package com.bcxin.api.interfaces.tenants.responses;
import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;

@Getter
public class MyImDepartGetResponse implements Serializable {
    private final String id;
    private final String name;
    private final String parentId;
    private final int displayOrder;
    private final int assign;
    private final Collection<MyImDepartGetResponse> children;

    public MyImDepartGetResponse(String id, String name, String parentId, int displayOrder, int assign, Collection<MyImDepartGetResponse> children) {
        this.id = id;
        this.name = name;
        this.parentId = parentId;
        this.displayOrder = displayOrder;
        this.assign = assign;
        this.children = children;
    }

    public static MyImDepartGetResponse create(String id, String name,
                                               String parentId, int displayOrder, int assign,
                                               Collection<MyImDepartGetResponse> children) {
        return new MyImDepartGetResponse(id, name, parentId, displayOrder, assign, children);
    }

}
