package com.bcxin.api.interfaces.tenants.responses;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.utils.CdnUtils;
import lombok.Getter;

import java.io.Serializable;

@Getter
public class MyImContactGetResponse implements Serializable {
    private final String id;
    private final String empId;
    private final String name;
    private final String headPhoto;
    private final String telephone;
    private final String imIdentity;
    private final Sex sex;

    public String getSexText() {
        switch (sex) {
            case Male:
                return "男";
            case Female:
                return "女";
            case Other:
                return "其他";
            default:
                return "未知";
        }
    }

    public MyImContactGetResponse(String id, String empId, String name, Sex sex, String headPhoto, String telephone, String imIdentity) {
        this.id = id;
        this.empId = empId;
        this.name = name;
        this.headPhoto = CdnUtils.convert(headPhoto);
        this.telephone = telephone;
        this.imIdentity = imIdentity;
        this.sex = sex;
    }

    public static MyImContactGetResponse create(String id, String empId, String name, Sex sex, String headPhoto, String telephone, String imIdentity) {
        return new MyImContactGetResponse(id, empId, name, sex, headPhoto, telephone, imIdentity);
    }
}
