package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

import java.util.Date;

@Getter
public class InviteUserGetResponse extends ResponseAbstract {

    private final String id;
    private final String name;
    private final Date hiredDate;
    private final OccupationType occupationType;
    private final CredentialType credentialType;
    private final String credentialNumber;

    public InviteUserGetResponse(String id,
                         String name,
                         Date hiredDate,
                         OccupationType occupationType,
                         CredentialType credentialType,
                         String credentialNumber){

        this.id = id;
        this.name = name;
        this.hiredDate = hiredDate;
        this.occupationType = occupationType;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
    }

    public static InviteUserGetResponse create(String id, String name, Date hiredDate, OccupationType occupationType, CredentialType credentialType, String credentialNumber) {
        return new InviteUserGetResponse(id,name,hiredDate,occupationType,credentialType,credentialNumber);
    }
}
