package com.bcxin.api.interfaces.identities.requests;

import com.bcxin.Infrastructures.utils.DES3;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.net.URLDecoder;
import java.net.URLEncoder;

@Data
public class SsoLoginRequest extends PasswordRequestAbstract {

    private String userName;

    private String userinfo;

    private String dnname;

    private String city;

    private String code;

    private String ipAddress;

    public void setUserNameForSSO(){
        try {
            if(!StringUtils.isEmpty(this.userName)) {
                return;
            }
            if(!StringUtils.isEmpty(this.userinfo)) {
                String userinfo = DES3.des3DecodeCBC(this.userinfo);
                if (!StringUtils.isEmpty(userinfo)) {
                    //解密后
                    String[] userArray = userinfo.split(",");
                    //获取用户名
                    this.userName = userArray[0];
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public void setUserNameForCA(){
        try {
            if(!StringUtils.isEmpty(this.userName)) {
                return;
            }
            //北京CA认证
            if(!StringUtils.isEmpty(this.dnname)) {
                String name = new String(this.dnname.getBytes("ISO8859-1"),"UTF-8");
                for (String data : name.split(",")) {
                    String[]datas = data.split("=");
                    if("CN".equals(datas[0].trim())){
                        String userInfo = datas[1].trim();
                        //获取身份证号
                        this.userName = userInfo.split(" ")[1];
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
