package com.bcxin.api.interfaces.identities;

import com.bcxin.api.interfaces.identities.requests.*;
import com.bcxin.api.interfaces.identities.responses.PrepareResetPasswordResponse;
import com.bcxin.api.interfaces.identities.responses.ThirdPartyCommonTokenResponse;
import com.bcxin.api.interfaces.identities.responses.SignInResponse;
import com.bcxin.api.interfaces.identities.responses.ToCWechatCgiBinSignInResponse;
import com.bcxin.api.interfaces.tenants.requests.employees.ResetPassWordRequest;
import org.springframework.stereotype.Component;

@Component
public interface IdentityRpcProvider {
    SignInResponse signIn(SignInRequest request);

    void signUp(SignUpRequest request);

    String getByName();

    void changePassword(ChangePasswordRequest request);

    void resetPassword(ResetPassWordRequest request);

    SignInResponse signIn(WeChatSignInRequest request);

    void change(ChangeBasicIdentityRequest request);

    void bindWechat(BindWechatRequest request);

    void unbindWechat(String id);

    /**
     * description：判断是否绑定微信unionid
     * author：linchunpeng
     * date：2023/10/12
     */
    boolean isBindUnionId(String id);

    PrepareResetPasswordResponse prepareResetPassword(PrepareResetPasswordRequest request);

    void restPassword(ResetPasswordRequest request);

    void sendCode(SmsRequest request);

    boolean checkCode(SmsRequest request);

    SignInResponse ssoLogin(SsoLoginRequest request) throws Exception;

    SignInResponse ssoLoginByIdNum(String userName, String ipAddress) throws Exception;

    void prepareResetPasswordCheckCode(ResetPasswordRequest request);

    PrepareResetPasswordResponse prepareResetPasswordExist(PrepareResetPasswordRequest request);

    String unlock(UnlockRequest request);

    ToCWechatCgiBinSignInResponse wechatCgiBinSignIn(ToCWechatCgiBinSignInRequest request);

    void doAssignTocUser(TocUserAssignIdentityRequest request);

    ThirdPartyCommonTokenResponse getAccessToken(ThirdPartyCommonTokenRequest request);

    void changedUserName(ChangeUserNameRequest request);
}
