package com.bcxin.identity.domains.utils;

import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;
import java.security.*;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

public class PasswordUtils {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;
    // 公私钥是 Base64编码情况下解码
    public static byte[] encPub = Base64.decode("MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAESic24soUECzuSh2aYH0e+hQYh+/I01NmfjOnm5mwyUEYQvNCPTzn3BlNyufgMV+DWLUKV+2h0+PVel9jYTfG8Q==");
    public static byte[] encPriv = Base64.decode("MIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQg0dYU+I6IdiSe8bvWlsHuWfsjSn3XFZqOGWO3K1814O6gCgYIKoEcz1UBgi2hRANCAARKJzbiyhQQLO5KHZpgfR76FBiH78jTU2Z+M6ebmbDJQRhC80I9POfcGU3K5+AxX4NYtQpX7aHT49V6X2NhN8bx");
    public static Logger logger = LoggerFactory.getLogger(PasswordUtils.class);

    /**
     * 生成安全的密码，生成随机的16位salt并经过1024次 sha-1 hash
     */
    public static Map<String, String> entryptPassword(String plainPassword) {
        byte[] salt = Digests.generateSalt(SALT_SIZE);
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), salt, HASH_INTERATIONS);
        Map<String, String> map = new HashMap<>();
        map.put("hashPassword", Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
        map.put("salt", salt.toString());
        return map;
    }

    /**
     * 验证密码
     *
     * @param plainPassword 明文密码
     * @param password      密文密码
     * @return 验证成功返回true
     */
    public static boolean validatePassword(String plainPassword, String password) {
        byte[] salt = Encodes.decodeHex(password.substring(0, 16));
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), salt, HASH_INTERATIONS);
        return password.equals(Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
    }

    public static String initSign(String password) {
        try {
            KeyFactory keyFact = KeyFactory.getInstance("EC", new BouncyCastleProvider());
            Signature signature = Signature.getInstance("SM3withSm2", new BouncyCastleProvider());
            PrivateKey priv = keyFact.generatePrivate(new PKCS8EncodedKeySpec(encPriv));
            signature.initSign(priv);
            signature.update(password.getBytes(StandardCharsets.UTF_8));
            // 计算签名值
            byte[] signatureValue = signature.sign();
            return Hex.toHexString(signatureValue);
        } catch (Exception ex) {
            logger.error("国密签名错误：{}",ex.getMessage());
        }
        return "";
    }
    public static boolean initVerify(String password,String hexPass) {
        try {
            Signature signature = Signature.getInstance("SM3withSm2", new BouncyCastleProvider());
            signature.initVerify(getPublicKey());
            signature.update(password.getBytes(StandardCharsets.UTF_8));
            boolean res = signature.verify(Hex.decode(hexPass));

            return res;
        } catch (Exception ex) {
            logger.error("国密验证签名错误：{}", ex.getMessage());
        }
        return false;
    }

    private static volatile PublicKey _pub;
    private static PublicKey getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (_pub == null) {
            synchronized (PublicKey.class) {
                if (_pub == null) {
                    KeyFactory keyFact = KeyFactory.getInstance("EC", new BouncyCastleProvider());
                    _pub = keyFact.generatePublic(new X509EncodedKeySpec(encPub));
                }
            }
        }

        return _pub;
    }
}
