package com.bcxin.identity.domains.utils;

/**
 * 密码加密工具类
 * 用于生成SM2加密的密码密文，供SQL语句使用
 * 
 * @author system
 * @date 2025-01-XX
 */
public class PasswordEncryptUtil {

    /**
     * 生成密码密文
     * 
     * @param plainPassword 明文密码
     * @return 加密后的密文（十六进制字符串）
     */
    public static String encryptPassword(String plainPassword) {
        return PasswordUtils.initSign(plainPassword);
    }

    /**
     * 验证密文是否正确
     * 
     * @param plainPassword 明文密码
     * @param encryptedPassword 密文密码
     * @return 验证结果
     */
    public static boolean verifyPassword(String plainPassword, String encryptedPassword) {
        return PasswordUtils.initVerify(plainPassword, encryptedPassword);
    }

    /**
     * 主方法：生成指定明文的密文
     * 
     * @param args 命令行参数，第一个参数为明文密码（可选，默认为 "Abcd@22101123"）
     */
    public static void main(String[] args) {
        String plainPassword = args.length > 0 ? args[0] : "Abcd@22101123";
        
        System.out.println("========================================");
        System.out.println("密码加密工具");
        System.out.println("========================================");
        System.out.println("明文密码: " + plainPassword);
        
        String encryptedPassword = encryptPassword(plainPassword);
        
        if (encryptedPassword != null && !encryptedPassword.isEmpty()) {
            System.out.println("加密密文: " + encryptedPassword);
            System.out.println("密文长度: " + encryptedPassword.length() + " 字符");
            
            // 验证密文
            boolean isValid = verifyPassword(plainPassword, encryptedPassword);
            System.out.println("验证结果: " + (isValid ? "✓ 验证通过" : "✗ 验证失败"));
            
            System.out.println("\n========================================");
            System.out.println("SQL 语句:");
            System.out.println("========================================");
            System.out.println("SELECT");
            System.out.println("    '" + plainPassword + "' AS plain_password,");
            System.out.println("    '" + encryptedPassword + "' AS encrypted_password;");
            System.out.println("========================================");
        } else {
            System.err.println("错误: 加密失败，返回空字符串");
        }
    }
}

