package com.bcxin.identity.domains.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.identity.domains.entities.IdentityUserEntity;
import com.bcxin.identity.domains.entities.UserNamePasswordPrincipalEntity;
import com.bcxin.identity.domains.entities.WechatPrincipalEntity;
import com.bcxin.identity.domains.repositories.dtos.IdentityUserNamePasswordDTO;

import java.util.Collection;

public interface IdentityUserRepository extends EntityRepository<IdentityUserEntity,String> {
    IdentityUserNamePasswordDTO findOne(String userName);

    IdentityUserEntity getByUserName(String id, String userName);

    UserNamePasswordPrincipalEntity getUserNamePasswordPrincipalByUserName(String userName);

    WechatPrincipalEntity findByOpenId(String openId);

    IdentityUserEntity getDirectlyByUserName(String userName);

    IdentityUserEntity findIdentityUserByUnionId(String unionId);

    Collection<IdentityUserEntity> findByTenantUserId(String tenantUserId);

    IdentityUserEntity getByTenantUserId(String tenantUserId);
}
