package com.bcxin.identity.domains.components;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.buses.enums.MessageType;
import com.bcxin.api.interfaces.buses.requests.MessageRequest;
import com.bcxin.identity.domains.components.commands.ForgetPasswordActionExecuteCommand;
import com.bcxin.identity.domains.services.commandResult.PrepareResetPasswordCommandResult;
import com.bcxin.identity.domains.utils.JwtUtil;
import org.springframework.stereotype.Component;

import java.util.*;

@Component("SmsForgetPasswordExecutor")
public class SmsForgetPasswordExecutor implements ForgetPasswordExecutorImpl {
    private final MessageRpcProvider messageRpcProvider;

    public SmsForgetPasswordExecutor(MessageRpcProvider messageRpcProvider) {
        this.messageRpcProvider = messageRpcProvider;
    }

    /**
     * 发送验证码
     * @param command
     * @return
     */
    @Override
    public PrepareResetPasswordCommandResult execute(ForgetPasswordActionExecuteCommand command) {
        command.validate();
        Map<String, Object> huaWeiSmsContent = new HashMap<>();
        huaWeiSmsContent.put("smsCode", "B02");
        String code = verificationCode();
        List<String> sendParams = new ArrayList();
        sendParams.add(code);
        huaWeiSmsContent.put("params", JSON.toJSONString(sendParams));
        huaWeiSmsContent.put("mobile", command.getMobile());
        this.messageRpcProvider.dispatch(MessageRequest.create(MessageType.SMS, huaWeiSmsContent));

        Map<String, Object> map = new HashMap<>();
        map.put("GetPasswordType", "1");
        map.put("code", code);
        map.put("loginName", command.getLoginName());
        map.put("time", DateUtil.now());
        String json = JSON.toJSONString(map);

        // 生成jwt
        String jwt = JwtUtil.createJwt(json);

        return PrepareResetPasswordCommandResult.create(jwt, true, "200",command.getMobile());
    }

    //生成随验证码
    public static String verificationCode() {

        Random random = new Random();
        String result = "";
        for (int i = 0; i < 6; i++) {
            result += random.nextInt(10);
        }
        return result;
    }
}
