/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.rbac.domain.entities.ResourceEntity;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Table(name="rbac_categories")
@Entity
public class CategoryEntity
extends OpEntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Column(name="code", length=200, nullable=false)
    private String code;
    @Column(name="name", length=500, nullable=false)
    private String name;
    @Column(name="note", length=4000)
    private String note;
    @Column(name="created_time")
    private Timestamp createdTime = Timestamp.from(Instant.now());
    @OneToMany(mappedBy="category", cascade={CascadeType.ALL})
    private Collection<ResourceEntity> resources;

    public void change(String code, String name, String note) {
        this.setCode(code);
        this.setName(name);
        this.setNote(note);
    }

    public void assignResource(String id, String code, String name, String data, String dataType) {
        Collection<ResourceEntity> res = this.getResources();
        if (res == null) {
            res = new ArrayList<ResourceEntity>();
        }
        Optional<ResourceEntity> selectedRceOptional = res.stream().filter(ii -> ii.getId().equals(id)).findFirst();
        ResourceEntity selectedRce = null;
        if (selectedRceOptional.isPresent()) {
            selectedRce = selectedRceOptional.get();
        } else {
            selectedRce = ResourceEntity.create(this, id, code, name, data, dataType);
            res.add(selectedRce);
        }
        selectedRce.change(code, name, data, dataType);
        this.setResources(res);
    }

    protected CategoryEntity() {
    }

    public static CategoryEntity create(String id, String code, String name, String note) {
        CategoryEntity category = new CategoryEntity();
        category.setId(id);
        category.change(code, name, note);
        return category;
    }

    public static CategoryEntity create(String code, String name, String note) {
        return CategoryEntity.create(UUIDUtil.getShortUuid(), code, name, note);
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setCode(String code) {
        this.code = code;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setNote(String note) {
        this.note = note;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setResources(Collection<ResourceEntity> resources) {
        this.resources = resources;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getNote() {
        return this.note;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Collection<ResourceEntity> getResources() {
        return this.resources;
    }
}

