/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="rbac_custom_role")
@Entity
public class RbacCustomRoleEntity
extends EntityAbstract
implements IAggregate {
    @Id
    private Long id;
    @Column(name="organization_id")
    private String organizationId;
    @Column(name="role_name")
    private String roleName;
    @Column(name="role_type")
    private Integer roleType;
    @Column(name="remark")
    private String remark;
    @Column(name="seq")
    private Integer seq;
    @Column(name="status")
    private Integer status;
    @Column(name="create_time")
    private Date createTime;
    @Column(name="create_user_id")
    private String createUserId;
    @Column(name="update_time")
    private Date updateTime;
    @Column(name="update_user_id")
    private String updateUserId;

    public static RbacCustomRoleEntity create(Long id, String organizationId, String roleName, String remark, Integer seq, String createUserId) {
        RbacCustomRoleEntity role = new RbacCustomRoleEntity();
        role.setId(id);
        role.setOrganizationId(organizationId);
        role.setRoleName(roleName);
        role.setRoleType(2);
        role.setRemark(remark);
        role.setSeq(seq == null ? 0 : seq);
        role.setStatus(1);
        role.setCreateTime(new Date());
        role.setCreateUserId(createUserId);
        return role;
    }

    public static RbacCustomRoleEntity copy(Long id, RbacCustomRoleEntity source, Integer maxSeq, String createUserId) {
        RbacCustomRoleEntity role = new RbacCustomRoleEntity();
        role.setId(id);
        role.setOrganizationId(source.getOrganizationId());
        role.setRoleName(source.getRoleName().concat("\uff08\u590d\u5236\uff09"));
        role.setRoleType(2);
        role.setRemark(source.getRemark());
        role.setSeq(maxSeq + 1);
        role.setStatus(1);
        role.setCreateTime(new Date());
        role.setCreateUserId(createUserId);
        return role;
    }

    public void update(String roleName, String remark, Integer seq, String updateUserId) {
        this.setRoleName(roleName);
        this.setRemark(remark);
        this.setSeq(seq == null ? 0 : seq);
        this.setUpdateTime(new Date());
        this.setUpdateUserId(updateUserId);
    }

    public Long getId() {
        return this.id;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public Integer getRoleType() {
        return this.roleType;
    }

    public String getRemark() {
        return this.remark;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreateUserId() {
        return this.createUserId;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String getUpdateUserId() {
        return this.updateUserId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public void setRoleType(Integer roleType) {
        this.roleType = roleType;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbacCustomRoleEntity)) {
            return false;
        }
        RbacCustomRoleEntity other = (RbacCustomRoleEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$roleType = this.getRoleType();
        Integer other$roleType = other.getRoleType();
        if (this$roleType == null ? other$roleType != null : !((Object)this$roleType).equals(other$roleType)) {
            return false;
        }
        Integer this$seq = this.getSeq();
        Integer other$seq = other.getSeq();
        if (this$seq == null ? other$seq != null : !((Object)this$seq).equals(other$seq)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$roleName = this.getRoleName();
        String other$roleName = other.getRoleName();
        if (this$roleName == null ? other$roleName != null : !this$roleName.equals(other$roleName)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$createUserId = this.getCreateUserId();
        String other$createUserId = other.getCreateUserId();
        if (this$createUserId == null ? other$createUserId != null : !this$createUserId.equals(other$createUserId)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$updateUserId = this.getUpdateUserId();
        String other$updateUserId = other.getUpdateUserId();
        return !(this$updateUserId == null ? other$updateUserId != null : !this$updateUserId.equals(other$updateUserId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RbacCustomRoleEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $roleType = this.getRoleType();
        result = result * 59 + ($roleType == null ? 43 : ((Object)$roleType).hashCode());
        Integer $seq = this.getSeq();
        result = result * 59 + ($seq == null ? 43 : ((Object)$seq).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $roleName = this.getRoleName();
        result = result * 59 + ($roleName == null ? 43 : $roleName.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $createUserId = this.getCreateUserId();
        result = result * 59 + ($createUserId == null ? 43 : $createUserId.hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $updateUserId = this.getUpdateUserId();
        result = result * 59 + ($updateUserId == null ? 43 : $updateUserId.hashCode());
        return result;
    }

    public String toString() {
        return "RbacCustomRoleEntity(id=" + this.getId() + ", organizationId=" + this.getOrganizationId() + ", roleName=" + this.getRoleName() + ", roleType=" + this.getRoleType() + ", remark=" + this.getRemark() + ", seq=" + this.getSeq() + ", status=" + this.getStatus() + ", createTime=" + this.getCreateTime() + ", createUserId=" + this.getCreateUserId() + ", updateTime=" + this.getUpdateTime() + ", updateUserId=" + this.getUpdateUserId() + ")";
    }
}

