/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bcxin.autodownloadupload.common.utils.DatabaseUtil;
import com.bcxin.autodownloadupload.common.utils.FileUtils;
import com.bcxin.autodownloadupload.common.utils.HttpUtil;
import com.bcxin.autodownloadupload.configs.PullConfig;
import com.bcxin.autodownloadupload.configs.PushConfig;
import com.bcxin.autodownloadupload.dtos.ChangeLogsRequestDto;
import com.bcxin.autodownloadupload.dtos.FerryTaskPullResult;
import com.bcxin.autodownloadupload.entity.FileDownloadLog;
import com.bcxin.autodownloadupload.entity.PullRecord;
import com.bcxin.autodownloadupload.service.FileDownloadLogService;
import com.bcxin.autodownloadupload.service.PullDataService;
import com.bcxin.autodownloadupload.service.PullRecordService;
import com.bcxin.autodownloadupload.service.RetryableService;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class PullDataServiceImpl
implements PullDataService {
    private static final Logger log = LoggerFactory.getLogger(PullDataServiceImpl.class);
    @Autowired
    private PullConfig pullConfig;
    @Autowired
    private PushConfig pushConfig;
    @Autowired
    private RetryableService retryableService;
    @Autowired
    private FileDownloadLogService fileDownloadLogService;
    @Autowired
    private PullRecordService pullRecordService;
    @Value(value="${spring.profiles.active}")
    private String activeFile;
    @Resource(name="taskExecutor")
    private TaskExecutor taskExecutor;
    private static final String DOWNLOAD_PULL_ZIP_URL = "/download/%s";

    public ChangeLogsRequestDto pullDataAsync(ChangeLogsRequestDto requestDto, int pullType) {
        return this.pullData(requestDto, pullType);
    }

    public ChangeLogsRequestDto pullData(ChangeLogsRequestDto requestDto, int pullType) {
        log.info("===================================\u62c9\u53d6\u6570\u636e===================================");
        if (requestDto != null && StringUtils.isNotBlank((CharSequence)this.pullConfig.getApi())) {
            String regionCodes = requestDto.getRegionCodes();
            log.info("===================================regionCodes\uff1a{}===================================", (Object)regionCodes);
            for (String regionCode : regionCodes.split(",")) {
                try {
                    log.info("==================================={}===================================", (Object)regionCode);
                    requestDto.setRegionCode(regionCode);
                    if (requestDto.getAutoFerryTaskId() != null) {
                        pullType = 2;
                    }
                    PullRecord record = this.pullRecordService.createRecord(requestDto.getAutoFerryTaskId(), this.pullConfig, requestDto, pullType, regionCode);
                    int errorCount = 1;
                    String requestId = "";
                    String endTime = "";
                    String pullResultZipSavePath = "";
                    while (StringUtils.isBlank((CharSequence)pullResultZipSavePath) && errorCount <= 5) {
                        String pullResult = this.getChangeLogPullResult(requestDto, regionCode);
                        if (StringUtils.isNotBlank((CharSequence)pullResult)) {
                            endTime = this.getRequestItems(pullResult);
                            if (StringUtils.isNotBlank((CharSequence)endTime)) {
                                requestDto.setEndTime(new java.util.Date(Long.parseLong(endTime)));
                                log.info("\u8bf7\u6c42\u62c9\u53d6\u6570\u636e\u7684\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u503c\uff1a{}\uff0c\u8bf7\u6c42endTime\uff1a{}", (Object)pullResult, (Object)endTime);
                                break;
                            }
                            requestId = this.getRequestId(pullResult);
                            log.info("\u8bf7\u6c42\u62c9\u53d6\u6570\u636e\u7684\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u503c\uff1a{}\uff0c\u8bf7\u6c42id\uff1a{}\uff0c\u8bf7\u6c42endTime\uff1a{}", new Object[]{pullResult, requestId, endTime});
                            log.info("===================================2\u3001\u8bf7\u6c42\u4e0b\u8f7dzip\u63a5\u53e3=======================================");
                            pullResultZipSavePath = this.retryableService.downloadPullResult(this.pullConfig.getApi().concat(String.format(DOWNLOAD_PULL_ZIP_URL, requestId)), this.pullConfig.getV5Path());
                            if (StringUtils.isNotBlank((CharSequence)pullResultZipSavePath)) {
                                log.info("\u62c9\u53d6\u670d\u52a1zip\u4e0b\u8f7d\u5b8c\u6210\uff0c\u5224\u65ad\u662f\u5426\u6709\u5b58\u5728\uff1av5\u90e8\u7f72\u8fc7\u7a0b\u4e2d\uff0c\u6570\u636e\u6e90\u4e3a\u7a7a\u7684\u60c5\u51b5\uff0c\u5982\u679c\u6709\uff0c\u5219\u91cd\u65b0\u8bf7\u6c42");
                                String errorId = this.pullRecordService.selectErrorSyncChangeLogs(requestId);
                                if (StringUtils.isNotBlank((CharSequence)errorId)) {
                                    log.info("\u62c9\u53d6\u670d\u52a1\u5b58\u5728v5\u90e8\u7f72\u8fc7\u7a0b\u4e2d\uff0c\u6570\u636e\u6e90\u4e3a\u7a7a\u7684\u60c5\u51b5\uff0crequestId\uff1a{}", (Object)errorId);
                                    log.info("\u8bf7\u6c42\u62c9\u53d6\u6570\u636e\uff0cv5\u5728\u90e8\u7f72\uff0c\u7b49\u5f853\u5206\u949f\u540e\u8fdb\u884c\u91cd\u8bd5\uff0c\u5f53\u524d\u91cd\u8bd5\u6b21\u6570\uff1a{}", (Object)errorCount);
                                    ++errorCount;
                                    pullResultZipSavePath = "";
                                    requestId = "";
                                    try {
                                        Thread.sleep(180000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                    continue;
                                }
                                log.info("\u62c9\u53d6\u670d\u52a1\u4e0d\u5b58\u5728v5\u90e8\u7f72\u8fc7\u7a0b\u4e2d\uff0c\u6570\u636e\u6e90\u4e3a\u7a7a\u7684\u60c5\u51b5\uff0c\u9000\u51fa\u5faa\u73af\uff0crequestId\uff1a{}", (Object)requestId);
                                break;
                            }
                            log.info("\u62c9\u53d6\u670d\u52a1\u65e0zip\u5305\u4e0b\u8f7d\uff0c\u9000\u51fa\u5faa\u73af");
                            break;
                        }
                        log.info("pullResult\u4e3a\u7a7a\uff0c\u9000\u51fa\u5faa\u73af");
                        break;
                    }
                    if (StringUtils.isNotBlank((CharSequence)endTime)) {
                        return requestDto;
                    }
                    if (StringUtils.isNotBlank((CharSequence)requestId)) {
                        record.setRequestId(requestId);
                    }
                    if (StringUtils.isNotBlank((CharSequence)pullResultZipSavePath)) {
                        log.info("===================================3\u3001\u89e3\u538bzip\uff0c\u5e76\u5f52\u7c7b\u5904\u7406sql\u6587\u4ef6\u3001txt\u6587\u4ef6=======================================");
                        String rootPath = this.unzip(pullResultZipSavePath, this.getCompletedPath(this.pullConfig.getCompletedPath(), regionCode), requestId);
                        log.info("===================================4\u3001\u626b\u63cftxt\u6587\u4ef6\uff0c\u5224\u65ad\u662f\u5426\u4e0b\u8f7d\u8fc7\uff0c\u6ca1\u4e0b\u8f7d\u8fc7\u5219\u8fdb\u884c\u4e0b\u8f7d=======================================");
                        this.downloadFiles(rootPath, requestDto.getIsRemoveRepeat().booleanValue(), record);
                        ZipUtil.zip((String)rootPath);
                        record.setCompleteZipPath(rootPath.concat(".zip"));
                        log.info("===================================zip\u538b\u7f29\u5b8c\u6210===================================");
                        if (requestDto.getAutoFerryTaskId() == null || "out-prod".equals(this.activeFile)) {
                            try {
                                FileUtil.del((String)rootPath);
                            }
                            catch (Exception e) {
                                log.info("\u5220\u9664\u62c9\u53d6\u6587\u4ef6\u5939\u51fa\u9519\uff0c\u8def\u5f84\uff1a{}", (Object)rootPath, (Object)e);
                            }
                            log.info("\u5220\u9664\u6587\u4ef6\u5939\uff1a{}", (Object)rootPath);
                        }
                    } else {
                        record.setPullErrorInfo("\u62c9\u53d6\u670d\u52a1\u65e0zip\u5305\u4e0b\u8f7d");
                    }
                    record.setUpdateTime(new java.util.Date());
                    this.pullRecordService.updateById((Object)record);
                }
                catch (Exception e) {
                    log.error("\u62c9\u53d6{}\u6570\u636e\u51fa\u9519\uff0c{}\uff0c{}", new Object[]{regionCode, e.getMessage(), e});
                }
            }
        }
        log.info("===================================\u62c9\u53d6\u6570\u636e\u7ed3\u675f===================================");
        return null;
    }

    private String getChangeLogPullResult(ChangeLogsRequestDto requestDto, String regionCode) {
        log.info("===================================1\u3001\u8bf7\u6c42\u62c9\u53d6\u63a5\u53e3\uff0c\u5730\u533a\uff1a{}\uff0c\u751f\u6210sql\u6587\u4ef6\u548ctxt\u6587\u4ef6=======================================", (Object)regionCode);
        String pullResult = HttpUtil.post((String)this.pullConfig.getApi(), (String)JSONObject.toJSONString((Object)requestDto));
        for (int retryCount = 1; "fail".equals(pullResult) && retryCount <= 10; ++retryCount) {
            log.info("\u8bf7\u6c42\u62c9\u53d6\u6570\u636e\u7684\u63a5\u53e3\u5931\u8d25\uff0c\u7b49\u5f853\u5206\u949f\u8fdb\u884c\u91cd\u8bd5\uff0c\u5f53\u524d\u91cd\u8bd5\u6b21\u6570\uff1a{}", (Object)retryCount);
            try {
                Thread.sleep(180000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            pullResult = HttpUtil.post((String)this.pullConfig.getApi(), (String)JSONObject.toJSONString((Object)requestDto));
        }
        return pullResult;
    }

    private String getCompletedPath(String completePath, String regionCode) {
        return completePath.concat(File.separator).concat(regionCode);
    }

    private String getRequestId(String pullResult) {
        String realPath = JSONObject.parseObject((String)pullResult).getString("realPath");
        return realPath.substring(realPath.indexOf("_cdc/") + 5, realPath.indexOf("/cdc_"));
    }

    private String getRequestItems(String pullResult) {
        JSONObject requestObj;
        JSONObject itemsObj;
        JSONObject resultObj;
        if (StringUtils.isBlank((CharSequence)pullResult)) {
            return null;
        }
        try {
            resultObj = JSONObject.parseObject((String)pullResult);
        }
        catch (Exception e) {
            log.info("pullResult\u8f6c\u6362json\u51fa\u9519\uff0cpullResult\uff1a{}", (Object)pullResult);
            return null;
        }
        String items = resultObj.getString("items");
        if (StringUtils.isBlank((CharSequence)items)) {
            return null;
        }
        try {
            itemsObj = JSONObject.parseObject((String)items);
        }
        catch (Exception e) {
            log.info("items\u8f6c\u6362json\u51fa\u9519\uff0citems\uff1a{}", (Object)items);
            return null;
        }
        String request = itemsObj.getString("request");
        if (StringUtils.isBlank((CharSequence)request)) {
            return null;
        }
        try {
            requestObj = JSONObject.parseObject((String)request);
        }
        catch (Exception e) {
            log.info("request\u8f6c\u6362json\u51fa\u9519\uff0crequest\uff1a{}", (Object)request);
            return null;
        }
        return requestObj.getString("endTime");
    }

    private String unzip(String pullResultZipSavePath, String completedPath, String requestId) {
        File unzipDir = ZipUtil.unzip((String)pullResultZipSavePath);
        log.info("\u89e3\u538b\u540e\u8def\u5f84\u4e3a\uff1a{}", (Object)unzipDir.getPath());
        String rootPath = completedPath.concat(File.separator).concat(requestId);
        String sqlPath = rootPath.concat(File.separator).concat("sql");
        String filesPath = rootPath.concat(File.separator).concat("files");
        String uploadsPath = filesPath.concat(File.separator).concat("uploads");
        FileUtil.mkdir((String)rootPath);
        FileUtil.mkdir((String)sqlPath);
        FileUtil.mkdir((String)filesPath);
        FileUtil.mkdir((String)uploadsPath);
        List fileList = FileUtil.loopFiles((File)unzipDir);
        if (fileList.size() > 0) {
            for (File file : fileList) {
                String suffix;
                switch (suffix = FileUtil.getSuffix((File)file).toUpperCase(Locale.ROOT)) {
                    case "SQL": {
                        log.info("\u590d\u5236\u6587\u4ef6\uff1a{}\uff0c\u5230sql\u76ee\u5f55", (Object)file.getPath());
                        FileUtil.copy((File)file, (File)new File(sqlPath.concat(File.separator).concat(FileUtil.getName((File)file))), (boolean)true);
                        break;
                    }
                    case "TXT": {
                        log.info("\u590d\u5236\u6587\u4ef6\uff1a{}\uff0c\u5230files\u76ee\u5f55", (Object)file.getPath());
                        FileUtil.copy((File)file, (File)new File(filesPath.concat(File.separator).concat(FileUtil.getName((File)file))), (boolean)true);
                    }
                }
            }
        }
        log.info("\u590d\u5236\u7ed3\u675f");
        log.info("\u5220\u9664\u6587\u4ef6\uff1a{}", (Object)pullResultZipSavePath);
        FileUtil.del((String)pullResultZipSavePath);
        log.info("\u5220\u9664\u6587\u4ef6\u5939\uff1a{}", (Object)unzipDir.getPath());
        FileUtil.del((File)unzipDir);
        return rootPath;
    }

    private void downloadFiles(String rootPath, boolean isRemoveRepeat, PullRecord record) {
        java.util.Date now = new java.util.Date();
        String serverUrl = this.pushConfig.getInternet().getServerUrl();
        String filesPath = rootPath.concat(File.separator).concat("files");
        String downloadFile = filesPath.concat(File.separator).concat("pull-download.txt");
        String resultFile = filesPath.concat(File.separator).concat("pull-result.txt");
        String errorFile = filesPath.concat(File.separator).concat("pull-error.txt");
        log.info("txt\u6587\u4ef6\u5939\u8def\u5f84\uff1a{}", (Object)filesPath);
        log.info("\u4e0b\u8f7d\u6210\u529f\u4fe1\u606f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)resultFile);
        log.info("\u4e0b\u8f7d\u9519\u8bef\u4fe1\u606f\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)errorFile);
        List txtFileList = FileUtil.loopFiles((File)new File(filesPath), (int)1, (FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (CollectionUtils.isNotEmpty((Collection)txtFileList)) {
            ArrayList saveFileLogList = new ArrayList();
            HashSet md5Set = new HashSet();
            for (File txtFile : txtFileList) {
                this.readTxtFiles(isRemoveRepeat, now, saveFileLogList, md5Set, txtFile, resultFile, serverUrl, record);
            }
            log.info("\u603b\u7684\u9700\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u6570\u91cf\uff1a{}", (Object)saveFileLogList.size());
            AtomicInteger successAtomicCount = new AtomicInteger(0);
            if (CollectionUtils.isNotEmpty(saveFileLogList)) {
                ArrayList executeList = new ArrayList();
                List saveListList = ListUtil.partition(saveFileLogList, (int)1000);
                CountDownLatch countDownLatch = new CountDownLatch(saveListList.size());
                saveListList.forEach(logList -> this.taskExecutor.execute(() -> {
                    log.info("\u5f00\u59cb\u6267\u884c\u5f53\u524d\u5206\u7247\u4e0b\u8f7d\u6587\u4ef6\u7ebf\u7a0b");
                    for (FileDownloadLog fileDownloadLog : logList) {
                        try {
                            boolean isSuccess = true;
                            if (!FileUtils.downloadFile((String)fileDownloadLog.getFileUrl(), (String)filesPath, (String)serverUrl, (String)this.pullConfig.getObsUrl())) {
                                if (StringUtils.isNotBlank((CharSequence)this.pullConfig.getObsUrl()) && fileDownloadLog.getFileUrl().contains(this.pullConfig.getObsUrl())) {
                                    fileDownloadLog.setFileUrl(fileDownloadLog.getFileUrl().replace(this.pullConfig.getObsUrl(), "https://bcxin-saas-prod.obs.cn-north-1.myhuaweicloud.com"));
                                    if (!FileUtils.downloadFile((String)fileDownloadLog.getFileUrl(), (String)filesPath, (String)serverUrl, (String)this.pullConfig.getObsUrl())) {
                                        isSuccess = false;
                                    }
                                } else {
                                    isSuccess = false;
                                }
                            }
                            if (isSuccess) {
                                if (isRemoveRepeat) {
                                    executeList.add(fileDownloadLog);
                                }
                                successAtomicCount.incrementAndGet();
                                continue;
                            }
                            FileUtil.appendUtf8Lines(Collections.singletonList(fileDownloadLog.getFileUrl()), (String)errorFile);
                        }
                        catch (Exception e) {
                            log.error("\u5355\u4e2a\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0curl\uff1a{}\uff0c{}", new Object[]{fileDownloadLog.getFileUrl(), e.getMessage(), e});
                        }
                    }
                    countDownLatch.countDown();
                    log.info("\u5f53\u524d\u5206\u7247\u4e0b\u8f7d\u6587\u4ef6\u5b8c\u6210");
                }));
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.fileDownloadLogService.saveBatch(executeList, 1000);
                FileUtil.appendUtf8Lines(Collections.singletonList(String.format("\u672c\u6b21\u62c9\u53d6\u603b\u7684\u9700\u8981\u4e0b\u8f7d\u6587\u4ef6\u6570\u91cf\uff1a%s\uff0c\u4e0b\u8f7d\u6210\u529f\u6570\u91cf\uff1a%s", saveFileLogList.size(), successAtomicCount.get())), (String)resultFile);
                FileUtil.appendUtf8Lines((Collection)saveFileLogList.stream().map(FileDownloadLog::getFileUrl).collect(Collectors.toList()), (String)downloadFile);
                if (FileUtil.exist((String)resultFile)) {
                    record.setPullResultInfo(FileUtil.readUtf8String((String)resultFile));
                }
                if (FileUtil.exist((String)errorFile)) {
                    record.setPullErrorInfo(FileUtil.readUtf8String((String)errorFile));
                }
            }
        } else {
            log.info("\u6ca1\u6709\u9700\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTxtFiles(boolean isRemoveRepeat, java.util.Date now, List<FileDownloadLog> saveFileLogList, Set<String> md5Set, File txtFile, String resultFile, String serverUrl, PullRecord record) {
        log.info("\u5f00\u59cb\u8bfb\u53d6txt\u6587\u4ef6\uff1a{}", (Object)txtFile.getPath());
        LineIterator lineIterator = null;
        try {
            boolean isAutoFerry = record.getPullType() == 2;
            java.util.Date lastCheckTime = null;
            if (!isAutoFerry) {
                log.info("\u4e0d\u662f\u81ea\u52a8\u6446\u6e21\uff0c\u9700\u8981\u517c\u5bb9\u5df2\u4e0b\u8f7d\u9644\u4ef6\u4e0b\u8f7d");
                String week = com.bcxin.autodownloadupload.common.utils.DateUtil.getWeekEngStrOfDate((java.util.Date)now);
                log.info("week\uff1a{}", (Object)week);
                if ("monday".equals(week)) {
                    log.info("\u5468\u4e00\u5224\u65ad\u91cd\u590d2\u592920\u5c0f\u65f6");
                    lastCheckTime = com.bcxin.autodownloadupload.common.utils.DateUtil.getBeforeNumDayTime((java.util.Date)now, (int)3, (int)4);
                } else {
                    log.info("\u5468\u4e8c\u5230\u5468\u4e94\uff0c\u5224\u65ad\u91cd\u590d20\u4e2a\u5c0f\u65f6");
                    lastCheckTime = com.bcxin.autodownloadupload.common.utils.DateUtil.getBeforeNumDayTime((java.util.Date)now, (int)1, (int)4);
                }
                log.info("lastCheckTime\uff1a{}", (Object)DateUtil.formatDateTime((java.util.Date)lastCheckTime));
            } else {
                log.info("\u81ea\u52a8\u6446\u6e21\uff0c\u9700\u8981\u517c\u5bb9\u5df2\u4e0b\u8f7d\u9644\u4ef6\u4f46\u672a\u751f\u6210\u5305\u7684\u8bb0\u5f55");
                PullRecord lastSameTimeRecord = this.pullRecordService.getLastSameTimeRecord(record.getRegionCode(), record.getStartTime(), record.getId());
                if (lastSameTimeRecord != null) {
                    lastCheckTime = lastSameTimeRecord.getCreateTime();
                    log.info("lastCheckTime\uff1a{}", (Object)DateUtil.formatDateTime((java.util.Date)lastCheckTime));
                }
            }
            lineIterator = org.apache.commons.io.FileUtils.lineIterator((File)txtFile, (String)"UTF-8");
            int count = 0;
            int needDownload = 0;
            ArrayList<FileDownloadLog> fileLogList = new ArrayList<FileDownloadLog>();
            ArrayList<String> md5List = new ArrayList<String>();
            while (lineIterator.hasNext()) {
                List<Object> addLogList;
                List dbLog;
                String url = lineIterator.nextLine();
                if (url.startsWith("/upload")) {
                    if (serverUrl.contains("v5qy.baibaodun.cn")) {
                        if (url.startsWith("/uploads")) {
                            url = url.substring(8);
                        }
                        url = this.pullConfig.getObsUrl().concat(url);
                    } else {
                        url = serverUrl.concat(url);
                    }
                }
                if (!url.startsWith("http")) continue;
                if (url.startsWith("https:/") && !url.startsWith("https://")) {
                    url = url.replace("https:/", "https://");
                }
                if (url.startsWith("http:/") && !url.startsWith("http://")) {
                    url = url.replace("http:/", "http://");
                }
                url = url.replace("%2F", "/");
                String md5 = MD5.create().digestHex(url, "UTF-8");
                FileDownloadLog fileDownloadLog = new FileDownloadLog();
                fileDownloadLog.setFileUrl(url);
                fileDownloadLog.setMd5(md5);
                fileDownloadLog.setCreateTime(now);
                fileDownloadLog.setRequestId(record.getRequestId());
                fileDownloadLog.setRegionCode(record.getRegionCode());
                fileLogList.add(fileDownloadLog);
                md5List.add(md5);
                if (!isRemoveRepeat || ++count % 1000 != 0) continue;
                log.info("\u6bcf1000\u6761\u8fdb\u884c\u4e00\u6b21\u9a8c\u8bc1md5\u5b58\u4e0d\u5b58\u5728");
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"md5", md5List);
                if (lastCheckTime != null) {
                    queryWrapper.le((Object)"createTime", (Object)lastCheckTime);
                }
                if (CollectionUtils.isNotEmpty((Collection)(dbLog = this.fileDownloadLogService.list((Wrapper)queryWrapper)))) {
                    List existMd5List = dbLog.stream().map(FileDownloadLog::getMd5).collect(Collectors.toList());
                    addLogList = fileLogList.stream().filter(fileLog -> !existMd5List.contains(fileLog.getMd5())).collect(Collectors.toList());
                } else {
                    addLogList = new ArrayList(fileLogList);
                }
                if (CollectionUtils.isNotEmpty(addLogList)) {
                    for (FileDownloadLog downloadLog : addLogList) {
                        if (!md5Set.add(downloadLog.getMd5())) continue;
                        saveFileLogList.add(downloadLog);
                    }
                }
                needDownload += addLogList.size();
                log.info("\u8fd91000\u6761\u9700\u8981\u4e0b\u8f7d{}\u6761", (Object)addLogList.size());
                fileLogList.clear();
                md5List.clear();
            }
            if (isRemoveRepeat) {
                if (fileLogList.size() > 0) {
                    List<Object> addLogList;
                    List dbLog;
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.in((Object)"md5", md5List);
                    if (lastCheckTime != null) {
                        queryWrapper.le((Object)"createTime", (Object)lastCheckTime);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(dbLog = this.fileDownloadLogService.list((Wrapper)queryWrapper)))) {
                        List existMd5List = dbLog.stream().map(FileDownloadLog::getMd5).collect(Collectors.toList());
                        addLogList = fileLogList.stream().filter(fileLog -> !existMd5List.contains(fileLog.getMd5())).collect(Collectors.toList());
                    } else {
                        addLogList = new ArrayList(fileLogList);
                    }
                    if (CollectionUtils.isNotEmpty(addLogList)) {
                        for (FileDownloadLog downloadLog : addLogList) {
                            if (!md5Set.add(downloadLog.getMd5())) continue;
                            saveFileLogList.add(downloadLog);
                        }
                    }
                    needDownload += addLogList.size();
                }
            } else {
                if (CollectionUtils.isNotEmpty(fileLogList)) {
                    for (FileDownloadLog downloadLog : fileLogList) {
                        if (!md5Set.add(downloadLog.getMd5())) continue;
                        saveFileLogList.add(downloadLog);
                    }
                }
                needDownload = fileLogList.size();
            }
            FileUtil.appendUtf8Lines(Collections.singletonList(FileUtil.getName((File)txtFile) + "\uff0c\u9700\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u6570\u91cf:" + needDownload), (String)resultFile);
            IOUtils.closeQuietly((Closeable)lineIterator);
        }
        catch (Exception e) {
            e.printStackTrace();
            String eMessage = e.getMessage();
            log.error("\u8bfb\u53d6txt\u6587\u4ef6\uff1a{}\uff0c\u5f02\u5e38\uff0c{}", new Object[]{txtFile.getName(), eMessage, e});
        }
        finally {
            IOUtils.closeQuietly(lineIterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oldDataProcessor(Long begin, Long end) {
        try {
            log.info("=======================================\u65e7\u6570\u636e\u8fc1\u79fb=======================================");
            log.info("\u6570\u636e\u8303\u56f4\uff1a{} \u5230 {}", (Object)begin, (Object)end);
            long beginTime = System.currentTimeMillis();
            Connection connection = DatabaseUtil.getConnection((String)this.pullConfig.getDatasource().getUrl(), (String)this.pullConfig.getDatasource().getUsername(), (String)this.pullConfig.getDatasource().getPassword());
            log.info("\u83b7\u53d6\u65e7\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f\uff0c\u5f00\u59cb\u8fc1\u79fb");
            ResultSet rs = null;
            Statement psmnt = null;
            try {
                end = end + 100000L;
                for (long limit = begin + 100000L; limit <= end; limit += 100000L) {
                    long bt = System.currentTimeMillis();
                    long start = limit - 100000L;
                    log.info("\u67e5\u8be2id >= {} and < {} \u7684\u6570\u636e", (Object)start, (Object)limit);
                    StringBuilder sql = new StringBuilder("select fileUrl, createTime from file_download_log_ex where id >= ");
                    sql.append(start).append(" and id < ").append(limit);
                    psmnt = connection.prepareStatement(sql.toString());
                    rs = psmnt.executeQuery();
                    ArrayList<FileDownloadLog> logList = new ArrayList<FileDownloadLog>();
                    log.info("\u67e5\u8be2\u6210\u529f");
                    while (rs.next()) {
                        String fileUrl = rs.getString(1);
                        Date createTime = rs.getDate(2);
                        String md5 = MD5.create().digestHex(fileUrl, "UTF-8");
                        FileDownloadLog fileLog = new FileDownloadLog();
                        fileLog.setFileUrl(fileUrl);
                        fileLog.setMd5(md5);
                        fileLog.setCreateTime((java.util.Date)createTime);
                        logList.add(fileLog);
                    }
                    log.info("\u8f6c\u5bf9\u8c61\u6210\u529f\uff0c\u5f00\u59cb\u6267\u884c\u5bfc\u5165\u6570\u636e\u5e93");
                    if (logList.size() > 0) {
                        if (this.fileDownloadLogService.saveBatch(logList, 1000)) {
                            log.info("\u65e7\u6570\u636e\u6279\u91cf\u63d2\u5165\u65b0\u6570\u636e\u5e93\u6210\u529f\uff0cstart\uff1a{}\uff0climit\uff1a{}\uff0c\u6761\u6570\uff1a{}", new Object[]{start, limit, logList.size()});
                        } else {
                            log.info("\u65e7\u6570\u636e\u6279\u91cf\u63d2\u5165\u65b0\u6570\u636e\u5e93\u5931\u8d25\uff0cstart\uff1a{}\uff0climit\uff1a{}\uff0c\u6761\u6570\uff1a{}", new Object[]{start, limit, logList.size()});
                        }
                    }
                    long et = System.currentTimeMillis();
                    log.info("id >= {} and < {} \u7684\u6570\u636e\u8fc1\u79fb\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}ms", new Object[]{start, limit, et - bt});
                }
            }
            catch (Exception e) {
                log.error("\u65e7\u6570\u636e\u8fc1\u79fb\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (psmnt != null) {
                        psmnt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    log.error("\u65e7\u6570\u636e\u8fc1\u79fb\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                }
            }
            long endTime = System.currentTimeMillis();
            log.info("=======================================\u8fc1\u79fb\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}=======================================", (Object)(endTime - beginTime));
        }
        catch (Exception e) {
            log.error("\u65e7\u6570\u636e\u8fc1\u79fb\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public FerryTaskPullResult queryAutoFerryPullResult(Long id) {
        log.info("===================================\u67e5\u8be2\u81ea\u52a8\u6446\u6e21\u62c9\u53d6\u7ed3\u679c\uff0c\u67e5\u8be2id\uff1a{}=======================================", (Object)id);
        FerryTaskPullResult ferryTaskPullResult = new FerryTaskPullResult();
        if (id != null) {
            ferryTaskPullResult.setId(id);
            PullRecord record = (PullRecord)this.pullRecordService.getById((Serializable)id);
            if (record != null && StringUtils.isNotBlank((CharSequence)record.getRequestId()) && (StringUtils.isNotBlank((CharSequence)record.getCompleteZipPath()) || StringUtils.isNotBlank((CharSequence)record.getPullErrorInfo()))) {
                ferryTaskPullResult.setRequestId(record.getRequestId());
                if (StringUtils.isNotBlank((CharSequence)record.getCompleteZipPath())) {
                    ferryTaskPullResult.setPackageUrl(this.getCompletedPath(this.pullConfig.getCompletedPath(), record.getRegionCode()));
                    ferryTaskPullResult.setPullResult("\u62c9\u53d6\u6570\u636e-\u4e0b\u8f7d\u5b8c\u6210");
                    ferryTaskPullResult.setTaskStatus(Integer.valueOf(2));
                } else {
                    ferryTaskPullResult.setPullResult("\u62c9\u53d6\u670d\u52a1\u65e0zip\u5305\u4e0b\u8f7d");
                    ferryTaskPullResult.setTaskStatus(Integer.valueOf(9));
                }
            } else {
                ferryTaskPullResult.setPullResult("\u8fd8\u672a\u62c9\u53d6\u5b8c\u6210");
            }
        }
        return ferryTaskPullResult;
    }
}

