package com.bcxin.autodownloadupload.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Data
@Component
@ConfigurationProperties(prefix = "push-config")
public class PushConfig {

    //zip文件所在目录
    private String filePath;

    //系统环境
    private String envir;

    //用命令行执行脚本的数据库配置
    private String dbIp;
    private String dbPort;
    private String dbUsername;
    private String dbPassword;

    //内外网配置
    private Internet internet;

    //内外网配置
    @Data
    public static class Internet{

        //服务地址或域名
        private String serverUrl;

        //in内网，out外网
        private String type;

        //内网配置
        private Inner in;

        //外网配置
        private Outer out;

    }

    //内网配置
    @Data
    public static class Inner{

        //ftp配置
        private FtpConfig ftp;

    }

    //外网配置
    @Data
    public static class Outer{
        //存储路径
        private String savePath;

    }

    //ftp配置
    @Data
    public static class FtpConfig{
        private String ip;
        private Integer port;
        private String username;
        private String password;
        private String path;
    }

}
