/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.sharding.strategy;

import com.bcxin.autodownloadupload.sharding.strategy.ConsistentHashAlgorithm;
import java.util.Collection;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource;
import org.apache.shardingsphere.underlying.common.rule.DataNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitTableNodesToHashLoop {
    private static final Logger log = LoggerFactory.getLogger(InitTableNodesToHashLoop.class);
    @Autowired
    private ShardingDataSource shardingDataSource;
    private HashMap<String, SortedMap<Long, String>> tableVirtualNodes = new HashMap();

    @PostConstruct
    public void init() {
        try {
            ShardingRule rule = (ShardingRule)this.shardingDataSource.getRuntimeContext().getRule();
            Collection tableRules = rule.getTableRules();
            ConsistentHashAlgorithm consistentHashAlgorithm = new ConsistentHashAlgorithm();
            for (TableRule tableRule : tableRules) {
                String logicTable = tableRule.getLogicTable();
                this.tableVirtualNodes.put(logicTable, consistentHashAlgorithm.initNodesToHashLoop((Collection)tableRule.getActualDataNodes().stream().map(DataNode::getTableName).collect(Collectors.toList())));
            }
        }
        catch (Exception e) {
            log.error("\u5206\u8868\u8282\u70b9\u521d\u59cb\u5316\u5931\u8d25 {}", (Throwable)e);
        }
    }

    public HashMap<String, SortedMap<Long, String>> getTableVirtualNodes() {
        return this.tableVirtualNodes;
    }
}

