package com.bcxin.runtime.domain.repositories.syncs.components.impls;

import com.bcxin.runtime.domain.repositories.syncs.components.SqlParser;
import com.bcxin.runtime.domain.snapshoots.JdbcConnectionSnapshot;
import com.bcxin.runtime.domain.snapshoots.TableMapSnapshot;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.bcxin.saas.core.AppConfigProperty;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

@Component(JdbcConnectionSnapshot.MYSQL_PARSER_BEAN_NAME)
public class SqlParserMySqlImpl extends SqlParserAbstract  implements SqlParser {

    public SqlParserMySqlImpl(JsonProvider jsonProvider,
                              AppConfigProperty appConfigProperty) {
        super(jsonProvider, appConfigProperty);
    }

    @Override
    protected String buildFinalSql(String sql, Collection<String> duplicateColumnNames) {
        /*
        sqlMapping.append(String.format("insert into %s (%s) values(%s) on conflict (id) do update set %s",
                tableMap.getTableName(), columnBuilder, valueBuilder, duplicate_UpdateBuilder));
         */
        if (duplicateColumnNames == null || duplicateColumnNames.size() == 0) {
            return sql;
        }

        return String.format("%s on duplicate key update %s",
                sql, duplicateColumnNames.stream().map(fieldName -> String.format("%s=values(%s)", fieldName, fieldName))
                        .collect(Collectors.joining(",")));
    }
}
