package com.bcxin.common.apis.controller;


import cn.myapps.common.controller.Resource;
import com.bcxin.runtime.approve.dto.MatterDataDto;
import com.bcxin.runtime.approve.dto.MatterDataSearchDto;
import com.bcxin.runtime.approve.service.MatterDataService;
import com.bcxin.runtime.approve.utils.JwtUtil;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;


@RestController
@RequestMapping("/api/dynamic/datas")
public class DynamicDataController{
    private final MatterDataService matterDataService;

    public DynamicDataController(MatterDataService matterDataService) {
        this.matterDataService = matterDataService;

    }

    @PostMapping
    public Resource post(@RequestBody MatterDataDto matterData) {//这个注解自动将json转化为对象属性赋值
        try {
            return Resource.ok(matterDataService.save(matterData));
        }
        catch (SaasNoSupportException ex)
        {
            return Resource.error(406,"暂无此功能",null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Resource(500,e.getMessage());
        }
    }

    @GetMapping
    public Resource page(MatterDataSearchDto searchDto) {
        try {

            return Resource.ok(matterDataService.page(searchDto));
        } catch (SaasNoSupportException ex){
            return Resource.error(406,"暂无此功能",null);

        } catch (Exception e) {
            e.printStackTrace();
            return new Resource(500,e.getMessage());
        }
    }
    @GetMapping("getXToken/{domainId}")
    public Resource getXToken(@PathVariable("domainId") String domainId) {
        return Resource.ok(JwtUtil.getToken(domainId));
    }
}
