package com.bcxin.sync.apis.controllers;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.util.ftp.FtpUtils;
import com.bcxin.saas.core.AppConfigProperty;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.bcxin.saas.core.utils.ExceptionUtils;
import com.bcxin.sync.apis.configs.FileModeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;

@RestController
@RequestMapping("/v2/sync/file/download")
public class FileDownloadController {
    private final AppConfigProperty appConfigProperty;
    private final static Logger logger = LoggerFactory.getLogger(FileDownloadController.class);

    public FileDownloadController(AppConfigProperty appConfigProperty) {
        this.appConfigProperty = appConfigProperty;
    }

    @GetMapping
    public void download(@RequestParam("f") String path, HttpServletResponse response) {
        if (!StringUtils.hasLength(path)) {
            response(response, HttpStatus.NOT_FOUND, "要下载的附件不能为空");
            return;
        }

        try {
            if (FileModeConfig.getUseFtp() && path.indexOf("/uploads/lib/icon/") < 0) {
                InputStream is = null;
                ServletOutputStream out = null;
                File tempFile = null;
                try {
                    //文件路径
                    String filePath = path.substring(0, path.lastIndexOf("/") + 1);
                    //文件名称
                    String fileName = path.substring(path.lastIndexOf("/") + 1);
                    String tempPath = PropertyUtil.getPath() + "/temp/";
                    tempFile = FtpUtils.downloadFile(FileModeConfig.getHost(),
                            FileModeConfig.getUserName(),
                            FileModeConfig.getPassword(),
                            FileModeConfig.getPort(),
                            (StrUtil.isEmpty(FileModeConfig.getFilePath()) ? "" : FileModeConfig.getFilePath()) + filePath,
                            tempPath,
                            fileName);


                    is = new FileInputStream(tempFile);
                    out = response.getOutputStream();
                    fileName = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
                    response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                    int read = 0;
                    byte[] buffer = new byte[8192];
                    while ((read = is.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    throw new SaasNofoundException("文件" + path + "不存在！！！");
                } finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                    } catch (Exception e) {
                        logger.error(e.getMessage(), e);
                        throw new SaasNofoundException("文件" + path + "不存在！！！");
                    }
                }
                tempFile.delete();
            } else {
                try (InputStream inputStream = this.getInputStream(path)) {
                    byte[] temp = new byte[2048];
                    response.setContentType("application/octet-stream");
                    //通过设置头信息给文件命名，也即是，在前端，文件流被接受完还原成原文件的时候会以你传递的文件名来命名
                    response.setContentType("application/x-msdownload");
                    String attachmentFileName = String.format("attachment; filename=%s", URLEncoder.encode(FileUtil.getName(path), "UTF-8"));
                    response.setHeader("Content-Disposition", attachmentFileName);
                    try (OutputStream stream = response.getOutputStream()) {
                        int len = 0;
                        while ((len = inputStream.read(temp)) != -1) {
                            stream.write(temp, 0, len);
                        }
                        stream.flush();
                    }

                } catch (FileNotFoundException e) {
                    response(response, HttpStatus.NOT_FOUND, ExceptionUtils.getStackMessage(e));
                    e.printStackTrace();
                } catch (IOException ex) {
                    response(response, HttpStatus.BAD_REQUEST, ExceptionUtils.getStackMessage(ex));
                    ex.printStackTrace();
                }
            }
        } catch (SaasNofoundException ex) {
            response(response, HttpStatus.NOT_FOUND, String.format("文件不存在(%s)或者无效", path));
        }

    }

    private void response(HttpServletResponse response, HttpStatus status, String msg) {
        try {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(msg);
            //response.getOutputStream().write(msg.getBytes(StandardCharsets.UTF_8));
        } catch (Exception ex) {
            logger.error("FileDownloadController.response 异常", ex);
            ex.printStackTrace();
        }
    }

    private InputStream getInputStream(String path) throws FileNotFoundException {
        if (path.startsWith("http")) {
            return HttpUtil.createGet(path).execute().bodyStream();
        } else {
            //获取服务器文件路径
            String sysPath = PropertyUtil.getPath();
            //获取文件名
            File file = new File(sysPath + path);
            //判断文件是否存在
            if (!(file.exists() && file.canRead())) {
                throw new SaasNofoundException("找不到文件");
            }

            return new FileInputStream(file);
        }
    }
}
