package com.bcxin.sync.apis.configs;


import com.bcxin.runtime.domain.imports.components.DataImportComponentProvider;
import com.bcxin.runtime.domain.imports.repositories.DataQueueRepository;
import com.bcxin.runtime.domain.imports.services.DataQueueService;
import com.bcxin.runtime.domain.imports.services.impls.DataQueueServiceImpl;
import com.bcxin.runtime.domain.metas.repositories.ApplicationMetaRepository;
import com.bcxin.runtime.domain.metas.repositories.FormSyncMetaRepository;
import com.bcxin.runtime.domain.metas.repositories.FormSyncTargetMetaRepository;
import com.bcxin.runtime.domain.metas.repositories.TaskMetaRepository;
import com.bcxin.runtime.domain.metas.services.ApplicationMetaService;
import com.bcxin.runtime.domain.metas.services.FormSyncMetaService;
import com.bcxin.runtime.domain.metas.services.FormSyncTargetMetaService;
import com.bcxin.runtime.domain.metas.services.TaskMetaService;
import com.bcxin.runtime.domain.metas.services.impls.ApplicationMetaServiceImpl;
import com.bcxin.runtime.domain.metas.services.impls.FormSyncMetaServiceImpl;
import com.bcxin.runtime.domain.metas.services.impls.FormSyncTargetMetaServiceImpl;
import com.bcxin.runtime.domain.metas.services.impls.TaskMetaServiceImpl;
import com.bcxin.runtime.domain.repositories.syncs.repositories.JpaDataMapSyncRepository;
import com.bcxin.runtime.domain.syncs.components.DbSyncExecutor;
import com.bcxin.runtime.domain.syncs.repositories.DataSyncLogRepository;
import com.bcxin.runtime.domain.syncs.repositories.DataSyncMapRepository;
import com.bcxin.runtime.domain.syncs.repositories.DataSyncQueueRepository;
import com.bcxin.runtime.domain.syncs.repositories.FileSyncQueueRepository;
import com.bcxin.runtime.domain.syncs.services.DataSyncMapService;
import com.bcxin.runtime.domain.syncs.services.DataSyncService;
import com.bcxin.runtime.domain.syncs.services.SyncViaFtpService;
import com.bcxin.runtime.domain.syncs.services.impls.DataSyncMapServiceImpl;
import com.bcxin.runtime.domain.syncs.services.impls.DataSyncServiceImpl;
import com.bcxin.runtime.domain.syncs.services.impls.SyncViaFtpServiceImpl;
import com.bcxin.saas.core.AppConfigProperty;
import com.bcxin.saas.core.components.HttpRequestProvider;
import com.bcxin.saas.core.components.JsonProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration("com.bcxin.sync.apis.configs.SetupConfig")
@ComponentScan(basePackages = {
                               "com.bcxin.runtime.domain.repositories.metas",
                               "com.bcxin.runtime.domain.repositories.imports",
                                "com.bcxin.runtime.domain.repositories.syncs"})
public class SetupConfig {
    public SetupConfig() {

    }

    @Primary
    @Bean(name = "com.bcxin.sync.apis.configs.SetupConfig.appConfigProperty")
    public AppConfigProperty appConfigProperty(
            @Value("${myapps.storage.root}") String rootPath,
            @Value("${myapps.domain.url:}") String domainUrl,
            @Value("${myapps.domain.needTDocument:false}") boolean needTDocument) {
        return AppConfigProperty.create(rootPath, domainUrl, needTDocument);
    }

    @Primary
    @Bean
    public ApplicationMetaService applicationMetaService(ApplicationMetaRepository applicationMetaRepository) {
        return new ApplicationMetaServiceImpl(applicationMetaRepository);
    }

    @Primary
    @Bean
    public FormSyncMetaService formSyncMetaService(ApplicationMetaRepository applicationMetaRepository,
                                                   FormSyncMetaRepository formSyncMetaRepository,
                                                   FormSyncTargetMetaRepository formSyncTargetMetaRepository,
                                                   JsonProvider jsonProvider) {
        return new FormSyncMetaServiceImpl(formSyncMetaRepository, applicationMetaRepository,
                jsonProvider,
                formSyncTargetMetaRepository);
    }

    @Primary
    @Bean
    public TaskMetaService taskMetaService(TaskMetaRepository taskMetaRepository,
                                           JsonProvider jsonProvider,
                                           ApplicationMetaRepository applicationMetaRepository) {
        return new TaskMetaServiceImpl(taskMetaRepository, jsonProvider, applicationMetaRepository);
    }

    @Primary
    @Bean
    public DataQueueService dataQueueService(DataQueueRepository dataQueueRepository,
                                             JsonProvider jsonProvider,
                                             DataImportComponentProvider dataImportComponentProvider) {
        return new DataQueueServiceImpl(dataQueueRepository, jsonProvider, dataImportComponentProvider);
    }

    @Primary
    @Bean
    public DataSyncService dataMapSyncService(DataSyncMapRepository dataMapSyncRepository,
                                              DataSyncLogRepository dataSyncLogRepository,
                                              JsonProvider jsonProvider,
                                              DbSyncExecutor dbSyncExecutor,
                                              HttpRequestProvider httpRequestProvider,
                                              AppConfigProperty appConfigProperty,
                                              FileSyncQueueRepository fileSyncQueueRepository) {
        return new DataSyncServiceImpl(dataMapSyncRepository, dataSyncLogRepository,
                jsonProvider, dbSyncExecutor, httpRequestProvider, appConfigProperty, fileSyncQueueRepository);
    }

    @Primary
    @Bean
    public DataSyncMapService dataSyncMapService(JpaDataMapSyncRepository jpaDataMapSyncRepository,
                                                 JsonProvider jsonProvider) {
        return new DataSyncMapServiceImpl(jpaDataMapSyncRepository, jsonProvider);
    }

    @Primary
    @Bean
    public HttpRequestProvider httpRequestProvider(JsonProvider jsonProvider) {
        return new HttpRequestProvider.HttpRequestProviderImpl(jsonProvider);
    }

    @Primary
    @Bean
    public FormSyncTargetMetaService formSyncTargetMetaService(
            FormSyncTargetMetaRepository formSyncTargetMetaRepository,
            JsonProvider jsonProvider) {
        return new FormSyncTargetMetaServiceImpl(formSyncTargetMetaRepository, jsonProvider);
    }

    @Primary
    @Bean
    public SyncViaFtpService ftpDataSyncService(DataSyncService dataSyncService,
                                                JsonProvider jsonProvider,
                                                DataSyncQueueRepository dataSyncQueueRepository) {
        return new SyncViaFtpServiceImpl(dataSyncService, jsonProvider, dataSyncQueueRepository);
    }
}
