package com.bcxin.runtime.domain.metas.services.impls;

import com.bcxin.runtime.domain.metas.commands.RefreshAppCommand;
import com.bcxin.runtime.domain.metas.entities.ApplicationMetaEntity;
import com.bcxin.runtime.domain.metas.repositories.ApplicationMetaRepository;
import com.bcxin.runtime.domain.metas.services.ApplicationMetaService;

import java.util.Collection;
import java.util.Optional;
import java.util.UUID;

public class ApplicationMetaServiceImpl implements ApplicationMetaService {
    private final ApplicationMetaRepository applicationMetaRepository;

    public ApplicationMetaServiceImpl(ApplicationMetaRepository applicationMetaRepository) {
        this.applicationMetaRepository = applicationMetaRepository;
    }

    @Override
    public void refresh(RefreshAppCommand command) {
        Collection<ApplicationMetaEntity> applicationMetaEntities = this.applicationMetaRepository.findAll();
        for (ApplicationMetaEntity ii : applicationMetaEntities) {
            Optional<RefreshAppCommand.Application> appOption = command.getApplications().stream()
                    .filter(ca -> ca.getId().equals(ii.getAppId()))
                    .findFirst();
            if (!appOption.isPresent()) {
                //applicationMetaEntities.remove(applicationMetaEntities);
                continue;
            }

            RefreshAppCommand.Application app = appOption.get();
            copyValue2DestDataSources(app.getDataSources(), ii);
            copyValue2DestForms(app.getForms(), ii);
        }

        for (RefreshAppCommand.Application ii : command.getApplications()) {
            Optional<ApplicationMetaEntity> metaEntityOptional = applicationMetaEntities.stream()
                    .filter(ap -> ap.getAppId().equals(ii.getId())).findFirst();

            ApplicationMetaEntity metaEntity = null;
            if (metaEntityOptional.isPresent()) {
                metaEntity = metaEntityOptional.get();
            }else {
                metaEntity = ApplicationMetaEntity.create(UUID.randomUUID().toString(),
                        ii.getId(), ii.getName(), ii.isOnline(), ii.getNote());
                applicationMetaEntities.add(metaEntity);
            }

            copyValue2DestDataSources(ii.getDataSources(), metaEntity);
            copyValue2DestForms(ii.getForms(), metaEntity);
        }

        this.applicationMetaRepository.saveAll(applicationMetaEntities);
    }

    private void copyValue2DestDataSources(Collection<RefreshAppCommand.DataSource> dataSources,
            ApplicationMetaEntity applicationMetaEntity) {
        for (RefreshAppCommand.DataSource ds : dataSources) {
            applicationMetaEntity.addDataSourceMeta(ds.getId(), ds.getName(), ds.getEnumDriveType(),
                    ds.getEnumDbType(), ds.getConfig(), "", ds.isSelected());
        }
    }

    private void copyValue2DestForms(Collection<RefreshAppCommand.Form> forms,
                                     ApplicationMetaEntity applicationMetaEntity) {
        for (RefreshAppCommand.Form fm : forms) {
            applicationMetaEntity.addFormMeta(fm.getId(), fm.getName(), fm.getTableName(),fm.getFormType());
        }
    }
}
