package com.bcxin.runtime.domain.repositories.metas.repositories;

import com.bcxin.runtime.domain.metas.entities.FormSyncMetaEntity;
import com.bcxin.runtime.domain.metas.repositories.FormSyncMetaRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Date;
import java.util.List;

public interface JpaFormSyncMetaRepository extends FormSyncMetaRepository,
        JpaRepository<FormSyncMetaEntity,String> {

    @Query("select u from FormSyncMetaEntity u where u.formMeta.id=?1")
    List<FormSyncMetaEntity> getByFormId(String formId);

    @Query("select u from FormSyncMetaEntity u where u.isOnline=1")
    List<FormSyncMetaEntity> findAllOnline();

    @Query("select u from FormSyncMetaEntity u where u.lastSyncedTime is null or u.lastSyncedTime<=?1 ")
    List<FormSyncMetaEntity> findReadyToSync(Date expectedDate);
}
