package com.bcxin.runtime.approve.utils;

import com.github.pagehelper.PageInfo;

import java.io.Serializable;
import java.util.List;


public class PageInfoUtils<T> implements Serializable {
	 //结果集
    private List<T> data;
    
    private Integer pageIndex;
    
    private Integer pageSize;
    
    private Integer total;
    
    private Integer totalPage;


    public PageInfoUtils() {
    	PageInfo pageInfo = new PageInfo();
    	this.pageSize = pageInfo.getPageSize();
    	this.pageIndex = pageInfo.getPageNum();
    	this.total = (int) pageInfo.getTotal();
    	this.totalPage = pageInfo.getPages();
    	
    }
    
    public PageInfoUtils(List<T> data) {
    	PageInfo pageInfo = new PageInfo(data);
    	this.data = data;
    	this.pageSize = pageInfo.getPageSize();
    	this.pageIndex = pageInfo.getPageNum();
    	this.total = (int) pageInfo.getTotal();
    	this.totalPage = pageInfo.getPages();
    }

	public List<T> getData() {
		return data;
	}

	public void setData(List<T> data) {
		this.data = data;
	}

	public Integer getPageIndex() {
		return pageIndex;
	}

	public void setPageIndex(Integer pageIndex) {
		this.pageIndex = pageIndex;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Integer getTotal() {
		return total;
	}

	public void setTotal(Integer total) {
		this.total = total;
	}

	public Integer getTotalPage() {
		return totalPage;
	}

	public void setTotalPage(Integer totalPage) {
		this.totalPage = totalPage;
	}

}
