package com.bcxin.runtime.approve.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;

import com.bcxin.runtime.approve.configs.DynamicDataConfig;
import com.bcxin.runtime.approve.dto.MatterDataDto;
import com.bcxin.runtime.approve.base.BaseEntity;
import com.bcxin.runtime.approve.dto.MatterDataSearchDto;
import com.bcxin.runtime.approve.entities.*;
import com.bcxin.runtime.approve.mapper.*;
import com.bcxin.runtime.approve.service.MatterDataService;
import com.bcxin.runtime.approve.utils.PageInfoUtils;
import com.bcxin.runtime.approve.utils.UUIDUtil;
import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import com.github.pagehelper.PageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Service
public class MatterDataServiceImpl implements MatterDataService {


    private final DynamicDataConfig dynamicDataConfig;

    //构造器注入
    public MatterDataServiceImpl(DynamicDataConfig dynamicDataConfig) {
        this.dynamicDataConfig = dynamicDataConfig;
    }

    @Resource
    private CrossrMapper crossrMapper;

    @Resource
    private SecuritysevicekMapper securitysevicekMapper;

    @Resource
    private EstablishMapper establishMapper;

    @Resource
    private LegalchangekMapper legalchangekMapper;

    @Resource
    private RecruitmentMapper recruitmentMapper;

    @Resource
    private RevokeMapper revokeMapper;

    @Resource
    private SecuritytrainingsMapper securitytrainingsMapper;



    @Transactional
    @Override
    public String save(MatterDataDto matterData) throws Exception {
        System.err.println("matterData:"+matterData.toString());
        if(StrUtil.isEmpty(dynamicDataConfig.getDomainId())) {
            throw new SaasNoSupportException("企业域id不能为空");
        }
        if(StrUtil.isEmpty(matterData.getType())){
            throw new Exception("类型不能为空");
        }
        if(matterData.getData() == null){
            throw new Exception("申报数据不能为空");
        }
        String id = UUIDUtil.getShortUuid();
        switch (matterData.getType()) {
            case "保安服务许可申请":
                id=id+"--__0TXoiEr3uNf7rO0sduB";
                Securitysevicek securitysevicek = JSON.parseObject(JSON.toJSONString(matterData.getData()), Securitysevicek.class);
                securitysevicek.setId(id);
                securitysevicek.setFormid("__0TXoiEr3uNf7rO0sduB");
                securitysevicek.setFormname("许可申报/保安服务许可申报/SecuritySeviceCompany");
                this.setBaseInfo(securitysevicek);
                securitysevicekMapper.insertSecuritysevicek(securitysevicek);
                //批量插入股东信息
                List<Companypermitshareholder> companypermitshareholders=securitysevicek.getCompanypermitshareholders();
                for (Companypermitshareholder companypermitshareholder : companypermitshareholders) {
                    this.setshareholder(companypermitshareholder,id);
                    securitysevicekMapper.insertCompanyPermitShareholder(companypermitshareholder);
                }
                //批量插入管理层信息
                List<CompanyPermitManagementLayer> companyPermitManagementLayers=securitysevicek.getCompanyPermitManagementLayers();
                for (CompanyPermitManagementLayer companyPermitManagementLayer : companyPermitManagementLayers) {
                    this.setManagementLayer(companyPermitManagementLayer,id);
                    securitysevicekMapper.insertCompanyPermitManagementLayer(companyPermitManagementLayer);
                }
                break;
            case "外省保安跨区服务设立分公司备案":
                id=id+"--__f6KPracyua0kseIfnAf";
                Crossr crossr = JSON.parseObject(JSON.toJSONString(matterData.getData()), Crossr.class);
                crossr.setId(id);
                crossr.setFormid("__f6KPracyua0kseIfnAf");
                crossr.setFormname("备案申报/外省保安跨区服务设立分公司备案/Crossr");
                this.setBaseInfo(crossr);
                crossrMapper.insertCrossr(crossr);
                break;
            case "保安公司设立分公司备案":
                id=id+"--__Cf9cHA3xWKgzDNL80xE";
                Establish establish = JSON.parseObject(JSON.toJSONString(matterData.getData()), Establish.class);
                if (StringUtils.isEmpty(establish.getTemplaterarfile())){
                    throw new Exception("保安公司设立分公司备案附件不能为null");
                }
                establish.setId(id);
                establish.setFormid("__Cf9cHA3xWKgzDNL80xE");
                establish.setFormname("备案申报/本市保安服务公司设立分公司备案/Establish");
                this.setBaseInfo(establish);
                establishMapper.insertEstablish(establish);
                break;
            case "保安培训单位备案":
                id=id+"--__RCOcXGrkJRC4HyyXmrG";
                Securitytrainings securitytrainings = JSON.parseObject(JSON.toJSONString(matterData.getData()), Securitytrainings.class);
                securitytrainings.setId(id);
                securitytrainings.setFormid("__RCOcXGrkJRC4HyyXmrG");
                securitytrainings.setFormname("许可管理/保安培训公司许可审批/SecurityTrainingS");
                this.setBaseInfo(securitytrainings);
                securitytrainingsMapper.insertSecuritytrainings(securitytrainings);
                break;
            case "自行招用保安员单位备案":
                id=id+"--__Kh9sHO1jncg49KqR2MN";
                Recruitment recruitment = JSON.parseObject(JSON.toJSONString(matterData.getData()), Recruitment.class);
                recruitment.setId(id);
                recruitment.setFormid("__Kh9sHO1jncg49KqR2MN");
                recruitment.setFormname("备案申报/自行招用保安员单位备案/Recruitment_record");
                this.setBaseInfo(recruitment);
                recruitmentMapper.insertRecruitment(recruitment);
                break;
            case "自行招用保安员单位撤销备案":
                id=id+"--__gcUSDii3Y98mCcLM2dD";
                Revoke revoke = JSON.parseObject(JSON.toJSONString(matterData.getData()), Revoke.class);
                revoke.setId(id);
                revoke.setFormid("__gcUSDii3Y98mCcLM2dD");
                revoke.setFormname("备案申报/自行招用保安员单位撤销备案/Revoke_record");
                this.setBaseInfo(revoke);
                revokeMapper.insertRevoke(revoke);
                break;
            case "许可证项目法人变更":
                id=id+"--__5pbeYTFpNEdQdpDbtG7";
                Legalchangek legalchangek = JSON.parseObject(JSON.toJSONString(matterData.getData()), Legalchangek.class);
                legalchangek.setId(id);
                legalchangek.setFormid("__5pbeYTFpNEdQdpDbtG7");
                legalchangek.setFormname("变更申报/许可证项目法人变更/LegalChange_change");
                this.setBaseInfo(legalchangek);
                legalchangekMapper.insertLegalchangek(legalchangek);
                //批量插入简历信息
                List<Resume> resumes=legalchangek.getResumes();
                for (Resume resume : resumes) {
                    this.setResume(resume,id);
                    legalchangekMapper.insertResume(resume);
                }
                break;
            default:
                break;
        }
        return id;
    }

    @Override
    public PageInfoUtils page(MatterDataSearchDto searchDto) throws Exception {
        if(StrUtil.isEmpty(dynamicDataConfig.getDomainId())){
            throw new SaasNoSupportException("企业域id不能为空");
        }
        if(StrUtil.isEmpty(searchDto.getType())){
            throw new Exception("类型不能为空");
        }
        if(searchDto.getIds().length==0){
            throw new Exception("id不能为空");
        }
        PageHelper.startPage(searchDto.getPageIndex(),searchDto.getPageSize());
        PageInfoUtils pageInfoUtils = null;
        switch (searchDto.getType()) {
            case "保安服务许可申请":
                List<SecuritisevicekDto> securitysevicekList = securitysevicekMapper.selectSecuritysevicekList(searchDto);
                pageInfoUtils = new PageInfoUtils(securitysevicekList);
                break;
            case "外省保安跨区服务设立分公司备案":
                List<Crossr> crossrList = crossrMapper.selectCrossrList(searchDto);
                pageInfoUtils = new PageInfoUtils(crossrList);
                break;
            case "保安公司设立分公司备案":
                List<Establish> establishList = establishMapper.selectEstablishList(searchDto);
                pageInfoUtils = new PageInfoUtils(establishList);
                break;
            case "保安培训单位备案":
                List<Securitytrainings> securitytrainingsList = securitytrainingsMapper.selectSecuritytrainingsList(searchDto);
                pageInfoUtils = new PageInfoUtils(securitytrainingsList);
                break;
            case "自行招用保安员单位备案":
                List<Recruitment> recruitmentList = recruitmentMapper.selectRecruitmentList(searchDto);
                pageInfoUtils = new PageInfoUtils(recruitmentList);
                break;
            case "自行招用保安员单位撤销备案":
                List<Revoke> revokeList = revokeMapper.selectRevokeList(searchDto);
                pageInfoUtils = new PageInfoUtils(revokeList);
                break;
            case "许可证项目法人变更":
                List<Legalchangek> legalchangekList = legalchangekMapper.selectLegalchangekList(searchDto);
                pageInfoUtils = new PageInfoUtils(legalchangekList);
                break;
            default:
                break;
        }

        return pageInfoUtils;
    }

    /**
     * 抽取公共字段赋值
     * @param baseInfo
     */
    private void setBaseInfo(BaseEntity baseInfo){
        baseInfo.setCreated(new Date());
        baseInfo.setApplicationid("__wGomeHJBz6CpLFCCl4y");
        baseInfo.setLastmodified(new Date());
        baseInfo.setDomainid(dynamicDataConfig.getDomainId());
        baseInfo.setState("");
        baseInfo.setAuditornames("");
    }

    /**
     * 保安服务许可申请
     * 股东信息专用
     * @param
     */
    private void setshareholder(Companypermitshareholder companypermitshareholder ,String id){
        companypermitshareholder.setId(UUIDUtil.getShortUuid()+"--__1JvRG0atyPWii0W4jVs");
        companypermitshareholder.setFormid("__1JvRG0atyPWii0W4jVs");
        companypermitshareholder.setTOPID(id);
        companypermitshareholder.setCreated(new Date());
        companypermitshareholder.setApplicationid("__wGomeHJBz6CpLFCCl4y");
        companypermitshareholder.setLastmodified(new Date());
        companypermitshareholder.setDomainid(dynamicDataConfig.getDomainId());
    }

    /**
     * 保安服务许可申请
     * 管理层信息专用
     * @param
     */
    private void setManagementLayer(CompanyPermitManagementLayer companyPermitManagementLayer ,String id){
        companyPermitManagementLayer.setId(UUIDUtil.getShortUuid()+"--__hb0zj6fDbIzt4NlMZTa");
        companyPermitManagementLayer.setFormid("__hb0zj6fDbIzt4NlMZTa");
        companyPermitManagementLayer.setTOPID(id);
        companyPermitManagementLayer.setCreated(new Date());
        companyPermitManagementLayer.setApplicationid("__wGomeHJBz6CpLFCCl4y");
        companyPermitManagementLayer.setLastmodified(new Date());
        companyPermitManagementLayer.setDomainid(dynamicDataConfig.getDomainId());
    }

    /**
     * 许可证法人变更
     * 简历信息专用
     * @param
     */
    private void setResume(Resume resume ,String id){
        resume.setId(UUIDUtil.getShortUuid()+"--__3pKY4P0ITkuHNs6052D");
        resume.setFormid("__3pKY4P0ITkuHNs6052D");
        resume.setTOPID(id);
        resume.setCreated(new Date());
        resume.setApplicationid("__wGomeHJBz6CpLFCCl4y");
        resume.setLastmodified(new Date());
        resume.setDomainid(dynamicDataConfig.getDomainId());
    }
}
