package com.bcxin.runtime.approve.mapper;

import com.bcxin.runtime.approve.dto.MatterDataSearchDto;
import com.bcxin.runtime.approve.entities.CompanyPermitManagementLayer;
import com.bcxin.runtime.approve.entities.Companypermitshareholder;
import com.bcxin.runtime.approve.entities.SecuritisevicekDto;
import com.bcxin.runtime.approve.entities.Securitysevicek;

import java.util.List;

/**
 * 保安服务许可申请Mapper接口
 *
 * @author lin
 * @date 2022-09-28
 */
public interface SecuritysevicekMapper {
    /**
     * 查询保安服务许可申请
     *
     * @param id 保安服务许可申请主键
     * @return 保安服务许可申请
     */
    Securitysevicek selectSecuritysevicekById(String id);

    /**
     * 查询保安服务许可申请列表
     *
     * @param searchDto 保安服务许可申请
     * @return 保安服务许可申请集合
     */
    List<SecuritisevicekDto> selectSecuritysevicekList(MatterDataSearchDto searchDto);

    /**
     * 新增保安服务许可申请
     *
     * @param securitysevicek 保安服务许可申请
     * @return 结果
     */
    int insertSecuritysevicek(Securitysevicek securitysevicek);


    /**
     * 新增保安服务许可申请股东信息
     * @param companypermitshareholder
     * @return
     */
    int insertCompanyPermitShareholder( Companypermitshareholder companypermitshareholder);


    /**
     * 新增保安服务许可申请管理层信息
     * @param companyPermitManagementLayer
     * @return
     */
    int insertCompanyPermitManagementLayer( CompanyPermitManagementLayer companyPermitManagementLayer);


    /**
     * 修改保安服务许可申请
     *
     * @param securitysevicek 保安服务许可申请
     * @return 结果
     */
    int updateSecuritysevicek(Securitysevicek securitysevicek);

}
