package com.bcxin.runtime.approve.mapper;

import com.bcxin.runtime.approve.dto.MatterDataSearchDto;
import com.bcxin.runtime.approve.entities.Revoke;

import java.util.List;

/**
 * 自行招用保安员单位撤销备案Mapper接口
 *
 * @author lin
 * @date 2022-09-28
 */
public interface RevokeMapper {
    /**
     * 查询自行招用保安员单位撤销备案
     *
     * @param id 自行招用保安员单位撤销备案主键
     * @return 自行招用保安员单位撤销备案
     */
    Revoke selectRevokeById(String id);

    /**
     * 查询自行招用保安员单位撤销备案列表
     *
     * @param searchDto 自行招用保安员单位撤销备案
     * @return 自行招用保安员单位撤销备案集合
     */
    List<Revoke> selectRevokeList(MatterDataSearchDto searchDto);

    /**
     * 新增自行招用保安员单位撤销备案
     *
     * @param revoke 自行招用保安员单位撤销备案
     * @return 结果
     */
    int insertRevoke(Revoke revoke);

    /**
     * 修改自行招用保安员单位撤销备案
     *
     * @param revoke 自行招用保安员单位撤销备案
     * @return 结果
     */
    int updateRevoke(Revoke revoke);

}
