package com.bcxin.runtime.approve.mapper;

import com.bcxin.runtime.approve.dto.MatterDataSearchDto;
import com.bcxin.runtime.approve.entities.Recruitment;

import java.util.List;

/**
 * 自行招用保安员单位备案Mapper接口
 *
 * @author lin
 * @date 2022-09-28
 */
public interface RecruitmentMapper {
    /**
     * 查询自行招用保安员单位备案
     *
     * @param id 自行招用保安员单位备案主键
     * @return 自行招用保安员单位备案
     */
    Recruitment selectRecruitmentById(String id);

    /**
     * 查询自行招用保安员单位备案列表
     *
     * @param searchDto 自行招用保安员单位备案
     * @return 自行招用保安员单位备案集合
     */
    List<Recruitment> selectRecruitmentList(MatterDataSearchDto searchDto);

    /**
     * 新增自行招用保安员单位备案
     *
     * @param recruitment 自行招用保安员单位备案
     * @return 结果
     */
    int insertRecruitment(Recruitment recruitment);

    /**
     * 修改自行招用保安员单位备案
     *
     * @param recruitment 自行招用保安员单位备案
     * @return 结果
     */
    int updateRecruitment(Recruitment recruitment);
}
