package com.bcxin.runtime.approve.mapper;

import com.bcxin.runtime.approve.dto.MatterDataSearchDto;
import com.bcxin.runtime.approve.entities.Legalchangek;
import com.bcxin.runtime.approve.entities.Resume;

import java.util.List;

/**
 * 许可证项目法人变更Mapper接口
 *
 * @author lin
 * @date 2022-09-28
 */
public interface LegalchangekMapper {
    /**
     * 查询许可证项目法人变更
     *
     * @param id 许可证项目法人变更主键
     * @return 许可证项目法人变更
     */
    Legalchangek selectLegalchangekById(String id);

    /**
     * 查询许可证项目法人变更列表
     *
     * @param searchDto 许可证项目法人变更
     * @return 许可证项目法人变更集合
     */
    List<Legalchangek> selectLegalchangekList(MatterDataSearchDto searchDto);

    /**
     * 新增许可证项目法人变更
     *
     * @param legalchangek 许可证项目法人变更
     * @return 结果
     */
    int insertLegalchangek(Legalchangek legalchangek);


    /**
     * 新增许可证项目法人变更简历信息
     * @param resume 许可证项目法人变更简历信息
     * @return 结果
     */
    int insertResume(Resume resume);


    /**
     * 修改许可证项目法人变更
     *
     * @param legalchangek 许可证项目法人变更
     * @return 结果
     */
    int updateLegalchangek(Legalchangek legalchangek);

}
