package com.bcxin.runtime.approve.mapper;

import com.bcxin.runtime.approve.dto.MatterDataSearchDto;
import com.bcxin.runtime.approve.entities.Establish;

import java.util.List;

/**
 * 保安公司设立分公司备案Mapper接口
 *
 * @author lin
 * @date 2022-09-28
 */
public interface EstablishMapper {
    /**
     * 查询保安公司设立分公司备案
     *
     * @param id 保安公司设立分公司备案主键
     * @return 保安公司设立分公司备案
     */
    Establish selectEstablishById(String id);

    /**
     * 查询保安公司设立分公司备案列表
     *
     * @param searchDto 保安公司设立分公司备案
     * @return 保安公司设立分公司备案集合
     */
    List<Establish> selectEstablishList(MatterDataSearchDto searchDto);

    /**
     * 新增保安公司设立分公司备案
     *
     * @param establish 保安公司设立分公司备案
     * @return 结果
     */
    int insertEstablish(Establish establish);

    /**
     * 修改保安公司设立分公司备案
     *
     * @param establish 保安公司设立分公司备案
     * @return 结果
     */
    int updateEstablish(Establish establish);

}
