package com.bcxin.runtime.approve.mapper;


import com.bcxin.runtime.approve.dto.MatterDataSearchDto;
import com.bcxin.runtime.approve.entities.Crossr;

import java.util.List;

/**
 * 外省保安跨区服务设立分公司备案Mapper接口
 *
 * @author lin
 * @date 2022-09-28
 */
public interface CrossrMapper {
    /**
     * 查询外省保安跨区服务设立分公司备案
     *
     * @param id 外省保安跨区服务设立分公司备案主键
     * @return 外省保安跨区服务设立分公司备案
     */
    Crossr selectCrossrById(String id);

    /**
     * 查询外省保安跨区服务设立分公司备案列表
     *
     * @param searchDto 外省保安跨区服务设立分公司备案
     * @return 外省保安跨区服务设立分公司备案集合
     */
    List<Crossr> selectCrossrList(MatterDataSearchDto searchDto);

    /**
     * 新增外省保安跨区服务设立分公司备案
     *
     * @param crossr 外省保安跨区服务设立分公司备案
     * @return 结果
     */
    int insertCrossr(Crossr crossr);

    /**
     * 修改外省保安跨区服务设立分公司备案
     *
     * @param crossr 外省保安跨区服务设立分公司备案
     * @return 结果
     */
    int updateCrossr(Crossr crossr);

    /**
     * 删除外省保安跨区服务设立分公司备案
     *
     * @param id 外省保安跨区服务设立分公司备案主键
     * @return 结果
     */
    int deleteCrossrById(String id);

    /**
     * 批量删除外省保安跨区服务设立分公司备案
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteCrossrByIds(String[] ids);
}
