package com.bcxin.runtime.approve.entities;

import com.bcxin.runtime.approve.base.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 自行招用保安员单位撤销备案对象 tlk_revoke
 *
 * @author lin
 * @date 2022-09-28
 */
@Data
public class Revoke extends BaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     * 审批状态
     */
    private String auditstatus;

    /**
     * 表单名称
     */
    private String tlkformname;

    /**
     * 办事区域
     */
    private String officepoliceaddress;

    /**
     * $column.columnComment
     */
    private String officepoliceaddressid;

    /**
     * 办公所属监管机构派出所层级
     */
    private String officepoliceidindex;

    /**
     * 公司名称
     */
    private String companyname;

    /**
     * 公司地址
     */
    private String address;

    /**
     * 登记备案号
     */
    private String loginnum;

    /**
     * 备案日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date recorddate;

    /**
     * 申请撤销备案日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date canceldate;

    /**
     * 服务区域项目名称
     */
    private String servicearea;

    /**
     * 姓名
     */
    private String legalname;

    /**
     * 性别
     */
    private String legalsex;

    /**
     * 手机号码
     */
    private String legalphone;

    /**
     * 身份证件号码
     */
    private String legalcardnumber;

    /**
     * 撤销申请书
     */
    private String cancelapplyfile;

    /**
     * 地区
     */
    private String region;

    /**
     * 失败原因
     */
    private String rejectreason;

    /**
     * 企业域ID
     */
    private String domainId;

    /**
     * 承诺
     */
    private String permit;

    /**
     * $column.columnComment
     */
    private String authordeptid;

    /**
     * $column.columnComment
     */
    private String authorUserIndex;

    /**
     * $column.columnComment
     */
    private String subformids;

    /**
     * $column.columnComment
     */
    private String initiator;

    /**
     * 单位法人资格证明材料
     */
    private String evidencePicture;

    /**
     * 法人身份证正面
     */
    private String legalcardfrontPicture;

    /**
     * 法人身份证背面
     */
    private String legalcardbackPicture;

    /**
     * $column.columnComment
     */
    private String evidencepic;

    /**
     * $column.columnComment
     */
    private String legalcardpicfront;

    /**
     * $column.columnComment
     */
    private String 法人身份证背面;
}
