package com.bcxin.runtime.approve.entities;

import com.bcxin.runtime.approve.base.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 外省保安跨区服务设立分公司备案对象 tlk_crossr
 *
 * @author lin
 * @date 2022-09-28
 */
@Data
public class Crossr extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 审批状态
     */
    private String auditstatus;

    /**
     * 表单名称
     */
    private String tlkformname;

    /**
     * 办事区域
     */
    private String officepoliceaddress;

    /**
     * $column.columnComment
     */
    private String officepoliceaddressid;

    /**
     * 办公所属监管机构派出所层级
     */
    private String officepoliceidindex;

    /**
     * 公司名称
     */
    private String companyname;

    /**
     * 公司地址
     */
    private String address;

    /**
     * 邮编
     */
    private String zipcode;

    /**
     * 保安服务许可证编号
     */
    private String licencenum;

    /**
     * 统一社会信用代码
     */
    private String creditcode;

    /**
     * 姓名
     */
    private String legalname;

    /**
     * 性别
     */
    private String legalsex;

    /**
     * 出生年月
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date legalbirth;

    /**
     * 国籍
     */
    private String legalnationality;

    /**
     * 民族
     */
    private String legalnation;

    /**
     * 政治面貌
     */
    private String legalpolitics;

    /**
     * 文化程度
     */
    private String legalculture;

    /**
     * 办公电话
     */
    private String legaltel;

    /**
     * 手机号码
     */
    private String legalphone;

    /**
     * 证件类型
     */
    private String legaltype;

    /**
     * 证件号码
     */
    private String legalcardnumber;

    /**
     * 实际居住地址
     */
    private String legaladdress;

    /**
     * 户籍所在地址/境外住址
     */
    private String legalabroadaddress;

    /**
     * 名称
     */
    private String soncompanyname;

    /**
     * 拟跨区域经营的保安服务项目
     */
    private String managerproject;

    /**
     * 跨区域经营服务时间（备案有效期开始）
     */
    private Date mobiscrollstartdate;

    /**
     * 跨区域经营服务时间（备案有效期结束）
     */
    private Date mobiscrollenddate;

    /**
     * 分公司地址
     */
    private String sonaddress;

    /**
     * 邮编
     */
    private String sonzipcode;

    /**
     * 保安员数
     */
    private BigDecimal sonpersonnum;

    /**
     * 姓名
     */
    private String chargename;

    /**
     * 职务
     */
    private String chargepost;

    /**
     * 居民身份证号
     */
    private String chargecardnumber;

    /**
     * 联系电话
     */
    private String chargephone;

    /**
     * $column.columnComment
     */
    private String templaterarfile;

    /**
     * 地区
     */
    private String region;

    /**
     * 失败原因
     */
    private String rejectreason;

    /**
     * 企业域ID
     */
    private String domainId;

    /**
     * 承诺
     */
    private String permit;

    /**
     * $column.columnComment
     */
    private String authordeptid;

    /**
     * $column.columnComment
     */
    private String authorUserIndex;

    /**
     * $column.columnComment
     */
    private String subformids;

    /**
     * $column.columnComment
     */
    private String initiator;

}
