package com.bcxin.runtime.approve.configs;

import java.io.IOException;
import java.util.*;
import javax.sql.DataSource;

import cn.hutool.core.util.StrUtil;
import com.bcxin.runtime.approve.enums.DataSourceType;
import com.bcxin.runtime.approve.configs.properties.DruidProperties;
import com.bcxin.runtime.approve.datasource.DynamicDataSource;
import com.bcxin.runtime.approve.utils.SpringUtils;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;

/**
 * druid 配置多数据源
 *
 * @author jubo
 */
@Configuration
@MapperScan(basePackages = {"com.bcxin.runtime.approve.mapper"})
public class DruidConfig {

    @Bean
    @ConfigurationProperties("spring.datasource.druid.master")
    public DataSource dataSource(DruidProperties druidProperties) {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        return druidProperties.dataSource(dataSource);
    }

}
