/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.sync.apis.controllers;

import com.bcxin.runtime.domain.enums.BooleanStatus;
import com.bcxin.runtime.domain.metas.commands.BatchCreateFormSyncMetaCommand;
import com.bcxin.runtime.domain.metas.repositories.FormSyncMetaRepository;
import com.bcxin.runtime.domain.metas.services.FormSyncMetaService;
import com.bcxin.sync.apis.requests.BatchFormSyncRequest;
import com.bcxin.sync.apis.requests.FormSyncRequest;
import com.bcxin.sync.apis.responses.FormSyncMetaResponse;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="com.bcxin.sync.apis.controllers.FormSyncMetaController")
@RequestMapping(value={"/v2/sync/form-sync/metas"})
public class FormSyncMetaController {
    private final FormSyncMetaRepository formSyncMetaRepository;
    private final FormSyncMetaService formSyncMetaService;

    public FormSyncMetaController(FormSyncMetaRepository formSyncMetaRepository, FormSyncMetaService formSyncMetaService) {
        this.formSyncMetaRepository = formSyncMetaRepository;
        this.formSyncMetaService = formSyncMetaService;
    }

    @PostMapping
    public ResponseEntity post(@RequestBody FormSyncRequest request) {
        this.formSyncMetaService.saveAll(request.getCommand());
        return this.get();
    }

    @GetMapping
    public ResponseEntity get() {
        List formSyncMetaEntities = this.formSyncMetaRepository.findAll();
        Collection formSyncs = formSyncMetaEntities.stream().map(fm -> FormSyncMetaResponse.FormSync.create(fm.getId(), fm.getFormMeta().getApplicationMeta().getAppId(), fm.getFormMeta().getId(), fm.getIsOnline() == BooleanStatus.TRUE, fm.getNote(), fm.getFormMeta().getFormType(), fm.getConfig(), fm.getTargetMetaEntity().getId())).collect(Collectors.toList());
        return ResponseEntity.ok((Object)FormSyncMetaResponse.create(formSyncs));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity delete(@PathVariable String id) {
        this.formSyncMetaService.delete(id);
        return ResponseEntity.ok().body((Object)"ok");
    }

    @PostMapping(value={"/batches"})
    public ResponseEntity batchPost(@RequestBody BatchFormSyncRequest request) {
        BatchCreateFormSyncMetaCommand command = request.getCommand();
        this.formSyncMetaService.batch(command);
        return this.get();
    }
}

