package com.bcxin.runtime.apis.controllers;

import cn.myapps.common.util.Security;
import cn.myapps.components.SettingProvider;
import com.bcxin.runtime.apis.requests.CreateTokenRequest;
import com.bcxin.runtime.apis.responses.CreateTokenResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Calendar;

@RestController
@RequestMapping(path = "/v3/extends/identity", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class AuthController {

    private final SettingProvider settingProvider;

    public AuthController(SettingProvider settingProvider) {
        this.settingProvider = settingProvider;
    }

    @ApiOperation(value = "generateToken", notes = "根据授权码")
    @PostMapping("/tokens")
    public ResponseEntity generateToken(@RequestBody CreateTokenRequest request) {
        if (!StringUtils.hasLength(request.getAuthCode())) {
            return ResponseEntity.status(HttpStatus.FORBIDDEN).body("AuthCode 不能为空");
        }

        String assignEmployeeId = this.settingProvider.getSettingWithCache(
                "platform.partner.authCodes", request.getAuthCode(), 30 * 60
        );
        if (!StringUtils.hasLength(assignEmployeeId)) {
            return ResponseEntity.status(HttpStatus.FORBIDDEN).body("AuthCode无效");
        }

        Calendar current = Calendar.getInstance();
        current.add(Calendar.SECOND,60 * 60);
        String token = Security.getToken(assignEmployeeId, 60 * 60);

        return ResponseEntity.ok(CreateTokenResponse.create(assignEmployeeId, token, current.getTime()));
    }
}
