/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.controllers;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.UserDepartmentRoleSet;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.FileSystemDesignTimeSerializable;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.mapping.TableMapping;
import cn.myapps.runtime.macro.RhinoJavaScriptCompiler;
import com.bcxin.runtime.apis.controllers.ControllerAbstract;
import com.bcxin.runtime.apis.requests.BatchAssignUserRoleRequest;
import com.bcxin.runtime.apis.requests.BatchClearUserRoleRequest;
import com.bcxin.runtime.apis.requests.SearchUserRoleRequest;
import com.bcxin.runtime.apis.responses.AppResource;
import com.bcxin.runtime.apis.responses.AppRoleResponse;
import com.bcxin.runtime.apis.responses.UserRoleResponse;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3/extends"})
public class AppController
extends ControllerAbstract {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final DistributedCacheProvider distributedCacheProvider;

    public AppController(NamedParameterJdbcTemplate jdbcTemplate, DistributedCacheProvider distributedCacheProvider) {
        this.jdbcTemplate = jdbcTemplate;
        this.distributedCacheProvider = distributedCacheProvider;
    }

    @GetMapping(value={"/domains/{domainId}"})
    public ResponseEntity getMyApps(@PathVariable String domainId) throws Exception {
        try {
            Collection<AppRoleResponse> appRoleResponses = this.getAppsByDomainId(domainId);
            return ResponseEntity.ok(appRoleResponses);
        }
        catch (Exception ex) {
            if (ex instanceof SaasNofoundException) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)ex.getMessage());
            }
            throw ex;
        }
    }

    @PutMapping(value={"/domains/{domainId}/batch-assign-permissions"})
    public ResponseEntity put(HttpServletRequest servletRequest, @PathVariable String domainId, @RequestBody BatchAssignUserRoleRequest request) throws Exception {
        this.validateAllowed(servletRequest, domainId);
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        Collection userVOS = userProcess.getAllByIds(domainId, request.getUserIds());
        Collection notExistsUserIds = request.getUserIds().stream().filter(ii -> !userVOS.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
        if (notExistsUserIds.size() > 0) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)String.format("\u627e\u4e0d\u5230\u7528\u6237(%s)", notExistsUserIds.stream().collect(Collectors.joining(","))));
        }
        Collection allowedAppRoles = this.getAppsByDomainId(domainId).stream().filter(ii -> ii.getRoles() != null).flatMap(ii -> ii.getRoles().stream()).collect(Collectors.toList());
        Collection notExistsRoleIds = request.getRoleIds().stream().filter(ii -> !allowedAppRoles.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
        if (notExistsRoleIds.size() > 0) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_ACCEPTABLE).body((Object)String.format("\u65e0\u6cd5\u6388\u6743\u5141\u8bb8\u7684\u5e94\u7528\u4ee5\u5916\u7684\u89d2\u8272\u4fe1\u606f(%s)", notExistsRoleIds.stream().collect(Collectors.joining(","))));
        }
        this.doUpdateUserRoles(domainId, userVOS, request.getRoleIds());
        return ResponseEntity.ok(null);
    }

    @PostMapping(value={"/domains/{domainId}/batch-clear-permissions"})
    public ResponseEntity batchDelete(HttpServletRequest servletRequest, @PathVariable String domainId, @RequestBody BatchClearUserRoleRequest request) {
        this.validateAllowed(servletRequest, domainId);
        HashMap<String, Object> deleteMap = new HashMap<String, Object>();
        deleteMap.put("id", request.getUserIds());
        deleteMap.put("domainId", domainId);
        int affectedCount = this.jdbcTemplate.update("delete from t_user_department_role_set where USERID in (select t.id from t_user t where t.id in (:id) and t.DOMAINID=:domainId)", deleteMap);
        return ResponseEntity.ok((Object)affectedCount);
    }

    @PostMapping(value={"/domains/{domainId}/search-permissions"})
    public ResponseEntity batchClear(@PathVariable String domainId, @RequestBody SearchUserRoleRequest request) throws Exception {
        Collection<String> userIds = request.getUserIds();
        HashMap userRoleIdMaps = new HashMap();
        if (!CollectionUtils.isEmpty(userIds)) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("id", userIds);
            parameters.put("domainId", domainId);
            this.jdbcTemplate.query("select USERID,ROLEID from t_user_department_role_set where USERID in (select t.id from t_user t where t.id in (:id) and t.DOMAINID=:domainId)", parameters, rs -> {
                while (rs.next()) {
                    String uId = rs.getString("USERID");
                    String rId = rs.getString("ROLEID");
                    Collection<String> userRoleIds = null;
                    if (!userRoleIdMaps.containsKey(uId)) {
                        userRoleIds = new ArrayList();
                        userRoleIdMaps.put(uId, userRoleIds);
                    } else {
                        userRoleIds = (Collection)userRoleIdMaps.get(uId);
                    }
                    userRoleIds.add(rId);
                }
            });
        }
        ArrayList<UserRoleResponse> userRoleResponses = new ArrayList<UserRoleResponse>();
        if (userRoleIdMaps.size() == 0) {
            return ResponseEntity.ok(userRoleResponses);
        }
        Collection<AppRoleResponse> appRoleResponses = this.getAppsByDomainId(domainId);
        for (String uId : userRoleIdMaps.keySet()) {
            Optional<UserRoleResponse> selectedUserRoleOptional = userRoleResponses.stream().filter(ii -> ii.getUserId().equals(uId)).findFirst();
            UserRoleResponse selectedUserRole = null;
            if (!selectedUserRoleOptional.isPresent()) {
                selectedUserRole = UserRoleResponse.create(uId);
                userRoleResponses.add(selectedUserRole);
            } else {
                selectedUserRole = selectedUserRoleOptional.get();
            }
            Collection roleIds = (Collection)userRoleIdMaps.get(uId);
            for (AppRoleResponse app : appRoleResponses) {
                Collection selectedRoles = app.getRoles().stream().filter(ii -> roleIds.contains(ii.getId())).collect(Collectors.toList());
                if (selectedRoles.size() <= 0) continue;
                UserRoleResponse.UserAppItem appItem = UserRoleResponse.UserAppItem.create(app.getId(), app.getName());
                selectedRoles.forEach(ix -> appItem.assignRole(ix.getId(), ix.getName()));
                selectedUserRole.assignApps(appItem);
            }
        }
        return ResponseEntity.ok(userRoleResponses);
    }

    @GetMapping(value={"/app-roles"})
    public ResponseEntity getAllApps() throws Exception {
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        List apps = appService.list(null, null);
        RoleDesignTimeService roleDesignTimeService = DesignTimeServiceManager.roleDesignTimeService();
        List roles = roleDesignTimeService.list(null, null);
        Collection appRoleResponses = apps.stream().map(ii -> {
            AppRoleResponse arr = AppRoleResponse.create(ii.getId(), ii.getName());
            Collection selectedRoles = roles.stream().filter(ir -> ir.getApplicationid().equals(ii.getId())).map(ir -> AppRoleResponse.RoleItem.create(ir.getId(), ir.getName())).collect(Collectors.toList());
            arr.assignRole(selectedRoles);
            return arr;
        }).collect(Collectors.toList());
        return ResponseEntity.ok((Object)appRoleResponses);
    }

    @GetMapping(value={"/apps/{appName}/forms"})
    public ResponseEntity getAppTables(@PathVariable String appName) throws Exception {
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        Collection appResources = DesignTimeSerializableCache.getResourcesByAppName((String)appName, (String)".form");
        ArrayList tableRs = new ArrayList();
        appResources.forEach(item -> {
            String formId = (String)item.getKey();
            try {
                Form form = (Form)formService.findById(formId);
                if (form == null) {
                    throw new OBPMValidateException("Form: " + formId + " does not exist");
                }
                TableMapping mapping = form.getTableMapping();
                tableRs.add(AppResource.create(formId, (String)item.getValue(), mapping.getTableName()));
            }
            catch (Exception ex) {
                tableRs.add(AppResource.create(formId, (String)item.getValue(), ex));
            }
        });
        return ResponseEntity.ok((Object)Resource.ok(tableRs, (String)tableRs.stream().filter(ii -> ii.getContent() instanceof String).map(ii -> String.valueOf(ii.getContent())).collect(Collectors.joining(";"))));
    }

    @GetMapping(value={"/components/{id}"})
    public ResponseEntity getComponent(@PathVariable String id) {
        FileSystemDesignTimeSerializable component = DesignTimeSerializableCache.get((String)id);
        HashMap<String, String> map = new HashMap<String, String>();
        if (component == null) {
            map.put("data", "\u627e\u4e0d\u5230\u7ec4\u4ef6");
        } else {
            map.put("id", component.getId());
            map.put("url", component.getUri());
            map.put("appId", component.getApplicationid());
            map.put("data", (String)component);
        }
        return ResponseEntity.ok(map);
    }

    @GetMapping(value={"/components-redis/{id}"})
    public ResponseEntity getComponentFromRedis(@PathVariable String id) {
        FileSystemDesignTimeSerializable component = (FileSystemDesignTimeSerializable)this.distributedCacheProvider.get(DesignTimeSerializableCache.getSeriallizableRedisKey((String)id, (boolean)false));
        HashMap<String, String> map = new HashMap<String, String>();
        if (component == null) {
            map.put("data", "\u627e\u4e0d\u5230\u7ec4\u4ef6");
        } else {
            map.put("data", (String)component);
        }
        return ResponseEntity.ok(map);
    }

    @GetMapping(value={"/components/{id}/children"})
    public ResponseEntity getComponentChildren(@PathVariable String id) {
        List components = DesignTimeSerializableCache.getChildens((String)id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty((Collection)components)) {
            map.put("data", "\u627e\u4e0d\u5230\u7ec4\u4ef6");
        } else {
            map.put("parentId", id);
            map.put("data", components);
        }
        return ResponseEntity.ok(map);
    }

    @GetMapping(value={"/components/{id}/{name}"})
    public ResponseEntity getComponentChildrenByName(@PathVariable String id, @PathVariable String name) {
        List components = DesignTimeSerializableCache.getChildens((String)id);
        Collection selectedBeans = components.stream().filter(ii -> ii.getName().equalsIgnoreCase(name)).collect(Collectors.toList());
        return ResponseEntity.ok((Object)selectedBeans);
    }

    @GetMapping(value={"/cache-index"})
    public ResponseEntity getCacheIndex() {
        Map component = DesignTimeSerializableCache.getCacheIndex();
        return ResponseEntity.ok((Object)component);
    }

    @GetMapping(value={"/cache-pid-index"})
    public ResponseEntity getCachePidIndex() {
        Map component = DesignTimeSerializableCache.getCachePidIndex();
        return ResponseEntity.ok((Object)component);
    }

    @GetMapping(value={"/cache-info"})
    public ResponseEntity getCacheInfo() {
        String cacheInfo = DesignTimeSerializableCache.getCacheInfo();
        return ResponseEntity.ok((Object)cacheInfo);
    }

    @GetMapping(value={"/cache-menus"})
    public ResponseEntity getMenus() {
        Map components = DesignTimeSerializableCache.getCachedMenus();
        return ResponseEntity.ok((Object)components);
    }

    @PostMapping(value={"/flush-second-caches"})
    public ResponseEntity flush2SecondCache() {
        boolean flag = DesignTimeSerializableCache.flush2SecondCached();
        return ResponseEntity.ok((Object)flag);
    }

    @PostMapping(value={"/disabled-second-caches"})
    public ResponseEntity disabled2SecondCache() {
        boolean flag = DesignTimeSerializableCache.disableSecondCache();
        return ResponseEntity.ok((Object)flag);
    }

    @PostMapping(value={"/components/redis/keys"})
    public ResponseEntity getRedisKeys() {
        Collection keys = DesignTimeSerializableCache.getAllRedisKeys();
        return ResponseEntity.ok((Object)keys);
    }

    @PostMapping(value={"/javascript-execute/{appId}/unregister"})
    public ResponseEntity unregister(@PathVariable String appId) {
        RhinoJavaScriptCompiler rhinoJavaScriptCompiler = (RhinoJavaScriptCompiler)SpringApplicationContextUtil.getBean(RhinoJavaScriptCompiler.class);
        rhinoJavaScriptCompiler.unRegister(appId);
        Collection registeredKeys = rhinoJavaScriptCompiler.getRegisteredKeys();
        return ResponseEntity.ok((Object)registeredKeys);
    }

    @GetMapping(value={"/javascript-execute/{appId}"})
    public ResponseEntity getRegistered(@PathVariable String appId) {
        RhinoJavaScriptCompiler rhinoJavaScriptCompiler = (RhinoJavaScriptCompiler)SpringApplicationContextUtil.getBean(RhinoJavaScriptCompiler.class);
        Collection registeredKeys = rhinoJavaScriptCompiler.getRegisteredKeys(appId);
        return ResponseEntity.ok((Object)registeredKeys);
    }

    private Collection<AppRoleResponse> getAppsByDomainId(String domainId) throws Exception {
        DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
        DomainVO domain = (DomainVO)domainProcess.doView(domainId);
        if (domain == null) {
            throw new SaasNofoundException("\u627e\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f");
        }
        ApplicationDesignTimeService service = DesignTimeServiceManager.applicationDesignTimeService();
        List list = service.list(null, null);
        Collection bindApplications = domain.getApplications();
        ArrayList<Application> items = new ArrayList<Application>();
        for (Application app : list) {
            if (app.getType() == 2 || !app.isActivated()) continue;
            boolean isBind = false;
            for (Application bindApp : bindApplications) {
                if (!app.getId().equals(bindApp.getId())) continue;
                isBind = true;
                break;
            }
            if (!isBind) continue;
            items.add(app);
        }
        return this.getAppRoles(items);
    }

    private Collection<AppRoleResponse> getAppRoles(Collection<Application> myApps) throws Exception {
        RoleDesignTimeService roleProcess = AuthTimeServiceManager.roleRuntimeService();
        return myApps.stream().map(appVo -> {
            try {
                AppRoleResponse appR = AppRoleResponse.create(appVo.getId(), appVo.getName());
                DataPackage dataPackage = null;
                dataPackage = roleProcess.query(appVo.getId(), null, 1, Integer.MAX_VALUE);
                Collection roles = dataPackage.getDatas().stream().map(r -> AppRoleResponse.RoleItem.create(r.getId(), r.getName())).collect(Collectors.toList());
                appR.assignRole(roles);
                return appR;
            }
            catch (Exception e) {
                throw new SaasBadException("\u83b7\u53d6\u5e94\u7528\u89d2\u8272\u5f02\u5e38");
            }
        }).collect(Collectors.toList());
    }

    @Transactional
    protected void doUpdateUserRoles(String domainId, Collection<UserVO> userVOS, Collection<String> roleIds) {
        Collection userIds = userVOS.stream().map(ii -> ii.getId()).filter(ii -> StringUtils.hasLength((String)ii)).distinct().collect(Collectors.toList());
        roleIds = roleIds.stream().filter(ii -> StringUtils.hasLength((String)ii)).distinct().collect(Collectors.toList());
        HashMap<String, Object> deleteMap = new HashMap<String, Object>();
        deleteMap.put("id", userIds);
        deleteMap.put("domainId", domainId);
        int affectedCount = this.jdbcTemplate.update("delete from t_user_department_role_set where USERID in (select t.id from t_user t where t.id in (:id) and t.DOMAINID=:domainId)", deleteMap);
        ArrayList parameters = new ArrayList();
        for (UserVO userVO : userVOS) {
            for (String roleId : roleIds) {
                HashMap<String, String> pm = new HashMap<String, String>();
                String selectedDepartId = null;
                if (userVO.getUserDepartmentRoleSets() != null && userVO.getUserDepartmentRoleSets().size() > 0) {
                    selectedDepartId = ((UserDepartmentRoleSet)userVO.getUserDepartmentRoleSets().stream().findFirst().get()).getDepartmentId();
                }
                if (!StringUtils.hasLength(selectedDepartId) && userVO.getDepartments() != null && userVO.getDepartments().size() > 0) {
                    selectedDepartId = ((DepartmentVO)userVO.getDepartments().stream().findFirst().get()).getId();
                }
                if (!StringUtils.hasLength(selectedDepartId)) {
                    selectedDepartId = userVO.getDefaultDepartment();
                }
                pm.put("id", UUID.randomUUID().toString());
                pm.put("departId", selectedDepartId);
                pm.put("userId", userVO.getId());
                pm.put("roleId", roleId);
                parameters.add(pm);
            }
        }
        int[] affectedCounts = this.jdbcTemplate.batchUpdate("insert into t_user_department_role_set(id,DEPARTMENTID,USERID,ROLEID) values(:id,:departId,:userId,:roleId)", parameters.toArray(new Map[parameters.size()]));
    }
}

