/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.runtime.apis.components;

import cn.myapps.components.SettingProvider;
import com.bcxin.runtime.domain.metas.repositories.SettingMetaRepository;
import com.bcxin.saas.core.components.CacheProvider;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class SettingProviderImpl
implements SettingProvider {
    private final SettingMetaRepository settingMetaRepository;
    private final CacheProvider cacheProvider;

    public SettingProviderImpl(SettingMetaRepository settingMetaRepository, CacheProvider cacheProvider) {
        this.settingMetaRepository = settingMetaRepository;
        this.cacheProvider = cacheProvider;
    }

    public String getSettingWithCache(String category, String key, int seconds) {
        return (String)this.cacheProvider.getData(String.format("cache_expired_setting_%s_%s", category, key), () -> {
            String value = this.settingMetaRepository.getValueByCategoryAndKey(category, key);
            return value;
        }, seconds);
    }

    public String getSetting(String category, String key) {
        return (String)this.cacheProvider.getData(String.format("setting_%s_%s", category, key), () -> {
            String value = this.settingMetaRepository.getValueByCategoryAndKey(category, key);
            return value;
        });
    }
}

