CREATE DATABASE IF NOT EXISTS obpm2 DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_general_ci; 
use obpm2; 
/*
Navicat MySQL Data Transfer

Source Server         : 192.168.88.123
Source Server Version : 50722
Source Host           : 192.168.88.123:3307
Source Database       : obpm2

Target Server Type    : MYSQL
Target Server Version : 50722
File Encoding         : 65001

Date: 2021-03-24 21:04:03
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for t_calendar
-- ----------------------------
DROP TABLE IF EXISTS `t_calendar`;
CREATE TABLE `t_calendar` (
  `ID` varchar(255) NOT NULL,
  `CALENDARTYPE` varchar(255) DEFAULT NULL,
  `CALENDARNAME` varchar(255) DEFAULT NULL,
  `LASTMODIFYDATE` datetime DEFAULT NULL,
  `SORTID` varchar(255) DEFAULT NULL,
  `DOMAINID` varchar(255) DEFAULT NULL,
  `REMARK` varchar(255) DEFAULT NULL,
  `WORKINGTIME` int(11) DEFAULT NULL,
  `FROMCALENDARID` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_calendar
-- ----------------------------
INSERT INTO `t_calendar` VALUES ('HmKdJTD3m76sGFo45Ob', 'Eight_TimeZone', '24小时日历', '2018-12-24 09:16:16', '154561417645400000', '3CffNlgt9B9StIjIUPB', 'core.workcalendar.24.calendarinfo', '24', null);
INSERT INTO `t_calendar` VALUES ('i7xj207zBMEwBp8aATE', 'Eight_TimeZone', '夜班日历', '2018-11-28 16:08:36', '154339251609900000', '3CffNlgt9B9StIjIUPB', 'core.workcalendar.night.calendarinfo', '8', null);
INSERT INTO `t_calendar` VALUES ('qCv88TplkcYoiGxMhJ8', 'Eight_TimeZone', '标准日历测试', '2019-01-23 16:13:42', '154823122227200000', '3CffNlgt9B9StIjIUPB', '标准日历测试', '8', null);
INSERT INTO `t_calendar` VALUES ('ZKsRAyDrAP7u0NKPQdR', 'Eight_TimeZone', '标准日历', '2018-11-28 16:08:36', '154339251598300000', '3CffNlgt9B9StIjIUPB', 'core.workcalendar.standard.calendarinfo', '8', null);

-- ----------------------------
-- Table structure for t_department
-- ----------------------------
DROP TABLE IF EXISTS `t_department`;
CREATE TABLE `t_department` (
  `ID` varchar(255) NOT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `SUPERIOR` varchar(255) DEFAULT NULL,
  `DOMAIN_ID` varchar(255) DEFAULT NULL,
  `LEVELS` int(11) DEFAULT NULL,
  `INDEXCODE` varchar(1000) DEFAULT NULL,
  `CODE` varchar(255) DEFAULT NULL,
  `SORTID` varchar(255) DEFAULT NULL,
  `VALID` int(11) DEFAULT '1',
  `ORDERBYNO` int(11) DEFAULT '10000',
  `WEIXIN_DEPT_ID` varchar(255) DEFAULT NULL,
  `LANXIN_DEPT_ID` varchar(255) DEFAULT NULL,
  `FIELD1` varchar(255) DEFAULT NULL,
  `FIELD2` varchar(255) DEFAULT NULL,
  `FIELD3` varchar(255) DEFAULT NULL,
  `FIELD4` varchar(255) DEFAULT NULL,
  `FIELD5` varchar(255) DEFAULT NULL,
  `FIELD6` varchar(255) DEFAULT NULL,
  `FIELD7` varchar(255) DEFAULT NULL,
  `FIELD8` varchar(255) DEFAULT NULL,
  `FIELD9` varchar(255) DEFAULT NULL,
  `FIELD10` varchar(255) DEFAULT NULL,
  `DINGDING_DEPT_ID` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `FK16A0C81D66C7842` (`DOMAIN_ID`) USING BTREE,
  KEY `FK16A0C81DF21BF5BD` (`SUPERIOR`) USING BTREE,
  KEY `index_ORDERBYNO` (`ORDERBYNO`) USING BTREE,
  CONSTRAINT `FK16A0C81D66C7842` FOREIGN KEY (`DOMAIN_ID`) REFERENCES `t_domain` (`ID`),
  CONSTRAINT `FK16A0C81DF21BF5BD` FOREIGN KEY (`SUPERIOR`) REFERENCES `t_department` (`ID`),
  CONSTRAINT `FKbcc5wye8i4vdb6wj7pojlclqj` FOREIGN KEY (`SUPERIOR`) REFERENCES `t_department` (`ID`),
  CONSTRAINT `FKtoe32rcaxqeqaep7rirky2cw9` FOREIGN KEY (`DOMAIN_ID`) REFERENCES `t_domain` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_department
-- ----------------------------
INSERT INTO `t_department` VALUES ('Z42xU8LmniRouZ93E7s', '总部', null, '3CffNlgt9B9StIjIUPB', '0', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s', '1', null, '1', '0', '1', null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__1O6N87wXdMfakt5tp6t', '销售二部2组', '__L9q75cTkzfjfBAEnO0H', '3CffNlgt9B9StIjIUPB', '3', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___bZiGACxcLs4FH8O8eTt___L9q75cTkzfjfBAEnO0H___1O6N87wXdMfakt5tp6t', null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__1z4dcx8FPx8xqoqBeAI', '销售一部2组', '__F2dZHD2K6nRnFUEZd0R', '3CffNlgt9B9StIjIUPB', '3', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___bZiGACxcLs4FH8O8eTt___F2dZHD2K6nRnFUEZd0R___1z4dcx8FPx8xqoqBeAI', null, null, '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__2Lc6K6lsEggXShMgQsf', '后端组', '__7AR6G1T02Nb55labPkr', '3CffNlgt9B9StIjIUPB', '2', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___7AR6G1T02Nb55labPkr___2Lc6K6lsEggXShMgQsf', null, '161277279013400000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__7AR6G1T02Nb55labPkr', '技术部', 'Z42xU8LmniRouZ93E7s', '3CffNlgt9B9StIjIUPB', '1', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___7AR6G1T02Nb55labPkr', null, '161277275760400000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__BbX5GmUz8om72ICA781', '后勤部', 'Z42xU8LmniRouZ93E7s', '3CffNlgt9B9StIjIUPB', '1', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___BbX5GmUz8om72ICA781', null, '161277277176200000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__BtjNSK3rxFefk6kbGwD', '销售一部1组', '__F2dZHD2K6nRnFUEZd0R', '3CffNlgt9B9StIjIUPB', '3', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___bZiGACxcLs4FH8O8eTt___F2dZHD2K6nRnFUEZd0R___BtjNSK3rxFefk6kbGwD', null, '161277296271400000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__BV9QzANmqxdwfi5QXUC', '前端组', '__7AR6G1T02Nb55labPkr', '3CffNlgt9B9StIjIUPB', '2', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___7AR6G1T02Nb55labPkr___BV9QzANmqxdwfi5QXUC', null, '161277279878700000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__BvI1o4ixaRoOm4sXFTQ', '财务部', '__BbX5GmUz8om72ICA781', '3CffNlgt9B9StIjIUPB', '2', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___BbX5GmUz8om72ICA781___BvI1o4ixaRoOm4sXFTQ', null, '161277286868500000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__bZiGACxcLs4FH8O8eTt', '销售部', 'Z42xU8LmniRouZ93E7s', '3CffNlgt9B9StIjIUPB', '1', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___bZiGACxcLs4FH8O8eTt', null, '161277273863900000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__Eb6u6iGjMKhkEK0RC8a', '销售二部1组', '__L9q75cTkzfjfBAEnO0H', '3CffNlgt9B9StIjIUPB', '3', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___bZiGACxcLs4FH8O8eTt___L9q75cTkzfjfBAEnO0H___Eb6u6iGjMKhkEK0RC8a', null, '161277299296300000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__F2dZHD2K6nRnFUEZd0R', '销售一部', '__bZiGACxcLs4FH8O8eTt', '3CffNlgt9B9StIjIUPB', '2', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___bZiGACxcLs4FH8O8eTt___F2dZHD2K6nRnFUEZd0R', null, '161277288630600000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__Jv6BqX9CRtC9rIW5Gha', '推广组', '__lBTr7YmXnkH1RaqPLlz', '3CffNlgt9B9StIjIUPB', '2', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___lBTr7YmXnkH1RaqPLlz___Jv6BqX9CRtC9rIW5Gha', null, '161277307368200000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__KbYVmFf5gJ88mIIi10v', '售后组', '__7AR6G1T02Nb55labPkr', '3CffNlgt9B9StIjIUPB', '2', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___7AR6G1T02Nb55labPkr___KbYVmFf5gJ88mIIi10v', null, '161277280800300000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__L9q75cTkzfjfBAEnO0H', '销售二部', '__bZiGACxcLs4FH8O8eTt', '3CffNlgt9B9StIjIUPB', '2', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___bZiGACxcLs4FH8O8eTt___L9q75cTkzfjfBAEnO0H', null, '161277289493800000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__lBTr7YmXnkH1RaqPLlz', '市场部', 'Z42xU8LmniRouZ93E7s', '3CffNlgt9B9StIjIUPB', '1', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___lBTr7YmXnkH1RaqPLlz', null, '161277275187500000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__LhYkQakjdJUq7eKWpMa', '人事部', '__BbX5GmUz8om72ICA781', '3CffNlgt9B9StIjIUPB', '2', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___BbX5GmUz8om72ICA781___LhYkQakjdJUq7eKWpMa', null, '161277286078900000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__Qnkm2kUMDGqnUDGa9u0', '运营组', '__lBTr7YmXnkH1RaqPLlz', '3CffNlgt9B9StIjIUPB', '2', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___lBTr7YmXnkH1RaqPLlz___Qnkm2kUMDGqnUDGa9u0', null, '161277308659800000', '1', '1', null, null, null, null, null, null, null, null, null, null, null, null, null);
INSERT INTO `t_department` VALUES ('__XbhgoVGgCCmZ4WiYYtB', '测试组', '__7AR6G1T02Nb55labPkr', '3CffNlgt9B9StIjIUPB', '2', '5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___7AR6G1T02Nb55labPkr___XbhgoVGgCCmZ4WiYYtB', null, '161277281636300000', '1', '0', null, null, null, null, null, null, null, null, null, null, null, null, null);

-- ----------------------------
-- Table structure for t_domain
-- ----------------------------
DROP TABLE IF EXISTS `t_domain`;
CREATE TABLE `t_domain` (
  `ID` varchar(255) NOT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `SORTID` varchar(255) DEFAULT NULL,
  `SKINTYPE` varchar(255) DEFAULT NULL,
  `DESCRIPTION` text,
  `STATUS` int(11) DEFAULT NULL,
  `SMSMEMBERCODE` varchar(255) DEFAULT NULL,
  `SMSMEMBERPWD` varchar(255) DEFAULT NULL,
  `IS_LOG` bit(1) DEFAULT NULL,
  `SYSTEM_NAME` varchar(255) DEFAULT NULL,
  `LOGO_URL` varchar(255) DEFAULT NULL,
  `WEIXIN_CORP_ID` varchar(255) DEFAULT NULL,
  `WEIXIN_CORP_SECRET` varchar(255) DEFAULT NULL,
  `WEIXIN_AGENT_ID` varchar(255) DEFAULT NULL,
  `WEIXIN_PROXY_TYPE` varchar(255) DEFAULT NULL,
  `SERVER_HOST` varchar(255) DEFAULT NULL,
  `WEIXIN_TOKEN` varchar(255) DEFAULT NULL,
  `WEIXIN_ENCODING_AESKEY` varchar(255) DEFAULT NULL,
  `SYSTEM_MODULE_CONFIG` text,
  `BIND_APPLICATIONS` varchar(1000) DEFAULT NULL,
  `WEIXIN_CONFIG` text,
  `SEND_HOST` varchar(255) DEFAULT NULL,
  `SEND_ADDRESS` varchar(255) DEFAULT NULL,
  `SEND_ACCOUNT` varchar(255) DEFAULT NULL,
  `SEND_PASSWORD` varchar(255) DEFAULT NULL,
  `CC_ADDRESS` varchar(255) DEFAULT NULL,
  `ISUSE_CLIENT` varchar(255) DEFAULT NULL,
  `FUNCTION_DOMAIN` varchar(255) DEFAULT NULL,
  `TRASH` varchar(255) DEFAULT NULL,
  `SENDER` varchar(255) DEFAULT NULL,
  `DRAFT` varchar(255) DEFAULT NULL,
  `REMOVED` varchar(255) DEFAULT NULL,
  `FETCH_SERVER` varchar(255) DEFAULT NULL,
  `FETCH_SERVER_PORT` varchar(255) DEFAULT NULL,
  `FETCH_PROTOCOL` varchar(255) DEFAULT NULL,
  `FETCH_SSL` varchar(255) DEFAULT NULL,
  `SMTP_SERVER` varchar(255) DEFAULT NULL,
  `SMTP_SERVER_PORT` varchar(255) DEFAULT NULL,
  `SMTP_AUTH_ENTICATED` varchar(255) DEFAULT NULL,
  `SMTP_SSL` varchar(255) DEFAULT NULL,
  `WEIXIN_QRCODE_AGENTID` varchar(255) DEFAULT NULL,
  `WEIXIN_QRCODE_SECRET` varchar(255) DEFAULT NULL,
  `WEIXIN_QRCODE_CALLBACKURL` varchar(255) DEFAULT NULL,
  `DINGDING_QRCODE_APPID` varchar(255) DEFAULT NULL,
  `DINGDING_QRCODE_APPSECRET` varchar(255) DEFAULT NULL,
  `DINGDING_QRCODE_CALLBACKURL` varchar(255) DEFAULT NULL,
  `DINGDING_PROXY_TYPE` varchar(255) DEFAULT NULL,
  `DINGDING_CORP_ID` varchar(255) DEFAULT NULL,
  `DINGDING_APP_SECRET` varchar(255) DEFAULT NULL,
  `DINGDING_APP_KEY` varchar(255) DEFAULT NULL,
  `DINGDING_AGENT_ID` varchar(255) DEFAULT NULL,
  `DINGDING_SERVER_HOST` varchar(255) DEFAULT NULL,
  `DINGDING_TOKEN` varchar(255) DEFAULT NULL,
  `DINGDING_CONFIG` longtext,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_domain
-- ----------------------------
INSERT INTO `t_domain` VALUES ('3CffNlgt9B9StIjIUPB', '公司域管理', '154339251588900000', 'good', '公司域管理', '1', 'sam_hr', '123456', '', '', '', 'ww4862e4c6416306be', '0SAub-YPjKrBuCUjFtBMOh1sPaiFLrkS28oVP-ZbeMU', '0', 'EnterpriseWeChat', 'http://office.teemlink.com:65533/obpm', null, '', '{\"amEnable\":true,\"cmEnable\":true,\"kmEnable\":true,\"kmRealmEnable\":true,\"kmTeamEnable\":true,\"pcmEnable\":true,\"pmEnable\":true,\"qmEnable\":true}', '[\"HdPeBqYwJyFyjHkhZu3\",\"FxsrYPpnxAFvmLWUsuv\",\"__6L7jV0BIHtm5CAMnelL\",\"cuKp8Z9u92TnzhbiH8u\",\"sOZu9kthmxyP8qQfq0e\"]', '{\"weixinAgentId\":{\"HdPeBqYwJyFyjHkhZu3\":\"1000009\",\"pm\":\"1000010\"},\"weixinSecret\":{\"HdPeBqYwJyFyjHkhZu3\":\"Ya8Ioa-qGJTEs506n0jLNZR1KrofzjyQLEgVRXBZTt8\",\"pm\":\"lp8pG6M_yb-YbjbJi45XssdvkYQ_G0omJkrHsp5ua4Y\"}}', 'smtp.exmail.qq.com', 'nicole@teemlink.com', 'nicole@teemlink.com', 'MyWAdC2ThUJoJgZa', '', 'true', 'teemlink.com', 'Junk E-mail', 'Sent Items', 'Drafts', 'removed', 'imap.exmail.qq.com', '993', 'imap', 'false', 'smtp.exmail.qq.com', '465', 'true', 'false', null, null, null, null, null, null, null, null, null, null, null, null, null, '{\"dingdingAgentId\":null,\"dingdingAppKey\":null,\"dingdingAppSecret\":null}');

-- ----------------------------
-- Table structure for t_email
-- ----------------------------
DROP TABLE IF EXISTS `t_email`;
CREATE TABLE `t_email` (
  `ID` varchar(255) NOT NULL,
  `ISREAD` bit(1) DEFAULT NULL,
  `ISREPLY` bit(1) DEFAULT NULL,
  `ISFORWARD` bit(1) DEFAULT NULL,
  `EMAILFOLDERID` varchar(255) DEFAULT NULL,
  `READDATE` datetime DEFAULT NULL,
  `EMAILID` bigint(20) DEFAULT NULL,
  `EMAINL_BODY_ID` varchar(255) DEFAULT NULL,
  `EMAINL_USER_ID` varchar(255) DEFAULT NULL,
  `MSGLEVEL` int(11) DEFAULT '0',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `FK19827D166C7D84E` (`EMAINL_USER_ID`) USING BTREE,
  KEY `FK19827D1BBD9A18A` (`EMAILFOLDERID`) USING BTREE,
  KEY `FK19827D172CA74EE` (`EMAINL_BODY_ID`) USING BTREE,
  CONSTRAINT `FK19827D166C7D84E` FOREIGN KEY (`EMAINL_USER_ID`) REFERENCES `t_email_user` (`ID`),
  CONSTRAINT `FK19827D172CA74EE` FOREIGN KEY (`EMAINL_BODY_ID`) REFERENCES `t_email_body` (`ID`),
  CONSTRAINT `FK19827D1BBD9A18A` FOREIGN KEY (`EMAILFOLDERID`) REFERENCES `t_email_folder` (`ID`),
  CONSTRAINT `FKdhq88koqgymslx3q9nrgtmkl1` FOREIGN KEY (`EMAILFOLDERID`) REFERENCES `t_email_folder` (`ID`),
  CONSTRAINT `FKp2w76bs1dq5bf4hxtty7pfpip` FOREIGN KEY (`EMAINL_BODY_ID`) REFERENCES `t_email_body` (`ID`),
  CONSTRAINT `FKpb261wtog2c90djd9ic4tboin` FOREIGN KEY (`EMAINL_USER_ID`) REFERENCES `t_email_user` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_email
-- ----------------------------

-- ----------------------------
-- Table structure for t_email_attachment
-- ----------------------------
DROP TABLE IF EXISTS `t_email_attachment`;
CREATE TABLE `t_email_attachment` (
  `ID` varchar(255) NOT NULL,
  `EMAILBODY_ID` varchar(255) DEFAULT NULL,
  `FILENAME` varchar(255) DEFAULT NULL,
  `REALFILENAME` varchar(255) DEFAULT NULL,
  `FILETEXT` tinyblob,
  `PATH` varchar(255) DEFAULT NULL,
  `SORTID` varchar(255) DEFAULT NULL,
  `CREATDATE` datetime DEFAULT NULL,
  `FILESIZE` bigint(20) DEFAULT NULL,
  `EMAILID` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `FKD06116515CC0C083` (`EMAILBODY_ID`) USING BTREE,
  CONSTRAINT `FKD06116515CC0C083` FOREIGN KEY (`EMAILBODY_ID`) REFERENCES `t_email_body` (`ID`),
  CONSTRAINT `FKc1x6h67al5etjrsaa0l9v8ehm` FOREIGN KEY (`EMAILBODY_ID`) REFERENCES `t_email_body` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_email_attachment
-- ----------------------------

-- ----------------------------
-- Table structure for t_email_body
-- ----------------------------
DROP TABLE IF EXISTS `t_email_body`;
CREATE TABLE `t_email_body` (
  `ID` varchar(255) NOT NULL,
  `SUBJECT` varchar(255) DEFAULT NULL,
  `CONTENT` text,
  `E_FROM` varchar(255) DEFAULT NULL,
  `RE_TO` text,
  `RE_CC` text,
  `RE_BCC` text,
  `SENDDATE` datetime DEFAULT NULL,
  `E_FROMDEP` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_email_body
-- ----------------------------

-- ----------------------------
-- Table structure for t_email_folder
-- ----------------------------
DROP TABLE IF EXISTS `t_email_folder`;
CREATE TABLE `t_email_folder` (
  `ID` varchar(255) NOT NULL,
  `OWNERID` varchar(255) DEFAULT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `DISPLAYNAME` varchar(255) DEFAULT NULL,
  `CREATDATE` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_email_folder
-- ----------------------------

-- ----------------------------
-- Table structure for t_email_user
-- ----------------------------
DROP TABLE IF EXISTS `t_email_user`;
CREATE TABLE `t_email_user` (
  `ID` varchar(255) NOT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `ACCOUNT` varchar(255) DEFAULT NULL,
  `PASSWORD` varchar(255) DEFAULT NULL,
  `OWNERID` varchar(255) DEFAULT NULL,
  `CREATEDATE` datetime DEFAULT NULL,
  `DOMAINID` varchar(255) DEFAULT NULL,
  `DEFAULTDEPARTMENT` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_email_user
-- ----------------------------

-- ----------------------------
-- Table structure for t_field_extends
-- ----------------------------
DROP TABLE IF EXISTS `t_field_extends`;
CREATE TABLE `t_field_extends` (
  `ID` varchar(255) NOT NULL,
  `FOR_TABLE` varchar(255) DEFAULT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `LABEL` varchar(255) DEFAULT NULL,
  `TYPE` varchar(255) DEFAULT NULL,
  `IS_NULL` bit(1) DEFAULT NULL,
  `ENABEL` bit(1) DEFAULT NULL,
  `SORT_NUMBER` int(11) DEFAULT NULL,
  `DOMAINID` varchar(255) DEFAULT NULL,
  `IS_NOT_NULL` bit(1) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_field_extends
-- ----------------------------

-- ----------------------------
-- Table structure for t_htmlhistory
-- ----------------------------
DROP TABLE IF EXISTS `t_htmlhistory`;
CREATE TABLE `t_htmlhistory` (
  `ID` varchar(255) NOT NULL,
  `DocumentID` varchar(50) DEFAULT NULL,
  `SignatureID` varchar(50) DEFAULT NULL,
  `SignatureName` varchar(50) DEFAULT NULL,
  `SignatureUnit` varchar(50) DEFAULT NULL,
  `SignatureUser` varchar(50) DEFAULT NULL,
  `KeySN` varchar(50) DEFAULT NULL,
  `SignatureSN` varchar(200) DEFAULT NULL,
  `SignatureGUID` varchar(50) DEFAULT NULL,
  `IP` varchar(50) DEFAULT NULL,
  `LogType` varchar(255) DEFAULT NULL,
  `LogTime` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_htmlhistory
-- ----------------------------

-- ----------------------------
-- Table structure for t_htmlsignature
-- ----------------------------
DROP TABLE IF EXISTS `t_htmlsignature`;
CREATE TABLE `t_htmlsignature` (
  `SignatureID` varchar(255) NOT NULL,
  `DocumentID` varchar(254) DEFAULT NULL,
  `FormID` varchar(254) DEFAULT NULL,
  `Signature` text,
  PRIMARY KEY (`SignatureID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_htmlsignature
-- ----------------------------

-- ----------------------------
-- Table structure for t_link
-- ----------------------------
DROP TABLE IF EXISTS `t_link`;
CREATE TABLE `t_link` (
  `ID` varchar(255) NOT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `DESCRIPTION` varchar(255) DEFAULT NULL,
  `TYPE` varchar(255) DEFAULT NULL,
  `APPLICATIONID` varchar(255) DEFAULT NULL,
  `MODULEID` varchar(255) DEFAULT NULL,
  `ACTIONCONTENT` varchar(2000) DEFAULT NULL,
  `QUERYSTRING` text,
  `DIRECTORY` varchar(255) DEFAULT NULL,
  `SORTID` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_link
-- ----------------------------
INSERT INTO `t_link` VALUES ('ePWALJY9is8TJ8Mdnag', '', '', '选择', 'HdPeBqYwJyFyjHkhZu3', '', '', '[]', 'portal', '155252843224200000');
INSERT INTO `t_link` VALUES ('RYsu3f2xt4zQqCOTH3x', '', '', '选择', 'HdPeBqYwJyFyjHkhZu3', '', '', '[]', 'portal', '155252844356800000');
INSERT INTO `t_link` VALUES ('sudgq6AlGXQmtUEwMKM', '新建', '', '00', 'HdPeBqYwJyFyjHkhZu3', 'tt2VKz8CkCFqA0x15AF', '6esIc2fTAI9nAOoOZcp', '[]', 'portal', '154461559411600000');
INSERT INTO `t_link` VALUES ('UkgE0A43OGmcYn5rNQM', '角色1', '', '01', 'HdPeBqYwJyFyjHkhZu3', 'HlKn0JFp8Tkon99m4IW', 'Gc5icb2c0g8ARf7Jath', '[]', 'portal', '155247333754800000');
INSERT INTO `t_link` VALUES ('zzPKKonhRQBpW40m2CM', '树形视图_链接', '', '00', 'HdPeBqYwJyFyjHkhZu3', 'zInRtbIrHN33clA2IEo', 'gniImP2ug7E82S1WO0L', '[]', 'portal', '155246969769600000');

-- ----------------------------
-- Table structure for t_log
-- ----------------------------
DROP TABLE IF EXISTS `t_log`;
CREATE TABLE `t_log` (
  `ID` varchar(255) NOT NULL,
  `USER_ID` varchar(255) DEFAULT NULL,
  `OPERATOR` varchar(255) DEFAULT NULL,
  `DESCRIPTION` varchar(255) DEFAULT NULL,
  `TYPE` varchar(255) DEFAULT NULL,
  `IP` varchar(255) DEFAULT NULL,
  `APPLICATIONID` varchar(255) DEFAULT NULL,
  `DOMAINID` varchar(255) DEFAULT NULL,
  `LOGDATE` datetime DEFAULT NULL,
  `SORTID` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `FK4CC0CB97093493B` (`USER_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_log
-- ----------------------------
INSERT INTO `t_log` VALUES ('C3l3UDV71ER1HA1aiYZ', '__oP0irhWXGA2oZRusW1d', '系统管理员', '{*[Login]*}{*[System]*}', '{*[Login]*}', '192.168.88.1', null, '3CffNlgt9B9StIjIUPB', '2021-02-08 17:15:20', '161277571959800000');
INSERT INTO `t_log` VALUES ('uOqpi4AuKUzsEAIsupE', '__oP0irhWXGA2oZRusW1d', '系统管理员', '{*[Login]*}{*[System]*}', '{*[Login]*}', '192.168.88.1', null, '3CffNlgt9B9StIjIUPB', '2021-02-19 11:18:04', '161370468358000000');
INSERT INTO `t_log` VALUES ('VR791gCm8e3gn13NInv', '__oP0irhWXGA2oZRusW1d', '系统管理员', '{*[Login]*}{*[System]*}', '{*[Login]*}', '192.168.88.1', null, '3CffNlgt9B9StIjIUPB', '2021-03-24 21:04:24', '161659106371000000');
INSERT INTO `t_log` VALUES ('__02Pvq7UjNLDL9tJ0Ctq', null, 'Admin', '更新部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:30:36', '161277303608700000');
INSERT INTO `t_log` VALUES ('__04OFroMJHQoWoURqRo5', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:55:05', '161277450468300000');
INSERT INTO `t_log` VALUES ('__0DbsQBx7mQ8PtK5Cyv6', null, 'Admin', '保存邮件配置', '企业域', '192.168.88.1', null, null, '2021-02-19 11:39:33', '161370597311300000');
INSERT INTO `t_log` VALUES ('__0GVKEKLuRld9S0T9zOv', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:22:59', '161277257881100000');
INSERT INTO `t_log` VALUES ('__0t01qq4pBSWcWRpz7nC', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:50:05', '161277420492500000');
INSERT INTO `t_log` VALUES ('__10AIN5JXJFgimAEY7gx', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:29:23', '161277296272800000');
INSERT INTO `t_log` VALUES ('__135P1kpPDow0DHr6wGz', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:41:31', '161277369086500000');
INSERT INTO `t_log` VALUES ('__1ngjzIDFAHdLLbdvhh3', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:29:53', '161277299297300000');
INSERT INTO `t_log` VALUES ('__2aARfbxlx2RM7w7xa82', null, 'Admin', '删除用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:21:18', '161277247798800000');
INSERT INTO `t_log` VALUES ('__3y5DkXu6em5iDA3zb7k', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:35:37', '161277333689000000');
INSERT INTO `t_log` VALUES ('__40Q58AsWBoObrrIoFNp', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:31:27', '161277308660200000');
INSERT INTO `t_log` VALUES ('__4ajLcOYCfIPvWgio0Xd', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:29:38', '161277297837600000');
INSERT INTO `t_log` VALUES ('__4Bn1uhxAHMwnbymNwip', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:48:20', '161277409960500000');
INSERT INTO `t_log` VALUES ('__4Cnb0s4kCfXChRX52O7', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:23:43', '161277262331400000');
INSERT INTO `t_log` VALUES ('__4SMjlJbPTeiKzq8taQK', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:39:21', '161277356061800000');
INSERT INTO `t_log` VALUES ('__4xy5zBsJuuDvZZZlVic', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:26:56', '161277281636900000');
INSERT INTO `t_log` VALUES ('__5DhEwTv06eCSHJYPe73', null, 'Admin', '更新用户', '企业域', '0:0:0:0:0:0:0:1', null, null, '2021-02-02 16:04:10', '161225304958900000');
INSERT INTO `t_log` VALUES ('__5jJaFR2RXyfrydgPwFj', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:35:44', '161277334395300000');
INSERT INTO `t_log` VALUES ('__5pKACPrqd7UCv3dyjuz', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:22:52', '161277257185400000');
INSERT INTO `t_log` VALUES ('__5svJGSnDRqoSEuTMuf7', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:22:04', '161277252407400000');
INSERT INTO `t_log` VALUES ('__5w9nmkHZiCBOIoE4ara', null, 'Admin', '删除用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:21:29', '161277248897600000');
INSERT INTO `t_log` VALUES ('__60eKH0tl10tp9WTKhl7', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:28:06', '161277288631000000');
INSERT INTO `t_log` VALUES ('__6eNfvtiVnEecZ9F3JIA', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:26:30', '161277279013900000');
INSERT INTO `t_log` VALUES ('__7KpU9O1c1SwjpUCOY4c', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:23:40', '161277262000800000');
INSERT INTO `t_log` VALUES ('__8H5zRoMGJCHRWtNxlHX', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:36:19', '161277337897500000');
INSERT INTO `t_log` VALUES ('__8KHjwtd4bErkqXkFLiF', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 17:09:14', '161277535419100000');
INSERT INTO `t_log` VALUES ('__9gyhspwAbCXlHonWJIV', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:23:21', '161277260101900000');
INSERT INTO `t_log` VALUES ('__9LgL32PdrUvvfP0iawn', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:49:12', '161277415181000000');
INSERT INTO `t_log` VALUES ('__9rDefGTm2vuJA7d0B3H', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:41:29', '161277368911600000');
INSERT INTO `t_log` VALUES ('__9wS5ABtKj4a1RDkd6Ce', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:50:56', '161277425627600000');
INSERT INTO `t_log` VALUES ('__ahdNSF83tfawRRYU2gs', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:23:09', '161277258889700000');
INSERT INTO `t_log` VALUES ('__Am0oYAUQKGh82bdggj2', '__oP0irhWXGA2oZRusW1d', '系统管理员', '{*[Form]*}-串行流程', '提交', '192.168.88.1', 'sOZu9kthmxyP8qQfq0e', '3CffNlgt9B9StIjIUPB', '2021-02-08 17:18:20', '161277589973000000');
INSERT INTO `t_log` VALUES ('__AmmUil4K0XeXFYrXYw6', null, 'Admin', '删除用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:21:31', '161277249086700000');
INSERT INTO `t_log` VALUES ('__aNlh0bib3XxXoqyNFwB', null, 'Admin', '删除用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:21:26', '161277248637700000');
INSERT INTO `t_log` VALUES ('__APGGZu25SMPpK308QPz', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:53:49', '161277442894700000');
INSERT INTO `t_log` VALUES ('__aPl0d2SMtqaWReTIY81', null, 'Admin', '删除用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:21:34', '161277249449100000');
INSERT INTO `t_log` VALUES ('__aRO7y4Zsq4MgFsxRZM2', null, 'Admin', '更新企业域', '企业域', '192.168.88.1', null, null, '2021-02-08 16:38:46', '161277352622600000');
INSERT INTO `t_log` VALUES ('__astNiLSePIVXYdPIS6l', null, 'Admin', '删除用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:21:45', '161277250488700000');
INSERT INTO `t_log` VALUES ('__b2M0c3XGiHH64ZC6nDP', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-05 16:16:18', '161251297764500000');
INSERT INTO `t_log` VALUES ('__bkN51QcBLbLD0Ff09UV', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:23:28', '161277260823500000');
INSERT INTO `t_log` VALUES ('__BMayuoXrmzHaDdPGSyX', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:53:52', '161277443239300000');
INSERT INTO `t_log` VALUES ('__BR8nH97jL85xTGuXlkm', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:34:52', '161277329164900000');
INSERT INTO `t_log` VALUES ('__CA4ebwI6ItKgF6pkYf6', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:38:03', '161277348312000000');
INSERT INTO `t_log` VALUES ('__CRZzB3xuFApZXLp2Ki4', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:58:05', '161277468501100000');
INSERT INTO `t_log` VALUES ('__deJJTYdViQqh6Pmxro0', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:25:39', '161277273865400000');
INSERT INTO `t_log` VALUES ('__ehTe3wnGWQ6CUdRAhnF', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:53:14', '161277439376300000');
INSERT INTO `t_log` VALUES ('__enxvcxXZldavJosVL5C', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:22:37', '161277255723400000');
INSERT INTO `t_log` VALUES ('__HPldBJFzFTtEqvBwZHW', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:28:15', '161277289494200000');
INSERT INTO `t_log` VALUES ('__I1zBv3AoJzNpQquu5F3', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-19 11:36:09', '161370576936400000');
INSERT INTO `t_log` VALUES ('__iga9sJsMkdPSs06AQLi', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:31:14', '161277307368700000');
INSERT INTO `t_log` VALUES ('__iyM0IeU2FH2ujw3w4ZU', null, 'Admin', '更新部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:30:27', '161277302704900000');
INSERT INTO `t_log` VALUES ('__JlZuiMKWR22y7wvdaa6', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:25:52', '161277275187900000');
INSERT INTO `t_log` VALUES ('__KKS8Cod45jIG9oAtySt', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:37:46', '161277346561800000');
INSERT INTO `t_log` VALUES ('__KlrQBSk1piFlApMYv7H', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:42:54', '161277377415900000');
INSERT INTO `t_log` VALUES ('__KyxERiGubpICOv2iOcr', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:25:58', '161277275760700000');
INSERT INTO `t_log` VALUES ('__L1QbHcw78v1jTTdtLuC', '__oP0irhWXGA2oZRusW1d', '系统管理员', '{*[ListView]*}-串行流程', '新建', '192.168.88.1', 'sOZu9kthmxyP8qQfq0e', '3CffNlgt9B9StIjIUPB', '2021-02-08 17:18:07', '161277588675800000');
INSERT INTO `t_log` VALUES ('__l4JWf00rrKI1HmIK8Vd', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:23:04', '161277258377100000');
INSERT INTO `t_log` VALUES ('__L9kHPWZhl2htZULsS4M', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:57:24', '161277464399700000');
INSERT INTO `t_log` VALUES ('__lr3pBhPqoxHqVF69X88', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-19 11:38:26', '161370590646600000');
INSERT INTO `t_log` VALUES ('__m78nAEDUbRdZeiIscXD', null, 'Admin', '删除流程实例', '企业域', '192.168.88.1', null, null, '2021-02-08 17:10:47', '161277544682400000');
INSERT INTO `t_log` VALUES ('__mbxK0iOksLEPWIQ4QVi', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:40:09', '161277360879700000');
INSERT INTO `t_log` VALUES ('__Nhlg1qEptXkwEQJMq1D', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:22:27', '161277254706400000');
INSERT INTO `t_log` VALUES ('__oNrgSSQnw6qyQXMRiVk', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:26:48', '161277280800700000');
INSERT INTO `t_log` VALUES ('__p3hPP9wzhwvkLXZvxqf', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:40:22', '161277362222500000');
INSERT INTO `t_log` VALUES ('__P8HPRUCfFh8nP60M1IF', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:30:05', '161277300479400000');
INSERT INTO `t_log` VALUES ('__pmK0ZHugtQjjuVSzz5n', null, 'Admin', '更新企业域', '企业域', '192.168.88.1', null, null, '2021-02-08 16:38:54', '161277353376400000');
INSERT INTO `t_log` VALUES ('__PQ59Q2tl11HiedWX9og', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:47:31', '161277405108400000');
INSERT INTO `t_log` VALUES ('__pWQiER2wLS3Z2SeJGR0', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:26:12', '161277277176600000');
INSERT INTO `t_log` VALUES ('__pZMIyL1m9bEo3JHPCpu', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:33:50', '161277323037100000');
INSERT INTO `t_log` VALUES ('__Q0CPvaaU5PGLb6lBPsb', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:45:15', '161277391544900000');
INSERT INTO `t_log` VALUES ('__Q3pEvrB9WT3E2D38umM', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:48:24', '161277410402700000');
INSERT INTO `t_log` VALUES ('__Q5hvcwVRX7logIv5l3E', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:37:40', '161277345975600000');
INSERT INTO `t_log` VALUES ('__Qa1Owi8GsczQbiYhpYQ', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-19 11:35:53', '161370575332800000');
INSERT INTO `t_log` VALUES ('__QCQOps9CHcNs5UJjaca', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:23:16', '161277259579400000');
INSERT INTO `t_log` VALUES ('__qfq2MPuPlysH1OUDngG', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:27:12', '161277283170000000');
INSERT INTO `t_log` VALUES ('__R0wpPsqIdY1wtIgPQHK', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:46:39', '161277399908600000');
INSERT INTO `t_log` VALUES ('__rFGVbliHuGYo102Pqem', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:45:36', '161277393552200000');
INSERT INTO `t_log` VALUES ('__rgJdGJI0Lcqkc6QGN3l', null, 'Admin', '更新企业域', '企业域', '192.168.88.1', null, null, '2021-02-08 16:24:23', '161277266342700000');
INSERT INTO `t_log` VALUES ('__rk0ugdOFlx3ejx26LLR', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:39:32', '161277357186200000');
INSERT INTO `t_log` VALUES ('__rlxVoByRCj5Fcly6Eny', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:26:39', '161277279879100000');
INSERT INTO `t_log` VALUES ('__sx3gbKPkhwpsge1jC6C', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:48:19', '161277409914200000');
INSERT INTO `t_log` VALUES ('__tM68eKfmASpi5l6Wzsr', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:49:14', '161277415415100000');
INSERT INTO `t_log` VALUES ('__TudfNtb3w2BAByp3W2d', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:44:18', '161277385814300000');
INSERT INTO `t_log` VALUES ('__TxmX5K0WB24SNBL9X5z', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:33:43', '161277322278900000');
INSERT INTO `t_log` VALUES ('__u9LXtCh8lo0dRa3gzXY', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:32:03', '161277312270100000');
INSERT INTO `t_log` VALUES ('__UCUavQSvW3eH8cVbocn', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:56:32', '161277459238200000');
INSERT INTO `t_log` VALUES ('__ue6ZIn51pyM9mttIYLp', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:46:40', '161277399973500000');
INSERT INTO `t_log` VALUES ('__uugrvFiu7njHuxDrbXB', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:53:31', '161277441131900000');
INSERT INTO `t_log` VALUES ('__UyBEkrRjHl8qYz6QRlF', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:50:56', '161277425573000000');
INSERT INTO `t_log` VALUES ('__uzQ8FYkwQBN9FMtDf5p', null, 'Admin', '删除用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:21:24', '161277248381800000');
INSERT INTO `t_log` VALUES ('__VaC6d5ER6oXmxfe24fk', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:27:49', '161277286869200000');
INSERT INTO `t_log` VALUES ('__vj2QalFz7lArkSaaSDl', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:37:01', '161277342112600000');
INSERT INTO `t_log` VALUES ('__vWKVVbwmCiRx8s1ziNJ', null, 'Admin', '更新企业域', '企业域', '192.168.88.1', null, null, '2021-02-08 16:38:34', '161277351445000000');
INSERT INTO `t_log` VALUES ('__VzDa8rvXxSVBNEyTloR', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:51:58', '161277431810900000');
INSERT INTO `t_log` VALUES ('__wfwC6nPglGcdazNkswO', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:54:23', '161277446318000000');
INSERT INTO `t_log` VALUES ('__whoVEECR7Gfo7hKAFav', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-05 15:10:08', '161250900753600000');
INSERT INTO `t_log` VALUES ('__WJLtdT6oOHRYcD2yOom', null, 'Admin', '新建部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:27:41', '161277286079400000');
INSERT INTO `t_log` VALUES ('__Xc75eAr5jAMRxSv15Zi', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:48:25', '161277410492400000');
INSERT INTO `t_log` VALUES ('__xW2F3rMSwuEjmXbTYYm', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:50:04', '161277420437500000');
INSERT INTO `t_log` VALUES ('__Y0wSwmeCk29sQwpcFos', null, 'Admin', '更新用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:47:32', '161277405216700000');
INSERT INTO `t_log` VALUES ('__Y7xtzsyJ4ZPcZOl07C1', null, 'Admin', '更新部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:24:41', '161277268071700000');
INSERT INTO `t_log` VALUES ('__Z5OkRBJIwe5xNBkqIxr', null, 'Admin', '新建用户', '企业域', '192.168.88.1', null, null, '2021-02-19 11:38:17', '161370589741900000');
INSERT INTO `t_log` VALUES ('__zjYYcmv1ZxikYtidtHy', null, 'Admin', '删除部门', '企业域', '192.168.88.1', null, null, '2021-02-08 16:21:52', '161277251165100000');
INSERT INTO `t_log` VALUES ('__znyV3WO6X7d0I9ClF6m', null, 'Admin', '保存邮件配置', '企业域', '192.168.88.1', null, null, '2021-02-19 14:01:33', '161371449311200000');
INSERT INTO `t_log` VALUES ('__ZVW7bafJN0TAwGgKNXN', null, 'Admin', '删除用户', '企业域', '192.168.88.1', null, null, '2021-02-08 16:20:02', '161277240237500000');

-- ----------------------------
-- Table structure for t_operation
-- ----------------------------
DROP TABLE IF EXISTS `t_operation`;
CREATE TABLE `t_operation` (
  `ID` varchar(255) NOT NULL,
  `NAME` varchar(255) DEFAULT NULL,
  `RESTYPE` int(11) DEFAULT NULL,
  `CODE` int(11) DEFAULT NULL,
  `APPLICATIONID` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_operation
-- ----------------------------
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600020', 'Create', '0', '2', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600030', 'Delete', '0', '3', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600081', 'Close_Window', '1', '8', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600091', 'Save_Close_Window', '1', '9', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600101', 'Back', '1', '10', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600111', 'Save_Back', '1', '11', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600121', 'Save_New_With_Old', '1', '12', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600151', 'Print_With_FlowHis', '1', '15', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600171', 'Save_New_WithOut_Old', '1', '17', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600180', 'Clear_All_Datas', '0', '18', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600191', 'Save_WithOut_Validate', '1', '19', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600200', 'Batch_Approve', '0', '20', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600211', 'Save_Copy', '1', '21', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600260', 'File_Download', '0', '26', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600261', 'File_Download', '1', '26', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600371', 'core.email.transport', '1', '37', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600390', 'Dispatcher', '0', '39', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600391', 'Dispatcher', '1', '39', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600421', 'Save&New', '1', '42', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb600461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610012', 'Isview', '2', '1001', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610022', 'Invisible', '2', '1002', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610113', 'Readonly', '3', '1011', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610123', 'Modify', '3', '1012', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610133', 'Hidden', '3', '1013', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610143', 'Disabled', '3', '1014', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610214', 'FolderCreate', '4', '1021', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610224', 'FolderRename', '4', '1022', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610234', 'FolderDelete', '4', '1023', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610244', 'FileReview', '4', '1024', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610254', 'FileEdit', '4', '1025', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610264', 'FileDelete', '4', '1026', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610274', 'FileDownload', '4', '1027', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610284', 'FileMove', '4', '1028', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610294', 'FileCopyAll', '4', '1029', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610304', 'UploadFile', '4', '1030', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11de-f053-df18d577-aeb6-19a7865cfdb610314', 'AddChooseFile', '4', '1031', '11de-f053-df18d577-aeb6-19a7865cfdb6');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600020', 'Create', '0', '2', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600030', 'Delete', '0', '3', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600081', 'Close_Window', '1', '8', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600091', 'Save_Close_Window', '1', '9', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600101', 'Back', '1', '10', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600111', 'Save_Back', '1', '11', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600121', 'Save_New_With_Old', '1', '12', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600151', 'Print_With_FlowHis', '1', '15', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600171', 'Save_New_WithOut_Old', '1', '17', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600180', 'Clear_All_Datas', '0', '18', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600191', 'Save_WithOut_Validate', '1', '19', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600200', 'Batch_Approve', '0', '20', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600211', 'Save_Copy', '1', '21', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600260', 'File_Download', '0', '26', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600261', 'File_Download', '1', '26', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600371', 'core.email.transport', '1', '37', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600390', 'Dispatcher', '0', '39', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600391', 'Dispatcher', '1', '39', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600421', 'Save&New', '1', '42', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9600461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610012', 'Isview', '2', '1001', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610022', 'Invisible', '2', '1002', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610113', 'Readonly', '3', '1011', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610123', 'Modify', '3', '1012', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610133', 'Hidden', '3', '1013', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610143', 'Disabled', '3', '1014', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610214', 'FolderCreate', '4', '1021', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610224', 'FolderRename', '4', '1022', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610234', 'FolderDelete', '4', '1023', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610244', 'FileReview', '4', '1024', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610254', 'FileEdit', '4', '1025', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610264', 'FileDelete', '4', '1026', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610274', 'FileDownload', '4', '1027', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610284', 'FileMove', '4', '1028', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610294', 'FileCopyAll', '4', '1029', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610304', 'UploadFile', '4', '1030', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e6-429d-dd7a3284-86a2-074015f7cc9610314', 'AddChooseFile', '4', '1031', '11e6-429d-dd7a3284-86a2-074015f7cc96');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700020', 'Create', '0', '2', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700030', 'Delete', '0', '3', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700081', 'Close_Window', '1', '8', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700091', 'Save_Close_Window', '1', '9', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700101', 'Back', '1', '10', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700111', 'Save_Back', '1', '11', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700121', 'Save_New_With_Old', '1', '12', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700151', 'Print_With_FlowHis', '1', '15', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700171', 'Save_New_WithOut_Old', '1', '17', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700180', 'Clear_All_Datas', '0', '18', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700191', 'Save_WithOut_Validate', '1', '19', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700200', 'Batch_Approve', '0', '20', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700211', 'Save_Copy', '1', '21', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700260', 'File_Download', '0', '26', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700261', 'File_Download', '1', '26', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700371', 'core.email.transport', '1', '37', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700390', 'Dispatcher', '0', '39', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700391', 'Dispatcher', '1', '39', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700421', 'Save&New', '1', '42', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41700461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710012', 'Isview', '2', '1001', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710022', 'Invisible', '2', '1002', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710113', 'Readonly', '3', '1011', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710123', 'Modify', '3', '1012', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710133', 'Hidden', '3', '1013', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710143', 'Disabled', '3', '1014', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710214', 'FolderCreate', '4', '1021', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710224', 'FolderRename', '4', '1022', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710234', 'FolderDelete', '4', '1023', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710244', 'FileReview', '4', '1024', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710254', 'FileEdit', '4', '1025', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710264', 'FileDelete', '4', '1026', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710274', 'FileDownload', '4', '1027', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710284', 'FileMove', '4', '1028', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710294', 'FileCopyAll', '4', '1029', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710304', 'UploadFile', '4', '1030', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-5f98-d7d66840-917f-e799edecb41710314', 'AddChooseFile', '4', '1031', '11e7-5f98-d7d66840-917f-e799edecb417');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100020', 'Create', '0', '2', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100030', 'Delete', '0', '3', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100081', 'Close_Window', '1', '8', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100091', 'Save_Close_Window', '1', '9', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100101', 'Back', '1', '10', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100111', 'Save_Back', '1', '11', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100121', 'Save_New_With_Old', '1', '12', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100151', 'Print_With_FlowHis', '1', '15', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100171', 'Save_New_WithOut_Old', '1', '17', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100180', 'Clear_All_Datas', '0', '18', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100191', 'Save_WithOut_Validate', '1', '19', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100200', 'Batch_Approve', '0', '20', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100211', 'Save_Copy', '1', '21', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100260', 'File_Download', '0', '26', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100261', 'File_Download', '1', '26', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100371', 'core.email.transport', '1', '37', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100390', 'Dispatcher', '0', '39', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100391', 'Dispatcher', '1', '39', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100421', 'Save&New', '1', '42', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed100461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110012', 'Isview', '2', '1001', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110022', 'Invisible', '2', '1002', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110113', 'Readonly', '3', '1011', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110123', 'Modify', '3', '1012', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110133', 'Hidden', '3', '1013', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110143', 'Disabled', '3', '1014', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110214', 'FolderCreate', '4', '1021', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110224', 'FolderRename', '4', '1022', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110234', 'FolderDelete', '4', '1023', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110244', 'FileReview', '4', '1024', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110254', 'FileEdit', '4', '1025', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110264', 'FileDelete', '4', '1026', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110274', 'FileDownload', '4', '1027', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110284', 'FileMove', '4', '1028', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110294', 'FileCopyAll', '4', '1029', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110304', 'UploadFile', '4', '1030', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e7-db36-e48fb673-9ff7-017304b00ed110314', 'AddChooseFile', '4', '1031', '11e7-db36-e48fb673-9ff7-017304b00ed1');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500020', 'Create', '0', '2', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500030', 'Delete', '0', '3', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500081', 'Close_Window', '1', '8', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500091', 'Save_Close_Window', '1', '9', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500101', 'Back', '1', '10', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500111', 'Save_Back', '1', '11', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500121', 'Save_New_With_Old', '1', '12', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500151', 'Print_With_FlowHis', '1', '15', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500171', 'Save_New_WithOut_Old', '1', '17', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500180', 'Clear_All_Datas', '0', '18', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500191', 'Save_WithOut_Validate', '1', '19', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500200', 'Batch_Approve', '0', '20', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500211', 'Save_Copy', '1', '21', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500260', 'File_Download', '0', '26', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500261', 'File_Download', '1', '26', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500371', 'core.email.transport', '1', '37', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500390', 'Dispatcher', '0', '39', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500391', 'Dispatcher', '1', '39', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500421', 'Save&New', '1', '42', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f500461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510012', 'Isview', '2', '1001', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510022', 'Invisible', '2', '1002', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510113', 'Readonly', '3', '1011', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510123', 'Modify', '3', '1012', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510133', 'Hidden', '3', '1013', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510143', 'Disabled', '3', '1014', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510214', 'FolderCreate', '4', '1021', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510224', 'FolderRename', '4', '1022', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510234', 'FolderDelete', '4', '1023', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510244', 'FileReview', '4', '1024', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510254', 'FileEdit', '4', '1025', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510264', 'FileDelete', '4', '1026', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510274', 'FileDownload', '4', '1027', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510284', 'FileMove', '4', '1028', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510294', 'FileCopyAll', '4', '1029', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510304', 'UploadFile', '4', '1030', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('11e8-7e9a-3e54d383-ac0c-8531276834f510314', 'AddChooseFile', '4', '1031', '11e8-7e9a-3e54d383-ac0c-8531276834f5');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00020', 'Create', '0', '2', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00030', 'Delete', '0', '3', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00081', 'Close_Window', '1', '8', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00091', 'Save_Close_Window', '1', '9', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00101', 'Back', '1', '10', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00111', 'Save_Back', '1', '11', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00121', 'Save_New_With_Old', '1', '12', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00151', 'Print_With_FlowHis', '1', '15', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00171', 'Save_New_WithOut_Old', '1', '17', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00180', 'Clear_All_Datas', '0', '18', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00191', 'Save_WithOut_Validate', '1', '19', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00200', 'Batch_Approve', '0', '20', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00211', 'Save_Copy', '1', '21', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00260', 'File_Download', '0', '26', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00261', 'File_Download', '1', '26', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00371', 'core.email.transport', '1', '37', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00390', 'Dispatcher', '0', '39', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00391', 'Dispatcher', '1', '39', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00421', 'Save&New', '1', '42', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10012', 'Isview', '2', '1001', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10022', 'Invisible', '2', '1002', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10113', 'Readonly', '3', '1011', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10123', 'Modify', '3', '1012', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10133', 'Hidden', '3', '1013', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10143', 'Disabled', '3', '1014', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10214', 'FolderCreate', '4', '1021', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10224', 'FolderRename', '4', '1022', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10234', 'FolderDelete', '4', '1023', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10244', 'FileReview', '4', '1024', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10254', 'FileEdit', '4', '1025', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10264', 'FileDelete', '4', '1026', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10274', 'FileDownload', '4', '1027', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10284', 'FileMove', '4', '1028', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10294', 'FileCopyAll', '4', '1029', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10304', 'UploadFile', '4', '1030', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('8KaI8USRnrQKrV2LhuW10314', 'AddChooseFile', '4', '1031', '8KaI8USRnrQKrV2LhuW');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100020', 'Create', '0', '2', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100030', 'Delete', '0', '3', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100081', 'Close_Window', '1', '8', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100091', 'Save_Close_Window', '1', '9', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100101', 'Back', '1', '10', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100111', 'Save_Back', '1', '11', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100121', 'Save_New_With_Old', '1', '12', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100151', 'Print_With_FlowHis', '1', '15', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100171', 'Save_New_WithOut_Old', '1', '17', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100180', 'Clear_All_Datas', '0', '18', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100191', 'Save_WithOut_Validate', '1', '19', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100200', 'Batch_Approve', '0', '20', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100211', 'Save_Copy', '1', '21', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100260', 'File_Download', '0', '26', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100261', 'File_Download', '1', '26', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100340', 'cn.myapps.runtime.dynaform.activity.type.save', '0', '34', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100371', 'core.email.transport', '1', '37', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100390', 'Dispatcher', '0', '39', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100391', 'Dispatcher', '1', '39', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100421', 'Save&New', '1', '42', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD100461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110012', 'Isview', '2', '1001', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110022', 'Invisible', '2', '1002', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110113', 'Readonly', '3', '1011', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110123', 'Modify', '3', '1012', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110133', 'Hidden', '3', '1013', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110143', 'Disabled', '3', '1014', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110214', 'FolderCreate', '4', '1021', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110224', 'FolderRename', '4', '1022', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110234', 'FolderDelete', '4', '1023', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110244', 'FileReview', '4', '1024', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110254', 'FileEdit', '4', '1025', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110264', 'FileDelete', '4', '1026', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110274', 'FileDownload', '4', '1027', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110284', 'FileMove', '4', '1028', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110294', 'FileCopyAll', '4', '1029', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110304', 'UploadFile', '4', '1030', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('aaITQNiVuTz324lCKD110314', 'AddChooseFile', '4', '1031', 'aaITQNiVuTz324lCKD1');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00020', 'Create', '0', '2', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00030', 'Delete', '0', '3', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00081', 'Close_Window', '1', '8', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00091', 'Save_Close_Window', '1', '9', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00101', 'Back', '1', '10', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00111', 'Save_Back', '1', '11', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00121', 'Save_New_With_Old', '1', '12', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00151', 'Print_With_FlowHis', '1', '15', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00171', 'Save_New_WithOut_Old', '1', '17', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00180', 'Clear_All_Datas', '0', '18', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00191', 'Save_WithOut_Validate', '1', '19', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00200', 'Batch_Approve', '0', '20', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00211', 'Save_Copy', '1', '21', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00260', 'File_Download', '0', '26', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00261', 'File_Download', '1', '26', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00371', 'core.email.transport', '1', '37', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00390', 'Dispatcher', '0', '39', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00391', 'Dispatcher', '1', '39', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00421', 'Save&New', '1', '42', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10012', 'Isview', '2', '1001', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10022', 'Invisible', '2', '1002', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10113', 'Readonly', '3', '1011', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10123', 'Modify', '3', '1012', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10133', 'Hidden', '3', '1013', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10143', 'Disabled', '3', '1014', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10214', 'FolderCreate', '4', '1021', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10224', 'FolderRename', '4', '1022', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10234', 'FolderDelete', '4', '1023', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10244', 'FileReview', '4', '1024', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10254', 'FileEdit', '4', '1025', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10264', 'FileDelete', '4', '1026', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10274', 'FileDownload', '4', '1027', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10284', 'FileMove', '4', '1028', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10294', 'FileCopyAll', '4', '1029', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10304', 'UploadFile', '4', '1030', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('AgfEcD81MnzBwsBVIEG10314', 'AddChooseFile', '4', '1031', 'AgfEcD81MnzBwsBVIEG');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00020', 'Create', '0', '2', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00030', 'Delete', '0', '3', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00081', 'Close_Window', '1', '8', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00091', 'Save_Close_Window', '1', '9', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00101', 'Back', '1', '10', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00111', 'Save_Back', '1', '11', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00121', 'Save_New_With_Old', '1', '12', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00151', 'Print_With_FlowHis', '1', '15', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00171', 'Save_New_WithOut_Old', '1', '17', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00180', 'Clear_All_Datas', '0', '18', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00191', 'Save_WithOut_Validate', '1', '19', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00200', 'Batch_Approve', '0', '20', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00211', 'Save_Copy', '1', '21', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00260', 'File_Download', '0', '26', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00261', 'File_Download', '1', '26', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00371', 'core.email.transport', '1', '37', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00390', 'Dispatcher', '0', '39', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00391', 'Dispatcher', '1', '39', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00421', 'Save&New', '1', '42', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10012', 'Isview', '2', '1001', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10022', 'Invisible', '2', '1002', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10113', 'Readonly', '3', '1011', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10123', 'Modify', '3', '1012', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10133', 'Hidden', '3', '1013', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10143', 'Disabled', '3', '1014', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10214', 'FolderCreate', '4', '1021', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10224', 'FolderRename', '4', '1022', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10234', 'FolderDelete', '4', '1023', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10244', 'FileReview', '4', '1024', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10254', 'FileEdit', '4', '1025', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10264', 'FileDelete', '4', '1026', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10274', 'FileDownload', '4', '1027', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10284', 'FileMove', '4', '1028', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10294', 'FileCopyAll', '4', '1029', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10304', 'UploadFile', '4', '1030', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('akf5Zsyc9EOtwyOLDOR10314', 'AddChooseFile', '4', '1031', 'akf5Zsyc9EOtwyOLDOR');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400020', 'Create', '0', '2', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400030', 'Delete', '0', '3', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400081', 'Close_Window', '1', '8', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400091', 'Save_Close_Window', '1', '9', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400101', 'Back', '1', '10', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400111', 'Save_Back', '1', '11', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400121', 'Save_New_With_Old', '1', '12', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400151', 'Print_With_FlowHis', '1', '15', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400171', 'Save_New_WithOut_Old', '1', '17', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400180', 'Clear_All_Datas', '0', '18', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400191', 'Save_WithOut_Validate', '1', '19', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400200', 'Batch_Approve', '0', '20', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400211', 'Save_Copy', '1', '21', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400260', 'File_Download', '0', '26', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400261', 'File_Download', '1', '26', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400371', 'core.email.transport', '1', '37', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400390', 'Dispatcher', '0', '39', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400391', 'Dispatcher', '1', '39', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400421', 'Save&New', '1', '42', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl400461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410012', 'Isview', '2', '1001', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410022', 'Invisible', '2', '1002', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410113', 'Readonly', '3', '1011', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410123', 'Modify', '3', '1012', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410133', 'Hidden', '3', '1013', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410143', 'Disabled', '3', '1014', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410214', 'FolderCreate', '4', '1021', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410224', 'FolderRename', '4', '1022', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410234', 'FolderDelete', '4', '1023', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410244', 'FileReview', '4', '1024', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410254', 'FileEdit', '4', '1025', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410264', 'FileDelete', '4', '1026', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410274', 'FileDownload', '4', '1027', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410284', 'FileMove', '4', '1028', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410294', 'FileCopyAll', '4', '1029', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410304', 'UploadFile', '4', '1030', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cgvu5Lg6ec3rt0XGnl410314', 'AddChooseFile', '4', '1031', 'cgvu5Lg6ec3rt0XGnl4');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00020', 'Create', '0', '2', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00030', 'Delete', '0', '3', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00081', 'Close_Window', '1', '8', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00091', 'Save_Close_Window', '1', '9', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00101', 'Back', '1', '10', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00111', 'Save_Back', '1', '11', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00121', 'Save_New_With_Old', '1', '12', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00151', 'Print_With_FlowHis', '1', '15', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00171', 'Save_New_WithOut_Old', '1', '17', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00180', 'Clear_All_Datas', '0', '18', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00191', 'Save_WithOut_Validate', '1', '19', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00200', 'Batch_Approve', '0', '20', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00211', 'Save_Copy', '1', '21', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00260', 'File_Download', '0', '26', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00261', 'File_Download', '1', '26', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00340', 'cn.myapps.runtime.dynaform.activity.type.save', '0', '34', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00371', 'core.email.transport', '1', '37', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00390', 'Dispatcher', '0', '39', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00391', 'Dispatcher', '1', '39', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00421', 'Save&New', '1', '42', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10012', 'Isview', '2', '1001', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10022', 'Invisible', '2', '1002', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10113', 'Readonly', '3', '1011', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10123', 'Modify', '3', '1012', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10133', 'Hidden', '3', '1013', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10143', 'Disabled', '3', '1014', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10214', 'FolderCreate', '4', '1021', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10224', 'FolderRename', '4', '1022', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10234', 'FolderDelete', '4', '1023', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10244', 'FileReview', '4', '1024', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10254', 'FileEdit', '4', '1025', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10264', 'FileDelete', '4', '1026', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10274', 'FileDownload', '4', '1027', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10284', 'FileMove', '4', '1028', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10294', 'FileCopyAll', '4', '1029', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10304', 'UploadFile', '4', '1030', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('cuKp8Z9u92TnzhbiH8u10314', 'AddChooseFile', '4', '1031', 'cuKp8Z9u92TnzhbiH8u');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00020', 'Create', '0', '2', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00030', 'Delete', '0', '3', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00081', 'Close_Window', '1', '8', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00091', 'Save_Close_Window', '1', '9', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00101', 'Back', '1', '10', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00111', 'Save_Back', '1', '11', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00121', 'Save_New_With_Old', '1', '12', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00151', 'Print_With_FlowHis', '1', '15', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00171', 'Save_New_WithOut_Old', '1', '17', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00180', 'Clear_All_Datas', '0', '18', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00191', 'Save_WithOut_Validate', '1', '19', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00200', 'Batch_Approve', '0', '20', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00211', 'Save_Copy', '1', '21', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00260', 'File_Download', '0', '26', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00261', 'File_Download', '1', '26', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00371', 'core.email.transport', '1', '37', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00390', 'Dispatcher', '0', '39', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00391', 'Dispatcher', '1', '39', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00421', 'Save&New', '1', '42', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10012', 'Isview', '2', '1001', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10022', 'Invisible', '2', '1002', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10113', 'Readonly', '3', '1011', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10123', 'Modify', '3', '1012', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10133', 'Hidden', '3', '1013', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10143', 'Disabled', '3', '1014', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10214', 'FolderCreate', '4', '1021', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10224', 'FolderRename', '4', '1022', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10234', 'FolderDelete', '4', '1023', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10244', 'FileReview', '4', '1024', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10254', 'FileEdit', '4', '1025', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10264', 'FileDelete', '4', '1026', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10274', 'FileDownload', '4', '1027', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10284', 'FileMove', '4', '1028', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10294', 'FileCopyAll', '4', '1029', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10304', 'UploadFile', '4', '1030', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('DXYqbpMOR1KsVKXukIy10314', 'AddChooseFile', '4', '1031', 'DXYqbpMOR1KsVKXukIy');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00020', 'Create', '0', '2', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00030', 'Delete', '0', '3', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00081', 'Close_Window', '1', '8', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00091', 'Save_Close_Window', '1', '9', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00101', 'Back', '1', '10', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00111', 'Save_Back', '1', '11', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00121', 'Save_New_With_Old', '1', '12', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00151', 'Print_With_FlowHis', '1', '15', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00171', 'Save_New_WithOut_Old', '1', '17', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00180', 'Clear_All_Datas', '0', '18', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00191', 'Save_WithOut_Validate', '1', '19', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00200', 'Batch_Approve', '0', '20', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00211', 'Save_Copy', '1', '21', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00260', 'File_Download', '0', '26', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00261', 'File_Download', '1', '26', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00371', 'core.email.transport', '1', '37', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00390', 'Dispatcher', '0', '39', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00391', 'Dispatcher', '1', '39', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00421', 'Save&New', '1', '42', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10012', 'Isview', '2', '1001', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10022', 'Invisible', '2', '1002', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10113', 'Readonly', '3', '1011', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10123', 'Modify', '3', '1012', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10133', 'Hidden', '3', '1013', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10143', 'Disabled', '3', '1014', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10214', 'FolderCreate', '4', '1021', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10224', 'FolderRename', '4', '1022', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10234', 'FolderDelete', '4', '1023', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10244', 'FileReview', '4', '1024', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10254', 'FileEdit', '4', '1025', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10264', 'FileDelete', '4', '1026', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10274', 'FileDownload', '4', '1027', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10284', 'FileMove', '4', '1028', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10294', 'FileCopyAll', '4', '1029', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10304', 'UploadFile', '4', '1030', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('dZdmJ6eNvWfLrhhv2yZ10314', 'AddChooseFile', '4', '1031', 'dZdmJ6eNvWfLrhhv2yZ');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00020', 'Create', '0', '2', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00030', 'Delete', '0', '3', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00081', 'Close_Window', '1', '8', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00091', 'Save_Close_Window', '1', '9', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00101', 'Back', '1', '10', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00111', 'Save_Back', '1', '11', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00121', 'Save_New_With_Old', '1', '12', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00151', 'Print_With_FlowHis', '1', '15', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00171', 'Save_New_WithOut_Old', '1', '17', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00180', 'Clear_All_Datas', '0', '18', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00191', 'Save_WithOut_Validate', '1', '19', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00200', 'Batch_Approve', '0', '20', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00211', 'Save_Copy', '1', '21', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00260', 'File_Download', '0', '26', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00261', 'File_Download', '1', '26', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00371', 'core.email.transport', '1', '37', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00390', 'Dispatcher', '0', '39', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00391', 'Dispatcher', '1', '39', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00421', 'Save&New', '1', '42', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10012', 'Isview', '2', '1001', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10022', 'Invisible', '2', '1002', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10113', 'Readonly', '3', '1011', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10123', 'Modify', '3', '1012', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10133', 'Hidden', '3', '1013', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10143', 'Disabled', '3', '1014', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10214', 'FolderCreate', '4', '1021', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10224', 'FolderRename', '4', '1022', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10234', 'FolderDelete', '4', '1023', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10244', 'FileReview', '4', '1024', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10254', 'FileEdit', '4', '1025', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10264', 'FileDelete', '4', '1026', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10274', 'FileDownload', '4', '1027', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10284', 'FileMove', '4', '1028', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10294', 'FileCopyAll', '4', '1029', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10304', 'UploadFile', '4', '1030', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('E2u9wCmer4OXPHL4ozL10314', 'AddChooseFile', '4', '1031', 'E2u9wCmer4OXPHL4ozL');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00020', 'Create', '0', '2', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00030', 'Delete', '0', '3', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00081', 'Close_Window', '1', '8', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00091', 'Save_Close_Window', '1', '9', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00101', 'Back', '1', '10', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00111', 'Save_Back', '1', '11', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00121', 'Save_New_With_Old', '1', '12', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00151', 'Print_With_FlowHis', '1', '15', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00171', 'Save_New_WithOut_Old', '1', '17', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00180', 'Clear_All_Datas', '0', '18', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00191', 'Save_WithOut_Validate', '1', '19', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00200', 'Batch_Approve', '0', '20', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00211', 'Save_Copy', '1', '21', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00260', 'File_Download', '0', '26', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00261', 'File_Download', '1', '26', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00371', 'core.email.transport', '1', '37', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00390', 'Dispatcher', '0', '39', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00391', 'Dispatcher', '1', '39', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00421', 'Save&New', '1', '42', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10012', 'Isview', '2', '1001', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10022', 'Invisible', '2', '1002', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10113', 'Readonly', '3', '1011', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10123', 'Modify', '3', '1012', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10133', 'Hidden', '3', '1013', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10143', 'Disabled', '3', '1014', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10214', 'FolderCreate', '4', '1021', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10224', 'FolderRename', '4', '1022', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10234', 'FolderDelete', '4', '1023', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10244', 'FileReview', '4', '1024', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10254', 'FileEdit', '4', '1025', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10264', 'FileDelete', '4', '1026', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10274', 'FileDownload', '4', '1027', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10284', 'FileMove', '4', '1028', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10294', 'FileCopyAll', '4', '1029', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10304', 'UploadFile', '4', '1030', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('ESKqqQsUjS39sZsiX9f10314', 'AddChooseFile', '4', '1031', 'ESKqqQsUjS39sZsiX9f');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300020', 'Create', '0', '2', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300030', 'Delete', '0', '3', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300081', 'Close_Window', '1', '8', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300091', 'Save_Close_Window', '1', '9', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300101', 'Back', '1', '10', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300111', 'Save_Back', '1', '11', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300121', 'Save_New_With_Old', '1', '12', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300151', 'Print_With_FlowHis', '1', '15', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300171', 'Save_New_WithOut_Old', '1', '17', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300180', 'Clear_All_Datas', '0', '18', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300191', 'Save_WithOut_Validate', '1', '19', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300200', 'Batch_Approve', '0', '20', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300211', 'Save_Copy', '1', '21', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300260', 'File_Download', '0', '26', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300261', 'File_Download', '1', '26', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300371', 'core.email.transport', '1', '37', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300390', 'Dispatcher', '0', '39', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300391', 'Dispatcher', '1', '39', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300421', 'Save&New', '1', '42', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu300461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310012', 'Isview', '2', '1001', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310022', 'Invisible', '2', '1002', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310113', 'Readonly', '3', '1011', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310123', 'Modify', '3', '1012', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310133', 'Hidden', '3', '1013', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310143', 'Disabled', '3', '1014', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310214', 'FolderCreate', '4', '1021', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310224', 'FolderRename', '4', '1022', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310234', 'FolderDelete', '4', '1023', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310244', 'FileReview', '4', '1024', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310254', 'FileEdit', '4', '1025', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310264', 'FileDelete', '4', '1026', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310274', 'FileDownload', '4', '1027', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310284', 'FileMove', '4', '1028', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310294', 'FileCopyAll', '4', '1029', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310304', 'UploadFile', '4', '1030', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('HdPeBqYwJyFyjHkhZu310314', 'AddChooseFile', '4', '1031', 'HdPeBqYwJyFyjHkhZu3');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00020', 'Create', '0', '2', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00030', 'Delete', '0', '3', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00081', 'Close_Window', '1', '8', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00091', 'Save_Close_Window', '1', '9', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00101', 'Back', '1', '10', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00111', 'Save_Back', '1', '11', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00121', 'Save_New_With_Old', '1', '12', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00151', 'Print_With_FlowHis', '1', '15', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00171', 'Save_New_WithOut_Old', '1', '17', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00180', 'Clear_All_Datas', '0', '18', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00191', 'Save_WithOut_Validate', '1', '19', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00200', 'Batch_Approve', '0', '20', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00211', 'Save_Copy', '1', '21', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00260', 'File_Download', '0', '26', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00261', 'File_Download', '1', '26', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00371', 'core.email.transport', '1', '37', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00390', 'Dispatcher', '0', '39', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00391', 'Dispatcher', '1', '39', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00421', 'Save&New', '1', '42', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10012', 'Isview', '2', '1001', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10022', 'Invisible', '2', '1002', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10113', 'Readonly', '3', '1011', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10123', 'Modify', '3', '1012', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10133', 'Hidden', '3', '1013', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10143', 'Disabled', '3', '1014', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10214', 'FolderCreate', '4', '1021', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10224', 'FolderRename', '4', '1022', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10234', 'FolderDelete', '4', '1023', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10244', 'FileReview', '4', '1024', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10254', 'FileEdit', '4', '1025', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10264', 'FileDelete', '4', '1026', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10274', 'FileDownload', '4', '1027', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10284', 'FileMove', '4', '1028', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10294', 'FileCopyAll', '4', '1029', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10304', 'UploadFile', '4', '1030', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('lb2zH07ZUEu05Iiikvm10314', 'AddChooseFile', '4', '1031', 'lb2zH07ZUEu05Iiikvm');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00020', 'Create', '0', '2', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00030', 'Delete', '0', '3', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00081', 'Close_Window', '1', '8', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00091', 'Save_Close_Window', '1', '9', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00101', 'Back', '1', '10', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00111', 'Save_Back', '1', '11', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00121', 'Save_New_With_Old', '1', '12', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00151', 'Print_With_FlowHis', '1', '15', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00171', 'Save_New_WithOut_Old', '1', '17', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00180', 'Clear_All_Datas', '0', '18', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00191', 'Save_WithOut_Validate', '1', '19', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00200', 'Batch_Approve', '0', '20', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00211', 'Save_Copy', '1', '21', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00260', 'File_Download', '0', '26', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00261', 'File_Download', '1', '26', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00371', 'core.email.transport', '1', '37', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00390', 'Dispatcher', '0', '39', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00391', 'Dispatcher', '1', '39', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00421', 'Save&New', '1', '42', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10012', 'Isview', '2', '1001', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10022', 'Invisible', '2', '1002', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10113', 'Readonly', '3', '1011', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10123', 'Modify', '3', '1012', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10133', 'Hidden', '3', '1013', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10143', 'Disabled', '3', '1014', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10214', 'FolderCreate', '4', '1021', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10224', 'FolderRename', '4', '1022', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10234', 'FolderDelete', '4', '1023', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10244', 'FileReview', '4', '1024', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10254', 'FileEdit', '4', '1025', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10264', 'FileDelete', '4', '1026', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10274', 'FileDownload', '4', '1027', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10284', 'FileMove', '4', '1028', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10294', 'FileCopyAll', '4', '1029', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10304', 'UploadFile', '4', '1030', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('mXr6VN7T4LQILVWBWWk10314', 'AddChooseFile', '4', '1031', 'mXr6VN7T4LQILVWBWWk');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00020', 'Create', '0', '2', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00030', 'Delete', '0', '3', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00081', 'Close_Window', '1', '8', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00091', 'Save_Close_Window', '1', '9', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00101', 'Back', '1', '10', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00111', 'Save_Back', '1', '11', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00121', 'Save_New_With_Old', '1', '12', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00151', 'Print_With_FlowHis', '1', '15', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00171', 'Save_New_WithOut_Old', '1', '17', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00180', 'Clear_All_Datas', '0', '18', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00191', 'Save_WithOut_Validate', '1', '19', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00200', 'Batch_Approve', '0', '20', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00211', 'Save_Copy', '1', '21', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00260', 'File_Download', '0', '26', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00261', 'File_Download', '1', '26', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00371', 'core.email.transport', '1', '37', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00390', 'Dispatcher', '0', '39', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00391', 'Dispatcher', '1', '39', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00421', 'Save&New', '1', '42', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10012', 'Isview', '2', '1001', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10022', 'Invisible', '2', '1002', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10113', 'Readonly', '3', '1011', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10123', 'Modify', '3', '1012', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10133', 'Hidden', '3', '1013', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10143', 'Disabled', '3', '1014', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10214', 'FolderCreate', '4', '1021', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10224', 'FolderRename', '4', '1022', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10234', 'FolderDelete', '4', '1023', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10244', 'FileReview', '4', '1024', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10254', 'FileEdit', '4', '1025', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10264', 'FileDelete', '4', '1026', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10274', 'FileDownload', '4', '1027', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10284', 'FileMove', '4', '1028', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10294', 'FileCopyAll', '4', '1029', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10304', 'UploadFile', '4', '1030', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('OybdKfpcFT9xAb6Y5wK10314', 'AddChooseFile', '4', '1031', 'OybdKfpcFT9xAb6Y5wK');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00020', 'Create', '0', '2', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00030', 'Delete', '0', '3', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00081', 'Close_Window', '1', '8', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00091', 'Save_Close_Window', '1', '9', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00101', 'Back', '1', '10', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00111', 'Save_Back', '1', '11', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00121', 'Save_New_With_Old', '1', '12', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00151', 'Print_With_FlowHis', '1', '15', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00171', 'Save_New_WithOut_Old', '1', '17', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00180', 'Clear_All_Datas', '0', '18', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00191', 'Save_WithOut_Validate', '1', '19', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00200', 'Batch_Approve', '0', '20', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00211', 'Save_Copy', '1', '21', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00260', 'File_Download', '0', '26', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00261', 'File_Download', '1', '26', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00371', 'core.email.transport', '1', '37', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00390', 'Dispatcher', '0', '39', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00391', 'Dispatcher', '1', '39', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00421', 'Save&New', '1', '42', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10012', 'Isview', '2', '1001', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10022', 'Invisible', '2', '1002', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10113', 'Readonly', '3', '1011', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10123', 'Modify', '3', '1012', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10133', 'Hidden', '3', '1013', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10143', 'Disabled', '3', '1014', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10214', 'FolderCreate', '4', '1021', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10224', 'FolderRename', '4', '1022', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10234', 'FolderDelete', '4', '1023', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10244', 'FileReview', '4', '1024', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10254', 'FileEdit', '4', '1025', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10264', 'FileDelete', '4', '1026', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10274', 'FileDownload', '4', '1027', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10284', 'FileMove', '4', '1028', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10294', 'FileCopyAll', '4', '1029', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10304', 'UploadFile', '4', '1030', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('pf0SN538q53vHjjHgmR10314', 'AddChooseFile', '4', '1031', 'pf0SN538q53vHjjHgmR');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00020', 'Create', '0', '2', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00030', 'Delete', '0', '3', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00081', 'Close_Window', '1', '8', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00091', 'Save_Close_Window', '1', '9', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00101', 'Back', '1', '10', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00111', 'Save_Back', '1', '11', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00121', 'Save_New_With_Old', '1', '12', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00151', 'Print_With_FlowHis', '1', '15', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00171', 'Save_New_WithOut_Old', '1', '17', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00180', 'Clear_All_Datas', '0', '18', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00191', 'Save_WithOut_Validate', '1', '19', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00200', 'Batch_Approve', '0', '20', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00211', 'Save_Copy', '1', '21', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00260', 'File_Download', '0', '26', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00261', 'File_Download', '1', '26', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00371', 'core.email.transport', '1', '37', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00390', 'Dispatcher', '0', '39', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00391', 'Dispatcher', '1', '39', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00421', 'Save&New', '1', '42', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10012', 'Isview', '2', '1001', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10022', 'Invisible', '2', '1002', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10113', 'Readonly', '3', '1011', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10123', 'Modify', '3', '1012', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10133', 'Hidden', '3', '1013', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10143', 'Disabled', '3', '1014', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10214', 'FolderCreate', '4', '1021', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10224', 'FolderRename', '4', '1022', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10234', 'FolderDelete', '4', '1023', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10244', 'FileReview', '4', '1024', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10254', 'FileEdit', '4', '1025', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10264', 'FileDelete', '4', '1026', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10274', 'FileDownload', '4', '1027', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10284', 'FileMove', '4', '1028', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10294', 'FileCopyAll', '4', '1029', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10304', 'UploadFile', '4', '1030', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('PkRQbHZ4wb56Sn9bcSb10314', 'AddChooseFile', '4', '1031', 'PkRQbHZ4wb56Sn9bcSb');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00020', 'Create', '0', '2', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00030', 'Delete', '0', '3', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00081', 'Close_Window', '1', '8', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00091', 'Save_Close_Window', '1', '9', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00101', 'Back', '1', '10', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00111', 'Save_Back', '1', '11', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00121', 'Save_New_With_Old', '1', '12', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00151', 'Print_With_FlowHis', '1', '15', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00171', 'Save_New_WithOut_Old', '1', '17', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00180', 'Clear_All_Datas', '0', '18', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00191', 'Save_WithOut_Validate', '1', '19', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00200', 'Batch_Approve', '0', '20', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00211', 'Save_Copy', '1', '21', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00260', 'File_Download', '0', '26', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00261', 'File_Download', '1', '26', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00340', 'cn.myapps.runtime.dynaform.activity.type.save', '0', '34', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00371', 'core.email.transport', '1', '37', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00390', 'Dispatcher', '0', '39', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00391', 'Dispatcher', '1', '39', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00421', 'Save&New', '1', '42', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10012', 'Isview', '2', '1001', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10022', 'Invisible', '2', '1002', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10113', 'Readonly', '3', '1011', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10123', 'Modify', '3', '1012', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10133', 'Hidden', '3', '1013', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10143', 'Disabled', '3', '1014', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10214', 'FolderCreate', '4', '1021', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10224', 'FolderRename', '4', '1022', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10234', 'FolderDelete', '4', '1023', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10244', 'FileReview', '4', '1024', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10254', 'FileEdit', '4', '1025', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10264', 'FileDelete', '4', '1026', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10274', 'FileDownload', '4', '1027', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10284', 'FileMove', '4', '1028', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10294', 'FileCopyAll', '4', '1029', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10304', 'UploadFile', '4', '1030', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('sOZu9kthmxyP8qQfq0e10314', 'AddChooseFile', '4', '1031', 'sOZu9kthmxyP8qQfq0e');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00020', 'Create', '0', '2', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00030', 'Delete', '0', '3', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00081', 'Close_Window', '1', '8', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00091', 'Save_Close_Window', '1', '9', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00101', 'Back', '1', '10', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00111', 'Save_Back', '1', '11', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00121', 'Save_New_With_Old', '1', '12', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00151', 'Print_With_FlowHis', '1', '15', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00171', 'Save_New_WithOut_Old', '1', '17', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00180', 'Clear_All_Datas', '0', '18', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00191', 'Save_WithOut_Validate', '1', '19', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00200', 'Batch_Approve', '0', '20', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00211', 'Save_Copy', '1', '21', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00260', 'File_Download', '0', '26', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00261', 'File_Download', '1', '26', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00301', 'cn.myapps.runtime.dynaform.activity.type.flexPrint', '1', '30', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00371', 'core.email.transport', '1', '37', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00390', 'Dispatcher', '0', '39', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00391', 'Dispatcher', '1', '39', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00421', 'Save&New', '1', '42', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10012', 'Isview', '2', '1001', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10022', 'Invisible', '2', '1002', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10113', 'Readonly', '3', '1011', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10123', 'Modify', '3', '1012', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10133', 'Hidden', '3', '1013', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10143', 'Disabled', '3', '1014', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10214', 'FolderCreate', '4', '1021', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10224', 'FolderRename', '4', '1022', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10234', 'FolderDelete', '4', '1023', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10244', 'FileReview', '4', '1024', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10254', 'FileEdit', '4', '1025', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10264', 'FileDelete', '4', '1026', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10274', 'FileDownload', '4', '1027', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10284', 'FileMove', '4', '1028', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10294', 'FileCopyAll', '4', '1029', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10304', 'UploadFile', '4', '1030', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('w7CXlq8zX8CuR5PxO9G10314', 'AddChooseFile', '4', '1031', 'w7CXlq8zX8CuR5PxO9G');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00010', 'cn.myapps.runtime.dynaform.activity.type.document_query', '0', '1', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00020', 'Create', '0', '2', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00030', 'Delete', '0', '3', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00041', 'cn.myapps.runtime.dynaform.activity.type.save_and_start_flow', '1', '4', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00051', 'cn.myapps.runtime.dynaform.activity.type.flow_processing', '1', '5', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00081', 'Close_Window', '1', '8', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00091', 'Save_Close_Window', '1', '9', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00101', 'Back', '1', '10', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00111', 'Save_Back', '1', '11', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00121', 'Save_New_With_Old', '1', '12', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00131', 'cn.myapps.runtime.dynaform.activity.type.nothing', '1', '13', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00141', 'cn.myapps.runtime.dynaform.activity.print', '1', '14', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00160', 'cn.myapps.runtime.dynaform.activity.type.excelExport', '0', '16', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00171', 'Save_New_WithOut_Old', '1', '17', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00180', 'Clear_All_Datas', '0', '18', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00191', 'Save_WithOut_Validate', '1', '19', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00200', 'Batch_Approve', '0', '20', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00211', 'Save_Copy', '1', '21', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00251', 'cn.myapps.runtime.dynaform.activity.type.pdfExport', '1', '25', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00260', 'File_Download', '0', '26', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00261', 'File_Download', '1', '26', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00270', 'cn.myapps.runtime.dynaform.activity.type.excelImport', '0', '27', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00281', 'cn.myapps.runtime.dynaform.activity.type.signature', '1', '28', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00290', 'cn.myapps.runtime.dynaform.activity.type.batchSignature', '0', '29', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00321', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '32', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00331', 'cn.myapps.runtime.dynaform.activity.type.start_flow', '1', '33', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00340', 'cn.myapps.runtime.dynaform.activity.type.save', '0', '34', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00341', 'cn.myapps.runtime.dynaform.activity.type.save', '1', '34', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00360', 'cn.myapps.runtime.dynaform.activity.print', '0', '36', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00371', 'core.email.transport', '1', '37', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00390', 'Dispatcher', '0', '39', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00391', 'Dispatcher', '1', '39', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00421', 'Save&New', '1', '42', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00430', 'cn.myapps.runtime.dynaform.activity.type.jump', '0', '43', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00431', 'cn.myapps.runtime.dynaform.activity.type.jump', '1', '43', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00451', 'cn.myapps.runtime.dynaform.activity.archive.name', '1', '45', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL00461', 'cn.myapps.runtime.dynaform.activity.type.sign', '1', '46', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10012', 'Isview', '2', '1001', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10022', 'Invisible', '2', '1002', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10113', 'Readonly', '3', '1011', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10123', 'Modify', '3', '1012', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10133', 'Hidden', '3', '1013', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10143', 'Disabled', '3', '1014', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10214', 'FolderCreate', '4', '1021', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10224', 'FolderRename', '4', '1022', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10234', 'FolderDelete', '4', '1023', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10244', 'FileReview', '4', '1024', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10254', 'FileEdit', '4', '1025', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10264', 'FileDelete', '4', '1026', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10274', 'FileDownload', '4', '1027', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10284', 'FileMove', '4', '1028', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10294', 'FileCopyAll', '4', '1029', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10304', 'UploadFile', '4', '1030', '__6L7jV0BIHtm5CAMnelL');
INSERT INTO `t_operation` VALUES ('__6L7jV0BIHtm5CAMnelL10314', 'AddChooseFile', '4', '1031', '__6L7jV0BIHtm5CAMnelL');

-- ----------------------------
-- Table structure for t_permission
-- ----------------------------
DROP TABLE IF EXISTS `t_permission`;
CREATE TABLE `t_permission` (
  `ID` varchar(255) NOT NULL,
  `ROLE_ID` varchar(255) DEFAULT NULL,
  `RESOURCE_ID` varchar(255) DEFAULT NULL,
  `RES_ID` varchar(255) DEFAULT NULL,
  `RES_TYPE` int(11) DEFAULT NULL,
  `OPERATION_ID` varchar(255) DEFAULT NULL,
  `SORTID` varchar(255) DEFAULT NULL,
  `APPLICATIONID` varchar(255) DEFAULT NULL,
  `RESNAME` varchar(255) DEFAULT NULL,
  `OPERATIONCODE` int(11) DEFAULT NULL,
  `TYPE` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of t_permission
-- ----------------------------
INSERT INTO `t_permission` VALUES ('00LxKdkbgY34ZppUcSg', '0Q0LkJpfR1ejtO8rD3p', null, 'kYU5ffwtqGFdhsYDlG8', '2', 'kYU5ffwtqGFdhsYDlG8', '155168789286100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('01G1SDT6EjUhmWEYLOV', '2jSs6cnzu4mzY9C13vF', null, 'sbkS067uQ9jIwpB6qWd', '2', 'sbkS067uQ9jIwpB6qWd', '155142339550000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('01mPY1g2tU50QRUeEgg', '3tFw1boS5L9vXoJCr6Z', null, 'SiPTeSpUhRIqVgi1HW1', '0', '75x9tz4gNnPZBrKKcK5', '154563949564800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('01zKYtza4UsMTVUSkAv', 'kPLbeydkgiYW6NIkCt0', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'QOEHg2MUz4Qp7kv5JyL', '155168804608500006', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('02OrgFTHiQ4zDKl0lST', '3tFw1boS5L9vXoJCr6Z', null, 'XxowwHQ6scpysjbxk0d', '2', 'XxowwHQ6scpysjbxk0d', '154563949447600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('04mnxBjOhlVeMgdVT1G', '2jSs6cnzu4mzY9C13vF', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'APxRfhpMtHJp5vsjIIa', '155142339759100001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('05UVVSIDRlp49WXWur7', 'jkpTHKg7DpuXQrppVxx', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'D4TlyirrG1V4ebAqUSh', '155142353128300000', 'HdPeBqYwJyFyjHkhZu3', '删除（右键菜单）', '3', '1');
INSERT INTO `t_permission` VALUES ('067VUU8y79fJcV7UvDh', 'kPLbeydkgiYW6NIkCt0', null, '66LHqZTlRhXpEZAIoTa', '2', '66LHqZTlRhXpEZAIoTa', '155168804486800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('06ZW7Xz1bPxb82tdnyn', 'kPLbeydkgiYW6NIkCt0', null, 'nTlBd4a4Vt8mtiTX41J', '0', 'E3J8OfymoQtKHIuFNMK', '155168804627200003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('09bAGZcawIcYDT8G06r', 'kPLbeydkgiYW6NIkCt0', null, 'Gc5icb2c0g8ARf7Jath', '0', 'SLsJFM3QWPsTiAQbQRE', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单', '3', '2');
INSERT INTO `t_permission` VALUES ('09DtSpAusxivPurtsPm', '2ytUeoxBqghwofmBALl', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'd0K3kzFXs6sjokcwJ3u', '154461619066300001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('09l9EytiIwdLeGLk8ue', 'jkpTHKg7DpuXQrppVxx', null, 'gkbm2C0NbCfu86GHkFh', '0', 'hahOwfXx6ZmPFPMbyf8', '155142353053400002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('0ADAnB9bpBo7mCjUWzb', '3tFw1boS5L9vXoJCr6Z', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'XG8ap7ffszErnf3ZYYp', '154563949572600003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('0AEyjUSLhzzMRqRVoU2', '2jSs6cnzu4mzY9C13vF', null, 'WOmzvkui5ZsoZu1CogR', '1', 'i12huWXbQz9KJExHc6D', '155142339780900003', 'HdPeBqYwJyFyjHkhZu3', '文件下载(路径脚本需完善)', '26', '1');
INSERT INTO `t_permission` VALUES ('0AMX06B7G1Cur4VE2JF', 'kPLbeydkgiYW6NIkCt0', null, '7fddj0hyGNlDYSZpyFZ', '1', '7fddj0hyGNlDYSZpyFZ', '155168804663100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('0APiqBpYiZclCnYraj1', '0Q0LkJpfR1ejtO8rD3p', null, 'xBX9EbJkveiSGJm9xRj', '0', 'Ly9Spk5ma18fAyhAWh3', '155168789392200000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('0AwHwa1pdSMx7SXUclk', '2jSs6cnzu4mzY9C13vF', null, 'G0WtPO1mX58wd7tjkTy', '0', 'MiGkf6DvyyRTJk95EY3', '155142339784000005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('0AWPfOX2gSEj05mVZe7', '2jSs6cnzu4mzY9C13vF', null, '1YQdDj3kDCsdgpgrTSf', '2', '1YQdDj3kDCsdgpgrTSf', '155142339556300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0aXtub5YZEFF1YPzY9n', '3tFw1boS5L9vXoJCr6Z', null, 'MnvkHQ9zdkDlQaAgtGq', '2', 'MnvkHQ9zdkDlQaAgtGq', '154563949449100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0bxxTC7KhPUsz8TpfUh', '0Q0LkJpfR1ejtO8rD3p', null, 'j4ncSyWthzCYoNj3n4J', '0', 'WWNamo3Hl2Q5IoZUFn7', '155168789451500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('0c0HSIMV9Rtl8cRyu8p', '0Q0LkJpfR1ejtO8rD3p', null, 'bKWrnsYGUGaqqYqkeeO', '0', '23XpTvLhb5XEzINSZHU', '155168789490500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('0cHNTwwuYEBoELnPWGr', '2ytUeoxBqghwofmBALl', null, 'IuPDe4Gm9occzflnrP0', '0', 'v6Do5TzCwJt7gNmEi1b', '154461618972600003', 'HdPeBqYwJyFyjHkhZu3', '弹出层打开', '43', '1');
INSERT INTO `t_permission` VALUES ('0f3zT16diDJKT6pwVzK', 'jkpTHKg7DpuXQrppVxx', null, 'vThTQ2M4QKScZTsYPVX', '2', 'vThTQ2M4QKScZTsYPVX', '155142352959800005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0faYMGB0JZZHUGODUVQ', '0Q0LkJpfR1ejtO8rD3p', null, 'WrG5tW3KzqYHU2QYywI', '2', 'WrG5tW3KzqYHU2QYywI', '155168789322000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0g3lT2zmyopwhhART6S', '3tFw1boS5L9vXoJCr6Z', null, '4RJ5cYekBtB1RdNDxL3', '1', '4RJ5cYekBtB1RdNDxL3', '154563949541300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('0H1KrE7fjc2tKf5vr66', 'jkpTHKg7DpuXQrppVxx', null, 'hP9KCze8ACTb6Z4BWVV', '2', 'hP9KCze8ACTb6Z4BWVV', '155142352973900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0heakvQ78So51Rsxxqd', '0Q0LkJpfR1ejtO8rD3p', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'RXwhTRAzZSqsUpQc1NF', '155168789451500003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('0hEE7OHd1b7OGGpFyRJ', 'jkpTHKg7DpuXQrppVxx', null, 'U1TygLjjsSxDfEoGwhc', '1', 'U1TygLjjsSxDfEoGwhc', '155142353016000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('0hY3ckZlTSYcybKrUDC', '2jSs6cnzu4mzY9C13vF', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'SAYbUm9awyQJXoJpDNc', '155142339777800005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('0I5NV8OGqxHQmlaHuZf', 'kPLbeydkgiYW6NIkCt0', null, 'mXDUC8go52mfA91GY0r', '0', 'fh4ptUZPIiHNtWvp0cJ', '155168804647500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('0Jh3cfwwb0TwQSpbm0J', '2jSs6cnzu4mzY9C13vF', null, '4VkP5W8VPlERMiThvSD', '0', 'SOe9OaDTLOE1domxYKV', '155142339780900004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('0JQgZVh8h4PRFDWaX42', 'jkpTHKg7DpuXQrppVxx', null, 'j3y8CHrsMwRmnPJz7EW', '1', 'j3y8CHrsMwRmnPJz7EW', '155142353111200006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('0JyKA9TpsbbVqV9bIQN', '2jSs6cnzu4mzY9C13vF', null, 'Z6pISvulUdsSz8bjuOV', '0', '81O85fI7nEQvujIwWvl', '155142339752800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('0jYv8gfxmiS14dUaPLb', 'WB81MbCBolNg6XmE35M', null, '11e6-5531-4f3943bb-8350-a3b9b8447d61', '1', '11e6-5531-4f3943bb-8350-a3b9b8447d61', '155141105198900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('0KhZqiqyuY4SgHxRtJK', '2ytUeoxBqghwofmBALl', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'TkN4G3lj2mZ4XOo0kVQ', '154461619005400002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('0KL8GKTmu9znRPVcUfk', '0Q0LkJpfR1ejtO8rD3p', null, 'Vu8Q68Bom89YJDgguC9', '1', 'pTuo29zZfTBXXiWv0y7', '155168789423400002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('0kWm0b9EHsYyNiYZwlr', 'jkpTHKg7DpuXQrppVxx', null, 'w7IsSOtXFvo61cP8sKr', '1', 'w7IsSOtXFvo61cP8sKr', '155142353083100004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('0L23D5jKf8FybgSUbGQ', '2ytUeoxBqghwofmBALl', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'PJTrl1ydDfvxVoyGPXp', '154461618969500001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('0L7v5U4YjGV8yHyxbuW', 'WB81MbCBolNg6XmE35M', null, '11e6-552e-bba4b939-8350-a3b9b8447d61', '1', '11e6-552f-69fb9d37-8350-a3b9b8447d61', '155141104902500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('0LsgEJhFYf4upQe7BXO', 'kPLbeydkgiYW6NIkCt0', null, '0bmAo7ylNxrpnAXlqnb', '2', '0bmAo7ylNxrpnAXlqnb', '155168804522700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0LXWsaCZumEqfMXnT7Y', 'jkpTHKg7DpuXQrppVxx', null, 'XtaVH2y40O9zvIVALWj', '1', 'bufGP6tY9wwjTOfXum5', '155142353011300001', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('0mmjAFqL3A3IANrI06e', '2jSs6cnzu4mzY9C13vF', null, 'vDsnTykdPOblfwEF4mR', '1', 'vDsnTykdPOblfwEF4mR', '155142339874500004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('0Nh0lPfCSNyWyMEeUC8', '0Q0LkJpfR1ejtO8rD3p', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'xEBN59fWrxYULgpdRLy', '155168789343800004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('0nOfpSiZVGwy2tdR0qA', '3tFw1boS5L9vXoJCr6Z', null, '7giYu3zk1hrdILU9eCl', '2', '7giYu3zk1hrdILU9eCl', '154563949472600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0ONhDwVgsCazZr7WISS', 'WB81MbCBolNg6XmE35M', null, '11e6-55fe-4ea6ff8f-bb59-b7243d4bcf51', '1', '11e6-55fe-6847f8f8-bb59-b7243d4bcf51', '155141105013300002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('0OPUB9p7lkdWpgbEt6E', 'WB81MbCBolNg6XmE35M', null, '11e6-561b-ab4832d4-91c5-cd8abd28b1f9', '2', '11e6-561b-ab4832d4-91c5-cd8abd28b1f9', '155141104757400002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0Q9xLVngMtBXioeKays', '2jSs6cnzu4mzY9C13vF', null, 'Kb6r6jvJBO7WdcyIqFH', '2', 'Kb6r6jvJBO7WdcyIqFH', '155142339568800004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0qBTPqfylVYp9lmKloa', '2jSs6cnzu4mzY9C13vF', null, '9ppSV2PIKNhHCOwufvI', '0', '1vKJVgUjJInvLMSVXIn', '155142339862000001', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '36', '1');
INSERT INTO `t_permission` VALUES ('0RyX1Ltzf7gUM2Bhvr4', '0Q0LkJpfR1ejtO8rD3p', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'PJTrl1ydDfvxVoyGPXp', '155168789375000001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('0rZsFc2rq4HWMjxu6N6', '2ytUeoxBqghwofmBALl', null, 'XzgpTEte9Q1JQswSETz', '0', 'oTrq3HVrCNx1jALWUgh', '154461619097600003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('0s6E44KKCTZLdrjCdfi', 'WB81MbCBolNg6XmE35M', null, '11e6-5e03-37c3a477-ae15-3d6b584ebd70', '2', '11e6-5e03-37c3a477-ae15-3d6b584ebd70', '155141104760500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0ShaeNraz0i58sGzpeP', '0Q0LkJpfR1ejtO8rD3p', null, 'Q1jIFlIQgvrxXHuYM9L', '2', 'Q1jIFlIQgvrxXHuYM9L', '155168789314200004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0TqqCdbbrWuw2Dnajaa', 'jkpTHKg7DpuXQrppVxx', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'GWNOfrdfU2z2hYo2y6Q', '155142353090900001', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('0UkVP31YB84VcBhcLcD', '0Q0LkJpfR1ejtO8rD3p', null, 'Tm9KRBnKnzjuuld7bJh', '0', '5GCo50RaCJdscjJW16V', '155168789396900003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('0UNM71SLv2QHa0ydt9J', '2jSs6cnzu4mzY9C13vF', null, 'ddbeKTjs0WvqKVJ90MU', '1', '8S96fbM0hHIvN2tHSUq', '155142339690400000', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('0UUoLa0JCEVrvXFZv7y', '3tFw1boS5L9vXoJCr6Z', null, 'w7IsSOtXFvo61cP8sKr', '1', '0km7YEvweo5SVWbQlku', '154563949549100000', 'HdPeBqYwJyFyjHkhZu3', '归档', '45', '1');
INSERT INTO `t_permission` VALUES ('0wnIl52l6PnLgjKWHt2', '2jSs6cnzu4mzY9C13vF', null, 'Ry5YZ6oWsbQSIWGTbiM', '2', 'Ry5YZ6oWsbQSIWGTbiM', '155142339576600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0xfQBTNVchQmOtrqS5U', 'WB81MbCBolNg6XmE35M', null, '11e6-4f27-1f4a23d7-81e8-cb77e1bc6c59', '1', '11e6-4f27-1f4a23d7-81e8-cb77e1bc6c59', '155141104799500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('0XKfAYon8TCnsEkQrwZ', '2jSs6cnzu4mzY9C13vF', null, 'gHKBmQ7kx8ThwKaSbuk', '2', 'gHKBmQ7kx8ThwKaSbuk', '155142339582800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('0XwsrTPdewLlurqpa0C', 'WB81MbCBolNg6XmE35M', null, '11e6-54b2-7bfe8b70-9671-379f935a9949', '0', '11e6-59f3-d505c9b9-ab5d-51da01f3eda4', '155141104932100001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('0zd2oO9XDwzbBm0Ntej', '2jSs6cnzu4mzY9C13vF', null, '1fhgTUPecMY0ajlTkKZ', '0', 'UiotHIXmy0M1EdhhF8k', '155142339763800003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('0zGCMl5RjiUe7FzsDPa', '0Q0LkJpfR1ejtO8rD3p', null, 'WHKujMuxTp67TYMu80o', '0', 'ti2S70c11piGDmryGEq', '155168789457700003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('10K7JGgoQSbxJoXN5oY', '3tFw1boS5L9vXoJCr6Z', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'xEBN59fWrxYULgpdRLy', '154563949486600001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('10WzjN9A5FcSJcBzc0z', '0Q0LkJpfR1ejtO8rD3p', null, 'JmxxVKFmtiAV278992Z', '2', 'JmxxVKFmtiAV278992Z', '155168789320400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('11oMI6yfOjtfukRlJtV', '2jSs6cnzu4mzY9C13vF', null, 'IMD35YU4FNWL8IkwPAJ', '1', 'IMD35YU4FNWL8IkwPAJ', '155142339707600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('11x1jVfCGAxfUUhgis0', 'kPLbeydkgiYW6NIkCt0', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K8Lx8Yr2KhbHQo4z25I', '155168804561700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('120bD1BDhEorKALD40x', '3tFw1boS5L9vXoJCr6Z', null, 'jWiazgyndKfhYY4uvW8', '2', 'jWiazgyndKfhYY4uvW8', '154563949422600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('13fFMX0tTS8Tl03RwHN', '2ytUeoxBqghwofmBALl', null, '4oavihvP4J8cXDsWDIP', '0', 'FRLJFxdshvQAeKmHSfM', '154461618897600000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('13qeZ2bWSAkm0CKjxp5', '3tFw1boS5L9vXoJCr6Z', null, 'jgNQbAPescA30mzAxWy', '2', 'jgNQbAPescA30mzAxWy', '154563949460100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1429TVZQMb49J9qf3xQ', 'kPLbeydkgiYW6NIkCt0', null, 'enhnCZbrTQ1mZpn18o5', '0', 'u8rE2hHMPcvxRUXgNQk', '155168804635000002', 'HdPeBqYwJyFyjHkhZu3', '更新所选记录', '1', '1');
INSERT INTO `t_permission` VALUES ('17sYnVBzI9UMh77pVyd', 'kPLbeydkgiYW6NIkCt0', null, 'NaZcYrbGaXxrTGcsd2M', '1', 'NaZcYrbGaXxrTGcsd2M', '155168804669300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('18VyqYqIE5EHvzj5Aj1', '2jSs6cnzu4mzY9C13vF', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'cAu7pZ4IzsfytkdYNLM', '155142339660800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1AGkxkMp9MBDhBxRZFV', 'WB81MbCBolNg6XmE35M', null, '11e6-5489-8ff2b70c-9671-379f935a9949', '0', '11e6-5489-a5010949-9671-379f935a9949', '155141105072500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1ajBGRbBq2D7ktYoSQu', '3tFw1boS5L9vXoJCr6Z', null, 'GhbQPNIblLICNGTEwqX', '0', '2YA8KZ2P1yC1f0g2Nzs', '154563949528800002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1aX8woZi5gw0kLRjpHe', '3tFw1boS5L9vXoJCr6Z', null, 'wsNAf0ykJEwUgvGWWKN', '2', 'wsNAf0ykJEwUgvGWWKN', '154563949467900004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1B3zsZtu1Cn0R72WxCd', '2jSs6cnzu4mzY9C13vF', null, 'IiQlslLmgrgXGsdYY0S', '2', 'IiQlslLmgrgXGsdYY0S', '155142339578100004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1beuDYB4MJtgLzhhpbY', 'WB81MbCBolNg6XmE35M', null, '11e6-54a7-2bd353aa-9671-379f935a9949', '1', '11e6-54a7-2bd353aa-9671-379f935a9949', '155141105103700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1BNEunmAUguSGqgF6Q9', 'jkpTHKg7DpuXQrppVxx', null, 'k3Ro7OsGafHyoiDAeLl', '2', 'k3Ro7OsGafHyoiDAeLl', '155142353006600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1Bt2WFvLynvIgUOg5Eh', '0Q0LkJpfR1ejtO8rD3p', null, 'bKWrnsYGUGaqqYqkeeO', '0', 'eKS6W5ObdgLXuBIKcJP', '155168789490500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1cp1YFomci8ryNMtwob', 'kPLbeydkgiYW6NIkCt0', null, '06Me4ssjoGBiKz0gMK2', '0', 'ZEh1qpMCAgYe10KWd1j', '155168804663100001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1CvVoXg4JzRxP7B3Wif', '0Q0LkJpfR1ejtO8rD3p', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'D4TlyirrG1V4ebAqUSh', '155168789463900001', 'HdPeBqYwJyFyjHkhZu3', '删除（右键菜单）', '3', '1');
INSERT INTO `t_permission` VALUES ('1cZNePWGwAHZITUG4BS', '2ytUeoxBqghwofmBALl', null, '9ppSV2PIKNhHCOwufvI', '0', 'OPN8L9J3OMzySIcqldf', '154461619102300000', 'HdPeBqYwJyFyjHkhZu3', '跳转', '1', '1');
INSERT INTO `t_permission` VALUES ('1dLX62Vdm25zHmku38U', '0Q0LkJpfR1ejtO8rD3p', null, 'zg2t1qqkaJ17B2vvX05', '0', 'COoHnOHkHeviVNasUlf', '155168789460800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1dmAgLHzWqVldi21BKs', 'WB81MbCBolNg6XmE35M', null, '11e6-5618-77e4407a-91c5-cd8abd28b1f9', '2', '11e6-5618-77e4407a-91c5-cd8abd28b1f9', '155141104771500004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1Don2JuQ1w3ksHbiJ17', 'kPLbeydkgiYW6NIkCt0', null, 'hxDvvyWbvIEUUrBHW0R', '1', 'hxDvvyWbvIEUUrBHW0R', '155168804603800005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1DuZBSfhH0M3oq0F9M3', '2ytUeoxBqghwofmBALl', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'Bd1tki9fxPhsf7tARcy', '154461618914800000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('1e92MRgFPd0PK8fqb3u', '0Q0LkJpfR1ejtO8rD3p', null, 'mXDUC8go52mfA91GY0r', '0', 'fh4ptUZPIiHNtWvp0cJ', '155168789468600001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('1Fftea9oluRx5dbDQ3O', 'jkpTHKg7DpuXQrppVxx', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'lCdJ38yUB4mcSL1qJJ2', '155142353047200001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('1g2a8640w1Jf9wcRTOP', '3tFw1boS5L9vXoJCr6Z', null, 'nnoKRjbCpRVhzIQaulN', '1', 'nnoKRjbCpRVhzIQaulN', '154563949478800005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1g4DHX17Ynp8UgKR6Ii', '0Q0LkJpfR1ejtO8rD3p', null, 'EHYHRWZlyHZcXyKrAkr', '2', 'EHYHRWZlyHZcXyKrAkr', '155168789304800004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1Ggu6qAqzJIpn1iDet4', 'jkpTHKg7DpuXQrppVxx', null, 'QKYvQ00K4tWyyjKycUC', '0', 'ARs78PxB8dp6mXxPrKL', '155142353114300005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('1GSaGsKOkGtH7U9ifH2', 'jkpTHKg7DpuXQrppVxx', null, 'tAYVkaJnHAdVuffzuOr', '2', 'tAYVkaJnHAdVuffzuOr', '155142352966100006', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1H8CGuLGtK29Y522k9Q', 'kPLbeydkgiYW6NIkCt0', null, 'LfGA9FEokOkgKY6hN4p', '2', 'LfGA9FEokOkgKY6hN4p', '155168804507100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1hHjQ1oSYEvwDOWfVoE', '2jSs6cnzu4mzY9C13vF', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'wgw8EmPgt7pl1vVHHdz', '155142339710700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1HsQkZwDMMGslHPfGX9', '3tFw1boS5L9vXoJCr6Z', null, '6Xi7fyFJT20APl5y8RE', '2', '6Xi7fyFJT20APl5y8RE', '154563949452300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1HVVKNAWiweodhRH5j2', 'kPLbeydkgiYW6NIkCt0', null, 'NGN4SO4fu5S5XxULG4X', '1', 'TrHax0MzDGsTz4DFUoo', '155168804535100002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('1ii6eKBna7lmT2PLNmF', 'WB81MbCBolNg6XmE35M', null, '11de-c3cf-2a95f2b4-9ee5-25eb8f482137', '0', '11de-c3cf-63846080-9ee5-25eb8f482137', '155141104876000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('1Ij2CDqZodhjkYkbtqn', 'kPLbeydkgiYW6NIkCt0', null, '6arVIWht264qE2jDBdE', '2', '6arVIWht264qE2jDBdE', '155168804513300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1IogEqnB9LFkI7Ml8Ez', '2jSs6cnzu4mzY9C13vF', null, 'kCeLKcebSzaR6kBjWoC', '2', 'kCeLKcebSzaR6kBjWoC', '155142339598400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1ivqakGXooXkqFU0Nhl', 'kPLbeydkgiYW6NIkCt0', null, 'ypFGviMvQl4iVE8dOS0', '2', 'ypFGviMvQl4iVE8dOS0', '155168804471200005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1IvRKSVr1CppuxslLvI', '3tFw1boS5L9vXoJCr6Z', null, '06Me4ssjoGBiKz0gMK2', '0', '8Hhv2rO3YipCX5JageH', '154563949619500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('1iyTWccSW3E4RdOcUqa', '0Q0LkJpfR1ejtO8rD3p', null, '4VkP5W8VPlERMiThvSD', '0', 'x4yYcPQJrgbYvpcebr5', '155168789417100001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('1jfpCkeyCryfUKu1yGW', '0Q0LkJpfR1ejtO8rD3p', null, '68kltzfu9ZSUp9aJOg4', '2', '68kltzfu9ZSUp9aJOg4', '155168789317300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1jhLiBvpxaGRw7vhzpi', '2jSs6cnzu4mzY9C13vF', null, '36v96aPARGPLLLpXBt5', '2', '36v96aPARGPLLLpXBt5', '155142339612400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1jmsgv6cnYKi8qD4UFE', 'jkpTHKg7DpuXQrppVxx', null, 'gniImP2ug7E82S1WO0L', '1', '2GBc0jCYf23ydklhe3I', '155142353109600001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('1kJrn1ZjGHgxtoTrxw7', '2ytUeoxBqghwofmBALl', null, 'L7O7fkCLsVh7KYd0RIy', '1', 'L7O7fkCLsVh7KYd0RIy', '154461619039800005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1kpZk3GkFVjlwmK6fw3', 'WB81MbCBolNg6XmE35M', null, '11e4-f55e-a41c0c48-8ba2-ddf836b3c03f', '0', '11e5-f494-f1b0535f-bf05-733864b5145f', '155141104838500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '43', '1');
INSERT INTO `t_permission` VALUES ('1KtKAw6nFIC2WMB4RGJ', 'WB81MbCBolNg6XmE35M', null, '11e5-9273-3f22d663-9db1-913f1ac2a256', '0', '11e5-9273-72f919a0-9db1-913f1ac2a256', '155141104880700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1LCUPqBQllPFB882Pm1', '0Q0LkJpfR1ejtO8rD3p', null, 'AeQX2k6Or75tfUuty4K', '2', 'AeQX2k6Or75tfUuty4K', '155168789317300004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1lJ3VOq3QNmDQEpMvie', 'kPLbeydkgiYW6NIkCt0', null, 'smthlnru9z9qwavJKk1', '0', 'AHJzoQDdLpyRpZLTTdK', '155168804674000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('1lvQVq8laytXRaIuBIk', '2jSs6cnzu4mzY9C13vF', null, 'F0SEYWEOMkZjQU2f0R1', '2', 'F0SEYWEOMkZjQU2f0R1', '155142339610900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1M1tZ4tIeSN6bUCZOMf', '2jSs6cnzu4mzY9C13vF', null, '6r0MsymflCeuD0Rrz4G', '2', '6r0MsymflCeuD0Rrz4G', '155142339548500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1mRqr6NWJWJSeVBkMpY', 'kPLbeydkgiYW6NIkCt0', null, 'bkoXpI9ilQlOYD8wsbU', '1', 'bkoXpI9ilQlOYD8wsbU', '155168804588200005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1mYX1hJJWGcSFxSee1s', '0Q0LkJpfR1ejtO8rD3p', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'fu3FPAvy3QbJl8Y96P7', '155168789410900003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1naav5PDb0rseMXRBJV', 'kPLbeydkgiYW6NIkCt0', null, 'ZB7liHeZS7Qm0mlMz6b', '2', 'ZB7liHeZS7Qm0mlMz6b', '155168804513300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1oNbmrNNkEOeOG0dcCg', '2jSs6cnzu4mzY9C13vF', null, '6BIvNJISOeZ3xm8S2aG', '1', '4TEeGoSPUfMP6R1Dxgq', '155142339659200001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('1P8sX5sInHyvQ7u7qC2', 'WB81MbCBolNg6XmE35M', null, '11e6-561b-6c723b01-91c5-cd8abd28b1f9', '2', '11e6-561b-6c723b01-91c5-cd8abd28b1f9', '155141104785500003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1pfOVJPhJZnxS1Tf2Un', 'kPLbeydkgiYW6NIkCt0', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'SmYDAD9eEDzqIUvO99F', '155168804574100001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('1PLc25FzDHYxRxFOyQd', 'WB81MbCBolNg6XmE35M', null, '11de-a1d8-03df0a0e-a188-7710f5ef0f5e', '0', '11de-a1db-ce8a3fa0-a188-7710f5ef0f5e', '155141104822900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1popKxx9ovty7Cl07Ed', 'jkpTHKg7DpuXQrppVxx', null, 'CjR2ngF0kCrKnCpD0rj', '1', '5KOAZ5zATQsht3hJjXs', '155142353034700000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('1qeb9mOk7j02B9OGRg1', '0Q0LkJpfR1ejtO8rD3p', null, 'G0WtPO1mX58wd7tjkTy', '0', 'XIYtwtem4lZYZBYOfS5', '155168789421800002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('1QKPUYRnTOQiEaU1HXh', '2jSs6cnzu4mzY9C13vF', null, 'BXWlXtLv3yNVPzVHd1A', '2', 'BXWlXtLv3yNVPzVHd1A', '155142339620200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1rlOxD8mSF5U0eL2UBL', '2ytUeoxBqghwofmBALl', null, 'gniImP2ug7E82S1WO0L', '1', '2GBc0jCYf23ydklhe3I', '154461619067900005', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('1tdPsGh2IxKBgOxgo2T', '2jSs6cnzu4mzY9C13vF', null, '6Xi7fyFJT20APl5y8RE', '2', '6Xi7fyFJT20APl5y8RE', '155142339587500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1tE2gtYC6sGwzOwRRmz', '0Q0LkJpfR1ejtO8rD3p', null, '27MTAjC7JxdEukQ4fFY', '2', '27MTAjC7JxdEukQ4fFY', '155168789297000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1tQnFWplIdiR0xNNZUj', 'kPLbeydkgiYW6NIkCt0', null, 'exsIaz9QN0WD65u23jd', '2', 'exsIaz9QN0WD65u23jd', '155168804525800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1UNfEUP5tiMlZMcs0Jt', 'kPLbeydkgiYW6NIkCt0', null, '4RJ5cYekBtB1RdNDxL3', '1', '2WEniL1FLLpXKQfd5XU', '155168804589700002', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('1wAWvynmG09qh0kAeoM', 'jkpTHKg7DpuXQrppVxx', null, 'gniImP2ug7E82S1WO0L', '1', 'Ap8uKeL5gioGlQk65eL', '155142353108000006', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('1wEND9MjmGipbxlppv2', '3tFw1boS5L9vXoJCr6Z', null, 'jhINwVUWllGph0gnSC6', '0', 'CbRpWeZs7qQG3vfc9YZ', '154563949525700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('1WzDEND5xi5FvFbiAX5', 'WB81MbCBolNg6XmE35M', null, '11e3-99fe-5dd46414-82a9-5d3e655b6861', '0', '11e4-ceb2-62581e7c-b2a1-b5b94c6fcd94', '155141104829200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '导出Excel', '16', '1');
INSERT INTO `t_permission` VALUES ('1x3JqnIG5mnXz5xj0gH', '0Q0LkJpfR1ejtO8rD3p', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'I5GJXxDs9LYwwqf4uQv', '155168789398400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1y6ZCJ53bDzd3m1yPHx', 'kPLbeydkgiYW6NIkCt0', null, 'U1TygLjjsSxDfEoGwhc', '1', 'U1TygLjjsSxDfEoGwhc', '155168804536700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1yBZ91cLLImGPj7AR1I', 'kPLbeydkgiYW6NIkCt0', null, 'SiPTeSpUhRIqVgi1HW1', '0', '75x9tz4gNnPZBrKKcK5', '155168804600700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('1YL8UVjZ3TFErVIHNb4', '0Q0LkJpfR1ejtO8rD3p', null, 'ezzP5oVH4ywB1HmiObF', '1', 'ezzP5oVH4ywB1HmiObF', '155168789435900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1yshQFFRENNwNJ0LSFS', '3tFw1boS5L9vXoJCr6Z', null, 'a7jp1Dm53YjlAwDWuws', '1', 'UFBBbyiSeV5fpFq1Apn', '154563949541300004', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('1YuTOdGomHFj0crYxBc', 'jkpTHKg7DpuXQrppVxx', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'IHazLikeEs3KYw5CBgr', '155142353154800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1YYsV32YNJ9uXzMibEp', 'WB81MbCBolNg6XmE35M', null, '11e6-55fd-5295e1d1-bb59-b7243d4bcf51', '1', '11e6-55fd-a0b4a988-bb59-b7243d4bcf51', '155141105003900002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('1Z81lXXulfsWVZlq08u', '2jSs6cnzu4mzY9C13vF', null, 'tfxROndy5dmj8HKxpkX', '2', 'tfxROndy5dmj8HKxpkX', '155142339626500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1zaWRlhNlBWDHp51Fg9', '3tFw1boS5L9vXoJCr6Z', null, 'j4ncSyWthzCYoNj3n4J', '0', 'KVWnOmmml6Kwm3w1RPe', '154563949583500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1ZCPwftZ7wYoCDilj9c', '2ytUeoxBqghwofmBALl', null, 'kqrKj5I16CqjnePUq0G', '1', 'kqrKj5I16CqjnePUq0G', '154461618757000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('1ZJQ2LaM2yGvPGLtFqq', '3tFw1boS5L9vXoJCr6Z', null, 'sMlqIILsNZ3bvqE2hSm', '1', '7gZkOqMaP3BBCXPapf5', '154563949486600002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('1zkFZvNuUWMY1myrbSU', 'jkpTHKg7DpuXQrppVxx', null, 'j4ncSyWthzCYoNj3n4J', '0', 'KVWnOmmml6Kwm3w1RPe', '155142353111200004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('1zOKr1lvgZ2j3YSXv1B', '0Q0LkJpfR1ejtO8rD3p', null, 'ECNTZk993cE71dxVqsx', '2', 'ECNTZk993cE71dxVqsx', '155168789323500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('1zqYg0zBDf0qh1rx7IU', '2jSs6cnzu4mzY9C13vF', null, '9ppSV2PIKNhHCOwufvI', '0', 'OPN8L9J3OMzySIcqldf', '155142339862000003', 'HdPeBqYwJyFyjHkhZu3', '跳转', '1', '1');
INSERT INTO `t_permission` VALUES ('1zud6rxL2EeQ5ZyzAry', 'kPLbeydkgiYW6NIkCt0', null, 'FKEDNCysUfAav1gze8O', '2', 'FKEDNCysUfAav1gze8O', '155168804510200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('203l6El2wwKBzvTb4CG', '0Q0LkJpfR1ejtO8rD3p', null, 'NGN4SO4fu5S5XxULG4X', '1', 'NGN4SO4fu5S5XxULG4X', '155168789342300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('21Y6IWM7wKwsvCMuSDs', 'kPLbeydkgiYW6NIkCt0', null, 'qX2GQGpdWwGnelcjHZP', '2', 'qX2GQGpdWwGnelcjHZP', '155168804466500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('22ZyemIWoo9aCQFdi6b', '0Q0LkJpfR1ejtO8rD3p', null, 'LfGA9FEokOkgKY6hN4p', '2', 'LfGA9FEokOkgKY6hN4p', '155168789320400003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('24mjLNvDJm8rY3LXcfP', '2ytUeoxBqghwofmBALl', null, 'U1TygLjjsSxDfEoGwhc', '1', 'hdiqWVc1ZHENK9nuZv5', '154461618927300005', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('24VuIaibEcOwPg5oUvi', 'jkpTHKg7DpuXQrppVxx', null, 'p44Eh34DScjVKkZi1ok', '2', 'p44Eh34DScjVKkZi1ok', '155142352964500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('26MkXehJ5gV0uGVes04', '2jSs6cnzu4mzY9C13vF', null, 'g7U0PGtN5bKYhwbka6s', '0', 'VXaTIyUn85r0Xf2ja64', '155142339748200001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('26xm5S7Mfursl6avG0l', 'WB81MbCBolNg6XmE35M', null, '11e6-53e6-73b34240-81f5-679a826556ce', '1', '11e6-53eb-a75d539a-81f5-679a826556ce', '155141105111500002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('29xCh3qJkb5wG05jfXy', 'jkpTHKg7DpuXQrppVxx', null, 'IMD35YU4FNWL8IkwPAJ', '1', 'IMD35YU4FNWL8IkwPAJ', '155142353036300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('29ZDFTQinTdZJewOqUM', 'WB81MbCBolNg6XmE35M', null, '11e6-5ba7-2f6939ba-a270-539aa660c6fc', '2', '11e6-5ba7-2f6939ba-a270-539aa660c6fc', '155141104780800003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2a6nQL3GGM1stfBx1FT', '2ytUeoxBqghwofmBALl', null, 'EKD2uh12ht0Vptz9xN5', '0', 'ThJH0AWU99Z8F5DDmUo', '154461618974200007', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('2ACeIDP4x0yHjZTyvse', 'jkpTHKg7DpuXQrppVxx', null, 'iL3YpikkZUlruc5ai3D', '1', '2HH7snENERzvRumcFTa', '155142353023800000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('2aPbDB1m3xJz7ztjaX8', 'kPLbeydkgiYW6NIkCt0', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'LjTWOCClNPbDkDtAgoQ', '155168804639700000', 'HdPeBqYwJyFyjHkhZu3', '删除（字体图标红色 ）', '3', '1');
INSERT INTO `t_permission` VALUES ('2AWdBc9BVVYqNaqMRTX', '3tFw1boS5L9vXoJCr6Z', null, 'mXDUC8go52mfA91GY0r', '0', 'P2oUhWPVibevLu0mKhp', '154563949605400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('2bnU52ooAUtffAlMPz6', '3tFw1boS5L9vXoJCr6Z', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'P1pXLZ0kw9I6axwJEcd', '154563949492900003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('2cbYn6sx7dGsOQ6tl2I', '3tFw1boS5L9vXoJCr6Z', null, 'lAUkIpgQSIZqQyttrB4', '1', 'lAUkIpgQSIZqQyttrB4', '154563949507000004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('2dF7YtW1vxA9IKZq0MJ', 'kPLbeydkgiYW6NIkCt0', null, 'J9uhQYSQWhPor4IvkOE', '0', 'J9uhQYSQWhPor4IvkOE', null, 'HdPeBqYwJyFyjHkhZu3', '自定义报销单', '1032', '1');
INSERT INTO `t_permission` VALUES ('2dkMXdeCHCJvE6ebJfH', 'kPLbeydkgiYW6NIkCt0', null, 'eLFjqFngRQrIkbsdeBd', '1', 'FdZlsUl66zL94sGKwVe', '155168804658400001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('2DNi94cILRFOVnGyQZt', '0Q0LkJpfR1ejtO8rD3p', null, 'tfxROndy5dmj8HKxpkX', '2', 'tfxROndy5dmj8HKxpkX', '155168789336000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2eetUiTumaqdZ9ta9ms', '0Q0LkJpfR1ejtO8rD3p', null, 'kqrKj5I16CqjnePUq0G', '1', 'kqrKj5I16CqjnePUq0G', '155168789431200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('2ELTjlBDR1AhVdnefVq', 'jkpTHKg7DpuXQrppVxx', null, 'mNVKo7InVqtGMI8pWnS', '2', 'mNVKo7InVqtGMI8pWnS', '155142352978600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2fGwH33EOH8O35r2R5O', 'kPLbeydkgiYW6NIkCt0', null, 'WrG5tW3KzqYHU2QYywI', '2', 'WrG5tW3KzqYHU2QYywI', '155168804508600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2G8NGSUtFwUIb9lnotX', 'kPLbeydkgiYW6NIkCt0', null, 'QfirpboG4MjuFdj8mbs', '2', 'QfirpboG4MjuFdj8mbs', '155168804477400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2gJqhqk77nM5HN0xE6Y', '3tFw1boS5L9vXoJCr6Z', null, '7q6BJWxhJzTuAFZpxa8', '2', '7q6BJWxhJzTuAFZpxa8', '154563949417900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2GzC0BoJG7FjWEd7G1N', '0Q0LkJpfR1ejtO8rD3p', null, 'ir2OPEdZvttSUxAzfmD', '1', 'ir2OPEdZvttSUxAzfmD', '155168789345400004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('2H4AY3McwabvD2SLyuH', 'jkpTHKg7DpuXQrppVxx', null, 'eLFjqFngRQrIkbsdeBd', '1', 'FdZlsUl66zL94sGKwVe', '155142353145500003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('2HPDzo7O84RokM4kRVI', '3tFw1boS5L9vXoJCr6Z', null, 'U945OMsdX9fvzRjE7xG', '0', 'S1V13oV2ZMjKmg0oiLO', '154563949519500002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('2hTgBjmG4OhoEDAIcov', '2jSs6cnzu4mzY9C13vF', null, 'MsyfStEFzDcCB1VPbYJ', '1', 'MsyfStEFzDcCB1VPbYJ', '155142339877600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('2i8upFouOq6iV4MBIe0', '2jSs6cnzu4mzY9C13vF', null, 'enhnCZbrTQ1mZpn18o5', '0', 'u8rE2hHMPcvxRUXgNQk', '155142339860500003', 'HdPeBqYwJyFyjHkhZu3', '更新所选记录', '1', '1');
INSERT INTO `t_permission` VALUES ('2I9GNPfxvYBS4xB7gTF', 'WB81MbCBolNg6XmE35M', null, '11e6-54a1-8e46ef97-9671-379f935a9949', '1', '11e6-54a6-ab79a8cb-9671-379f935a9949', '155141105080300002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('2inioAZAZwnaLJmuJDn', '0Q0LkJpfR1ejtO8rD3p', null, 'htuZKnVCqioBBZD9Tg4', '2', 'htuZKnVCqioBBZD9Tg4', '155168789289200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2JO4ByCtZ3yoWHdx7Ir', 'jkpTHKg7DpuXQrppVxx', null, '3K4lxgBhBLAbzJrfYaB', '1', 'j2jPRJ7cK9BqO2p9iP9', '155142353167300001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('2jP0ZvXTA06ElckKLgl', '2jSs6cnzu4mzY9C13vF', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'TdjwkbcPtyWwzr47Pw5', '155142339662400001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('2ke16Gl6XhGV5n3G5ir', 'kPLbeydkgiYW6NIkCt0', null, 'dtXU9EYYl4qLe8PdIVc', '0', 'k1Bk7XRgKJ0522NyIQs', '155168804572600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('2KnIgSiDuIjv5tBfTCv', 'jkpTHKg7DpuXQrppVxx', null, 'JUpr2SmaIGVASTdp53r', '2', 'JUpr2SmaIGVASTdp53r', '155142352959800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2KXQfSPJnyCGT1HTw3c', '2ytUeoxBqghwofmBALl', null, 'Gc5icb2c0g8ARf7Jath', '0', 'SLsJFM3QWPsTiAQbQRE', '154461618917900000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('2l4DwOwjsoHOPkS5rXX', 'kPLbeydkgiYW6NIkCt0', null, 'F6reQ5BW7P6q236Pi13', '1', 'wK7VlAkGcNMtWEsCCF2', '155168804652100000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('2liupwfqIMVZKpMhBKf', '3tFw1boS5L9vXoJCr6Z', null, 'YLmf4h3xwvzrU2wJmYU', '2', 'YLmf4h3xwvzrU2wJmYU', '154563949469500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2mQL8rVZSvIxZagpArl', '0Q0LkJpfR1ejtO8rD3p', null, 'ZM7F9MjjscP8bADF7cH', '1', 'aN0KA8MmhVB1LjOqtWo', '155168789364100005', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('2Nbkz1wPoXmmXvf8Yph', '3tFw1boS5L9vXoJCr6Z', null, 'mL5IgApmFXBzpokqr1u', '1', 'iGHzzDNLilKMQkssnXP', '154563949566300000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('2Nd4GiRCXOTwqVkVbam', 'kPLbeydkgiYW6NIkCt0', null, '5RZRK7Jt5vyqwlIccop', '1', 'n7ODSabeRv0h2pyGxhm', '155168804563200003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('2nV0pzmT80bbjsLMgeX', '3tFw1boS5L9vXoJCr6Z', null, 'ECNTZk993cE71dxVqsx', '2', 'ECNTZk993cE71dxVqsx', '154563949461600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2O9FnYLNPXISKYgEn0P', 'kPLbeydkgiYW6NIkCt0', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'IajyYUcsSuyg4dFRXdR', '155168804633400001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('2OIijKsUKWBTJutdOxJ', 'kPLbeydkgiYW6NIkCt0', null, '5RZRK7Jt5vyqwlIccop', '1', '5RZRK7Jt5vyqwlIccop', '155168804563200002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('2oxhE45hq3RnT1xmkah', 'kPLbeydkgiYW6NIkCt0', null, 'iDzESIHQQFeI8FiDtGE', '2', 'iDzESIHQQFeI8FiDtGE', '155168804468100005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2pe9Pmm8DYmNGx5ZXzz', 'WB81MbCBolNg6XmE35M', null, '11e6-5e0c-5b614a82-ae15-3d6b584ebd70', '1', '11e6-5e0c-788b43e7-ae15-3d6b584ebd70', '155141104997700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('2Q1MuvJRjGIHJzR7xzE', '2ytUeoxBqghwofmBALl', null, 'BrbFcB3ptMyxdPl5W6u', '0', '1JVZYNRouHUK7MH0xzc', '154461618938200003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('2qdMimGhrWj9vjt1QE6', '0Q0LkJpfR1ejtO8rD3p', null, 'vZjJlrJAj7XdNX3czmS', '0', 'SG77mlxdPhjGgtckCUZ', '155168789382800002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('2qKbPGwzOJ6zkOADSnh', 'kPLbeydkgiYW6NIkCt0', null, 'WOmzvkui5ZsoZu1CogR', '1', 'i12huWXbQz9KJExHc6D', '155168804596000004', 'HdPeBqYwJyFyjHkhZu3', '文件下载(路径脚本需完善)', '26', '1');
INSERT INTO `t_permission` VALUES ('2rGjc1zuP0F96avwfho', '2ytUeoxBqghwofmBALl', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'QXO7cxkzLZ51qdiKBrI', '154461619136700003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('2SbtUWBkS94nT7bylJ2', '0Q0LkJpfR1ejtO8rD3p', null, '1QioSPqczT1xRrQBliu', '0', 'HxoUk6HtGOsbmINNEDW', '155168789390600003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('2T6u02WPZ7Ws3CfXtNI', '0Q0LkJpfR1ejtO8rD3p', null, 'rfmGjP7LXiQfxy15izp', '1', 'dUQn2CkeHgHGnGsR8JC', '155168789449900004', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('2TUrZDUV9n8xn4Vqq7U', '2jSs6cnzu4mzY9C13vF', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'Jbc2xwZhMLLNIjg0h02', '155142339731000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('2twRlrXlcgVmASWbtEC', '0Q0LkJpfR1ejtO8rD3p', null, '3sSURwczE2wMjgOqqOo', '0', 'rNGiDIRMmVUcl95QN9f', '155168789401500004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('2uu0M3mRuBT0lYBZGui', 'jkpTHKg7DpuXQrppVxx', null, 'sivHMH0kWQLjuMBG8z1', '2', 'sivHMH0kWQLjuMBG8z1', '155142352959800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('2wCBVal5fIia85cbUgi', 'kPLbeydkgiYW6NIkCt0', null, 'rfmGjP7LXiQfxy15izp', '1', 'rfmGjP7LXiQfxy15izp', '155168804617800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('2WdbBapIVOch6PIEUaH', '0Q0LkJpfR1ejtO8rD3p', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'ZLGOtOxZGBCsfXYeK15', '155168789442100001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('2Xnij58RSWiw6ZDnmZ8', '2ytUeoxBqghwofmBALl', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'APxRfhpMtHJp5vsjIIa', '154461619013200003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('2zPZqRuETwOZHdP8N2Y', '2ytUeoxBqghwofmBALl', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'weZ9Sz2X5RBVBRpCdJM', '154461619060100001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('31bJ9XtHQdXu81ss9FX', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-cbc22c98-91c5-cd8abd28b1f9', '2', '11e6-5619-cbc22c98-91c5-cd8abd28b1f9', '155141104763700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('328X246v3xojlVq92hK', '3tFw1boS5L9vXoJCr6Z', null, 'JdWD8biOlCXjkEvrwMm', '0', 'OLJQOfZpoAIKsZOpeqD', '154563949603800004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('36i1BDyJ1DQamgzg7at', '3tFw1boS5L9vXoJCr6Z', null, '6esIc2fTAI9nAOoOZcp', '1', '6esIc2fTAI9nAOoOZcp', '154563949499100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('37vg419lqTECIlrcjg2', 'kPLbeydkgiYW6NIkCt0', null, 'viwgtc32VtB7wJo2O8S', '0', 'Wlje8Nr2ww7qrmEwdBf', '155168804571000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('38hbAzJf5ZAawatA1YA', 'jkpTHKg7DpuXQrppVxx', null, 'IS48bOUKPFjCVejkBfd', '2', 'IS48bOUKPFjCVejkBfd', '155142353000400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('39GDKk0JH2qXwHLXmyq', '2jSs6cnzu4mzY9C13vF', null, 'ZM7F9MjjscP8bADF7cH', '1', 's0ipQa9ktbRum255G0J', '155142339699800002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('3aau4YMej6l0eGzaU54', 'jkpTHKg7DpuXQrppVxx', null, 'LHgnhFx0bsvuS1fUhBi', '0', 'bBLadEJMfkOsH44bqZy', '155142353053400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3AlCFk7aSHypqSGTSBw', '2jSs6cnzu4mzY9C13vF', null, '5RzsvfgAUx2y0k1pDlg', '0', 'NgNicpt0mPuprqEMquB', '155142339901000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3AW1c1eiqZzxccPJq35', '3tFw1boS5L9vXoJCr6Z', null, 'vO8pkCUFsC8T8Ur5qEn', '2', 'vO8pkCUFsC8T8Ur5qEn', '154563949450700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3awAprx5XPeqMBnhOVD', '2ytUeoxBqghwofmBALl', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'Zb272Z4FRc9su5s2Lik', '154461619103800000', 'HdPeBqYwJyFyjHkhZu3', '批量提交（图片图标）', '20', '1');
INSERT INTO `t_permission` VALUES ('3axEuCoUZKzGRZah3ON', '3tFw1boS5L9vXoJCr6Z', null, 'ID88NPj17JbpAMGYh9J', '2', 'ID88NPj17JbpAMGYh9J', '154563949463200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3b4NHbtfAWG8ckmHbPM', '0Q0LkJpfR1ejtO8rD3p', null, 'GhbQPNIblLICNGTEwqX', '0', 'CnYPYgX7tOKqpWia5h3', '155168789398400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3BejwoYrqbzuf71PKRo', '0Q0LkJpfR1ejtO8rD3p', null, 'Ueyt2ELhQd7E2oZ9cIi', '1', 'Ueyt2ELhQd7E2oZ9cIi', '155168789364100001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('3bK195TIqoVGEh7VsIf', '2jSs6cnzu4mzY9C13vF', null, '0bgD6IPDYyID2susbqZ', '0', 'q2Ay04xXzfVCDjfyvgH', '155142339765300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3c2GYQ0mf23chg9vr0X', '3tFw1boS5L9vXoJCr6Z', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'zubbDJQFaTursZKijlj', '154563949550700002', 'HdPeBqYwJyFyjHkhZu3', '自定义', '13', '1');
INSERT INTO `t_permission` VALUES ('3Ce9JjhJeOms8LJTZVZ', 'kPLbeydkgiYW6NIkCt0', null, 'LSwQOY0mggQ0vy4752p', '0', 'GrfqbEO7sjk3s3xGl3W', '155168804677100005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('3dFs19Wnx9dtX2ELq3V', '2jSs6cnzu4mzY9C13vF', null, 'ZM7F9MjjscP8bADF7cH', '1', '0LKFnyB5ViPnDQN8Ocl', '155142339699800001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('3dHosHwQwTcjXz0tvRz', 'WB81MbCBolNg6XmE35M', null, '11e6-5569-e32c800c-8350-a3b9b8447d61', '1', '11e6-d15f-0f93a05b-bbdd-9f7a0eebced4', '155141105167700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('3E8yWpfFCS4uI5UK32Q', 'kPLbeydkgiYW6NIkCt0', null, 'mXDUC8go52mfA91GY0r', '0', 'P2oUhWPVibevLu0mKhp', '155168804645900005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('3eF6jXceSRGnllHEGEF', 'jkpTHKg7DpuXQrppVxx', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'weZ9Sz2X5RBVBRpCdJM', '155142353150200002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('3EPTrKr2nnAjAfEIss1', '3tFw1boS5L9vXoJCr6Z', null, 'icLamwX0TBANfjhoCxB', '2', 'icLamwX0TBANfjhoCxB', '154563949416300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3EV9pZNYDKLdpmCVIgt', 'jkpTHKg7DpuXQrppVxx', null, 'Z6pISvulUdsSz8bjuOV', '0', '7nN7s8EOZ6SjZc0tEMY', '155142353070600000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3eW49spBoLm2Ae0lbHa', 'jkpTHKg7DpuXQrppVxx', null, 'fu3FPAvy3QbJl8Y96P7', '1', '5oWWmwFfmt1UTNzYcO7', '155142353086200003', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('3FiPuAxu5VMRgzawa7v', 'WB81MbCBolNg6XmE35M', null, '11e6-53c8-9cbf836c-81f5-679a826556ce', '1', '11e6-53c8-9cbf836c-81f5-679a826556ce', '155141104944600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('3Gd4FruakzewNTEtrNG', '2jSs6cnzu4mzY9C13vF', null, 'SYAJTXtkhpXsGIAqioF', '2', 'SYAJTXtkhpXsGIAqioF', '155142339582800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3gi5BR4Z7E5nAoVWPMO', 'jkpTHKg7DpuXQrppVxx', null, 'oeLOJO0f3CC02OjOOIC', '0', '6onRFmzn8mrnGdrnIJy', '155142353072200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3GqIQvXCydUkUt3pXXN', 'WB81MbCBolNg6XmE35M', null, '11e6-5e20-39f2170b-ae15-3d6b584ebd70', '0', '11e8-3d69-c7828429-bebe-676024ec99b8', '155141105233200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '网页打印', '36', '1');
INSERT INTO `t_permission` VALUES ('3H7jsm1rdOMro3yoZ9L', 'WB81MbCBolNg6XmE35M', null, '11e6-54c1-da28d861-9671-379f935a9949', '0', '11e6-592d-e6c306d9-a8ef-c39406c7f446', '155141104916500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('3hBQAVJgnhiyZybtPzu', '2ytUeoxBqghwofmBALl', null, '6bUPlXeVH92MIv7Nmdw', '1', 'ZNYYg5DdRtEMBaS3QLl', '154461618941300000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('3hGcN04Ktu0JbFHuG5h', 'kPLbeydkgiYW6NIkCt0', null, 'ZKzfdA0mMJy8MQ16L4e', '2', 'ZKzfdA0mMJy8MQ16L4e', '155168804466500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3hJHUJEFqyyrG3HJSOr', '0Q0LkJpfR1ejtO8rD3p', null, 'UmMnr5J8RhgknR3Dsos', '0', 'gxzuym0IWRzScvUoUk7', '155168789400000003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('3HK09l3JirjEEQndudT', '0Q0LkJpfR1ejtO8rD3p', null, '5RZRK7Jt5vyqwlIccop', '1', '5RZRK7Jt5vyqwlIccop', '155168789371900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('3Hu7eqJSvsOfFWikV4U', '2ytUeoxBqghwofmBALl', null, 'G0WtPO1mX58wd7tjkTy', '0', 'MiGkf6DvyyRTJk95EY3', '154461619046000000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('3iBlAzRjRLPiaaNxb3Y', '0Q0LkJpfR1ejtO8rD3p', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'zubbDJQFaTursZKijlj', '155168789412500001', 'HdPeBqYwJyFyjHkhZu3', '自定义', '13', '1');
INSERT INTO `t_permission` VALUES ('3ie7bDa1wKeFSGreTA1', 'WB81MbCBolNg6XmE35M', null, '11e6-5ead-f083c7a8-b0f0-d3a532217234', '2', '11e6-5ead-f083c7a8-b0f0-d3a532217234', '155141104776100002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3jFMqZR8H1LaiWzeE1a', '2jSs6cnzu4mzY9C13vF', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'iURMg4fbNkBkiB0qxra', '155142339712300000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('3jkItLl3oO5r522mjlt', '2ytUeoxBqghwofmBALl', null, '9ppSV2PIKNhHCOwufvI', '0', 'Qbqk2LB86r3acRInIHN', '154461618961700006', 'HdPeBqYwJyFyjHkhZu3', '刷新', '1', '1');
INSERT INTO `t_permission` VALUES ('3JV2gJ4LpwS9nVJk1cl', '2ytUeoxBqghwofmBALl', null, 'LSwQOY0mggQ0vy4752p', '0', 'PSPMnN2J3uJvKmrQ0mW', '154461619110100008', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3kMGCwHUtQRcUrS5m15', '2jSs6cnzu4mzY9C13vF', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'fW5mHIOMi7iJ4kftiPg', '155142339759100002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3KMxiHtpoB4w0NoNhUm', 'kPLbeydkgiYW6NIkCt0', null, 'Vu8Q68Bom89YJDgguC9', '1', 'o0LAsNjkLfWve8FIjmu', '155168804600700003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('3KsBdZybWOJLYg9PAca', '3tFw1boS5L9vXoJCr6Z', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'ZLGOtOxZGBCsfXYeK15', '154563949574100003', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('3MBc9PlSaZju2RvF0ub', '3tFw1boS5L9vXoJCr6Z', null, 'blVc1BNkTRUvVGde7Pj', '2', 'blVc1BNkTRUvVGde7Pj', '154563949463200004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3MCcvwSzpXBx0PySLI9', '2jSs6cnzu4mzY9C13vF', null, '1hPCUYj6dx9rMn0NAlL', '2', '1hPCUYj6dx9rMn0NAlL', '155142339557800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3MmWkqAdoZTXB9TUDMY', 'kPLbeydkgiYW6NIkCt0', null, 'g2XzgmKDL1T8UB79GZh', '0', '8yld9hcbZOKvZi6xp2Q', '155168804625600003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('3NKOUTt44cFBXABTAwQ', '0Q0LkJpfR1ejtO8rD3p', null, 'NLGiWBICUXkTNWcaaD0', '1', 'NLGiWBICUXkTNWcaaD0', '155168789432700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('3NRmQJEyJA1XmQ2pcyj', 'kPLbeydkgiYW6NIkCt0', null, 'epn8IcdUN0afirW9qZ6', '2', 'epn8IcdUN0afirW9qZ6', '155168804518000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3nXsziKco6ruc0LZ0NT', '3tFw1boS5L9vXoJCr6Z', null, 'HqyysOeWOVkmU29sLla', '0', 'NYq2pB1fAXTxVgfupIY', '154563949532000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('3OPcw8aCQfCieGFc9kA', 'jkpTHKg7DpuXQrppVxx', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'fu3FPAvy3QbJl8Y96P7', '155142353084600004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('3QDIVa7fVkENrjTl6pS', '2ytUeoxBqghwofmBALl', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'bVmZ9H8tKyNWZ4omc1a', '154461619116300000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('3qX4SZ63hvIBqFhA6UM', 'jkpTHKg7DpuXQrppVxx', null, '5RZRK7Jt5vyqwlIccop', '1', 'n7ODSabeRv0h2pyGxhm', '155142353044100001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('3QYohJU4PZpKsdossHB', '2ytUeoxBqghwofmBALl', null, 'enhnCZbrTQ1mZpn18o5', '0', 'iqufoXl2qzIWDFkt1Vi', '154461619099200005', 'HdPeBqYwJyFyjHkhZu3', '获取第一个查询条件的值', '1', '1');
INSERT INTO `t_permission` VALUES ('3qz7PsR8ZVOpVjrucCH', '2jSs6cnzu4mzY9C13vF', null, 'MtITrUcx3REq45LskT3', '0', '7vuhrOZQxA5vCOL1Nkw', '155142339885400004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('3reZhb03SJ6BU5SkaYP', 'kPLbeydkgiYW6NIkCt0', null, '27MTAjC7JxdEukQ4fFY', '2', '27MTAjC7JxdEukQ4fFY', '155168804475900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3s5rex4ptJ0Z43CmM7y', 'jkpTHKg7DpuXQrppVxx', null, 'Ueyt2ELhQd7E2oZ9cIi', '1', 'Ueyt2ELhQd7E2oZ9cIi', '155142353031600006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('3t967HqjKHH4esBvoaU', 'jkpTHKg7DpuXQrppVxx', null, 'vZjJlrJAj7XdNX3czmS', '0', 'Mk4H4HSkj1saDLiahVH', '155142353059700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3TeC17gf3iZcS3xyMJD', 'jkpTHKg7DpuXQrppVxx', null, '3sSURwczE2wMjgOqqOo', '0', 'xgvB9tVQZn0ZxoQMZ31', '155142353078400002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3TQjZVYJxvwK0XKMrcU', 'WB81MbCBolNg6XmE35M', null, '11e6-5477-569e3918-9671-379f935a9949', '1', '11e6-5477-569e3918-9671-379f935a9949', '155141105063200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('3TY8Na4MWOus6JfHP9A', '3tFw1boS5L9vXoJCr6Z', null, 'U1TygLjjsSxDfEoGwhc', '1', 'ih9o5BJcd9TxtaItt0i', '154563949485100005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('3UK6ndWtIOtP9HrovuJ', '0Q0LkJpfR1ejtO8rD3p', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '155168789376600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('3uyMveUyk6iqi57GJqi', '2jSs6cnzu4mzY9C13vF', null, 'CUiq0kurilZ2dSBIXUv', '0', 'Ksb2IhhfWaj5cJWTMwr', '155142339752800003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3V1ta2EEf4brEyNmb4j', '2jSs6cnzu4mzY9C13vF', null, 'YAsL41bmDXtb0dBUQcb', '2', 'YAsL41bmDXtb0dBUQcb', '155142339614000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3VmYiQKREKvmRy4kXCH', '2ytUeoxBqghwofmBALl', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'eTnoMZs9GI6BwMJq1Cn', '154461619007000004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3vqAu6C5iMq1ZuROxlb', 'kPLbeydkgiYW6NIkCt0', null, '4oavihvP4J8cXDsWDIP', '0', 'FRLJFxdshvQAeKmHSfM', '155168804614700002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3VrovNl3rOw6KZr0pGB', '3tFw1boS5L9vXoJCr6Z', null, '4mTMb4cMMoLDRa0FTzS', '2', '4mTMb4cMMoLDRa0FTzS', '154563949422600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3wzyYz8WwUZXLLvUHeK', '0Q0LkJpfR1ejtO8rD3p', null, 'WOmzvkui5ZsoZu1CogR', '1', 'i12huWXbQz9KJExHc6D', '155168789415600002', 'HdPeBqYwJyFyjHkhZu3', '文件下载(路径脚本需完善)', '26', '1');
INSERT INTO `t_permission` VALUES ('3XIjMzijCHoODSHp2MC', '2jSs6cnzu4mzY9C13vF', null, 'NyOvQfCmNxbiRG9N00v', '2', 'NyOvQfCmNxbiRG9N00v', '155142339589000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3Xl1yrYr1h1pJ6p8tGx', 'kPLbeydkgiYW6NIkCt0', null, 'EHYHRWZlyHZcXyKrAkr', '2', 'EHYHRWZlyHZcXyKrAkr', '155168804485200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('3xSHiOajoJUSBFj4hEF', 'kPLbeydkgiYW6NIkCt0', null, 'RW4FioZIBDuiBUAyIEB', '2', 'RW4FioZIBDuiBUAyIEB', null, 'HdPeBqYwJyFyjHkhZu3', '交叉1', '1002', '2');
INSERT INTO `t_permission` VALUES ('3yOwT1MmfjzjKFgVeTw', '2ytUeoxBqghwofmBALl', null, 'mXDUC8go52mfA91GY0r', '0', 'fh4ptUZPIiHNtWvp0cJ', '154461618992900001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3zEXVkdwxDh4BIBSWdz', '2ytUeoxBqghwofmBALl', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'Nmhce5xixb5FBPVv5dc', '154461618969500002', 'HdPeBqYwJyFyjHkhZu3', '此按钮不可见', '3', '1');
INSERT INTO `t_permission` VALUES ('3ZfeZfjGnaeYlC2Q1wf', 'kPLbeydkgiYW6NIkCt0', null, 'Jh68ppMt3QMha315Hi6', '0', 'ePkoYYvvztlUvkHqa16', '155168804572600001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3zKlZ1fGyI6lknDNFcm', '3tFw1boS5L9vXoJCr6Z', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'KMy1rLdwRmKATB4fMJZ', '154563949560100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('3ZMzd60tcmw3JkbMRDO', '2jSs6cnzu4mzY9C13vF', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K4IeXTdrXu7wZa0AkpH', '155142339715400001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('41CHPvJPWIrp4LA4pP9', 'WB81MbCBolNg6XmE35M', null, '11e6-53c1-c45f44a1-81f5-679a826556ce', '1', '11e6-5a28-4cda388e-9288-a3f5193ed8de', '155141104936800002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('42EejLJi76ekx8UmVOt', '3tFw1boS5L9vXoJCr6Z', null, '0zSRHMqiyMTl1dth7ds', '1', 'EbrSUqhaaWu3vkwQzkZ', '154563949497600000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('43ImUSUPa61xIUs2yXV', 'kPLbeydkgiYW6NIkCt0', null, 'RbRiCQx2QJQpvBYXZ2O', '0', 'XlLd3N6XsZV8ljvxjkp', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单12', '3', '2');
INSERT INTO `t_permission` VALUES ('44D2eMCnXeQcVyygbN9', '2jSs6cnzu4mzY9C13vF', null, '0zSRHMqiyMTl1dth7ds', '1', 'EbrSUqhaaWu3vkwQzkZ', '155142339678000002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('44om3sLmgVKoUnIeE30', '3tFw1boS5L9vXoJCr6Z', null, 'fWq4603Eftipw3SEKHB', '2', 'fWq4603Eftipw3SEKHB', '154563949421000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('47DXKFe8kSQJBeSVnak', '2jSs6cnzu4mzY9C13vF', null, 'vCWvTbPligxwrkrwAv8', '0', 'oyuPcAc1VAmt4JtNf7A', '155142339887000003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('47FWEZdaecybVOcIzTY', 'jkpTHKg7DpuXQrppVxx', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'zubbDJQFaTursZKijlj', '155142353086200000', 'HdPeBqYwJyFyjHkhZu3', '自定义', '13', '1');
INSERT INTO `t_permission` VALUES ('47H1kGiHGo3jvM7aWP1', '0Q0LkJpfR1ejtO8rD3p', null, 'BrbFcB3ptMyxdPl5W6u', '0', '6DhnKNo54979AgvQSGH', '155168789456100001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('48JcCvTTg7Cmrl8sa0q', '2ytUeoxBqghwofmBALl', null, 'OGMmff1QTZYqFk5vfeD', '1', 'OGMmff1QTZYqFk5vfeD', '154461618924200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('48StdKbbWciyoP5pxKF', 'jkpTHKg7DpuXQrppVxx', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'wuWQttnDBKAz7kQ2UMs', '155142353161100000', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('49IBcsK6DaQl3YXi01r', 'jkpTHKg7DpuXQrppVxx', null, 'bIBjrPWlkEMkXKe7cPi', '2', 'bIBjrPWlkEMkXKe7cPi', '155142353000400003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('49OGC1DnrrldEG2Hfqk', 'kPLbeydkgiYW6NIkCt0', null, '0N8ygEUeoPdGG6HeaCN', '0', 'P6EFwq71QsWsWVrbk7D', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单11', '2', '2');
INSERT INTO `t_permission` VALUES ('4A5T395pmjKIKKGKgTj', '3tFw1boS5L9vXoJCr6Z', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'PTTHSwtvw3HyoyAo3JB', '154563949592900001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('4aBxX7YPsG7uIwDl7zp', 'kPLbeydkgiYW6NIkCt0', null, '1QioSPqczT1xRrQBliu', '0', 'HxoUk6HtGOsbmINNEDW', '155168804575700005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('4BAVSoxGHSR7K0eliO1', '2jSs6cnzu4mzY9C13vF', null, 'HsCxJxVzSoMOXQotkMK', '1', 'HsCxJxVzSoMOXQotkMK', '155142339877600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4BLMKmhv3rlZNNY2mVk', '2ytUeoxBqghwofmBALl', null, 'wjPLVvwWYR2a9BOi0st', '0', 'cV9hNfWQ2CjjMiWBnt2', '154461618857000002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('4c5CgbMRSXNMcW8geNA', 'kPLbeydkgiYW6NIkCt0', null, 'iuGmP6OvURaOFF3NzoP', '0', 'qylo0G6lIYWGVKLPVnS', '155168804606900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('4c7i6uJShTHu9iGoE8V', 'jkpTHKg7DpuXQrppVxx', null, 'gWeQH0XbGS29JGGgrvT', '2', 'gWeQH0XbGS29JGGgrvT', '155142352966100004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4cImy6EWQrMyQX82OuW', '0Q0LkJpfR1ejtO8rD3p', null, 'gniImP2ug7E82S1WO0L', '1', 'Ap8uKeL5gioGlQk65eL', '155168789446800004', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('4CJ4jUJzA51cI03pdkJ', 'kPLbeydkgiYW6NIkCt0', null, 'b3y6CS4gmftCVXdw4Pb', '2', 'b3y6CS4gmftCVXdw4Pb', '155168804474300005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4crrasXKRVVbgaUpXYZ', '3tFw1boS5L9vXoJCr6Z', null, '9IbX83RDH7O16tUh901', '2', '9IbX83RDH7O16tUh901', '154563949467900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4dCGioPaK9TzFKGGb1A', 'jkpTHKg7DpuXQrppVxx', null, 'DwtZozROcOIsno6lTY3', '2', 'DwtZozROcOIsno6lTY3', '155142352969200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4DlMXbjDAM9oZMh9l1G', '0Q0LkJpfR1ejtO8rD3p', null, 'kebFCC8mkGX3V1QEriK', '0', 'dsB4JOjIMnlpqITpAVO', '155168789485800004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('4DM2252hT1PsMb63Vwr', 'WB81MbCBolNg6XmE35M', null, '11e6-4f27-1f4a23d7-81e8-cb77e1bc6c59', '1', '11e6-d15d-bd7cdfe3-bbdd-9f7a0eebced4', '155141104799500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('4eoCXkLVIA9Lx9Hvur0', '2jSs6cnzu4mzY9C13vF', null, 'XAQy4mQfPb9hnyOISK1', '0', 'jekyDtY4Gsod5cEuiVD', '155142339763800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('4eoRGjLZ0TvGtoZZuk7', 'jkpTHKg7DpuXQrppVxx', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'gjNDcP4lJlHlGCLsxRq', '155142353067500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('4EZqA6Skc55zCTX1kyR', 'jkpTHKg7DpuXQrppVxx', null, 'WHKujMuxTp67TYMu80o', '0', '7wT8mURPGaaDwJxvvHC', '155142353119000000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('4FbIKStlqwY3SmSYeZF', 'WB81MbCBolNg6XmE35M', null, '11e6-54ac-b2844607-9671-379f935a9949', '1', '11e6-d160-6b064f38-bbdd-9f7a0eebced4', '155141105025700003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('4Fpmpfal4tndBOLsQPw', 'jkpTHKg7DpuXQrppVxx', null, 'IfoHRC8Rs6njW75HqiE', '1', 'IfoHRC8Rs6njW75HqiE', '155142353140800004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4FpPynSGQWMr0YEz0s0', '2ytUeoxBqghwofmBALl', null, '5RzsvfgAUx2y0k1pDlg', '0', 'NgNicpt0mPuprqEMquB', '154461619146000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('4Gc4n1Kt4ruswY5CwaP', '2jSs6cnzu4mzY9C13vF', null, 'vDsnTykdPOblfwEF4mR', '1', 'g26NwXh1sSVhmkBCy8v', '155142339876100000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('4GhZlmO2AdKsEs9Zba3', '3tFw1boS5L9vXoJCr6Z', null, '71ct9G1xJPW7vLgA5JB', '2', '71ct9G1xJPW7vLgA5JB', '154563949474100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4gtcDRTv1HCvxscBGAW', '3tFw1boS5L9vXoJCr6Z', null, 'Qi632udYFiwUydksuYy', '2', 'Qi632udYFiwUydksuYy', '154563949475700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4GVdXInufU3td8ep7Fh', 'jkpTHKg7DpuXQrppVxx', null, 'JSvvw8VjIpL8ESGH8YA', '2', 'JSvvw8VjIpL8ESGH8YA', '155142352964500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4hNWt5MbYe5vIzQNuNa', 'jkpTHKg7DpuXQrppVxx', null, 'EUJuOrIly3lBnwGTF7Q', '1', 'EUJuOrIly3lBnwGTF7Q', '155142353101800003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4IpfYLZwqsn8OVkwUyc', 'jkpTHKg7DpuXQrppVxx', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'RXwhTRAzZSqsUpQc1NF', '155142353112700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4jI4buzmTgCkpisat9q', '0Q0LkJpfR1ejtO8rD3p', null, 'OAOscbfZQwOIteqeYSP', '1', 'OAOscbfZQwOIteqeYSP', '155168789426500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4jvzZRTHdFoDDP6UUOa', '0Q0LkJpfR1ejtO8rD3p', null, 'IS48bOUKPFjCVejkBfd', '2', 'IS48bOUKPFjCVejkBfd', '155168789334500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4Kqd0fmLBqATVItTZGy', 'kPLbeydkgiYW6NIkCt0', null, '5r3ZtpSgGVUw8avJcWr', '0', '5r3ZtpSgGVUw8avJcWr', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单1', '1032', '2');
INSERT INTO `t_permission` VALUES ('4l0o1CC507kAZ0jExgL', 'jkpTHKg7DpuXQrppVxx', null, 'XpNoNSLR8vialNcJDXq', '0', 'DDOwg7IIyIziyaozQTN', '155142353104900005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('4LJa7MV7vom90PmpC1r', '2ytUeoxBqghwofmBALl', null, 'nTlBd4a4Vt8mtiTX41J', '0', '9e1x2YMVEFvz8YJOOtI', '154461619096000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('4loMAAmCpHhjDJELbYg', '2ytUeoxBqghwofmBALl', null, 'wjPLVvwWYR2a9BOi0st', '0', 'cV9hNfWQ2CjjMiWBnt2', '154461619058500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('4MfOqdVQruNiFNuhz0G', '2ytUeoxBqghwofmBALl', null, 'LSwQOY0mggQ0vy4752p', '0', 'GrfqbEO7sjk3s3xGl3W', '154461619110100006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('4NVGYjGfBYAuOrf0k81', '0Q0LkJpfR1ejtO8rD3p', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155168789301700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4Ny3nByhdERw9VZq8wW', 'kPLbeydkgiYW6NIkCt0', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'PX5hS2Svd6sudk7n9l9', '155168804539800001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('4nZkSqQ1uSvxyv1dm0h', '2jSs6cnzu4mzY9C13vF', null, '7NlGpNC1MAEM6EuX2X0', '1', 'tqjrAb05aPRsD2JYTh1', '155142339908800000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('4oqFZfnvRBMiHMfMI8x', '0Q0LkJpfR1ejtO8rD3p', null, 'LSwQOY0mggQ0vy4752p', '0', 'GrfqbEO7sjk3s3xGl3W', '155168789488900003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('4oXH7YLu6xvnV20BFdQ', 'WB81MbCBolNg6XmE35M', null, '11e6-54a1-8e46ef97-9671-379f935a9949', '1', '11e6-54a1-8e46ef97-9671-379f935a9949', '155141105080300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4pFoxWUtO3UsDN0VnGe', 'jkpTHKg7DpuXQrppVxx', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'wKRxU5XodFTWQ3Od5v0', '155142353022200004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('4PHh9tVqQgKe9T5kGaz', '2ytUeoxBqghwofmBALl', null, '0zSRHMqiyMTl1dth7ds', '1', 'cn2gajGsHOgYLGZkWvG', '154461618946000002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('4QvgrmyMecFN5TAn4Zk', '0Q0LkJpfR1ejtO8rD3p', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'wKRxU5XodFTWQ3Od5v0', '155168789350100003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('4R4o1Sx2sq0hZyyMI9T', '3tFw1boS5L9vXoJCr6Z', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'XbKbKnKFlkZNvOSlGTo', '154563949496000001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('4RgLpEnzQzT81ieoZhE', '2jSs6cnzu4mzY9C13vF', null, 'poalxIjVlN70WdVjfQq', '1', '1reYhDLZyvld0uiPZMk', '155142339902600000', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('4S2Z1l1nWf78an2ir6G', '0Q0LkJpfR1ejtO8rD3p', null, 'poalxIjVlN70WdVjfQq', '1', 'poalxIjVlN70WdVjfQq', '155168789487300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4Sj9ApdQjbhwQgtHRLE', '0Q0LkJpfR1ejtO8rD3p', null, 'iS0C05zNyVJaInb9Lvo', '2', 'iS0C05zNyVJaInb9Lvo', '155168789312600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4SvgIC0xyFpcGXRW0pv', 'WB81MbCBolNg6XmE35M', null, '11e6-53f3-57372a15-81f5-679a826556ce', '1', '11e6-53f7-31969bfb-81f5-679a826556ce', '155141104972700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('4THgGbTdNqcgHF1DfjQ', 'WB81MbCBolNg6XmE35M', null, '11e6-53c0-961da43a-81f5-679a826556ce', '0', '11e6-53c1-14948518-81f5-679a826556ce', '155141105183300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('4TjZdAOlV2ItM4tH8f2', '0Q0LkJpfR1ejtO8rD3p', null, 'McumxQcBkg92YPli9Ox', '1', 'McumxQcBkg92YPli9Ox', '155168789432700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4U2UeRmku4fLj36LUji', '2ytUeoxBqghwofmBALl', null, 'RZTAlFVXkUYpYm96zVo', '1', 'RZTAlFVXkUYpYm96zVo', '154461619074200003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4W4y4552sC7bp7cfyDE', 'WB81MbCBolNg6XmE35M', null, '11e6-53c1-c45f44a1-81f5-679a826556ce', '1', '11e6-53c5-b0b5b62c-81f5-679a826556ce', '155141104938400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('4WcFH9mI0AG2sxhOK6g', '3tFw1boS5L9vXoJCr6Z', null, 'iL3YpikkZUlruc5ai3D', '1', '2HH7snENERzvRumcFTa', '154563949492900001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('4XkZH4wY3Chk1HwSlRw', '2ytUeoxBqghwofmBALl', null, 'L7O7fkCLsVh7KYd0RIy', '1', 'L7O7fkCLsVh7KYd0RIy', '154461619122600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4y4vqS1hYNCyyiTcBnN', '3tFw1boS5L9vXoJCr6Z', null, 'tAYVkaJnHAdVuffzuOr', '2', 'tAYVkaJnHAdVuffzuOr', '154563949442900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('4ydboOi5NmqMXFWuWdq', '3tFw1boS5L9vXoJCr6Z', null, 'bKWrnsYGUGaqqYqkeeO', '0', 'eKS6W5ObdgLXuBIKcJP', '154563949633500005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('4Yh0FJN6zK7ETOwqMQy', '0Q0LkJpfR1ejtO8rD3p', null, 'HsCxJxVzSoMOXQotkMK', '1', 'HsCxJxVzSoMOXQotkMK', '155168789474900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('4yVntVWu2jhpbMS9vIN', '2jSs6cnzu4mzY9C13vF', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'HsJKTUvE0PpgpJ9EXSw', '155142339882300001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('4ZAoDXWVj87na6SYnn1', '2jSs6cnzu4mzY9C13vF', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'mHhOCWGxOkvrAOWpqLl', '155142339662400000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('4zxYLNVtoIPby2eijwG', 'WB81MbCBolNg6XmE35M', null, '11e3-235b-96added8-825b-e3da92374d42', '0', '11e4-76b2-35136ff5-8c2b-2702792dd20d', '155141104849500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('50F7cOimijn85Y1T1nd', 'kPLbeydkgiYW6NIkCt0', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'KWyhjGMdOzdszl2VD2Q', '155168804670900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('513VGaXMoV44YzYMLWj', '0Q0LkJpfR1ejtO8rD3p', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '155168789390600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('51k9EJN9TyempNzgJav', '3tFw1boS5L9vXoJCr6Z', null, 'DwtZozROcOIsno6lTY3', '2', 'DwtZozROcOIsno6lTY3', '154563949446000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('52mAqaoGE9AMoDRx9BW', '2jSs6cnzu4mzY9C13vF', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Ty33WfwAyTHWENnxPcQ', '155142339774700003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('543WtOM3bosY5eGJ1oR', 'kPLbeydkgiYW6NIkCt0', null, 'fwj9yeT6AbfKtPOwtOM', '2', 'fwj9yeT6AbfKtPOwtOM', '155168804518000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('56U3aN2nxoxcNcFn5WN', 'kPLbeydkgiYW6NIkCt0', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'wgw8EmPgt7pl1vVHHdz', '155168804560100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('57xvG0bPmsXl3Cs7OfN', 'kPLbeydkgiYW6NIkCt0', null, 'htuZKnVCqioBBZD9Tg4', '2', 'htuZKnVCqioBBZD9Tg4', '155168804471200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('593a2PoBpKv32R5VFew', '2ytUeoxBqghwofmBALl', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'tjznokFdoftUtJzbwhl', '154461618949200004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('59Oo9vHkFm5lqiQhTmw', '0Q0LkJpfR1ejtO8rD3p', null, 'QB2YTfQBMnrttSiZNeP', '2', 'QB2YTfQBMnrttSiZNeP', '155168789311100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('59RjV1Npk3xl7tgMQg9', '0Q0LkJpfR1ejtO8rD3p', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'JyfgeJsIiLDXbY9SXJ7', '155168789453000001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('59WD7SnKPkHRjuADYbh', '2ytUeoxBqghwofmBALl', null, 'EGmIBh1ogGUoD8df1rE', '1', 'K1Q7LwDo3Y9JWxc1O1W', '154461619074200001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('5Ad0aeXV2PqaMhFBcEt', 'kPLbeydkgiYW6NIkCt0', null, 'IiQlslLmgrgXGsdYY0S', '2', 'IiQlslLmgrgXGsdYY0S', '155168804488300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5Ai0yALCjbZn26pDyMv', '2ytUeoxBqghwofmBALl', null, 'IfoHRC8Rs6njW75HqiE', '1', 'IfoHRC8Rs6njW75HqiE', '154461619117900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5atSWbETYIaqTgxVXmo', '2ytUeoxBqghwofmBALl', null, 'WOmzvkui5ZsoZu1CogR', '1', 'WOmzvkui5ZsoZu1CogR', '154461619041300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5Au0vw6sApubr6EHZCJ', '2ytUeoxBqghwofmBALl', null, 'j4ncSyWthzCYoNj3n4J', '0', 'WWNamo3Hl2Q5IoZUFn7', '154461619074200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('5BNeuRRfyo6JF27ZiY2', '3tFw1boS5L9vXoJCr6Z', null, 'EGmIBh1ogGUoD8df1rE', '1', 'EGmIBh1ogGUoD8df1rE', '154563949624100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5C9VH6etDGKzPj7r5wp', 'jkpTHKg7DpuXQrppVxx', null, '3gGNzYyE5dK9ogZidWA', '1', '7SBexLWqUvnu9vb48Vu', '155142353114300000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('5CBGb4ZjvtipESER8PO', '0Q0LkJpfR1ejtO8rD3p', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'PX5hS2Svd6sudk7n9l9', '155168789345400001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('5CMWXU3zAnWu3crjStE', 'jkpTHKg7DpuXQrppVxx', null, 'Gc5icb2c0g8ARf7Jath', '0', 'SLsJFM3QWPsTiAQbQRE', '155142353009800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('5CXc7ZbaQX2pe64v0bl', '2jSs6cnzu4mzY9C13vF', null, 'A6EMGp4mkUqLbMGLtql', '0', 'jvS3grY0lQM6HRUV78H', '155142339796500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5Ehpoetshgp4VhTE7qk', '2ytUeoxBqghwofmBALl', null, '6esIc2fTAI9nAOoOZcp', '1', 'qXsymSHvIPzVV0lWwQe', '154461618949200001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('5eI1kW06ry93qbSPR2G', 'jkpTHKg7DpuXQrppVxx', null, 'kebFCC8mkGX3V1QEriK', '0', '2eoDuuIu6c2LNFTXHBl', '155142353165800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('5F1DcqA98MNyZL70zSm', 'WB81MbCBolNg6XmE35M', null, '11e6-53d0-13d83c16-81f5-679a826556ce', '1', '11e6-53d0-13d83c16-81f5-679a826556ce', '155141105036700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5fc9kbxKgqCDgADRrOo', 'kPLbeydkgiYW6NIkCt0', null, 'LHgnhFx0bsvuS1fUhBi', '0', 'bBLadEJMfkOsH44bqZy', '155168804567900001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('5FIDiYmPO2Uii3NVHUy', 'jkpTHKg7DpuXQrppVxx', null, 'Z6pISvulUdsSz8bjuOV', '0', '81O85fI7nEQvujIwWvl', '155142353069000005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5FMhGVb6x9508Hfu8cu', '2ytUeoxBqghwofmBALl', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'ISM9kGtKs3Gkvrg1HSD', '154461619111700006', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '27', '1');
INSERT INTO `t_permission` VALUES ('5FXMgODI2uvxO9YXvfj', 'jkpTHKg7DpuXQrppVxx', null, '4oavihvP4J8cXDsWDIP', '0', 'FRLJFxdshvQAeKmHSfM', '155142353109600003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('5g7po1dSWp0WzbmrYZn', '3tFw1boS5L9vXoJCr6Z', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'csKjmVnToONLiXzljYG', '154563949600700002', 'HdPeBqYwJyFyjHkhZu3', '执行后提醒', '3', '1');
INSERT INTO `t_permission` VALUES ('5G8bvCaM1TEv2sUo0ZM', '0Q0LkJpfR1ejtO8rD3p', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '155168789389100002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5h2hVqTqnGx6mzNQMn2', 'kPLbeydkgiYW6NIkCt0', null, 'XOjVSXTJxQ9WnTO8TmN', '1', 'aSYThGpCcKMF1dEwssZ', '155168804564800000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('5H6YgfqKOiHsbWQg1vn', '0Q0LkJpfR1ejtO8rD3p', null, '36v96aPARGPLLLpXBt5', '2', '36v96aPARGPLLLpXBt5', '155168789328200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5Ihzqgx8kByxjPu4rnl', '2jSs6cnzu4mzY9C13vF', null, 'xBX9EbJkveiSGJm9xRj', '0', 'Ly9Spk5ma18fAyhAWh3', '155142339751300001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5ip2rMxUyZzSVeAG4Io', '3tFw1boS5L9vXoJCr6Z', null, 'Tm9KRBnKnzjuuld7bJh', '0', '5GCo50RaCJdscjJW16V', '154563949528800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5jqty7Z3XngCqcaHyQt', '2jSs6cnzu4mzY9C13vF', null, 'gniImP2ug7E82S1WO0L', '1', 'gniImP2ug7E82S1WO0L', '155142339824600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5K3e03QKQLbxIUGiROR', '2ytUeoxBqghwofmBALl', null, 'kA4m81roWetnkDQgWm0', '0', 'imbMPttNeDXyRLEFJeh', '154461618992900005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('5KJVmR0ODXxgfRKxi0m', '0Q0LkJpfR1ejtO8rD3p', null, '2F75ZJJXk8564FkCLYA', '1', 'aYBPeZTWDS1YHS4MWF5', '155168789359400001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('5LUSZw0XTpAG8af78v4', '3tFw1boS5L9vXoJCr6Z', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'IHazLikeEs3KYw5CBgr', '154563949621000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5Lw9OFfmaP28SULwC9f', 'jkpTHKg7DpuXQrppVxx', null, '5RZRK7Jt5vyqwlIccop', '1', '5RZRK7Jt5vyqwlIccop', '155142353044100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5lwc6LoPTzlpOvmIV36', '0Q0LkJpfR1ejtO8rD3p', null, 'smthlnru9z9qwavJKk1', '0', '55V8ZUWfTBCxFClWTNS', '155168789485800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5lwvGYO0Px68cEKvel0', 'jkpTHKg7DpuXQrppVxx', null, 'QB2YTfQBMnrttSiZNeP', '2', 'QB2YTfQBMnrttSiZNeP', '155142352970800005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5LXow8TmZF6t2Ue7HK3', 'jkpTHKg7DpuXQrppVxx', null, 'dcaZRzor22qTnafQjNv', '2', 'dcaZRzor22qTnafQjNv', '155142353002000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5MI1tvef5bl2zZRSEga', '3tFw1boS5L9vXoJCr6Z', null, 'Gs69JZ3ObwaQctDBcOp', '2', 'Gs69JZ3ObwaQctDBcOp', '154563949446000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5MnTpmESZy0uZQ0sr7a', '3tFw1boS5L9vXoJCr6Z', null, 'mEHACJenoEKew2MDnRm', '1', 'mEHACJenoEKew2MDnRm', '154563949586600004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5mWWsN8QhXLH3f0fvlx', '3tFw1boS5L9vXoJCr6Z', null, 'SAzJx5AkUZOJRct29BH', '0', 'x3O0Ifcwe8BqX5uhms5', '154563949578800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5nE7twU4GdFPAUwvYcM', '2jSs6cnzu4mzY9C13vF', null, 'UmMnr5J8RhgknR3Dsos', '0', 'gxzuym0IWRzScvUoUk7', '155142339763800001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5NUemfc1YyxSeJV8LEY', '0Q0LkJpfR1ejtO8rD3p', null, 'IfoHRC8Rs6njW75HqiE', '1', 'IfoHRC8Rs6njW75HqiE', '155168789471700003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5NVkCJvwcMRiUUrEXNQ', '3tFw1boS5L9vXoJCr6Z', null, 'vCWvTbPligxwrkrwAv8', '0', 'oyuPcAc1VAmt4JtNf7A', '154563949621000003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5oIi9IHkNVEsQzsf62u', 'kPLbeydkgiYW6NIkCt0', null, 'AeQX2k6Or75tfUuty4K', '2', 'AeQX2k6Or75tfUuty4K', '155168804502400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5oKhjUEX1l5AzsJVvUj', 'jkpTHKg7DpuXQrppVxx', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'kYjMqLc40QkdYGXLHWO', '155142353106500000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('5orRiHTVEpGBBpwtl5B', '3tFw1boS5L9vXoJCr6Z', null, 'kCeLKcebSzaR6kBjWoC', '2', 'kCeLKcebSzaR6kBjWoC', '154563949457000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5OSjzfmdLOS9xIciDY4', 'kPLbeydkgiYW6NIkCt0', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'csKjmVnToONLiXzljYG', '155168804642800002', 'HdPeBqYwJyFyjHkhZu3', '执行后提醒', '3', '1');
INSERT INTO `t_permission` VALUES ('5oUhy5CmzGBaXPOYjOb', '0Q0LkJpfR1ejtO8rD3p', null, 'uiFkOAGeBPQyi2pQlVb', '2', 'uiFkOAGeBPQyi2pQlVb', '155168789320400005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5pEM1aJcFqkN505lySb', 'jkpTHKg7DpuXQrppVxx', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'JAAon6tsqZ7pmxzP2fn', '155142353128300002', 'HdPeBqYwJyFyjHkhZu3', '批量签章', '29', '1');
INSERT INTO `t_permission` VALUES ('5PQ7wX15WLqkoP3s0KK', '3tFw1boS5L9vXoJCr6Z', null, 'g7U0PGtN5bKYhwbka6s', '0', 'V6C3ScFeVfcdhY9Xw63', '154563949521000000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5PtIJeX5Sq6tRE2W1Xv', 'jkpTHKg7DpuXQrppVxx', null, 'zg2t1qqkaJ17B2vvX05', '0', 'COoHnOHkHeviVNasUlf', '155142353122100002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5r2DvY4HvIS8xtYzwBj', '2jSs6cnzu4mzY9C13vF', null, 'taWpyKypy5rBhloCotj', '2', 'taWpyKypy5rBhloCotj', '155142339564100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5RTURUU8SMrtriziRme', '3tFw1boS5L9vXoJCr6Z', null, '9yUEQxnm9PCrsiRLBfo', '2', '9yUEQxnm9PCrsiRLBfo', '154563949435100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5saCmalGirFqwZVeZ9J', 'jkpTHKg7DpuXQrppVxx', null, 'ZKzfdA0mMJy8MQ16L4e', '2', 'ZKzfdA0mMJy8MQ16L4e', '155142352952000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5SddcjlgtqCmV3gxpYb', '0Q0LkJpfR1ejtO8rD3p', null, 'QgINfDEbj3rwSwaOJHg', '2', 'QgINfDEbj3rwSwaOJHg', '155168789325100005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5str8S8vUPjwpO0O9eJ', 'kPLbeydkgiYW6NIkCt0', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'nGaEFBPrXgV7aN882KS', '155168804611600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5tqm1DuMAr3iivE3k9I', '2ytUeoxBqghwofmBALl', null, 'LY2n5aO7h1TrpoHU2mc', '1', 'LY2n5aO7h1TrpoHU2mc', '154461619058500002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5tU38NMO0gWotkOLljY', '2ytUeoxBqghwofmBALl', null, '3K4lxgBhBLAbzJrfYaB', '1', 'iYGmCNLDOISoDmNMi4d', '154461619147600004', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('5uZiHhA979QFEXKQXPJ', 'kPLbeydkgiYW6NIkCt0', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'zubbDJQFaTursZKijlj', '155168804594400002', 'HdPeBqYwJyFyjHkhZu3', '自定义', '13', '1');
INSERT INTO `t_permission` VALUES ('5vB6zhj5lC4hbly0Rut', '2jSs6cnzu4mzY9C13vF', null, '1QioSPqczT1xRrQBliu', '0', 'HxoUk6HtGOsbmINNEDW', '155142339749700003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('5vEwJQahxaZTnb8xvaA', 'kPLbeydkgiYW6NIkCt0', null, 'JSvvw8VjIpL8ESGH8YA', '2', 'JSvvw8VjIpL8ESGH8YA', '155168804479000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5Vjvwd677AakBlREWSx', '0Q0LkJpfR1ejtO8rD3p', null, 'TU5YGgO5fJs1QU3q3h6', '1', 'TU5YGgO5fJs1QU3q3h6', '155168789428100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5vtnjBpk0mZvik9L5SA', '2jSs6cnzu4mzY9C13vF', null, 'vO8pkCUFsC8T8Ur5qEn', '2', 'vO8pkCUFsC8T8Ur5qEn', '155142339584400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5wsydOzpRSj0BC7U2mw', 'kPLbeydkgiYW6NIkCt0', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'GWNOfrdfU2z2hYo2y6Q', '155168804599100001', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('5xAO4j6v1kUocJdNDvw', '0Q0LkJpfR1ejtO8rD3p', null, 'aGwWScnt2f6X87bV5u9', '1', '4LdvPBnK70nLgMp5OzH', '155168789370300004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('5Y5p7RIT2rndyRbeUh0', 'kPLbeydkgiYW6NIkCt0', null, 'rUBAvMGr4fLCj7Wg0HQ', '2', 'rUBAvMGr4fLCj7Wg0HQ', '155168804522700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('5YKyZJ6JRy1khHFDCPM', 'jkpTHKg7DpuXQrppVxx', null, 'OGMmff1QTZYqFk5vfeD', '1', 'KTmmfPfwuB4gGJuw9fD', '155142353012900004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('5Yn62BE4JKmSW1bp76A', '2ytUeoxBqghwofmBALl', null, 'mEHACJenoEKew2MDnRm', '1', 'mEHACJenoEKew2MDnRm', '154461618930400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5yPtg7SJLcyGvWFp6lG', 'jkpTHKg7DpuXQrppVxx', null, 'enhnCZbrTQ1mZpn18o5', '0', 'iqufoXl2qzIWDFkt1Vi', '155142353123600000', 'HdPeBqYwJyFyjHkhZu3', '获取第一个查询条件的值', '1', '1');
INSERT INTO `t_permission` VALUES ('5Z8NIka8aOPR8h1EmIv', '0Q0LkJpfR1ejtO8rD3p', null, '6esIc2fTAI9nAOoOZcp', '1', '6esIc2fTAI9nAOoOZcp', '155168789359400004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5ZeLHJ2hJGyc7xNQxZj', '3tFw1boS5L9vXoJCr6Z', null, 'LSwQOY0mggQ0vy4752p', '0', 'GrfqbEO7sjk3s3xGl3W', '154563949633500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('5zuQAXjLjQWEsgn48PF', '3tFw1boS5L9vXoJCr6Z', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'f4NDOEOVMi7vrgWjzz4', '154563949544500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('5ZxEHlr5c9kdrZvQPhm', 'jkpTHKg7DpuXQrppVxx', null, 'IuPDe4Gm9occzflnrP0', '0', 'R45h7dTChA2x72ng9VU', '155142353131400001', 'HdPeBqYwJyFyjHkhZu3', '当前页面打开', '43', '1');
INSERT INTO `t_permission` VALUES ('60tS3NHacmaklmlrgeu', 'jkpTHKg7DpuXQrppVxx', null, 'ZM7F9MjjscP8bADF7cH', '1', 'ZM7F9MjjscP8bADF7cH', '155142353033200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('64sjYQxquq4IHddJaMk', 'kPLbeydkgiYW6NIkCt0', null, 'U1TygLjjsSxDfEoGwhc', '1', '6hT0k732Mz5j3yugFP1', '155168804538300000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('65baY9kA8aosTstmaNu', '2jSs6cnzu4mzY9C13vF', null, 'LSwQOY0mggQ0vy4752p', '0', 'PSPMnN2J3uJvKmrQ0mW', '155142339908800002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('685exHKDBxa88AGcnLn', '2ytUeoxBqghwofmBALl', null, 'jhINwVUWllGph0gnSC6', '0', 'CbRpWeZs7qQG3vfc9YZ', '154461619013200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('685OU75B0uIlWADVBrv', '3tFw1boS5L9vXoJCr6Z', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'nGaEFBPrXgV7aN882KS', '154563949577300000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('68b3VesAUIqthbigIsJ', 'WB81MbCBolNg6XmE35M', null, '11e6-5616-ab525ee3-91c5-cd8abd28b1f9', '2', '11e6-5616-ab525ee3-91c5-cd8abd28b1f9', '155141104783900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('68bcC56HaXErjj9IgZj', '2jSs6cnzu4mzY9C13vF', null, 'IuPDe4Gm9occzflnrP0', '0', 'LFydu54akpsq9Y9sCQr', '155142339866700004', 'HdPeBqYwJyFyjHkhZu3', '载入其他视图', '1', '1');
INSERT INTO `t_permission` VALUES ('68uHPtv1ZyxtsKGURTb', '2ytUeoxBqghwofmBALl', null, 'f9GQrsfu9GKGRqKKPgi', '1', '3wblZ30SS7TkVHaoRy2', '154461619113200001', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('69CxDCIan2MkcgAQfWq', 'kPLbeydkgiYW6NIkCt0', null, 'EKD2uh12ht0Vptz9xN5', '0', 'ThJH0AWU99Z8F5DDmUo', '155168804575700003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('69QXyktqco6CPR1qOsv', '2jSs6cnzu4mzY9C13vF', null, '4VkP5W8VPlERMiThvSD', '0', 'x4yYcPQJrgbYvpcebr5', '155142339780900005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6A2RpuQnliaxiLKvUNk', '2ytUeoxBqghwofmBALl', null, 'Tm9KRBnKnzjuuld7bJh', '0', 'k0TYCIl1oBQF4xUGHYE', '154461619017900001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6AdeUE7TIM2vkaD6zzx', '0Q0LkJpfR1ejtO8rD3p', null, 'qAcxhZ5mnoiohEBYD9G', '2', 'qAcxhZ5mnoiohEBYD9G', '155168789293900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6ARkQhNHDeLoxRVsKW3', '2ytUeoxBqghwofmBALl', null, 'kqrKj5I16CqjnePUq0G', '1', 'kqrKj5I16CqjnePUq0G', '154461619052300006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6avUdMlOp5MtdiINSHf', 'kPLbeydkgiYW6NIkCt0', null, 'IS48bOUKPFjCVejkBfd', '2', 'IS48bOUKPFjCVejkBfd', '155168804522700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6aYH0beA5UmJqoQlgeC', '2ytUeoxBqghwofmBALl', null, 'OAOscbfZQwOIteqeYSP', '1', 'OAOscbfZQwOIteqeYSP', '154461619050700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6AZzIrPUX1NL1eUirD2', 'WB81MbCBolNg6XmE35M', null, '11e6-5618-5f31026a-91c5-cd8abd28b1f9', '2', '11e6-5618-5f31026a-91c5-cd8abd28b1f9', '155141104769900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6BDpCmPbmIZrxQVtmi9', 'WB81MbCBolNg6XmE35M', null, '11e6-561a-446f92cd-91c5-cd8abd28b1f9', '2', '11e6-561a-446f92cd-91c5-cd8abd28b1f9', '155141104771500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6BoBWtajCnypSQalXxr', 'kPLbeydkgiYW6NIkCt0', null, 'ddbeKTjs0WvqKVJ90MU', '1', '8S96fbM0hHIvN2tHSUq', '155168804555400001', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('6bqzwSGOLMspFxac3PL', 'kPLbeydkgiYW6NIkCt0', null, 'BXWlXtLv3yNVPzVHd1A', '2', 'BXWlXtLv3yNVPzVHd1A', '155168804521100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6CLM3gtG5vp0k8SfuL7', '2ytUeoxBqghwofmBALl', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'Nmhce5xixb5FBPVv5dc', '154461619108500003', 'HdPeBqYwJyFyjHkhZu3', '此按钮不可见', '3', '1');
INSERT INTO `t_permission` VALUES ('6CQ1XNnd5txGEsJPWoR', '3tFw1boS5L9vXoJCr6Z', null, 'ZKzfdA0mMJy8MQ16L4e', '2', 'ZKzfdA0mMJy8MQ16L4e', '154563949416300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6D7zSkAk1X6mzB8coQv', '2jSs6cnzu4mzY9C13vF', null, '3gGNzYyE5dK9ogZidWA', '1', '7SBexLWqUvnu9vb48Vu', '155142339843300002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('6doXINH9M0cb8QpPJwo', '3tFw1boS5L9vXoJCr6Z', null, 'TyQHY3EqKQuNGfJ6teV', '2', 'TyQHY3EqKQuNGfJ6teV', '154563949474100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6DV4t3GE7UMGcFBE8Hh', '0Q0LkJpfR1ejtO8rD3p', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'eTnoMZs9GI6BwMJq1Cn', '155168789390600005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6EBVuybY2sbpEGrDAye', '3tFw1boS5L9vXoJCr6Z', null, 'HPxu0lHX6xisYxe5W5t', '2', 'HPxu0lHX6xisYxe5W5t', '154563949467900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6ehPg7gYGsj5Sg9jkWb', '2ytUeoxBqghwofmBALl', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'D4TlyirrG1V4ebAqUSh', '154461619102300005', 'HdPeBqYwJyFyjHkhZu3', '删除（右键菜单）', '3', '1');
INSERT INTO `t_permission` VALUES ('6eTFQJod4TfhEUXOiqv', '2ytUeoxBqghwofmBALl', null, 'wjPLVvwWYR2a9BOi0st', '0', '6798mFOtT3LLK9CYgPv', '154461619058500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6f2vcdQ70mpcw9Rkpa5', 'jkpTHKg7DpuXQrppVxx', null, 'bkoXpI9ilQlOYD8wsbU', '1', 'bkoXpI9ilQlOYD8wsbU', '155142353080000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6f5ymi7H7HrFv1r20EE', 'jkpTHKg7DpuXQrppVxx', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'zQbdwHlWMKfQxZOw4TN', '155142353148600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6fIFkGdHGvsy2nEWR9s', '3tFw1boS5L9vXoJCr6Z', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'aJ8FUYVtCO50iowXPg5', '154563949492900004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('6gAUQZAB5W1Cjb5oc8M', 'kPLbeydkgiYW6NIkCt0', null, 'u9zN1C73prPrzriTtzg', '1', 'u9zN1C73prPrzriTtzg', '155168804659900003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6gSyakml8nIjpI0yjtG', '2jSs6cnzu4mzY9C13vF', null, '98kmnnrWwGKmgyiIkUF', '0', 'erevZ9qTmGbUQpQWI61', '155142339745000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6GU4KXg13vD2OWjPWZY', '2ytUeoxBqghwofmBALl', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'mHhOCWGxOkvrAOWpqLl', '154461618936700003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('6HK5zRsSXgFk1TfsFi4', 'WB81MbCBolNg6XmE35M', null, '11e2-11c4-3682572e-8481-bf43184b8d87', '0', '11e2-11c4-3682573e-8481-bf43184b8d87', '155141104819800001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6Hu5ulTboJWHNCIpx1b', '3tFw1boS5L9vXoJCr6Z', null, 'Ueyt2ELhQd7E2oZ9cIi', '1', 'Ueyt2ELhQd7E2oZ9cIi', '154563949502300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6HvTlIWGVzqcyPeAx5X', 'WB81MbCBolNg6XmE35M', null, '11e6-5540-7128195d-8350-a3b9b8447d61', '1', '11e6-5540-7128195d-8350-a3b9b8447d61', '155141105159900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6HW2cHlXhRMiDsBevzd', '2ytUeoxBqghwofmBALl', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'LjTWOCClNPbDkDtAgoQ', '154461618966300000', 'HdPeBqYwJyFyjHkhZu3', '删除（字体图标红色 ）', '3', '1');
INSERT INTO `t_permission` VALUES ('6iaWXbDAFG804Fkj7Yn', 'jkpTHKg7DpuXQrppVxx', null, 'vCWvTbPligxwrkrwAv8', '0', 'akF0OOm8JnnvHsDhrLQ', '155142353156400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6ikymv6cRWfjzBuXazJ', 'kPLbeydkgiYW6NIkCt0', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'iY5ypHvJGJTn6j3J2nC', '155168804610000003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6iwYWBEzcAV8fmtYI7l', 'jkpTHKg7DpuXQrppVxx', null, 'poalxIjVlN70WdVjfQq', '1', 'ZABfGox4xJSo5PMgCOr', '155142353165800002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('6JFNM0jY1JYcK7EMC4H', '0Q0LkJpfR1ejtO8rD3p', null, 'gkbm2C0NbCfu86GHkFh', '0', 'hahOwfXx6ZmPFPMbyf8', '155168789379700002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6Ji2LUb20LrSBnNWO2X', '2jSs6cnzu4mzY9C13vF', null, 'OAOscbfZQwOIteqeYSP', '1', 'OAOscbfZQwOIteqeYSP', '155142339788700003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6KC1pAC2jv6quBsvBos', '2jSs6cnzu4mzY9C13vF', null, '4RJ5cYekBtB1RdNDxL3', '1', '4RJ5cYekBtB1RdNDxL3', '155142339771600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6kuWEdznBGHPYqUrupo', 'jkpTHKg7DpuXQrppVxx', null, 'P8aW26pXrA6epiJLKX0', '1', 'P8aW26pXrA6epiJLKX0', '155142353100200005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6ldYtahX3z1ywoCcrUV', '2jSs6cnzu4mzY9C13vF', null, 'xBX9EbJkveiSGJm9xRj', '0', 'hkNKtk1zbGkFX0hZFT9', '155142339751300002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6lFBUjW6ZZXohNxlhlQ', '3tFw1boS5L9vXoJCr6Z', null, 'enhnCZbrTQ1mZpn18o5', '0', 'u8rE2hHMPcvxRUXgNQk', '154563949596000001', 'HdPeBqYwJyFyjHkhZu3', '更新所选记录', '1', '1');
INSERT INTO `t_permission` VALUES ('6LlDxjnf92hIRrKq0wU', 'jkpTHKg7DpuXQrppVxx', null, 'jhINwVUWllGph0gnSC6', '0', 'GdRrT9CE4nmpUBASJy2', '155142353070600003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('6MghbCrK4oKEnkH7dOJ', 'jkpTHKg7DpuXQrppVxx', null, 'j4ncSyWthzCYoNj3n4J', '0', 'WWNamo3Hl2Q5IoZUFn7', '155142353111200005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6MgpIsMFMls0Fdmf6qr', '0Q0LkJpfR1ejtO8rD3p', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'czdV0c3QJMI2AZPkQZ6', '155168789462400004', 'HdPeBqYwJyFyjHkhZu3', '新建（绿色）', '2', '1');
INSERT INTO `t_permission` VALUES ('6mLI2DDeW64wz3Un7ti', '2jSs6cnzu4mzY9C13vF', null, 'KUp98gX4KG2acWUaepP', '2', 'KUp98gX4KG2acWUaepP', '155142339561000004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6mmqys5BtdD8cQQKYK5', '3tFw1boS5L9vXoJCr6Z', null, 'Ad9RS4RG7w9vkXmoKHG', '2', 'Ad9RS4RG7w9vkXmoKHG', '154563949433500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6MPbhZR7HbiMuqzYEY0', 'kPLbeydkgiYW6NIkCt0', null, 'EGz4qs5QI4fsCuCJwdc', '2', 'EGz4qs5QI4fsCuCJwdc', '155168804522700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6Nhv4MtKtLyB3kpeY0s', 'kPLbeydkgiYW6NIkCt0', null, 'G0WtPO1mX58wd7tjkTy', '0', 'XIYtwtem4lZYZBYOfS5', '155168804599100004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6NoTelfHtmCdit694ZM', '0Q0LkJpfR1ejtO8rD3p', null, 'yDZaeD0mt44iNjakHmE', '0', 'mYv5iZiU0TwoK4MWL6v', '155168789404700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('6nwHSzmM1Rrf9QvSLqa', '2ytUeoxBqghwofmBALl', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'csKjmVnToONLiXzljYG', '154461618967900006', 'HdPeBqYwJyFyjHkhZu3', '执行后提醒', '3', '1');
INSERT INTO `t_permission` VALUES ('6O5w3z1rRtax1e2XfJr', 'WB81MbCBolNg6XmE35M', null, '11e6-53f9-3bed7a60-81f5-679a826556ce', '1', '11e6-53f9-3bed7a60-81f5-679a826556ce', '155141104982100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6od7UFblPZU4CE4SDUf', '2jSs6cnzu4mzY9C13vF', null, '3gGNzYyE5dK9ogZidWA', '1', '3gGNzYyE5dK9ogZidWA', '155142339843300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6OoP9StBoPeboZQeMXj', '0Q0LkJpfR1ejtO8rD3p', null, 'TB1tzLM8yuJEkB6aQUk', '1', 'TB1tzLM8yuJEkB6aQUk', '155168789482700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6oPFoYTyEMzqcfnZsxi', 'jkpTHKg7DpuXQrppVxx', null, 'g2XzgmKDL1T8UB79GZh', '0', '1uOt5KaDxl3ZK3OT1Mw', '155142353115800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6pBXKjPETgIxQvBj5VE', 'kPLbeydkgiYW6NIkCt0', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'bOLR3Xo33mj06rfix3J', '155168804610000005', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('6PT907ag85LlTLjyjwc', '2ytUeoxBqghwofmBALl', null, '7NlGpNC1MAEM6EuX2X0', '1', 'tqjrAb05aPRsD2JYTh1', '154461619110100002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('6qBOj5wNefjl0bBrFUU', 'jkpTHKg7DpuXQrppVxx', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'WVuL60fA6C1cUsSUk5t', '155142353090900002', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('6RQR4wp3IHwEZJC6BY2', 'kPLbeydkgiYW6NIkCt0', null, 'ArQpV2XcSwZaAGmiCGT', '2', 'ArQpV2XcSwZaAGmiCGT', '155168804516400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6S1Etruk5ovPGeb4BKC', 'jkpTHKg7DpuXQrppVxx', null, 'uiFkOAGeBPQyi2pQlVb', '2', 'uiFkOAGeBPQyi2pQlVb', '155142352981700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6s3iMedpUXVwTz01ZDp', 'jkpTHKg7DpuXQrppVxx', null, 'ysihCX7dcjE9EuejMrJ', '2', 'ysihCX7dcjE9EuejMrJ', '155142352995700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6sbTfACDDnceETbj5pV', '2ytUeoxBqghwofmBALl', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'czdV0c3QJMI2AZPkQZ6', '154461618963200005', 'HdPeBqYwJyFyjHkhZu3', '新建（绿色）', '2', '1');
INSERT INTO `t_permission` VALUES ('6SiP7YTwRltzUD13PYa', 'jkpTHKg7DpuXQrppVxx', null, 'LHgnhFx0bsvuS1fUhBi', '0', '0dtX4S7P4eplUre1uBL', '155142353051900001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('6TmKdeHub3duYqeFrRx', '2jSs6cnzu4mzY9C13vF', null, 'ddbeKTjs0WvqKVJ90MU', '1', 'ddbeKTjs0WvqKVJ90MU', '155142339688900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6TxOPXcRsAE3QSpyCzt', '2ytUeoxBqghwofmBALl', null, 'bKWrnsYGUGaqqYqkeeO', '0', 'eKS6W5ObdgLXuBIKcJP', '154461619111700003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('6uISJxmjmIAcHENrzRu', '0Q0LkJpfR1ejtO8rD3p', null, 'bG7zmifAqOWLU6guwgi', '1', 'bG7zmifAqOWLU6guwgi', '155168789434300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6uygp7iQtBUMyLL0RPQ', '0Q0LkJpfR1ejtO8rD3p', null, 'gniImP2ug7E82S1WO0L', '1', 'A9ZVOiaJCjFUhFQkG6X', '155168789448300000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('6v0ZQFv0jfW8Z9qc7CV', 'jkpTHKg7DpuXQrppVxx', null, 'NGN4SO4fu5S5XxULG4X', '1', 'OH7Z3LEcqPhif8kJKhi', '155142353014400004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('6vjwqtu1OyvzOcYEwdh', 'kPLbeydkgiYW6NIkCt0', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'VC7xzHBeSzCmdpBwT9w', '155168804557000006', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('6VpP4f91irETjrOBScZ', '0Q0LkJpfR1ejtO8rD3p', null, 'XpNoNSLR8vialNcJDXq', '0', 'DDOwg7IIyIziyaozQTN', '155168789443700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6vWQZMo2zI5pmgrtoSe', '2ytUeoxBqghwofmBALl', null, '4VkP5W8VPlERMiThvSD', '0', 'DKXXNVp1SE3PrcD4Mq2', '154461619042900004', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('6W5fdF9nkLfopezB7vP', '2ytUeoxBqghwofmBALl', null, '4mlBSmLGlzULUWJe8Nu', '1', 'XeBSO1gjZBWzi78mcUl', '154461619033500000', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('6w629yP7FE9v8zKUHHQ', '3tFw1boS5L9vXoJCr6Z', null, 'IiXqyN1VoajtXmJTPKS', '2', 'IiXqyN1VoajtXmJTPKS', '154563949446000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6x0POHW93qOPy2LHXNF', 'kPLbeydkgiYW6NIkCt0', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'd0K3kzFXs6sjokcwJ3u', '155168804611600005', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('6xb0KJzQU0xrIQKC8k4', '3tFw1boS5L9vXoJCr6Z', null, 'jwnvWbHVPeT86x5j2LF', '2', 'jwnvWbHVPeT86x5j2LF', '154563949464800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6xJzOTDJghHqdknY7Od', 'WB81MbCBolNg6XmE35M', null, '11e3-99fe-5dd46414-82a9-5d3e655b6861', '0', '11de-a1db-d209a261-a188-7710f5ef0f5e', '155141104827600001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('6XKyur0gQRRtFYYYJ2T', '2jSs6cnzu4mzY9C13vF', null, 'HPxu0lHX6xisYxe5W5t', '2', 'HPxu0lHX6xisYxe5W5t', '155142339610900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6XxUSYocO6MM0y8RqXd', '0Q0LkJpfR1ejtO8rD3p', null, 'LgvvPpcCxScmiziQW7d', '2', 'LgvvPpcCxScmiziQW7d', '155168789314200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6Y9M2PRrd21vRDCBuju', '2jSs6cnzu4mzY9C13vF', null, 'bG7zmifAqOWLU6guwgi', '1', 'bG7zmifAqOWLU6guwgi', '155142339793400004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('6yG89h5l6pIPrzwQsl0', '3tFw1boS5L9vXoJCr6Z', null, 'tXSz1JBmnuwUf1VB2vL', '2', 'tXSz1JBmnuwUf1VB2vL', '154563949436600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('6YPerrYjhXZZEpcKVLu', '0Q0LkJpfR1ejtO8rD3p', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'QOEHg2MUz4Qp7kv5JyL', '155168789442100002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('6ys3KbuL0LJeu2J66st', '2ytUeoxBqghwofmBALl', null, 'jYDgN5WH46paTNLcCqi', '0', '3Un6aJGRxrZKJu5VhVa', '154461619044500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('6zcjQlzqN3taTqVDE0X', '2jSs6cnzu4mzY9C13vF', null, 'vZjJlrJAj7XdNX3czmS', '0', 'SG77mlxdPhjGgtckCUZ', '155142339743500003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('6zPc6hPeYYAqaxMlsrk', 'WB81MbCBolNg6XmE35M', null, '11de-7667-4caa6ce0-8d52-0547317ddd4c', '0', '11e8-3d67-f395b2e0-bebe-676024ec99b8', '155141105138100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '网页打印', '36', '1');
INSERT INTO `t_permission` VALUES ('73N6CR21jLkqaZmK7Ws', '0Q0LkJpfR1ejtO8rD3p', null, 'EKD2uh12ht0Vptz9xN5', '0', 'ThJH0AWU99Z8F5DDmUo', '155168789390600001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('73WB0s4oM9IkzVgoLvl', 'WB81MbCBolNg6XmE35M', null, '11e6-55fd-e3a84011-bb59-b7243d4bcf51', '1', '11e6-55fd-e3a84011-bb59-b7243d4bcf51', '155141105008600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('75iVWEfViZTO3nbKdTb', '3tFw1boS5L9vXoJCr6Z', null, '1QioSPqczT1xRrQBliu', '0', 'wIwBEaIp2kNiyXqGS2h', '154563949522600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('75JTlJEKQ7LxlQgbrKU', '2jSs6cnzu4mzY9C13vF', null, 'LocWe3mm3K3vF1gdbgC', '2', 'LocWe3mm3K3vF1gdbgC', '155142339568800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('78ngAOlQjlrRvHdFoP1', '3tFw1boS5L9vXoJCr6Z', null, '6esIc2fTAI9nAOoOZcp', '1', 'ngq5KVxqa5NRDO7OoHy', '154563949499100002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('78yDefGq343xLEqY0M9', '2ytUeoxBqghwofmBALl', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'd0K3kzFXs6sjokcwJ3u', '154461618882000002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('79Ey5XgnkCotlUtLlva', '3tFw1boS5L9vXoJCr6Z', null, 'kqrKj5I16CqjnePUq0G', '1', 'kqrKj5I16CqjnePUq0G', '154563949569500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7a0gJx4R9iPnFzckFF2', '2ytUeoxBqghwofmBALl', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'erjzyEtPTNQ9Oc2MmGl', '154461618933500004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('7A32zrXYPuk6kYnlavW', '3tFw1boS5L9vXoJCr6Z', null, 'DzqlEtg4JObApV7iWX8', '0', 'e6ZwAUd38TnujcTz0j9', '154563949538200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7b8XUmHlztOfNrMI07a', '3tFw1boS5L9vXoJCr6Z', null, 'EGmIBh1ogGUoD8df1rE', '1', 'K1Q7LwDo3Y9JWxc1O1W', '154563949624100001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('7Bfpln2gNd1wLppZBqU', '2jSs6cnzu4mzY9C13vF', null, 'UdbmUInPiuJzqP4yBTS', '1', 'UdbmUInPiuJzqP4yBTS', '155142339876100003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7bGO3yCj58w4QRsX22S', '2jSs6cnzu4mzY9C13vF', null, 'aA68dayjwAsKuH1y8yq', '2', 'aA68dayjwAsKuH1y8yq', '155142339603100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7BZxpzVxLUwrE3ebHqo', '0Q0LkJpfR1ejtO8rD3p', null, '3K4lxgBhBLAbzJrfYaB', '1', '3K4lxgBhBLAbzJrfYaB', '155168789487300004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7C8eYzyy8VyVDEAimVM', 'jkpTHKg7DpuXQrppVxx', null, 'Jh68ppMt3QMha315Hi6', '0', 'xTW6bbE29gUdngFIb2q', '155142353062800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('7CRvp2OlRN7x1venij2', '0Q0LkJpfR1ejtO8rD3p', null, 'Gc5icb2c0g8ARf7Jath', '0', 'nHElJbBXVkEhXwGIaUL', '155168789337600004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('7D2a59WuA8AeptIeVTz', '0Q0LkJpfR1ejtO8rD3p', null, '8PCn6NiiMTRGZcA5dsU', '1', '8PCn6NiiMTRGZcA5dsU', '155168789426500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7DFblbuYNTZj9q6uenx', 'jkpTHKg7DpuXQrppVxx', null, 'zqGmDkZIRa4COpFVzTj', '1', 'zqGmDkZIRa4COpFVzTj', '155142353006600002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7DPe3nN5REdpW1BoPrp', '3tFw1boS5L9vXoJCr6Z', null, 'bG7zmifAqOWLU6guwgi', '1', 'bG7zmifAqOWLU6guwgi', '154563949571000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7Du2u3onUru0TRBSVwP', 'jkpTHKg7DpuXQrppVxx', null, 'SYAJTXtkhpXsGIAqioF', '2', 'SYAJTXtkhpXsGIAqioF', '155142352972300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7E6O3MKj1b4j8lAIZ0a', 'kPLbeydkgiYW6NIkCt0', null, 'bkoXpI9ilQlOYD8wsbU', '1', 'eEsrQhBVYzA97RMPPGX', '155168804589700000', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('7EgFzDTUaXvH8iR6Mkt', '0Q0LkJpfR1ejtO8rD3p', null, '4v5tmazbZwdNkJDYso5', '1', '4v5tmazbZwdNkJDYso5', '155168789482700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7epuZi7WSbbpnPQdNF5', '2jSs6cnzu4mzY9C13vF', null, 'blVc1BNkTRUvVGde7Pj', '2', 'blVc1BNkTRUvVGde7Pj', '155142339607800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7EYGfli1m2tEFOqh3rR', '2jSs6cnzu4mzY9C13vF', null, 'XtaVH2y40O9zvIVALWj', '1', 'cJircppYbKZxUtuClYU', '155142339634300001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('7f6dWT95WlhZecsedOG', 'kPLbeydkgiYW6NIkCt0', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'TFCrC5zb0w6fDoq6icl', '155168804583500005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7G0RaPJLG4R7xgKiAze', '3tFw1boS5L9vXoJCr6Z', null, '4VkP5W8VPlERMiThvSD', '0', 'x4yYcPQJrgbYvpcebr5', '154563949555400002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7GBgAQA0nbSKvEfkSqc', '2jSs6cnzu4mzY9C13vF', null, 'Cg51Ds07QnrIkV1ne95', '2', 'Cg51Ds07QnrIkV1ne95', '155142339600000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7gKBGEoTEpVaZakKNa8', '2jSs6cnzu4mzY9C13vF', null, 'bIBjrPWlkEMkXKe7cPi', '2', 'bIBjrPWlkEMkXKe7cPi', '155142339624900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7GrSQWnBEdehZwqHjRx', 'kPLbeydkgiYW6NIkCt0', null, 'XAQy4mQfPb9hnyOISK1', '0', 'xGuspPXmrUTCn5KTdAR', '155168804585100002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('7Gskn71B1GvagYLQGbN', '3tFw1boS5L9vXoJCr6Z', null, '4RJ5cYekBtB1RdNDxL3', '1', '2WEniL1FLLpXKQfd5XU', '154563949541300002', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('7GuFm7ykoTrJwiZo3eF', '3tFw1boS5L9vXoJCr6Z', null, 'qqHbF4LC1qdUg1ak29k', '1', 'vdYEg1wdkIfHULE2LzN', '154563949492900006', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('7GWQrNKv4bLozTfIcyK', '2ytUeoxBqghwofmBALl', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'cHPexySH1L6Pf3IyNTH', '154461618857000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7h5EjoQEk9JvCOA4X2a', '0Q0LkJpfR1ejtO8rD3p', null, 'MsyfStEFzDcCB1VPbYJ', '1', 'MsyfStEFzDcCB1VPbYJ', '155168789474900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7hosKLRtQ2eDo4euOA4', '3tFw1boS5L9vXoJCr6Z', null, 'lOgu0Jvq0z5dlveyrnY', '0', 'eq15KrpMbnefCOE2bGq', '154563949582000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7HRFqSVjTvjmIC0KrSK', 'kPLbeydkgiYW6NIkCt0', null, '7u0fRbpHrxopCyfgADs', '1', 'QdJEZOBLT4lXyJm0dJq', '155168804558500004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('7hWpKKdmRj3FsAhPJIk', '2ytUeoxBqghwofmBALl', null, 'MtITrUcx3REq45LskT3', '0', '1GnA7ouj5X9SbchE8C5', '154461619064800007', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7HX9gEX56WcrU2hVhGP', '2jSs6cnzu4mzY9C13vF', null, '6esIc2fTAI9nAOoOZcp', '1', 'ngq5KVxqa5NRDO7OoHy', '155142339684200001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('7HYrqIYAuiCupSVSqt7', 'kPLbeydkgiYW6NIkCt0', null, '1fhgTUPecMY0ajlTkKZ', '0', 'juwrHEhNEXIqxCUqQuz', '155168804586600000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7jFIMwFLkijHp7eGbeV', 'WB81MbCBolNg6XmE35M', null, '11e6-5ee7-c49c1b4f-b0f0-d3a532217234', '2', '11e6-5ee7-c49c1b4f-b0f0-d3a532217234', '155141104759000001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7Jre8Vx1L43uD51vpWC', '3tFw1boS5L9vXoJCr6Z', null, 'CjR2ngF0kCrKnCpD0rj', '1', '5KOAZ5zATQsht3hJjXs', '154563949503800001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('7juhe0RkEuJlOk3fquE', '3tFw1boS5L9vXoJCr6Z', null, 'UW3rch1KdGhIyDrOLr6', '2', 'UW3rch1KdGhIyDrOLr6', '154563949464800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7LnFs9l7AGkGPizlX1r', 'kPLbeydkgiYW6NIkCt0', null, 'jhINwVUWllGph0gnSC6', '0', 'GdRrT9CE4nmpUBASJy2', '155168804578800002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('7lt6tG68rQRqnCpx5WU', '2jSs6cnzu4mzY9C13vF', null, 'WHKujMuxTp67TYMu80o', '0', 'ti2S70c11piGDmryGEq', '155142339857400001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7lW2ofjlJmqECpv5s15', '2jSs6cnzu4mzY9C13vF', null, 'dzJOLeIY4r6nbim6lou', '2', 'dzJOLeIY4r6nbim6lou', '155142339550000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7M0GBf4c2XgrjSzKdwn', 'jkpTHKg7DpuXQrppVxx', null, 'rfmGjP7LXiQfxy15izp', '1', 'rfmGjP7LXiQfxy15izp', '155142353111200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7Ne9Zi6CqH5d03elLpf', 'jkpTHKg7DpuXQrppVxx', null, 'BrbFcB3ptMyxdPl5W6u', '0', '6DhnKNo54979AgvQSGH', '155142353115800002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('7nEUkWubUybGdz3WRc5', 'jkpTHKg7DpuXQrppVxx', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'FoxNtE4HNjqsnne055E', '155142353106500002', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('7NH5Pvlq8H4nCiyHvRK', 'kPLbeydkgiYW6NIkCt0', null, 'iL3YpikkZUlruc5ai3D', '1', '2HH7snENERzvRumcFTa', '155168804547600002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('7njRRM8o7KA5kmuebkW', '2ytUeoxBqghwofmBALl', null, 'MtITrUcx3REq45LskT3', '0', '1GnA7ouj5X9SbchE8C5', '154461619135100001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7nUFFbfxqVhnEITgJx0', 'kPLbeydkgiYW6NIkCt0', null, 'jzty8K7Nbi7GKcU8c3L', '2', 'jzty8K7Nbi7GKcU8c3L', '155168804502400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7nX9TmLSGZbJ8IcWYBw', '0Q0LkJpfR1ejtO8rD3p', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'KMy1rLdwRmKATB4fMJZ', '155168789420300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7Ov0ZiUH0x9gKXBQxOx', '0Q0LkJpfR1ejtO8rD3p', null, 'RwAgQB30vyuzPHYBb3F', '2', 'RwAgQB30vyuzPHYBb3F', '155168789287700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7OXkub8vv3to0mfGryR', '2jSs6cnzu4mzY9C13vF', null, 'rfmGjP7LXiQfxy15izp', '1', 'N1gohv56wfzjxXMkYXQ', '155142339834000001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('7qGfhsPDBINGpoiLkl7', '2jSs6cnzu4mzY9C13vF', null, '4VkP5W8VPlERMiThvSD', '0', 'DKXXNVp1SE3PrcD4Mq2', '155142339782500001', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('7R2HQCTav4GmolvtLQ2', 'kPLbeydkgiYW6NIkCt0', null, 'sivHMH0kWQLjuMBG8z1', '2', 'sivHMH0kWQLjuMBG8z1', '155168804474300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7rAfK1NO8iY5xCBmwOc', '2ytUeoxBqghwofmBALl', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'Y0AtqRPANYqitR5XI0Q', '154461618955400004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('7RjCxm4qI8OubrNh4Oi', '0Q0LkJpfR1ejtO8rD3p', null, 'RZTAlFVXkUYpYm96zVo', '1', 'RZTAlFVXkUYpYm96zVo', '155168789482700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7RSiNsQSiowwHcgSeml', 'jkpTHKg7DpuXQrppVxx', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'XG8ap7ffszErnf3ZYYp', '155142353103400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('7sC1YnQTCVZnBYtHBuo', 'jkpTHKg7DpuXQrppVxx', null, 'icLamwX0TBANfjhoCxB', '2', 'icLamwX0TBANfjhoCxB', '155142352950500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7sjkiJ6JjkSuCaGPpKk', '0Q0LkJpfR1ejtO8rD3p', null, 'zqGmDkZIRa4COpFVzTj', '1', 'zqGmDkZIRa4COpFVzTj', '155168789337600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7t5iyo3uofSplTeInnF', 'kPLbeydkgiYW6NIkCt0', null, 'BrbFcB3ptMyxdPl5W6u', '0', '1JVZYNRouHUK7MH0xzc', '155168804627200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7TN32QziLdTRBNeVqMg', 'WB81MbCBolNg6XmE35M', null, '11e6-552e-bba4b939-8350-a3b9b8447d61', '1', '11e6-5a13-01edaa9c-9288-a3f5193ed8de', '155141104902500002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '取消会议', '11', '1');
INSERT INTO `t_permission` VALUES ('7tuAssI1oDmkb0F2Aic', '3tFw1boS5L9vXoJCr6Z', null, 'LSwQOY0mggQ0vy4752p', '0', 'OpbXZPZAU8ywvgR0xaQ', '154563949633500004', 'HdPeBqYwJyFyjHkhZu3', '打开表单', '2', '1');
INSERT INTO `t_permission` VALUES ('7u9UZ4kjNWEueoj2j2s', '0Q0LkJpfR1ejtO8rD3p', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'f4NDOEOVMi7vrgWjzz4', '155168789407800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7uCMEDPeV7Gi5u5pIbm', '3tFw1boS5L9vXoJCr6Z', null, 'eLFjqFngRQrIkbsdeBd', '1', 'eLFjqFngRQrIkbsdeBd', '154563949614800003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7uDpwwg4wYGrjdHTKQ5', '2jSs6cnzu4mzY9C13vF', null, 'eLFjqFngRQrIkbsdeBd', '1', 'UZzpqQ3lo5RbuYNWbsL', '155142339879200001', 'HdPeBqYwJyFyjHkhZu3', 'pdf导出', '25', '1');
INSERT INTO `t_permission` VALUES ('7VmsmIva45pr3qryjQ5', '3tFw1boS5L9vXoJCr6Z', null, 'U1TygLjjsSxDfEoGwhc', '1', '6hT0k732Mz5j3yugFP1', '154563949485100006', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('7vzsrrpKMdgX9b0sL6H', '0Q0LkJpfR1ejtO8rD3p', null, '9ppSV2PIKNhHCOwufvI', '0', 'KXsfuFCITnsqT6hE3Je', '155168789460800004', 'HdPeBqYwJyFyjHkhZu3', '导出', '16', '1');
INSERT INTO `t_permission` VALUES ('7w1ghLktLvaott3RVYE', '2ytUeoxBqghwofmBALl', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'CjR2ngF0kCrKnCpD0rj', '154461618955400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7WDrpT6Tuv23oZEAMaq', '2ytUeoxBqghwofmBALl', null, 'kebFCC8mkGX3V1QEriK', '0', '2eoDuuIu6c2LNFTXHBl', '154461619146000004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('7wIfAXZF5jOAIeCHzg6', '0Q0LkJpfR1ejtO8rD3p', null, 'vDsnTykdPOblfwEF4mR', '1', 'vDsnTykdPOblfwEF4mR', '155168789471700004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('7wmxl00aqs6rwptLOdR', 'kPLbeydkgiYW6NIkCt0', null, 'ZM7F9MjjscP8bADF7cH', '1', 'aN0KA8MmhVB1LjOqtWo', '155168804557000004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('7WvATNBuUrcznf9ACL4', '2jSs6cnzu4mzY9C13vF', null, 'icLamwX0TBANfjhoCxB', '2', 'icLamwX0TBANfjhoCxB', '155142339546900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7YhT9tb6NUtC0gU7nSj', '2ytUeoxBqghwofmBALl', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'Wy8unQKVYBEnHvEqVyA', '154461618933500003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('7yM81lpOWPBpKYKougw', 'WB81MbCBolNg6XmE35M', null, '11e6-5616-1387ba29-91c5-cd8abd28b1f9', '2', '11e6-5616-1387ba29-91c5-cd8abd28b1f9', '155141104766800001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('7YSDcQ2morLwDBHOYwO', '0Q0LkJpfR1ejtO8rD3p', null, 'nTlBd4a4Vt8mtiTX41J', '0', 'E3J8OfymoQtKHIuFNMK', '155168789456100003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('7yT9uCAgb93YY2jdqAQ', '3tFw1boS5L9vXoJCr6Z', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'Zb272Z4FRc9su5s2Lik', '154563949599100002', 'HdPeBqYwJyFyjHkhZu3', '批量提交（图片图标）', '20', '1');
INSERT INTO `t_permission` VALUES ('7zponQNxbdZpIbJsIS3', '3tFw1boS5L9vXoJCr6Z', null, 'NGN4SO4fu5S5XxULG4X', '1', 'TrHax0MzDGsTz4DFUoo', '154563949485100000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('80gTKrRJxkRV0ZBiYOr', '2jSs6cnzu4mzY9C13vF', null, 'GP2yEPcfqN4Gwg8M4Da', '2', 'GP2yEPcfqN4Gwg8M4Da', '155142339565600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('80y9pzh91HbuwKCpes6', '2ytUeoxBqghwofmBALl', null, 'WHKujMuxTp67TYMu80o', '0', '7wT8mURPGaaDwJxvvHC', '154461618944500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('81dIDkzkSgCWgWdpKZV', 'WB81MbCBolNg6XmE35M', null, '11e6-55fd-2fd5daef-bb59-b7243d4bcf51', '0', '11e6-55fd-39d29e39-bb59-b7243d4bcf51', '155141104991400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('81Gf0327sgj4zTzLVEe', '2jSs6cnzu4mzY9C13vF', null, 'aGwWScnt2f6X87bV5u9', '1', '4LdvPBnK70nLgMp5OzH', '155142339720100001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('81IMb20cZj7yxU5ma0J', 'jkpTHKg7DpuXQrppVxx', null, 'NGN4SO4fu5S5XxULG4X', '1', 'NGN4SO4fu5S5XxULG4X', '155142353014400001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('83hWrkHbhRwmNyLsW2W', '0Q0LkJpfR1ejtO8rD3p', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'bVmZ9H8tKyNWZ4omc1a', '155168789470200004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('84BQ3WuxZM0TP4bzqrs', '3tFw1boS5L9vXoJCr6Z', null, 'e6OXY8vDBhwyntKTBcc', '1', 'e6OXY8vDBhwyntKTBcc', '154563949627300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('85Lqgw4oO7TIVpZs3CT', 'jkpTHKg7DpuXQrppVxx', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'czdV0c3QJMI2AZPkQZ6', '155142353126800000', 'HdPeBqYwJyFyjHkhZu3', '新建（绿色）', '2', '1');
INSERT INTO `t_permission` VALUES ('860fuTjG8C6doopuS1Y', '2jSs6cnzu4mzY9C13vF', null, '6bUPlXeVH92MIv7Nmdw', '1', 'qPbgIDRXTjRZoXpvZJl', '155142339671700002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('865dMjMCZJ4wC2pQwc1', '3tFw1boS5L9vXoJCr6Z', null, 'Jh68ppMt3QMha315Hi6', '0', 'xTW6bbE29gUdngFIb2q', '154563949517900005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('88eHBP6yS79uJAlmJET', '2ytUeoxBqghwofmBALl', null, 'smthlnru9z9qwavJKk1', '0', '55V8ZUWfTBCxFClWTNS', '154461619144500004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('88LYHtQreYGHVOyBFMf', '2ytUeoxBqghwofmBALl', null, 'TqQZlnV3BVaRGCm4tXn', '1', 'UsdBObB53oqCjmBMNib', '154461618936700000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('89CC15XCOM0pak6R7Ro', '2jSs6cnzu4mzY9C13vF', null, 'XtaVH2y40O9zvIVALWj', '1', 'bufGP6tY9wwjTOfXum5', '155142339634300000', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('89UWXqdQZYLfL0Xglsd', '2jSs6cnzu4mzY9C13vF', null, 'bVLnHAUMhdToxosd7nT', '0', 'zNyhoGxQwFdm43lTvgK', '155142339757500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('8a0k5U9CBGtRRqRTyP0', '2jSs6cnzu4mzY9C13vF', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'WL5tjQMqesP6uJhWq81', '155142339759100003', 'HdPeBqYwJyFyjHkhZu3', '批量审核', '20', '1');
INSERT INTO `t_permission` VALUES ('8ASuHzlNdT6ybmd9SY7', '3tFw1boS5L9vXoJCr6Z', null, 'qEKeS98EGXZh9qkxklB', '2', 'qEKeS98EGXZh9qkxklB', '154563949419500005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8CfecSAJw7Ko7IfZj8o', '2jSs6cnzu4mzY9C13vF', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'cHPexySH1L6Pf3IyNTH', '155142339798100001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('8CvP0gZp7SJBrJFCVkj', '3tFw1boS5L9vXoJCr6Z', null, 'qqHbF4LC1qdUg1ak29k', '1', 'DvqeT7614zNxx8M5zED', '154563949494500001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('8D8EMGkaDrJjMuFOIbt', '2jSs6cnzu4mzY9C13vF', null, 'htuZKnVCqioBBZD9Tg4', '2', 'htuZKnVCqioBBZD9Tg4', '155142339553200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8ddtJT9zkFLUSK5eITA', '0Q0LkJpfR1ejtO8rD3p', null, 'L5GM913NGCFMkNWSZ8A', '0', 'QicxhLOE9YigegItmGd', '155168789395300000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('8EASTThAll3e0CMz656', '2ytUeoxBqghwofmBALl', null, 'ddbeKTjs0WvqKVJ90MU', '1', '5fbpm1XlYeZn8KXFMNL', '154461618950700001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('8etKOfUvtC28TNtkwyn', 'kPLbeydkgiYW6NIkCt0', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'D4TlyirrG1V4ebAqUSh', '155168804639700001', 'HdPeBqYwJyFyjHkhZu3', '删除（右键菜单）', '3', '1');
INSERT INTO `t_permission` VALUES ('8FQcAcCGcIMSuMHzein', 'kPLbeydkgiYW6NIkCt0', null, 'WOmzvkui5ZsoZu1CogR', '1', 'WOmzvkui5ZsoZu1CogR', '155168804596000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('8frDGTL0TpjjGBbSpHl', '3tFw1boS5L9vXoJCr6Z', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'M2lLJBuu4yQUfthKi4F', '154563949546000000', 'HdPeBqYwJyFyjHkhZu3', '保存草稿', '19', '1');
INSERT INTO `t_permission` VALUES ('8FwCpkULsf7BBIlR9Pz', '2ytUeoxBqghwofmBALl', null, 'rfmGjP7LXiQfxy15izp', '1', 'N1gohv56wfzjxXMkYXQ', '154461618907000000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('8ggPnBalW5ldzfJynyC', '2jSs6cnzu4mzY9C13vF', null, 'qqHbF4LC1qdUg1ak29k', '1', 'DvqeT7614zNxx8M5zED', '155142339670200000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('8GnmtUA2HUrZI5epX55', 'jkpTHKg7DpuXQrppVxx', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'wgw8EmPgt7pl1vVHHdz', '155142353037800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('8GpFcF56NLFwmcI4oXB', 'kPLbeydkgiYW6NIkCt0', null, 'F6reQ5BW7P6q236Pi13', '1', 'l8ljKs0dTA8uw1QTIcr', '155168804650600004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('8Gvl8Aqw4P2SE8Q3f8a', '2jSs6cnzu4mzY9C13vF', null, 'jYDgN5WH46paTNLcCqi', '0', 'MfAD53jYG4vMOBrhLRM', '155142339784000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('8hvSSHydjfLzxTEZYMU', 'kPLbeydkgiYW6NIkCt0', null, 'b76ggxFJ4XBOIQkmVoY', '2', 'b76ggxFJ4XBOIQkmVoY', '155168804468100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8i5RLpSVbeWJKUkCiEL', '2jSs6cnzu4mzY9C13vF', null, 'Vu8Q68Bom89YJDgguC9', '1', 'o0LAsNjkLfWve8FIjmu', '155142339788700000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('8I9l1gPdeeLpX5MuJJu', '3tFw1boS5L9vXoJCr6Z', null, 'vZjJlrJAj7XdNX3czmS', '0', 'Mk4H4HSkj1saDLiahVH', '154563949517900002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('8JCWPvFrNsE5gPOPoK0', '3tFw1boS5L9vXoJCr6Z', null, 'bJ9sgpEHjmdZEsbMwIM', '2', 'bJ9sgpEHjmdZEsbMwIM', '154563949472600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8jlvs7DcjTGkRFXyRkM', '0Q0LkJpfR1ejtO8rD3p', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'ISM9kGtKs3Gkvrg1HSD', '155168789470200000', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '27', '1');
INSERT INTO `t_permission` VALUES ('8keELWClg0YAg0aaOPc', '3tFw1boS5L9vXoJCr6Z', null, 'BwrS8PTVhvcxNYK06zs', '0', 'iioyeW0YPh4mK1mvfxY', '154563949567900001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('8kXA3HclOrQtCEQGmC5', 'kPLbeydkgiYW6NIkCt0', null, 'eKZqOwJmAFsUEwu0WfL', '1', '3jy9fTiYM0hwEHejpTu', '155168804560100005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('8lCjeAmyxJf9SrM3Fzv', '2ytUeoxBqghwofmBALl', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '154461619005400003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('8mDXA9qodHQFaMiLIhr', 'jkpTHKg7DpuXQrppVxx', null, 'vDsnTykdPOblfwEF4mR', '1', 'I7O5wArbJ75dWvyv3oX', '155142353143900001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('8mpK0b9uZkgSy87OBYr', 'jkpTHKg7DpuXQrppVxx', null, 'bJ9sgpEHjmdZEsbMwIM', '2', 'bJ9sgpEHjmdZEsbMwIM', '155142352995700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8n1vfuVGaUyCHZpdXUY', '3tFw1boS5L9vXoJCr6Z', null, 'jzty8K7Nbi7GKcU8c3L', '2', 'jzty8K7Nbi7GKcU8c3L', '154563949455400005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8Ne6RTfvKjpVMHINURh', '0Q0LkJpfR1ejtO8rD3p', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'QOJ06s8WUaokm0sdBKM', '155168789459300001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('8NfCCUiCYYfoMB6ah5Y', '0Q0LkJpfR1ejtO8rD3p', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'cAu7pZ4IzsfytkdYNLM', '155168789350100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('8nKjj0bxxlstggW7qKY', '2ytUeoxBqghwofmBALl', null, '2Icse0Cn99YRTQTZO3f', '1', '2Icse0Cn99YRTQTZO3f', '154461619088200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('8nOV8dmsxyejBL3uSLc', 'jkpTHKg7DpuXQrppVxx', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '155142353067500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('8nuwAm6B3nXThUNCp5z', '3tFw1boS5L9vXoJCr6Z', null, 'fu3FPAvy3QbJl8Y96P7', '1', '5oWWmwFfmt1UTNzYcO7', '154563949550700005', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('8pFHVTSBwSpwv88Yxgb', 'kPLbeydkgiYW6NIkCt0', null, '8q7uUoYo99jyzdLW3o5', '1', '8q7uUoYo99jyzdLW3o5', '155168804600700004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('8pTgIzsWnM7iKga8kD4', '0Q0LkJpfR1ejtO8rD3p', null, 'hxDvvyWbvIEUUrBHW0R', '1', 'hxDvvyWbvIEUUrBHW0R', '155168789434300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('8QjmN2fdnDS2x35Z1RS', '0Q0LkJpfR1ejtO8rD3p', null, 'wwsNkkwFEvqL44gK2fM', '0', 'WbfBIyoU0AkbLY6hBur', '155168789381300002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('8QlYovImj9NdtKz116W', 'kPLbeydkgiYW6NIkCt0', null, 'd1anhG9lkXM7xOEL0p0', '1', '54Ke6lqQKZqsRiIAuzU', '155168804563200001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('8qMprv7kcJEt90tJZc4', '2jSs6cnzu4mzY9C13vF', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'va8G9KHkziR1bHrdZwG', '155142339858900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('8RFXBgZc6ueTNLwLvPH', 'kPLbeydkgiYW6NIkCt0', null, 'gniImP2ug7E82S1WO0L', '1', 'Ap8uKeL5gioGlQk65eL', '155168804613100003', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('8RsIG4oivdKaIFdqmXi', 'WB81MbCBolNg6XmE35M', null, '11e6-5e0c-5b614a82-ae15-3d6b584ebd70', '1', '11e6-5e0c-5b614a82-ae15-3d6b584ebd70', '155141104997700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('8tdvVkejoqXwUCSjUf6', '0Q0LkJpfR1ejtO8rD3p', null, 'qU8WM5a2IVVudiqn38E', '1', 'qU8WM5a2IVVudiqn38E', '155168789435900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('8tGZL5bNpcMtzBwPck2', 'kPLbeydkgiYW6NIkCt0', null, '3K4lxgBhBLAbzJrfYaB', '1', '3K4lxgBhBLAbzJrfYaB', '155168804677100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('8TuUWkW022tkFkVgM4n', 'jkpTHKg7DpuXQrppVxx', null, 'IiXqyN1VoajtXmJTPKS', '2', 'IiXqyN1VoajtXmJTPKS', '155142352969200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8uF2fT083FhzB8jsme5', 'kPLbeydkgiYW6NIkCt0', null, '3sSURwczE2wMjgOqqOo', '0', 'rNGiDIRMmVUcl95QN9f', '155168804586600003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('8V21BAkv8luoD4bJCpw', '2ytUeoxBqghwofmBALl', null, '4VkP5W8VPlERMiThvSD', '0', 'SOe9OaDTLOE1domxYKV', '154461619042900001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('8vEEspAlkDpzz3zJ32c', 'jkpTHKg7DpuXQrppVxx', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155142352964500004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8vHgrGnsn91iLRhys5Z', '2ytUeoxBqghwofmBALl', null, 'EUJuOrIly3lBnwGTF7Q', '1', 'EUJuOrIly3lBnwGTF7Q', '154461618836700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('8vHp2lLexnUossAnCC3', 'kPLbeydkgiYW6NIkCt0', null, 'gniImP2ug7E82S1WO0L', '1', '2GBc0jCYf23ydklhe3I', '155168804614700000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('8vzXhcChHhjwWGpX3Lc', 'WB81MbCBolNg6XmE35M', null, '11e6-560b-b7fed962-91c5-cd8abd28b1f9', '2', '11e6-560b-b7fed962-91c5-cd8abd28b1f9', '155141104773000003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8wlJw9ABfZYu1K7bHpa', 'jkpTHKg7DpuXQrppVxx', null, 'fWq4603Eftipw3SEKHB', '2', 'fWq4603Eftipw3SEKHB', '155142352955200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8Xgg2scOkeXWQOd5yH1', '2jSs6cnzu4mzY9C13vF', null, 'vCWvTbPligxwrkrwAv8', '0', 'akF0OOm8JnnvHsDhrLQ', '155142339887000004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('8yAn1igWUF9Ld9jz03M', 'WB81MbCBolNg6XmE35M', null, '11e6-5616-9e73d872-91c5-cd8abd28b1f9', '2', '11e6-5616-9e73d872-91c5-cd8abd28b1f9', '155141104762100001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('8z7RNXFitI2xQY9o82P', '2ytUeoxBqghwofmBALl', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'mJFtUs7KSNrMTt3W70z', '154461619071000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('91kjhcSXCQa0mePj2gz', 'kPLbeydkgiYW6NIkCt0', null, 'vCWvTbPligxwrkrwAv8', '0', 'akF0OOm8JnnvHsDhrLQ', '155168804666200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('91OPiKfHjJWVatjnukx', 'WB81MbCBolNg6XmE35M', null, '11e6-52de-588531bf-a13d-c75d0a89256c', '1', '11e6-52de-588531bf-a13d-c75d0a89256c', '155141104888500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('92HtzhaxLo6tEMhauZb', 'jkpTHKg7DpuXQrppVxx', null, 'rumve1swtYufxpvxfcC', '2', 'rumve1swtYufxpvxfcC', '155142352984800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('92ttKagUS7IUsQwVZD9', '2jSs6cnzu4mzY9C13vF', null, 'TqQZlnV3BVaRGCm4tXn', '1', 'TqQZlnV3BVaRGCm4tXn', '155142339656100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('93aVLYcrDfjD28n8hw7', 'jkpTHKg7DpuXQrppVxx', null, 'wjPLVvwWYR2a9BOi0st', '0', 'cV9hNfWQ2CjjMiWBnt2', '155142353103400003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('945wBM03KfVFMVb3Ooe', 'jkpTHKg7DpuXQrppVxx', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'va8G9KHkziR1bHrdZwG', '155142353122100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('94n3B8WQb0F7O68yRUt', 'jkpTHKg7DpuXQrppVxx', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'iURMg4fbNkBkiB0qxra', '155142353037800001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('94pNqkHhUOJufBC8Yx7', '2ytUeoxBqghwofmBALl', null, 'IMD35YU4FNWL8IkwPAJ', '1', 'IMD35YU4FNWL8IkwPAJ', '154461618957000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('94yVCP1mRk5SUcJW9Ay', '0Q0LkJpfR1ejtO8rD3p', null, 'gkbm2C0NbCfu86GHkFh', '0', 'C06613mOoQKz6Rr0LIo', '155168789379700001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('95JMqHWhQyZLi5Dbt68', '2jSs6cnzu4mzY9C13vF', null, 'nTlBd4a4Vt8mtiTX41J', '0', 'E3J8OfymoQtKHIuFNMK', '155142339854200003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('95TeWWPjRAyCxdQUvNT', '0Q0LkJpfR1ejtO8rD3p', null, 'P14ZGIv1IEdecUGGYYk', '2', 'P14ZGIv1IEdecUGGYYk', '155168789289200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('96wEgC8D9YGSAATeaU2', '0Q0LkJpfR1ejtO8rD3p', null, '9HKopmq2QmqQZjBp0ve', '1', '9HKopmq2QmqQZjBp0ve', '155168789454600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('972xQdYrYGSCfthcjJj', '2jSs6cnzu4mzY9C13vF', null, 'laN4VVChl81K10rDCWr', '1', 'laN4VVChl81K10rDCWr', '155142339793400002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('97fB9NyGHvytkzoxac7', 'kPLbeydkgiYW6NIkCt0', null, 'UW3rch1KdGhIyDrOLr6', '2', 'UW3rch1KdGhIyDrOLr6', '155168804513300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('9BgWRPw5Tk1I0I4lQgL', 'jkpTHKg7DpuXQrppVxx', null, '7giYu3zk1hrdILU9eCl', '2', '7giYu3zk1hrdILU9eCl', '155142352997300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('9dM1aiFDiYg01xANWDf', 'kPLbeydkgiYW6NIkCt0', null, '5rcVntJVt1P8847Jpus', '2', '5rcVntJVt1P8847Jpus', '155168804518000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('9EB5HCUWentDnh3WLT9', '2ytUeoxBqghwofmBALl', null, 'w7IsSOtXFvo61cP8sKr', '1', 'w7IsSOtXFvo61cP8sKr', '154461619035100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('9eocDKFxDH0lm7Hgrlk', '2jSs6cnzu4mzY9C13vF', null, 'LdUkdpc3EVM9iBygFMr', '0', 'aDMBVBnzRI5FgVJbQR2', '155142339790300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('9etFgZ2Ni4duH3ThCoV', 'kPLbeydkgiYW6NIkCt0', null, 'fBeJCr5ipcIdScfuebs', '2', 'fBeJCr5ipcIdScfuebs', '155168804521100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('9F1VepiKl3aFXXgyH7Q', '0Q0LkJpfR1ejtO8rD3p', null, 'XAQy4mQfPb9hnyOISK1', '0', 'jekyDtY4Gsod5cEuiVD', '155168789400000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('9FbzYO9MZDSnLQxyuIJ', 'WB81MbCBolNg6XmE35M', null, '11e6-5496-7fbba41d-9671-379f935a9949', '1', '11e6-549a-45b4ea8b-9671-379f935a9949', '155141105095900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('9fK2Kr1PmiZ2NmEV9eQ', 'WB81MbCBolNg6XmE35M', null, '11e6-561a-a227bb1f-91c5-cd8abd28b1f9', '2', '11e6-561a-a227bb1f-91c5-cd8abd28b1f9', '155141104763700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('9FYD09AGhsW2buX1kVB', 'kPLbeydkgiYW6NIkCt0', null, 'UmMnr5J8RhgknR3Dsos', '0', 'RZ790ojkvhzumC5tyL2', '155168804585100005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('9gbUSgnWo0qfGlSXPQi', '0Q0LkJpfR1ejtO8rD3p', null, 'tAYVkaJnHAdVuffzuOr', '2', 'tAYVkaJnHAdVuffzuOr', '155168789304800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('9GJwWht4kNyQWzLUmvV', '2jSs6cnzu4mzY9C13vF', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'NF5zkjoJvJNVpgmQsj6', '155142339865200000', 'HdPeBqYwJyFyjHkhZu3', '执行前提示', '3', '1');
INSERT INTO `t_permission` VALUES ('9GW4oo0EpBQeA8sj9h0', 'kPLbeydkgiYW6NIkCt0', null, 'UdbmUInPiuJzqP4yBTS', '1', 'UdbmUInPiuJzqP4yBTS', '155168804655300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('9gxLn6ImsuSpM1Mr8Wb', 'kPLbeydkgiYW6NIkCt0', null, 'g7U0PGtN5bKYhwbka6s', '0', 'VXaTIyUn85r0Xf2ja64', '155168804574100003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('9JFflfQAVRl5xWvQYjQ', '2ytUeoxBqghwofmBALl', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'E47mVx0cWjUwctEiuIt', '154461619007000003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('9k0sXJrKp09lA9smhF8', 'WB81MbCBolNg6XmE35M', null, '11e6-546d-1bedb3b5-9671-379f935a9949', '1', '11e6-d15f-f611d1f4-bbdd-9f7a0eebced4', '155141104954000001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('9k2jgU0VcDbmZzVeDKB', 'WB81MbCBolNg6XmE35M', null, '11de-a1c6-fdf40dd0-a188-7710f5ef0f5e', '1', '11e1-6dc7-9355d28e-9ed5-651613166675', '155141104837000002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('9kBZ6v2xDaCmSynnK6w', 'WB81MbCBolNg6XmE35M', null, '11e6-5534-a670333f-8350-a3b9b8447d61', '1', '11e6-553c-1900085b-8350-a3b9b8447d61', '155141105194200003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('9kYBBWKgxY7hvrwyxCz', 'WB81MbCBolNg6XmE35M', null, '11e6-560b-6d26b140-91c5-cd8abd28b1f9', '2', '11e6-560b-6d26b140-91c5-cd8abd28b1f9', '155141104780800000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('9lEkr73XPXJZp7sgpXe', '3tFw1boS5L9vXoJCr6Z', null, '3gGNzYyE5dK9ogZidWA', '1', '1yFGNlNaVN83hKJQ7vt', '154563949586600002', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('9LFqrfWzqRwA102IS4D', 'kPLbeydkgiYW6NIkCt0', null, 'MnvkHQ9zdkDlQaAgtGq', '2', 'MnvkHQ9zdkDlQaAgtGq', '155168804491500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('9m9PRIrZCayGyHNuzYX', '3tFw1boS5L9vXoJCr6Z', null, 'RZTAlFVXkUYpYm96zVo', '1', 'RZTAlFVXkUYpYm96zVo', '154563949624100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('9mRdcnY8bLMBY9cTsRA', '3tFw1boS5L9vXoJCr6Z', null, 'aGwWScnt2f6X87bV5u9', '1', '4LdvPBnK70nLgMp5OzH', '154563949508500001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('9mTFdB8qPDQ34FP5p5A', '2ytUeoxBqghwofmBALl', null, 'HsCxJxVzSoMOXQotkMK', '1', 'HsCxJxVzSoMOXQotkMK', '154461619122600002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('9N3gyqr9pMYv1iOO4XL', '2jSs6cnzu4mzY9C13vF', null, 'SAzJx5AkUZOJRct29BH', '0', 'x3O0Ifcwe8BqX5uhms5', '155142339823000000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('9n8Hsw2lYwFeapyumcD', '2ytUeoxBqghwofmBALl', null, '3sSURwczE2wMjgOqqOo', '0', 'xgvB9tVQZn0ZxoQMZ31', '154461619024200006', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('9pD2Zs05vXjeimniOKt', 'jkpTHKg7DpuXQrppVxx', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '155142353050300001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('9Q2EK9umgrRyDDyrVlk', '0Q0LkJpfR1ejtO8rD3p', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'IHazLikeEs3KYw5CBgr', '155168789479500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('9q3SomvhZxR2EpPK4Zi', 'WB81MbCBolNg6XmE35M', null, '11e6-53e0-0aeaac2d-81f5-679a826556ce', '1', '11e6-53e5-cc5a60f5-81f5-679a826556ce', '155141105120900003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('9Qeza6TNNNLmpbicaJ8', 'TzxwQuzGAOCi1aTd7o1', null, 'j4ncSyWthzCYoNj3n4J', '0', 'KVWnOmmml6Kwm3w1RPe', '154461643401400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('9qOs95YneU2lEQ6Xsgy', '3tFw1boS5L9vXoJCr6Z', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'jlpTpnbZ03B6oqSeFmM', '154563949577300005', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('9RvnzDu4a6O5FpGU3RQ', '0Q0LkJpfR1ejtO8rD3p', null, 'yDZaeD0mt44iNjakHmE', '0', 'gOx8PapU5TCGaG1IcWs', '155168789404700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('9rVqGIiFu3llXWzljxi', '2jSs6cnzu4mzY9C13vF', null, 'a7jp1Dm53YjlAwDWuws', '1', 'UFBBbyiSeV5fpFq1Apn', '155142339773100001', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('9ryvUMUaxKXpGPd2nZ8', '3tFw1boS5L9vXoJCr6Z', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'MiEVpwvQ9yx8Zb5c2bR', '154563949510100006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('9T87N9NHuRRltAIUwlO', '2ytUeoxBqghwofmBALl', null, 'TqQZlnV3BVaRGCm4tXn', '1', 'TqQZlnV3BVaRGCm4tXn', '154461618935100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('9TCjJyIIVsAkTzsTY0f', '3tFw1boS5L9vXoJCr6Z', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'KDRVonlpSB5oYD1O1LY', '154563949607000000', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('9tVHnNaygEn9OrWtgk9', '2jSs6cnzu4mzY9C13vF', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'zQbdwHlWMKfQxZOw4TN', '155142339882300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('9UAb74WQsnDxNxaylZq', '2jSs6cnzu4mzY9C13vF', null, 'g2XzgmKDL1T8UB79GZh', '0', '1uOt5KaDxl3ZK3OT1Mw', '155142339854200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('9UAj3RM0qfeLQ93kbWF', '2jSs6cnzu4mzY9C13vF', null, 'IuPDe4Gm9occzflnrP0', '0', 'oD3WAF1Vtv6gB6lDCtv', '155142339866700003', 'HdPeBqYwJyFyjHkhZu3', '新窗口打开', '43', '1');
INSERT INTO `t_permission` VALUES ('9uZsLOZsStCAePQppMm', '3tFw1boS5L9vXoJCr6Z', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'TFCrC5zb0w6fDoq6icl', '154563949532000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('9vcNZqFjkGXsv0vjeUj', '2jSs6cnzu4mzY9C13vF', null, 'ZM7F9MjjscP8bADF7cH', '1', 'aN0KA8MmhVB1LjOqtWo', '155142339701400000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('9VfgzbCkc7PtKSZne6K', '3tFw1boS5L9vXoJCr6Z', null, 'oeLOJO0f3CC02OjOOIC', '0', 'Wvgpr80lY60tZ8EcoLc', '154563949525700002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('9VFOxZYT7oSBcSDh8Jc', 'WB81MbCBolNg6XmE35M', null, '11e6-53ae-1c5fbd29-81f5-679a826556ce', '1', '11e6-53bf-5f07e2b1-81f5-679a826556ce', '155141105178600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('9vqp8imLkMqU7onnv0f', '3tFw1boS5L9vXoJCr6Z', null, 'SAzJx5AkUZOJRct29BH', '0', 'wLzLCUPc9LuRRv9j8J3', '154563949578800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('9vx1soHEjnAQoWH0K8G', '3tFw1boS5L9vXoJCr6Z', null, 'XpNoNSLR8vialNcJDXq', '0', 'DDOwg7IIyIziyaozQTN', '154563949575700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('9VyvQIUnCUd4svSGZXE', 'jkpTHKg7DpuXQrppVxx', null, 'tbfv6enk6DCV69XcIwq', '2', 'tbfv6enk6DCV69XcIwq', '155142352952000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('9Wscx0WlalEMTY8TJeW', 'WB81MbCBolNg6XmE35M', null, '11e6-5e18-cb96ead8-ae15-3d6b584ebd70', '2', '11e6-5e18-cb96ead8-ae15-3d6b584ebd70', '155141104759000002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('9wzXjUPFGQEqogP4o5c', 'WB81MbCBolNg6XmE35M', null, '11e6-5496-7fbba41d-9671-379f935a9949', '1', '11e6-d160-2fb315d6-bbdd-9f7a0eebced4', '155141105095900002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('9XKWPTObc2PZR7aBo5F', '2ytUeoxBqghwofmBALl', null, 'gniImP2ug7E82S1WO0L', '1', 'Ap8uKeL5gioGlQk65eL', '154461619067900001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('9XqQlxbpXEpi0EGOKHT', 'WB81MbCBolNg6XmE35M', null, '11de-a1ce-12978c3f-a188-7710f5ef0f5e', '1', '11e8-5efb-d979cb7d-b84a-39be571b3c90', '155141104818300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存新建', '42', '1');
INSERT INTO `t_permission` VALUES ('9xrs6M1SELpnK7w7Av9', 'WB81MbCBolNg6XmE35M', null, '11e6-592c-d0d8c95a-a8ef-c39406c7f446', '1', '11e6-5934-9cba5fe6-a94a-e36ebd4ccf2c', '155141105177100002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('9xv7qIyfYFU3HSYkVHY', 'jkpTHKg7DpuXQrppVxx', null, '6bUPlXeVH92MIv7Nmdw', '1', '6bUPlXeVH92MIv7Nmdw', '155142353025400002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('9yHwc5JzvrfvVu8osYm', '0Q0LkJpfR1ejtO8rD3p', null, 'ZM7F9MjjscP8bADF7cH', '1', 's0ipQa9ktbRum255G0J', '155168789364100004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('9Z7HPPgATe8WIBRopzB', 'WB81MbCBolNg6XmE35M', null, '11de-a1ce-12978c3f-a188-7710f5ef0f5e', '1', '11e1-310a-207e087b-9d9c-1f2508069590', '155141104816700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('9ZPshMxDfuKAnPTO3un', 'kPLbeydkgiYW6NIkCt0', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'WL5tjQMqesP6uJhWq81', '155168804581900002', 'HdPeBqYwJyFyjHkhZu3', '批量审核', '20', '1');
INSERT INTO `t_permission` VALUES ('9ZSMG8Vf0qsqEElJJCV', 'kPLbeydkgiYW6NIkCt0', null, 'B0yjUrREPsW6eZ4NRxH', '2', 'B0yjUrREPsW6eZ4NRxH', '155168804479000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('A09IDKZ8gNRXYsg71YZ', '2jSs6cnzu4mzY9C13vF', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '155142339748200005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('A0GLlaFAKDlx2W9SKkG', '3tFw1boS5L9vXoJCr6Z', null, 'enhnCZbrTQ1mZpn18o5', '0', 'iqufoXl2qzIWDFkt1Vi', '154563949596000000', 'HdPeBqYwJyFyjHkhZu3', '获取第一个查询条件的值', '1', '1');
INSERT INTO `t_permission` VALUES ('a0jU9a52NsVwF0JZDU2', '2ytUeoxBqghwofmBALl', null, 'j4ncSyWthzCYoNj3n4J', '0', 'KVWnOmmml6Kwm3w1RPe', '154461618907000002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('A0NhHVNiZy8vTBrMVa6', 'jkpTHKg7DpuXQrppVxx', null, '4VkP5W8VPlERMiThvSD', '0', 'r8ONfNaqWuH1q18rKZk', '155142353087800005', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('a0ogXlqcXWFmDaKRmVo', '0Q0LkJpfR1ejtO8rD3p', null, 'Z6pISvulUdsSz8bjuOV', '0', '7nN7s8EOZ6SjZc0tEMY', '155168789392200003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('a18fD1AGEp84CDHcpjc', '3tFw1boS5L9vXoJCr6Z', null, 'JUpr2SmaIGVASTdp53r', '2', 'JUpr2SmaIGVASTdp53r', '154563949428800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('a1AWaBSuJjF8anUE6zF', 'kPLbeydkgiYW6NIkCt0', null, 'DzqlEtg4JObApV7iWX8', '0', 'e6ZwAUd38TnujcTz0j9', '155168804588200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('A2dSWJGjwKIuZj2kRIo', '2jSs6cnzu4mzY9C13vF', null, '1QioSPqczT1xRrQBliu', '0', 'wIwBEaIp2kNiyXqGS2h', '155142339749700002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('A2pahWYgH19pALexh20', 'kPLbeydkgiYW6NIkCt0', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'TkN4G3lj2mZ4XOo0kVQ', '155168804650600001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('A3j5UqmXYkCNgBC3Fkn', 'jkpTHKg7DpuXQrppVxx', null, '6esIc2fTAI9nAOoOZcp', '1', '6esIc2fTAI9nAOoOZcp', '155142353030000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('a4tGM9HNBvjfPERlYzE', 'WB81MbCBolNg6XmE35M', null, '11e6-5eae-1c9fe505-b0f0-d3a532217234', '2', '11e6-5eae-1c9fe505-b0f0-d3a532217234', '155141104769900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('A4Z00NcmqOdbsRGxnD3', 'jkpTHKg7DpuXQrppVxx', null, 'LSwQOY0mggQ0vy4752p', '0', 'PSPMnN2J3uJvKmrQ0mW', '155142353168900002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('A54mPdhFCdHa3EaqHoM', '2jSs6cnzu4mzY9C13vF', null, 'ezzP5oVH4ywB1HmiObF', '1', 'ezzP5oVH4ywB1HmiObF', '155142339795000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('a6aF1fNIMsjM0z2ig4g', '2ytUeoxBqghwofmBALl', null, '8PCn6NiiMTRGZcA5dsU', '1', '8PCn6NiiMTRGZcA5dsU', '154461619047600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('A6CTcSLtMRTpBCWDxsp', '2jSs6cnzu4mzY9C13vF', null, 'LgvvPpcCxScmiziQW7d', '2', 'LgvvPpcCxScmiziQW7d', '155142339587500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('a6LzqB9kliRgZe03Ks8', '0Q0LkJpfR1ejtO8rD3p', null, 'XzgpTEte9Q1JQswSETz', '0', 'oTrq3HVrCNx1jALWUgh', '155168789484200005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('a71Wv5lDkGrx03noaVa', '2ytUeoxBqghwofmBALl', null, 'KQSVH3r5JbmIAoPEf1R', '0', 'K4Z97NLTLZ952TInMrM', '154461619025700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('a7JneUW72HDKpswH4gr', '2jSs6cnzu4mzY9C13vF', null, 'QgINfDEbj3rwSwaOJHg', '2', 'QgINfDEbj3rwSwaOJHg', '155142339609300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('A83OlouL9b8l4pSQxTC', 'jkpTHKg7DpuXQrppVxx', null, 'dzJOLeIY4r6nbim6lou', '2', 'dzJOLeIY4r6nbim6lou', '155142352953600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('a8P2G4ILqs4kc7BGVyw', '0Q0LkJpfR1ejtO8rD3p', null, 'zg2t1qqkaJ17B2vvX05', '0', '5YmlK5Wk3G3ZqIrhdzM', '155168789460800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('a9LopWYsuMc4oDpT6ss', '3tFw1boS5L9vXoJCr6Z', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'SospNqkq0w4oZqt8HNv', '154563949600700003', 'HdPeBqYwJyFyjHkhZu3', '只读按钮', '3', '1');
INSERT INTO `t_permission` VALUES ('aaGwM8Pq5506CSSH1KR', '2jSs6cnzu4mzY9C13vF', null, 'iS0C05zNyVJaInb9Lvo', '2', 'iS0C05zNyVJaInb9Lvo', '155142339584400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('AahD775U4rbmKbA4hBB', '3tFw1boS5L9vXoJCr6Z', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'NF5zkjoJvJNVpgmQsj6', '154563949600700000', 'HdPeBqYwJyFyjHkhZu3', '执行前提示', '3', '1');
INSERT INTO `t_permission` VALUES ('AAlqH5H01NTJZSjOdfq', '0Q0LkJpfR1ejtO8rD3p', null, 'lAUkIpgQSIZqQyttrB4', '1', 'g6HusIB9Lr81fIHCCp5', '155168789370300002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('aaTQk4ZWgwi1azl8w67', 'kPLbeydkgiYW6NIkCt0', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'f9GQrsfu9GKGRqKKPgi', '155168804649000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('aBh2GnajjOf6ypNlR26', '2jSs6cnzu4mzY9C13vF', null, 'QuvtJrkqhNSzp7mN4R3', '2', 'QuvtJrkqhNSzp7mN4R3', '155142339567200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('AbSCyXLXog2FMRfbWos', '2jSs6cnzu4mzY9C13vF', null, 'vDsnTykdPOblfwEF4mR', '1', 'jVcLQaH4BiwznPvstCF', '155142339876100001', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('AbtTdyJuB41v36T8haE', '3tFw1boS5L9vXoJCr6Z', null, 'rumve1swtYufxpvxfcC', '2', 'rumve1swtYufxpvxfcC', '154563949463200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('aC4Yq5lOfUlr5rot1JZ', '0Q0LkJpfR1ejtO8rD3p', null, 'Jh68ppMt3QMha315Hi6', '0', 'ePkoYYvvztlUvkHqa16', '155168789385900000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('AcA5CVpw0hvroftQMGv', '2jSs6cnzu4mzY9C13vF', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'PTTHSwtvw3HyoyAo3JB', '155142339858900001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('aCcVrFUTTHGi4PQEzl5', '3tFw1boS5L9vXoJCr6Z', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'eTfrqgZ8RLViOksDpqV', '154563949577300003', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('Acfl16NjFay1YtZ69ma', '3tFw1boS5L9vXoJCr6Z', null, 'mXDUC8go52mfA91GY0r', '0', 'fh4ptUZPIiHNtWvp0cJ', '154563949605400002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('ACQoxCgvHyj5sbMdOow', '2ytUeoxBqghwofmBALl', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'bVmZ9H8tKyNWZ4omc1a', '154461619005400004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('acrx0qLn4ULhZgzElgt', '3tFw1boS5L9vXoJCr6Z', null, 'w7IsSOtXFvo61cP8sKr', '1', 'u8cNJQfZVXWFj5hlBow', '154563949547600000', 'HdPeBqYwJyFyjHkhZu3', '保存并启动流程', '4', '1');
INSERT INTO `t_permission` VALUES ('Ad74vnRV0jEzwaXLMVs', 'jkpTHKg7DpuXQrppVxx', null, 'TqQZlnV3BVaRGCm4tXn', '1', 'UsdBObB53oqCjmBMNib', '155142353020700001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('ADgyecvrWGx1KwF8zA8', '2ytUeoxBqghwofmBALl', null, '5XvXec6bdYRjaPxuLlQ', '1', '5XvXec6bdYRjaPxuLlQ', '154461619052300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('AdiAcaJiTLexJgTlcQk', '2jSs6cnzu4mzY9C13vF', null, '5XvXec6bdYRjaPxuLlQ', '1', '5XvXec6bdYRjaPxuLlQ', '155142339790300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ADmBHMb1LEPmP7ATrS0', 'kPLbeydkgiYW6NIkCt0', null, 'lbZDhonVIlyX0n0IKyu', '2', 'lbZDhonVIlyX0n0IKyu', '155168804471200004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('AdqCy6bRqa4KHhf2gG8', 'jkpTHKg7DpuXQrppVxx', null, 'ddbeKTjs0WvqKVJ90MU', '1', 'ddbeKTjs0WvqKVJ90MU', '155142353031600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('AdXSVwwheOhiEEyIv9L', 'jkpTHKg7DpuXQrppVxx', null, 'b76ggxFJ4XBOIQkmVoY', '2', 'b76ggxFJ4XBOIQkmVoY', '155142352953600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('aE1GQVE3qicql7YiM7t', 'jkpTHKg7DpuXQrppVxx', null, '2bmCU7aUTZfM8CZmJEP', '2', '2bmCU7aUTZfM8CZmJEP', '155142352973900006', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('AEBHezIueXaWus2taA9', '0Q0LkJpfR1ejtO8rD3p', null, 'rfmGjP7LXiQfxy15izp', '1', 'rfmGjP7LXiQfxy15izp', '155168789449900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Aenn1lSu7CZK9OE6bZr', '2ytUeoxBqghwofmBALl', null, 'JdWD8biOlCXjkEvrwMm', '0', 'OLJQOfZpoAIKsZOpeqD', '154461618975700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('aEOxECXjKLDlGdaZ4VV', 'jkpTHKg7DpuXQrppVxx', null, 'LgvvPpcCxScmiziQW7d', '2', 'LgvvPpcCxScmiziQW7d', '155142352973900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('aEQxJSO9o04cBZYCEtF', 'kPLbeydkgiYW6NIkCt0', null, '9ppSV2PIKNhHCOwufvI', '0', 'KJPLDYCNeJz1SWkwXZd', '155168804638100001', 'HdPeBqYwJyFyjHkhZu3', '下载文件', '26', '1');
INSERT INTO `t_permission` VALUES ('Af2fj655pBGV83OnzRw', '2ytUeoxBqghwofmBALl', null, 'hxDvvyWbvIEUUrBHW0R', '1', 'hxDvvyWbvIEUUrBHW0R', '154461618800700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('AFf5qTqqKFI2eMbxUap', '2jSs6cnzu4mzY9C13vF', null, '66LHqZTlRhXpEZAIoTa', '2', '66LHqZTlRhXpEZAIoTa', '155142339578100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('AfhPbHqey4iI4YlCP9b', '2ytUeoxBqghwofmBALl', null, 'MsyfStEFzDcCB1VPbYJ', '1', 'MsyfStEFzDcCB1VPbYJ', '154461619122600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('AfkvgjxGnf7r6sEe0jQ', 'kPLbeydkgiYW6NIkCt0', null, 'blVc1BNkTRUvVGde7Pj', '2', 'blVc1BNkTRUvVGde7Pj', '155168804511700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('afW2b9rWnrLS3i6PRsb', 'WB81MbCBolNg6XmE35M', null, '11e6-54b2-7bfe8b70-9671-379f935a9949', '0', '11e6-59f3-d0ec495c-ab5d-51da01f3eda4', '155141104932100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('AGRq3xhHVz5DYr8pT2n', 'jkpTHKg7DpuXQrppVxx', null, 'UmMnr5J8RhgknR3Dsos', '0', 'gxzuym0IWRzScvUoUk7', '155142353076800001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('agTxmvOeiHi6XY9b0WJ', '3tFw1boS5L9vXoJCr6Z', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '154563949511600005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('agVLREGu72FuAapqF32', '0Q0LkJpfR1ejtO8rD3p', null, 'TqagBUMFdyCepAZ3Umc', '2', 'TqagBUMFdyCepAZ3Umc', '155168789328200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('aGYkZl8HQ2r0gxV8Xjs', 'jkpTHKg7DpuXQrppVxx', null, 'a7jp1Dm53YjlAwDWuws', '1', 'wL7xiiufleig43GVrAC', '155142353081500002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('AhD0Am3eounRKejRNHU', '3tFw1boS5L9vXoJCr6Z', null, 'kA4m81roWetnkDQgWm0', '0', 'imbMPttNeDXyRLEFJeh', '154563949514800005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('AHgKvuBchBaNd9kzqGQ', '2jSs6cnzu4mzY9C13vF', null, 'oeLOJO0f3CC02OjOOIC', '0', 'Wvgpr80lY60tZ8EcoLc', '155142339754400002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('AHKiAZelzoInuEsQywT', '0Q0LkJpfR1ejtO8rD3p', null, 'JdWD8biOlCXjkEvrwMm', '0', 'OLJQOfZpoAIKsZOpeqD', '155168789467100003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('AHLeskgQdBHlSIg8bP8', '2jSs6cnzu4mzY9C13vF', null, 'nTlBd4a4Vt8mtiTX41J', '0', '9e1x2YMVEFvz8YJOOtI', '155142339855800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('aHubJyMkQw7X5Gn5uWx', '3tFw1boS5L9vXoJCr6Z', null, 'vDsnTykdPOblfwEF4mR', '1', 'I7O5wArbJ75dWvyv3oX', '154563949613200001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('ai9alOTWJwLljwZeAWW', '0Q0LkJpfR1ejtO8rD3p', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'LGI4kXh1sQ9vMEdPg6S', '155168789409300000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('Aic0EPpD43H9GikGdhK', 'kPLbeydkgiYW6NIkCt0', null, 'ddbeKTjs0WvqKVJ90MU', '1', 'ddbeKTjs0WvqKVJ90MU', '155168804555400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('AIDG7TT5Bg0sTmxfjD3', 'WB81MbCBolNg6XmE35M', null, '11e6-5534-a670333f-8350-a3b9b8447d61', '1', '11e6-d160-8b636073-bbdd-9f7a0eebced4', '155141105194200001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('aiISBn8LaGsE6eNBPBl', '2ytUeoxBqghwofmBALl', null, 'LHgnhFx0bsvuS1fUhBi', '0', 'bBLadEJMfkOsH44bqZy', '154461618977300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('ais9LSrt539lEKNPfFQ', '3tFw1boS5L9vXoJCr6Z', null, 'IuPDe4Gm9occzflnrP0', '0', 'R45h7dTChA2x72ng9VU', '154563949602300001', 'HdPeBqYwJyFyjHkhZu3', '当前页面打开', '43', '1');
INSERT INTO `t_permission` VALUES ('AjcM0EtisiyGZxNysUv', '0Q0LkJpfR1ejtO8rD3p', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'gUlSUpqhlS2ym2ijZAg', '155168789356300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('AJXXJkP0CLh83fG55qI', '3tFw1boS5L9vXoJCr6Z', null, 'oUGfBAkdjTsO2z22gYU', '2', 'oUGfBAkdjTsO2z22gYU', '154563949435100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ak9ro2BXL5Z6ruNSwOe', 'jkpTHKg7DpuXQrppVxx', null, '8BSYIj5kZKJjAD7IxkX', '2', '8BSYIj5kZKJjAD7IxkX', '155142352970800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('AkaIS4J0I5BqVBjOLLx', '0Q0LkJpfR1ejtO8rD3p', null, '98kmnnrWwGKmgyiIkUF', '0', 'erevZ9qTmGbUQpQWI61', '155168789384400002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('akDAHM8LGvK53szmd2r', 'kPLbeydkgiYW6NIkCt0', null, 'OGMmff1QTZYqFk5vfeD', '1', 'KTmmfPfwuB4gGJuw9fD', '155168804533600001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('aKicQYiCIV1x55NmVr8', '2jSs6cnzu4mzY9C13vF', null, 'jzty8K7Nbi7GKcU8c3L', '2', 'jzty8K7Nbi7GKcU8c3L', '155142339596800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Akv8wteUjLPR0y7AwbX', '0Q0LkJpfR1ejtO8rD3p', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'mHhOCWGxOkvrAOWpqLl', '155168789350100001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('aKwgXJzY2JYMW9gvjJ4', '0Q0LkJpfR1ejtO8rD3p', null, '2F75ZJJXk8564FkCLYA', '1', 'elMcFSK0gGbaGWSt2pH', '155168789359400003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('akZti9J6DxLOtuL1oFO', '2jSs6cnzu4mzY9C13vF', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'x2qgUpE8u9jmGEWbbQm', '155142339801200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ALet0mWsMcH4U6aJG9o', '2jSs6cnzu4mzY9C13vF', null, 'ypFGviMvQl4iVE8dOS0', '2', 'ypFGviMvQl4iVE8dOS0', '155142339554700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('alPsqdp5YPYzKu90v4l', 'jkpTHKg7DpuXQrppVxx', null, '6r0MsymflCeuD0Rrz4G', '2', '6r0MsymflCeuD0Rrz4G', '155142352952000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('amJ8kQdIwDx1F5Cv5pm', '2ytUeoxBqghwofmBALl', null, 'd1anhG9lkXM7xOEL0p0', '1', 'd1anhG9lkXM7xOEL0p0', '154461618963200006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('AmMvDmWzsH16Jkwa4fv', '2ytUeoxBqghwofmBALl', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'va8G9KHkziR1bHrdZwG', '154461619097600006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('AMnUJN0NOBwnTNwEiaX', '0Q0LkJpfR1ejtO8rD3p', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'eTfrqgZ8RLViOksDpqV', '155168789445200002', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('AMsisinUZBGdAQlCN6c', '2ytUeoxBqghwofmBALl', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'I5GJXxDs9LYwwqf4uQv', '154461619019500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('AMszmdkZGiroaC2h4BM', '3tFw1boS5L9vXoJCr6Z', null, 'QB2YTfQBMnrttSiZNeP', '2', 'QB2YTfQBMnrttSiZNeP', '154563949449100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('amV0dz1StjwSXBfw4Pq', '0Q0LkJpfR1ejtO8rD3p', null, 'WOmzvkui5ZsoZu1CogR', '1', 'YTpVlB2kK9hmipw8HMw', '155168789414000003', 'HdPeBqYwJyFyjHkhZu3', '自定义打印', '30', '1');
INSERT INTO `t_permission` VALUES ('aN1F3ZAHkMWEYnXnHEg', '2ytUeoxBqghwofmBALl', null, '98kmnnrWwGKmgyiIkUF', '0', 'mlTio0aN6W90Aant0Mk', '154461618996000000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('an2xEGxKK6PHqqnN5k1', '2ytUeoxBqghwofmBALl', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'ZLGOtOxZGBCsfXYeK15', '154461619060100002', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('aNBYlOyVdCXSgg0wxYQ', '0Q0LkJpfR1ejtO8rD3p', null, 'j3y8CHrsMwRmnPJz7EW', '1', 'j3y8CHrsMwRmnPJz7EW', '155168789451500002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('AnOlG25l8UuUXblXMl3', '0Q0LkJpfR1ejtO8rD3p', null, 'TqQZlnV3BVaRGCm4tXn', '1', '22ZvmpjYHg3LQFPOh01', '155168789346900005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('anos4qmNpVROVgyZw9J', 'kPLbeydkgiYW6NIkCt0', null, 'R6yjKjfn0NuFZDhxQuS', '2', 'R6yjKjfn0NuFZDhxQuS', '155168804503900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ANSPPDuYnBcfTwmkcPn', '0Q0LkJpfR1ejtO8rD3p', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'fkbqJ4vxJOUvHY59Lo6', '155168789478000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('AnyQKrTmywoFQL80AyY', '3tFw1boS5L9vXoJCr6Z', null, '53PLwEjsvlAXAnlixPb', '2', '53PLwEjsvlAXAnlixPb', '154563949472600004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('aOG32lzi8SJvTVDHpHi', '3tFw1boS5L9vXoJCr6Z', null, 'HqyysOeWOVkmU29sLla', '0', 'K6e79wYCTJXzxMeQIon', '154563949532000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('aomDcQHCixSbUtAOtty', '3tFw1boS5L9vXoJCr6Z', null, 'WHKujMuxTp67TYMu80o', '0', '7wT8mURPGaaDwJxvvHC', '154563949591300000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('aOMQtDmcfEYg7wQ0fXI', '0Q0LkJpfR1ejtO8rD3p', null, 'viwgtc32VtB7wJo2O8S', '0', 'Wlje8Nr2ww7qrmEwdBf', '155168789382800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('aoU2rfo65qTa0wHopEX', 'WB81MbCBolNg6XmE35M', null, '11e2-5faa-5a846059-b702-3f84c4cacb0d', '1', '11e2-613b-b025fb75-a79e-e3f5892dd4af', '155141104830700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('AovCkRVluFdMr8dEixK', '2jSs6cnzu4mzY9C13vF', null, '71ct9G1xJPW7vLgA5JB', '2', '71ct9G1xJPW7vLgA5JB', '155142339620200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('aOXehxj6N62luJN8cAl', 'kPLbeydkgiYW6NIkCt0', null, '0zSRHMqiyMTl1dth7ds', '1', 'cn2gajGsHOgYLGZkWvG', '155168804552300000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('AP4HZp9JotaItAREIqg', '0Q0LkJpfR1ejtO8rD3p', null, 'vDsnTykdPOblfwEF4mR', '1', 'jVcLQaH4BiwznPvstCF', '155168789473300001', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('ApalgOWV8bVCAlPblJO', 'jkpTHKg7DpuXQrppVxx', null, 'b3y6CS4gmftCVXdw4Pb', '2', 'b3y6CS4gmftCVXdw4Pb', '155142352959800004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('APouic3VHKusRj1IDnf', '2ytUeoxBqghwofmBALl', null, 'smthlnru9z9qwavJKk1', '0', '55V8ZUWfTBCxFClWTNS', '154461619099200000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('aPVtB6sWvdhIHoMrRVv', 'jkpTHKg7DpuXQrppVxx', null, '0zSRHMqiyMTl1dth7ds', '1', 'cn2gajGsHOgYLGZkWvG', '155142353028500000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('aq1tPyUvayMxwKOZG7x', 'WB81MbCBolNg6XmE35M', null, '11e2-5fb6-9a1cc7c4-b702-3f84c4cacb0d', '0', '11e3-9878-595c85c8-a625-2b98d9965dcf', '155141104843200001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('AQDUY8Zn7bq3qF7w66g', '2jSs6cnzu4mzY9C13vF', null, 'YLmf4h3xwvzrU2wJmYU', '2', 'YLmf4h3xwvzrU2wJmYU', '155142339612400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('AqGQkxENU3BxsIZdWxC', '2ytUeoxBqghwofmBALl', null, 'eLFjqFngRQrIkbsdeBd', '1', 'SX3rVQxkpU96Pko5JDm', '154461619052300005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('AQsen0eg92L3VWlOTLK', 'kPLbeydkgiYW6NIkCt0', null, 'K34zNYKOBOe8fgOk6ia', '2', 'K34zNYKOBOe8fgOk6ia', '155168804499300004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('AR7SXuZZN04jllrgCgx', '2jSs6cnzu4mzY9C13vF', null, 'qqHbF4LC1qdUg1ak29k', '1', 'qqHbF4LC1qdUg1ak29k', '155142339668600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('arl8H77KYMVXw0z016e', 'jkpTHKg7DpuXQrppVxx', null, '6Xi7fyFJT20APl5y8RE', '2', '6Xi7fyFJT20APl5y8RE', '155142352973900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ARMD25zGF4Dj2koYgsm', '0Q0LkJpfR1ejtO8rD3p', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'tjznokFdoftUtJzbwhl', '155168789361000004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('ArOiba5sD7dkkKkHcVw', '2jSs6cnzu4mzY9C13vF', null, '0zSRHMqiyMTl1dth7ds', '1', '0zSRHMqiyMTl1dth7ds', '155142339676400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ArVk5A8G7Q9qcduXgSQ', '2ytUeoxBqghwofmBALl', null, 'smthlnru9z9qwavJKk1', '0', 'AHJzoQDdLpyRpZLTTdK', '154461619146000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('AS5nLB4OwblWM8n7LjG', 'kPLbeydkgiYW6NIkCt0', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'IHazLikeEs3KYw5CBgr', '155168804664600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('asau4UXAZxBF9rwTHxS', 'kPLbeydkgiYW6NIkCt0', null, 'RbRiCQx2QJQpvBYXZ2O', '0', 'RbRiCQx2QJQpvBYXZ2O', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单12', '1032', '2');
INSERT INTO `t_permission` VALUES ('AsgHdQks1f1q8u6C7Nz', 'kPLbeydkgiYW6NIkCt0', null, 'lOgu0Jvq0z5dlveyrnY', '0', '5XIqbMcQ6K0lFtVi4HZ', '155168804616300000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ASLRBn6AZ5udyT5Mvkf', 'jkpTHKg7DpuXQrppVxx', null, 'LocWe3mm3K3vF1gdbgC', '2', 'LocWe3mm3K3vF1gdbgC', '155142352966100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('asRs5QjkWiU7eVWhY7B', 'WB81MbCBolNg6XmE35M', null, '11e8-5779-e83c37fa-a079-2fb3fd4402df', '0', '11e8-5779-e83c3806-a079-2fb3fd4402df', '155141104855700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('AtB9xkis0qxvMuIHrus', 'jkpTHKg7DpuXQrppVxx', null, '71ct9G1xJPW7vLgA5JB', '2', '71ct9G1xJPW7vLgA5JB', '155142352998800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('aTE6YKZSDPYK2R8mEZq', '3tFw1boS5L9vXoJCr6Z', null, 'rGe8G3KDtHAZZyMFzyw', '1', 'rGe8G3KDtHAZZyMFzyw', '154563949567900004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('aTOvj8o45ZkxXQ5AdZ4', '2jSs6cnzu4mzY9C13vF', null, 'Jh68ppMt3QMha315Hi6', '0', 'ePkoYYvvztlUvkHqa16', '155142339745000003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('au1lryCAMNOIA1WfUi2', '2ytUeoxBqghwofmBALl', null, 'EGmIBh1ogGUoD8df1rE', '1', 'K1Q7LwDo3Y9JWxc1O1W', '154461619138200000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('aUEAf5PLLSwhOM1g4PL', '0Q0LkJpfR1ejtO8rD3p', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'Iw7PqAhVcFRVUHnbbwR', '155168789445200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('aV9gHJ3IfCjGsnjnPTq', '3tFw1boS5L9vXoJCr6Z', null, 'viwgtc32VtB7wJo2O8S', '0', 'Wlje8Nr2ww7qrmEwdBf', '154563949517900000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('aVbGNb1H3VgivKA6YgL', 'jkpTHKg7DpuXQrppVxx', null, 'SaFhOUcZJcd0Kj5IodL', '2', 'SaFhOUcZJcd0Kj5IodL', '155142352989500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('AVHo8vytXkbFnrQH4tm', 'jkpTHKg7DpuXQrppVxx', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'WL5tjQMqesP6uJhWq81', '155142353073700002', 'HdPeBqYwJyFyjHkhZu3', '批量审核', '20', '1');
INSERT INTO `t_permission` VALUES ('awg3ViuvBSfU0Mrr7yV', 'WB81MbCBolNg6XmE35M', null, '11e6-561b-bad81da5-91c5-cd8abd28b1f9', '2', '11e6-561b-bad81da5-91c5-cd8abd28b1f9', '155141104757400003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('AWH52KM4Bq5yJeBwitK', '2ytUeoxBqghwofmBALl', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'XbKbKnKFlkZNvOSlGTo', '154461618944500001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('AwSgBd4wbS4Lfs3PAFX', 'WB81MbCBolNg6XmE35M', null, '11e6-53f9-3bed7a60-81f5-679a826556ce', '1', '11e6-d15f-d0577723-bbdd-9f7a0eebced4', '155141104982100001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Axapl7u0c96grotTisF', 'jkpTHKg7DpuXQrppVxx', null, '6BIvNJISOeZ3xm8S2aG', '1', '6BIvNJISOeZ3xm8S2aG', '155142353020700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('AxJnVq7kXqumInZVras', '0Q0LkJpfR1ejtO8rD3p', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'QE5Y9qsMqfgX5CnSw2u', '155168789468600003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('aXleMJJcK9QP4EBMNvA', 'WB81MbCBolNg6XmE35M', null, '11e6-55fe-10c18219-bb59-b7243d4bcf51', '0', '11e6-55fe-21daf324-bb59-b7243d4bcf51', '155141105011700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('AXMr2qNYlLaPtzIjVTd', 'kPLbeydkgiYW6NIkCt0', null, '7u0fRbpHrxopCyfgADs', '1', '7u0fRbpHrxopCyfgADs', '155168804558500002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('axPXIqIHDvYZvH9xM9R', '3tFw1boS5L9vXoJCr6Z', null, 'yDZaeD0mt44iNjakHmE', '0', 'gOx8PapU5TCGaG1IcWs', '154563949539800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('axQgTaK60VD5H316QdL', 'jkpTHKg7DpuXQrppVxx', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'TdjwkbcPtyWwzr47Pw5', '155142353022200003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('AYh8KPSoI6BJSWNKTho', 'jkpTHKg7DpuXQrppVxx', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K4IeXTdrXu7wZa0AkpH', '155142353039400001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('AYkjiDDoj3t40FTmYBw', '2ytUeoxBqghwofmBALl', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'x2qgUpE8u9jmGEWbbQm', '154461618861700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('aZaIdf3JXLlsODysEsu', '0Q0LkJpfR1ejtO8rD3p', null, 'ysihCX7dcjE9EuejMrJ', '2', 'ysihCX7dcjE9EuejMrJ', '155168789329800004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('azpeQPNMSPVbS4QCk3H', 'kPLbeydkgiYW6NIkCt0', null, 'IfoHRC8Rs6njW75HqiE', '1', 'IfoHRC8Rs6njW75HqiE', '155168804653700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('aZskweMFAE8XBkiqw1m', '3tFw1boS5L9vXoJCr6Z', null, 'PLiK5HYs3YFoECyyMBo', '2', 'PLiK5HYs3YFoECyyMBo', '154563949463200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('B0lnEOskhiAdTiUAOWZ', '2ytUeoxBqghwofmBALl', null, '3gGNzYyE5dK9ogZidWA', '1', '3gGNzYyE5dK9ogZidWA', '154461618917900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('B0nm70E4WqA2ZtvQeYB', '3tFw1boS5L9vXoJCr6Z', null, 'v0ioxUWrQYtMKt3TTeU', '0', '59objucVbuT5MT82n7E', '154563949527300000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('b1s5UCuEvTA0tGgseLw', 'jkpTHKg7DpuXQrppVxx', null, 'm8moRuOLRGU8fSbCIty', '0', '6ieKi8bk8zbO9XkicpP', '155142353014400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('B1U6btLq3twx6skjX7S', 'jkpTHKg7DpuXQrppVxx', null, 'dtXU9EYYl4qLe8PdIVc', '0', '35iPlaPI9jj9qVEeTCZ', '155142353064400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('b2APzPJjzB207NDPfsS', '2ytUeoxBqghwofmBALl', null, '4RJ5cYekBtB1RdNDxL3', '1', '4RJ5cYekBtB1RdNDxL3', '154461619030400001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('B2fLAZL5kI8ANV470mM', '2ytUeoxBqghwofmBALl', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'zubbDJQFaTursZKijlj', '154461619039800001', 'HdPeBqYwJyFyjHkhZu3', '自定义', '13', '1');
INSERT INTO `t_permission` VALUES ('b3ABKBhmj4ewB22KrQ4', 'WB81MbCBolNg6XmE35M', null, '11e6-52de-588531bf-a13d-c75d0a89256c', '1', '11e6-52e2-0482b45c-a13d-c75d0a89256c', '155141104890000002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('b4B1Nc57hrJtDn9oekb', '0Q0LkJpfR1ejtO8rD3p', null, 'FKEDNCysUfAav1gze8O', '2', 'FKEDNCysUfAav1gze8O', '155168789322000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('B5B7MoaYYtZeIp6WTh5', '2jSs6cnzu4mzY9C13vF', null, '7u0fRbpHrxopCyfgADs', '1', 'rjxMvPpz6S7x7f7eWEk', '155142339706000001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('b5OhnewZaPVHzDAQMwf', 'kPLbeydkgiYW6NIkCt0', null, 'iuGmP6OvURaOFF3NzoP', '0', 'vTGnvvEUTALWtPdcXab', '155168804606900003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('b5VLtxEIWgTEo74qxNc', '2jSs6cnzu4mzY9C13vF', null, 'XAQy4mQfPb9hnyOISK1', '0', 'xGuspPXmrUTCn5KTdAR', '155142339762200004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('b6bWo8HkWBQ2L8SRxd4', '2ytUeoxBqghwofmBALl', null, 'WOmzvkui5ZsoZu1CogR', '1', 'i12huWXbQz9KJExHc6D', '154461619042900000', 'HdPeBqYwJyFyjHkhZu3', '文件下载(路径脚本需完善)', '26', '1');
INSERT INTO `t_permission` VALUES ('b6BwpHFpFoFiChK1IRF', 'jkpTHKg7DpuXQrppVxx', null, 'o4zdmPoNHMg5JK6m6dx', '0', '2MHj4CnPnbOb2UFuMQr', '155142353129900000', 'HdPeBqYwJyFyjHkhZu3', '执行前再确认', '3', '1');
INSERT INTO `t_permission` VALUES ('b6jlobDQYHvvfWNtZUp', '2jSs6cnzu4mzY9C13vF', null, 'EGmIBh1ogGUoD8df1rE', '1', 'K1Q7LwDo3Y9JWxc1O1W', '155142339890100001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('B6Mff1xYgIynk0DkzAG', '2ytUeoxBqghwofmBALl', null, 'IuPDe4Gm9occzflnrP0', '0', 'R45h7dTChA2x72ng9VU', '154461619108500004', 'HdPeBqYwJyFyjHkhZu3', '当前页面打开', '43', '1');
INSERT INTO `t_permission` VALUES ('b6TkELrooNsCQUBUmW8', 'WB81MbCBolNg6XmE35M', null, '11e6-52de-588531bf-a13d-c75d0a89256c', '1', '11e6-d15e-622a01f9-bbdd-9f7a0eebced4', '155141104890000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('B7imrzn8qL5prRmvDGI', '0Q0LkJpfR1ejtO8rD3p', null, '8q7uUoYo99jyzdLW3o5', '1', '8q7uUoYo99jyzdLW3o5', '155168789424900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('b7KVhVrLWDonyObcKfg', 'WB81MbCBolNg6XmE35M', null, '11e6-55fe-77cd3577-bb59-b7243d4bcf51', '0', '11e6-55fe-882615a2-bb59-b7243d4bcf51', '155141105016400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('B89xsTNnuzPTbRhkGCz', '2jSs6cnzu4mzY9C13vF', null, 'SAzJx5AkUZOJRct29BH', '0', 'wLzLCUPc9LuRRv9j8J3', '155142339823000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('B8ewCc5gtGW8wDk96px', 'jkpTHKg7DpuXQrppVxx', null, 'dtXU9EYYl4qLe8PdIVc', '0', 'k1Bk7XRgKJ0522NyIQs', '155142353062800002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('b8GVl3DL4a2usLIWbhZ', 'kPLbeydkgiYW6NIkCt0', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'PJTrl1ydDfvxVoyGPXp', '155168804564800002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('b8sPlQukkHeN6F9Hj6i', '0Q0LkJpfR1ejtO8rD3p', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'Mto2Exz54Tcvkyw1NCx', '155168789361000003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('B8SRNclXLbuykXj9qn9', 'WB81MbCBolNg6XmE35M', null, '11e6-5633-c861eb4e-91c5-cd8abd28b1f9', '1', '11e6-5635-509ef9de-91c5-cd8abd28b1f9', '155141105219200001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('b8vxlloU9tSmEf2P2jw', '2ytUeoxBqghwofmBALl', null, 'mXDUC8go52mfA91GY0r', '0', 'fh4ptUZPIiHNtWvp0cJ', '154461619111700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('b8yIltu5uz3X23iTl6y', '3tFw1boS5L9vXoJCr6Z', null, 'U945OMsdX9fvzRjE7xG', '0', 'NNovnd63EkWs6jGCQgq', '154563949519500001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('bacT3LZda09sxUjqBAe', 'jkpTHKg7DpuXQrppVxx', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'eTfrqgZ8RLViOksDpqV', '155142353108000000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('BAcyPNWmLnT6vI2vZdA', '0Q0LkJpfR1ejtO8rD3p', null, 'EGmIBh1ogGUoD8df1rE', '1', 'K1Q7LwDo3Y9JWxc1O1W', '155168789481100004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('BaR5uczigRsPSYjbLNj', 'kPLbeydkgiYW6NIkCt0', null, '9HKopmq2QmqQZjBp0ve', '1', '9HKopmq2QmqQZjBp0ve', '155168804624100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('bAT6yhppEVGtLUxXrD2', '2ytUeoxBqghwofmBALl', null, 'SAzJx5AkUZOJRct29BH', '0', 'wLzLCUPc9LuRRv9j8J3', '154461618889800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Bawxzw6tP2tOkZT2SKN', 'WB81MbCBolNg6XmE35M', null, '11e6-561a-0bfbfa4a-91c5-cd8abd28b1f9', '2', '11e6-561a-0bfbfa4a-91c5-cd8abd28b1f9', '155141104771500002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('BayysnLsKY6pEA6OvMu', '2ytUeoxBqghwofmBALl', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'AiibIdUU3zQiGsrKDXn', '154461619096000005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('bbdLtp89UmjqnDBDSEx', '3tFw1boS5L9vXoJCr6Z', null, 'gniImP2ug7E82S1WO0L', '1', 'A9ZVOiaJCjFUhFQkG6X', '154563949578800004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('bbLa7haCkby8wlSfr7f', '0Q0LkJpfR1ejtO8rD3p', null, '9ppSV2PIKNhHCOwufvI', '0', 'KJPLDYCNeJz1SWkwXZd', '155168789462400003', 'HdPeBqYwJyFyjHkhZu3', '下载文件', '26', '1');
INSERT INTO `t_permission` VALUES ('bBuOYkJqOCcX4xToqEU', '2jSs6cnzu4mzY9C13vF', null, 'Q1jIFlIQgvrxXHuYM9L', '2', 'Q1jIFlIQgvrxXHuYM9L', '155142339589000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bCAtARlycTDsInDfBa9', 'jkpTHKg7DpuXQrppVxx', null, 'YLmf4h3xwvzrU2wJmYU', '2', 'YLmf4h3xwvzrU2wJmYU', '155142352992600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bcEaGPMm00XI4KZLS6L', 'WB81MbCBolNg6XmE35M', null, '11e6-54b1-282867bf-9671-379f935a9949', '1', '11e6-54b2-69e50f6d-9671-379f935a9949', '155141104930600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('bCEoF5nY6dywNRWHXh9', 'kPLbeydkgiYW6NIkCt0', null, 'DzqlEtg4JObApV7iWX8', '0', 'YIzUW1O7NPBhfxLwHuj', '155168804588200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('bCiCU7mEZYHiDrqftcP', 'kPLbeydkgiYW6NIkCt0', null, '7u0fRbpHrxopCyfgADs', '1', 'rjxMvPpz6S7x7f7eWEk', '155168804558500003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('BCuQzltDWocLiPii2KJ', 'jkpTHKg7DpuXQrppVxx', null, 'Vu8Q68Bom89YJDgguC9', '1', 'Vu8Q68Bom89YJDgguC9', '155142353092400004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('bcxJ8GBhRfxiK911dE0', '2jSs6cnzu4mzY9C13vF', null, 'WHKujMuxTp67TYMu80o', '0', '7wT8mURPGaaDwJxvvHC', '155142339857400000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('BdIg7sBuZfFaCZWjw2l', 'kPLbeydkgiYW6NIkCt0', null, '8BSYIj5kZKJjAD7IxkX', '2', '8BSYIj5kZKJjAD7IxkX', '155168804489900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bDuRfuP6XCNpvbF08KZ', 'jkpTHKg7DpuXQrppVxx', null, 'zqGmDkZIRa4COpFVzTj', '1', 'GfV1N4DO1ZfVQGkI6Jz', '155142353008200000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Bdws2HojQ5SslBbJpQM', '2jSs6cnzu4mzY9C13vF', null, '7NlGpNC1MAEM6EuX2X0', '1', '7NlGpNC1MAEM6EuX2X0', '155142339907300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('bDXusGTufSvsaCnf3f1', '2ytUeoxBqghwofmBALl', null, 'A6EMGp4mkUqLbMGLtql', '0', 'jvS3grY0lQM6HRUV78H', '154461618853800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('beDBWCPnan06bqfTv2k', 'WB81MbCBolNg6XmE35M', null, '11e6-592c-d0d8c95a-a8ef-c39406c7f446', '1', '11e6-592c-d0d8c95a-a8ef-c39406c7f446', '155141105177100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('bePw90gDDA3IbFtVV3i', '3tFw1boS5L9vXoJCr6Z', null, '3K4lxgBhBLAbzJrfYaB', '1', 'j2jPRJ7cK9BqO2p9iP9', '154563949632000004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('bEUCvYixYBz1jf7Mi4b', '2ytUeoxBqghwofmBALl', null, 'qU8WM5a2IVVudiqn38E', '1', 'qU8WM5a2IVVudiqn38E', '154461618825700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('bf03Hd7CqFXfXYzXO3u', '2jSs6cnzu4mzY9C13vF', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'QXO7cxkzLZ51qdiKBrI', '155142339888600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('BFAoXY3Q229yINFUqOL', '2ytUeoxBqghwofmBALl', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'PTTHSwtvw3HyoyAo3JB', '154461619097600005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bfbHXVGxVLKClaYFkSi', 'WB81MbCBolNg6XmE35M', null, '11e6-596a-8d25aa25-a94a-e36ebd4ccf2c', '2', '11e6-596a-8d25aa25-a94a-e36ebd4ccf2c', '155141104780800002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bGBbcSuyeRKpw9fi29U', 'kPLbeydkgiYW6NIkCt0', null, 'CUiq0kurilZ2dSBIXUv', '0', 'Ksb2IhhfWaj5cJWTMwr', '155168804578800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bGg3E5PXYZobAco0sPY', '2ytUeoxBqghwofmBALl', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'gP7qA2QTRCEqWmdByHT', '154461619033500003', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('BgN1YVYMUANnVIK205C', '2jSs6cnzu4mzY9C13vF', null, '8DmOHAVRvs3BblbhJoa', '1', '8DmOHAVRvs3BblbhJoa', '155142339653000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('BgRE20oHbFkxPf7uQRW', 'kPLbeydkgiYW6NIkCt0', null, 'WHKujMuxTp67TYMu80o', '0', 'ti2S70c11piGDmryGEq', '155168804630300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bh5V4602dO414zpn968', 'jkpTHKg7DpuXQrppVxx', null, 'IiQlslLmgrgXGsdYY0S', '2', 'IiQlslLmgrgXGsdYY0S', '155142352969200004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Bim3ukyh46wiJGkDFtK', 'jkpTHKg7DpuXQrppVxx', null, 'A6EMGp4mkUqLbMGLtql', '0', 'jvS3grY0lQM6HRUV78H', '155142353101800005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('bJL8ZfXAT9rzbZfhHn6', 'jkpTHKg7DpuXQrppVxx', null, 'xBX9EbJkveiSGJm9xRj', '0', 'hkNKtk1zbGkFX0hZFT9', '155142353069000004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bJRswnC31hkGVx6zoHd', 'jkpTHKg7DpuXQrppVxx', null, 'DzqlEtg4JObApV7iWX8', '0', 'YIzUW1O7NPBhfxLwHuj', '155142353078400005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('bJXGy6zI3WX2wX6oUi6', '0Q0LkJpfR1ejtO8rD3p', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'TdjwkbcPtyWwzr47Pw5', '155168789350100002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('BJzymIRpNjW8BmaoQQ6', 'kPLbeydkgiYW6NIkCt0', null, 'IuPDe4Gm9occzflnrP0', '0', 'R45h7dTChA2x72ng9VU', '155168804644300002', 'HdPeBqYwJyFyjHkhZu3', '当前页面打开', '43', '1');
INSERT INTO `t_permission` VALUES ('bkgPtT6jZmvkrfpgGBH', '2ytUeoxBqghwofmBALl', null, 'DzqlEtg4JObApV7iWX8', '0', 'e6ZwAUd38TnujcTz0j9', '154461619025700003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Bkmt9qUutbMDYOUDQ7N', '0Q0LkJpfR1ejtO8rD3p', null, 'j4ncSyWthzCYoNj3n4J', '0', 'KVWnOmmml6Kwm3w1RPe', '155168789451500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('BKPQrN63XQMwut01ciV', '2jSs6cnzu4mzY9C13vF', null, '8q7uUoYo99jyzdLW3o5', '1', '8q7uUoYo99jyzdLW3o5', '155142339788700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('bkqJrFp79tzrhud5FDt', '0Q0LkJpfR1ejtO8rD3p', null, 'hdMXKLI1XqTUYUrFniv', '0', 'aa25jXytFYZYB62Ac2z', '155168789457700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('BKZGNTInF7FPVcTVlok', 'kPLbeydkgiYW6NIkCt0', null, 'nv2ul1HAiYcvTtoT6Lr', '1', 'nv2ul1HAiYcvTtoT6Lr', '155168804605300004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('blkkMG27mVukqVnWJqD', '0Q0LkJpfR1ejtO8rD3p', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'lCdJ38yUB4mcSL1qJJ2', '155168789375000003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('bM2xPTBp0ppFFi8abm2', 'jkpTHKg7DpuXQrppVxx', null, 'wjPLVvwWYR2a9BOi0st', '0', '6798mFOtT3LLK9CYgPv', '155142353103400004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bm4F77Zc00EZTZGf4GA', 'kPLbeydkgiYW6NIkCt0', null, 'kA4m81roWetnkDQgWm0', '0', 'imbMPttNeDXyRLEFJeh', '155168804569500005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bMDLM0hPDDOtWJLAc2x', '0Q0LkJpfR1ejtO8rD3p', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'jlpTpnbZ03B6oqSeFmM', '155168789446800000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('BMeYFtImfbHEimJRNH0', '2ytUeoxBqghwofmBALl', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'NF5zkjoJvJNVpgmQsj6', '154461619103800002', 'HdPeBqYwJyFyjHkhZu3', '执行前提示', '3', '1');
INSERT INTO `t_permission` VALUES ('Bml77Om8zMGMGy9Ivro', '3tFw1boS5L9vXoJCr6Z', null, 'F6reQ5BW7P6q236Pi13', '1', 'F6reQ5BW7P6q236Pi13', '154563949608500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('BMlbTuMbzLf3E3d8KUb', 'WB81MbCBolNg6XmE35M', null, '11e6-57c7-4e7f1b0f-99bd-f3f2cc3ce475', '1', '11e6-57c7-4e7f1b0f-99bd-f3f2cc3ce475', '155141104911900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('bMLZ5a5wuA8zqZbm103', '2ytUeoxBqghwofmBALl', null, 'zg2t1qqkaJ17B2vvX05', '0', 'COoHnOHkHeviVNasUlf', '154461619099200003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('bMOmtx34EqNi6JnlHTR', 'jkpTHKg7DpuXQrppVxx', null, 'Jzy7zZItDzniSSkL6fQ', '2', 'Jzy7zZItDzniSSkL6fQ', '155142352986400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Bmp4PrwpFR9yzEhV1Nx', '2ytUeoxBqghwofmBALl', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'bOLR3Xo33mj06rfix3J', '154461619064800001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('BMutZubcfVoxhl6hwLk', 'kPLbeydkgiYW6NIkCt0', null, 'JJCy9khz1JRwqvX4xEI', '0', 'uFtdRxVPySujVTqhxrx', '155168804569500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bMyfbZimeIag6YOLfVh', '2ytUeoxBqghwofmBALl', null, 'wwsNkkwFEvqL44gK2fM', '0', 'WbfBIyoU0AkbLY6hBur', '154461618992900003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bngNkleh036EwwWSgA9', 'WB81MbCBolNg6XmE35M', null, '11e6-5614-de0198f5-91c5-cd8abd28b1f9', '2', '11e6-5614-de0198f5-91c5-cd8abd28b1f9', '155141104751200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bnmB5hqJA5hODhSNwS2', '2jSs6cnzu4mzY9C13vF', null, 'ry6uZqKmxro1UYtKquD', '2', 'ry6uZqKmxro1UYtKquD', '155142339550000004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bnMcGWesYgekF27uc0m', '3tFw1boS5L9vXoJCr6Z', null, 'gPHUIa48Bpsz26fjjNA', '2', 'gPHUIa48Bpsz26fjjNA', '154563949455400003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('BNP3PC2kx3IOZIginFI', '3tFw1boS5L9vXoJCr6Z', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'GWNOfrdfU2z2hYo2y6Q', '154563949560100001', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('bNtodCc12Jtxdk67QEP', '2ytUeoxBqghwofmBALl', null, 'poalxIjVlN70WdVjfQq', '1', 'ZABfGox4xJSo5PMgCOr', '154461619102300006', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('BoCpQrD1gKCzmwjVDJH', 'kPLbeydkgiYW6NIkCt0', null, 'eLFjqFngRQrIkbsdeBd', '1', 'UZzpqQ3lo5RbuYNWbsL', '155168804658400000', 'HdPeBqYwJyFyjHkhZu3', 'pdf导出', '25', '1');
INSERT INTO `t_permission` VALUES ('bodJyJqzDmswI25Crel', '0Q0LkJpfR1ejtO8rD3p', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'XYV76K6iat8P2bzFJIm', '155168789468600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('BogAB65ZQDvhnGbu1Be', '2jSs6cnzu4mzY9C13vF', null, 'sxP7Fu1gvFvYLklKaKB', '2', 'sxP7Fu1gvFvYLklKaKB', '155142339559400003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('boJO50dfNC6X3vD5sSW', 'jkpTHKg7DpuXQrppVxx', null, '7NlGpNC1MAEM6EuX2X0', '1', 'tqjrAb05aPRsD2JYTh1', '155142353168900000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('boUv1KzlKQ0lqXw5WuH', '3tFw1boS5L9vXoJCr6Z', null, 'wjPLVvwWYR2a9BOi0st', '0', '6798mFOtT3LLK9CYgPv', '154563949574100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bOXEZTTGbVj1bZZ7Do4', '2jSs6cnzu4mzY9C13vF', null, 'ZB7liHeZS7Qm0mlMz6b', '2', 'ZB7liHeZS7Qm0mlMz6b', '155142339607800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bP9mhR775fwipGzlpJr', '2ytUeoxBqghwofmBALl', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'Zb272Z4FRc9su5s2Lik', '154461618966300004', 'HdPeBqYwJyFyjHkhZu3', '批量提交（图片图标）', '20', '1');
INSERT INTO `t_permission` VALUES ('BpeASiNhHH9ti9MU6Rh', '2ytUeoxBqghwofmBALl', null, '9ppSV2PIKNhHCOwufvI', '0', 'KJPLDYCNeJz1SWkwXZd', '154461618963200003', 'HdPeBqYwJyFyjHkhZu3', '下载文件', '26', '1');
INSERT INTO `t_permission` VALUES ('BPhwpxIJ7OjwS33nRI6', '0Q0LkJpfR1ejtO8rD3p', null, 'b3y6CS4gmftCVXdw4Pb', '2', 'b3y6CS4gmftCVXdw4Pb', '155168789295500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('BpIrVpzkVgGUfLDRT6h', '2jSs6cnzu4mzY9C13vF', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'Nmhce5xixb5FBPVv5dc', '155142339865200004', 'HdPeBqYwJyFyjHkhZu3', '此按钮不可见', '3', '1');
INSERT INTO `t_permission` VALUES ('BpLDukuVyoYXJ3DCgIc', '2ytUeoxBqghwofmBALl', null, 'F6reQ5BW7P6q236Pi13', '1', 'F6reQ5BW7P6q236Pi13', '154461619116300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('bPSL8idaui7CKMdmSTD', '2ytUeoxBqghwofmBALl', null, 'TU5YGgO5fJs1QU3q3h6', '1', 'TU5YGgO5fJs1QU3q3h6', '154461619052300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('bPYtgVPrD7W1SG9itny', '0Q0LkJpfR1ejtO8rD3p', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'GWNOfrdfU2z2hYo2y6Q', '155168789420300002', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('BqJW5Jko5EEluUz1zbO', 'jkpTHKg7DpuXQrppVxx', null, 'g7U0PGtN5bKYhwbka6s', '0', 'V6C3ScFeVfcdhY9Xw63', '155142353065900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('bqskkArkgwwaceB0u0y', '2jSs6cnzu4mzY9C13vF', null, 'J9uhQYSQWhPor4IvkOE', '0', 'Q2aiiWtqBNqF33UGXUy', '155142339634300002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('BQWMWLDTDdw5Al8CrRv', '2ytUeoxBqghwofmBALl', null, 'xBX9EbJkveiSGJm9xRj', '0', 'hkNKtk1zbGkFX0hZFT9', '154461619008500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('BrbQD8Dbe6OJHafsOPx', '3tFw1boS5L9vXoJCr6Z', null, 'IMD35YU4FNWL8IkwPAJ', '1', 'IMD35YU4FNWL8IkwPAJ', '154563949505400001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('BRFSf3ElFKo4Kxboca1', '0Q0LkJpfR1ejtO8rD3p', null, 'U1TygLjjsSxDfEoGwhc', '1', '6hT0k732Mz5j3yugFP1', '155168789343800002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('BrKfAvfBoUrG0vvumKd', '3tFw1boS5L9vXoJCr6Z', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '154563949441300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('BROZo3rlsLEqP6o3HFP', 'kPLbeydkgiYW6NIkCt0', null, '2FzVqBVCwr7uvFsl3Yo', '2', '2FzVqBVCwr7uvFsl3Yo', '155168804499300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('BrWJOPjlOhKN2KpdIgT', '2ytUeoxBqghwofmBALl', null, 'eLFjqFngRQrIkbsdeBd', '1', 'UZzpqQ3lo5RbuYNWbsL', '154461619052300001', 'HdPeBqYwJyFyjHkhZu3', 'pdf导出', '25', '1');
INSERT INTO `t_permission` VALUES ('bS0wJ5KuZBRtPKvgMgI', '2jSs6cnzu4mzY9C13vF', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'D4TlyirrG1V4ebAqUSh', '155142339863600002', 'HdPeBqYwJyFyjHkhZu3', '删除（右键菜单）', '3', '1');
INSERT INTO `t_permission` VALUES ('bS75PI949AHdMJozkhS', 'kPLbeydkgiYW6NIkCt0', null, 'KUp98gX4KG2acWUaepP', '2', 'KUp98gX4KG2acWUaepP', '155168804475900006', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bs8HOT6m8DYkJU44t8I', '2jSs6cnzu4mzY9C13vF', null, 'uiFkOAGeBPQyi2pQlVb', '2', 'uiFkOAGeBPQyi2pQlVb', '155142339601500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bscdsi4WZ0lp2uvDLzR', '2jSs6cnzu4mzY9C13vF', null, '68kltzfu9ZSUp9aJOg4', '2', '68kltzfu9ZSUp9aJOg4', '155142339592200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('BsSzzjiaZ0QzIZ4PdL7', '0Q0LkJpfR1ejtO8rD3p', null, 'g2XzgmKDL1T8UB79GZh', '0', '1uOt5KaDxl3ZK3OT1Mw', '155168789456100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bSZGvQqviFqlgFuaFWw', '2jSs6cnzu4mzY9C13vF', null, '4oavihvP4J8cXDsWDIP', '0', 'FRLJFxdshvQAeKmHSfM', '155142339829300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bT0ViCs7HMQdF2qrwFe', '2ytUeoxBqghwofmBALl', null, 'SiPTeSpUhRIqVgi1HW1', '0', '75x9tz4gNnPZBrKKcK5', '154461619046000003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bTGklML4nQCEmSSgNXx', 'kPLbeydkgiYW6NIkCt0', null, 'qAcxhZ5mnoiohEBYD9G', '2', 'qAcxhZ5mnoiohEBYD9G', '155168804474300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('BtZXS8iEF10RNGFSIWA', '2jSs6cnzu4mzY9C13vF', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'sMlqIILsNZ3bvqE2hSm', '155142339645200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('bUJXngA70NKGP7et9h0', 'jkpTHKg7DpuXQrppVxx', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155142352964500005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('BuMzo1TIJptdkUZeADI', '0Q0LkJpfR1ejtO8rD3p', null, '0bgD6IPDYyID2susbqZ', '0', 'q2Ay04xXzfVCDjfyvgH', '155168789401500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('buP1Z5Fcx77p4iaeKRo', '0Q0LkJpfR1ejtO8rD3p', null, 'g7U0PGtN5bKYhwbka6s', '0', 'VXaTIyUn85r0Xf2ja64', '155168789387500005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('buph5ahIQLbiHIPUwnL', '2ytUeoxBqghwofmBALl', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'A293BH1uO82kIt5k5f9', '154461619044500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Bv0FruW1WEOrKeFHRn5', 'WB81MbCBolNg6XmE35M', null, '11e6-5540-7128195d-8350-a3b9b8447d61', '1', '11e6-d15e-f5f713cd-bbdd-9f7a0eebced4', '155141105159900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('BVBEMdUwlPbrj8bby6f', 'jkpTHKg7DpuXQrppVxx', null, 'L7O7fkCLsVh7KYd0RIy', '1', 'L7O7fkCLsVh7KYd0RIy', '155142353143900003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('BvCAWgN0qKVlIfMGy0Q', '3tFw1boS5L9vXoJCr6Z', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'erjzyEtPTNQ9Oc2MmGl', '154563949488200000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('bVdy8G6iWSl3pzxz0aZ', 'jkpTHKg7DpuXQrppVxx', null, 'qqHbF4LC1qdUg1ak29k', '1', 'B3jWFwhgVoeriEcsKyv', '155142353025400000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('bVJ4OExTYZc3PhtX6xC', '0Q0LkJpfR1ejtO8rD3p', null, 'SiPTeSpUhRIqVgi1HW1', '0', '75x9tz4gNnPZBrKKcK5', '155168789423400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bVQ4LPksxofunUamj5y', '2jSs6cnzu4mzY9C13vF', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Z3JLytYNIhmUl9AqEci', '155142339776200001', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('bW9rJXCuNuSEd8qHFm3', 'kPLbeydkgiYW6NIkCt0', null, 'kebFCC8mkGX3V1QEriK', '0', '2eoDuuIu6c2LNFTXHBl', '155168804675500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bWiWGiJa7Mhrsnxgla2', 'jkpTHKg7DpuXQrppVxx', null, 'JHeHJ8lBe8BGHZfwoph', '2', 'JHeHJ8lBe8BGHZfwoph', '155142352975400005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('BWRL3ZzZWHqk7FfbOpv', '2jSs6cnzu4mzY9C13vF', null, 'qqHbF4LC1qdUg1ak29k', '1', 'B3jWFwhgVoeriEcsKyv', '155142339668600002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('bWUHq3LCHBRrdVeyGow', 'kPLbeydkgiYW6NIkCt0', null, '2F75ZJJXk8564FkCLYA', '1', 'G1Mxsr3SbNkCXsao7je', '155168804552300004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('bxCylGg16JgAkUlbgFN', '2ytUeoxBqghwofmBALl', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'VMAbFQIQDDpyST1AhyZ', '154461619066300005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bxGztQ7kaF72VTActuM', '2jSs6cnzu4mzY9C13vF', null, 'MIExqx2MWO5cunDiuaX', '1', 'BjLpkwnLuJNx6aokoma', '155142339709200001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('BXjjd3dJSbzWrjcF2LY', 'WB81MbCBolNg6XmE35M', null, '11e6-4f1e-e81c7160-81e8-cb77e1bc6c59', '1', '11e6-4f2b-e80972bb-81e8-cb77e1bc6c59', '155141105214500002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('BXk9fV5QzcHc4QL843m', '3tFw1boS5L9vXoJCr6Z', null, '5RZRK7Jt5vyqwlIccop', '1', 'n7ODSabeRv0h2pyGxhm', '154563949508500005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('BXKxp7biliFsv8urBPi', '0Q0LkJpfR1ejtO8rD3p', null, '9yUEQxnm9PCrsiRLBfo', '2', '9yUEQxnm9PCrsiRLBfo', '155168789298600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bxtWNabzvK6aeIMaE6P', 'kPLbeydkgiYW6NIkCt0', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'XbKbKnKFlkZNvOSlGTo', '155168804550700003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('by0aAfGAHBw41NSR6Fx', 'kPLbeydkgiYW6NIkCt0', null, '9yUEQxnm9PCrsiRLBfo', '2', '9yUEQxnm9PCrsiRLBfo', '155168804477400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('By1AorEUSsR2BG55lM1', '0Q0LkJpfR1ejtO8rD3p', null, 'rUBAvMGr4fLCj7Wg0HQ', '2', 'rUBAvMGr4fLCj7Wg0HQ', '155168789332900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ByASltZ0oGQNi32byCN', '2ytUeoxBqghwofmBALl', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'JAAon6tsqZ7pmxzP2fn', '154461619103800001', 'HdPeBqYwJyFyjHkhZu3', '批量签章', '29', '1');
INSERT INTO `t_permission` VALUES ('bYf3FiqRsFcGkMviRaf', '2jSs6cnzu4mzY9C13vF', null, 'IS48bOUKPFjCVejkBfd', '2', 'IS48bOUKPFjCVejkBfd', '155142339624900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bzcMLozKc3ZklpVklX4', 'jkpTHKg7DpuXQrppVxx', null, '8DmOHAVRvs3BblbhJoa', '1', 'b2wnjqSK0hVEGNix31k', '155142353019100002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('BZJrjJxzoFvjLuGiI8d', 'kPLbeydkgiYW6NIkCt0', null, '98kmnnrWwGKmgyiIkUF', '0', 'mlTio0aN6W90Aant0Mk', '155168804571000004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('BZKXfGzUUQR3a5Sxsfj', 'jkpTHKg7DpuXQrppVxx', null, 'yDZaeD0mt44iNjakHmE', '0', 'gOx8PapU5TCGaG1IcWs', '155142353080000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('bzMAtUWSZZC0r3WgaS6', '2jSs6cnzu4mzY9C13vF', null, 'HqyysOeWOVkmU29sLla', '0', 'NYq2pB1fAXTxVgfupIY', '155142339762200002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('bZtYrtjP937FhyC80vV', '0Q0LkJpfR1ejtO8rD3p', null, 'pr4QXSdeHJHNRiWlpyU', '2', 'pr4QXSdeHJHNRiWlpyU', '155168789286100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('BzXFLAREiOuEoosEfjf', '0Q0LkJpfR1ejtO8rD3p', null, 'TyQHY3EqKQuNGfJ6teV', '2', 'TyQHY3EqKQuNGfJ6teV', '155168789332900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('bZyXrj2Pa5HKhTFzDYo', '0Q0LkJpfR1ejtO8rD3p', null, 'enhnCZbrTQ1mZpn18o5', '0', 'u8rE2hHMPcvxRUXgNQk', '155168789460800003', 'HdPeBqYwJyFyjHkhZu3', '更新所选记录', '1', '1');
INSERT INTO `t_permission` VALUES ('c0S0fAaocyFjyCqmK0U', 'WB81MbCBolNg6XmE35M', null, '11e6-5612-423e7c77-91c5-cd8abd28b1f9', '2', '11e6-5612-423e7c77-91c5-cd8abd28b1f9', '155141104768300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('C1LjGvptYGVxVa28qva', '0Q0LkJpfR1ejtO8rD3p', null, 'Li1q0Dlwg6sZn4YFamQ', '2', 'Li1q0Dlwg6sZn4YFamQ', '155168789306400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('c1ryuw1kTwFZiBKPZTI', 'jkpTHKg7DpuXQrppVxx', null, 'HqyysOeWOVkmU29sLla', '0', 'K6e79wYCTJXzxMeQIon', '155142353075300004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('C28J8Zgc6Bik5uRKksW', '2ytUeoxBqghwofmBALl', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'kYjMqLc40QkdYGXLHWO', '154461618871000001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('c2rnqdvzWf04j4WO7Ay', 'jkpTHKg7DpuXQrppVxx', null, '4mTMb4cMMoLDRa0FTzS', '2', '4mTMb4cMMoLDRa0FTzS', '155142352955200005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('c2Tk63siAbstLg1HMOa', 'jkpTHKg7DpuXQrppVxx', null, 'vO8pkCUFsC8T8Ur5qEn', '2', 'vO8pkCUFsC8T8Ur5qEn', '155142352972300004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('c3ArHEFBQUgqzHJesmr', 'WB81MbCBolNg6XmE35M', null, '11e6-54a7-2bd353aa-9671-379f935a9949', '1', '11e6-578b-e4a9c223-99bd-f3f2cc3ce475', '155141105103700002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('c3c2wE0VBQTk4h9ltjc', 'jkpTHKg7DpuXQrppVxx', null, 'U945OMsdX9fvzRjE7xG', '0', 'S1V13oV2ZMjKmg0oiLO', '155142353064400002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('C3ev5gJgiuWnAxfg6sW', 'jkpTHKg7DpuXQrppVxx', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'VC7xzHBeSzCmdpBwT9w', '155142353033200005', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('c3y0DfsVSIEoVhNIN0k', 'jkpTHKg7DpuXQrppVxx', null, '1fhgTUPecMY0ajlTkKZ', '0', 'juwrHEhNEXIqxCUqQuz', '155142353076800004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('c3zY7DHLAKiGWU5FX39', '2ytUeoxBqghwofmBALl', null, '06Me4ssjoGBiKz0gMK2', '0', 'ZEh1qpMCAgYe10KWd1j', '154461619064800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('c434H1ubtLOOByaEjqv', '2ytUeoxBqghwofmBALl', null, 'LY2n5aO7h1TrpoHU2mc', '1', 'LY2n5aO7h1TrpoHU2mc', '154461618858500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('C4AeBsA5Hhqx31Kl8Tl', '2ytUeoxBqghwofmBALl', null, 'ir2OPEdZvttSUxAzfmD', '1', 'ir2OPEdZvttSUxAzfmD', '154461618933500005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('C4MsWayUNqbCDbJbLtZ', '0Q0LkJpfR1ejtO8rD3p', null, 'RwMAY2iXBOjVaNZzkcE', '2', 'RwMAY2iXBOjVaNZzkcE', '155168789320400004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('c5uPmTzQpG0eq80qV41', 'kPLbeydkgiYW6NIkCt0', null, 'wwsNkkwFEvqL44gK2fM', '0', 'WbfBIyoU0AkbLY6hBur', '155168804569500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('c6tHyK5VGqWB1zKyQQ6', '3tFw1boS5L9vXoJCr6Z', null, 'CUiq0kurilZ2dSBIXUv', '0', 'XxEDLxeqpXRncPsDJDo', '154563949524100004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('C7RNPp9lAiijcccTLqz', 'WB81MbCBolNg6XmE35M', null, '11e6-5632-b9443ff1-91c5-cd8abd28b1f9', '1', '11e6-5632-b9443ff1-91c5-cd8abd28b1f9', '155141105220700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('c8E3jyCl9XX7bmcS5WZ', '3tFw1boS5L9vXoJCr6Z', null, 'RGSlfhmaWRtgtaWUhTU', '2', 'RGSlfhmaWRtgtaWUhTU', '154563949436600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('c9xMx6P4FNopWsyGs7R', '2jSs6cnzu4mzY9C13vF', null, 'T9IoQKXjHSvxRXYM3L8', '1', 'T9IoQKXjHSvxRXYM3L8', '155142339726300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CA8ivpAuqiO5Bm2bdPQ', '2jSs6cnzu4mzY9C13vF', null, 'HqyysOeWOVkmU29sLla', '0', 'K6e79wYCTJXzxMeQIon', '155142339762200003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('CaDbaL6BXEAoIjIzerv', '0Q0LkJpfR1ejtO8rD3p', null, 'Ry5YZ6oWsbQSIWGTbiM', '2', 'Ry5YZ6oWsbQSIWGTbiM', '155168789306400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Cao0Ez59nOv9ijBfFNF', '2ytUeoxBqghwofmBALl', null, 'nv2ul1HAiYcvTtoT6Lr', '1', 'nv2ul1HAiYcvTtoT6Lr', '154461618830400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('caruN8xAa01l5wBTwVK', 'jkpTHKg7DpuXQrppVxx', null, 'sMlqIILsNZ3bvqE2hSm', '1', '7gZkOqMaP3BBCXPapf5', '155142353017600000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('cAsQAdxLvlhvD23VWsb', '0Q0LkJpfR1ejtO8rD3p', null, '9ppSV2PIKNhHCOwufvI', '0', '1vKJVgUjJInvLMSVXIn', '155168789462400000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '36', '1');
INSERT INTO `t_permission` VALUES ('caTb1iuiOxwUG6ZQ9IG', 'jkpTHKg7DpuXQrppVxx', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'gP7qA2QTRCEqWmdByHT', '155142353083100000', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('caYXHd2IzOI7XcWGC1B', 'jkpTHKg7DpuXQrppVxx', null, 'F6reQ5BW7P6q236Pi13', '1', 'F6reQ5BW7P6q236Pi13', '155142353140800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('cB3UaWgbMRZn3nUX8Wq', '0Q0LkJpfR1ejtO8rD3p', null, 'Gc5icb2c0g8ARf7Jath', '0', 'SLsJFM3QWPsTiAQbQRE', '155168789339100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('CBAIhSUoebQPnuv3r2D', 'WB81MbCBolNg6XmE35M', null, '11e6-53d6-9d864d4e-81f5-679a826556ce', '1', '11e6-d15f-69518fd1-bbdd-9f7a0eebced4', '155141105047600001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('cbJrPPLdv5Wy8GGmZJA', '2jSs6cnzu4mzY9C13vF', null, 'NGN4SO4fu5S5XxULG4X', '1', 'TrHax0MzDGsTz4DFUoo', '155142339640500001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('cBmunjtSL14y69Buf9O', '2jSs6cnzu4mzY9C13vF', null, '6BIvNJISOeZ3xm8S2aG', '1', 'gZXQSMJKQTAqYMBYWXE', '155142339659200002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('cc5SjpFt5YD2yI0f1Gq', 'jkpTHKg7DpuXQrppVxx', null, 'G0WtPO1mX58wd7tjkTy', '0', 'MiGkf6DvyyRTJk95EY3', '155142353092400000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('cc9aiNRLM4aIA32H7wu', '2jSs6cnzu4mzY9C13vF', null, 'bn8WKWSmkeCbTynZV4J', '2', 'bn8WKWSmkeCbTynZV4J', '155142339582800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CcAflIPCXr80GxUF4d3', 'WB81MbCBolNg6XmE35M', null, '11e6-560b-5a452a60-91c5-cd8abd28b1f9', '2', '11e6-560b-5a452a60-91c5-cd8abd28b1f9', '155141104779300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CcAPtaJlXNApzlzrMHH', '3tFw1boS5L9vXoJCr6Z', null, '4mlBSmLGlzULUWJe8Nu', '1', '4mlBSmLGlzULUWJe8Nu', '154563949542900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('cCMoIWyqZU0x8XI8ong', '3tFw1boS5L9vXoJCr6Z', null, 'gWeQH0XbGS29JGGgrvT', '2', 'gWeQH0XbGS29JGGgrvT', '154563949442900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CDQfxk3oD7HsUMfn3Qi', '2ytUeoxBqghwofmBALl', null, '3K4lxgBhBLAbzJrfYaB', '1', '3K4lxgBhBLAbzJrfYaB', '154461619147600002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CDrAuCvmFEYlGmJjtvh', 'kPLbeydkgiYW6NIkCt0', null, 'smthlnru9z9qwavJKk1', '0', '55V8ZUWfTBCxFClWTNS', '155168804672400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('CENWfuw7bTs0ytGvW3p', '2jSs6cnzu4mzY9C13vF', null, 'G0WtPO1mX58wd7tjkTy', '0', 'XIYtwtem4lZYZBYOfS5', '155142339785600000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('CEsBosRynagw5ojbtI4', 'kPLbeydkgiYW6NIkCt0', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'Y0AtqRPANYqitR5XI0Q', '155168804558500001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('cEVp5kUYvkKQC4smnQD', 'WB81MbCBolNg6XmE35M', null, '11e6-53f3-57372a15-81f5-679a826556ce', '1', '11e6-53f7-384852ec-81f5-679a826556ce', '155141104972700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('cFac7n47dXhuoTlU8jB', 'WB81MbCBolNg6XmE35M', null, '11de-7665-e571fab8-8d52-0547317ddd4c', '1', '11de-7665-e571fab8-8d52-0547317ddd4c', '155141105133400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CftROzHTcDuVhKwrG7E', '3tFw1boS5L9vXoJCr6Z', null, 'j3y8CHrsMwRmnPJz7EW', '1', 'j3y8CHrsMwRmnPJz7EW', '154563949585100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CFxTUwv6rWbkbQvCxkl', 'WB81MbCBolNg6XmE35M', null, '11e6-5e1c-806385d4-ae15-3d6b584ebd70', '2', '11e6-5e1c-806385d4-ae15-3d6b584ebd70', '155141104759000004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('cg2WtD2lq6ksYIWjbeT', '0Q0LkJpfR1ejtO8rD3p', null, 'qEKeS98EGXZh9qkxklB', '2', 'qEKeS98EGXZh9qkxklB', '155168789284500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CgA9ZMaAAf6ZG4GKyN3', '2jSs6cnzu4mzY9C13vF', null, 's4T0yhSw1lIJMsiBfQa', '2', 's4T0yhSw1lIJMsiBfQa', '155142339603100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('cGShTs6LRxKZFqp7xlK', '2ytUeoxBqghwofmBALl', null, '2F75ZJJXk8564FkCLYA', '1', 'aYBPeZTWDS1YHS4MWF5', '154461618947600000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('CH4qdE59ENnhcJ8qtVJ', 'jkpTHKg7DpuXQrppVxx', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'JyfgeJsIiLDXbY9SXJ7', '155142353112700003', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('Ch5iLdrQwoheJXs2EjK', '2ytUeoxBqghwofmBALl', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'LGI4kXh1sQ9vMEdPg6S', '154461619035100001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('cH6IpmdUA99x7wnf6ax', '3tFw1boS5L9vXoJCr6Z', null, 'D0geS9pQRj0wkmGMmBp', '2', 'D0geS9pQRj0wkmGMmBp', '154563949457000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Ch6zw4m3iDZFHYYyfrJ', '2jSs6cnzu4mzY9C13vF', null, 'dOBS9ubbO1XiVfY9ndg', '2', 'dOBS9ubbO1XiVfY9ndg', '155142339546900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ChcOkfSXRwtDbCF91yn', '3tFw1boS5L9vXoJCr6Z', null, '2F75ZJJXk8564FkCLYA', '1', 'G1Mxsr3SbNkCXsao7je', '154563949497600003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('cHFXoIG7E2go3q9qgY3', 'jkpTHKg7DpuXQrppVxx', null, 'DzqlEtg4JObApV7iWX8', '0', 'e6ZwAUd38TnujcTz0j9', '155142353078400006', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('chK3fnDYcFLq8vkvDBW', '2jSs6cnzu4mzY9C13vF', null, 'bkoXpI9ilQlOYD8wsbU', '1', 'bkoXpI9ilQlOYD8wsbU', '155142339768400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CHoybtK6mnXESHbqDpL', 'kPLbeydkgiYW6NIkCt0', null, '06Me4ssjoGBiKz0gMK2', '0', '8Hhv2rO3YipCX5JageH', '155168804663100002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('cHXSVOaWvd1xJRZ94uo', 'kPLbeydkgiYW6NIkCt0', null, 'L5GM913NGCFMkNWSZ8A', '0', 'l8GWni0miSZsKhx4FGB', '155168804580400001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('ChYPWj63WzI29uFImKM', '0Q0LkJpfR1ejtO8rD3p', null, 'LHgnhFx0bsvuS1fUhBi', '0', 'bBLadEJMfkOsH44bqZy', '155168789379700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('CI1h7D8Uwzjq4XhtNYG', '2ytUeoxBqghwofmBALl', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'XYV76K6iat8P2bzFJIm', '154461619111700001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('CI3piwadOnMjKWASQKP', 'kPLbeydkgiYW6NIkCt0', null, 'yDZaeD0mt44iNjakHmE', '0', 'mYv5iZiU0TwoK4MWL6v', '155168804588200003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ci4fq51QwAlTK4Y6t9m', '2jSs6cnzu4mzY9C13vF', null, '2F75ZJJXk8564FkCLYA', '1', 'elMcFSK0gGbaGWSt2pH', '155142339681100002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('ci57AeeOKsKaPHLTu8E', '2ytUeoxBqghwofmBALl', null, 'ezzP5oVH4ywB1HmiObF', '1', 'ezzP5oVH4ywB1HmiObF', '154461619055400003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CIjfNQwdRRmib2tOicP', 'kPLbeydkgiYW6NIkCt0', null, '5XKkpkend5hrAy8xWlc', '1', 'xHnChg1mK6MilHV4VCZ', '155168804555400004', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('cIjpiELjfwGNQu0RM1D', '0Q0LkJpfR1ejtO8rD3p', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'TkN4G3lj2mZ4XOo0kVQ', '155168789470200003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('CiMj93xWqNJRlF7iVuC', '2jSs6cnzu4mzY9C13vF', null, 'McumxQcBkg92YPli9Ox', '1', 'McumxQcBkg92YPli9Ox', '155142339791800003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('cIoV5ylV08icPcm3LDH', 'kPLbeydkgiYW6NIkCt0', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '155168804575700002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('cj0IhoEvenfCVhPQd1M', 'kPLbeydkgiYW6NIkCt0', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'SAYbUm9awyQJXoJpDNc', '155168804594400001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('cj3bilfJWFF1Wh5wqhi', '2ytUeoxBqghwofmBALl', null, 'iL3YpikkZUlruc5ai3D', '1', '2HH7snENERzvRumcFTa', '154461618938200002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('CJezbUwz5lX7cGBd9Re', 'jkpTHKg7DpuXQrppVxx', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '155142353048800002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('CJj4Ck6TNqmBNLlWYNR', 'WB81MbCBolNg6XmE35M', null, '11e6-53c8-9cbf836c-81f5-679a826556ce', '1', '11e6-563c-a604d622-91c5-cd8abd28b1f9', '155141104946200001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('cJxkqGZxStZRQ3O3GN3', '2ytUeoxBqghwofmBALl', null, 'j4ncSyWthzCYoNj3n4J', '0', 'KVWnOmmml6Kwm3w1RPe', '154461619072600004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('cK1tJ0VgukJGVd96oBG', '2ytUeoxBqghwofmBALl', null, 'Ueyt2ELhQd7E2oZ9cIi', '1', 'Ueyt2ELhQd7E2oZ9cIi', '154461618950700005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CkLqe12HcnLxtBOtI1Y', '2jSs6cnzu4mzY9C13vF', null, '2F75ZJJXk8564FkCLYA', '1', 'aYBPeZTWDS1YHS4MWF5', '155142339681100000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('CksZJ9fLao9PkPIpwQv', 'jkpTHKg7DpuXQrppVxx', null, 'T9IoQKXjHSvxRXYM3L8', '1', '3X6cQR0K41HlNd3N5Ty', '155142353044100003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('ckyjEL4bGH06PKUwj2y', 'WB81MbCBolNg6XmE35M', null, '11e6-5615-c075b470-91c5-cd8abd28b1f9', '2', '11e6-5615-c075b470-91c5-cd8abd28b1f9', '155141104751200003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ClcwP7Qis82PphnAEc5', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-16d5a517-91c5-cd8abd28b1f9', '2', '11e6-5619-16d5a517-91c5-cd8abd28b1f9', '155141104755900002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CLdbhaTIT4KxrlA5xqW', '0Q0LkJpfR1ejtO8rD3p', null, 'BXWlXtLv3yNVPzVHd1A', '2', 'BXWlXtLv3yNVPzVHd1A', '155168789331300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ClPEGVNmKIBF3ifnoq9', '2jSs6cnzu4mzY9C13vF', null, 'pr4QXSdeHJHNRiWlpyU', '2', 'pr4QXSdeHJHNRiWlpyU', '155142339551600004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CLPfAkIiDbkXQwSUo0k', '2jSs6cnzu4mzY9C13vF', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'KMy1rLdwRmKATB4fMJZ', '155142339784000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('CLSCaAPqoCAiwhkycip', 'jkpTHKg7DpuXQrppVxx', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'Mto2Exz54Tcvkyw1NCx', '155142353030000004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ClzITFOAq6zwTJjsGng', 'kPLbeydkgiYW6NIkCt0', null, 'GLnzLxRphPAJ2Z2L7fM', '2', 'GLnzLxRphPAJ2Z2L7fM', '155168804516400005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('cMQYPv0D4l486YQWpYN', 'jkpTHKg7DpuXQrppVxx', null, '8PCn6NiiMTRGZcA5dsU', '1', '8PCn6NiiMTRGZcA5dsU', '155142353095600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CMuOn8SnhDEmkR4Yixn', '3tFw1boS5L9vXoJCr6Z', null, 'IuPDe4Gm9occzflnrP0', '0', 'dSSZNfrsXOVhXvx7vOM', '154563949603800001', 'HdPeBqYwJyFyjHkhZu3', '页签打开', '43', '1');
INSERT INTO `t_permission` VALUES ('cn02aGvvrjy2DVUTXVv', '2jSs6cnzu4mzY9C13vF', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'M2lLJBuu4yQUfthKi4F', '155142339776200002', 'HdPeBqYwJyFyjHkhZu3', '保存草稿', '19', '1');
INSERT INTO `t_permission` VALUES ('Cnq3UjAToXIQJcpG2tX', '2jSs6cnzu4mzY9C13vF', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'LjTWOCClNPbDkDtAgoQ', '155142339863600001', 'HdPeBqYwJyFyjHkhZu3', '删除（字体图标红色 ）', '3', '1');
INSERT INTO `t_permission` VALUES ('CNWNTyiubUatT3EPgsV', '3tFw1boS5L9vXoJCr6Z', null, 'f9GQrsfu9GKGRqKKPgi', '1', '3wblZ30SS7TkVHaoRy2', '154563949607000003', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('cO0vuQoW6NfZtmVJfCH', '0Q0LkJpfR1ejtO8rD3p', null, 'hP9KCze8ACTb6Z4BWVV', '2', 'hP9KCze8ACTb6Z4BWVV', '155168789314200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Cp014VXJFHixC5NPzQ9', '2ytUeoxBqghwofmBALl', null, 'f9GQrsfu9GKGRqKKPgi', '1', '3wblZ30SS7TkVHaoRy2', '154461619005400000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('cpcOS8bXjFWl9hBukMg', '3tFw1boS5L9vXoJCr6Z', null, 'qX2GQGpdWwGnelcjHZP', '2', 'qX2GQGpdWwGnelcjHZP', '154563949416300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CpcWdALXii2KZZQ9c6B', '3tFw1boS5L9vXoJCr6Z', null, 'hP9KCze8ACTb6Z4BWVV', '2', 'hP9KCze8ACTb6Z4BWVV', '154563949450700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CpFn0vFM1qpoy1DyRL1', 'WB81MbCBolNg6XmE35M', null, '11e6-55fe-77cd3577-bb59-b7243d4bcf51', '0', '11e6-55fe-83ce0621-bb59-b7243d4bcf51', '155141105014800000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('CpkrDp9MCDzTLC8sPUR', 'kPLbeydkgiYW6NIkCt0', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155168804480500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CPLrFJUCRgXjYpoxPkv', 'WB81MbCBolNg6XmE35M', null, '11e6-5614-d091a7f4-91c5-cd8abd28b1f9', '2', '11e6-5614-d091a7f4-91c5-cd8abd28b1f9', '155141104751200002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CPPPjLH8xS0t5JLRpxp', 'jkpTHKg7DpuXQrppVxx', null, 'pr4QXSdeHJHNRiWlpyU', '2', 'pr4QXSdeHJHNRiWlpyU', '155142352955200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('cQIi4JIVUABzut1tNos', '3tFw1boS5L9vXoJCr6Z', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'CJu3AVSi8NfqhFlu5jl', '154563949511600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('cqQNBBfoBKWQFyZgexX', '2ytUeoxBqghwofmBALl', null, 'vDsnTykdPOblfwEF4mR', '1', 'jVcLQaH4BiwznPvstCF', '154461619024200001', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('Crbb4be52tMijCZXUcu', '0Q0LkJpfR1ejtO8rD3p', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'fW5mHIOMi7iJ4kftiPg', '155168789396900001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('cRmQChYmGkKm3AVrN5W', 'WB81MbCBolNg6XmE35M', null, '11e6-5e0c-bf1399e7-ae15-3d6b584ebd70', '0', '11e6-5e0d-3fe75643-ae15-3d6b584ebd70', '155141105000800000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('cSH4GTiOabFz6BNsXHG', 'jkpTHKg7DpuXQrppVxx', null, 'tXSz1JBmnuwUf1VB2vL', '2', 'tXSz1JBmnuwUf1VB2vL', '155142352963000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('cslzV93BE463RFWBRCk', '0Q0LkJpfR1ejtO8rD3p', null, 'NyOvQfCmNxbiRG9N00v', '2', 'NyOvQfCmNxbiRG9N00v', '155168789315700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CsQwvcdXtYoHLBaErIE', '3tFw1boS5L9vXoJCr6Z', null, '6r0MsymflCeuD0Rrz4G', '2', '6r0MsymflCeuD0Rrz4G', '154563949417900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CSX7PIeizETg3RFWVDY', '2jSs6cnzu4mzY9C13vF', null, '9IbX83RDH7O16tUh901', '2', '9IbX83RDH7O16tUh901', '155142339610900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('cSzCe1AjST7Q14bafhE', '2ytUeoxBqghwofmBALl', null, '4VkP5W8VPlERMiThvSD', '0', 'x4yYcPQJrgbYvpcebr5', '154461619042900002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('cT4n5zQbKAj73g7P1CX', '2jSs6cnzu4mzY9C13vF', null, 'wsNAf0ykJEwUgvGWWKN', '2', 'wsNAf0ykJEwUgvGWWKN', '155142339610900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('cTRuywnlwhkppkj4saW', 'kPLbeydkgiYW6NIkCt0', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'APxRfhpMtHJp5vsjIIa', '155168804581900000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('cuiqukYSKR9lzn8oae6', 'WB81MbCBolNg6XmE35M', null, '11e6-5bb1-f718b840-a270-539aa660c6fc', '2', '11e6-5bb1-f718b840-a270-539aa660c6fc', '155141104779300002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('cuPW6fDoZWtv0nhWZUG', '2ytUeoxBqghwofmBALl', null, 'u9zN1C73prPrzriTtzg', '1', 'u9zN1C73prPrzriTtzg', '154461619130400002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CUrSFO5ZItHGHqO5S6r', '2ytUeoxBqghwofmBALl', null, 'UdbmUInPiuJzqP4yBTS', '1', 'UdbmUInPiuJzqP4yBTS', '154461619121000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CV5XMEnjuqmb1dvkgrJ', 'jkpTHKg7DpuXQrppVxx', null, 'OAOscbfZQwOIteqeYSP', '1', 'OAOscbfZQwOIteqeYSP', '155142353095600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CvCdHvTYuqImN4J3yYx', 'jkpTHKg7DpuXQrppVxx', null, 'eLFjqFngRQrIkbsdeBd', '1', 'SX3rVQxkpU96Pko5JDm', '155142353147000000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('CVhqFFyZsTaZ2cS3dlQ', '2jSs6cnzu4mzY9C13vF', null, 'lAUkIpgQSIZqQyttrB4', '1', 'g6HusIB9Lr81fIHCCp5', '155142339718500000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('cVJOuzOLcCXsh9wCLO9', '0Q0LkJpfR1ejtO8rD3p', null, 'gniImP2ug7E82S1WO0L', '1', 'gniImP2ug7E82S1WO0L', '155168789446800003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('CvquwFKB3JFiZ1dz1AN', '2jSs6cnzu4mzY9C13vF', null, '7u0fRbpHrxopCyfgADs', '1', 'QdJEZOBLT4lXyJm0dJq', '155142339706000002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('cVsCyEDRTEypk2EqHFE', 'kPLbeydkgiYW6NIkCt0', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'eTnoMZs9GI6BwMJq1Cn', '155168804577300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('CVWO2OzpmhjyLo1SjMk', 'WB81MbCBolNg6XmE35M', null, '11e6-53a7-e48bf523-81f5-679a826556ce', '1', '11e6-53a7-e48bf523-81f5-679a826556ce', '155141105186400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('cw14qLFtiOy64Afds0P', '2jSs6cnzu4mzY9C13vF', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'Wy8unQKVYBEnHvEqVyA', '155142339651400000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('CWiM2L1ztg0oPiW5pvh', 'jkpTHKg7DpuXQrppVxx', null, 'EGmIBh1ogGUoD8df1rE', '1', 'EGmIBh1ogGUoD8df1rE', '155142353158000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('cwjGmYlCMTGITw7xz6T', 'kPLbeydkgiYW6NIkCt0', null, 'LsrnkDvx5pdkA6JnHuj', '2', 'LsrnkDvx5pdkA6JnHuj', '155168804472700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('CwOTalVm5n1hxnQs8hs', 'kPLbeydkgiYW6NIkCt0', null, 'zl3R26vYd12dQFRodMT', '2', 'zl3R26vYd12dQFRodMT', '155168804483700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('cwt93nOyh3gjF2hLm2m', '2jSs6cnzu4mzY9C13vF', null, 'wwsNkkwFEvqL44gK2fM', '0', 'ITAEcCLmB4JM7hMwJQC', '155142339741900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('cXBK4AzGcll72Aow0zS', 'kPLbeydkgiYW6NIkCt0', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'mJFtUs7KSNrMTt3W70z', '155168804666200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('CXgccbpDKu5GZgAa9te', '2ytUeoxBqghwofmBALl', null, 'IuPDe4Gm9occzflnrP0', '0', 'LFydu54akpsq9Y9sCQr', '154461618974200005', 'HdPeBqYwJyFyjHkhZu3', '载入其他视图', '1', '1');
INSERT INTO `t_permission` VALUES ('cxj1Zcjh8wjHxPM3zKh', 'jkpTHKg7DpuXQrppVxx', null, 'LSwQOY0mggQ0vy4752p', '0', 'GrfqbEO7sjk3s3xGl3W', '155142353168900001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('CxOvpL5RDG8zDWDaE4Q', '3tFw1boS5L9vXoJCr6Z', null, 'UmMnr5J8RhgknR3Dsos', '0', 'RZ790ojkvhzumC5tyL2', '154563949535100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('CXvwkDpEKSSxgj8OqPJ', '3tFw1boS5L9vXoJCr6Z', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'Y0AtqRPANYqitR5XI0Q', '154563949505400000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('cY4SHNllFZwijjps1g7', '2ytUeoxBqghwofmBALl', null, 'lOgu0Jvq0z5dlveyrnY', '0', '5XIqbMcQ6K0lFtVi4HZ', '154461618899200000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('cydcYml2FDOoZunaSlD', 'jkpTHKg7DpuXQrppVxx', null, '9ppSV2PIKNhHCOwufvI', '0', '1vKJVgUjJInvLMSVXIn', '155142353123600003', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '36', '1');
INSERT INTO `t_permission` VALUES ('cZfeLRfSF3AX1zKk5re', '2jSs6cnzu4mzY9C13vF', null, '4oavihvP4J8cXDsWDIP', '0', 'pwDWlADlB4vGrKVGIQc', '155142339829300000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('CZH2BYzvqwjbQ8DfoqZ', 'WB81MbCBolNg6XmE35M', null, '11e6-54b3-01603448-9671-379f935a9949', '1', '11e6-54b5-eb87865b-9671-379f935a9949', '155141104904100002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('d0bKfbGrbrjn3QblAJK', 'jkpTHKg7DpuXQrppVxx', null, 'nv2ul1HAiYcvTtoT6Lr', '1', 'nv2ul1HAiYcvTtoT6Lr', '155142353101800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('D0ROkiUlq2E2lxJTZSj', '2jSs6cnzu4mzY9C13vF', null, 'yDZaeD0mt44iNjakHmE', '0', 'gOx8PapU5TCGaG1IcWs', '155142339766900003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('D1wOvxf3nEzlKUKoYOp', '2ytUeoxBqghwofmBALl', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'fW5mHIOMi7iJ4kftiPg', '154461619014800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('D2rbGbKLtDFiZQSKoQj', '2jSs6cnzu4mzY9C13vF', null, 'LHgnhFx0bsvuS1fUhBi', '0', 'bBLadEJMfkOsH44bqZy', '155142339738800002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('d2rCd8rzxoaQgAztr00', '3tFw1boS5L9vXoJCr6Z', null, 'NGN4SO4fu5S5XxULG4X', '1', '3obNdvpJGlYwLE4U916', '154563949485100001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('d3AkbkDbsMTXul1QKqr', '3tFw1boS5L9vXoJCr6Z', null, 'BrbFcB3ptMyxdPl5W6u', '0', '1JVZYNRouHUK7MH0xzc', '154563949588200004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('d3JiN44wPCnFjouqwed', '2ytUeoxBqghwofmBALl', null, 'QKYvQ00K4tWyyjKycUC', '0', 'ARs78PxB8dp6mXxPrKL', '154461618933500002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('d3WjLrKiHJaktFuEaBw', 'WB81MbCBolNg6XmE35M', null, '11de-c3cf-2a95f2b4-9ee5-25eb8f482137', '0', '11de-c3cf-608be1ff-9ee5-25eb8f482137', '155141104874400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('d4FZo2JyFS0Hos0RoQy', 'jkpTHKg7DpuXQrppVxx', null, 'jyd4rbIxoL6EKjtSVWC', '1', 'jyd4rbIxoL6EKjtSVWC', '155142353098700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('D4IED9PoBXGmsHy7g9f', 'kPLbeydkgiYW6NIkCt0', null, 'OAOscbfZQwOIteqeYSP', '1', 'OAOscbfZQwOIteqeYSP', '155168804600700006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('D4L1AZQlZyPovJMs907', '0Q0LkJpfR1ejtO8rD3p', null, 'nv2ul1HAiYcvTtoT6Lr', '1', 'ArAARDqxACIn5mJd2RB', '155168789437400000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('D4N305QBCbpphgi2IkT', '0Q0LkJpfR1ejtO8rD3p', null, 'wjPLVvwWYR2a9BOi0st', '0', 'cV9hNfWQ2CjjMiWBnt2', '155168789440500001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('D4OVK2nEbU7uCKOhmWC', '3tFw1boS5L9vXoJCr6Z', null, 'F6reQ5BW7P6q236Pi13', '1', 'l8ljKs0dTA8uw1QTIcr', '154563949610100000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('d5KdltUqTx8t3IMUpkE', 'WB81MbCBolNg6XmE35M', null, '11e6-5616-3b33fa3c-91c5-cd8abd28b1f9', '2', '11e6-5616-3b33fa3c-91c5-cd8abd28b1f9', '155141104766800000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('d6qDr8F94bzcQsNHFeW', '2jSs6cnzu4mzY9C13vF', null, 'GLnzLxRphPAJ2Z2L7fM', '2', 'GLnzLxRphPAJ2Z2L7fM', '155142339615600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('d6Y6uA22gzXhdNMBQNL', 'jkpTHKg7DpuXQrppVxx', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'f1qYzMAqsF7bNYJc4Xl', '155142353023800001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('D8jx3l1ffKsJsLuzNBP', '2ytUeoxBqghwofmBALl', null, 'SiPTeSpUhRIqVgi1HW1', '0', 'LI7k2GDTP5VDdaobmtO', '154461619046000002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('d8Wn1QpXDkRy7iwi0Ly', '2ytUeoxBqghwofmBALl', null, 'BrbFcB3ptMyxdPl5W6u', '0', '6DhnKNo54979AgvQSGH', '154461618938200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('D9BlIFXhcTyUeJR7vcC', 'jkpTHKg7DpuXQrppVxx', null, '4oavihvP4J8cXDsWDIP', '0', 'pwDWlADlB4vGrKVGIQc', '155142353109600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('D9KJZAN2EEtExZg7qIV', 'kPLbeydkgiYW6NIkCt0', null, '6bUPlXeVH92MIv7Nmdw', '1', 'ZNYYg5DdRtEMBaS3QLl', '155168804549200004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('D9PteLdFqpstK5giRuH', '2ytUeoxBqghwofmBALl', null, 'WjB49SEA8rvzL9rkC7N', '1', 'WjB49SEA8rvzL9rkC7N', '154461619053800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('D9XKU5ubrrvNI0OVkZd', 'jkpTHKg7DpuXQrppVxx', null, 'XzgpTEte9Q1JQswSETz', '0', 'oTrq3HVrCNx1jALWUgh', '155142353162600000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Da0HTz1UcSgyuoyPid7', '0Q0LkJpfR1ejtO8rD3p', null, 'm8moRuOLRGU8fSbCIty', '0', 'Z6h9QsC5gMpu1hmPip2', '155168789340700004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dAIGIRQWoTwlBJX4ztl', 'kPLbeydkgiYW6NIkCt0', null, 'dcaZRzor22qTnafQjNv', '2', 'dcaZRzor22qTnafQjNv', '155168804524200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dAJVjYzNRjclN2myC49', '2ytUeoxBqghwofmBALl', null, 'gniImP2ug7E82S1WO0L', '1', 'gniImP2ug7E82S1WO0L', '154461619067900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('darlc9R7muYt8cV9tpv', 'jkpTHKg7DpuXQrppVxx', null, 'poalxIjVlN70WdVjfQq', '1', 'poalxIjVlN70WdVjfQq', '155142353165800001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('dAuVjKLuRTWjoDZwazz', 'jkpTHKg7DpuXQrppVxx', null, 'DH7Zen0eWUXbjpOEAKb', '2', 'DH7Zen0eWUXbjpOEAKb', '155142352967600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('DbiixqsRHkXLjIlyCd8', '3tFw1boS5L9vXoJCr6Z', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'fu3FPAvy3QbJl8Y96P7', '154563949550700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('DbsmawWq9Ofzz056sB5', 'kPLbeydkgiYW6NIkCt0', null, 'hdMXKLI1XqTUYUrFniv', '0', '3EhqWBGmEEkub8qvOuy', '155168804628700002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('DC98KMjmfGnaeuO2ufP', 'jkpTHKg7DpuXQrppVxx', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'fW5mHIOMi7iJ4kftiPg', '155142353073700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dcSuTt1WTyPsYEWQht8', 'jkpTHKg7DpuXQrppVxx', null, 'TqQZlnV3BVaRGCm4tXn', '1', '7Cu3i9C1gOoAeAS2dAn', '155142353019100004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('dCWCPAIaJKWF9TVWtPX', '2jSs6cnzu4mzY9C13vF', null, 'XzgpTEte9Q1JQswSETz', '0', 'oTrq3HVrCNx1jALWUgh', '155142339897900003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dD3ku0UprNAr3GlFf3U', 'jkpTHKg7DpuXQrppVxx', null, 'SAzJx5AkUZOJRct29BH', '0', 'wLzLCUPc9LuRRv9j8J3', '155142353108000004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dd5qyIcKOcDhSWqKydw', 'WB81MbCBolNg6XmE35M', null, '11e6-5491-50c5cc93-9671-379f935a9949', '1', '11e6-5493-5a4fbe9b-9671-379f935a9949', '155141105088100003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('DDfoKN3cfDQKxpvb3dA', 'kPLbeydkgiYW6NIkCt0', null, 'd1anhG9lkXM7xOEL0p0', '1', 'd1anhG9lkXM7xOEL0p0', '155168804563200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('DdgVXrQ6jSrvI7aO89U', 'jkpTHKg7DpuXQrppVxx', null, 'ir2OPEdZvttSUxAzfmD', '1', 'C6hePhUj7uuuUyJJSuq', '155142353019100000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('de6cKWm0UXEOONpPDLN', '2ytUeoxBqghwofmBALl', null, '2F75ZJJXk8564FkCLYA', '1', 'elMcFSK0gGbaGWSt2pH', '154461618947600002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('dE8QUMJKhEyIcANx4FH', '0Q0LkJpfR1ejtO8rD3p', null, 'a7jp1Dm53YjlAwDWuws', '1', 'wL7xiiufleig43GVrAC', '155168789406200003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('dEEFoDOwISGwasOBCN3', '3tFw1boS5L9vXoJCr6Z', null, '4VkP5W8VPlERMiThvSD', '0', 'SOe9OaDTLOE1domxYKV', '154563949555400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('DeKsceTw7k0aHCVwdzN', '0Q0LkJpfR1ejtO8rD3p', null, 'eKZqOwJmAFsUEwu0WfL', '1', '3jy9fTiYM0hwEHejpTu', '155168789368800003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('denAQ4nTMKfj9nT2IXy', '2jSs6cnzu4mzY9C13vF', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'XYV76K6iat8P2bzFJIm', '155142339868300003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dF2EPPIKglUphgHONlS', '3tFw1boS5L9vXoJCr6Z', null, 'gUlSUpqhlS2ym2ijZAg', '1', '6vfobfgmvGLQuOe0b3s', '154563949496000000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('DFfZM9aT7UT4Pb5Hnn1', 'jkpTHKg7DpuXQrppVxx', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'bOLR3Xo33mj06rfix3J', '155142353106500001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('dFIbubRN4R9NHFKRYF4', '2ytUeoxBqghwofmBALl', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'wuWQttnDBKAz7kQ2UMs', '154461619096000003', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('dFr1sfsK5z5jqE5YGec', '2jSs6cnzu4mzY9C13vF', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'A293BH1uO82kIt5k5f9', '155142339784000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dFZrRL7IP7Xh4PdBxJX', '0Q0LkJpfR1ejtO8rD3p', null, 'CUiq0kurilZ2dSBIXUv', '0', 'XxEDLxeqpXRncPsDJDo', '155168789392200004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dG7coiMiVCPrbD8SSKU', 'kPLbeydkgiYW6NIkCt0', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'mHhOCWGxOkvrAOWpqLl', '155168804546100004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('DGOyd1cEgsOuVB0NjOm', 'jkpTHKg7DpuXQrppVxx', null, '7u0fRbpHrxopCyfgADs', '1', '7u0fRbpHrxopCyfgADs', '155142353034700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('DgUIbKFQI4L3paXbmUS', 'WB81MbCBolNg6XmE35M', null, '11e6-5476-94a8e7ab-9671-379f935a9949', '1', '11e6-548a-7f2b9025-9671-379f935a9949', '155141105071000003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('DHeYHbwnUxjbWZOTs7P', '2ytUeoxBqghwofmBALl', null, '3sSURwczE2wMjgOqqOo', '0', 'rNGiDIRMmVUcl95QN9f', '154461619024200005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dHNeC9Cc8ZRpXUUY1JT', 'kPLbeydkgiYW6NIkCt0', null, 'xBX9EbJkveiSGJm9xRj', '0', 'Ly9Spk5ma18fAyhAWh3', '155168804577300002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dhSURJ6wIbEmbKW1nMB', 'jkpTHKg7DpuXQrppVxx', null, 'iDzESIHQQFeI8FiDtGE', '2', 'iDzESIHQQFeI8FiDtGE', '155142352953600004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('DHvfp3E7IliaXPAzVvb', '2jSs6cnzu4mzY9C13vF', null, 'd1anhG9lkXM7xOEL0p0', '1', 'd1anhG9lkXM7xOEL0p0', '155142339721600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('diHqa8DhqW1nZJV9ctl', '3tFw1boS5L9vXoJCr6Z', null, 'NGN4SO4fu5S5XxULG4X', '1', 'OH7Z3LEcqPhif8kJKhi', '154563949485100002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('dJ9C4AUSB5rrpbRPouh', 'kPLbeydkgiYW6NIkCt0', null, 'AkuEixxtkMd7QuHLVOR', '2', 'AkuEixxtkMd7QuHLVOR', '155168804472700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dJGfFfOy1cgmnuj17Mk', '2ytUeoxBqghwofmBALl', null, 'hdMXKLI1XqTUYUrFniv', '0', 'aa25jXytFYZYB62Ac2z', '154461619096000002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dJO4rFJyzQXX3w0wvTu', 'jkpTHKg7DpuXQrppVxx', null, 'WOmzvkui5ZsoZu1CogR', '1', 'WOmzvkui5ZsoZu1CogR', '155142353086200005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Djw5xnILsb1mRCwWRGQ', '2jSs6cnzu4mzY9C13vF', null, 'RGSlfhmaWRtgtaWUhTU', '2', 'RGSlfhmaWRtgtaWUhTU', '155142339564100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('djypADnn3JBfNeBK1or', '3tFw1boS5L9vXoJCr6Z', null, 'iS0C05zNyVJaInb9Lvo', '2', 'iS0C05zNyVJaInb9Lvo', '154563949450700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('DKaIBindGLp74tHkdGM', '0Q0LkJpfR1ejtO8rD3p', null, 'rumve1swtYufxpvxfcC', '2', 'rumve1swtYufxpvxfcC', '155168789323500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dkAYJBk7ZIh6IzjEVnO', '3tFw1boS5L9vXoJCr6Z', null, 'm8moRuOLRGU8fSbCIty', '0', '6ieKi8bk8zbO9XkicpP', '154563949483600003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dkbeOCymOp0JfIbUjih', '3tFw1boS5L9vXoJCr6Z', null, 'a7jp1Dm53YjlAwDWuws', '1', 'wL7xiiufleig43GVrAC', '154563949541300005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('DkbexWmSvMN42LgxfYx', 'kPLbeydkgiYW6NIkCt0', null, 'QKYvQ00K4tWyyjKycUC', '0', 'ARs78PxB8dp6mXxPrKL', '155168804625600002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dKlidoXjC5DFMbTYX4y', 'kPLbeydkgiYW6NIkCt0', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'P1pXLZ0kw9I6axwJEcd', '155168804547600004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('dkQWIsqVo3k2FLTCwSq', '2jSs6cnzu4mzY9C13vF', null, 'QB2YTfQBMnrttSiZNeP', '2', 'QB2YTfQBMnrttSiZNeP', '155142339581200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dKy5BkUUuZWiLwbomp1', '2jSs6cnzu4mzY9C13vF', null, 'viwgtc32VtB7wJo2O8S', '0', 'u09JpvzXkvJXfyRFCj6', '155142339743500001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dL0qseLFPeSJEPXPwCF', '3tFw1boS5L9vXoJCr6Z', null, 'MtITrUcx3REq45LskT3', '0', '1GnA7ouj5X9SbchE8C5', '154563949621000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dLzMcxFv3ifJb7PWnEx', '2ytUeoxBqghwofmBALl', null, '5RZRK7Jt5vyqwlIccop', '1', 'n7ODSabeRv0h2pyGxhm', '154461618966300005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('dm4EiDPA1MerkQbUZdA', '2ytUeoxBqghwofmBALl', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'v5qY31shPwgs5BLkLlM', '154461619000700004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dm7Fc06mP4Rdp57MbQo', '3tFw1boS5L9vXoJCr6Z', null, 'nTlBd4a4Vt8mtiTX41J', '0', 'E3J8OfymoQtKHIuFNMK', '154563949588200005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dn5dPNa1TxnWdDMVVSW', '2ytUeoxBqghwofmBALl', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'XG8ap7ffszErnf3ZYYp', '154461618857000000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('dn8OXz4yQZYzH4USEN9', 'jkpTHKg7DpuXQrppVxx', null, 'A6EMGp4mkUqLbMGLtql', '0', 'z1cc7dNuc4Vg60yjjLM', '155142353103400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dNbNJvLEs6vqwHYPM2m', '2ytUeoxBqghwofmBALl', null, 'c8qqHIRjZCxEMPx5YoO', '1', 'c8qqHIRjZCxEMPx5YoO', '154461618750700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('DNc4zqSPVvwz0Pqcz0p', 'jkpTHKg7DpuXQrppVxx', null, 'jhINwVUWllGph0gnSC6', '0', 'CbRpWeZs7qQG3vfc9YZ', '155142353070600004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dneNUJuDeOaHyHt9HKj', '2ytUeoxBqghwofmBALl', null, 'ddbeKTjs0WvqKVJ90MU', '1', 'ddbeKTjs0WvqKVJ90MU', '154461618949200006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('dNf0ryQxEx4sgIsisE8', 'WB81MbCBolNg6XmE35M', null, '11e6-5ead-d2a76e4c-b0f0-d3a532217234', '2', '11e6-5ead-d2a76e4c-b0f0-d3a532217234', '155141104768300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dnnc6DSUGLMLiljIEFw', '2jSs6cnzu4mzY9C13vF', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'eTnoMZs9GI6BwMJq1Cn', '155142339751300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dnsC3mKgKGbRNS9FvTm', 'WB81MbCBolNg6XmE35M', null, '11e6-53c7-e8d1f5b4-81f5-679a826556ce', '0', 'JsaXlUylz09K52xnC37', '155141104941500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Do87HaEM6ewh3yHxLhZ', '2ytUeoxBqghwofmBALl', null, 'Z6pISvulUdsSz8bjuOV', '0', '81O85fI7nEQvujIwWvl', '154461619011700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('DoAWDxrx75f2F9WsFWW', '2ytUeoxBqghwofmBALl', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '154461619005400005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('DOJinnyQIAdOR2jlgvV', 'jkpTHKg7DpuXQrppVxx', null, 'Tm9KRBnKnzjuuld7bJh', '0', '5GCo50RaCJdscjJW16V', '155142353073700003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('DoLnJlJ9nJTtWE1fVHO', 'jkpTHKg7DpuXQrppVxx', null, 'viwgtc32VtB7wJo2O8S', '0', 'Wlje8Nr2ww7qrmEwdBf', '155142353058100001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dqEI0mBqfNGznUil4EP', '0Q0LkJpfR1ejtO8rD3p', null, 'bkoXpI9ilQlOYD8wsbU', '1', 'eEsrQhBVYzA97RMPPGX', '155168789404700003', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('dqoYJPUw4QLmpJnZPiw', 'WB81MbCBolNg6XmE35M', null, '11e6-5e12-a2b175c4-ae15-3d6b584ebd70', '2', '11e6-5e12-a2b175c4-ae15-3d6b584ebd70', '155141104757400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('DqysIg8VgZ6sRTFSRkQ', 'jkpTHKg7DpuXQrppVxx', null, 'GhbQPNIblLICNGTEwqX', '0', '2YA8KZ2P1yC1f0g2Nzs', '155142353073700005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('DrpZcRdpROaw2dqxOzx', '3tFw1boS5L9vXoJCr6Z', null, '8DmOHAVRvs3BblbhJoa', '1', 'b2wnjqSK0hVEGNix31k', '154563949488200004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('drzLoTpHhmbyIJuIg9A', 'jkpTHKg7DpuXQrppVxx', null, 'ZB7liHeZS7Qm0mlMz6b', '2', 'ZB7liHeZS7Qm0mlMz6b', '155142352987900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Ds4c0rERnKfWtiL2lkm', 'jkpTHKg7DpuXQrppVxx', null, 'qAcxhZ5mnoiohEBYD9G', '2', 'qAcxhZ5mnoiohEBYD9G', '155142352959800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dSzDg1VzXAyv9YrW1k1', '3tFw1boS5L9vXoJCr6Z', null, '3K4lxgBhBLAbzJrfYaB', '1', '3K4lxgBhBLAbzJrfYaB', '154563949632000003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('DTC7f2EvBjcarkMeThN', '2ytUeoxBqghwofmBALl', null, 'EaVrfjS89IZqE63BWPa', '0', '9YwViaujJTr161CesBX', '154461618946000003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Dtd37bPXYvPulYrMEER', '0Q0LkJpfR1ejtO8rD3p', null, 'Qi632udYFiwUydksuYy', '2', 'Qi632udYFiwUydksuYy', '155168789334500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dtGfz0GwVBieeJsVOnj', 'jkpTHKg7DpuXQrppVxx', null, 'qU8WM5a2IVVudiqn38E', '1', 'qU8WM5a2IVVudiqn38E', '155142353101800001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('dTi5O8R4zw0mGdU0PHp', 'kPLbeydkgiYW6NIkCt0', null, 'NGN4SO4fu5S5XxULG4X', '1', 'NGN4SO4fu5S5XxULG4X', '155168804535100001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('DtiMvmFjUlwtDmqBW6D', '2jSs6cnzu4mzY9C13vF', null, '2bmCU7aUTZfM8CZmJEP', '2', '2bmCU7aUTZfM8CZmJEP', '155142339590600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dtSylgeavTuqN9IrmYc', 'jkpTHKg7DpuXQrppVxx', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'IajyYUcsSuyg4dFRXdR', '155142353122100001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('du6T7VdXHKtnuNgQ5wD', 'jkpTHKg7DpuXQrppVxx', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'KDRVonlpSB5oYD1O1LY', '155142353137700001', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('DUOZd9rEb9DAWuqD0tv', 'kPLbeydkgiYW6NIkCt0', null, 'Kb6r6jvJBO7WdcyIqFH', '2', 'Kb6r6jvJBO7WdcyIqFH', '155168804482100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Dv8jJHP7mx79KBVqw4A', 'jkpTHKg7DpuXQrppVxx', null, 'F6reQ5BW7P6q236Pi13', '1', 'l8ljKs0dTA8uw1QTIcr', '155142353140800001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('DVQtf4KTbaSXFt3fCmP', 'kPLbeydkgiYW6NIkCt0', null, 'e6OXY8vDBhwyntKTBcc', '1', 'e6OXY8vDBhwyntKTBcc', '155168804670900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('dvtaY4Ca9HUmhLmdxu2', '2ytUeoxBqghwofmBALl', null, 'QKYvQ00K4tWyyjKycUC', '0', 'vDCiwAlHhexzsJITERJ', '154461618933500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('DvTNbprknZd8K6CEBHi', '0Q0LkJpfR1ejtO8rD3p', null, 'oUGfBAkdjTsO2z22gYU', '2', 'oUGfBAkdjTsO2z22gYU', '155168789297000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('DvwsEhx7NLKPzfmYa5N', '2jSs6cnzu4mzY9C13vF', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'VMAbFQIQDDpyST1AhyZ', '155142339887000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dwa5dXY0Qn3YETMDQuM', 'kPLbeydkgiYW6NIkCt0', null, '4VkP5W8VPlERMiThvSD', '0', 'x4yYcPQJrgbYvpcebr5', '155168804597500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dwBaofnG4oBYV7xiTgA', '3tFw1boS5L9vXoJCr6Z', null, 'GhbQPNIblLICNGTEwqX', '0', 'CnYPYgX7tOKqpWia5h3', '154563949528800003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('dwi7G6QsofWjn1Fvigw', 'kPLbeydkgiYW6NIkCt0', null, 'w7IsSOtXFvo61cP8sKr', '1', 'w7IsSOtXFvo61cP8sKr', '155168804592900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('DWod89s8PTbM4Ehgpma', 'WB81MbCBolNg6XmE35M', null, '11e6-561a-8ffc8bfe-91c5-cd8abd28b1f9', '2', '11e6-561a-8ffc8bfe-91c5-cd8abd28b1f9', '155141104765200001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dWrQDAl8vrxrJuMmb4j', 'kPLbeydkgiYW6NIkCt0', null, 'PEBmSuAdvPujm2dfjAb', '2', 'PEBmSuAdvPujm2dfjAb', '155168804466500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('DWUC1odPOH8aUjswEi0', '0Q0LkJpfR1ejtO8rD3p', null, 'EGz4qs5QI4fsCuCJwdc', '2', 'EGz4qs5QI4fsCuCJwdc', '155168789332900004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dWy0rfylAKJynVTfKA7', '0Q0LkJpfR1ejtO8rD3p', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155168789303300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('DxDIZkWZTQJTunIq4Sf', 'kPLbeydkgiYW6NIkCt0', null, 'XtaVH2y40O9zvIVALWj', '1', 'cJircppYbKZxUtuClYU', '155168804532000000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('DylLJ3PHuXA0j0ix7Kf', '2jSs6cnzu4mzY9C13vF', null, '0n6dTFPWytWUOlO2aeq', '2', '0n6dTFPWytWUOlO2aeq', '155142339596800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('DYwNappZTVKsLAV5g87', '2jSs6cnzu4mzY9C13vF', null, 'qFSn8P14pNLldr9j5QS', '2', 'qFSn8P14pNLldr9j5QS', '155142339584400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dZaYw1Z5CtNyuWYlZhv', '3tFw1boS5L9vXoJCr6Z', null, 'RwAgQB30vyuzPHYBb3F', '2', 'RwAgQB30vyuzPHYBb3F', '154563949421000004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('dZlJtjcjptOtw8lRqRQ', 'kPLbeydkgiYW6NIkCt0', null, 'Ueyt2ELhQd7E2oZ9cIi', '1', 'Ueyt2ELhQd7E2oZ9cIi', '155168804557000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Dzns1ELoNXReWXGIJsC', 'jkpTHKg7DpuXQrppVxx', null, 'NLGiWBICUXkTNWcaaD0', '1', 'NLGiWBICUXkTNWcaaD0', '155142353100200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('dZWZDvzpilhM8jMntfm', '0Q0LkJpfR1ejtO8rD3p', null, 'OGMmff1QTZYqFk5vfeD', '1', 'KTmmfPfwuB4gGJuw9fD', '155168789340700003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('e07Gyc4qvBan878sBRu', 'kPLbeydkgiYW6NIkCt0', null, 'XpNoNSLR8vialNcJDXq', '0', 'WadmhwRuII4JmFt4TYS', '155168804610000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('e09YBisjBzSY4SqpsIW', 'jkpTHKg7DpuXQrppVxx', null, 'WrG5tW3KzqYHU2QYywI', '2', 'WrG5tW3KzqYHU2QYywI', '155142352983200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('e0pC1scPrGpE2cDD2Wz', 'kPLbeydkgiYW6NIkCt0', null, 'McumxQcBkg92YPli9Ox', '1', 'McumxQcBkg92YPli9Ox', '155168804603800001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('e0VNSBVmqRcNRhSXdIS', '3tFw1boS5L9vXoJCr6Z', null, '1YQdDj3kDCsdgpgrTSf', '2', '1YQdDj3kDCsdgpgrTSf', '154563949424100004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('e28cDBTeAjbjWkvMSiP', 'kPLbeydkgiYW6NIkCt0', null, 'JmxxVKFmtiAV278992Z', '2', 'JmxxVKFmtiAV278992Z', '155168804505500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('e2KrmWgxKMkZoRwsyeT', 'jkpTHKg7DpuXQrppVxx', null, '0zSRHMqiyMTl1dth7ds', '1', 'EbrSUqhaaWu3vkwQzkZ', '155142353028500001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('E2nsSjqi2FqLs3SHga7', '3tFw1boS5L9vXoJCr6Z', null, 'Li1q0Dlwg6sZn4YFamQ', '2', 'Li1q0Dlwg6sZn4YFamQ', '154563949444500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('e37LVj0pQACPVbvClu2', '2jSs6cnzu4mzY9C13vF', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'vVMfrqzsYfwhMJonU2y', '155142339674800003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('E392wh25EEPJ98jDNck', '2ytUeoxBqghwofmBALl', null, 'JdWD8biOlCXjkEvrwMm', '0', 'OLJQOfZpoAIKsZOpeqD', '154461619110100004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('E3rgejFlHUyWodnzPgp', 'jkpTHKg7DpuXQrppVxx', null, 'zl3R26vYd12dQFRodMT', '2', 'zl3R26vYd12dQFRodMT', '155142352966100005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('e4LupsfckLrZ16O4hz7', '3tFw1boS5L9vXoJCr6Z', null, 'AKGX6zv2MUckrIYhVdz', '2', 'AKGX6zv2MUckrIYhVdz', '154563949444500004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('e4oRFrtlKtnGb7jjO2k', '0Q0LkJpfR1ejtO8rD3p', null, 'e6OXY8vDBhwyntKTBcc', '1', 'e6OXY8vDBhwyntKTBcc', '155168789484200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('e65ZsbPvd0N2LGMzAi0', 'jkpTHKg7DpuXQrppVxx', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'E47mVx0cWjUwctEiuIt', '155142353069000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('E67QJLvsac8xq7yoy5H', 'kPLbeydkgiYW6NIkCt0', null, 'TqQZlnV3BVaRGCm4tXn', '1', 'TqQZlnV3BVaRGCm4tXn', '155168804542900002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('E6ZgMUC3ohGr55YjL5Z', '2jSs6cnzu4mzY9C13vF', null, '8BSYIj5kZKJjAD7IxkX', '2', '8BSYIj5kZKJjAD7IxkX', '155142339579700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('E7Qn7BSNSPxrikdqLLC', 'jkpTHKg7DpuXQrppVxx', null, 'CUiq0kurilZ2dSBIXUv', '0', 'Ksb2IhhfWaj5cJWTMwr', '155142353070600002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('E7Scg7uUQmxXC04pECH', '3tFw1boS5L9vXoJCr6Z', null, 'ypFGviMvQl4iVE8dOS0', '2', 'ypFGviMvQl4iVE8dOS0', '154563949424100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('E7zltj6sRGfxy5noVnI', '2ytUeoxBqghwofmBALl', null, '4mlBSmLGlzULUWJe8Nu', '1', '4mlBSmLGlzULUWJe8Nu', '154461619032000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('E86qPEzKdFUCOOKAOwH', 'jkpTHKg7DpuXQrppVxx', null, '5XKkpkend5hrAy8xWlc', '1', 'xHnChg1mK6MilHV4VCZ', '155142353031600004', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('e9uPjsyVOF6AuJPkzZE', 'jkpTHKg7DpuXQrppVxx', null, 'viwgtc32VtB7wJo2O8S', '0', 'u09JpvzXkvJXfyRFCj6', '155142353058100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('eA7T4ak5YjdvoAj7l7O', 'WB81MbCBolNg6XmE35M', null, '11e6-54b3-01603448-9671-379f935a9949', '1', '11e6-54b5-b85bb3a9-9671-379f935a9949', '155141104904100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('eAEGWhr0lHF3LM9KKn5', 'kPLbeydkgiYW6NIkCt0', null, 'bn8WKWSmkeCbTynZV4J', '2', 'bn8WKWSmkeCbTynZV4J', '155168804493000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('eAEKDx5b37ZyyXkUT7A', '0Q0LkJpfR1ejtO8rD3p', null, 'Ps4ZZv1ZXK9RWgInE2I', '2', 'Ps4ZZv1ZXK9RWgInE2I', '155168789312600004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('EamLrgpqX96E6BNk7bN', '2jSs6cnzu4mzY9C13vF', null, 'IfoHRC8Rs6njW75HqiE', '1', 'IfoHRC8Rs6njW75HqiE', '155142339874500003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('EaNOncilOdviNx3fpzp', 'WB81MbCBolNg6XmE35M', null, '11e6-5540-7128195d-8350-a3b9b8447d61', '1', '11e6-5ae4-2955f016-a841-31f95f893f0b', '155141105159900002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('eAtPLsXVBhuzCo0hUS0', '2ytUeoxBqghwofmBALl', null, 'MtITrUcx3REq45LskT3', '0', '7vuhrOZQxA5vCOL1Nkw', '154461619135100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('EB0q30zggMrMbFOtCyd', 'kPLbeydkgiYW6NIkCt0', null, 'oUGfBAkdjTsO2z22gYU', '2', 'oUGfBAkdjTsO2z22gYU', '155168804475900004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('EB8AuUDHCN5zWEdZw15', 'WB81MbCBolNg6XmE35M', null, '11e6-4f1e-e81c7160-81e8-cb77e1bc6c59', '1', '11e6-4f1e-e81c7160-81e8-cb77e1bc6c59', '155141105214500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('eBDUqphMmuSVvEaX9PD', '3tFw1boS5L9vXoJCr6Z', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'cY4kl4aBnqojbhnxddX', '154563949577300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('eBJ5ZNbjUjtVPhjOQm1', '0Q0LkJpfR1ejtO8rD3p', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'Wy8unQKVYBEnHvEqVyA', '155168789345400002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('eBs6aY3j3BdiIU1fbfC', '2jSs6cnzu4mzY9C13vF', null, 'T9IoQKXjHSvxRXYM3L8', '1', '3X6cQR0K41HlNd3N5Ty', '155142339727900000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('EbUucqkMidl5d7WbFhF', '0Q0LkJpfR1ejtO8rD3p', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'f1qYzMAqsF7bNYJc4Xl', '155168789351600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('EBwj5OgDOC2vZspFZ0a', '0Q0LkJpfR1ejtO8rD3p', null, '3K4lxgBhBLAbzJrfYaB', '1', 'iYGmCNLDOISoDmNMi4d', '155168789488900000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('ebWxk59NtjOp8Xs5OUg', '2ytUeoxBqghwofmBALl', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'ElTaDWYx8x0ksSxQW27', '154461619074200006', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('EBXqPxo0fvcWo3t4zG0', '3tFw1boS5L9vXoJCr6Z', null, 'TU5YGgO5fJs1QU3q3h6', '1', 'TU5YGgO5fJs1QU3q3h6', '154563949567900005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('eCCoHjIkwbiBJOXust2', '3tFw1boS5L9vXoJCr6Z', null, 'BXWlXtLv3yNVPzVHd1A', '2', 'BXWlXtLv3yNVPzVHd1A', '154563949472600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('eCeePCyVtb2rL2zNYkF', '2ytUeoxBqghwofmBALl', null, 'CjR2ngF0kCrKnCpD0rj', '1', '5KOAZ5zATQsht3hJjXs', '154461618955400003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Ecjuot0kauRnpWxAfTg', 'jkpTHKg7DpuXQrppVxx', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'cAu7pZ4IzsfytkdYNLM', '155142353022200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('eCSFnts0ggnINnemWSf', '3tFw1boS5L9vXoJCr6Z', null, 'HsCxJxVzSoMOXQotkMK', '1', 'HsCxJxVzSoMOXQotkMK', '154563949614800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('eCxTpodJ0rEOgDLb06t', '2ytUeoxBqghwofmBALl', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'M2lLJBuu4yQUfthKi4F', '154461619035100000', 'HdPeBqYwJyFyjHkhZu3', '保存草稿', '19', '1');
INSERT INTO `t_permission` VALUES ('ED7FAdQcWguj3F9ySWf', '3tFw1boS5L9vXoJCr6Z', null, 'A6EMGp4mkUqLbMGLtql', '0', 'jvS3grY0lQM6HRUV78H', '154563949572600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('edUecnOtsB9UkDvJT3s', 'kPLbeydkgiYW6NIkCt0', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'erjzyEtPTNQ9Oc2MmGl', '155168804541400000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('eeHuM5QBj8BjmR9h8yx', '3tFw1boS5L9vXoJCr6Z', null, 'OGMmff1QTZYqFk5vfeD', '1', 'OGMmff1QTZYqFk5vfeD', '154563949483600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('eezaCNB7gpwwWjuYfCF', '3tFw1boS5L9vXoJCr6Z', null, 'yv2DP99h1j34cgCO1SZ', '2', 'yv2DP99h1j34cgCO1SZ', '154563949469500005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('EF9pwhyhabrzlpEyLhl', '2ytUeoxBqghwofmBALl', null, '5XKkpkend5hrAy8xWlc', '1', 'gMLNnDrjNUE07fMXd9o', '154461618950700004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('efaRZbEiBGeMPUO4p5i', '2ytUeoxBqghwofmBALl', null, '9HKopmq2QmqQZjBp0ve', '1', '9HKopmq2QmqQZjBp0ve', '154461619089800003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('efeZPFykNky0t1tCHIE', 'WB81MbCBolNg6XmE35M', null, '11e6-5531-4f3943bb-8350-a3b9b8447d61', '1', '11e6-5533-07370c77-8350-a3b9b8447d61', '155141105200500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('EFm8s3hk2hfVE2me1KP', '3tFw1boS5L9vXoJCr6Z', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'SmYDAD9eEDzqIUvO99F', '154563949519500004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('EfVCRgP3cnEltzJxnRT', '3tFw1boS5L9vXoJCr6Z', null, 'a0NeCmvVh6L5QDzhezl', '2', 'a0NeCmvVh6L5QDzhezl', '154563949449100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('EfxJMTAJRFGTdHxU7QI', '2ytUeoxBqghwofmBALl', null, 'w7IsSOtXFvo61cP8sKr', '1', 'bdnOlGNgir39pNIV5w3', '154461619035100004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('EGJCkaQ9DtdG72pUFQ7', 'kPLbeydkgiYW6NIkCt0', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'cHPexySH1L6Pf3IyNTH', '155168804608500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Eh8U3fZpWLjYiAYk5pi', '2ytUeoxBqghwofmBALl', null, 'IuPDe4Gm9occzflnrP0', '0', 'dSSZNfrsXOVhXvx7vOM', '154461619108500006', 'HdPeBqYwJyFyjHkhZu3', '页签打开', '43', '1');
INSERT INTO `t_permission` VALUES ('EHDHfUwKfzDwsYwOHNu', '3tFw1boS5L9vXoJCr6Z', null, '4v5tmazbZwdNkJDYso5', '1', '4v5tmazbZwdNkJDYso5', '154563949625700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ehDwO4f8XMbxLb2XTWp', 'jkpTHKg7DpuXQrppVxx', null, 'zg2t1qqkaJ17B2vvX05', '0', '5YmlK5Wk3G3ZqIrhdzM', '155142353122100003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('ehI9Acf3urDl8xAR6yw', 'WB81MbCBolNg6XmE35M', null, '11e6-549a-e2332c7e-9671-379f935a9949', '1', '11e6-549a-e2332c7e-9671-379f935a9949', '155141105055400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('eHL33FSceWozF6ScU2J', '2ytUeoxBqghwofmBALl', null, 'qqHbF4LC1qdUg1ak29k', '1', 'DvqeT7614zNxx8M5zED', '154461618939800004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('eHZwJxyONdKuyVdX11s', 'jkpTHKg7DpuXQrppVxx', null, 'iS0C05zNyVJaInb9Lvo', '2', 'iS0C05zNyVJaInb9Lvo', '155142352972300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('eidHABaChmAwgqxzaQh', '2jSs6cnzu4mzY9C13vF', null, 'gniImP2ug7E82S1WO0L', '1', '2GBc0jCYf23ydklhe3I', '155142339826200002', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('EIMoVguIo860bN4B3Jq', '2jSs6cnzu4mzY9C13vF', null, '4mlBSmLGlzULUWJe8Nu', '1', '4mlBSmLGlzULUWJe8Nu', '155142339774700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('einrZdvfIHfjtuMkjQn', '2ytUeoxBqghwofmBALl', null, 'U945OMsdX9fvzRjE7xG', '0', 'S1V13oV2ZMjKmg0oiLO', '154461618999200007', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('eiwlJ9d2shMT8pV0rgY', '3tFw1boS5L9vXoJCr6Z', null, 'aA68dayjwAsKuH1y8yq', '2', 'aA68dayjwAsKuH1y8yq', '154563949461600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('EiZ8lBsfPJIuf6Fx0ps', 'WB81MbCBolNg6XmE35M', null, '11e6-8086-9ae48819-94e7-cf1302a16d88', '0', '11e6-8086-9ae96a24-94e7-cf1302a16d88', '155141105142700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ejcPkWhWKEgvWjytWsl', '3tFw1boS5L9vXoJCr6Z', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'WL5tjQMqesP6uJhWq81', '154563949527300006', 'HdPeBqYwJyFyjHkhZu3', '批量审核', '20', '1');
INSERT INTO `t_permission` VALUES ('eJL0jLbk8iAtZxSLedG', '2jSs6cnzu4mzY9C13vF', null, 'TU5YGgO5fJs1QU3q3h6', '1', 'TU5YGgO5fJs1QU3q3h6', '155142339790300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('EJWtEU33q4NBFcHSb60', '3tFw1boS5L9vXoJCr6Z', null, 'BwrS8PTVhvcxNYK06zs', '0', 'lYGfum2jUhooCRzlS3U', '154563949567900002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('EK6EUx1xXlUCXZ0KLma', '2jSs6cnzu4mzY9C13vF', null, 'a2ZyD3z0DqPxaNXX6Zx', '0', 'UcyIJcbxVT4vXhKlAIg', '155142339759100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('eKDvs9RVVlqJX89tyud', 'jkpTHKg7DpuXQrppVxx', null, 'd1anhG9lkXM7xOEL0p0', '1', 'd1anhG9lkXM7xOEL0p0', '155142353042500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('eklL5rc5qvswrSCzcFl', '0Q0LkJpfR1ejtO8rD3p', null, 'MtITrUcx3REq45LskT3', '0', '7vuhrOZQxA5vCOL1Nkw', '155168789479500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('El4rcfgLCgHuDxNrjeL', 'jkpTHKg7DpuXQrppVxx', null, 'U1TygLjjsSxDfEoGwhc', '1', 'hdiqWVc1ZHENK9nuZv5', '155142353016000001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('EL8Ui2SlqeFUuG2fWvs', '2jSs6cnzu4mzY9C13vF', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'IajyYUcsSuyg4dFRXdR', '155142339858900003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('eLFsgMlOJgyr8ycXd9m', 'kPLbeydkgiYW6NIkCt0', null, 'sxP7Fu1gvFvYLklKaKB', '2', 'sxP7Fu1gvFvYLklKaKB', '155168804475900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('eLIoPsJ2aaVxwaCJvP8', '3tFw1boS5L9vXoJCr6Z', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K8Lx8Yr2KhbHQo4z25I', '154563949507000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ELsYpUGusPvxQE27YMl', '2ytUeoxBqghwofmBALl', null, 'rfmGjP7LXiQfxy15izp', '1', 'rfmGjP7LXiQfxy15izp', '154461619072600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('emQAyE7jpRXkIGKBvQ0', 'kPLbeydkgiYW6NIkCt0', null, '3gGNzYyE5dK9ogZidWA', '1', '7SBexLWqUvnu9vb48Vu', '155168804624100000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('EmvWvjHsxWc6NEofodj', '3tFw1boS5L9vXoJCr6Z', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'czdV0c3QJMI2AZPkQZ6', '154563949597600003', 'HdPeBqYwJyFyjHkhZu3', '新建（绿色）', '2', '1');
INSERT INTO `t_permission` VALUES ('eN51VhDDzIZIiklxIEK', '0Q0LkJpfR1ejtO8rD3p', null, 'ry6uZqKmxro1UYtKquD', '2', 'ry6uZqKmxro1UYtKquD', '155168789284500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('enEE2YfN5hTxzRZatm7', 'kPLbeydkgiYW6NIkCt0', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'VMAbFQIQDDpyST1AhyZ', '155168804664600001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('eNisu2rTcEJZ15QXKbV', '3tFw1boS5L9vXoJCr6Z', null, 'Kb6r6jvJBO7WdcyIqFH', '2', 'Kb6r6jvJBO7WdcyIqFH', '154563949441300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('eNJG9zXRK3uH8Bxujn7', 'jkpTHKg7DpuXQrppVxx', null, '8q7uUoYo99jyzdLW3o5', '1', '8q7uUoYo99jyzdLW3o5', '155142353094000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('enLzqzZSuI49diycwqT', '2jSs6cnzu4mzY9C13vF', null, 'dtXU9EYYl4qLe8PdIVc', '0', '35iPlaPI9jj9qVEeTCZ', '155142339745000005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('EnOgLxJFyD7nYPLCytD', 'jkpTHKg7DpuXQrppVxx', null, 'taWpyKypy5rBhloCotj', '2', 'taWpyKypy5rBhloCotj', '155142352963000004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('eoUjB87D0UuUq31HHKf', 'kPLbeydkgiYW6NIkCt0', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'lCdJ38yUB4mcSL1qJJ2', '155168804564800004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('Ep5Nf5PKfg70jLEIysg', 'jkpTHKg7DpuXQrppVxx', null, 'g2XzgmKDL1T8UB79GZh', '0', '8yld9hcbZOKvZi6xp2Q', '155142353115800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ep9VXAxS8HAi23rWhdF', 'kPLbeydkgiYW6NIkCt0', null, 'ysihCX7dcjE9EuejMrJ', '2', 'ysihCX7dcjE9EuejMrJ', '155168804519500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('EPbONac8y5wx3YkqtGL', '2jSs6cnzu4mzY9C13vF', null, 'kA4m81roWetnkDQgWm0', '0', 'imbMPttNeDXyRLEFJeh', '155142339743500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('epeG7xXhmemRvOaG6gl', '3tFw1boS5L9vXoJCr6Z', null, 'WOmzvkui5ZsoZu1CogR', '1', 'WOmzvkui5ZsoZu1CogR', '154563949552300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('epPj9VndqPN93Z5IDFP', 'jkpTHKg7DpuXQrppVxx', null, 'w7IsSOtXFvo61cP8sKr', '1', 'tdpqhqKdJ6wj3toLl5M', '155142353084600003', 'HdPeBqYwJyFyjHkhZu3', '打印包含流程历史', '15', '1');
INSERT INTO `t_permission` VALUES ('eqBYs6oY0gYz7zTuxtS', 'WB81MbCBolNg6XmE35M', null, '11e6-5467-f56e4cca-9671-379f935a9949', '1', '11e6-5ab8-a1ab9e1e-a841-31f95f893f0b', '155141104963300002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('eQLZmKVdZzkiwTBt49J', '2ytUeoxBqghwofmBALl', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '154461618974200006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('EQSiO9Fa7GbDALiLFWo', 'jkpTHKg7DpuXQrppVxx', null, 'NaZcYrbGaXxrTGcsd2M', '1', 'NaZcYrbGaXxrTGcsd2M', '155142353159500002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('EQZFYxRaxiXk8RPEEgv', 'jkpTHKg7DpuXQrppVxx', null, 'laN4VVChl81K10rDCWr', '1', 'laN4VVChl81K10rDCWr', '155142353100200002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('er6isqOZgZbTHCpnVMr', 'kPLbeydkgiYW6NIkCt0', null, 'gniImP2ug7E82S1WO0L', '1', 'A9ZVOiaJCjFUhFQkG6X', '155168804613100004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('erbOFe2uCEGTtC6Srs1', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-3520c5ac-91c5-cd8abd28b1f9', '2', '11e6-5619-3520c5ac-91c5-cd8abd28b1f9', '155141104755900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ErFRtOcKHxIYWJryLod', '2ytUeoxBqghwofmBALl', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'kYjMqLc40QkdYGXLHWO', '154461619063200003', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('eRvQ20joLcrw5Zkte4A', 'jkpTHKg7DpuXQrppVxx', null, 'eKZqOwJmAFsUEwu0WfL', '1', 'eKZqOwJmAFsUEwu0WfL', '155142353037800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('es0Gy24jm55icGUs5Oq', '3tFw1boS5L9vXoJCr6Z', null, 'F0SEYWEOMkZjQU2f0R1', '2', 'F0SEYWEOMkZjQU2f0R1', '154563949467900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Es5EdBA84lr2rjf73mg', 'kPLbeydkgiYW6NIkCt0', null, 'dzJOLeIY4r6nbim6lou', '2', 'dzJOLeIY4r6nbim6lou', '155168804468100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('EsBTH8soHlqXWefyauB', '0Q0LkJpfR1ejtO8rD3p', null, 'R6yjKjfn0NuFZDhxQuS', '2', 'R6yjKjfn0NuFZDhxQuS', '155168789318900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ESP67pResZfntkT0pWL', '3tFw1boS5L9vXoJCr6Z', null, 'IuPDe4Gm9occzflnrP0', '0', 'oD3WAF1Vtv6gB6lDCtv', '154563949603800002', 'HdPeBqYwJyFyjHkhZu3', '新窗口打开', '43', '1');
INSERT INTO `t_permission` VALUES ('Et0mQWkekll0dW96b18', 'jkpTHKg7DpuXQrppVxx', null, 'TsNrOa7PU4hkaT6pxfO', '2', 'TsNrOa7PU4hkaT6pxfO', '155142352961400003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('eT677pxIEEj96cgTrQv', '3tFw1boS5L9vXoJCr6Z', null, 'xBX9EbJkveiSGJm9xRj', '0', 'Ly9Spk5ma18fAyhAWh3', '154563949524100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ETDYb15bSJKRBR0ap1c', '3tFw1boS5L9vXoJCr6Z', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'KWyhjGMdOzdszl2VD2Q', '154563949627300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ETOy1T9TREft3jBHLmb', 'jkpTHKg7DpuXQrppVxx', null, 'NyOvQfCmNxbiRG9N00v', '2', 'NyOvQfCmNxbiRG9N00v', '155142352973900005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('eUhoVRbn1nYVTuUqtWc', '3tFw1boS5L9vXoJCr6Z', null, 'bKWrnsYGUGaqqYqkeeO', '0', 'hC3yELXt7HX4lHI9D1B', '154563949635100000', 'HdPeBqYwJyFyjHkhZu3', '打开表单', '2', '1');
INSERT INTO `t_permission` VALUES ('EujKXHMg1LIrPWmSzTz', 'jkpTHKg7DpuXQrppVxx', null, '6bUPlXeVH92MIv7Nmdw', '1', 'RUXaoNPGKk4u8FtSPTh', '155142353025400005', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('eUmDMAPk4OtnfEAUvMz', '3tFw1boS5L9vXoJCr6Z', null, 'Tm9KRBnKnzjuuld7bJh', '0', 'k0TYCIl1oBQF4xUGHYE', '154563949528800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('eUTKK717dskYahazKuP', '0Q0LkJpfR1ejtO8rD3p', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'ElTaDWYx8x0ksSxQW27', '155168789451500004', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('eV18hB5jyBa1jjBEYAC', '3tFw1boS5L9vXoJCr6Z', null, 'Dp0d6MuuCtsiTwqL6qe', '2', 'Dp0d6MuuCtsiTwqL6qe', '154563949475700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('EVHBZ21WeNNWD8X4nKl', '0Q0LkJpfR1ejtO8rD3p', null, '7NlGpNC1MAEM6EuX2X0', '1', 'tqjrAb05aPRsD2JYTh1', '155168789488900002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('eVqRpDaZc2Egg8rZ2HG', 'WB81MbCBolNg6XmE35M', null, '11e6-5616-2f97dedb-91c5-cd8abd28b1f9', '2', '11e6-5616-2f97dedb-91c5-cd8abd28b1f9', '155141104765200002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('evu6OkBJruGKqWFBzOH', '0Q0LkJpfR1ejtO8rD3p', null, 'ddbeKTjs0WvqKVJ90MU', '1', '5fbpm1XlYeZn8KXFMNL', '155168789362500002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('EvwJBBD8GUjjKMhfF9I', 'WB81MbCBolNg6XmE35M', null, '11e6-53d0-13d83c16-81f5-679a826556ce', '1', '11e6-53d4-1ee56143-81f5-679a826556ce', '155141105038200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('eWdTmCWL3N5ztwl9y0i', 'WB81MbCBolNg6XmE35M', null, '11e6-560b-cd376f93-91c5-cd8abd28b1f9', '2', '11e6-560b-cd376f93-91c5-cd8abd28b1f9', '155141104766800003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('EwSCGGQ0UmuLBTqVKmF', '3tFw1boS5L9vXoJCr6Z', null, '7NlGpNC1MAEM6EuX2X0', '1', 'tqjrAb05aPRsD2JYTh1', '154563949633500001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('EwsyoDznR4OvOTy65iD', '0Q0LkJpfR1ejtO8rD3p', null, 'UW3rch1KdGhIyDrOLr6', '2', 'UW3rch1KdGhIyDrOLr6', '155168789325100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('eWxgOZPqHUIWqMr6mHC', 'kPLbeydkgiYW6NIkCt0', null, 'U945OMsdX9fvzRjE7xG', '0', 'NNovnd63EkWs6jGCQgq', '155168804572600004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('EwzTT7z4bI6pOYUaXnz', '3tFw1boS5L9vXoJCr6Z', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'QE5Y9qsMqfgX5CnSw2u', '154563949605400004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Ex2XlSzPEsG9LtAWfnC', '0Q0LkJpfR1ejtO8rD3p', null, 'aA68dayjwAsKuH1y8yq', '2', 'aA68dayjwAsKuH1y8yq', '155168789322000004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Ex3ghJ8F9y92ARJBIRf', '3tFw1boS5L9vXoJCr6Z', null, 'vZjJlrJAj7XdNX3czmS', '0', 'SG77mlxdPhjGgtckCUZ', '154563949517900001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('exKBYbP5AjGW7uAUHLH', 'jkpTHKg7DpuXQrppVxx', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'M2lLJBuu4yQUfthKi4F', '155142353083100002', 'HdPeBqYwJyFyjHkhZu3', '保存草稿', '19', '1');
INSERT INTO `t_permission` VALUES ('EXN3aPGiu5Xh6wStrqX', '0Q0LkJpfR1ejtO8rD3p', null, 'IuPDe4Gm9occzflnrP0', '0', 'LFydu54akpsq9Y9sCQr', '155168789467100002', 'HdPeBqYwJyFyjHkhZu3', '载入其他视图', '1', '1');
INSERT INTO `t_permission` VALUES ('eXR0p6qhC3QPIeDqUXl', 'kPLbeydkgiYW6NIkCt0', null, '4oavihvP4J8cXDsWDIP', '0', 'pwDWlADlB4vGrKVGIQc', '155168804614700001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ExrxxfKRCEtZ9JuLic1', '3tFw1boS5L9vXoJCr6Z', null, 'J9uhQYSQWhPor4IvkOE', '0', 'Q2aiiWtqBNqF33UGXUy', '154563949480400002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ExSCk0oT5uAIM2HIMna', 'jkpTHKg7DpuXQrppVxx', null, 'gHKBmQ7kx8ThwKaSbuk', '2', 'gHKBmQ7kx8ThwKaSbuk', '155142352972300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Exw6r4MWH7cq8dIkC4s', 'WB81MbCBolNg6XmE35M', null, '11e6-5615-dfca2eb5-91c5-cd8abd28b1f9', '2', '11e6-5615-dfca2eb5-91c5-cd8abd28b1f9', '155141104752700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('eYAzlHR77B93ljeyJzx', 'kPLbeydkgiYW6NIkCt0', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'weZ9Sz2X5RBVBRpCdJM', '155168804661500001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('EYCTyHOo4V3ygjuBR76', 'jkpTHKg7DpuXQrppVxx', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'PJTrl1ydDfvxVoyGPXp', '155142353045600003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('eYDzVdEGDT85UW42oSe', 'jkpTHKg7DpuXQrppVxx', null, 'J9uhQYSQWhPor4IvkOE', '0', 'Q2aiiWtqBNqF33UGXUy', '155142353012900001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('eyNicFEknic2P3cTe3R', '2ytUeoxBqghwofmBALl', null, 'eLFjqFngRQrIkbsdeBd', '1', 'laHgljUkGTSlRpd6Sbl', '154461619053800000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('eZD7u0bYgtbzqW2gnvH', '2ytUeoxBqghwofmBALl', null, 'rfmGjP7LXiQfxy15izp', '1', 'dUQn2CkeHgHGnGsR8JC', '154461619072600003', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('EzfOAxGmM4yw0ABNWjc', '2ytUeoxBqghwofmBALl', null, '5XKkpkend5hrAy8xWlc', '1', 'xHnChg1mK6MilHV4VCZ', '154461618950700003', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('EzKBuN8BRubX4rDnTkD', 'kPLbeydkgiYW6NIkCt0', null, 'Vu8Q68Bom89YJDgguC9', '1', 'pTuo29zZfTBXXiWv0y7', '155168804600700002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('ezo6RSFMdYBBghuTNAd', '2ytUeoxBqghwofmBALl', null, 'vZjJlrJAj7XdNX3czmS', '0', 'SG77mlxdPhjGgtckCUZ', '154461618994500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ezoVl0U0jlLMzQilSq8', 'kPLbeydkgiYW6NIkCt0', null, 'jYDgN5WH46paTNLcCqi', '0', '3Un6aJGRxrZKJu5VhVa', '155168804597500003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('EzrC3mIb8uFnncFRPvP', 'jkpTHKg7DpuXQrppVxx', null, '14PxjfoOE09shUfSg1l', '2', '14PxjfoOE09shUfSg1l', '155142352975400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ezsN6573n8dqWA0BIXl', 'jkpTHKg7DpuXQrppVxx', null, 'x2qgUpE8u9jmGEWbbQm', '1', '1x0dmC76v20LfiQLJDC', '155142353104900003', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('F04WhnS8ItajkR3xLa9', 'jkpTHKg7DpuXQrppVxx', null, 'qOM6QAy48iqde43ij94', '2', 'qOM6QAy48iqde43ij94', '155142352969200006', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('F06bl1Wcrn4O7vP9Mch', 'kPLbeydkgiYW6NIkCt0', null, 'RwAgQB30vyuzPHYBb3F', '2', 'RwAgQB30vyuzPHYBb3F', '155168804469600005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('f0jOv78UXBTF9L5HsUE', '2ytUeoxBqghwofmBALl', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'eTfrqgZ8RLViOksDpqV', '154461619066300000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('f0Rd1Nvk3upvWtNfb8g', '2jSs6cnzu4mzY9C13vF', null, 'JdWD8biOlCXjkEvrwMm', '0', 'MRVrK6Uj6Z6imY0qwYm', '155142339868300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('F16E7F623NZrXGCuXCM', '2ytUeoxBqghwofmBALl', null, '1fhgTUPecMY0ajlTkKZ', '0', 'juwrHEhNEXIqxCUqQuz', '154461619024200004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('f1SArnkiIEMq12Ggfkq', 'WB81MbCBolNg6XmE35M', null, '11e6-552e-bba4b939-8350-a3b9b8447d61', '1', '11e6-552f-771d6e39-8350-a3b9b8447d61', '155141104902500003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('f1YBXOB3Zt77dQ5Aj2f', '3tFw1boS5L9vXoJCr6Z', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '154563949521000005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('f3nqMVygLreLiXV8asM', '2ytUeoxBqghwofmBALl', null, 'bKWrnsYGUGaqqYqkeeO', '0', '23XpTvLhb5XEzINSZHU', '154461619149200004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('F3OMubI7rIZF6P6M2lB', '2ytUeoxBqghwofmBALl', null, 'eKZqOwJmAFsUEwu0WfL', '1', '3jy9fTiYM0hwEHejpTu', '154461618961700000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('f4fgXdoM6TSWehqpM2s', 'kPLbeydkgiYW6NIkCt0', null, 'a7jp1Dm53YjlAwDWuws', '1', 'wL7xiiufleig43GVrAC', '155168804589700005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('f4KUTlBOdyit67LRrCR', 'kPLbeydkgiYW6NIkCt0', null, '5r3ZtpSgGVUw8avJcWr', '0', 'pGXUT2ahLNR4H5EfGjy', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单1', '2', '2');
INSERT INTO `t_permission` VALUES ('F4uph0AUKLkmZebsSle', '2jSs6cnzu4mzY9C13vF', null, 'enhnCZbrTQ1mZpn18o5', '0', 'iqufoXl2qzIWDFkt1Vi', '155142339860500002', 'HdPeBqYwJyFyjHkhZu3', '获取第一个查询条件的值', '1', '1');
INSERT INTO `t_permission` VALUES ('F61NnQhe0KzymEIUByM', '0Q0LkJpfR1ejtO8rD3p', null, '4VkP5W8VPlERMiThvSD', '0', 'r8ONfNaqWuH1q18rKZk', '155168789417100002', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('f67ZOH8wzSWmrJIeAc5', 'kPLbeydkgiYW6NIkCt0', null, '5XvXec6bdYRjaPxuLlQ', '1', '5XvXec6bdYRjaPxuLlQ', '155168804602200002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('f7utZN2yYtlhCe0Suit', 'jkpTHKg7DpuXQrppVxx', null, 'WjB49SEA8rvzL9rkC7N', '1', 'WjB49SEA8rvzL9rkC7N', '155142353100200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('f94VFlbPi62Syam2okA', '3tFw1boS5L9vXoJCr6Z', null, '1fhgTUPecMY0ajlTkKZ', '0', 'juwrHEhNEXIqxCUqQuz', '154563949535100002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('f98DOA6prtZvJmxBqXX', 'WB81MbCBolNg6XmE35M', null, '11e6-53e6-73b34240-81f5-679a826556ce', '1', '11e6-d15f-abd0b9bc-bbdd-9f7a0eebced4', '155141105111500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('f997A0mIc3uadcKz5oo', 'kPLbeydkgiYW6NIkCt0', null, 'oeLOJO0f3CC02OjOOIC', '0', '6onRFmzn8mrnGdrnIJy', '155168804578800005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('f9g7QDXOJYZSXNRST7X', '2ytUeoxBqghwofmBALl', null, 'poalxIjVlN70WdVjfQq', '1', 'ZABfGox4xJSo5PMgCOr', '154461619147600001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('f9qJ7830aeqiueJeECr', '2jSs6cnzu4mzY9C13vF', null, 'fAVX6iUbvHroALIUfPf', '2', 'fAVX6iUbvHroALIUfPf', '155142339559400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('f9Xz4Lp6r3IrvbkZaor', 'jkpTHKg7DpuXQrppVxx', null, 'hdMXKLI1XqTUYUrFniv', '0', 'aa25jXytFYZYB62Ac2z', '155142353117400000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('FAsJDu6ra5jietigx7A', '2jSs6cnzu4mzY9C13vF', null, 'CjR2ngF0kCrKnCpD0rj', '1', '5KOAZ5zATQsht3hJjXs', '155142339702900002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('FaSTCfE1hSsqdMoUWws', 'kPLbeydkgiYW6NIkCt0', null, 'bVLnHAUMhdToxosd7nT', '0', 'zNyhoGxQwFdm43lTvgK', '155168804580400002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Fb7JX8xyh9Oks5vx8R8', 'jkpTHKg7DpuXQrppVxx', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Ty33WfwAyTHWENnxPcQ', '155142353081500006', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('fbgyQUFID29CVgw7rwA', 'jkpTHKg7DpuXQrppVxx', null, 'AKGX6zv2MUckrIYhVdz', '2', 'AKGX6zv2MUckrIYhVdz', '155142352967600005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fbmLnuZGiYykIbDhP1P', 'WB81MbCBolNg6XmE35M', null, '11e6-5467-f56e4cca-9671-379f935a9949', '1', '11e6-5467-f56e4cca-9671-379f935a9949', '155141104961800000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fc0F6RMNXxZV9b4Vymp', '2jSs6cnzu4mzY9C13vF', null, 's8qcshfzszuUknfhZNl', '2', 's8qcshfzszuUknfhZNl', '155142339550000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fclI1S5oKvwEY7cvh0s', '3tFw1boS5L9vXoJCr6Z', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'PX5hS2Svd6sudk7n9l9', '154563949486600004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('fDIW238l8lc4VB5ktUB', 'kPLbeydkgiYW6NIkCt0', null, '14PxjfoOE09shUfSg1l', '2', '14PxjfoOE09shUfSg1l', '155168804499300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FDjdbPciabg472VDqah', '2jSs6cnzu4mzY9C13vF', null, 'sMlqIILsNZ3bvqE2hSm', '1', '7gZkOqMaP3BBCXPapf5', '155142339646800000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('FdJWllWnVXFsQZJjec7', 'jkpTHKg7DpuXQrppVxx', null, '2F75ZJJXk8564FkCLYA', '1', 'aYBPeZTWDS1YHS4MWF5', '155142353028500003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('FDmnPZtyfuxZtwSe42U', 'jkpTHKg7DpuXQrppVxx', null, '0zSRHMqiyMTl1dth7ds', '1', '0zSRHMqiyMTl1dth7ds', '155142353026900003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fevlJKLyMrH0bjBzcAh', '2jSs6cnzu4mzY9C13vF', null, 'Gs69JZ3ObwaQctDBcOp', '2', 'Gs69JZ3ObwaQctDBcOp', '155142339579700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FEwwDgfO6uOV1kEqeeH', 'WB81MbCBolNg6XmE35M', null, '11de-7665-e571fab8-8d52-0547317ddd4c', '1', '11de-ab62-34569ebe-9b88-2bcddad554b6', '155141105133400003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '打印', '14', '1');
INSERT INTO `t_permission` VALUES ('ff20GBtiaNfmMCNTh96', '2ytUeoxBqghwofmBALl', null, 'o4zdmPoNHMg5JK6m6dx', '0', '2MHj4CnPnbOb2UFuMQr', '154461618967900004', 'HdPeBqYwJyFyjHkhZu3', '执行前再确认', '3', '1');
INSERT INTO `t_permission` VALUES ('Ffskz0YCPD1kRKsm8I9', 'jkpTHKg7DpuXQrppVxx', null, '6esIc2fTAI9nAOoOZcp', '1', 'qXsymSHvIPzVV0lWwQe', '155142353030000003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('fg9NN0nm8KzlyUjCgIg', '0Q0LkJpfR1ejtO8rD3p', null, 'WOmzvkui5ZsoZu1CogR', '1', 'yJFj2Hn06m1lkC7swux', '155168789415600000', 'HdPeBqYwJyFyjHkhZu3', '通过邮件或短信通知', '37', '1');
INSERT INTO `t_permission` VALUES ('FGgZydVGurp5AI0wFzL', '2jSs6cnzu4mzY9C13vF', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'lCdJ38yUB4mcSL1qJJ2', '155142339735700000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('FGhlHjVcOcxtdFOjblI', 'jkpTHKg7DpuXQrppVxx', null, 'MIExqx2MWO5cunDiuaX', '1', 'BjLpkwnLuJNx6aokoma', '155142353036300002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('FGJ6RkIgKzhKn2TNj8k', 'kPLbeydkgiYW6NIkCt0', null, 'j4ncSyWthzCYoNj3n4J', '0', 'WWNamo3Hl2Q5IoZUFn7', '155168804619400002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('fgqq6BeOYWdx2vS4G1N', '0Q0LkJpfR1ejtO8rD3p', null, '4mlBSmLGlzULUWJe8Nu', '1', '4mlBSmLGlzULUWJe8Nu', '155168789406200004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('FGV0mpsdteHqmr9UMFh', 'jkpTHKg7DpuXQrppVxx', null, '53PLwEjsvlAXAnlixPb', '2', '53PLwEjsvlAXAnlixPb', '155142352997300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Fh31DVpkf4mwYmsGNJt', 'kPLbeydkgiYW6NIkCt0', null, 'ZM7F9MjjscP8bADF7cH', '1', '0LKFnyB5ViPnDQN8Ocl', '155168804557000002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('FhCBDgcABDEm3dyWpp3', '2ytUeoxBqghwofmBALl', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'D4TlyirrG1V4ebAqUSh', '154461618966300002', 'HdPeBqYwJyFyjHkhZu3', '删除（右键菜单）', '3', '1');
INSERT INTO `t_permission` VALUES ('FhP8X0jsFVxpirkPBvL', 'jkpTHKg7DpuXQrppVxx', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'PX5hS2Svd6sudk7n9l9', '155142353017600002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('fhSjRTfflBM4Rpmf7Zz', '2jSs6cnzu4mzY9C13vF', null, 'MnvkHQ9zdkDlQaAgtGq', '2', 'MnvkHQ9zdkDlQaAgtGq', '155142339581200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fI4VL3tdPTmknOuoXRc', 'WB81MbCBolNg6XmE35M', null, '11e6-5303-7920361b-a13d-c75d0a89256c', '1', '11e6-5306-66e74331-a13d-c75d0a89256c', '155141104885300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('fibf0xAjTKJGgBWGZYG', 'jkpTHKg7DpuXQrppVxx', null, 'a7jp1Dm53YjlAwDWuws', '1', 'a7jp1Dm53YjlAwDWuws', '155142353081500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fIDSJnRjSIc9JTrl5hP', '2jSs6cnzu4mzY9C13vF', null, 'hdMXKLI1XqTUYUrFniv', '0', 'aa25jXytFYZYB62Ac2z', '155142339855800001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('fikzVTRSktEweRtrYG6', '2ytUeoxBqghwofmBALl', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'NF5zkjoJvJNVpgmQsj6', '154461618967900002', 'HdPeBqYwJyFyjHkhZu3', '执行前提示', '3', '1');
INSERT INTO `t_permission` VALUES ('fjDe14AN7iAeYgXVoOu', '2jSs6cnzu4mzY9C13vF', null, '3sSURwczE2wMjgOqqOo', '0', 'xgvB9tVQZn0ZxoQMZ31', '155142339765300002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('fJkzQizVMx1i09bjxhg', '2jSs6cnzu4mzY9C13vF', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'PJTrl1ydDfvxVoyGPXp', '155142339732600000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('fkhKtRxVmbNiSP1C3O7', '2jSs6cnzu4mzY9C13vF', null, 'Ta56UCfylnpmF0NhOQW', '2', 'Ta56UCfylnpmF0NhOQW', '155142339600000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FKHQJOh2SEfY7voHB20', 'jkpTHKg7DpuXQrppVxx', null, 'SiPTeSpUhRIqVgi1HW1', '0', '75x9tz4gNnPZBrKKcK5', '155142353092400003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('FkqMWLv0hQqmULq6UXJ', 'jkpTHKg7DpuXQrppVxx', null, 'ArQpV2XcSwZaAGmiCGT', '2', 'ArQpV2XcSwZaAGmiCGT', '155142352992600004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fldeKB5HDBoKjbKFHoL', 'kPLbeydkgiYW6NIkCt0', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'fkbqJ4vxJOUvHY59Lo6', '155168804661500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fLFnPeXpxg0lBl2UkWL', '0Q0LkJpfR1ejtO8rD3p', null, 'jIuyPXyzHxgmBlx4oQs', '2', 'jIuyPXyzHxgmBlx4oQs', '155168789290800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fLikO9tRldNn3ZuQEDD', '2ytUeoxBqghwofmBALl', null, 'g2XzgmKDL1T8UB79GZh', '0', '8yld9hcbZOKvZi6xp2Q', '154461619091300002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('flKz69I6oeDsmwkx6wr', 'jkpTHKg7DpuXQrppVxx', null, 'NGN4SO4fu5S5XxULG4X', '1', '3obNdvpJGlYwLE4U916', '155142353014400003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('FlNevu0TKVHzg5DI0VE', '0Q0LkJpfR1ejtO8rD3p', null, '6esIc2fTAI9nAOoOZcp', '1', 'qXsymSHvIPzVV0lWwQe', '155168789361000002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('FLpnkM7A4UnUrcJ1JCe', '2jSs6cnzu4mzY9C13vF', null, 'f9GQrsfu9GKGRqKKPgi', '1', '3wblZ30SS7TkVHaoRy2', '155142339871400001', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('fm4RpzvWEg2m3Fzmqcx', 'kPLbeydkgiYW6NIkCt0', null, 'j3y8CHrsMwRmnPJz7EW', '1', 'j3y8CHrsMwRmnPJz7EW', '155168804619400003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fm5CFMpJyolYykvnfo5', 'jkpTHKg7DpuXQrppVxx', null, '1YQdDj3kDCsdgpgrTSf', '2', '1YQdDj3kDCsdgpgrTSf', '155142352958300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FmRMSmajVRjQz9UWH0e', 'WB81MbCBolNg6XmE35M', null, '11de-c39b-5cf3eb81-b652-871d9b638147', '1', '11de-c39e-17d13817-b652-871d9b638147', '155141104872900002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('fmwldVxkHojYYzHNuks', '2ytUeoxBqghwofmBALl', null, '8DmOHAVRvs3BblbhJoa', '1', '8DmOHAVRvs3BblbhJoa', '154461618935100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fNgQfoqSxsvHivitNco', '0Q0LkJpfR1ejtO8rD3p', null, 'LocWe3mm3K3vF1gdbgC', '2', 'LocWe3mm3K3vF1gdbgC', '155168789303300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FnY1IRNa3LRHSwYM9P0', 'kPLbeydkgiYW6NIkCt0', null, 'WjB49SEA8rvzL9rkC7N', '1', 'WjB49SEA8rvzL9rkC7N', '155168804603800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('FoHgr8BlM0mbKQMpvVY', '0Q0LkJpfR1ejtO8rD3p', null, 'o4zdmPoNHMg5JK6m6dx', '0', '2MHj4CnPnbOb2UFuMQr', '155168789463900005', 'HdPeBqYwJyFyjHkhZu3', '执行前再确认', '3', '1');
INSERT INTO `t_permission` VALUES ('fOhnFIiAdE9M70ZaTAv', '0Q0LkJpfR1ejtO8rD3p', null, 'sbkS067uQ9jIwpB6qWd', '2', 'sbkS067uQ9jIwpB6qWd', '155168789283000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fOly2h2vvUqi4DVblRk', '2jSs6cnzu4mzY9C13vF', null, 'WOmzvkui5ZsoZu1CogR', '1', 'yJFj2Hn06m1lkC7swux', '155142339780900001', 'HdPeBqYwJyFyjHkhZu3', '通过邮件或短信通知', '37', '1');
INSERT INTO `t_permission` VALUES ('fOXJpSbGNczCilebw2r', '2jSs6cnzu4mzY9C13vF', null, 'lOgu0Jvq0z5dlveyrnY', '0', '5XIqbMcQ6K0lFtVi4HZ', '155142339829300002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('FP9utDEzXQcY3PWh2S9', 'jkpTHKg7DpuXQrppVxx', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '155142353067500004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('fPgMv1f6O7cuW1WIjQp', '3tFw1boS5L9vXoJCr6Z', null, 'tbfv6enk6DCV69XcIwq', '2', 'tbfv6enk6DCV69XcIwq', '154563949417900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FPgrDpTOjXi86NK2CHc', '0Q0LkJpfR1ejtO8rD3p', null, 'u9zN1C73prPrzriTtzg', '1', 'u9zN1C73prPrzriTtzg', '155168789476400005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fpw8Mxbod1MKR0k6NWy', '0Q0LkJpfR1ejtO8rD3p', null, 'bIBjrPWlkEMkXKe7cPi', '2', 'bIBjrPWlkEMkXKe7cPi', '155168789334500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fpzw318A1HNArgRdtm0', 'WB81MbCBolNg6XmE35M', null, '11e6-561b-147c87c0-91c5-cd8abd28b1f9', '2', '11e6-561b-147c87c0-91c5-cd8abd28b1f9', '155141104760500003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fq48IOlFNKXOzgl7dpF', '2jSs6cnzu4mzY9C13vF', null, 'mXDUC8go52mfA91GY0r', '0', 'fh4ptUZPIiHNtWvp0cJ', '155142339868300002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('fQEPEr0w8mrq0WvPIBW', 'jkpTHKg7DpuXQrppVxx', null, 'fVc4y8aYlKHvUPNHpUz', '2', 'fVc4y8aYlKHvUPNHpUz', '155142352970800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FqglU8pK0aNGecu4pHq', '0Q0LkJpfR1ejtO8rD3p', null, '2bmCU7aUTZfM8CZmJEP', '2', '2bmCU7aUTZfM8CZmJEP', '155168789315700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FqHwSomtrX3YugiA1KW', '2jSs6cnzu4mzY9C13vF', null, 'eLFjqFngRQrIkbsdeBd', '1', 'eLFjqFngRQrIkbsdeBd', '155142339879200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fQKdW6L4pgtGmNDWsa2', 'kPLbeydkgiYW6NIkCt0', null, '9ppSV2PIKNhHCOwufvI', '0', '1vKJVgUjJInvLMSVXIn', '155168804636500001', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '36', '1');
INSERT INTO `t_permission` VALUES ('fqkHHZba3lQjwltYYJ5', '2jSs6cnzu4mzY9C13vF', null, 'ikeULZmmOeAR6XklD2T', '2', 'ikeULZmmOeAR6XklD2T', '155142339628000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FQROyTdYVRnniudeQHM', '3tFw1boS5L9vXoJCr6Z', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'lCdJ38yUB4mcSL1qJJ2', '154563949511600000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('FQyktbwz2H5o3x4gZ1L', 'jkpTHKg7DpuXQrppVxx', null, '2F75ZJJXk8564FkCLYA', '1', '2F75ZJJXk8564FkCLYA', '155142353028500002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('FR9cwIiJLsIbQtabt8m', 'jkpTHKg7DpuXQrppVxx', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'ZLGOtOxZGBCsfXYeK15', '155142353104900001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('fRkn8VbnaPAyzEXeOQE', '3tFw1boS5L9vXoJCr6Z', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'v5qY31shPwgs5BLkLlM', '154563949521000002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('fRsdPWSA1C2BoKZU6wt', 'kPLbeydkgiYW6NIkCt0', null, 'JJCy9khz1JRwqvX4xEI', '0', '58H52uh4rkjC2i1d2jE', '155168804569500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('fS4dlhwpJraOfDH9gKt', '3tFw1boS5L9vXoJCr6Z', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'E47mVx0cWjUwctEiuIt', '154563949522600004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('fSD9ftQ23ZzmVBCGjyn', '3tFw1boS5L9vXoJCr6Z', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'I5GJXxDs9LYwwqf4uQv', '154563949528800004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('fsFSWPE1cmKfoa8Cvdk', 'kPLbeydkgiYW6NIkCt0', null, 'w7IsSOtXFvo61cP8sKr', '1', 'u8cNJQfZVXWFj5hlBow', '155168804592900002', 'HdPeBqYwJyFyjHkhZu3', '保存并启动流程', '4', '1');
INSERT INTO `t_permission` VALUES ('fSmrzcxqYuNjSuPHjZJ', '3tFw1boS5L9vXoJCr6Z', null, 'rdQ5WPuRoiCMJtXgsjg', '1', 'fusEE1rcz284HqXlYIO', '154563949482000002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('FSPHA8ZHTjLZU9mcYA3', 'kPLbeydkgiYW6NIkCt0', null, 'p44Eh34DScjVKkZi1ok', '2', 'p44Eh34DScjVKkZi1ok', '155168804479000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Ft5eHOLRfVKr9TliGOi', '3tFw1boS5L9vXoJCr6Z', null, '9HKopmq2QmqQZjBp0ve', '1', '9HKopmq2QmqQZjBp0ve', '154563949586600003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fteEXdQAzFkphiHQLVx', '0Q0LkJpfR1ejtO8rD3p', null, 'DwtZozROcOIsno6lTY3', '2', 'DwtZozROcOIsno6lTY3', '155168789307900004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fvlApX9PEW1T8VQQHfL', '0Q0LkJpfR1ejtO8rD3p', null, 'AkuEixxtkMd7QuHLVOR', '2', 'AkuEixxtkMd7QuHLVOR', '155168789290800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FWb9hxGHZjD4Z3AZK3A', '3tFw1boS5L9vXoJCr6Z', null, 'QfirpboG4MjuFdj8mbs', '2', 'QfirpboG4MjuFdj8mbs', '154563949436600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fWBSR33unnPHqqse6uU', 'kPLbeydkgiYW6NIkCt0', null, '6BIvNJISOeZ3xm8S2aG', '1', '6BIvNJISOeZ3xm8S2aG', '155168804544500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fwcAA4t1YFbzEwuvcDQ', '3tFw1boS5L9vXoJCr6Z', null, 'hxDvvyWbvIEUUrBHW0R', '1', 'hxDvvyWbvIEUUrBHW0R', '154563949571000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fWEIg9AZmWsokpsokWp', 'kPLbeydkgiYW6NIkCt0', null, 'f9GQrsfu9GKGRqKKPgi', '1', '3wblZ30SS7TkVHaoRy2', '155168804650600000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('fwidpQtZ1yYu5MhJQq1', 'kPLbeydkgiYW6NIkCt0', null, 'RZTAlFVXkUYpYm96zVo', '1', 'RZTAlFVXkUYpYm96zVo', '155168804667700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('FwnSgCzm60fwWeod1i1', '3tFw1boS5L9vXoJCr6Z', null, 'qAcxhZ5mnoiohEBYD9G', '2', 'qAcxhZ5mnoiohEBYD9G', '154563949427300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Fws08kB3nVtEIeu2oVy', '3tFw1boS5L9vXoJCr6Z', null, 'A6EMGp4mkUqLbMGLtql', '0', 'z1cc7dNuc4Vg60yjjLM', '154563949572600002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('FxIwAAG1tnJPntO1Q0a', '2jSs6cnzu4mzY9C13vF', null, 'B0yjUrREPsW6eZ4NRxH', '2', 'B0yjUrREPsW6eZ4NRxH', '155142339567200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fXJigs7eYv9JkLHfVW5', '2jSs6cnzu4mzY9C13vF', null, 'Ksfgm24NkZrnPIXYgay', '2', 'Ksfgm24NkZrnPIXYgay', '155142339601500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fXMzQPcuXZ5lXJ0TDCM', '0Q0LkJpfR1ejtO8rD3p', null, 'oeLOJO0f3CC02OjOOIC', '0', '6onRFmzn8mrnGdrnIJy', '155168789393700004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('fxnSoH1PJWXXeHsObEq', '3tFw1boS5L9vXoJCr6Z', null, '5RzsvfgAUx2y0k1pDlg', '0', 'ukXAzRjE6lHNKWb0XN5', '154563949630400003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('fxnWUgI5SS1lUSxz1BV', 'kPLbeydkgiYW6NIkCt0', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'LGI4kXh1sQ9vMEdPg6S', '155168804592900000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('fxqPihxuPsNAdkqAfzd', 'WB81MbCBolNg6XmE35M', null, '11e5-9273-3f22d663-9db1-913f1ac2a256', '0', '11e5-9273-7af922b4-9db1-913f1ac2a256', '155141104880700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('fxUIjJappfBz3K9lXhP', '2jSs6cnzu4mzY9C13vF', null, '8PCn6NiiMTRGZcA5dsU', '1', '8PCn6NiiMTRGZcA5dsU', '155142339788700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fY5l5m7bfU9aUA1vlUt', '3tFw1boS5L9vXoJCr6Z', null, 'G1v3gcUQOvFAo7IH62c', '2', 'G1v3gcUQOvFAo7IH62c', '154563949439800004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('FYmHrlSxqksFtkKId3e', '0Q0LkJpfR1ejtO8rD3p', null, 'epn8IcdUN0afirW9qZ6', '2', 'epn8IcdUN0afirW9qZ6', '155168789329800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fymWdaAHPsdu9N2JRyz', '2jSs6cnzu4mzY9C13vF', null, 'a0NeCmvVh6L5QDzhezl', '2', 'a0NeCmvVh6L5QDzhezl', '155142339581200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('fywnRwcPiGXROLAI6DJ', '2jSs6cnzu4mzY9C13vF', null, 'CuDZkkf1DSaMf5ST7bj', '1', 'CuDZkkf1DSaMf5ST7bj', '155142339795000004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('FYYZkOBlpAQsXC8So6b', 'kPLbeydkgiYW6NIkCt0', null, '3gGNzYyE5dK9ogZidWA', '1', '3gGNzYyE5dK9ogZidWA', '155168804622500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('fzDqPSZGr9XiZi55grR', '2ytUeoxBqghwofmBALl', null, 'EaVrfjS89IZqE63BWPa', '0', 'lPhlrrSkZ8hekbRhXPh', '154461619097600002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('FZGHGgyqFR5dzqhyrES', '2jSs6cnzu4mzY9C13vF', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'AiibIdUU3zQiGsrKDXn', '155142339897900001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('fZoJwoBJHNgoM5Dxlxq', 'kPLbeydkgiYW6NIkCt0', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'Bd1tki9fxPhsf7tARcy', '155168804620900002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('FzqkOb5vueP00lR7jzq', 'jkpTHKg7DpuXQrppVxx', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'iY5ypHvJGJTn6j3J2nC', '155142353104900006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('G0Fb6KiJgCPk1k7ZYmm', '2ytUeoxBqghwofmBALl', null, 'NLGiWBICUXkTNWcaaD0', '1', 'NLGiWBICUXkTNWcaaD0', '154461619053800003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('g0q7m5LWSECpd7bu2yu', 'kPLbeydkgiYW6NIkCt0', null, 'poalxIjVlN70WdVjfQq', '1', 'poalxIjVlN70WdVjfQq', '155168804675500002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('g10EvMeb6kVlHmhByv4', 'jkpTHKg7DpuXQrppVxx', null, 'lbZDhonVIlyX0n0IKyu', '2', 'lbZDhonVIlyX0n0IKyu', '155142352956700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('G1SFvgGMVYOQ0lS3BHa', 'jkpTHKg7DpuXQrppVxx', null, 'hdMXKLI1XqTUYUrFniv', '0', '3EhqWBGmEEkub8qvOuy', '155142353117400001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('g2rOjJalqKaVfTwEUaA', '0Q0LkJpfR1ejtO8rD3p', null, '74xpaQX1peQaya80WFh', '2', '74xpaQX1peQaya80WFh', '155168789309500004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('G3etYBWQEeNDIVtNfwx', 'jkpTHKg7DpuXQrppVxx', null, 'E4cbMljP402vIH2nZMB', '2', 'E4cbMljP402vIH2nZMB', '155142352975400004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('G3OhQqSlbYcoGaOQsGz', 'kPLbeydkgiYW6NIkCt0', null, 'J9uhQYSQWhPor4IvkOE', '0', 'KgFs9krHT2ZyBayTPo8', '155168804532000003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('G43UWjfwqqw8IQg1MEi', '2ytUeoxBqghwofmBALl', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'SmYDAD9eEDzqIUvO99F', '154461619000700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('G4GfN5F7etVFaBmu009', 'jkpTHKg7DpuXQrppVxx', null, 'JJCy9khz1JRwqvX4xEI', '0', 'uFtdRxVPySujVTqhxrx', '155142353055000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('g4k7uO2mYBlr5YQs4XB', 'jkpTHKg7DpuXQrppVxx', null, '6BIvNJISOeZ3xm8S2aG', '1', 't4hcTsCptGZ5kTWV2Ya', '155142353022200000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('g4Sw0ocu40r1VMkHYFA', 'WB81MbCBolNg6XmE35M', null, '11e6-5615-e831d306-91c5-cd8abd28b1f9', '2', '11e6-5615-e831d306-91c5-cd8abd28b1f9', '155141104785500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('G4Wu5i5SJwk446E7aXI', 'kPLbeydkgiYW6NIkCt0', null, '6esIc2fTAI9nAOoOZcp', '1', 'y5AHygdKnFROYRFfQuX', '155168804553900001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('g4Ysn9PLhrLkV0WBBrn', '2ytUeoxBqghwofmBALl', null, '9HKopmq2QmqQZjBp0ve', '1', '9HKopmq2QmqQZjBp0ve', '154461618927300004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('G587zHmMOhOR5s3lQTY', '0Q0LkJpfR1ejtO8rD3p', null, 'PbQMu46yyehblOGohri', '2', 'PbQMu46yyehblOGohri', '155168789306400003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('G6RYtRqklGdoQYtD61Z', 'kPLbeydkgiYW6NIkCt0', null, 'Ry5YZ6oWsbQSIWGTbiM', '2', 'Ry5YZ6oWsbQSIWGTbiM', '155168804485200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('G7gHVg2Mdmx0ViNmiGV', 'jkpTHKg7DpuXQrppVxx', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'KWyhjGMdOzdszl2VD2Q', '155142353159500004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('g7gjLYKQmFqQWztiXQl', '0Q0LkJpfR1ejtO8rD3p', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'wgw8EmPgt7pl1vVHHdz', '155168789368800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('g94Gp2jcWquWbdpEBFH', '2ytUeoxBqghwofmBALl', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'Iw7PqAhVcFRVUHnbbwR', '154461619064800008', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('G9cXqBlmS6z7RUYQquA', 'jkpTHKg7DpuXQrppVxx', null, 'gPHUIa48Bpsz26fjjNA', '2', 'gPHUIa48Bpsz26fjjNA', '155142352977000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gAPIlFwcoINOz5j6zsu', 'WB81MbCBolNg6XmE35M', null, '11de-c39b-5cf3eb81-b652-871d9b638147', '1', '11e5-9335-bb2baeb2-a66b-89e10b8c8666', '155141104872900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('gApVor6mDqUvTfRUsY9', 'WB81MbCBolNg6XmE35M', null, '11e6-546d-1bedb3b5-9671-379f935a9949', '1', '11e6-5472-efe44c30-9671-379f935a9949', '155141104955500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('GavEty2kCrrRJnVYani', '0Q0LkJpfR1ejtO8rD3p', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'APxRfhpMtHJp5vsjIIa', '155168789396900000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('gbCENrwlPxm7XCUW07u', '2jSs6cnzu4mzY9C13vF', null, 'Li1q0Dlwg6sZn4YFamQ', '2', 'Li1q0Dlwg6sZn4YFamQ', '155142339576600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('GcmvIYyYLEnm45uXw39', '3tFw1boS5L9vXoJCr6Z', null, 'pr4QXSdeHJHNRiWlpyU', '2', 'pr4QXSdeHJHNRiWlpyU', '154563949421000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gCmWInaEWJmzcGch2x5', 'jkpTHKg7DpuXQrppVxx', null, 'smthlnru9z9qwavJKk1', '0', 'AHJzoQDdLpyRpZLTTdK', '155142353164200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('gcQxX2SsxhruSYmI3x2', '2jSs6cnzu4mzY9C13vF', null, 'EGz4qs5QI4fsCuCJwdc', '2', 'EGz4qs5QI4fsCuCJwdc', '155142339624900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gctckaJWhbMx2AwKHUV', '2jSs6cnzu4mzY9C13vF', null, 'kqrKj5I16CqjnePUq0G', '1', 'kqrKj5I16CqjnePUq0G', '155142339791800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('gD5WFkKJ74EvnxF66fk', '2ytUeoxBqghwofmBALl', null, 'zg2t1qqkaJ17B2vvX05', '0', '5YmlK5Wk3G3ZqIrhdzM', '154461618957000003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('GdCZIyX6FWzXXfm4c8L', 'kPLbeydkgiYW6NIkCt0', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'WVuL60fA6C1cUsSUk5t', '155168804599100002', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('GDmNmruTz5HuuCv7TFJ', 'kPLbeydkgiYW6NIkCt0', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155168804480500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gEpSHwZ5hdtEjEUlTYz', '2ytUeoxBqghwofmBALl', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'eIRDEeewznXKf3ktljY', '154461619039800002', 'HdPeBqYwJyFyjHkhZu3', '跳转', '43', '1');
INSERT INTO `t_permission` VALUES ('geySFiikeBvlH1XMzHQ', 'kPLbeydkgiYW6NIkCt0', null, 'LocWe3mm3K3vF1gdbgC', '2', 'LocWe3mm3K3vF1gdbgC', '155168804482100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('geZUOopfPu7SOUyOeI3', '0Q0LkJpfR1ejtO8rD3p', null, 'd1anhG9lkXM7xOEL0p0', '1', 'd1anhG9lkXM7xOEL0p0', '155168789370300005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('gFd3GGXIrCKfv9t8jG5', '2jSs6cnzu4mzY9C13vF', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '155142339737200002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('gFnqjgQ1gk2rQFFMBmP', '3tFw1boS5L9vXoJCr6Z', null, 'RwMAY2iXBOjVaNZzkcE', '2', 'RwMAY2iXBOjVaNZzkcE', '154563949460100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gfzSP9jUAy7xw0NU45p', '0Q0LkJpfR1ejtO8rD3p', null, 'iL3YpikkZUlruc5ai3D', '1', '2HH7snENERzvRumcFTa', '155168789351600000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('GgdB6jeOBQcoi2wogBv', '2jSs6cnzu4mzY9C13vF', null, 'U945OMsdX9fvzRjE7xG', '0', 'NNovnd63EkWs6jGCQgq', '155142339746600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('GGF0pPLNnGPujKbST8u', '0Q0LkJpfR1ejtO8rD3p', null, 'QuvtJrkqhNSzp7mN4R3', '2', 'QuvtJrkqhNSzp7mN4R3', '155168789301700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gGFptupOMCEJsFs5Bhv', '0Q0LkJpfR1ejtO8rD3p', null, '8BSYIj5kZKJjAD7IxkX', '2', '8BSYIj5kZKJjAD7IxkX', '155168789309500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('GggrKQVGcH8zHZAYo2Q', 'WB81MbCBolNg6XmE35M', null, '11e6-5ba8-b15f1285-a270-539aa660c6fc', '2', '11e6-5ba8-b15f1285-a270-539aa660c6fc', '155141104771500003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ggNo9VqT6nQcaw34Ww9', 'kPLbeydkgiYW6NIkCt0', null, 'L7O7fkCLsVh7KYd0RIy', '1', 'L7O7fkCLsVh7KYd0RIy', '155168804655300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ggTmEPTgJnX076iSMZz', '3tFw1boS5L9vXoJCr6Z', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'gjNDcP4lJlHlGCLsxRq', '154563949521000003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('gH741OWiBvl8Qe3KtNx', 'kPLbeydkgiYW6NIkCt0', null, 'tAYVkaJnHAdVuffzuOr', '2', 'tAYVkaJnHAdVuffzuOr', '155168804485200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gHCaK108WTdo6KO72aN', '2ytUeoxBqghwofmBALl', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'zQbdwHlWMKfQxZOw4TN', '154461619055400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('GhFRfMIRyGVQUcmloDm', 'jkpTHKg7DpuXQrppVxx', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'f4NDOEOVMi7vrgWjzz4', '155142353081500005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ghVcFXEiGnwad0LylUu', '2ytUeoxBqghwofmBALl', null, '8DmOHAVRvs3BblbhJoa', '1', 'b2wnjqSK0hVEGNix31k', '154461618935100001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('gHzKFywZMkxgYQjoddC', '3tFw1boS5L9vXoJCr6Z', null, '8q7uUoYo99jyzdLW3o5', '1', '8q7uUoYo99jyzdLW3o5', '154563949566300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('gIbkBHAxbWEPG32xV43', 'kPLbeydkgiYW6NIkCt0', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'vVMfrqzsYfwhMJonU2y', '155168804550700004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('gIBLbONR6TWp3aBJL5Z', 'kPLbeydkgiYW6NIkCt0', null, 'uiFkOAGeBPQyi2pQlVb', '2', 'uiFkOAGeBPQyi2pQlVb', '155168804508600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('GICkIKuAwWfhZrB5Uj7', 'jkpTHKg7DpuXQrppVxx', null, 'MsyfStEFzDcCB1VPbYJ', '1', 'MsyfStEFzDcCB1VPbYJ', '155142353143900004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('gIeuFGh4Pht60NGF6kb', '2ytUeoxBqghwofmBALl', null, 'IuPDe4Gm9occzflnrP0', '0', 'oD3WAF1Vtv6gB6lDCtv', '154461618974200003', 'HdPeBqYwJyFyjHkhZu3', '新窗口打开', '43', '1');
INSERT INTO `t_permission` VALUES ('giOufCvMKpPWolS6IQS', 'kPLbeydkgiYW6NIkCt0', null, 'IuPDe4Gm9occzflnrP0', '0', 'dSSZNfrsXOVhXvx7vOM', '155168804645900000', 'HdPeBqYwJyFyjHkhZu3', '页签打开', '43', '1');
INSERT INTO `t_permission` VALUES ('gIZs2Y5Ly9wuqMJVUcg', 'kPLbeydkgiYW6NIkCt0', null, 'LHgnhFx0bsvuS1fUhBi', '0', '0dtX4S7P4eplUre1uBL', '155168804567900000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Gj0HFG2oI12aVCMWTaW', 'kPLbeydkgiYW6NIkCt0', null, 'ry6uZqKmxro1UYtKquD', '2', 'ry6uZqKmxro1UYtKquD', '155168804468100004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Gj5bvsKS2VuaJSzwrpN', '2jSs6cnzu4mzY9C13vF', null, 'rUBAvMGr4fLCj7Wg0HQ', '2', 'rUBAvMGr4fLCj7Wg0HQ', '155142339621800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gJGvxxXjVHakocnu7mA', 'jkpTHKg7DpuXQrppVxx', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'Nmhce5xixb5FBPVv5dc', '155142353131400000', 'HdPeBqYwJyFyjHkhZu3', '此按钮不可见', '3', '1');
INSERT INTO `t_permission` VALUES ('GJXhCfZdGvGsJDgCwMk', '0Q0LkJpfR1ejtO8rD3p', null, 'zl3R26vYd12dQFRodMT', '2', 'zl3R26vYd12dQFRodMT', '155168789304800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gk9mhCDFpLaiXM0iT2x', 'WB81MbCBolNg6XmE35M', null, '11e6-53d6-9d864d4e-81f5-679a826556ce', '1', '11e6-563c-8a7f1762-91c5-cd8abd28b1f9', '155141105049100001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('gKItPUyaJ6UlkpwgejB', 'kPLbeydkgiYW6NIkCt0', null, 'EGmIBh1ogGUoD8df1rE', '1', 'K1Q7LwDo3Y9JWxc1O1W', '155168804667700001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('gknU3z1wzKvZXymKyZj', '2jSs6cnzu4mzY9C13vF', null, 'gUlSUpqhlS2ym2ijZAg', '1', '6vfobfgmvGLQuOe0b3s', '155142339674800001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Gkp5Oicf2ez8kCEEIP7', 'jkpTHKg7DpuXQrppVxx', null, 'OGMmff1QTZYqFk5vfeD', '1', 'OGMmff1QTZYqFk5vfeD', '155142353012900003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('gkSwCfNRaVWD3RyaEOw', '2ytUeoxBqghwofmBALl', null, '8q7uUoYo99jyzdLW3o5', '1', '8q7uUoYo99jyzdLW3o5', '154461619046000004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('GKt76bmy7CgTLs9OreO', 'jkpTHKg7DpuXQrppVxx', null, 'eKZqOwJmAFsUEwu0WfL', '1', '3jy9fTiYM0hwEHejpTu', '155142353037800003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('GKz1k6w2ay4IlPSaQpK', '3tFw1boS5L9vXoJCr6Z', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'd0K3kzFXs6sjokcwJ3u', '154563949577300004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('GLps82edqmWiVGFhBtn', '2jSs6cnzu4mzY9C13vF', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'TkN4G3lj2mZ4XOo0kVQ', '155142339871400002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Gm1mOCynCdpzvrpuZ3T', '2ytUeoxBqghwofmBALl', null, 'gkbm2C0NbCfu86GHkFh', '0', 'C06613mOoQKz6Rr0LIo', '154461618989800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('gMJB2ZMKh7AKtBWcJ1J', '2jSs6cnzu4mzY9C13vF', null, '2Icse0Cn99YRTQTZO3f', '1', '2Icse0Cn99YRTQTZO3f', '155142339891700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('GMKh4w1QQNHWHn1VTyj', 'kPLbeydkgiYW6NIkCt0', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'Iw7PqAhVcFRVUHnbbwR', '155168804611600003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('GmnIadawp2YFaXF7YVm', 'kPLbeydkgiYW6NIkCt0', null, 'IuPDe4Gm9occzflnrP0', '0', 'oD3WAF1Vtv6gB6lDCtv', '155168804645900001', 'HdPeBqYwJyFyjHkhZu3', '新窗口打开', '43', '1');
INSERT INTO `t_permission` VALUES ('gNERkDKKOZ45Mo07Bes', '2jSs6cnzu4mzY9C13vF', null, 'Jh68ppMt3QMha315Hi6', '0', 'xTW6bbE29gUdngFIb2q', '155142339745000002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('GoOz60fMG7vuj5URkK3', '2jSs6cnzu4mzY9C13vF', null, 'SiPTeSpUhRIqVgi1HW1', '0', 'LI7k2GDTP5VDdaobmtO', '155142339785600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('GOQUwJ57sEWZn5Ct2rK', '0Q0LkJpfR1ejtO8rD3p', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155168789303300004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gOVsLGRrREEtOon1mEs', '3tFw1boS5L9vXoJCr6Z', null, 'u9zN1C73prPrzriTtzg', '1', 'u9zN1C73prPrzriTtzg', '154563949616300003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Gp7ozfQ1j3NRQPJEsSR', '2jSs6cnzu4mzY9C13vF', null, 'yv2DP99h1j34cgCO1SZ', '2', 'yv2DP99h1j34cgCO1SZ', '155142339615600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('GpHg9KJyxESoEDW6ydq', '0Q0LkJpfR1ejtO8rD3p', null, 'k3Ro7OsGafHyoiDAeLl', '2', 'k3Ro7OsGafHyoiDAeLl', '155168789337600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gphztojlt4L2Qf71A3C', '0Q0LkJpfR1ejtO8rD3p', null, 'lOgu0Jvq0z5dlveyrnY', '0', '5XIqbMcQ6K0lFtVi4HZ', '155168789448300004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('GPnJd5mMwCjsmZQHZh2', 'TzxwQuzGAOCi1aTd7o1', null, 'qX2GQGpdWwGnelcjHZP', '2', 'qX2GQGpdWwGnelcjHZP', '154461643401400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('GPpoBF6AMzQ3PAMssUP', '2jSs6cnzu4mzY9C13vF', null, 'poalxIjVlN70WdVjfQq', '1', 'ZABfGox4xJSo5PMgCOr', '155142339901000005', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('GPxejf0ZW7IH7Z2n6sJ', '0Q0LkJpfR1ejtO8rD3p', null, 'kCeLKcebSzaR6kBjWoC', '2', 'kCeLKcebSzaR6kBjWoC', '155168789318900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gQ7iqLMIPKMyGB4PMgH', '3tFw1boS5L9vXoJCr6Z', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'iURMg4fbNkBkiB0qxra', '154563949505400005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('gRl8djmm1mxYrtGqoC4', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-55cf0395-91c5-cd8abd28b1f9', '2', '11e6-5619-55cf0395-91c5-cd8abd28b1f9', '155141104754300004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('GRp1MDJM74yywSyLcB0', '3tFw1boS5L9vXoJCr6Z', null, 'Z5slsKyCh5Eg2s6qSK5', '2', 'Z5slsKyCh5Eg2s6qSK5', '154563949438200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gRQ6cgdl7BexukWnZpR', '0Q0LkJpfR1ejtO8rD3p', null, '1hPCUYj6dx9rMn0NAlL', '2', '1hPCUYj6dx9rMn0NAlL', '155168789293900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('GrtEX58ImDXql06V49G', 'jkpTHKg7DpuXQrppVxx', null, 'qEKeS98EGXZh9qkxklB', '2', 'qEKeS98EGXZh9qkxklB', '155142352953600005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('grWFm4e9q248iSFQ76R', 'jkpTHKg7DpuXQrppVxx', null, 'lAUkIpgQSIZqQyttrB4', '1', 'g6HusIB9Lr81fIHCCp5', '155142353041000000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('gsfy7BrqnkyLAJZRxaB', 'WB81MbCBolNg6XmE35M', null, '11e6-5616-4f609ead-91c5-cd8abd28b1f9', '2', '11e6-5616-4f609ead-91c5-cd8abd28b1f9', '155141104783900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gsVHtYxUMHXoxX1KFrU', '3tFw1boS5L9vXoJCr6Z', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'd6qZunMLjwykDchDPZG', '154563949519500003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('gt2CDTjRTHZ3nbqnLVt', 'kPLbeydkgiYW6NIkCt0', null, 'gniImP2ug7E82S1WO0L', '1', 'gniImP2ug7E82S1WO0L', '155168804613100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('gTBHVMjbFjAxfQBdols', '0Q0LkJpfR1ejtO8rD3p', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'VMAbFQIQDDpyST1AhyZ', '155168789479500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('GTdOrYCNJVGwvliBhoh', '2jSs6cnzu4mzY9C13vF', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'QOEHg2MUz4Qp7kv5JyL', '155142339802800001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('GtEQdjzTdEFeDfmtwkp', '0Q0LkJpfR1ejtO8rD3p', null, '6esIc2fTAI9nAOoOZcp', '1', 'y5AHygdKnFROYRFfQuX', '155168789361000000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('gTljbDay0kHNlOGymlg', '2ytUeoxBqghwofmBALl', null, 'SAzJx5AkUZOJRct29BH', '0', 'x3O0Ifcwe8BqX5uhms5', '154461618886700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('GuauqrbjBWHJghjwV4E', '2ytUeoxBqghwofmBALl', null, '3gGNzYyE5dK9ogZidWA', '1', 'HbDOYiiIBcC1oYN30Kx', '154461619088200003', 'HdPeBqYwJyFyjHkhZu3', '保存', '4', '1');
INSERT INTO `t_permission` VALUES ('GudR7Rn98Nz16KNInJK', '3tFw1boS5L9vXoJCr6Z', null, 'IuPDe4Gm9occzflnrP0', '0', 'v6Do5TzCwJt7gNmEi1b', '154563949603800000', 'HdPeBqYwJyFyjHkhZu3', '弹出层打开', '43', '1');
INSERT INTO `t_permission` VALUES ('GUEe9jLicBLq2b5AsSu', '2jSs6cnzu4mzY9C13vF', null, 'qAcxhZ5mnoiohEBYD9G', '2', 'qAcxhZ5mnoiohEBYD9G', '155142339557800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gugBXM8U2SBIurJpKm7', '0Q0LkJpfR1ejtO8rD3p', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'wuWQttnDBKAz7kQ2UMs', '155168789484200002', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('GUICZJdGEI1wTdaq7GI', '0Q0LkJpfR1ejtO8rD3p', null, 'LSwQOY0mggQ0vy4752p', '0', 'PSPMnN2J3uJvKmrQ0mW', '155168789488900004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('GuqVt5Pgv6VAh7wwTCu', '0Q0LkJpfR1ejtO8rD3p', null, '7u0fRbpHrxopCyfgADs', '1', 'rjxMvPpz6S7x7f7eWEk', '155168789367200000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('guVpCWrlaPoXOteuOpN', 'jkpTHKg7DpuXQrppVxx', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'mJFtUs7KSNrMTt3W70z', '155142353158000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('GvHy0vdNWqslh3gdPOQ', '0Q0LkJpfR1ejtO8rD3p', null, 'fVc4y8aYlKHvUPNHpUz', '2', 'fVc4y8aYlKHvUPNHpUz', '155168789309500005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gvLxxeMAQjeF0H2v6Fj', '2ytUeoxBqghwofmBALl', null, 'J9uhQYSQWhPor4IvkOE', '0', 'KgFs9krHT2ZyBayTPo8', '154461618924200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('gWP3Mue46tCv6BEWOzm', 'WB81MbCBolNg6XmE35M', null, '11e2-11c4-3682572e-8481-bf43184b8d87', '0', '11e2-11c4-3682573d-8481-bf43184b8d87', '155141104819800000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('gWYbcrndBBNqXKquiam', 'WB81MbCBolNg6XmE35M', null, '11e2-5fb6-9a1cc7c4-b702-3f84c4cacb0d', '0', '11e4-ceb1-ba8ad06e-b2a1-b5b94c6fcd94', '155141104844800000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '导出Excel', '16', '1');
INSERT INTO `t_permission` VALUES ('gXfD5Pu0CEalpltaPJC', '0Q0LkJpfR1ejtO8rD3p', null, 'Cg51Ds07QnrIkV1ne95', '2', 'Cg51Ds07QnrIkV1ne95', '155168789320400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gXfopZrHz34LD57M6uT', '3tFw1boS5L9vXoJCr6Z', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'FoxNtE4HNjqsnne055E', '154563949575700005', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('Gxs41PYyOgvNsWC0C3G', '3tFw1boS5L9vXoJCr6Z', null, 'TqQZlnV3BVaRGCm4tXn', '1', 'TqQZlnV3BVaRGCm4tXn', '154563949488200005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('GXTCk2hOucBwF1arEZO', 'kPLbeydkgiYW6NIkCt0', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'IE1QRBOyhDRgkxFpUU2', '155168804539800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('gxw2owo1rihvhE6E4i8', '0Q0LkJpfR1ejtO8rD3p', null, '1fhgTUPecMY0ajlTkKZ', '0', 'UiotHIXmy0M1EdhhF8k', '155168789401500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('gY1z0kfLGkoufTbILau', 'WB81MbCBolNg6XmE35M', null, '11e6-55fd-b6c9bd17-bb59-b7243d4bcf51', '0', '11e6-55fe-2d011b42-bb59-b7243d4bcf51', '155141105005500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Gy9coili5rckrRQXB1p', '3tFw1boS5L9vXoJCr6Z', null, 'wwsNkkwFEvqL44gK2fM', '0', 'WbfBIyoU0AkbLY6hBur', '154563949514800003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('gYqgxOszKeXiX3HpYul', 'jkpTHKg7DpuXQrppVxx', null, 'pyZGNS3zwQ5ravJoqyj', '2', 'pyZGNS3zwQ5ravJoqyj', '155142352969200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('gYqjfmTp2804SYc5qW7', '2ytUeoxBqghwofmBALl', null, 'WHKujMuxTp67TYMu80o', '0', 'ti2S70c11piGDmryGEq', '154461619096000007', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('gYW715YQhnKgBwrTAej', '2ytUeoxBqghwofmBALl', null, 'F6reQ5BW7P6q236Pi13', '1', 'l8ljKs0dTA8uw1QTIcr', '154461619011700001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('GzaYT4GZxhBwCE0GNcW', 'kPLbeydkgiYW6NIkCt0', null, 'ty5ziZz2nDWVO0jHM22', '2', 'ty5ziZz2nDWVO0jHM22', '155168804525800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('GZBCK0VQwG8JUGd6rb1', '2ytUeoxBqghwofmBALl', null, '3gGNzYyE5dK9ogZidWA', '1', '7SBexLWqUvnu9vb48Vu', '154461619089800000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('gZcziH9yI8kh0ZWElCE', '2jSs6cnzu4mzY9C13vF', null, '7am5R9EPlSCV3gz3SZG', '2', '7am5R9EPlSCV3gz3SZG', '155142339554700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('GzDLtBObTboAb3MmvjQ', 'kPLbeydkgiYW6NIkCt0', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Ty33WfwAyTHWENnxPcQ', '155168804591300002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('gziVe3Xwp9DZ85sSXC1', 'jkpTHKg7DpuXQrppVxx', null, 'u9zN1C73prPrzriTtzg', '1', 'u9zN1C73prPrzriTtzg', '155142353150200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('GZVTVDkythp8ZyHNMJq', 'kPLbeydkgiYW6NIkCt0', null, 'jyd4rbIxoL6EKjtSVWC', '1', 'jyd4rbIxoL6EKjtSVWC', '155168804602200004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('gzZuLHXRi1TNi9KsF7m', 'jkpTHKg7DpuXQrppVxx', null, 'UW3rch1KdGhIyDrOLr6', '2', 'UW3rch1KdGhIyDrOLr6', '155142352987900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('h0gtOVqhT8AxChJv7TT', 'jkpTHKg7DpuXQrppVxx', null, '3gGNzYyE5dK9ogZidWA', '1', '1yFGNlNaVN83hKJQ7vt', '155142353114300001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('h0hHgv0y9qkplr1Xc4N', '0Q0LkJpfR1ejtO8rD3p', null, 'AKGX6zv2MUckrIYhVdz', '2', 'AKGX6zv2MUckrIYhVdz', '155168789307900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('H0k4rz0tDKwDZ7VhLnn', '2jSs6cnzu4mzY9C13vF', null, 'BrbFcB3ptMyxdPl5W6u', '0', '6DhnKNo54979AgvQSGH', '155142339854200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('H0XRTFEpk1dfTh5ya1f', '2ytUeoxBqghwofmBALl', null, 'vCWvTbPligxwrkrwAv8', '0', 'oyuPcAc1VAmt4JtNf7A', '154461619067900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('H1D1iTX4OGt0r1kfyWt', '3tFw1boS5L9vXoJCr6Z', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'vVMfrqzsYfwhMJonU2y', '154563949496000002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('H2324vQhA86vLlnwPdF', 'kPLbeydkgiYW6NIkCt0', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'ElTaDWYx8x0ksSxQW27', '155168804620900001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('H232DhPkZ10stDwZefw', '2ytUeoxBqghwofmBALl', null, 'fu3FPAvy3QbJl8Y96P7', '1', '5oWWmwFfmt1UTNzYcO7', '154461619039800004', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('h23xJXLWXW4cdHTq5Xx', '2jSs6cnzu4mzY9C13vF', null, 'u9zN1C73prPrzriTtzg', '1', 'u9zN1C73prPrzriTtzg', '155142339882300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('h28U3WZAOvhgFMaDky9', 'WB81MbCBolNg6XmE35M', null, '11e6-53e6-73b34240-81f5-679a826556ce', '1', '11e6-53e6-73b34240-81f5-679a826556ce', '155141105111500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('h3ADcki2LX7lggOVb9d', 'kPLbeydkgiYW6NIkCt0', null, 'enhnCZbrTQ1mZpn18o5', '0', 'iqufoXl2qzIWDFkt1Vi', '155168804635000001', 'HdPeBqYwJyFyjHkhZu3', '获取第一个查询条件的值', '1', '1');
INSERT INTO `t_permission` VALUES ('H3B6p6E9hG47gn9L11F', '3tFw1boS5L9vXoJCr6Z', null, 'EGz4qs5QI4fsCuCJwdc', '2', 'EGz4qs5QI4fsCuCJwdc', '154563949474100004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('H3k7CKNtc8df8nGjZKz', '2ytUeoxBqghwofmBALl', null, 'c8qqHIRjZCxEMPx5YoO', '1', 'c8qqHIRjZCxEMPx5YoO', '154461619052300004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('h3ztT9DAHYwBkTHrpdQ', '2ytUeoxBqghwofmBALl', null, 'XzgpTEte9Q1JQswSETz', '0', 'XLZiQKl894Jrpsbimx0', '154461619097600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('h4AX2PijQlnsKt4vtVc', 'kPLbeydkgiYW6NIkCt0', null, 'ZM7F9MjjscP8bADF7cH', '1', 's0ipQa9ktbRum255G0J', '155168804557000003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('h4fBJVk7s620upAVTQn', '0Q0LkJpfR1ejtO8rD3p', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'Zb272Z4FRc9su5s2Lik', '155168789463900002', 'HdPeBqYwJyFyjHkhZu3', '批量提交（图片图标）', '20', '1');
INSERT INTO `t_permission` VALUES ('h5Hal21DivplgZGEGPv', 'WB81MbCBolNg6XmE35M', null, '11e6-5e12-53a31e44-ae15-3d6b584ebd70', '2', '11e6-5e12-53a31e44-ae15-3d6b584ebd70', '155141104757400001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('H61kXpvIIOFs1XCGYXI', '2ytUeoxBqghwofmBALl', null, '5XKkpkend5hrAy8xWlc', '1', '5XKkpkend5hrAy8xWlc', '154461618950700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('H6BpOAesSKVnaD6C8zv', 'kPLbeydkgiYW6NIkCt0', null, 'vThTQ2M4QKScZTsYPVX', '2', 'vThTQ2M4QKScZTsYPVX', '155168804475900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('H6K8eBA6aeryKeyhbJZ', '2ytUeoxBqghwofmBALl', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'vVMfrqzsYfwhMJonU2y', '154461618944500003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('h6szIBouWKGvpHOwwbj', 'kPLbeydkgiYW6NIkCt0', null, 'Tm9KRBnKnzjuuld7bJh', '0', '5GCo50RaCJdscjJW16V', '155168804583500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('H7ghSEUHE4mTwM6oSXP', '2jSs6cnzu4mzY9C13vF', null, 'gkbm2C0NbCfu86GHkFh', '0', 'C06613mOoQKz6Rr0LIo', '155142339740400000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('h7pAND9SiMuwsz83J8E', 'kPLbeydkgiYW6NIkCt0', null, 'EKD2uh12ht0Vptz9xN5', '0', 'ThJH0AWU99Z8F5DDmUo', '155168804566300004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('h7T2K4n3MGrnz0idozV', '3tFw1boS5L9vXoJCr6Z', null, '1hPCUYj6dx9rMn0NAlL', '2', '1hPCUYj6dx9rMn0NAlL', '154563949425700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('h7YkRWTqBlDUXFtNQ8D', '2jSs6cnzu4mzY9C13vF', null, '5RzsvfgAUx2y0k1pDlg', '0', 'ukXAzRjE6lHNKWb0XN5', '155142339901000000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('H897iqVdRLGVwI6VcKb', '3tFw1boS5L9vXoJCr6Z', null, '0zSRHMqiyMTl1dth7ds', '1', 'hy32XOXaddLpvsHlLeY', '154563949496000004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('H8EwrdAOqKQxH0doCKc', '3tFw1boS5L9vXoJCr6Z', null, 'qqHbF4LC1qdUg1ak29k', '1', 'B3jWFwhgVoeriEcsKyv', '154563949494500000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('h8NHEYO0r4CJAwSBDWr', '2jSs6cnzu4mzY9C13vF', null, 'lbZDhonVIlyX0n0IKyu', '2', 'lbZDhonVIlyX0n0IKyu', '155142339554700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('H8qFt6JAo9LSXdukowM', '0Q0LkJpfR1ejtO8rD3p', null, '0bgD6IPDYyID2susbqZ', '0', 'qQ3GQtV2z6ogWiGsF2D', '155168789401500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('HA5ogGwQfdDvQ40jt0j', 'WB81MbCBolNg6XmE35M', null, '11e6-55fd-e3a84011-bb59-b7243d4bcf51', '1', '11e6-55fe-01b5bb59-bb59-b7243d4bcf51', '155141105008600001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('Ha7m5Z2BdnppQuAPEeS', 'kPLbeydkgiYW6NIkCt0', null, 'gUlSUpqhlS2ym2ijZAg', '1', '6vfobfgmvGLQuOe0b3s', '155168804550700002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('haAGsFOE3keegYl8ndM', 'jkpTHKg7DpuXQrppVxx', null, 'bVLnHAUMhdToxosd7nT', '0', 'yzBBJOTOG9lvHIAigYN', '155142353072200004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('hadBkb1buUqOyFWvFUx', 'kPLbeydkgiYW6NIkCt0', null, 'U1TygLjjsSxDfEoGwhc', '1', 'hdiqWVc1ZHENK9nuZv5', '155168804536700002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('HaLWVHBcq0guVoYHgU4', 'jkpTHKg7DpuXQrppVxx', null, 'vZjJlrJAj7XdNX3czmS', '0', 'SG77mlxdPhjGgtckCUZ', '155142353059700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('HAQEYqY69eVrtOrRSaW', '0Q0LkJpfR1ejtO8rD3p', null, '14PxjfoOE09shUfSg1l', '2', '14PxjfoOE09shUfSg1l', '155168789315700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('hASkqYuxj79ZWfN566F', '0Q0LkJpfR1ejtO8rD3p', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'Jbc2xwZhMLLNIjg0h02', '155168789375000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('hb0y2wP3fXTs58CQo0P', 'WB81MbCBolNg6XmE35M', null, '11e6-5615-b288f24f-91c5-cd8abd28b1f9', '2', '11e6-5615-b288f24f-91c5-cd8abd28b1f9', '155141104752700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HB31SGrh7gpVpyLkezB', '2ytUeoxBqghwofmBALl', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'kgw3nVgzE2lQ8Be6S1i', '154461619039800003', 'HdPeBqYwJyFyjHkhZu3', '关闭窗口', '8', '1');
INSERT INTO `t_permission` VALUES ('HBBzkAUGeEa41BtVYcS', 'jkpTHKg7DpuXQrppVxx', null, '98kmnnrWwGKmgyiIkUF', '0', 'mlTio0aN6W90Aant0Mk', '155142353061200000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('hbc4mO2GNV1EOPls0e3', '0Q0LkJpfR1ejtO8rD3p', null, '1QioSPqczT1xRrQBliu', '0', 'wIwBEaIp2kNiyXqGS2h', '155168789390600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('hbeEKO9GPZdw8D5l05v', '0Q0LkJpfR1ejtO8rD3p', null, 'YAsL41bmDXtb0dBUQcb', '2', 'YAsL41bmDXtb0dBUQcb', '155168789328200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HbI53VGIbnXFdIi4sKN', '2jSs6cnzu4mzY9C13vF', null, '5RZRK7Jt5vyqwlIccop', '1', 'n7ODSabeRv0h2pyGxhm', '155142339724800001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('hbkvX8Pr2WvYuih23qP', 'WB81MbCBolNg6XmE35M', null, '11e6-5618-c6a49f3e-91c5-cd8abd28b1f9', '2', '11e6-5618-c6a49f3e-91c5-cd8abd28b1f9', '155141104774600002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('hby9UNDGKIo8a9PduhU', 'WB81MbCBolNg6XmE35M', null, '11e6-5612-9d22272b-91c5-cd8abd28b1f9', '2', '11e6-5612-9d22272b-91c5-cd8abd28b1f9', '155141104749600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HC5mmwGYXKOrkzB4xxE', '3tFw1boS5L9vXoJCr6Z', null, 'w7IsSOtXFvo61cP8sKr', '1', '5CLK8GNJd4rBCvhU5Ge', '154563949547600002', 'HdPeBqYwJyFyjHkhZu3', '流程启动', '33', '1');
INSERT INTO `t_permission` VALUES ('hCfjE323aTCUSyOxMPQ', 'kPLbeydkgiYW6NIkCt0', null, 'bG7zmifAqOWLU6guwgi', '1', 'bG7zmifAqOWLU6guwgi', '155168804605300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('hCYfRT8j5LLfwxSmkAq', '3tFw1boS5L9vXoJCr6Z', null, 'GP2yEPcfqN4Gwg8M4Da', '2', 'GP2yEPcfqN4Gwg8M4Da', '154563949438200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('hDBJ4HBD3cYoSXIB40N', '2ytUeoxBqghwofmBALl', null, '5RZRK7Jt5vyqwlIccop', '1', '5RZRK7Jt5vyqwlIccop', '154461618966300003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('hDGe6ChDiUaeeD5aomz', 'WB81MbCBolNg6XmE35M', null, '11e6-8086-9ae48819-94e7-cf1302a16d88', '0', '11e8-3ef5-c606bcbb-9c36-67e77928d46b', '155141105144300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '导出Excel', '16', '1');
INSERT INTO `t_permission` VALUES ('hdQe2I3Qi5qnkz4PGRz', '2jSs6cnzu4mzY9C13vF', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'CJu3AVSi8NfqhFlu5jl', '155142339737200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('HdzN494zPbtGSKhlLKb', '2jSs6cnzu4mzY9C13vF', null, 'SaFhOUcZJcd0Kj5IodL', '2', 'SaFhOUcZJcd0Kj5IodL', '155142339609300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('he6hF1L18BXjeiJK2rT', 'kPLbeydkgiYW6NIkCt0', null, '4VkP5W8VPlERMiThvSD', '0', 'DKXXNVp1SE3PrcD4Mq2', '155168804597500002', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('hEAyDzhp5bFgyDxujEv', '0Q0LkJpfR1ejtO8rD3p', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '155168789389100003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('heGJ3SPtkusnfdEvF3r', 'WB81MbCBolNg6XmE35M', null, '11e6-54b7-721a8db1-9671-379f935a9949', '1', '11e6-54b7-721a8db1-9671-379f935a9949', '155141104907200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('HEI0kl1Mu7D2pQVbdPW', '0Q0LkJpfR1ejtO8rD3p', null, 'L7O7fkCLsVh7KYd0RIy', '1', 'L7O7fkCLsVh7KYd0RIy', '155168789473300004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('heiK987vaRKpBkTIfSK', 'jkpTHKg7DpuXQrppVxx', null, 'CuDZkkf1DSaMf5ST7bj', '1', 'CuDZkkf1DSaMf5ST7bj', '155142353101800004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('HEnlxXMtqLHnqAzWps1', '2jSs6cnzu4mzY9C13vF', null, 'g2XzgmKDL1T8UB79GZh', '0', '8yld9hcbZOKvZi6xp2Q', '155142339852700001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('hEoAUDUXmxTklQtRrsN', '2jSs6cnzu4mzY9C13vF', null, 'zg2t1qqkaJ17B2vvX05', '0', '5YmlK5Wk3G3ZqIrhdzM', '155142339860500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('heOHDB7PWrXquhfePMs', 'jkpTHKg7DpuXQrppVxx', null, 'ddbeKTjs0WvqKVJ90MU', '1', '5fbpm1XlYeZn8KXFMNL', '155142353031600002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('hEs4JOeah8VS3BPVDIr', '3tFw1boS5L9vXoJCr6Z', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'wgw8EmPgt7pl1vVHHdz', '154563949505400004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('HEZ6eQfM9oxh7RnvDaC', '2jSs6cnzu4mzY9C13vF', null, 'Tm9KRBnKnzjuuld7bJh', '0', 'k0TYCIl1oBQF4xUGHYE', '155142339760600000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('heZPem527HskpmbO7nh', 'jkpTHKg7DpuXQrppVxx', null, 'lOgu0Jvq0z5dlveyrnY', '0', 'eq15KrpMbnefCOE2bGq', '155142353109600005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('hF1pmZL2jIzoUQyeZX2', '2jSs6cnzu4mzY9C13vF', null, 'tAYVkaJnHAdVuffzuOr', '2', 'tAYVkaJnHAdVuffzuOr', '155142339573400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HFHS93njeMCGB6H3wpj', 'jkpTHKg7DpuXQrppVxx', null, 'WOmzvkui5ZsoZu1CogR', '1', 'GtjuDeHrOcWix1W5qZC', '155142353087800001', 'HdPeBqYwJyFyjHkhZu3', '签章', '46', '1');
INSERT INTO `t_permission` VALUES ('HgaBusutnRToXIPOkKJ', '3tFw1boS5L9vXoJCr6Z', null, 'Jzy7zZItDzniSSkL6fQ', '2', 'Jzy7zZItDzniSSkL6fQ', '154563949463200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('hGAWsR2dtuOnfXhyWbC', '2ytUeoxBqghwofmBALl', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Z3JLytYNIhmUl9AqEci', '154461619033500004', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('hgSBehAi9XdRkTAuLGs', 'kPLbeydkgiYW6NIkCt0', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'kYjMqLc40QkdYGXLHWO', '155168804610000004', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('HGvPuuXBBNviLOVoO09', 'WB81MbCBolNg6XmE35M', null, '11e6-5303-7920361b-a13d-c75d0a89256c', '1', '11e6-d15e-749d1054-bbdd-9f7a0eebced4', '155141104883800001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('HgZCVb5cri8nrCdl5Kz', 'WB81MbCBolNg6XmE35M', null, '11e6-5489-8ff2b70c-9671-379f935a9949', '0', '11e6-5489-a9ecf45a-9671-379f935a9949', '155141105072500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('hH9Hq5gXRV6j1IXMTc4', '0Q0LkJpfR1ejtO8rD3p', null, 'MIExqx2MWO5cunDiuaX', '1', 'BjLpkwnLuJNx6aokoma', '155168789367200004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('hhbC0dvEBc2ezyHqrzP', '2ytUeoxBqghwofmBALl', null, 'g2XzgmKDL1T8UB79GZh', '0', '1uOt5KaDxl3ZK3OT1Mw', '154461619092900000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('HHfPVhLhj84qfpM350l', 'WB81MbCBolNg6XmE35M', null, '11e6-5476-94a8e7ab-9671-379f935a9949', '1', '11e6-d160-0ab2bbe7-bbdd-9f7a0eebced4', '155141105071000001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('HHLtCNccFXRyZRupPAE', '0Q0LkJpfR1ejtO8rD3p', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'kgw3nVgzE2lQ8Be6S1i', '155168789412500003', 'HdPeBqYwJyFyjHkhZu3', '关闭窗口', '8', '1');
INSERT INTO `t_permission` VALUES ('hhTAjKI0UK1QV3r7ZqY', 'WB81MbCBolNg6XmE35M', null, '11de-a1c6-fdf40dd0-a188-7710f5ef0f5e', '1', '11de-a1c6-fdf40dd0-a188-7710f5ef0f5e', '155141104835400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('HHWqloQT5HLYYnnBHX7', 'WB81MbCBolNg6XmE35M', null, '11de-a1ce-12978c3f-a188-7710f5ef0f5e', '1', '11de-a1ce-12978c3f-a188-7710f5ef0f5e', '155141104808900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('hhzATerOaqcj9i1Vaya', 'kPLbeydkgiYW6NIkCt0', null, 'QB2YTfQBMnrttSiZNeP', '2', 'QB2YTfQBMnrttSiZNeP', '155168804493000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('hi0tp7XB1k8i9dB0kHM', '2ytUeoxBqghwofmBALl', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '154461619005400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Hi6RvT4bqd4FYDD2TkZ', '0Q0LkJpfR1ejtO8rD3p', null, 'JJCy9khz1JRwqvX4xEI', '0', '58H52uh4rkjC2i1d2jE', '155168789379700003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('HIFwb12oDC4QfBa6sMB', 'WB81MbCBolNg6XmE35M', null, '11de-7665-e571fab8-8d52-0547317ddd4c', '1', '11de-7b44-b482b1a5-8e75-5db8009a65bb', '155141105134900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('hIHTabUXvnz0gMRIRGs', 'kPLbeydkgiYW6NIkCt0', null, 'qqHbF4LC1qdUg1ak29k', '1', 'B3jWFwhgVoeriEcsKyv', '155168804549200001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('HIIR6o64QKEUfxLUtI1', '0Q0LkJpfR1ejtO8rD3p', null, 'gHKBmQ7kx8ThwKaSbuk', '2', 'gHKBmQ7kx8ThwKaSbuk', '155168789312600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HirfoIw2BgWg40oabwp', '3tFw1boS5L9vXoJCr6Z', null, 'b76ggxFJ4XBOIQkmVoY', '2', 'b76ggxFJ4XBOIQkmVoY', '154563949419500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('hiYIAAt2U6an87z6BZS', '2jSs6cnzu4mzY9C13vF', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'ElTaDWYx8x0ksSxQW27', '155142339838600001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('hjtC5Z0QuUEuQxJbWTr', 'jkpTHKg7DpuXQrppVxx', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'vVMfrqzsYfwhMJonU2y', '155142353026900002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('hJu5NI9ZvgiWQlrvs2k', '2ytUeoxBqghwofmBALl', null, 'eLFjqFngRQrIkbsdeBd', '1', 'UZzpqQ3lo5RbuYNWbsL', '154461619124200001', 'HdPeBqYwJyFyjHkhZu3', 'pdf导出', '25', '1');
INSERT INTO `t_permission` VALUES ('hJuuNkcckSDwvGWIb7C', '2ytUeoxBqghwofmBALl', null, 'LSwQOY0mggQ0vy4752p', '0', 'GrfqbEO7sjk3s3xGl3W', '154461619149200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('HJUzBwm6Geq7iVV6SlQ', '2ytUeoxBqghwofmBALl', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'Jbc2xwZhMLLNIjg0h02', '154461618967900007', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('hJxsD9abGfLtq3jJbIo', 'jkpTHKg7DpuXQrppVxx', null, 'rfmGjP7LXiQfxy15izp', '1', '5RmGeLAjzOblugQN5jG', '155142353111200001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('hKUarSbOxbBuoxIbPpZ', '2jSs6cnzu4mzY9C13vF', null, 'A6EMGp4mkUqLbMGLtql', '0', 'z1cc7dNuc4Vg60yjjLM', '155142339796500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Hl5p6lU3CKGqKizV2Wy', '2ytUeoxBqghwofmBALl', null, '3gGNzYyE5dK9ogZidWA', '1', '1yFGNlNaVN83hKJQ7vt', '154461618922600005', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('hlb9z6L9uFofWzoGBKd', 'kPLbeydkgiYW6NIkCt0', null, '6r0MsymflCeuD0Rrz4G', '2', '6r0MsymflCeuD0Rrz4G', '155168804466500005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HLoI3r2zjyPtv2JSxiQ', '0Q0LkJpfR1ejtO8rD3p', null, 'eKZqOwJmAFsUEwu0WfL', '1', 'eKZqOwJmAFsUEwu0WfL', '155168789368800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('hLz4suo3cwekNIykCSV', 'jkpTHKg7DpuXQrppVxx', null, 'QKYvQ00K4tWyyjKycUC', '0', 'vDCiwAlHhexzsJITERJ', '155142353114300004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Hlzcw5J6YqffbD5u8Fd', '0Q0LkJpfR1ejtO8rD3p', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'd0K3kzFXs6sjokcwJ3u', '155168789445200003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Hm0dXYAy1hPlITTzoQ4', 'jkpTHKg7DpuXQrppVxx', null, 'AeQX2k6Or75tfUuty4K', '2', 'AeQX2k6Or75tfUuty4K', '155142352977000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HmgHkHcsGNNLGXysv8j', '2ytUeoxBqghwofmBALl', null, '3K4lxgBhBLAbzJrfYaB', '1', 'j2jPRJ7cK9BqO2p9iP9', '154461619107000002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('hN6xwK4v2SZpYRTdmOy', 'kPLbeydkgiYW6NIkCt0', null, 'kqrKj5I16CqjnePUq0G', '1', 'kqrKj5I16CqjnePUq0G', '155168804603800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('HnD5t6mBz3KkwIYJ3gJ', '2ytUeoxBqghwofmBALl', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'FoxNtE4HNjqsnne055E', '154461619064800003', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('hNQckOPRRlzFvm6qBdl', 'kPLbeydkgiYW6NIkCt0', null, '6esIc2fTAI9nAOoOZcp', '1', 'qXsymSHvIPzVV0lWwQe', '155168804553900003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('HOLVcD8tMCfwftT8woI', 'jkpTHKg7DpuXQrppVxx', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'cY4kl4aBnqojbhnxddX', '155142353106500004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('homh31eYl4wifAIjN9g', '3tFw1boS5L9vXoJCr6Z', null, '6bUPlXeVH92MIv7Nmdw', '1', 'qPbgIDRXTjRZoXpvZJl', '154563949494500004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('HoRV5dLBz1QYuE2jsAF', '3tFw1boS5L9vXoJCr6Z', null, 'LHgnhFx0bsvuS1fUhBi', '0', '0dtX4S7P4eplUre1uBL', '154563949513200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('hp6hmRFgQccX15nmkqy', '2jSs6cnzu4mzY9C13vF', null, '5XKkpkend5hrAy8xWlc', '1', '5XKkpkend5hrAy8xWlc', '155142339692000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('hpetEiNyf1xHNMt18Jg', '2jSs6cnzu4mzY9C13vF', null, 'bKWrnsYGUGaqqYqkeeO', '0', '23XpTvLhb5XEzINSZHU', '155142339910400001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('HPITfriHudPj8BsODsu', 'jkpTHKg7DpuXQrppVxx', null, 'YAsL41bmDXtb0dBUQcb', '2', 'YAsL41bmDXtb0dBUQcb', '155142352992600005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HPl6AlxPmKRrzC5PGJl', '2ytUeoxBqghwofmBALl', null, 'ZM7F9MjjscP8bADF7cH', '1', 'aN0KA8MmhVB1LjOqtWo', '154461618952300003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('HPmw8RjjWGlzoNOr2pQ', '0Q0LkJpfR1ejtO8rD3p', null, 'dtXU9EYYl4qLe8PdIVc', '0', 'k1Bk7XRgKJ0522NyIQs', '155168789385900001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('HPyE9qmL1Tba6u3KQ9c', '0Q0LkJpfR1ejtO8rD3p', null, '9ppSV2PIKNhHCOwufvI', '0', 'Qbqk2LB86r3acRInIHN', '155168789462400001', 'HdPeBqYwJyFyjHkhZu3', '刷新', '1', '1');
INSERT INTO `t_permission` VALUES ('HQDDARS6pF4foAEURwp', '0Q0LkJpfR1ejtO8rD3p', null, '4oavihvP4J8cXDsWDIP', '0', 'FRLJFxdshvQAeKmHSfM', '155168789448300003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('hqhJbuYX4Zr9veF1XHR', 'jkpTHKg7DpuXQrppVxx', null, 'GP2yEPcfqN4Gwg8M4Da', '2', 'GP2yEPcfqN4Gwg8M4Da', '155142352963000005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HQp3vhwAXG4p5bmL8lA', '0Q0LkJpfR1ejtO8rD3p', null, 'Jh68ppMt3QMha315Hi6', '0', 'xTW6bbE29gUdngFIb2q', '155168789384400003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('hqrJgV5q5hysorzZ3Pg', 'jkpTHKg7DpuXQrppVxx', null, 'm8moRuOLRGU8fSbCIty', '0', 'Z6h9QsC5gMpu1hmPip2', '155142353012900005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('hQvHlLX5VfFx0E6eMeA', 'WB81MbCBolNg6XmE35M', null, '11e6-54c0-6df9a554-9671-379f935a9949', '1', '11e6-54c0-6df9a554-9671-379f935a9949', '155141104908700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('hQxRcneNaGstQeQxdXg', '3tFw1boS5L9vXoJCr6Z', null, 'WOmzvkui5ZsoZu1CogR', '1', 'yJFj2Hn06m1lkC7swux', '154563949553800001', 'HdPeBqYwJyFyjHkhZu3', '通过邮件或短信通知', '37', '1');
INSERT INTO `t_permission` VALUES ('hr4KHUfahtWHkjKjLvw', 'kPLbeydkgiYW6NIkCt0', null, 'JUpr2SmaIGVASTdp53r', '2', 'JUpr2SmaIGVASTdp53r', '155168804474300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HRAwvbUE27gdgLhhptg', 'kPLbeydkgiYW6NIkCt0', null, 'sMlqIILsNZ3bvqE2hSm', '1', '7gZkOqMaP3BBCXPapf5', '155168804538300003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('HRBJBSfjhLWw49LxHXl', 'jkpTHKg7DpuXQrppVxx', null, '3K4lxgBhBLAbzJrfYaB', '1', 'iYGmCNLDOISoDmNMi4d', '155142353167300002', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('hrgLAG7BpwqaiMwwI6v', '2ytUeoxBqghwofmBALl', null, 'vZjJlrJAj7XdNX3czmS', '0', 'Mk4H4HSkj1saDLiahVH', '154461618994500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('hRMjY9Zz2xKxeZxBzXV', '3tFw1boS5L9vXoJCr6Z', null, 'wjPLVvwWYR2a9BOi0st', '0', 'cV9hNfWQ2CjjMiWBnt2', '154563949572600005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('hrP0VFI1aUfBBRkXLa9', 'kPLbeydkgiYW6NIkCt0', null, 'jYDgN5WH46paTNLcCqi', '0', 'MfAD53jYG4vMOBrhLRM', '155168804597500004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('HrQAZ2StOWkpLFJ36nf', '2jSs6cnzu4mzY9C13vF', null, 'kcMdjikNe3R1UmNMZPB', '2', 'kcMdjikNe3R1UmNMZPB', '155142339626500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Hrw0aRNQODhEe1Wu02C', 'kPLbeydkgiYW6NIkCt0', null, 'UmMnr5J8RhgknR3Dsos', '0', 'gxzuym0IWRzScvUoUk7', '155168804585100004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('HScXrEYWhNssE84NY6j', '2jSs6cnzu4mzY9C13vF', null, '06Me4ssjoGBiKz0gMK2', '0', 'ZEh1qpMCAgYe10KWd1j', '155142339885400002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('HsqOICG18OZjXXJLz5S', '2jSs6cnzu4mzY9C13vF', null, 'JJCy9khz1JRwqvX4xEI', '0', '58H52uh4rkjC2i1d2jE', '155142339741900000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('HSsNndMNaVufypSy8xd', '0Q0LkJpfR1ejtO8rD3p', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Ty33WfwAyTHWENnxPcQ', '155168789407800001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('htCJnnCXPKgnoXl7aQ2', '3tFw1boS5L9vXoJCr6Z', null, '6bUPlXeVH92MIv7Nmdw', '1', 'RUXaoNPGKk4u8FtSPTh', '154563949494500005', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('HTICMTwpb6SNKkErZjz', '2jSs6cnzu4mzY9C13vF', null, 'QfirpboG4MjuFdj8mbs', '2', 'QfirpboG4MjuFdj8mbs', '155142339562500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HTjXf1kbIc9XVXirRJS', 'WB81MbCBolNg6XmE35M', null, '11e6-53c1-c45f44a1-81f5-679a826556ce', '1', '11e6-53c1-c45f44a1-81f5-679a826556ce', '155141104936800000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('HTqoCEHAQuOmIiv6uog', 'WB81MbCBolNg6XmE35M', null, '11e6-53a7-e48bf523-81f5-679a826556ce', '1', '11e6-d15e-da8e52cb-bbdd-9f7a0eebced4', '155141105186400001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('hUdyGbdXdDeksSguQV2', 'kPLbeydkgiYW6NIkCt0', null, 'gkbm2C0NbCfu86GHkFh', '0', 'C06613mOoQKz6Rr0LIo', '155168804567900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('HUGqeXfGNRpzduhyJ2s', 'jkpTHKg7DpuXQrppVxx', null, 'ir2OPEdZvttSUxAzfmD', '1', 'ir2OPEdZvttSUxAzfmD', '155142353017600005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('huRlQxKPqFMjKn91coe', '2jSs6cnzu4mzY9C13vF', null, 'qEKeS98EGXZh9qkxklB', '2', 'qEKeS98EGXZh9qkxklB', '155142339551600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HUWNechk0Magg4KAfBA', 'jkpTHKg7DpuXQrppVxx', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'IE1QRBOyhDRgkxFpUU2', '155142353017600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('HvB2hKTnyN5XI6vQpJL', 'kPLbeydkgiYW6NIkCt0', null, 'bJ9sgpEHjmdZEsbMwIM', '2', 'bJ9sgpEHjmdZEsbMwIM', '155168804519500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('HVcJtAraqBjsf06zT7m', 'WB81MbCBolNg6XmE35M', null, '11e6-53c0-961da43a-81f5-679a826556ce', '0', '11e6-53c1-0f57bae7-81f5-679a826556ce', '155141105181700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新增', '2', '1');
INSERT INTO `t_permission` VALUES ('HvixoqumBG1lvunqiig', '2ytUeoxBqghwofmBALl', null, 'eLFjqFngRQrIkbsdeBd', '1', 'laHgljUkGTSlRpd6Sbl', '154461619128800002', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('HVljWqOqtK9AExHj3o0', '0Q0LkJpfR1ejtO8rD3p', null, 'F6reQ5BW7P6q236Pi13', '1', 'l8ljKs0dTA8uw1QTIcr', '155168789471700000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('HWzRGg0FlTCuI0LBzzz', '2jSs6cnzu4mzY9C13vF', null, '7giYu3zk1hrdILU9eCl', '2', '7giYu3zk1hrdILU9eCl', '155142339618700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('hxUp7RGFjvbus5w2Afe', 'jkpTHKg7DpuXQrppVxx', null, 'eLFjqFngRQrIkbsdeBd', '1', 'UZzpqQ3lo5RbuYNWbsL', '155142353145500002', 'HdPeBqYwJyFyjHkhZu3', 'pdf导出', '25', '1');
INSERT INTO `t_permission` VALUES ('HyBp7PCUFXkvPPO1PtH', '3tFw1boS5L9vXoJCr6Z', null, 'g2XzgmKDL1T8UB79GZh', '0', '8yld9hcbZOKvZi6xp2Q', '154563949588200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('hyTwkLiL4VnEgZva7E9', '0Q0LkJpfR1ejtO8rD3p', null, 'ZM7F9MjjscP8bADF7cH', '1', 'ZM7F9MjjscP8bADF7cH', '155168789364100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('hYYzIUNirC2LqeyIPtR', 'kPLbeydkgiYW6NIkCt0', null, '1QioSPqczT1xRrQBliu', '0', 'wIwBEaIp2kNiyXqGS2h', '155168804575700004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('hzBDbHwau1O2gIFSTW8', 'kPLbeydkgiYW6NIkCt0', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'gUlSUpqhlS2ym2ijZAg', '155168804550700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('hZGlDmS5DaVmj9SnDsC', '2jSs6cnzu4mzY9C13vF', null, '6esIc2fTAI9nAOoOZcp', '1', 'qXsymSHvIPzVV0lWwQe', '155142339684200002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('hZsMyFqiQTX9uEBdhCd', 'jkpTHKg7DpuXQrppVxx', null, '7NlGpNC1MAEM6EuX2X0', '1', '7NlGpNC1MAEM6EuX2X0', '155142353167300003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('HzTUBH2ba8Uu2QhMATZ', 'kPLbeydkgiYW6NIkCt0', null, 'ECNTZk993cE71dxVqsx', '2', 'ECNTZk993cE71dxVqsx', '155168804510200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('i0ik4FAtVVRILXeBkcG', 'WB81MbCBolNg6XmE35M', null, '11e6-53f3-57372a15-81f5-679a826556ce', '1', '11e6-d15f-bfe9afbf-bbdd-9f7a0eebced4', '155141104971100001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('i0KQOaSN9gaiZT3KuSi', '3tFw1boS5L9vXoJCr6Z', null, 'XOjVSXTJxQ9WnTO8TmN', '1', 'XOjVSXTJxQ9WnTO8TmN', '154563949510100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('I1R1KtnCsYBo6dHhCJi', 'WB81MbCBolNg6XmE35M', null, '11e6-561a-b4b10fdf-91c5-cd8abd28b1f9', '2', '11e6-561a-b4b10fdf-91c5-cd8abd28b1f9', '155141104765200003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('i1z5WmrGyzodrXsFtKQ', 'kPLbeydkgiYW6NIkCt0', null, 'qqHbF4LC1qdUg1ak29k', '1', 'DvqeT7614zNxx8M5zED', '155168804549200002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('I2ov1l6udYtcH1zfjf4', '0Q0LkJpfR1ejtO8rD3p', null, 'LHgnhFx0bsvuS1fUhBi', '0', '0dtX4S7P4eplUre1uBL', '155168789378100002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('i2Z9UTxKiJFzgkHPzcK', '2ytUeoxBqghwofmBALl', null, '6esIc2fTAI9nAOoOZcp', '1', '6esIc2fTAI9nAOoOZcp', '154461618947600003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('I33ifuIWR8FRSDr1ZyQ', 'kPLbeydkgiYW6NIkCt0', null, 'vO8pkCUFsC8T8Ur5qEn', '2', 'vO8pkCUFsC8T8Ur5qEn', '155168804494600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('i3KmTb6qpKMS60sd3fQ', '3tFw1boS5L9vXoJCr6Z', null, 'Ksfgm24NkZrnPIXYgay', '2', 'Ksfgm24NkZrnPIXYgay', '154563949460100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('I3Mn1FzKAjcjAW9jgpd', '2ytUeoxBqghwofmBALl', null, 'XzgpTEte9Q1JQswSETz', '0', 'XLZiQKl894Jrpsbimx0', '154461619144500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('i3rIWeFe9JL0jGkr45k', '2ytUeoxBqghwofmBALl', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'PX5hS2Svd6sudk7n9l9', '154461618933500001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('I40EUP4Vehtb4JJam6U', 'jkpTHKg7DpuXQrppVxx', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'VMAbFQIQDDpyST1AhyZ', '155142353154800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('I4FQsiAXRCIBcaQFjQ6', '3tFw1boS5L9vXoJCr6Z', null, '3gGNzYyE5dK9ogZidWA', '1', 'HbDOYiiIBcC1oYN30Kx', '154563949586600000', 'HdPeBqYwJyFyjHkhZu3', '保存', '4', '1');
INSERT INTO `t_permission` VALUES ('i4YEikPlogWgg519o6K', 'kPLbeydkgiYW6NIkCt0', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'xEBN59fWrxYULgpdRLy', '155168804538300002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('i5lgd4qotzPkE6mqTiR', 'kPLbeydkgiYW6NIkCt0', null, '74xpaQX1peQaya80WFh', '2', '74xpaQX1peQaya80WFh', '155168804491500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('I5qwFOpjt9fitPa8AKs', '2ytUeoxBqghwofmBALl', null, '4oavihvP4J8cXDsWDIP', '0', 'pwDWlADlB4vGrKVGIQc', '154461619067900006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('I5YVLvuGzsdw3JhiiAy', '2jSs6cnzu4mzY9C13vF', null, 'rfmGjP7LXiQfxy15izp', '1', 'dUQn2CkeHgHGnGsR8JC', '155142339834000002', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('I5z9QGN0ZFu7thLNFKt', '0Q0LkJpfR1ejtO8rD3p', null, 'hdMXKLI1XqTUYUrFniv', '0', '3EhqWBGmEEkub8qvOuy', '155168789457700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('I6wZpWIm9S6BSjpIQIs', '2ytUeoxBqghwofmBALl', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'f1qYzMAqsF7bNYJc4Xl', '154461618938200004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('i6XSvbDF6uZfHPsxwSY', '2ytUeoxBqghwofmBALl', null, '4oavihvP4J8cXDsWDIP', '0', 'pwDWlADlB4vGrKVGIQc', '154461618894500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('i7fvHJTj1XjTqwAyar3', 'jkpTHKg7DpuXQrppVxx', null, 'a2ZyD3z0DqPxaNXX6Zx', '0', 'XUVXBLmXG3ryVuGQfA9', '155142353072200005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('I7hfve8wcxjqTSkNrIx', '3tFw1boS5L9vXoJCr6Z', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'Iw7PqAhVcFRVUHnbbwR', '154563949577300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('I7N33MbYeIFPpVFWgk9', '0Q0LkJpfR1ejtO8rD3p', null, 's4T0yhSw1lIJMsiBfQa', '2', 's4T0yhSw1lIJMsiBfQa', '155168789322000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('I7uJTioLwGPVrFNHXTg', '2ytUeoxBqghwofmBALl', null, 'SAzJx5AkUZOJRct29BH', '0', 'wLzLCUPc9LuRRv9j8J3', '154461619066300006', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('i9GIwmx33Y5lloqMvKV', '2ytUeoxBqghwofmBALl', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'QOEHg2MUz4Qp7kv5JyL', '154461619061700000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('i9KgRLiLfvMSs2a9tBx', '2ytUeoxBqghwofmBALl', null, '6bUPlXeVH92MIv7Nmdw', '1', 'qPbgIDRXTjRZoXpvZJl', '154461618941300001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('i9SC5pKnJjDpklevEN1', '2jSs6cnzu4mzY9C13vF', null, 'F6reQ5BW7P6q236Pi13', '1', 'l8ljKs0dTA8uw1QTIcr', '155142339874500000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('i9vgwRGypygZPtDUh2n', '2jSs6cnzu4mzY9C13vF', null, 'D0geS9pQRj0wkmGMmBp', '2', 'D0geS9pQRj0wkmGMmBp', '155142339596800004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('iaEbo0N9eOMqFj7cor8', '0Q0LkJpfR1ejtO8rD3p', null, '5XKkpkend5hrAy8xWlc', '1', 'xHnChg1mK6MilHV4VCZ', '155168789362500004', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('iAH8EeSbxspkWvG9FLJ', 'kPLbeydkgiYW6NIkCt0', null, '3K4lxgBhBLAbzJrfYaB', '1', 'j2jPRJ7cK9BqO2p9iP9', '155168804677100001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('IaTo3Nsl1WPFq2bL0pk', '2jSs6cnzu4mzY9C13vF', null, 'Z5slsKyCh5Eg2s6qSK5', '2', 'Z5slsKyCh5Eg2s6qSK5', '155142339564100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('iBTJfPmJwBQKENfgcef', '2ytUeoxBqghwofmBALl', null, '4v5tmazbZwdNkJDYso5', '1', '4v5tmazbZwdNkJDYso5', '154461619074200005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('IBvTP0NFSCw1biRtYOt', '0Q0LkJpfR1ejtO8rD3p', null, 'Z5slsKyCh5Eg2s6qSK5', '2', 'Z5slsKyCh5Eg2s6qSK5', '155168789300100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('IbycmeogsQkZOpFif0s', 'kPLbeydkgiYW6NIkCt0', null, '5RzsvfgAUx2y0k1pDlg', '0', 'NgNicpt0mPuprqEMquB', '155168804674000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('iC0ENZ3e1bL1agZCCp2', '2ytUeoxBqghwofmBALl', null, '7NlGpNC1MAEM6EuX2X0', '1', '7NlGpNC1MAEM6EuX2X0', '154461619110100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('icF1weVKKc6jgoGOGPt', 'jkpTHKg7DpuXQrppVxx', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'P1pXLZ0kw9I6axwJEcd', '155142353023800002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('icyrZVCfhGBzbUVyS1X', '2jSs6cnzu4mzY9C13vF', null, 'mEHACJenoEKew2MDnRm', '1', 'mEHACJenoEKew2MDnRm', '155142339849600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ICzSzFR0mH0Ju7uXVVZ', 'WB81MbCBolNg6XmE35M', null, '11e6-55fd-5295e1d1-bb59-b7243d4bcf51', '1', '11e6-55fd-9cdf5e97-bb59-b7243d4bcf51', '155141105003900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('iD4IfkAjavOUbuZSt1E', '0Q0LkJpfR1ejtO8rD3p', null, 'LdUkdpc3EVM9iBygFMr', '0', 'aDMBVBnzRI5FgVJbQR2', '155168789428100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('idnAfiOmpFtLJoH6M1H', '3tFw1boS5L9vXoJCr6Z', null, 'gkbm2C0NbCfu86GHkFh', '0', 'hahOwfXx6ZmPFPMbyf8', '154563949514800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('iDSoonTMnPxoCXr1UzJ', '2ytUeoxBqghwofmBALl', null, 'yDZaeD0mt44iNjakHmE', '0', 'gOx8PapU5TCGaG1IcWs', '154461619028800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('iDZYcKkfNLRF91nzL8F', '2jSs6cnzu4mzY9C13vF', null, '06Me4ssjoGBiKz0gMK2', '0', '8Hhv2rO3YipCX5JageH', '155142339885400003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('iEcgWR8A3q5VzaZhaAl', 'kPLbeydkgiYW6NIkCt0', null, 'nTlBd4a4Vt8mtiTX41J', '0', '9e1x2YMVEFvz8YJOOtI', '155168804628700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('iEhASFKkMCLmTZNrl9Y', 'jkpTHKg7DpuXQrppVxx', null, 'XpNoNSLR8vialNcJDXq', '0', 'WadmhwRuII4JmFt4TYS', '155142353104900004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('IfXHLPiog3rYAuZ4pDo', '2jSs6cnzu4mzY9C13vF', null, 'oUGfBAkdjTsO2z22gYU', '2', 'oUGfBAkdjTsO2z22gYU', '155142339561000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ig0e3YvqGbVxz5kdfLu', 'WB81MbCBolNg6XmE35M', null, '11e6-53e0-0aeaac2d-81f5-679a826556ce', '1', '11e6-53e0-0aeaac2d-81f5-679a826556ce', '155141105120900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ig9nFqi94I2c7uzAMHC', 'kPLbeydkgiYW6NIkCt0', null, 'gPHUIa48Bpsz26fjjNA', '2', 'gPHUIa48Bpsz26fjjNA', '155168804502400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('IGfQwSNyLJdbi3ytlq9', '2ytUeoxBqghwofmBALl', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'Bd1tki9fxPhsf7tARcy', '154461619075700000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('IGJjNreh5tsZyROLDKR', 'jkpTHKg7DpuXQrppVxx', null, 'nTlBd4a4Vt8mtiTX41J', '0', 'E3J8OfymoQtKHIuFNMK', '155142353115800004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('iGm7p9vfee8VQhwfL0H', '2jSs6cnzu4mzY9C13vF', null, 'P8aW26pXrA6epiJLKX0', '1', 'P8aW26pXrA6epiJLKX0', '155142339793400005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ignhIyWbKoHmP8JZotP', '2jSs6cnzu4mzY9C13vF', null, 'yDZaeD0mt44iNjakHmE', '0', 'mYv5iZiU0TwoK4MWL6v', '155142339766900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('igP4BxOzXCZVyFcU9VV', 'kPLbeydkgiYW6NIkCt0', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Z3JLytYNIhmUl9AqEci', '155168804591300004', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('IgWbLeVVxX3gTUelY97', '3tFw1boS5L9vXoJCr6Z', null, 'AkuEixxtkMd7QuHLVOR', '2', 'AkuEixxtkMd7QuHLVOR', '154563949424100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('iHGwWDBjlQm1IpJuhbI', 'kPLbeydkgiYW6NIkCt0', null, 'A6EMGp4mkUqLbMGLtql', '0', 'jvS3grY0lQM6HRUV78H', '155168804606900004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('iHH1YI1ujLvjLNnuObs', 'jkpTHKg7DpuXQrppVxx', null, 'g7U0PGtN5bKYhwbka6s', '0', 'VXaTIyUn85r0Xf2ja64', '155142353065900003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('IhjHGLIyEjRJPlqy2sW', '2ytUeoxBqghwofmBALl', null, 'T9IoQKXjHSvxRXYM3L8', '1', '3X6cQR0K41HlNd3N5Ty', '154461618967900001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('IhrzUIHhY1t7L6Cve7Z', '2ytUeoxBqghwofmBALl', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'XG8ap7ffszErnf3ZYYp', '154461619057000004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('iIpO5lkM0E5lV7Hcyte', '2jSs6cnzu4mzY9C13vF', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155142339568800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('iIRn1c5IbJGXPE48N69', '3tFw1boS5L9vXoJCr6Z', null, 'eKZqOwJmAFsUEwu0WfL', '1', 'eKZqOwJmAFsUEwu0WfL', '154563949507000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('IJD9OVQkWIcxE8urw6x', 'kPLbeydkgiYW6NIkCt0', null, '6bUPlXeVH92MIv7Nmdw', '1', 'RUXaoNPGKk4u8FtSPTh', '155168804550700000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('IJi2UDzmvs0k06IF810', 'WB81MbCBolNg6XmE35M', null, '11e3-235b-96added8-825b-e3da92374d42', '0', '11e5-9418-2ae2a335-a810-fbcd742073f4', '155141104849500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('iJjvKTCgVOaQNBOfmOw', '2ytUeoxBqghwofmBALl', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'gjNDcP4lJlHlGCLsxRq', '154461619003800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('IJKR3gxFWrPq8kphyZP', '0Q0LkJpfR1ejtO8rD3p', null, 'fwj9yeT6AbfKtPOwtOM', '2', 'fwj9yeT6AbfKtPOwtOM', '155168789329800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ijvn1kTdKUNKXKF1Nho', '0Q0LkJpfR1ejtO8rD3p', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'SmYDAD9eEDzqIUvO99F', '155168789387500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('ik45S9ZlrHqqBx2IYjz', 'WB81MbCBolNg6XmE35M', null, '11e6-55fd-5295e1d1-bb59-b7243d4bcf51', '1', '11e6-55fd-5295e1d1-bb59-b7243d4bcf51', '155141105003900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ikHYpI8R0DDabcKdslS', '0Q0LkJpfR1ejtO8rD3p', null, 'eLFjqFngRQrIkbsdeBd', '1', 'FdZlsUl66zL94sGKwVe', '155168789476400000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('IKWhjTY2gvygJfPnRkN', '3tFw1boS5L9vXoJCr6Z', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'SAYbUm9awyQJXoJpDNc', '154563949550700001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Il0chZQYob9J9lhsIKX', '2jSs6cnzu4mzY9C13vF', null, '7fddj0hyGNlDYSZpyFZ', '1', '7fddj0hyGNlDYSZpyFZ', '155142339885400001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('il6dFgga9bH8AQ9mg4l', '3tFw1boS5L9vXoJCr6Z', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'TdjwkbcPtyWwzr47Pw5', '154563949491300001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('IM3H4s2ieNd5zTYGqXw', 'kPLbeydkgiYW6NIkCt0', null, 'rfmGjP7LXiQfxy15izp', '1', 'dUQn2CkeHgHGnGsR8JC', '155168804619400000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('ima7X4ryhUO9dpXEjRq', '2ytUeoxBqghwofmBALl', null, '9ppSV2PIKNhHCOwufvI', '0', 'KXsfuFCITnsqT6hE3Je', '154461619099200009', 'HdPeBqYwJyFyjHkhZu3', '导出', '16', '1');
INSERT INTO `t_permission` VALUES ('IMCEWcfAuCMWVO3gYWo', '0Q0LkJpfR1ejtO8rD3p', null, 'yv2DP99h1j34cgCO1SZ', '2', 'yv2DP99h1j34cgCO1SZ', '155168789328200004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ImGzZ3icCphDeXoQsl5', 'kPLbeydkgiYW6NIkCt0', null, 'rfmGjP7LXiQfxy15izp', '1', '5RmGeLAjzOblugQN5jG', '155168804617800001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('iN3t9yiGkqTrGpOcT8z', '3tFw1boS5L9vXoJCr6Z', null, '4wigakaNlnx6FakxlBQ', '2', '4wigakaNlnx6FakxlBQ', '154563949472600005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ina0GWIhgZrXNG0Fccz', 'kPLbeydkgiYW6NIkCt0', null, 'KQSVH3r5JbmIAoPEf1R', '0', 'FpCOlrvb0mWq2jRlD44', '155168804586600005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('INBDunnw4J7JMoezH50', 'WB81MbCBolNg6XmE35M', null, '11e3-235b-96added8-825b-e3da92374d42', '0', '11e4-ceb1-c5af7118-b2a1-b5b94c6fcd94', '155141104851000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '导出Excel', '16', '1');
INSERT INTO `t_permission` VALUES ('inGK1yhswyQRB5i7gdP', 'WB81MbCBolNg6XmE35M', null, '11e2-5faa-5a846059-b702-3f84c4cacb0d', '1', '11e2-5faa-5a846059-b702-3f84c4cacb0d', '155141104830700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('iNJzX7VUpcbmogm7AO6', '0Q0LkJpfR1ejtO8rD3p', null, 'wsNAf0ykJEwUgvGWWKN', '2', 'wsNAf0ykJEwUgvGWWKN', '155168789326700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('inUSZIyRVVxP1E7sarY', '2jSs6cnzu4mzY9C13vF', null, 'Q70cP6OyQI3YDJ10sz9', '2', 'Q70cP6OyQI3YDJ10sz9', '155142339587500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('IOaiYj1DrhFEuAvUdk9', 'kPLbeydkgiYW6NIkCt0', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'I5GJXxDs9LYwwqf4uQv', '155168804583500004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ioj3gdPDJo1vVuQa5do', '2ytUeoxBqghwofmBALl', null, '3gGNzYyE5dK9ogZidWA', '1', '7SBexLWqUvnu9vb48Vu', '154461618922600003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('IOQ1n4u1nhZ54ZGl1BM', '2ytUeoxBqghwofmBALl', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'WVuL60fA6C1cUsSUk5t', '154461619044500006', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('IOWWQPT71KyxIlTbdju', 'jkpTHKg7DpuXQrppVxx', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'LjTWOCClNPbDkDtAgoQ', '155142353126800001', 'HdPeBqYwJyFyjHkhZu3', '删除（字体图标红色 ）', '3', '1');
INSERT INTO `t_permission` VALUES ('Ipj93xcjCE4MR4r1yIp', '0Q0LkJpfR1ejtO8rD3p', null, 'eLFjqFngRQrIkbsdeBd', '1', 'SX3rVQxkpU96Pko5JDm', '155168789476400001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Iq54l7zWJJDp0BFThk4', 'kPLbeydkgiYW6NIkCt0', null, '0zSRHMqiyMTl1dth7ds', '1', 'hy32XOXaddLpvsHlLeY', '155168804550700006', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('iQb5OqZYArmHIUjASPY', 'jkpTHKg7DpuXQrppVxx', null, 'Tm9KRBnKnzjuuld7bJh', '0', 'k0TYCIl1oBQF4xUGHYE', '155142353073700004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('IqD9bBwkLY9wypQp5LW', 'jkpTHKg7DpuXQrppVxx', null, 'aA68dayjwAsKuH1y8yq', '2', 'aA68dayjwAsKuH1y8yq', '155142352983200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('iQdms7lmbT8m6iwak14', '3tFw1boS5L9vXoJCr6Z', null, 'dzJOLeIY4r6nbim6lou', '2', 'dzJOLeIY4r6nbim6lou', '154563949419500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('IQiSdPFaN6YzTEpyEmA', 'kPLbeydkgiYW6NIkCt0', null, '7NlGpNC1MAEM6EuX2X0', '1', '7NlGpNC1MAEM6EuX2X0', '155168804677100003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('iqQaarGkhllSWTWi6vW', '0Q0LkJpfR1ejtO8rD3p', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'JAAon6tsqZ7pmxzP2fn', '155168789463900003', 'HdPeBqYwJyFyjHkhZu3', '批量签章', '29', '1');
INSERT INTO `t_permission` VALUES ('iQQtaoeBrjULshftDSy', '3tFw1boS5L9vXoJCr6Z', null, 'IfoHRC8Rs6njW75HqiE', '1', 'IfoHRC8Rs6njW75HqiE', '154563949611600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('IRvJV2pjpJda4KJkQFN', '2ytUeoxBqghwofmBALl', null, 'yDZaeD0mt44iNjakHmE', '0', 'mYv5iZiU0TwoK4MWL6v', '154461619028800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Irx0DjUMyGrzO6XCm3d', 'jkpTHKg7DpuXQrppVxx', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'csKjmVnToONLiXzljYG', '155142353129900001', 'HdPeBqYwJyFyjHkhZu3', '执行后提醒', '3', '1');
INSERT INTO `t_permission` VALUES ('iS0NMKs30LPlIaIwZGp', '2jSs6cnzu4mzY9C13vF', null, 'JJCy9khz1JRwqvX4xEI', '0', 'uFtdRxVPySujVTqhxrx', '155142339741900001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('iS5EKKt2DL2s57IPc94', '0Q0LkJpfR1ejtO8rD3p', null, 'MIExqx2MWO5cunDiuaX', '1', 'MIExqx2MWO5cunDiuaX', '155168789367200003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ISoBReSM8XQk0qcjkAJ', '0Q0LkJpfR1ejtO8rD3p', null, 'blVc1BNkTRUvVGde7Pj', '2', 'blVc1BNkTRUvVGde7Pj', '155168789325100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ISV97M6h1sIdonfyNbL', '2jSs6cnzu4mzY9C13vF', null, 'qqHbF4LC1qdUg1ak29k', '1', 'vdYEg1wdkIfHULE2LzN', '155142339668600001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('isVhX3zRUvWvSqc8TKx', 'kPLbeydkgiYW6NIkCt0', null, 'PLiK5HYs3YFoECyyMBo', '2', 'PLiK5HYs3YFoECyyMBo', '155168804511700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('iT9HXqH4RRZnOMebu5C', '2jSs6cnzu4mzY9C13vF', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'iY5ypHvJGJTn6j3J2nC', '155142339813700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ItGsgMk0iKHu8P2oOr4', '0Q0LkJpfR1ejtO8rD3p', null, '1hPCUYj6dx9rMn0NAlL', '2', '1hPCUYj6dx9rMn0NAlL', '155168789293900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('iTHopjuFaBiHdapb2x8', 'jkpTHKg7DpuXQrppVxx', null, 'Kb6r6jvJBO7WdcyIqFH', '2', 'Kb6r6jvJBO7WdcyIqFH', '155142352966100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('itOuVfHEO1FhK4iqcRG', 'jkpTHKg7DpuXQrppVxx', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'd0K3kzFXs6sjokcwJ3u', '155142353108000001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('ItpLmdCEi85SjFpmxdJ', '2jSs6cnzu4mzY9C13vF', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'RXwhTRAzZSqsUpQc1NF', '155142339838600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('iu3eAYQ0PlAgA66pimD', 'WB81MbCBolNg6XmE35M', null, '11e6-54a1-8e46ef97-9671-379f935a9949', '1', '11e6-d160-4b2c78f3-bbdd-9f7a0eebced4', '155141105081900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('IUcMqtq4nuenJWSNUOu', '0Q0LkJpfR1ejtO8rD3p', null, 'Kb6r6jvJBO7WdcyIqFH', '2', 'Kb6r6jvJBO7WdcyIqFH', '155168789303300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('IuRZcDZyZbvrf9bS45H', '2jSs6cnzu4mzY9C13vF', null, 'TqQZlnV3BVaRGCm4tXn', '1', '7Cu3i9C1gOoAeAS2dAn', '155142339656100001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('ivaVB2omqDHjXFMqs1F', '2ytUeoxBqghwofmBALl', null, 'd1anhG9lkXM7xOEL0p0', '1', '54Ke6lqQKZqsRiIAuzU', '154461618966300001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('ivb4dUMlmoT4LOCFwnR', 'jkpTHKg7DpuXQrppVxx', null, 'qqHbF4LC1qdUg1ak29k', '1', 'DvqeT7614zNxx8M5zED', '155142353025400001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('ivSjfkWnUJEyq2egzF0', '3tFw1boS5L9vXoJCr6Z', null, 'J9uhQYSQWhPor4IvkOE', '0', 'KgFs9krHT2ZyBayTPo8', '154563949480400003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('IVtm6HFlHWux4Vcv1gq', '2ytUeoxBqghwofmBALl', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'IajyYUcsSuyg4dFRXdR', '154461619099200001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('iwdctLyrjFwwRyZRVBE', '2ytUeoxBqghwofmBALl', null, 'aGwWScnt2f6X87bV5u9', '1', '4LdvPBnK70nLgMp5OzH', '154461618963200004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('iwfh9PXLfqih9md2THy', 'kPLbeydkgiYW6NIkCt0', null, '6bUPlXeVH92MIv7Nmdw', '1', 'qPbgIDRXTjRZoXpvZJl', '155168804549200005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('iwvCBoxMv06dOX9i3LB', '0Q0LkJpfR1ejtO8rD3p', null, 'Tm9KRBnKnzjuuld7bJh', '0', 'k0TYCIl1oBQF4xUGHYE', '155168789396900004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('IX29JVvqXzkBJUxKBE6', 'jkpTHKg7DpuXQrppVxx', null, 'PLiK5HYs3YFoECyyMBo', '2', 'PLiK5HYs3YFoECyyMBo', '155142352984800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('IX4g4A0mdHOjhrhVgDZ', '2jSs6cnzu4mzY9C13vF', null, 'U945OMsdX9fvzRjE7xG', '0', 'S1V13oV2ZMjKmg0oiLO', '155142339746600001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('IxFmfYTFY9XB1EtkgrI', '0Q0LkJpfR1ejtO8rD3p', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'TFCrC5zb0w6fDoq6icl', '155168789398400002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('IxHNo7fUkX5iQcb8Dij', '0Q0LkJpfR1ejtO8rD3p', null, '06Me4ssjoGBiKz0gMK2', '0', '8Hhv2rO3YipCX5JageH', '155168789478000004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('iXjZ0vvmyhNyg3Y3SVR', '2ytUeoxBqghwofmBALl', null, 'hdMXKLI1XqTUYUrFniv', '0', '3EhqWBGmEEkub8qvOuy', '154461619096000004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('IXmBz0jQiLFWpqmiV6V', '3tFw1boS5L9vXoJCr6Z', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'wKRxU5XodFTWQ3Od5v0', '154563949491300002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('ixqDPhBkjEAJWPpcb3X', '3tFw1boS5L9vXoJCr6Z', null, 'taWpyKypy5rBhloCotj', '2', 'taWpyKypy5rBhloCotj', '154563949438200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('iXtvbqwkbpyRTpMLuel', 'kPLbeydkgiYW6NIkCt0', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K4IeXTdrXu7wZa0AkpH', '155168804561700001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('ixVFjwak3rQOBfDrnM2', 'jkpTHKg7DpuXQrppVxx', null, 'kYU5ffwtqGFdhsYDlG8', '2', 'kYU5ffwtqGFdhsYDlG8', '155142352953600006', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('IYkJOKQ2x7LnUTvffSz', 'kPLbeydkgiYW6NIkCt0', null, 'a7jp1Dm53YjlAwDWuws', '1', 'UFBBbyiSeV5fpFq1Apn', '155168804589700004', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('izinnuoD9FUuw9X18Wx', 'jkpTHKg7DpuXQrppVxx', null, 'HPxu0lHX6xisYxe5W5t', '2', 'HPxu0lHX6xisYxe5W5t', '155142352991000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('IZJ1bvJI8Lu1IvBb4gk', 'jkpTHKg7DpuXQrppVxx', null, 'cbE2ixGwPBn9lHk5RmS', '2', 'cbE2ixGwPBn9lHk5RmS', '155142352955200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('iZrWV6W2xIgCHqc8C5w', '0Q0LkJpfR1ejtO8rD3p', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'IE1QRBOyhDRgkxFpUU2', '155168789345400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('iZxDoyxfejYgv0fdrrC', '2jSs6cnzu4mzY9C13vF', null, 'NGN4SO4fu5S5XxULG4X', '1', 'NGN4SO4fu5S5XxULG4X', '155142339640500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('IZXoBNP7tF0rWtJS4uF', '0Q0LkJpfR1ejtO8rD3p', null, '53PLwEjsvlAXAnlixPb', '2', '53PLwEjsvlAXAnlixPb', '155168789331300004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('J0nJlnyOfwDt4Dze0OR', '2ytUeoxBqghwofmBALl', null, 'RZTAlFVXkUYpYm96zVo', '1', 'RZTAlFVXkUYpYm96zVo', '154461619138200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('j0PTnArVqKEvK3Ul1lC', 'WB81MbCBolNg6XmE35M', null, '11e6-560a-9badd0e9-91c5-cd8abd28b1f9', '2', '11e6-560a-9badd0e9-91c5-cd8abd28b1f9', '155141104780800004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('j0QT4jQuX5vqWIBnCWw', '2jSs6cnzu4mzY9C13vF', null, 'U1TygLjjsSxDfEoGwhc', '1', 'U1TygLjjsSxDfEoGwhc', '155142339642100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('J1zkw5sxpx63NqpX14y', '2jSs6cnzu4mzY9C13vF', null, '4mTMb4cMMoLDRa0FTzS', '2', '4mTMb4cMMoLDRa0FTzS', '155142339553200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('j1ZpsyQuyXf5h082LcS', '0Q0LkJpfR1ejtO8rD3p', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'Bd1tki9fxPhsf7tARcy', '155168789453000000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('j23NxemPqqOvCDZhkw2', 'jkpTHKg7DpuXQrppVxx', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'v5qY31shPwgs5BLkLlM', '155142353067500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('j34Ui5ex6Ou4hZaHk98', '2jSs6cnzu4mzY9C13vF', null, 'qU8WM5a2IVVudiqn38E', '1', 'qU8WM5a2IVVudiqn38E', '155142339795000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('j34Zk4UdPtBz4jaQwTc', '3tFw1boS5L9vXoJCr6Z', null, '2F75ZJJXk8564FkCLYA', '1', '2F75ZJJXk8564FkCLYA', '154563949497600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('J4ezwAseFK5wFsSAx95', '0Q0LkJpfR1ejtO8rD3p', null, 'a2ZyD3z0DqPxaNXX6Zx', '0', 'XUVXBLmXG3ryVuGQfA9', '155168789395300004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('J4lV6p80gHgjRXn9m5p', 'jkpTHKg7DpuXQrppVxx', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'TkN4G3lj2mZ4XOo0kVQ', '155142353139200001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('j4saZep7cqOCwHjjgrM', '2ytUeoxBqghwofmBALl', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'cY4kl4aBnqojbhnxddX', '154461619064800005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('J4uGLmjGofmqSVyaqmu', '2jSs6cnzu4mzY9C13vF', null, '0zSRHMqiyMTl1dth7ds', '1', 'cn2gajGsHOgYLGZkWvG', '155142339678000001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('J4UgPiVkiiirA813ivq', 'kPLbeydkgiYW6NIkCt0', null, 'YLmf4h3xwvzrU2wJmYU', '2', 'YLmf4h3xwvzrU2wJmYU', '155168804514900005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('J5BSLRpr07ZUfHILj8u', 'jkpTHKg7DpuXQrppVxx', null, '7u0fRbpHrxopCyfgADs', '1', 'rjxMvPpz6S7x7f7eWEk', '155142353034700003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('J5IzoDRcorxHHzLeHxL', 'jkpTHKg7DpuXQrppVxx', null, '4v5tmazbZwdNkJDYso5', '1', '4v5tmazbZwdNkJDYso5', '155142353158000004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('j5OH3iNKNECIAh9LdGG', 'kPLbeydkgiYW6NIkCt0', null, 'ezzP5oVH4ywB1HmiObF', '1', 'ezzP5oVH4ywB1HmiObF', '155168804605300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('J5s0YJBv7z0MN30Qk7T', 'jkpTHKg7DpuXQrppVxx', null, 'w7IsSOtXFvo61cP8sKr', '1', 'bdnOlGNgir39pNIV5w3', '155142353084600000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('J5TyFlhMCqtpKA2dJV0', 'jkpTHKg7DpuXQrppVxx', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'zEz94y8drV2wM7Sh0jS', '155142353048800001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('J8almvkc8kysDrpSllL', '0Q0LkJpfR1ejtO8rD3p', null, 'NGN4SO4fu5S5XxULG4X', '1', '3obNdvpJGlYwLE4U916', '155168789342300003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('j8eBnYN5wu0qFAAqGHK', '2ytUeoxBqghwofmBALl', null, 'IuPDe4Gm9occzflnrP0', '0', 'LFydu54akpsq9Y9sCQr', '154461619110100003', 'HdPeBqYwJyFyjHkhZu3', '载入其他视图', '1', '1');
INSERT INTO `t_permission` VALUES ('J95KIC5Bk218sQcbuVF', '2ytUeoxBqghwofmBALl', null, 'bG7zmifAqOWLU6guwgi', '1', 'bG7zmifAqOWLU6guwgi', '154461618811700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jAaoBw45xBLOC6sH8uh', 'kPLbeydkgiYW6NIkCt0', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'wKRxU5XodFTWQ3Od5v0', '155168804547600000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('jaDVlXmT2lWjA9X3oEb', '2ytUeoxBqghwofmBALl', null, 'LHgnhFx0bsvuS1fUhBi', '0', '0dtX4S7P4eplUre1uBL', '154461618975700001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('JAjej2WsSLov0FXKkoc', 'jkpTHKg7DpuXQrppVxx', null, '4VkP5W8VPlERMiThvSD', '0', 'x4yYcPQJrgbYvpcebr5', '155142353087800004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('jAuZUWtQuPZlHIKUXim', '2ytUeoxBqghwofmBALl', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'ZLGOtOxZGBCsfXYeK15', '154461618864800000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('jB6L3be4nVcUlNQsjSf', 'kPLbeydkgiYW6NIkCt0', null, 'rumve1swtYufxpvxfcC', '2', 'rumve1swtYufxpvxfcC', '155168804511700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('JbKSvXRmp5a7oab8GO6', '0Q0LkJpfR1ejtO8rD3p', null, 'U945OMsdX9fvzRjE7xG', '0', 'NNovnd63EkWs6jGCQgq', '155168789387500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('jbKUa2mpc4ZwuTTMIZN', '0Q0LkJpfR1ejtO8rD3p', null, 'DzqlEtg4JObApV7iWX8', '0', 'e6ZwAUd38TnujcTz0j9', '155168789403100004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Jbz4B4nZKhwjIrnDMHU', '2ytUeoxBqghwofmBALl', null, 'o4zdmPoNHMg5JK6m6dx', '0', '2MHj4CnPnbOb2UFuMQr', '154461619107000001', 'HdPeBqYwJyFyjHkhZu3', '执行前再确认', '3', '1');
INSERT INTO `t_permission` VALUES ('JbZk079hjHLK3JzKy0x', 'jkpTHKg7DpuXQrppVxx', null, 'Ps4ZZv1ZXK9RWgInE2I', '2', 'Ps4ZZv1ZXK9RWgInE2I', '155142352972300005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('jc1P6NTTb6MzOn49rK0', '0Q0LkJpfR1ejtO8rD3p', null, 'NGN4SO4fu5S5XxULG4X', '1', 'TrHax0MzDGsTz4DFUoo', '155168789342300002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('JC9cdYYqMOoGOSKNLgD', 'WB81MbCBolNg6XmE35M', null, '11de-a1d8-03df0a0e-a188-7710f5ef0f5e', '0', '11de-a1db-d209a261-a188-7710f5ef0f5e', '155141104822900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('jcAUp1EUUFl9nPdmArW', '0Q0LkJpfR1ejtO8rD3p', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'cHPexySH1L6Pf3IyNTH', '155168789440500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('JCLB3B47mW4eHFcHAay', 'kPLbeydkgiYW6NIkCt0', null, 'zg2t1qqkaJ17B2vvX05', '0', 'COoHnOHkHeviVNasUlf', '155168804633400002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('JCmBe2SFyiZpj6uJYLq', '3tFw1boS5L9vXoJCr6Z', null, 'kebFCC8mkGX3V1QEriK', '0', 'dsB4JOjIMnlpqITpAVO', '154563949630400005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('jcneXDCWI40EU780LeM', 'kPLbeydkgiYW6NIkCt0', null, 'P14ZGIv1IEdecUGGYYk', '2', 'P14ZGIv1IEdecUGGYYk', '155168804471200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('jcouAIvQM25wY4Yq2HP', '2ytUeoxBqghwofmBALl', null, 'TU5YGgO5fJs1QU3q3h6', '1', 'TU5YGgO5fJs1QU3q3h6', '154461618738200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jcxKJBylAmq3KWrexXq', '3tFw1boS5L9vXoJCr6Z', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'Nmhce5xixb5FBPVv5dc', '154563949602300000', 'HdPeBqYwJyFyjHkhZu3', '此按钮不可见', '3', '1');
INSERT INTO `t_permission` VALUES ('JcYDyG99dEWY19PkVFW', 'jkpTHKg7DpuXQrppVxx', null, 'QfirpboG4MjuFdj8mbs', '2', 'QfirpboG4MjuFdj8mbs', '155142352963000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Jdf6Dwpw06mg2CkQq1Y', '3tFw1boS5L9vXoJCr6Z', null, 'rfmGjP7LXiQfxy15izp', '1', 'rfmGjP7LXiQfxy15izp', '154563949582000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JE5bMAnlkBKA3oqYZKP', '2ytUeoxBqghwofmBALl', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'VMAbFQIQDDpyST1AhyZ', '154461619136700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('jeCSKvchd6BzdHP6YEv', '2jSs6cnzu4mzY9C13vF', null, 'LHgnhFx0bsvuS1fUhBi', '0', '0dtX4S7P4eplUre1uBL', '155142339738800001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('JEnesfhmVUZzhomRyOW', '3tFw1boS5L9vXoJCr6Z', null, '6esIc2fTAI9nAOoOZcp', '1', 'qXsymSHvIPzVV0lWwQe', '154563949499100003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('JeqaBiWxaNvyeLpfOGF', '2jSs6cnzu4mzY9C13vF', null, 'EUJuOrIly3lBnwGTF7Q', '1', 'EUJuOrIly3lBnwGTF7Q', '155142339795000003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JeRCHIkJYa3veLmt6yo', '2jSs6cnzu4mzY9C13vF', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'xEBN59fWrxYULgpdRLy', '155142339645200001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('jeZcPHTd3m9CHZfKu8w', '3tFw1boS5L9vXoJCr6Z', null, 'XpNoNSLR8vialNcJDXq', '0', 'WadmhwRuII4JmFt4TYS', '154563949575700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Jfd5JNG7IenQMSKBKxs', '0Q0LkJpfR1ejtO8rD3p', null, 'iDzESIHQQFeI8FiDtGE', '2', 'iDzESIHQQFeI8FiDtGE', '155168789284500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('jfn7WkM97FM6k5GAfiu', '2ytUeoxBqghwofmBALl', null, 'EGmIBh1ogGUoD8df1rE', '1', 'EGmIBh1ogGUoD8df1rE', '154461619136700005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JfR0BTZlzkQgmbOQrpN', '2ytUeoxBqghwofmBALl', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'XYV76K6iat8P2bzFJIm', '154461618999200000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('JgDlB750HnzwMLZ1Onb', '0Q0LkJpfR1ejtO8rD3p', null, 'Ad9RS4RG7w9vkXmoKHG', '2', 'Ad9RS4RG7w9vkXmoKHG', '155168789297000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('jGiF0ukuG0gsEqxbYxG', '0Q0LkJpfR1ejtO8rD3p', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'sMlqIILsNZ3bvqE2hSm', '155168789343800003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JGZ8bqqks9MiSmSNHYZ', 'jkpTHKg7DpuXQrppVxx', null, 'SAzJx5AkUZOJRct29BH', '0', 'x3O0Ifcwe8BqX5uhms5', '155142353108000003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('jH7Oqu9apZJGdUQAsNA', 'WB81MbCBolNg6XmE35M', null, '11e6-4f27-1f4a23d7-81e8-cb77e1bc6c59', '1', '11e6-4fb6-9e15f58c-ae2a-85737433dd16', '155141104799500002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('JHBgCnDMgTtFi8ZWmkl', 'WB81MbCBolNg6XmE35M', null, '11e6-5611-fb38e044-91c5-cd8abd28b1f9', '2', '11e6-5611-fb38e044-91c5-cd8abd28b1f9', '155141104773000002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('jHiKnKzWQvjL3UMR8qW', '3tFw1boS5L9vXoJCr6Z', null, '3gGNzYyE5dK9ogZidWA', '1', '7SBexLWqUvnu9vb48Vu', '154563949586600001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('JHy8PcSmpLJ1dNIqjA4', '3tFw1boS5L9vXoJCr6Z', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'mHhOCWGxOkvrAOWpqLl', '154563949491300000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Ji6RaOzZ72Ro9IUxYgs', '2ytUeoxBqghwofmBALl', null, 'XtaVH2y40O9zvIVALWj', '1', 'cJircppYbKZxUtuClYU', '154461618922600004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('jIvNjvt3BPPFT1uKQBd', 'kPLbeydkgiYW6NIkCt0', null, 'Jzy7zZItDzniSSkL6fQ', '2', 'Jzy7zZItDzniSSkL6fQ', '155168804511700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('JJLltAe4DvguL90aIiV', '2jSs6cnzu4mzY9C13vF', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'd0K3kzFXs6sjokcwJ3u', '155142339819900002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('JJTrMl8fZvZsENYrT0B', 'jkpTHKg7DpuXQrppVxx', null, 'mEHACJenoEKew2MDnRm', '1', 'mEHACJenoEKew2MDnRm', '155142353114300003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jJwnQvv9ze1in8ZHm9h', 'kPLbeydkgiYW6NIkCt0', null, 'bIBjrPWlkEMkXKe7cPi', '2', 'bIBjrPWlkEMkXKe7cPi', '155168804524200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('jkmVeuyNerdI84HT5ah', 'jkpTHKg7DpuXQrppVxx', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'Jbc2xwZhMLLNIjg0h02', '155142353045600002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jKMxtBryP7okl5Tzocf', '2jSs6cnzu4mzY9C13vF', null, 'vZjJlrJAj7XdNX3czmS', '0', 'Mk4H4HSkj1saDLiahVH', '155142339743500004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('JKvHBtcyfActfuMzVhn', '0Q0LkJpfR1ejtO8rD3p', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'gP7qA2QTRCEqWmdByHT', '155168789407800002', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('JKXMt6ltLOvGGNrTeP1', '2jSs6cnzu4mzY9C13vF', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'LGI4kXh1sQ9vMEdPg6S', '155142339776200003', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('JL0yhusJoL0PFk8zo2R', '2jSs6cnzu4mzY9C13vF', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'zEz94y8drV2wM7Sh0jS', '155142339737200001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('jl3PAMFx2pIta5eIQ0x', 'jkpTHKg7DpuXQrppVxx', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'KMy1rLdwRmKATB4fMJZ', '155142353090900000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Jl7i1l1IhvFtmFmW8wg', '2ytUeoxBqghwofmBALl', null, 'XpNoNSLR8vialNcJDXq', '0', 'DDOwg7IIyIziyaozQTN', '154461618869500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('JlAhoGb0U7cUWvrWFi1', '2jSs6cnzu4mzY9C13vF', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'fu3FPAvy3QbJl8Y96P7', '155142339777800004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JLGfIftUVilhHhwP4KV', 'jkpTHKg7DpuXQrppVxx', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'CjR2ngF0kCrKnCpD0rj', '155142353033200004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JlHv7mItDyB8JoKeDsK', '2ytUeoxBqghwofmBALl', null, '5RzsvfgAUx2y0k1pDlg', '0', 'NgNicpt0mPuprqEMquB', '154461619099200008', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Jljal3Xpgd82rGgEXYu', '3tFw1boS5L9vXoJCr6Z', null, 'rdQ5WPuRoiCMJtXgsjg', '1', 'lV8RS6ch6jXlb2iiWqh', '154563949482000001', 'HdPeBqYwJyFyjHkhZu3', '保存', '4', '1');
INSERT INTO `t_permission` VALUES ('JLOzGmfl0luN2KhjecJ', 'jkpTHKg7DpuXQrppVxx', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'ElTaDWYx8x0ksSxQW27', '155142353112700001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('jLPb7txWSk5yRcyw4sv', '0Q0LkJpfR1ejtO8rD3p', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'eIRDEeewznXKf3ktljY', '155168789412500002', 'HdPeBqYwJyFyjHkhZu3', '跳转', '43', '1');
INSERT INTO `t_permission` VALUES ('jLpILAjfTCiT6vav9Oq', '2jSs6cnzu4mzY9C13vF', null, 'XtaVH2y40O9zvIVALWj', '1', 'XtaVH2y40O9zvIVALWj', '155142339632700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JLQYoV2BnZMtyRPZA8w', 'jkpTHKg7DpuXQrppVxx', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'XbKbKnKFlkZNvOSlGTo', '155142353026900001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('jlUP7lrZLmTtxX032Xe', 'WB81MbCBolNg6XmE35M', null, '11e6-5569-e32c800c-8350-a3b9b8447d61', '1', '11e6-5570-855c36fd-8575-9d6645ab8581', '155141105167700002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('JmaTyKQUmEux5vPqa2T', '3tFw1boS5L9vXoJCr6Z', null, 'NLGiWBICUXkTNWcaaD0', '1', 'NLGiWBICUXkTNWcaaD0', '154563949569500003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jMCNaMRubMiIWq0kgac', '3tFw1boS5L9vXoJCr6Z', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'f1qYzMAqsF7bNYJc4Xl', '154563949492900002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jn7HcgnSrdvk8JZAYXz', '3tFw1boS5L9vXoJCr6Z', null, 'ir2OPEdZvttSUxAzfmD', '1', 'ir2OPEdZvttSUxAzfmD', '154563949488200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JN8t07StJK6iMiBUTB7', '0Q0LkJpfR1ejtO8rD3p', null, 'bVLnHAUMhdToxosd7nT', '0', 'zNyhoGxQwFdm43lTvgK', '155168789395300002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('JnMzKTLht0rrTGRaVLl', 'kPLbeydkgiYW6NIkCt0', null, 'vDsnTykdPOblfwEF4mR', '1', 'vDsnTykdPOblfwEF4mR', '155168804653700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JNtO0RMU5rX8UVRexjZ', 'kPLbeydkgiYW6NIkCt0', null, '68kltzfu9ZSUp9aJOg4', '2', '68kltzfu9ZSUp9aJOg4', '155168804500800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('jNyBsHox18bxsPBaZWR', '2jSs6cnzu4mzY9C13vF', null, 'jYDgN5WH46paTNLcCqi', '0', '3Un6aJGRxrZKJu5VhVa', '155142339782500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('JOGYDdvMVP9TPkMn48T', '0Q0LkJpfR1ejtO8rD3p', null, '7q6BJWxhJzTuAFZpxa8', '2', '7q6BJWxhJzTuAFZpxa8', '155168789281400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Jp014eYl1rvvKkYgWxS', '0Q0LkJpfR1ejtO8rD3p', null, 'XtaVH2y40O9zvIVALWj', '1', 'XtaVH2y40O9zvIVALWj', '155168789339100001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jP21E56naAUEB3dYBbK', 'jkpTHKg7DpuXQrppVxx', null, 'ypFGviMvQl4iVE8dOS0', '2', 'ypFGviMvQl4iVE8dOS0', '155142352956700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('jp8RUSfWAlwgdcazyFO', '2jSs6cnzu4mzY9C13vF', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'gjNDcP4lJlHlGCLsxRq', '155142339748200003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('jpIFR0DJColtFtnmPhC', '0Q0LkJpfR1ejtO8rD3p', null, 'F6reQ5BW7P6q236Pi13', '1', 'wK7VlAkGcNMtWEsCCF2', '155168789471700001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('jPNhBej8j7CEdGtTO8d', '2jSs6cnzu4mzY9C13vF', null, 'RwMAY2iXBOjVaNZzkcE', '2', 'RwMAY2iXBOjVaNZzkcE', '155142339600000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('JPQP8lYJhArM0uayjoW', '2jSs6cnzu4mzY9C13vF', null, 'CUiq0kurilZ2dSBIXUv', '0', 'XxEDLxeqpXRncPsDJDo', '155142339752800002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('jPTL461jwMOE1Z3Rg7t', 'WB81MbCBolNg6XmE35M', null, '11e6-5ead-c5433cfb-b0f0-d3a532217234', '2', '11e6-5ead-c5433cfb-b0f0-d3a532217234', '155141104771500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('JPxfqOYTk4yezyaOucZ', '2jSs6cnzu4mzY9C13vF', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'ZLGOtOxZGBCsfXYeK15', '155142339802800000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('jQQDxfFnhrv1ub2dThA', '2jSs6cnzu4mzY9C13vF', null, 'mNVKo7InVqtGMI8pWnS', '2', 'mNVKo7InVqtGMI8pWnS', '155142339598400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('JqqJb5AAJeoiMqk9CPK', 'kPLbeydkgiYW6NIkCt0', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'd6qZunMLjwykDchDPZG', '155168804574100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('jQTvKv1kmzUiNXgtg8t', '3tFw1boS5L9vXoJCr6Z', null, '5XKkpkend5hrAy8xWlc', '1', 'xHnChg1mK6MilHV4VCZ', '154563949500700005', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('JqUhGr4qEkWCznDnELB', '2jSs6cnzu4mzY9C13vF', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'KDRVonlpSB5oYD1O1LY', '155142339869800000', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('JRbSWylDwh6DmeiRQFX', '3tFw1boS5L9vXoJCr6Z', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'LjTWOCClNPbDkDtAgoQ', '154563949599100000', 'HdPeBqYwJyFyjHkhZu3', '删除（字体图标红色 ）', '3', '1');
INSERT INTO `t_permission` VALUES ('JRKd61u7PGVz93fl6Em', '0Q0LkJpfR1ejtO8rD3p', null, 'GhbQPNIblLICNGTEwqX', '0', '2YA8KZ2P1yC1f0g2Nzs', '155168789396900005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('JrpS9qbFf1OQyhlV6SO', '3tFw1boS5L9vXoJCr6Z', null, '4VkP5W8VPlERMiThvSD', '0', 'DKXXNVp1SE3PrcD4Mq2', '154563949557000001', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('JRyz0BBb8IVbaKc3qsD', '2jSs6cnzu4mzY9C13vF', null, 'EaVrfjS89IZqE63BWPa', '0', 'lPhlrrSkZ8hekbRhXPh', '155142339857400003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('JSDeqDQBhqGq4vXi96e', '3tFw1boS5L9vXoJCr6Z', null, 'XzgpTEte9Q1JQswSETz', '0', 'oTrq3HVrCNx1jALWUgh', '154563949630400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('JSefOR6kd7UyC4lqFjf', '0Q0LkJpfR1ejtO8rD3p', null, '4wigakaNlnx6FakxlBQ', '2', '4wigakaNlnx6FakxlBQ', '155168789331300005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('jsoArDog3YWJFtlFSCN', '0Q0LkJpfR1ejtO8rD3p', null, 'jwnvWbHVPeT86x5j2LF', '2', 'jwnvWbHVPeT86x5j2LF', '155168789325100004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('JStWsQKa6kjBB02CBrm', 'WB81MbCBolNg6XmE35M', null, '11de-c39b-5cf3eb81-b652-871d9b638147', '1', '11de-c39b-5cf3eb81-b652-871d9b638147', '155141104871300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jTB1WjOcEOJifj75hvz', '2jSs6cnzu4mzY9C13vF', null, 'g7U0PGtN5bKYhwbka6s', '0', 'V6C3ScFeVfcdhY9Xw63', '155142339748200000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('jtBfou0cEEbctlgFUdB', 'kPLbeydkgiYW6NIkCt0', null, 'Tm9KRBnKnzjuuld7bJh', '0', 'k0TYCIl1oBQF4xUGHYE', '155168804583500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('JTfMXwlPsan9lgOJ748', '0Q0LkJpfR1ejtO8rD3p', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'NF5zkjoJvJNVpgmQsj6', '155168789463900004', 'HdPeBqYwJyFyjHkhZu3', '执行前提示', '3', '1');
INSERT INTO `t_permission` VALUES ('jTkJlMpmbHI1F8KyWrz', '2jSs6cnzu4mzY9C13vF', null, 'ir2OPEdZvttSUxAzfmD', '1', 'ir2OPEdZvttSUxAzfmD', '155142339651400002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jTyebJh1SFlaa6mTXGg', '2jSs6cnzu4mzY9C13vF', null, 'd1anhG9lkXM7xOEL0p0', '1', '54Ke6lqQKZqsRiIAuzU', '155142339721600001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('JuE85iXkSgJ6nsiPqHx', 'jkpTHKg7DpuXQrppVxx', null, 'ZM7F9MjjscP8bADF7cH', '1', 'aN0KA8MmhVB1LjOqtWo', '155142353033200003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('jUFshq7ftossQ1FoJ8w', '0Q0LkJpfR1ejtO8rD3p', null, '4RJ5cYekBtB1RdNDxL3', '1', '4RJ5cYekBtB1RdNDxL3', '155168789404700004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jUYpHNCj00Twq4C7y6e', '0Q0LkJpfR1ejtO8rD3p', null, 'qAcxhZ5mnoiohEBYD9G', '2', 'qAcxhZ5mnoiohEBYD9G', '155168789293900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('jVCzQloBRxgntYF3Q1c', '3tFw1boS5L9vXoJCr6Z', null, 'XtaVH2y40O9zvIVALWj', '1', 'XtaVH2y40O9zvIVALWj', '154563949478800006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jWaVRCJgjHnk4ZBSC4v', '2ytUeoxBqghwofmBALl', null, 'zqGmDkZIRa4COpFVzTj', '1', 'zqGmDkZIRa4COpFVzTj', '154461618916300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JwB0oZFAvFfehYeLMxw', 'WB81MbCBolNg6XmE35M', null, '11e6-55fc-b39ba492-bb59-b7243d4bcf51', '0', '11e6-55fc-c28c1b1b-bb59-b7243d4bcf51', '155141105019500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('jXFtMGy285lGLeP4yGM', '3tFw1boS5L9vXoJCr6Z', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'sMlqIILsNZ3bvqE2hSm', '154563949486600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JXhuirxr5AoIr4sXs5R', '2ytUeoxBqghwofmBALl', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'Mto2Exz54Tcvkyw1NCx', '154461618949200002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('JxNU5BpmNIsqUBIKqWD', 'kPLbeydkgiYW6NIkCt0', null, 'SiPTeSpUhRIqVgi1HW1', '0', 'LI7k2GDTP5VDdaobmtO', '155168804599100005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('jxqiFz7c3gjhrraKSbx', 'kPLbeydkgiYW6NIkCt0', null, 'wjPLVvwWYR2a9BOi0st', '0', 'cV9hNfWQ2CjjMiWBnt2', '155168804608500001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('JxsO5VBgDAb8W1BcsGG', '2ytUeoxBqghwofmBALl', null, 'XAQy4mQfPb9hnyOISK1', '0', 'xGuspPXmrUTCn5KTdAR', '154461619019500005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('JXUvClKdp018U2nTpgc', '3tFw1boS5L9vXoJCr6Z', null, 'g7U0PGtN5bKYhwbka6s', '0', 'VXaTIyUn85r0Xf2ja64', '154563949521000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('JXwqtGEYEdEqM6yZXYQ', '2ytUeoxBqghwofmBALl', null, 'lOgu0Jvq0z5dlveyrnY', '0', 'eq15KrpMbnefCOE2bGq', '154461618900700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Jy6qPBdcqJjRnVH5ms3', 'WB81MbCBolNg6XmE35M', null, '11e6-552e-bba4b939-8350-a3b9b8447d61', '1', '11e6-552e-bba4b939-8350-a3b9b8447d61', '155141104900900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('jyKshuMznarnIkPagHd', '2ytUeoxBqghwofmBALl', null, 'gniImP2ug7E82S1WO0L', '1', 'A9ZVOiaJCjFUhFQkG6X', '154461619067900003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('JZHgHiu9GUw4TEIVE5v', '2ytUeoxBqghwofmBALl', null, 'Jh68ppMt3QMha315Hi6', '0', 'ePkoYYvvztlUvkHqa16', '154461618999200003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('JZJFrGIhD7CrngIacE6', 'jkpTHKg7DpuXQrppVxx', null, 'kA4m81roWetnkDQgWm0', '0', 'fc8oYpPYk2t3xyohWqx', '155142353056600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('jZKswPRG6365cGEjRSZ', '0Q0LkJpfR1ejtO8rD3p', null, 'jhINwVUWllGph0gnSC6', '0', 'CbRpWeZs7qQG3vfc9YZ', '155168789393700002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Jzm1OK8lqLj7YXHzj63', 'WB81MbCBolNg6XmE35M', null, '11e6-5534-a670333f-8350-a3b9b8447d61', '1', '11e6-553c-14e0e32a-8350-a3b9b8447d61', '155141105194200002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('JzNCqI7L9LhYDgpANeN', 'jkpTHKg7DpuXQrppVxx', null, 'qqHbF4LC1qdUg1ak29k', '1', 'vdYEg1wdkIfHULE2LzN', '155142353023800005', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('K00DlBvfbG3SUpteKdW', '3tFw1boS5L9vXoJCr6Z', null, 'LgvvPpcCxScmiziQW7d', '2', 'LgvvPpcCxScmiziQW7d', '154563949452300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('K1gckLXWO7NVu3XY8fV', '2ytUeoxBqghwofmBALl', null, '6bUPlXeVH92MIv7Nmdw', '1', '6bUPlXeVH92MIv7Nmdw', '154461618939800005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('K1qLRCoZb6nK0gknodS', '3tFw1boS5L9vXoJCr6Z', null, 'AeQX2k6Or75tfUuty4K', '2', 'AeQX2k6Or75tfUuty4K', '154563949455400004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('K1Wpcp3AzuJHgZnZnHm', 'WB81MbCBolNg6XmE35M', null, '11e6-552e-bba4b939-8350-a3b9b8447d61', '1', '11e6-552f-6ed69858-8350-a3b9b8447d61', '155141104902500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '发布会议', '11', '1');
INSERT INTO `t_permission` VALUES ('K2v5ER6THaTamIyFJfw', '0Q0LkJpfR1ejtO8rD3p', null, 'EGmIBh1ogGUoD8df1rE', '1', 'EGmIBh1ogGUoD8df1rE', '155168789481100003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('k3DjvfTcF9jo70h1Jnh', '3tFw1boS5L9vXoJCr6Z', null, 'bn8WKWSmkeCbTynZV4J', '2', 'bn8WKWSmkeCbTynZV4J', '154563949449100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('K3TwAVf0oI04xlJJ1lz', '2ytUeoxBqghwofmBALl', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'weZ9Sz2X5RBVBRpCdJM', '154461619130400004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('K4TxCJ9boXRh1qOBAEl', '2ytUeoxBqghwofmBALl', null, 'vDsnTykdPOblfwEF4mR', '1', 'I7O5wArbJ75dWvyv3oX', '154461619024200003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('k5BQQOMmtIQDx5Zeglv', 'kPLbeydkgiYW6NIkCt0', null, 'Ksfgm24NkZrnPIXYgay', '2', 'Ksfgm24NkZrnPIXYgay', '155168804508600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('k5JtjZwJr8DjgVA0oJ6', '2jSs6cnzu4mzY9C13vF', null, 'eKZqOwJmAFsUEwu0WfL', '1', '3jy9fTiYM0hwEHejpTu', '155142339713800001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('k6smFXCOWOru9h1UaaD', 'kPLbeydkgiYW6NIkCt0', null, 'CuDZkkf1DSaMf5ST7bj', '1', 'CuDZkkf1DSaMf5ST7bj', '155168804606900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('k7kaKnPZtgHJm8RYmwR', 'jkpTHKg7DpuXQrppVxx', null, '6arVIWht264qE2jDBdE', '2', '6arVIWht264qE2jDBdE', '155142352987900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('k7qB1B7cCCerdBnP5HR', '2jSs6cnzu4mzY9C13vF', null, 'a2ZyD3z0DqPxaNXX6Zx', '0', 'XUVXBLmXG3ryVuGQfA9', '155142339757500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('K7R4XByN4etqreca1hh', 'jkpTHKg7DpuXQrppVxx', null, 'fwj9yeT6AbfKtPOwtOM', '2', 'fwj9yeT6AbfKtPOwtOM', '155142352995700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('K7RYOxIwySwrm09EtWm', '2ytUeoxBqghwofmBALl', null, '0zSRHMqiyMTl1dth7ds', '1', '0zSRHMqiyMTl1dth7ds', '154461618946000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('k7UdRwDjnul3VRFUA0s', '3tFw1boS5L9vXoJCr6Z', null, 'dcaZRzor22qTnafQjNv', '2', 'dcaZRzor22qTnafQjNv', '154563949475700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('k8eFyZkclCk43nf4rIz', 'jkpTHKg7DpuXQrppVxx', null, '0zSRHMqiyMTl1dth7ds', '1', 'hy32XOXaddLpvsHlLeY', '155142353026900004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('k8lGgeDLQWCa0W1Hmi1', '0Q0LkJpfR1ejtO8rD3p', null, 'Z6pISvulUdsSz8bjuOV', '0', '81O85fI7nEQvujIwWvl', '155168789392200002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('K8TAjRvqjMoVaqlQAUE', '2jSs6cnzu4mzY9C13vF', null, 'Ueyt2ELhQd7E2oZ9cIi', '1', 'Ueyt2ELhQd7E2oZ9cIi', '155142339698200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('K9up9Qfl0sYbUk6Vv4q', '0Q0LkJpfR1ejtO8rD3p', null, '8DmOHAVRvs3BblbhJoa', '1', 'b2wnjqSK0hVEGNix31k', '155168789346900002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('KA3LmsphtsZNHdDYvp4', 'jkpTHKg7DpuXQrppVxx', null, 'K34zNYKOBOe8fgOk6ia', '2', 'K34zNYKOBOe8fgOk6ia', '155142352975400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Ka4yKt6naE7i11CMIWe', '2ytUeoxBqghwofmBALl', null, 'iL3YpikkZUlruc5ai3D', '1', 'iL3YpikkZUlruc5ai3D', '154461618938200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KABCpdqaPqpv0pHTnCm', '2ytUeoxBqghwofmBALl', null, 'bkoXpI9ilQlOYD8wsbU', '1', 'bkoXpI9ilQlOYD8wsbU', '154461619028800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KaCZMljaqJmpLRFzEYn', '3tFw1boS5L9vXoJCr6Z', null, 'P14ZGIv1IEdecUGGYYk', '2', 'P14ZGIv1IEdecUGGYYk', '154563949422600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kaet3CRjG5sOabgEc6z', 'jkpTHKg7DpuXQrppVxx', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'I5GJXxDs9LYwwqf4uQv', '155142353075300001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('kAG0599nt8Al6bC3Kk9', '2jSs6cnzu4mzY9C13vF', null, 'lOgu0Jvq0z5dlveyrnY', '0', 'eq15KrpMbnefCOE2bGq', '155142339829300003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('KAyMsYfkyJPBlCwqA67', '3tFw1boS5L9vXoJCr6Z', null, 'XAQy4mQfPb9hnyOISK1', '0', 'xGuspPXmrUTCn5KTdAR', '154563949533500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Kb6hoH8bK0gEmygFWLY', 'WB81MbCBolNg6XmE35M', null, '11e6-5610-c21c03a9-91c5-cd8abd28b1f9', '2', '11e6-5610-c21c03a9-91c5-cd8abd28b1f9', '155141104779300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kBdtWAKMTDDvXA3fph9', '0Q0LkJpfR1ejtO8rD3p', null, 'G1v3gcUQOvFAo7IH62c', '2', 'G1v3gcUQOvFAo7IH62c', '155168789303300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KbHS0QFZOhZYDT4SzQ2', '0Q0LkJpfR1ejtO8rD3p', null, 'eLFjqFngRQrIkbsdeBd', '1', 'UZzpqQ3lo5RbuYNWbsL', '155168789474900003', 'HdPeBqYwJyFyjHkhZu3', 'pdf导出', '25', '1');
INSERT INTO `t_permission` VALUES ('kbi8jplpdhp6c5SLts2', '2jSs6cnzu4mzY9C13vF', null, 'MtITrUcx3REq45LskT3', '0', '1GnA7ouj5X9SbchE8C5', '155142339887000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('kbJTwJHbEpkxdIW0YSC', '3tFw1boS5L9vXoJCr6Z', null, 'Ps4ZZv1ZXK9RWgInE2I', '2', 'Ps4ZZv1ZXK9RWgInE2I', '154563949450700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kBmbP01BzplaPyTcQCA', 'kPLbeydkgiYW6NIkCt0', null, 'WOmzvkui5ZsoZu1CogR', '1', 'yJFj2Hn06m1lkC7swux', '155168804596000002', 'HdPeBqYwJyFyjHkhZu3', '通过邮件或短信通知', '37', '1');
INSERT INTO `t_permission` VALUES ('KBmYs4izM3TNgP94Xdk', '2ytUeoxBqghwofmBALl', null, 'HsCxJxVzSoMOXQotkMK', '1', 'HsCxJxVzSoMOXQotkMK', '154461619044500004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KBOoDTpS5hlRc8NvygA', 'jkpTHKg7DpuXQrppVxx', null, 'wwsNkkwFEvqL44gK2fM', '0', 'ITAEcCLmB4JM7hMwJQC', '155142353055000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('KC6eTRecNZHi5NTBPzk', 'jkpTHKg7DpuXQrppVxx', null, 'jIuyPXyzHxgmBlx4oQs', '2', 'jIuyPXyzHxgmBlx4oQs', '155142352958300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kCaGk4lThMr9z9GdR4g', 'kPLbeydkgiYW6NIkCt0', null, 'm8moRuOLRGU8fSbCIty', '0', '6ieKi8bk8zbO9XkicpP', '155168804535100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('kcflrEAxoXSZDhvIteB', 'WB81MbCBolNg6XmE35M', null, '11e6-5633-c861eb4e-91c5-cd8abd28b1f9', '1', '11e6-5633-c861eb4e-91c5-cd8abd28b1f9', '155141105219200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kCGcsoGn3CIWM7MUhLh', 'jkpTHKg7DpuXQrppVxx', null, 'lAUkIpgQSIZqQyttrB4', '1', 'lAUkIpgQSIZqQyttrB4', '155142353039400002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kCX5nB5Qy0VbgNeWO4i', 'jkpTHKg7DpuXQrppVxx', null, 'D0geS9pQRj0wkmGMmBp', '2', 'D0geS9pQRj0wkmGMmBp', '155142352978600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KdOmyUwTKCpWNDSoDPG', '2ytUeoxBqghwofmBALl', null, 'XtaVH2y40O9zvIVALWj', '1', 'bufGP6tY9wwjTOfXum5', '154461618922600002', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('KdRpDxKkULQVqXhnv4h', 'jkpTHKg7DpuXQrppVxx', null, '7fddj0hyGNlDYSZpyFZ', '1', '7fddj0hyGNlDYSZpyFZ', '155142353150200003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KdrXSQOxSD8u5k4eWIq', '2jSs6cnzu4mzY9C13vF', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'mJFtUs7KSNrMTt3W70z', '155142339888600001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('kDYyGGSac82k23pNT0x', 'WB81MbCBolNg6XmE35M', null, '11e6-5631-e6dd0796-91c5-cd8abd28b1f9', '1', '11e6-5631-e6dd0796-91c5-cd8abd28b1f9', '155141105220700002', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KECTgLQMokgffMtRdMW', '0Q0LkJpfR1ejtO8rD3p', null, 'WOmzvkui5ZsoZu1CogR', '1', 'WOmzvkui5ZsoZu1CogR', '155168789414000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KeFb4fvKHJMpioG2gG4', '2jSs6cnzu4mzY9C13vF', null, 'LsrnkDvx5pdkA6JnHuj', '2', 'LsrnkDvx5pdkA6JnHuj', '155142339556300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('keMu1pZ7uEX7QMBTcGT', 'jkpTHKg7DpuXQrppVxx', null, 'qX2GQGpdWwGnelcjHZP', '2', 'qX2GQGpdWwGnelcjHZP', '155142352950500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('keNNvI4wlHIiNLAfq1b', '0Q0LkJpfR1ejtO8rD3p', null, '7NlGpNC1MAEM6EuX2X0', '1', '7NlGpNC1MAEM6EuX2X0', '155168789488900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kF2JfxqPSEKcahYwXj6', '0Q0LkJpfR1ejtO8rD3p', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'erjzyEtPTNQ9Oc2MmGl', '155168789345400003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('KF4m7VoQVvypNWZPGAR', '3tFw1boS5L9vXoJCr6Z', null, '5RZRK7Jt5vyqwlIccop', '1', '5RZRK7Jt5vyqwlIccop', '154563949508500004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KFAqQ30XJRe8xEDvO4G', '2ytUeoxBqghwofmBALl', null, 'GhbQPNIblLICNGTEwqX', '0', 'CnYPYgX7tOKqpWia5h3', '154461619017900003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('KfNQMXkWqIU1pyq7BJw', '2ytUeoxBqghwofmBALl', null, 'BrbFcB3ptMyxdPl5W6u', '0', '1JVZYNRouHUK7MH0xzc', '154461619094500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('kFyuPMNl4NjnawCPmdV', 'WB81MbCBolNg6XmE35M', null, '11e6-53d0-13d83c16-81f5-679a826556ce', '1', '11e6-53d4-26294614-81f5-679a826556ce', '155141105038200001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('kGoorh5u7JbTl5kRSKP', '0Q0LkJpfR1ejtO8rD3p', null, '2F75ZJJXk8564FkCLYA', '1', '2F75ZJJXk8564FkCLYA', '155168789359400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kgOp1zQH7yrcHhXWr9g', '0Q0LkJpfR1ejtO8rD3p', null, 'KQSVH3r5JbmIAoPEf1R', '0', 'K4Z97NLTLZ952TInMrM', '155168789403100002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('KgSvxYZrZT83BESTuJx', 'kPLbeydkgiYW6NIkCt0', null, '6BIvNJISOeZ3xm8S2aG', '1', 't4hcTsCptGZ5kTWV2Ya', '155168804546100002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('kGWdWRNoDseuh0tPGJn', '3tFw1boS5L9vXoJCr6Z', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'gUlSUpqhlS2ym2ijZAg', '154563949494500006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('khD5EPHFlcrr0lel70W', '2ytUeoxBqghwofmBALl', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'cY4kl4aBnqojbhnxddX', '154461618878800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Khmjsc2OOipbR1JY0KD', '0Q0LkJpfR1ejtO8rD3p', null, 'OGMmff1QTZYqFk5vfeD', '1', 'OGMmff1QTZYqFk5vfeD', '155168789340700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KHmJWQeb0KiISlI9npr', 'kPLbeydkgiYW6NIkCt0', null, 'zqGmDkZIRa4COpFVzTj', '1', 'zqGmDkZIRa4COpFVzTj', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单', '1032', '2');
INSERT INTO `t_permission` VALUES ('KhN73M3TEoHelnoWCD1', '3tFw1boS5L9vXoJCr6Z', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Ty33WfwAyTHWENnxPcQ', '154563949544500001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('KI2bq1iwQiVdVmf3UWd', '0Q0LkJpfR1ejtO8rD3p', null, 'XtaVH2y40O9zvIVALWj', '1', 'cJircppYbKZxUtuClYU', '155168789339100003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('kI3MRGgi0Oer7q65MGb', '3tFw1boS5L9vXoJCr6Z', null, '4VkP5W8VPlERMiThvSD', '0', 'r8ONfNaqWuH1q18rKZk', '154563949557000000', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('KIEJySUp8UlmsneBnxa', '3tFw1boS5L9vXoJCr6Z', null, 'eLFjqFngRQrIkbsdeBd', '1', 'SX3rVQxkpU96Pko5JDm', '154563949614800006', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('kIWfgaAJqW4pqqyTMQw', 'kPLbeydkgiYW6NIkCt0', null, 'OGMmff1QTZYqFk5vfeD', '1', 'OGMmff1QTZYqFk5vfeD', '155168804533600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kJFdOem0gDIjJvvhR7T', '2ytUeoxBqghwofmBALl', null, 'oeLOJO0f3CC02OjOOIC', '0', '6onRFmzn8mrnGdrnIJy', '154461619013200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('KJnc3FI29UfPRfcP26S', '3tFw1boS5L9vXoJCr6Z', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '154563949439800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KjT1Lw5l6IcBRjzp087', '2jSs6cnzu4mzY9C13vF', null, 'm8moRuOLRGU8fSbCIty', '0', '6ieKi8bk8zbO9XkicpP', '155142339639000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('KKAvMfBAOxwnTaC73A3', '2jSs6cnzu4mzY9C13vF', null, 'fVc4y8aYlKHvUPNHpUz', '2', 'fVc4y8aYlKHvUPNHpUz', '155142339579700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KLQk9x5hOARSQ2mTdXH', '2jSs6cnzu4mzY9C13vF', null, 'poalxIjVlN70WdVjfQq', '1', 'poalxIjVlN70WdVjfQq', '155142339901000004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KlWBuPgeO5ttMYt8tyR', 'jkpTHKg7DpuXQrppVxx', null, 'Z5slsKyCh5Eg2s6qSK5', '2', 'Z5slsKyCh5Eg2s6qSK5', '155142352963000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kmelIDKA8hEPDPwyOwm', 'kPLbeydkgiYW6NIkCt0', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'v5qY31shPwgs5BLkLlM', '155168804574100004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('kmIJAL79ETxnUlqBEMP', 'kPLbeydkgiYW6NIkCt0', null, 'avS4WYnlhLiRlkXIHhD', '2', 'avS4WYnlhLiRlkXIHhD', '155168804525800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kmPgd8ojFblTOpIzPFH', '2jSs6cnzu4mzY9C13vF', null, 'Vu8Q68Bom89YJDgguC9', '1', 'pTuo29zZfTBXXiWv0y7', '155142339787200001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('KmUzeUdCkQ0jIbG8YOH', '2jSs6cnzu4mzY9C13vF', null, 'o4zdmPoNHMg5JK6m6dx', '0', '2MHj4CnPnbOb2UFuMQr', '155142339865200001', 'HdPeBqYwJyFyjHkhZu3', '执行前再确认', '3', '1');
INSERT INTO `t_permission` VALUES ('kmVNQy9JyrYFS26ipS0', 'jkpTHKg7DpuXQrppVxx', null, 'wwsNkkwFEvqL44gK2fM', '0', 'WbfBIyoU0AkbLY6hBur', '155142353055000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('KnOmdYtK6wfsLfSuWl4', '2jSs6cnzu4mzY9C13vF', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'Zb272Z4FRc9su5s2Lik', '155142339863600003', 'HdPeBqYwJyFyjHkhZu3', '批量提交（图片图标）', '20', '1');
INSERT INTO `t_permission` VALUES ('knYcqPFFcParVduHGQ2', '3tFw1boS5L9vXoJCr6Z', null, 'zqGmDkZIRa4COpFVzTj', '1', 'zqGmDkZIRa4COpFVzTj', '154563949478800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Kos64Nu2eponaqq802F', '3tFw1boS5L9vXoJCr6Z', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'WVuL60fA6C1cUsSUk5t', '154563949560100002', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('Kp0q6XSx4OJIRML6HiW', '0Q0LkJpfR1ejtO8rD3p', null, 'YLmf4h3xwvzrU2wJmYU', '2', 'YLmf4h3xwvzrU2wJmYU', '155168789326700005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KPeMYRvHUlwgQ0Y9BoM', 'jkpTHKg7DpuXQrppVxx', null, 'rfmGjP7LXiQfxy15izp', '1', 'dUQn2CkeHgHGnGsR8JC', '155142353111200003', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('KpfgvSaqXVivZ8Ap1Y7', 'kPLbeydkgiYW6NIkCt0', null, 'TU5YGgO5fJs1QU3q3h6', '1', 'TU5YGgO5fJs1QU3q3h6', '155168804602200003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kPNQ9nCoNDe6Wu9fYQF', '3tFw1boS5L9vXoJCr6Z', null, 'eLFjqFngRQrIkbsdeBd', '1', 'laHgljUkGTSlRpd6Sbl', '154563949616300000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('KpRSJrCn88ihB7Qq3SJ', 'WB81MbCBolNg6XmE35M', null, '11e6-5e0c-bf1399e7-ae15-3d6b584ebd70', '0', '11e6-5e0d-44259c34-ae15-3d6b584ebd70', '155141105000800001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('KpSCObDFKcd3JpgNaSB', '3tFw1boS5L9vXoJCr6Z', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'fkbqJ4vxJOUvHY59Lo6', '154563949617900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kpuLp2QxBk919uPKD7h', '3tFw1boS5L9vXoJCr6Z', null, 'smthlnru9z9qwavJKk1', '0', 'AHJzoQDdLpyRpZLTTdK', '154563949630400002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('kQAnIDRjRfyYvcHjai2', 'WB81MbCBolNg6XmE35M', null, '11de-7666-1dc7f93b-8d52-0547317ddd4c', '1', '11de-766c-752b707c-824d-d3dd83e4db1b', '155141105128700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '4', '1');
INSERT INTO `t_permission` VALUES ('kQBfAsdWsyRig8iNuHp', '0Q0LkJpfR1ejtO8rD3p', null, 'ID88NPj17JbpAMGYh9J', '2', 'ID88NPj17JbpAMGYh9J', '155168789323500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kQBrk6eGrDgRCJfTsd1', '3tFw1boS5L9vXoJCr6Z', null, 'cbE2ixGwPBn9lHk5RmS', '2', 'cbE2ixGwPBn9lHk5RmS', '154563949421000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KQk3AkOjl7W3waTQV1M', 'kPLbeydkgiYW6NIkCt0', null, '6Xi7fyFJT20APl5y8RE', '2', '6Xi7fyFJT20APl5y8RE', '155168804497700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kQnw5m0hl9ar7TwzOSv', '2ytUeoxBqghwofmBALl', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'QOJ06s8WUaokm0sdBKM', '154461619097600004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('KqTUzE8JFNPrBIxwge8', '2ytUeoxBqghwofmBALl', null, 'j4ncSyWthzCYoNj3n4J', '0', 'WWNamo3Hl2Q5IoZUFn7', '154461618908500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('kre71TB7VGaN9Ptzrl0', '3tFw1boS5L9vXoJCr6Z', null, '06Me4ssjoGBiKz0gMK2', '0', 'ZEh1qpMCAgYe10KWd1j', '154563949619500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('krOiaG0vHHINI8RyU5J', '3tFw1boS5L9vXoJCr6Z', null, 'fAVX6iUbvHroALIUfPf', '2', 'fAVX6iUbvHroALIUfPf', '154563949430400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kRvoDOXSvbjs0Cbc0BX', '2ytUeoxBqghwofmBALl', null, 'BrbFcB3ptMyxdPl5W6u', '0', '6DhnKNo54979AgvQSGH', '154461619094500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('kRyTbYXZoKQrxfGSA4J', 'kPLbeydkgiYW6NIkCt0', null, '7giYu3zk1hrdILU9eCl', '2', '7giYu3zk1hrdILU9eCl', '155168804519500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kS1BKk2o0BtXWyMZZLA', '2ytUeoxBqghwofmBALl', null, 'CuDZkkf1DSaMf5ST7bj', '1', 'CuDZkkf1DSaMf5ST7bj', '154461619057000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KspYKcjQiWEsQf9u8Fv', '3tFw1boS5L9vXoJCr6Z', null, 'BrbFcB3ptMyxdPl5W6u', '0', '6DhnKNo54979AgvQSGH', '154563949588200003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('KSt0NTZAmgsGZj78zAb', '0Q0LkJpfR1ejtO8rD3p', null, 'XtaVH2y40O9zvIVALWj', '1', 'bufGP6tY9wwjTOfXum5', '155168789339100002', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('Kt9TZ6cF0xvluwbiCVk', 'kPLbeydkgiYW6NIkCt0', null, 'F6reQ5BW7P6q236Pi13', '1', 'Okamal6erVlSp96ygxI', '155168804652100001', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('kTeWzxAk4aQwaKeAWYa', '3tFw1boS5L9vXoJCr6Z', null, 'MIExqx2MWO5cunDiuaX', '1', 'MIExqx2MWO5cunDiuaX', '154563949505400002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KTIAc4J3782tbRT4OYM', '0Q0LkJpfR1ejtO8rD3p', null, 'IuPDe4Gm9occzflnrP0', '0', 'v6Do5TzCwJt7gNmEi1b', '155168789465500004', 'HdPeBqYwJyFyjHkhZu3', '弹出层打开', '43', '1');
INSERT INTO `t_permission` VALUES ('KU0ga6x3LmbnGVuIYMO', 'WB81MbCBolNg6XmE35M', null, '11de-7665-e571fab8-8d52-0547317ddd4c', '1', '11e6-d15f-7cf5cb2a-bbdd-9f7a0eebced4', '155141105133400001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('kUaur3KRsWnqLNmkYOP', '3tFw1boS5L9vXoJCr6Z', null, 'nTlBd4a4Vt8mtiTX41J', '0', '9e1x2YMVEFvz8YJOOtI', '154563949589800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('kuBu9Trzz32CG9gANrl', '0Q0LkJpfR1ejtO8rD3p', null, '4RJ5cYekBtB1RdNDxL3', '1', '2WEniL1FLLpXKQfd5XU', '155168789406200000', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('kuHXNL0oUPv3FGudAh1', '0Q0LkJpfR1ejtO8rD3p', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'AiibIdUU3zQiGsrKDXn', '155168789484200003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Kuk06LFBS5TLlrgRvOd', 'jkpTHKg7DpuXQrppVxx', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'QXO7cxkzLZ51qdiKBrI', '155142353156400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('kUTL7OCktej9qWntJOI', 'jkpTHKg7DpuXQrppVxx', null, 'JdWD8biOlCXjkEvrwMm', '0', 'MRVrK6Uj6Z6imY0qwYm', '155142353134600001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('KuvuInporDMsIRf1A2I', '2jSs6cnzu4mzY9C13vF', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '155142339749700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('KuyvXEdNXM2Q574Ahrh', '0Q0LkJpfR1ejtO8rD3p', null, 'IMD35YU4FNWL8IkwPAJ', '1', 'IMD35YU4FNWL8IkwPAJ', '155168789367200002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KVAdodj3aPypGVfoOG9', 'kPLbeydkgiYW6NIkCt0', null, 'Ps4ZZv1ZXK9RWgInE2I', '2', 'Ps4ZZv1ZXK9RWgInE2I', '155168804496100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KvdJC0zYvR3jU4MC8Gp', '2jSs6cnzu4mzY9C13vF', null, 'w7IsSOtXFvo61cP8sKr', '1', 'tdpqhqKdJ6wj3toLl5M', '155142339777800003', 'HdPeBqYwJyFyjHkhZu3', '打印包含流程历史', '15', '1');
INSERT INTO `t_permission` VALUES ('kvfp5QzmJSu4yDvurQG', '2jSs6cnzu4mzY9C13vF', null, 'K34zNYKOBOe8fgOk6ia', '2', 'K34zNYKOBOe8fgOk6ia', '155142339592200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KViNP6DeiKgFj95u9qq', '2jSs6cnzu4mzY9C13vF', null, '6BIvNJISOeZ3xm8S2aG', '1', 't4hcTsCptGZ5kTWV2Ya', '155142339659200003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('KVlVE9hhJEtXejC9ZlQ', 'jkpTHKg7DpuXQrppVxx', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'Wy8unQKVYBEnHvEqVyA', '155142353017600003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('KVm7vfoIXGnD4oYJ8l6', '2jSs6cnzu4mzY9C13vF', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'I5GJXxDs9LYwwqf4uQv', '155142339762200000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('KVP8NsCY7HPTwNMbzhg', 'kPLbeydkgiYW6NIkCt0', null, 's4T0yhSw1lIJMsiBfQa', '2', 's4T0yhSw1lIJMsiBfQa', '155168804510200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KvvKL57GQXMm68Naxxq', '2ytUeoxBqghwofmBALl', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'KDRVonlpSB5oYD1O1LY', '154461618999200004', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('kVwhoahxyG9JA2eT8hM', 'kPLbeydkgiYW6NIkCt0', null, '5XKkpkend5hrAy8xWlc', '1', '5XKkpkend5hrAy8xWlc', '155168804555400003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kW11rIyZ0pf6dnk8YZl', '0Q0LkJpfR1ejtO8rD3p', null, 'lAUkIpgQSIZqQyttrB4', '1', 'lAUkIpgQSIZqQyttrB4', '155168789370300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kw4vhr8x9XIeWgawEcj', '3tFw1boS5L9vXoJCr6Z', null, 'epn8IcdUN0afirW9qZ6', '2', 'epn8IcdUN0afirW9qZ6', '154563949471000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kWIrJey4VL5xYmHinmQ', '3tFw1boS5L9vXoJCr6Z', null, 'avS4WYnlhLiRlkXIHhD', '2', 'avS4WYnlhLiRlkXIHhD', '154563949477300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KwIrZczvRiMrQm7Hqa9', '2jSs6cnzu4mzY9C13vF', null, '2F75ZJJXk8564FkCLYA', '1', 'G1Mxsr3SbNkCXsao7je', '155142339681100001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('KwQ6bqTgfeAjvWuC9fi', '0Q0LkJpfR1ejtO8rD3p', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'SospNqkq0w4oZqt8HNv', '155168789465500001', 'HdPeBqYwJyFyjHkhZu3', '只读按钮', '3', '1');
INSERT INTO `t_permission` VALUES ('KwW1dktwCzoASCTs08J', 'kPLbeydkgiYW6NIkCt0', null, 'IuPDe4Gm9occzflnrP0', '0', 'LFydu54akpsq9Y9sCQr', '155168804645900002', 'HdPeBqYwJyFyjHkhZu3', '载入其他视图', '1', '1');
INSERT INTO `t_permission` VALUES ('kwwNlTmX1mmonI4LVdE', '3tFw1boS5L9vXoJCr6Z', null, 'gniImP2ug7E82S1WO0L', '1', '2GBc0jCYf23ydklhe3I', '154563949580400000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('kWXSVdbVYe4NTzYOajK', '3tFw1boS5L9vXoJCr6Z', null, '6bUPlXeVH92MIv7Nmdw', '1', 'ZNYYg5DdRtEMBaS3QLl', '154563949494500003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('kx0X274fLrUl4Xhan8P', 'kPLbeydkgiYW6NIkCt0', null, 'zg2t1qqkaJ17B2vvX05', '0', '5YmlK5Wk3G3ZqIrhdzM', '155168804635000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('KX2JZJnUQL8Xhiez2Ji', 'jkpTHKg7DpuXQrppVxx', null, 'EHYHRWZlyHZcXyKrAkr', '2', 'EHYHRWZlyHZcXyKrAkr', '155142352967600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kxcBPLN83jZ6WWITBCK', 'kPLbeydkgiYW6NIkCt0', null, '3gGNzYyE5dK9ogZidWA', '1', '1yFGNlNaVN83hKJQ7vt', '155168804624100001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('KxfQrCp6O2irGv5EyhQ', '0Q0LkJpfR1ejtO8rD3p', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'zQbdwHlWMKfQxZOw4TN', '155168789476400003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kXHlRYfIFkujYqO9zoB', 'kPLbeydkgiYW6NIkCt0', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'AiibIdUU3zQiGsrKDXn', '155168804670900003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('KxsBzjBSTONmJLGiaTx', 'kPLbeydkgiYW6NIkCt0', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '155168804566300003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Ky5uMaAriRjFk0IEKhv', '0Q0LkJpfR1ejtO8rD3p', null, 'T9IoQKXjHSvxRXYM3L8', '1', 'T9IoQKXjHSvxRXYM3L8', '155168789371900003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('KyhHfjilrEhsGty8ycC', 'WB81MbCBolNg6XmE35M', null, '11e6-5610-ddd7c6bb-91c5-cd8abd28b1f9', '2', '11e6-5610-ddd7c6bb-91c5-cd8abd28b1f9', '155141104769900004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('kySprx6gPATpuKYxAXI', '3tFw1boS5L9vXoJCr6Z', null, '9ppSV2PIKNhHCOwufvI', '0', 'OPN8L9J3OMzySIcqldf', '154563949597600001', 'HdPeBqYwJyFyjHkhZu3', '跳转', '1', '1');
INSERT INTO `t_permission` VALUES ('kysrf60c2IScQubkpnt', '3tFw1boS5L9vXoJCr6Z', null, 'T9IoQKXjHSvxRXYM3L8', '1', 'T9IoQKXjHSvxRXYM3L8', '154563949510100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kyUfYFhOzkexNwafB3V', 'jkpTHKg7DpuXQrppVxx', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'QE5Y9qsMqfgX5CnSw2u', '155142353137700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Kz2lX1dMSWdoZZ81Ftt', 'kPLbeydkgiYW6NIkCt0', null, 'Ta56UCfylnpmF0NhOQW', '2', 'Ta56UCfylnpmF0NhOQW', '155168804507100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Kz5XqvJXZJUQPadsGKA', '3tFw1boS5L9vXoJCr6Z', null, '2FzVqBVCwr7uvFsl3Yo', '2', '2FzVqBVCwr7uvFsl3Yo', '154563949452300005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Kza4QMOxudwqbvgoTfE', '0Q0LkJpfR1ejtO8rD3p', null, 'bn8WKWSmkeCbTynZV4J', '2', 'bn8WKWSmkeCbTynZV4J', '155168789311100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Kzc0W5ITmMhoGMUIcPi', '3tFw1boS5L9vXoJCr6Z', null, '36v96aPARGPLLLpXBt5', '2', '36v96aPARGPLLLpXBt5', '154563949469500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('KzERfWZql0f6C5hYm31', 'jkpTHKg7DpuXQrppVxx', null, 'EKD2uh12ht0Vptz9xN5', '0', 'ThJH0AWU99Z8F5DDmUo', '155142353051900000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('kZIzWEjdGRyv3qbEkJh', '2jSs6cnzu4mzY9C13vF', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'WVuL60fA6C1cUsSUk5t', '155142339784000004', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('kzS1i0Gt3YQqnVojIll', '0Q0LkJpfR1ejtO8rD3p', null, 'NaZcYrbGaXxrTGcsd2M', '1', 'NaZcYrbGaXxrTGcsd2M', '155168789482700004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('kzxNOibBjfOVP3eIzsb', '3tFw1boS5L9vXoJCr6Z', null, 'T9IoQKXjHSvxRXYM3L8', '1', '3X6cQR0K41HlNd3N5Ty', '154563949510100001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('L0DZ5cZXWZ9oPkdVsTS', '0Q0LkJpfR1ejtO8rD3p', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'aJ8FUYVtCO50iowXPg5', '155168789351600003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('L0mBLhtyZm90wAO3GJ6', '2jSs6cnzu4mzY9C13vF', null, '9ppSV2PIKNhHCOwufvI', '0', 'KJPLDYCNeJz1SWkwXZd', '155142339862000004', 'HdPeBqYwJyFyjHkhZu3', '下载文件', '26', '1');
INSERT INTO `t_permission` VALUES ('L0UkNSXUNOanxVV4jjK', '2jSs6cnzu4mzY9C13vF', null, 'ZKzfdA0mMJy8MQ16L4e', '2', 'ZKzfdA0mMJy8MQ16L4e', '155142339548500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('l12Ioiw6uvoT6FeZIjA', 'WB81MbCBolNg6XmE35M', null, '11e6-53d6-9d864d4e-81f5-679a826556ce', '1', '11e6-53d6-9d864d4e-81f5-679a826556ce', '155141105047600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('L1O4CWzZBp0qb9soEYY', 'jkpTHKg7DpuXQrppVxx', null, 'kcMdjikNe3R1UmNMZPB', '2', 'kcMdjikNe3R1UmNMZPB', '155142353003500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('l1SoO41sPMIxbMxiNhP', '3tFw1boS5L9vXoJCr6Z', null, 'WjB49SEA8rvzL9rkC7N', '1', 'WjB49SEA8rvzL9rkC7N', '154563949569500002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('l2A4mqnViI8vT8EwaOS', '0Q0LkJpfR1ejtO8rD3p', null, 'dzJOLeIY4r6nbim6lou', '2', 'dzJOLeIY4r6nbim6lou', '155168789283000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('l2CHeE3B94chDdFKHfD', '0Q0LkJpfR1ejtO8rD3p', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'mJFtUs7KSNrMTt3W70z', '155168789481100002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('l2fn59FlDQXonq2k9FA', '3tFw1boS5L9vXoJCr6Z', null, 'viwgtc32VtB7wJo2O8S', '0', 'u09JpvzXkvJXfyRFCj6', '154563949516300000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('l2GBjRTDzZZmeLSIUXb', 'kPLbeydkgiYW6NIkCt0', null, 'viwgtc32VtB7wJo2O8S', '0', 'u09JpvzXkvJXfyRFCj6', '155168804571000000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('l3AiLfs74hS681OKqzq', '2ytUeoxBqghwofmBALl', null, 'GhbQPNIblLICNGTEwqX', '0', '2YA8KZ2P1yC1f0g2Nzs', '154461619017900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('L40WafI5sDEiUILs9Ie', '3tFw1boS5L9vXoJCr6Z', null, 'jIuyPXyzHxgmBlx4oQs', '2', 'jIuyPXyzHxgmBlx4oQs', '154563949424100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('L495dphR4CLqxtRcP3Y', '3tFw1boS5L9vXoJCr6Z', null, '74xpaQX1peQaya80WFh', '2', '74xpaQX1peQaya80WFh', '154563949447600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('L4l8hxn6yQXkCftSGov', '3tFw1boS5L9vXoJCr6Z', null, 'iDzESIHQQFeI8FiDtGE', '2', 'iDzESIHQQFeI8FiDtGE', '154563949419500004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('l4Nv43A5WQhwCaBrPtM', 'jkpTHKg7DpuXQrppVxx', null, 'kebFCC8mkGX3V1QEriK', '0', 'dsB4JOjIMnlpqITpAVO', '155142353164200003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('l4ZfWWtpjgt9WcFqiLp', '0Q0LkJpfR1ejtO8rD3p', null, 'qOM6QAy48iqde43ij94', '2', 'qOM6QAy48iqde43ij94', '155168789309500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('L5Tpisu6kGn1dSijuy4', '2ytUeoxBqghwofmBALl', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'QOEHg2MUz4Qp7kv5JyL', '154461618866300000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('l6FtIf2mwWiL09zte56', 'kPLbeydkgiYW6NIkCt0', null, 'RGSlfhmaWRtgtaWUhTU', '2', 'RGSlfhmaWRtgtaWUhTU', '155168804477400003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('L6iDRihMi8OJAzCjWbO', '2ytUeoxBqghwofmBALl', null, 'laN4VVChl81K10rDCWr', '1', 'laN4VVChl81K10rDCWr', '154461619053800004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('l7IgPdyxeKTtfuhqcky', '2ytUeoxBqghwofmBALl', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'HsJKTUvE0PpgpJ9EXSw', '154461619055400002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('l89QgSdJeUdPj9KytiR', 'jkpTHKg7DpuXQrppVxx', null, 'kA4m81roWetnkDQgWm0', '0', 'imbMPttNeDXyRLEFJeh', '155142353056600001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('l8B12vKvBUfX8tfiIR8', 'kPLbeydkgiYW6NIkCt0', null, '8DmOHAVRvs3BblbhJoa', '1', '8DmOHAVRvs3BblbhJoa', '155168804542900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('l8no77r4HBzO1s3mVyB', '2ytUeoxBqghwofmBALl', null, 'UdbmUInPiuJzqP4yBTS', '1', 'UdbmUInPiuJzqP4yBTS', '154461619030400005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('L8uJQQtkE2msY9n4SSR', '3tFw1boS5L9vXoJCr6Z', null, 'Ry5YZ6oWsbQSIWGTbiM', '2', 'Ry5YZ6oWsbQSIWGTbiM', '154563949444500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('L8Y26hJWq1LdVHNvqDd', '2jSs6cnzu4mzY9C13vF', null, 'Jzy7zZItDzniSSkL6fQ', '2', 'Jzy7zZItDzniSSkL6fQ', '155142339606200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('L9b9fPgoYG3jARsdiI5', 'WB81MbCBolNg6XmE35M', null, '11e6-54a7-2bd353aa-9671-379f935a9949', '1', '11e6-578b-e0a41862-99bd-f3f2cc3ce475', '155141105103700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('L9wEqqymHiAswtPiSoZ', '2ytUeoxBqghwofmBALl', null, 'wwsNkkwFEvqL44gK2fM', '0', 'ITAEcCLmB4JM7hMwJQC', '154461618992900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('LA1NpZFqhPnm4hmE5jB', '0Q0LkJpfR1ejtO8rD3p', null, 'poalxIjVlN70WdVjfQq', '1', '1reYhDLZyvld0uiPZMk', '155168789487300003', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('la4gTJKLtMqRPJGx9qP', 'WB81MbCBolNg6XmE35M', null, '11e6-5534-447f1c38-8350-a3b9b8447d61', '0', '11e6-5534-743cc9f4-8350-a3b9b8447d61', '155141105206700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('lA4LTxpWb8JBjM2JNyT', '3tFw1boS5L9vXoJCr6Z', null, 'UdbmUInPiuJzqP4yBTS', '1', 'UdbmUInPiuJzqP4yBTS', '154563949613200002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('lAAr5foj3WcZ4tTjvPH', '2jSs6cnzu4mzY9C13vF', null, '4mlBSmLGlzULUWJe8Nu', '1', 'XeBSO1gjZBWzi78mcUl', '155142339774700001', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('LAemlaCfzTqYztwMJSS', '0Q0LkJpfR1ejtO8rD3p', null, 'XAQy4mQfPb9hnyOISK1', '0', 'xGuspPXmrUTCn5KTdAR', '155168789400000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('lb6kCvxoX42WjGlXU4u', '2ytUeoxBqghwofmBALl', null, 'poalxIjVlN70WdVjfQq', '1', 'poalxIjVlN70WdVjfQq', '154461619102300004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('LCxGxHTySImoRwoUi3N', '3tFw1boS5L9vXoJCr6Z', null, 'exsIaz9QN0WD65u23jd', '2', 'exsIaz9QN0WD65u23jd', '154563949477300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lD2HCfaweahYOJaXG0a', 'kPLbeydkgiYW6NIkCt0', null, 'jwnvWbHVPeT86x5j2LF', '2', 'jwnvWbHVPeT86x5j2LF', '155168804513300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ldYIiMIw40zlpnnUhdV', '2jSs6cnzu4mzY9C13vF', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'd6qZunMLjwykDchDPZG', '155142339746600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('lEa2UH9m1fPq5JF8jYE', '0Q0LkJpfR1ejtO8rD3p', null, '6BIvNJISOeZ3xm8S2aG', '1', 'gZXQSMJKQTAqYMBYWXE', '155168789348500003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('lEaKgv4nm52SzomVWqX', '3tFw1boS5L9vXoJCr6Z', null, 'eLFjqFngRQrIkbsdeBd', '1', 'FdZlsUl66zL94sGKwVe', '154563949614800005', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('LEHg4Pu2sGPdHiBxian', '3tFw1boS5L9vXoJCr6Z', null, 'w7IsSOtXFvo61cP8sKr', '1', 'bdnOlGNgir39pNIV5w3', '154563949547600001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('LEtFEuVWLcEnex1iCQU', '2jSs6cnzu4mzY9C13vF', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'wKRxU5XodFTWQ3Od5v0', '155142339662400002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('LEum7PRWiWWo2MXoynS', '2ytUeoxBqghwofmBALl', null, 'IuPDe4Gm9occzflnrP0', '0', 'v6Do5TzCwJt7gNmEi1b', '154461619108500005', 'HdPeBqYwJyFyjHkhZu3', '弹出层打开', '43', '1');
INSERT INTO `t_permission` VALUES ('Lf5tEtR3UUcvMTa0XRR', '2jSs6cnzu4mzY9C13vF', null, '1hPCUYj6dx9rMn0NAlL', '2', '1hPCUYj6dx9rMn0NAlL', '155142339556300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lffQilBDkFwocmHYxPW', '3tFw1boS5L9vXoJCr6Z', null, 'CuDZkkf1DSaMf5ST7bj', '1', 'CuDZkkf1DSaMf5ST7bj', '154563949572600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('LfNhdXgvVZSmk4YTvxa', '0Q0LkJpfR1ejtO8rD3p', null, 'TqQZlnV3BVaRGCm4tXn', '1', '7Cu3i9C1gOoAeAS2dAn', '155168789346900004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('LfSx5Tdv1X4PKurRGdk', '2ytUeoxBqghwofmBALl', null, 'qqHbF4LC1qdUg1ak29k', '1', 'qqHbF4LC1qdUg1ak29k', '154461618939800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('lftwcB5TscUha7I1Eib', '2ytUeoxBqghwofmBALl', null, 'CUiq0kurilZ2dSBIXUv', '0', 'Ksb2IhhfWaj5cJWTMwr', '154461619011700006', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('LfXLZaMGBJyKZ01fZl0', 'kPLbeydkgiYW6NIkCt0', null, 'Q1jIFlIQgvrxXHuYM9L', '2', 'Q1jIFlIQgvrxXHuYM9L', '155168804497700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lgfCEHsF9hOpwl24Lf9', 'jkpTHKg7DpuXQrppVxx', null, 'LY2n5aO7h1TrpoHU2mc', '1', 'LY2n5aO7h1TrpoHU2mc', '155142353103400005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('LGNSFi6iCaZRIkU6hSs', 'WB81MbCBolNg6XmE35M', null, '11e6-53e0-0aeaac2d-81f5-679a826556ce', '1', '11e6-53e5-c63bc244-81f5-679a826556ce', '155141105120900002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('LGPhVLK0gJxCiZWeOLc', 'jkpTHKg7DpuXQrppVxx', null, 'rUBAvMGr4fLCj7Wg0HQ', '2', 'rUBAvMGr4fLCj7Wg0HQ', '155142352998800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LGzQX7hqIJx8bUOCAyv', 'kPLbeydkgiYW6NIkCt0', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'zQbdwHlWMKfQxZOw4TN', '155168804659900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('lHaXAnoPQlR2nZyY7uG', 'jkpTHKg7DpuXQrppVxx', null, 'qFSn8P14pNLldr9j5QS', '2', 'qFSn8P14pNLldr9j5QS', '155142352972300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lhBYYaxiwEGz93f86IL', 'kPLbeydkgiYW6NIkCt0', null, '53PLwEjsvlAXAnlixPb', '2', '53PLwEjsvlAXAnlixPb', '155168804521100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LhG75jkFXX9hllPXupt', '0Q0LkJpfR1ejtO8rD3p', null, 'vCWvTbPligxwrkrwAv8', '0', 'oyuPcAc1VAmt4JtNf7A', '155168789479500004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('LHnRD1gOJyBdIlWviUT', 'kPLbeydkgiYW6NIkCt0', null, 'vDsnTykdPOblfwEF4mR', '1', 'g26NwXh1sSVhmkBCy8v', '155168804653700002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('LhQukeyq8D3kZiaiCAP', '3tFw1boS5L9vXoJCr6Z', null, 'SaFhOUcZJcd0Kj5IodL', '2', 'SaFhOUcZJcd0Kj5IodL', '154563949467900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lHSE0peukBDuVjJ5qrT', '3tFw1boS5L9vXoJCr6Z', null, 'rfmGjP7LXiQfxy15izp', '1', 'dUQn2CkeHgHGnGsR8JC', '154563949583500001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('LJ3GHfdWCE3pguvKqOd', 'kPLbeydkgiYW6NIkCt0', null, 'fu3FPAvy3QbJl8Y96P7', '1', '5oWWmwFfmt1UTNzYcO7', '155168804594400005', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('ljGVhz1UJITAgFeTcOS', 'kPLbeydkgiYW6NIkCt0', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'MiEVpwvQ9yx8Zb5c2bR', '155168804564800003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('lji2XOrYO6dj6bRCxFl', 'jkpTHKg7DpuXQrppVxx', null, 'poalxIjVlN70WdVjfQq', '1', '1reYhDLZyvld0uiPZMk', '155142353165800003', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('LkAwwu1oCsGq0doy3q0', 'kPLbeydkgiYW6NIkCt0', null, 'H4Obg0f1gqRhQW4pA1i', '0', 'wp5DHPGjQQJlPGmBg50', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单2', '3', '2');
INSERT INTO `t_permission` VALUES ('LkrUEsdZqD8d9UdQDg1', 'WB81MbCBolNg6XmE35M', null, '11e6-5e11-af9f0d23-ae15-3d6b584ebd70', '1', '11e6-5e11-af9f0d23-ae15-3d6b584ebd70', '155141104993000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('LL3zo8waXwL0Km5bogr', 'jkpTHKg7DpuXQrppVxx', null, 'PbQMu46yyehblOGohri', '2', 'PbQMu46yyehblOGohri', '155142352967600004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('llAfvrIwwqttKmoWtVV', 'jkpTHKg7DpuXQrppVxx', null, 'KQSVH3r5JbmIAoPEf1R', '0', 'FpCOlrvb0mWq2jRlD44', '155142353078400003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('LlDG59NSxS7CkK3Gmqt', 'kPLbeydkgiYW6NIkCt0', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'KMy1rLdwRmKATB4fMJZ', '155168804599100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('lLho7VPJq7pgXNkLGLu', 'kPLbeydkgiYW6NIkCt0', null, 'ikeULZmmOeAR6XklD2T', '2', 'ikeULZmmOeAR6XklD2T', '155168804527300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LLJs9SKswpNmy2V6zt8', 'jkpTHKg7DpuXQrppVxx', null, 'tfxROndy5dmj8HKxpkX', '2', 'tfxROndy5dmj8HKxpkX', '155142353003500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lLOLMygjjBfZopBfIUn', 'jkpTHKg7DpuXQrppVxx', null, 'BrbFcB3ptMyxdPl5W6u', '0', '1JVZYNRouHUK7MH0xzc', '155142353115800003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('LmDXQ0PlVB4FL8VHUJR', '3tFw1boS5L9vXoJCr6Z', null, 'TqQZlnV3BVaRGCm4tXn', '1', 'UsdBObB53oqCjmBMNib', '154563949489800002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('LMj2R6oF1VHr2fPSYxb', '0Q0LkJpfR1ejtO8rD3p', null, 'rfmGjP7LXiQfxy15izp', '1', '5RmGeLAjzOblugQN5jG', '155168789449900002', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('lmt8mPVnxxXO1r5O5ql', '0Q0LkJpfR1ejtO8rD3p', null, 'U1TygLjjsSxDfEoGwhc', '1', 'ih9o5BJcd9TxtaItt0i', '155168789343800001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('LmX1PQ7XlPnz3uUCJNW', 'kPLbeydkgiYW6NIkCt0', null, 'pr4QXSdeHJHNRiWlpyU', '2', 'pr4QXSdeHJHNRiWlpyU', '155168804469600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LN99xwwUI9vvlIJsCZR', '2jSs6cnzu4mzY9C13vF', null, 'tXSz1JBmnuwUf1VB2vL', '2', 'tXSz1JBmnuwUf1VB2vL', '155142339562500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lNG0i0WE1Rsq110nhUh', 'kPLbeydkgiYW6NIkCt0', null, 'eKZqOwJmAFsUEwu0WfL', '1', 'eKZqOwJmAFsUEwu0WfL', '155168804560100004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('LNzqfazFqbsmC5vyV4E', 'WB81MbCBolNg6XmE35M', null, '11e6-5618-d28fc4ff-91c5-cd8abd28b1f9', '2', '11e6-5618-d28fc4ff-91c5-cd8abd28b1f9', '155141104783900003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lOd5RA8JAU3RwuvRDYQ', 'kPLbeydkgiYW6NIkCt0', null, 'c8qqHIRjZCxEMPx5YoO', '1', 'c8qqHIRjZCxEMPx5YoO', '155168804602200005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('LoF0XkkyvB9sliQ5MAt', 'WB81MbCBolNg6XmE35M', null, '11e6-593f-2eaf97f7-a94a-e36ebd4ccf2c', '0', '11e6-5a22-546e20cd-9288-a3f5193ed8de', '155141105152100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('LofuDFHrkfVor4bO18Q', '0Q0LkJpfR1ejtO8rD3p', null, 'XOjVSXTJxQ9WnTO8TmN', '1', 'XOjVSXTJxQ9WnTO8TmN', '155168789373500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('LOP9OpJfFbctUhVFQUK', '2jSs6cnzu4mzY9C13vF', null, 'rfmGjP7LXiQfxy15izp', '1', '5RmGeLAjzOblugQN5jG', '155142339834000000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('Lpmky0S0ykFgFW3abTl', '2jSs6cnzu4mzY9C13vF', null, 'w7IsSOtXFvo61cP8sKr', '1', 'bdnOlGNgir39pNIV5w3', '155142339777800000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('LPT1sRPASrAVolWSf2k', '3tFw1boS5L9vXoJCr6Z', null, 'm8moRuOLRGU8fSbCIty', '0', 'Z6h9QsC5gMpu1hmPip2', '154563949483600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('LPXkA80pjOCueMQ6TXU', '3tFw1boS5L9vXoJCr6Z', null, 'nv2ul1HAiYcvTtoT6Lr', '1', 'nv2ul1HAiYcvTtoT6Lr', '154563949571000005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Lq2kJ17419bXOwypa45', 'WB81MbCBolNg6XmE35M', null, '11e6-5612-5b4753a9-91c5-cd8abd28b1f9', '2', '11e6-5612-5b4753a9-91c5-cd8abd28b1f9', '155141104751200001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lQ6sHdJSSTzasbiEjTq', 'jkpTHKg7DpuXQrppVxx', null, 's8qcshfzszuUknfhZNl', '2', 's8qcshfzszuUknfhZNl', '155142352953600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lQbnDqBUZwNxNUqtRKu', '2jSs6cnzu4mzY9C13vF', null, 'ArQpV2XcSwZaAGmiCGT', '2', 'ArQpV2XcSwZaAGmiCGT', '155142339614000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LqZKDAlxG7hr1R6fBXv', '2ytUeoxBqghwofmBALl', null, 'NGN4SO4fu5S5XxULG4X', '1', 'NGN4SO4fu5S5XxULG4X', '154461618925700003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Lrejig2qH23vyzl213b', '3tFw1boS5L9vXoJCr6Z', null, 'LY2n5aO7h1TrpoHU2mc', '1', 'LY2n5aO7h1TrpoHU2mc', '154563949574100001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('lRfBr1AinNjyIBqf7Fi', 'kPLbeydkgiYW6NIkCt0', null, 'EaVrfjS89IZqE63BWPa', '0', '9YwViaujJTr161CesBX', '155168804631900000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('LRkuuInnjAlnVwVmrJv', '0Q0LkJpfR1ejtO8rD3p', null, '0zSRHMqiyMTl1dth7ds', '1', '0zSRHMqiyMTl1dth7ds', '155168789357900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('LRLtTtWGD0Omf1hYdoK', '3tFw1boS5L9vXoJCr6Z', null, 'LHgnhFx0bsvuS1fUhBi', '0', 'bBLadEJMfkOsH44bqZy', '154563949513200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Lrz1B9NpMS78IUFreDd', 'jkpTHKg7DpuXQrppVxx', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'SmYDAD9eEDzqIUvO99F', '155142353065900001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('lRzbRlt7gDwpf8obJBK', 'WB81MbCBolNg6XmE35M', null, '11e6-549a-e2332c7e-9671-379f935a9949', '1', '11e6-54a0-fa7682b9-9671-379f935a9949', '155141105056900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('ls0zQ9gheFvW7aSsPdk', '0Q0LkJpfR1ejtO8rD3p', null, 'HqyysOeWOVkmU29sLla', '0', 'K6e79wYCTJXzxMeQIon', '155168789400000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('LS5qzidtA8VbgKQBiW8', 'kPLbeydkgiYW6NIkCt0', null, 'wwsNkkwFEvqL44gK2fM', '0', 'ITAEcCLmB4JM7hMwJQC', '155168804569500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('LsayHeGsjMUvaFSa1Rt', '2ytUeoxBqghwofmBALl', null, '3K4lxgBhBLAbzJrfYaB', '1', 'j2jPRJ7cK9BqO2p9iP9', '154461619147600003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Lt4OyDpsnra9P5BqaCc', '0Q0LkJpfR1ejtO8rD3p', null, 'LsrnkDvx5pdkA6JnHuj', '2', 'LsrnkDvx5pdkA6JnHuj', '155168789292300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lt6nKfSNSQdxcMP8emC', '2ytUeoxBqghwofmBALl', null, 'EGmIBh1ogGUoD8df1rE', '1', 'EGmIBh1ogGUoD8df1rE', '154461619072600005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('lt9uGGh7QWIpsyoYNHQ', '2ytUeoxBqghwofmBALl', null, 'ezzP5oVH4ywB1HmiObF', '1', 'ezzP5oVH4ywB1HmiObF', '154461618821000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ltF7aS7rAiImftgqdCJ', '0Q0LkJpfR1ejtO8rD3p', null, '8DmOHAVRvs3BblbhJoa', '1', '8DmOHAVRvs3BblbhJoa', '155168789346900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('LtFi5WKATeGIfeTd39n', 'kPLbeydkgiYW6NIkCt0', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'QOJ06s8WUaokm0sdBKM', '155168804631900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('lTGqJcVCvFFrAlha8V8', '3tFw1boS5L9vXoJCr6Z', null, 'Q1jIFlIQgvrxXHuYM9L', '2', 'Q1jIFlIQgvrxXHuYM9L', '154563949452300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LTh72hFud7WSEv6uYv6', '2ytUeoxBqghwofmBALl', null, 'KQSVH3r5JbmIAoPEf1R', '0', 'FpCOlrvb0mWq2jRlD44', '154461619025700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('lTTIMBaZQGIGi4t0p9G', '0Q0LkJpfR1ejtO8rD3p', null, 'oeLOJO0f3CC02OjOOIC', '0', 'Wvgpr80lY60tZ8EcoLc', '155168789393700003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('lttpisYy9AfteZDDosN', '3tFw1boS5L9vXoJCr6Z', null, 'DH7Zen0eWUXbjpOEAKb', '2', 'DH7Zen0eWUXbjpOEAKb', '154563949444500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LU3DNfHOwFAkhh8BllF', '0Q0LkJpfR1ejtO8rD3p', null, 'ZM7F9MjjscP8bADF7cH', '1', '0LKFnyB5ViPnDQN8Ocl', '155168789364100003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('LU64yCmdZuoD14e7gND', '3tFw1boS5L9vXoJCr6Z', null, 'GkSLWRbQwybXSXPOABb', '2', 'GkSLWRbQwybXSXPOABb', '154563949441300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LU6XemXtP8sXHcoBcdX', '3tFw1boS5L9vXoJCr6Z', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'APxRfhpMtHJp5vsjIIa', '154563949527300004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('lUavUtE3ep5u31KzlKK', 'kPLbeydkgiYW6NIkCt0', null, 'dOBS9ubbO1XiVfY9ndg', '2', 'dOBS9ubbO1XiVfY9ndg', '155168804464900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LuCD9jayw8fPOlyXNdO', '3tFw1boS5L9vXoJCr6Z', null, 'ddbeKTjs0WvqKVJ90MU', '1', 'ddbeKTjs0WvqKVJ90MU', '154563949500700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('lue6sR0b9yRAhgijwbO', '0Q0LkJpfR1ejtO8rD3p', null, 'Dp0d6MuuCtsiTwqL6qe', '2', 'Dp0d6MuuCtsiTwqL6qe', '155168789334500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lUG3KUhzz4FYWia4Zpv', '2jSs6cnzu4mzY9C13vF', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'gP7qA2QTRCEqWmdByHT', '155142339776200000', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('luI4L1OKOmR0yGnHMEI', '2jSs6cnzu4mzY9C13vF', null, 'b76ggxFJ4XBOIQkmVoY', '2', 'b76ggxFJ4XBOIQkmVoY', '155142339550000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lUpEt0im87Xx8Fq6pQo', '2ytUeoxBqghwofmBALl', null, '3gGNzYyE5dK9ogZidWA', '1', '1yFGNlNaVN83hKJQ7vt', '154461619089800001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('luvFFBGkdAN2G66CHPX', '0Q0LkJpfR1ejtO8rD3p', null, '5XKkpkend5hrAy8xWlc', '1', '5XKkpkend5hrAy8xWlc', '155168789362500003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('lUXDgkVYcZIvCuRKBxu', '3tFw1boS5L9vXoJCr6Z', null, 'WOmzvkui5ZsoZu1CogR', '1', 'GtjuDeHrOcWix1W5qZC', '154563949553800002', 'HdPeBqYwJyFyjHkhZu3', '签章', '46', '1');
INSERT INTO `t_permission` VALUES ('LuXX1O1jQwEWnsFLiGQ', '0Q0LkJpfR1ejtO8rD3p', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'IajyYUcsSuyg4dFRXdR', '155168789459300004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('lVb93baAK2q6HBUkHsu', '2ytUeoxBqghwofmBALl', null, '6esIc2fTAI9nAOoOZcp', '1', 'ngq5KVxqa5NRDO7OoHy', '154461618949200000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('lvgRi3x3K9kjvMNQtuY', '3tFw1boS5L9vXoJCr6Z', null, 'McumxQcBkg92YPli9Ox', '1', 'McumxQcBkg92YPli9Ox', '154563949569500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('lVnUfS6LmXkxoDtp7Kd', '0Q0LkJpfR1ejtO8rD3p', null, 'iL3YpikkZUlruc5ai3D', '1', 'iL3YpikkZUlruc5ai3D', '155168789350100004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('LwgEn4DG8fVbvXDoNyP', '3tFw1boS5L9vXoJCr6Z', null, 'FKEDNCysUfAav1gze8O', '2', 'FKEDNCysUfAav1gze8O', '154563949460100005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LwGkdNZWR7huFK5HpIN', 'WB81MbCBolNg6XmE35M', null, '11de-a1d8-03df0a0e-a188-7710f5ef0f5e', '0', '11e4-ceb2-509797d5-b2a1-b5b94c6fcd94', '155141104822900002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '导出Excel', '16', '1');
INSERT INTO `t_permission` VALUES ('LWLmDBieVYrjyGxB1wH', '0Q0LkJpfR1ejtO8rD3p', null, '2Icse0Cn99YRTQTZO3f', '1', '2Icse0Cn99YRTQTZO3f', '155168789482700003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('lxB91XU4PaCXdEvBPeo', '2jSs6cnzu4mzY9C13vF', null, 'b3y6CS4gmftCVXdw4Pb', '2', 'b3y6CS4gmftCVXdw4Pb', '155142339559400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lxB9edyDWPo9wfUjPPv', 'jkpTHKg7DpuXQrppVxx', null, 'F6reQ5BW7P6q236Pi13', '1', 'wK7VlAkGcNMtWEsCCF2', '155142353140800002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('ly50yFQivjNmRJBlYjO', '3tFw1boS5L9vXoJCr6Z', null, '98kmnnrWwGKmgyiIkUF', '0', 'erevZ9qTmGbUQpQWI61', '154563949517900004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('LY51DU21bSKubx3Ibhg', '0Q0LkJpfR1ejtO8rD3p', null, 'JHeHJ8lBe8BGHZfwoph', '2', 'JHeHJ8lBe8BGHZfwoph', '155168789317300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lYbodkzHluBELPRzKtN', '2jSs6cnzu4mzY9C13vF', null, '3sSURwczE2wMjgOqqOo', '0', 'rNGiDIRMmVUcl95QN9f', '155142339765300001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('lYJOXJwMfHXTVsyFrzh', 'jkpTHKg7DpuXQrppVxx', null, 'rfmGjP7LXiQfxy15izp', '1', 'N1gohv56wfzjxXMkYXQ', '155142353111200002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('lYLc2jDuIV38XSf5rb9', 'kPLbeydkgiYW6NIkCt0', null, 'o4zdmPoNHMg5JK6m6dx', '0', '2MHj4CnPnbOb2UFuMQr', '155168804642800001', 'HdPeBqYwJyFyjHkhZu3', '执行前再确认', '3', '1');
INSERT INTO `t_permission` VALUES ('lyMvKwtO2VpxEjEu82t', '3tFw1boS5L9vXoJCr6Z', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'eIRDEeewznXKf3ktljY', '154563949550700003', 'HdPeBqYwJyFyjHkhZu3', '跳转', '43', '1');
INSERT INTO `t_permission` VALUES ('lyR5VLxCpOb1ljKPONm', 'WB81MbCBolNg6XmE35M', null, '11e6-5569-e32c800c-8350-a3b9b8447d61', '1', '11e6-5570-89df4e1e-8575-9d6645ab8581', '155141105167700003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('lYXlgsgmvrusKqK0kLp', 'WB81MbCBolNg6XmE35M', null, '11e6-560b-394b645a-91c5-cd8abd28b1f9', '2', '11e6-560b-394b645a-91c5-cd8abd28b1f9', '155141104777700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('LyZJvy1vglKJZnQxm28', 'jkpTHKg7DpuXQrppVxx', null, 'IuPDe4Gm9occzflnrP0', '0', 'v6Do5TzCwJt7gNmEi1b', '155142353131400002', 'HdPeBqYwJyFyjHkhZu3', '弹出层打开', '43', '1');
INSERT INTO `t_permission` VALUES ('lz4NNDEjjfyIWu8buv7', '3tFw1boS5L9vXoJCr6Z', null, 'EaVrfjS89IZqE63BWPa', '0', '9YwViaujJTr161CesBX', '154563949591300002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('LZLqwXIi5jduQaHrDjQ', 'jkpTHKg7DpuXQrppVxx', null, 'oUGfBAkdjTsO2z22gYU', '2', 'oUGfBAkdjTsO2z22gYU', '155142352961400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('lzoi01T96ayUe9svcKL', '3tFw1boS5L9vXoJCr6Z', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'PJTrl1ydDfvxVoyGPXp', '154563949510100005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('M03sWbydQBl1BwKMxtq', 'kPLbeydkgiYW6NIkCt0', null, 'ddbeKTjs0WvqKVJ90MU', '1', '5fbpm1XlYeZn8KXFMNL', '155168804555400002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('M05ztqkJ4GXpiwxDLpg', '2ytUeoxBqghwofmBALl', null, 'A6EMGp4mkUqLbMGLtql', '0', 'jvS3grY0lQM6HRUV78H', '154461619057000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('M0DpqHQkEIqboIZkG9W', '2jSs6cnzu4mzY9C13vF', null, 'TsNrOa7PU4hkaT6pxfO', '2', 'TsNrOa7PU4hkaT6pxfO', '155142339561000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('m0okVeKyjHN7Zfc76vg', '2jSs6cnzu4mzY9C13vF', null, '2F75ZJJXk8564FkCLYA', '1', '2F75ZJJXk8564FkCLYA', '155142339679500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('M0QVv5ibgSUkPx3nau5', 'kPLbeydkgiYW6NIkCt0', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'FoxNtE4HNjqsnne055E', '155168804611600000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('M0SA2TTgiricUgELitJ', 'WB81MbCBolNg6XmE35M', null, '11e6-5615-9a7a7fb6-91c5-cd8abd28b1f9', '2', '11e6-5615-9a7a7fb6-91c5-cd8abd28b1f9', '155141104785500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('m0Ur036npByI6nWRV2P', '3tFw1boS5L9vXoJCr6Z', null, 'ZM7F9MjjscP8bADF7cH', '1', 's0ipQa9ktbRum255G0J', '154563949502300004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('m1B1FbCVyGnqDXohhhV', '3tFw1boS5L9vXoJCr6Z', null, 'uiFkOAGeBPQyi2pQlVb', '2', 'uiFkOAGeBPQyi2pQlVb', '154563949460100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('m1kYeB4jZVWiNp5ivwk', 'WB81MbCBolNg6XmE35M', null, '11de-a1ce-12978c3f-a188-7710f5ef0f5e', '1', '11e8-5efb-e332a7ee-b84a-39be571b3c90', '155141104818300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存复制', '21', '1');
INSERT INTO `t_permission` VALUES ('M1MWWfxyIgHnY9BDmpZ', '2jSs6cnzu4mzY9C13vF', null, 'XOjVSXTJxQ9WnTO8TmN', '1', 'XOjVSXTJxQ9WnTO8TmN', '155142339729400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('m1pgOXWElJZ3FY8li3e', '2jSs6cnzu4mzY9C13vF', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'Bd1tki9fxPhsf7tARcy', '155142339838600002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('m1Sh27H0mAuOqQn93Yd', 'jkpTHKg7DpuXQrppVxx', null, 'IuPDe4Gm9occzflnrP0', '0', 'oD3WAF1Vtv6gB6lDCtv', '155142353133000001', 'HdPeBqYwJyFyjHkhZu3', '新窗口打开', '43', '1');
INSERT INTO `t_permission` VALUES ('M2BxiRofgDwjTOJZ363', 'WB81MbCBolNg6XmE35M', null, '11e6-5530-8ee397f4-8350-a3b9b8447d61', '0', '11e6-59f4-1bd3b41a-ab5d-51da01f3eda4', '155141104922800000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('m3806taDCysztRWEsPS', 'WB81MbCBolNg6XmE35M', null, '11e6-5530-13f122e7-8350-a3b9b8447d61', '0', '11e6-59f4-0aa8b6d4-ab5d-51da01f3eda4', '155141104925900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('M4asESGgO3FdVifOxUu', 'kPLbeydkgiYW6NIkCt0', null, 'KQSVH3r5JbmIAoPEf1R', '0', 'K4Z97NLTLZ952TInMrM', '155168804588200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('M4OXlrTpU0eFbUz6eSQ', 'kPLbeydkgiYW6NIkCt0', null, 'dtXU9EYYl4qLe8PdIVc', '0', '35iPlaPI9jj9qVEeTCZ', '155168804572600003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('m4qCCH0hHLcJjbLbDbx', 'jkpTHKg7DpuXQrppVxx', null, '36v96aPARGPLLLpXBt5', '2', '36v96aPARGPLLLpXBt5', '155142352992600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('m66bdijnqu5rJRCAMoX', 'jkpTHKg7DpuXQrppVxx', null, 'XtaVH2y40O9zvIVALWj', '1', 'XtaVH2y40O9zvIVALWj', '155142353011300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('M6FgbRb82Slwg7tyLvz', 'jkpTHKg7DpuXQrppVxx', null, '4RJ5cYekBtB1RdNDxL3', '1', '2WEniL1FLLpXKQfd5XU', '155142353080000005', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('m6zx8yQYwHRUbX323aP', '2jSs6cnzu4mzY9C13vF', null, '6bUPlXeVH92MIv7Nmdw', '1', '6bUPlXeVH92MIv7Nmdw', '155142339671700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('m785HTqWQ0MBjt8S3Yu', '0Q0LkJpfR1ejtO8rD3p', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'WL5tjQMqesP6uJhWq81', '155168789396900002', 'HdPeBqYwJyFyjHkhZu3', '批量审核', '20', '1');
INSERT INTO `t_permission` VALUES ('m7HNHQOQ2MVsQUhIh6G', '0Q0LkJpfR1ejtO8rD3p', null, 'b76ggxFJ4XBOIQkmVoY', '2', 'b76ggxFJ4XBOIQkmVoY', '155168789283000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('m8I6gfBPEpuJ3xs1SLv', 'kPLbeydkgiYW6NIkCt0', null, '4VkP5W8VPlERMiThvSD', '0', 'r8ONfNaqWuH1q18rKZk', '155168804597500001', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('m8RN1x3cTkarbkvtguZ', 'kPLbeydkgiYW6NIkCt0', null, 'nv2ul1HAiYcvTtoT6Lr', '1', 'ArAARDqxACIn5mJd2RB', '155168804605300005', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('M9EmVKlBGJHZQKwBweL', '3tFw1boS5L9vXoJCr6Z', null, 'KQSVH3r5JbmIAoPEf1R', '0', 'FpCOlrvb0mWq2jRlD44', '154563949536600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MA65CHnc6Cdu3CNRxj5', '2ytUeoxBqghwofmBALl', null, 'UmMnr5J8RhgknR3Dsos', '0', 'gxzuym0IWRzScvUoUk7', '154461619022600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('mACCOfIS98lQWzitLf8', 'jkpTHKg7DpuXQrppVxx', null, 'JJCy9khz1JRwqvX4xEI', '0', '58H52uh4rkjC2i1d2jE', '155142353053400003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MaJ6CXBkLj9UgmhlIdv', 'WB81MbCBolNg6XmE35M', null, '11e6-561a-d67355c1-91c5-cd8abd28b1f9', '2', '11e6-561a-d67355c1-91c5-cd8abd28b1f9', '155141104783900002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MAktW9I9usgYTkvxEiO', '3tFw1boS5L9vXoJCr6Z', null, 'ddbeKTjs0WvqKVJ90MU', '1', '5fbpm1XlYeZn8KXFMNL', '154563949500700003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('mapLDK1ZwhEEEb5l5WT', 'kPLbeydkgiYW6NIkCt0', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'tjznokFdoftUtJzbwhl', '155168804553900005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('MArDRukT5S1tNOKGAAy', '3tFw1boS5L9vXoJCr6Z', null, '7NlGpNC1MAEM6EuX2X0', '1', '7NlGpNC1MAEM6EuX2X0', '154563949633500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MB1ni9AicNGzBXpBzaW', '3tFw1boS5L9vXoJCr6Z', null, 'lAUkIpgQSIZqQyttrB4', '1', 'g6HusIB9Lr81fIHCCp5', '154563949507000005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('mb3uqiVrqi7nmhxBuHf', '0Q0LkJpfR1ejtO8rD3p', null, '6BIvNJISOeZ3xm8S2aG', '1', '4TEeGoSPUfMP6R1Dxgq', '155168789348500002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('mbGW4u5hNV8zLNVm6uP', '0Q0LkJpfR1ejtO8rD3p', null, 'dcaZRzor22qTnafQjNv', '2', 'dcaZRzor22qTnafQjNv', '155168789334500004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mbqW64aPQLVniZoMFaS', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-4352ce2d-91c5-cd8abd28b1f9', '2', '11e6-5619-4352ce2d-91c5-cd8abd28b1f9', '155141104754300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mC0Pk6pGKI7icZG3PDB', 'WB81MbCBolNg6XmE35M', null, '11e6-53d0-13d83c16-81f5-679a826556ce', '1', '11e6-d15f-521e8985-bbdd-9f7a0eebced4', '155141105036700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('mc7JK4YNmArM4rnN5dF', '2jSs6cnzu4mzY9C13vF', null, 'IuPDe4Gm9occzflnrP0', '0', 'v6Do5TzCwJt7gNmEi1b', '155142339866700001', 'HdPeBqYwJyFyjHkhZu3', '弹出层打开', '43', '1');
INSERT INTO `t_permission` VALUES ('mcx1ut4lirtjT7Hxjox', '2jSs6cnzu4mzY9C13vF', null, 'WOmzvkui5ZsoZu1CogR', '1', 'YTpVlB2kK9hmipw8HMw', '155142339780900000', 'HdPeBqYwJyFyjHkhZu3', '自定义打印', '30', '1');
INSERT INTO `t_permission` VALUES ('MdaCSf10LF3ZeNI4XoN', 'jkpTHKg7DpuXQrppVxx', null, '5RzsvfgAUx2y0k1pDlg', '0', 'ukXAzRjE6lHNKWb0XN5', '155142353164200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Mdc6soynI9ynZAJwOur', '2ytUeoxBqghwofmBALl', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'iURMg4fbNkBkiB0qxra', '154461618960100003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('MdFZlVXxAqLwYuMb6U6', '0Q0LkJpfR1ejtO8rD3p', null, 'ir2OPEdZvttSUxAzfmD', '1', 'C6hePhUj7uuuUyJJSuq', '155168789346900000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('MDFZqErzBpvWsXLf4hz', '3tFw1boS5L9vXoJCr6Z', null, 'eKZqOwJmAFsUEwu0WfL', '1', '3jy9fTiYM0hwEHejpTu', '154563949507000001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('mdi5vptde6cQhN1DhML', '2ytUeoxBqghwofmBALl', null, 'g2XzgmKDL1T8UB79GZh', '0', '1uOt5KaDxl3ZK3OT1Mw', '154461618936700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('MdL4zKn3ptTciyaAKlI', 'jkpTHKg7DpuXQrppVxx', null, 'jWiazgyndKfhYY4uvW8', '2', 'jWiazgyndKfhYY4uvW8', '155142352956700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mDO6mJiHlHDvWpHoQqK', '2jSs6cnzu4mzY9C13vF', null, 'dcaZRzor22qTnafQjNv', '2', 'dcaZRzor22qTnafQjNv', '155142339626500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MDqbY43jKRNdMfsI947', '0Q0LkJpfR1ejtO8rD3p', null, 'vCWvTbPligxwrkrwAv8', '0', 'akF0OOm8JnnvHsDhrLQ', '155168789481100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('MDseliBLxVbZYwLrncx', 'WB81MbCBolNg6XmE35M', null, '11e6-5e20-ab770fe8-ae15-3d6b584ebd70', '2', '11e6-5e20-ab770fe8-ae15-3d6b584ebd70', '155141104760500002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mDSSu7X0yWf6BldjdyM', 'kPLbeydkgiYW6NIkCt0', null, 'RbRiCQx2QJQpvBYXZ2O', '0', 'G4jfzpgWrDz0n5RaK11', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单12', '2', '2');
INSERT INTO `t_permission` VALUES ('mDuE8Qph2XMkJFfsswx', '2jSs6cnzu4mzY9C13vF', null, 'eLFjqFngRQrIkbsdeBd', '1', 'laHgljUkGTSlRpd6Sbl', '155142339880800001', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('mdugN5bTKQhd1nYsAdZ', '2ytUeoxBqghwofmBALl', null, 'F6reQ5BW7P6q236Pi13', '1', 'F6reQ5BW7P6q236Pi13', '154461619008500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ME4vc1XWFVxg99kS3ct', '0Q0LkJpfR1ejtO8rD3p', null, '98kmnnrWwGKmgyiIkUF', '0', 'mlTio0aN6W90Aant0Mk', '155168789384400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MeAzpnZUyTTjJkntWUu', 'jkpTHKg7DpuXQrppVxx', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'kgw3nVgzE2lQ8Be6S1i', '155142353086200002', 'HdPeBqYwJyFyjHkhZu3', '关闭窗口', '8', '1');
INSERT INTO `t_permission` VALUES ('megLvIn5lDoOfsuaKx3', '2ytUeoxBqghwofmBALl', null, 'JdWD8biOlCXjkEvrwMm', '0', 'MRVrK6Uj6Z6imY0qwYm', '154461619110100005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('meKFguhNwIk966SG8ai', 'WB81MbCBolNg6XmE35M', null, '11e6-53d6-9d864d4e-81f5-679a826556ce', '1', '11e6-563c-85676161-91c5-cd8abd28b1f9', '155141105049100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('MeoIVjAVjZRk21Yz9FD', '2jSs6cnzu4mzY9C13vF', null, 'EHYHRWZlyHZcXyKrAkr', '2', 'EHYHRWZlyHZcXyKrAkr', '155142339575000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MESsXpqTPsrukEF4Hqe', '0Q0LkJpfR1ejtO8rD3p', null, 'EaVrfjS89IZqE63BWPa', '0', '9YwViaujJTr161CesBX', '155168789457700004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('metSjxbhOtmLBDMQJ6D', '2jSs6cnzu4mzY9C13vF', null, 'NGN4SO4fu5S5XxULG4X', '1', 'OH7Z3LEcqPhif8kJKhi', '155142339640500003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('MFChbYOmH4fihlrTQfg', '2jSs6cnzu4mzY9C13vF', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'kgw3nVgzE2lQ8Be6S1i', '155142339779400002', 'HdPeBqYwJyFyjHkhZu3', '关闭窗口', '8', '1');
INSERT INTO `t_permission` VALUES ('MFFgYEtThwArgfV1lAS', '2ytUeoxBqghwofmBALl', null, 'jhINwVUWllGph0gnSC6', '0', 'GdRrT9CE4nmpUBASJy2', '154461619011700007', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MFL1gVOJVRo8uOZ9Sta', 'kPLbeydkgiYW6NIkCt0', null, 'GhbQPNIblLICNGTEwqX', '0', 'CnYPYgX7tOKqpWia5h3', '155168804583500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('mFLmOiGHzR99nce95zo', 'kPLbeydkgiYW6NIkCt0', null, 'Z5slsKyCh5Eg2s6qSK5', '2', 'Z5slsKyCh5Eg2s6qSK5', '155168804477400004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MFOy3RvXmVIeg0HYCyG', '3tFw1boS5L9vXoJCr6Z', null, 'gHKBmQ7kx8ThwKaSbuk', '2', 'gHKBmQ7kx8ThwKaSbuk', '154563949449100005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MFToK4MALBimuZc237H', 'kPLbeydkgiYW6NIkCt0', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'E47mVx0cWjUwctEiuIt', '155168804577300000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MGf9XqXd6YCsNET21IV', '0Q0LkJpfR1ejtO8rD3p', null, 'laN4VVChl81K10rDCWr', '1', 'laN4VVChl81K10rDCWr', '155168789434300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('mgK0MlbletVOjRYAACD', '2ytUeoxBqghwofmBALl', null, 'XAQy4mQfPb9hnyOISK1', '0', 'jekyDtY4Gsod5cEuiVD', '154461619021000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('MgR7NbKWb5P9Q1AO0CN', '0Q0LkJpfR1ejtO8rD3p', null, 'nv2ul1HAiYcvTtoT6Lr', '1', 'nv2ul1HAiYcvTtoT6Lr', '155168789435900002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('mhUVgs9NtIHVOgr0n54', '2jSs6cnzu4mzY9C13vF', null, 'j4ncSyWthzCYoNj3n4J', '0', 'WWNamo3Hl2Q5IoZUFn7', '155142339835500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('mhWBFeUQz4PgA2tPywL', 'kPLbeydkgiYW6NIkCt0', null, 'WHKujMuxTp67TYMu80o', '0', '7wT8mURPGaaDwJxvvHC', '155168804630300000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('mHXDmRn3woO2V3OMvhB', '3tFw1boS5L9vXoJCr6Z', null, 'CUiq0kurilZ2dSBIXUv', '0', 'Ksb2IhhfWaj5cJWTMwr', '154563949524100005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('mI53si2BeGphWw5Yr4m', 'kPLbeydkgiYW6NIkCt0', null, '0N8ygEUeoPdGG6HeaCN', '0', '6xRCL09Unhc8wBKXBhV', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单11', '3', '2');
INSERT INTO `t_permission` VALUES ('miExa3CEO8z2CQeO6In', '3tFw1boS5L9vXoJCr6Z', null, 'lOgu0Jvq0z5dlveyrnY', '0', '5XIqbMcQ6K0lFtVi4HZ', '154563949580400003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('mIODiNuHyCGl3kD5FTI', '2ytUeoxBqghwofmBALl', null, 'WOmzvkui5ZsoZu1CogR', '1', 'YTpVlB2kK9hmipw8HMw', '154461619041300001', 'HdPeBqYwJyFyjHkhZu3', '自定义打印', '30', '1');
INSERT INTO `t_permission` VALUES ('miZLyvdTC0HCxzZatkj', '0Q0LkJpfR1ejtO8rD3p', null, '4mTMb4cMMoLDRa0FTzS', '2', '4mTMb4cMMoLDRa0FTzS', '155168789289200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mj0mQrURLx9EtEF3iQT', '2ytUeoxBqghwofmBALl', null, 'x2qgUpE8u9jmGEWbbQm', '1', '1x0dmC76v20LfiQLJDC', '154461619061700001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('MJA0555V8u0zPgEAIbV', '2ytUeoxBqghwofmBALl', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'gUlSUpqhlS2ym2ijZAg', '154461618942900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MjfbnO3GdNKin2Bq1Ww', '3tFw1boS5L9vXoJCr6Z', null, 'vDsnTykdPOblfwEF4mR', '1', 'g26NwXh1sSVhmkBCy8v', '154563949611600002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('mji60FzlUN6mb8pSrk5', 'WB81MbCBolNg6XmE35M', null, '11de-c39b-5cf3eb81-b652-871d9b638147', '1', '11e6-d15d-d818663d-bbdd-9f7a0eebced4', '155141104871300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('MJp99eJwyLnLxW5eqim', 'WB81MbCBolNg6XmE35M', null, '11de-a1c6-fdf40dd0-a188-7710f5ef0f5e', '1', '11e1-6dc7-8fbb1f9d-9ed5-651613166675', '155141104837000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('MjVawuXBEDZ3KmdkKad', 'jkpTHKg7DpuXQrppVxx', null, 'WOmzvkui5ZsoZu1CogR', '1', 'i12huWXbQz9KJExHc6D', '155142353087800002', 'HdPeBqYwJyFyjHkhZu3', '文件下载(路径脚本需完善)', '26', '1');
INSERT INTO `t_permission` VALUES ('Mjxk5KoDwDWpJ0mqhEM', '2ytUeoxBqghwofmBALl', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K8Lx8Yr2KhbHQo4z25I', '154461618961700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MK07dmrNV1exf8GGApc', '3tFw1boS5L9vXoJCr6Z', null, '2F75ZJJXk8564FkCLYA', '1', 'aYBPeZTWDS1YHS4MWF5', '154563949497600002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('MK8rTYSUf3pNIJtOjlr', 'kPLbeydkgiYW6NIkCt0', null, 'iS0C05zNyVJaInb9Lvo', '2', 'iS0C05zNyVJaInb9Lvo', '155168804494600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MkAi64xGxWfNWOOobnz', 'kPLbeydkgiYW6NIkCt0', null, 'w7IsSOtXFvo61cP8sKr', '1', '0km7YEvweo5SVWbQlku', '155168804592900005', 'HdPeBqYwJyFyjHkhZu3', '归档', '45', '1');
INSERT INTO `t_permission` VALUES ('mKcmA1LuJlgJUywHYYk', 'jkpTHKg7DpuXQrppVxx', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'tjznokFdoftUtJzbwhl', '155142353030000005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('MKt2DiOmV3CXK1lPVWu', '2jSs6cnzu4mzY9C13vF', null, 'WrG5tW3KzqYHU2QYywI', '2', 'WrG5tW3KzqYHU2QYywI', '155142339601500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mKuHR5zIARjjeLpgIzy', '2ytUeoxBqghwofmBALl', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'eTfrqgZ8RLViOksDpqV', '154461618882000001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('mkXWhs2U2OeSQmxSfLg', 'WB81MbCBolNg6XmE35M', null, '11e6-546d-1bedb3b5-9671-379f935a9949', '1', '11e6-5472-eb38775f-9671-379f935a9949', '155141104954000002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('mkxYP5ynV4hFVoKollf', '0Q0LkJpfR1ejtO8rD3p', null, 'enhnCZbrTQ1mZpn18o5', '0', 'iqufoXl2qzIWDFkt1Vi', '155168789460800002', 'HdPeBqYwJyFyjHkhZu3', '获取第一个查询条件的值', '1', '1');
INSERT INTO `t_permission` VALUES ('mkzfkoKFetFxYdHdfMH', 'jkpTHKg7DpuXQrppVxx', null, 'Q1jIFlIQgvrxXHuYM9L', '2', 'Q1jIFlIQgvrxXHuYM9L', '155142352973900004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MlCcitebRf4UdLuyUvs', '3tFw1boS5L9vXoJCr6Z', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'kYjMqLc40QkdYGXLHWO', '154563949575700003', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('mLiJbLw8vDbY5lcz4qw', '2ytUeoxBqghwofmBALl', null, '3K4lxgBhBLAbzJrfYaB', '1', '3K4lxgBhBLAbzJrfYaB', '154461619107000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MLnAt4FNNEyUt2fNYxZ', 'kPLbeydkgiYW6NIkCt0', null, 'LY2n5aO7h1TrpoHU2mc', '1', 'LY2n5aO7h1TrpoHU2mc', '155168804608500003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MloFbZ8iVYfaxxJibmx', 'jkpTHKg7DpuXQrppVxx', null, 'avS4WYnlhLiRlkXIHhD', '2', 'avS4WYnlhLiRlkXIHhD', '155142353005100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mlRTiWimZDO1mxyNG1k', '2ytUeoxBqghwofmBALl', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'IajyYUcsSuyg4dFRXdR', '154461618955400001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('mlwyEvGn9Hi6ABB6xrZ', 'jkpTHKg7DpuXQrppVxx', null, 's4T0yhSw1lIJMsiBfQa', '2', 's4T0yhSw1lIJMsiBfQa', '155142352983200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mMAMdSyBmuP3ZX9L2x5', 'jkpTHKg7DpuXQrppVxx', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'QOJ06s8WUaokm0sdBKM', '155142353120500001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MMArV30h0Zl2OhjGVP6', 'jkpTHKg7DpuXQrppVxx', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'Bd1tki9fxPhsf7tARcy', '155142353112700002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('mMlsRwc8hDxWL26P1iZ', '2ytUeoxBqghwofmBALl', null, '7fddj0hyGNlDYSZpyFZ', '1', '7fddj0hyGNlDYSZpyFZ', '154461619132000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MMtDNQp0ALkpmSACSv6', '0Q0LkJpfR1ejtO8rD3p', null, 'g2XzgmKDL1T8UB79GZh', '0', '8yld9hcbZOKvZi6xp2Q', '155168789454600004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MmzkjdCooKv4LS28Cw4', '2ytUeoxBqghwofmBALl', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'JyfgeJsIiLDXbY9SXJ7', '154461618914800001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('mn3wa6EXFsQ9nZFP3hg', 'jkpTHKg7DpuXQrppVxx', null, '3sSURwczE2wMjgOqqOo', '0', 'rNGiDIRMmVUcl95QN9f', '155142353078400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('mnhpVLDFhB3jrwwSdBk', '3tFw1boS5L9vXoJCr6Z', null, 'NyOvQfCmNxbiRG9N00v', '2', 'NyOvQfCmNxbiRG9N00v', '154563949452300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mnR2iYltbq6q2nxYFfV', 'jkpTHKg7DpuXQrppVxx', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'LGI4kXh1sQ9vMEdPg6S', '155142353083100003', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('MnX0tbTWbdUlaifYtuz', 'kPLbeydkgiYW6NIkCt0', null, '0zSRHMqiyMTl1dth7ds', '1', 'EbrSUqhaaWu3vkwQzkZ', '155168804552300001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('MoA3PJjr04sqPownmBE', '0Q0LkJpfR1ejtO8rD3p', null, 'QKYvQ00K4tWyyjKycUC', '0', 'vDCiwAlHhexzsJITERJ', '155168789454600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('mOcdYcIj4xsFHwFEAkl', 'WB81MbCBolNg6XmE35M', null, '11de-7666-1dc7f93b-8d52-0547317ddd4c', '1', '11de-7666-1dc7f93b-8d52-0547317ddd4c', '155141105128700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('mOIfi1Q5gMMojK6bbLT', '2jSs6cnzu4mzY9C13vF', null, 'Tm9KRBnKnzjuuld7bJh', '0', '5GCo50RaCJdscjJW16V', '155142339759100004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('momNTaGoBkAv502aKya', '0Q0LkJpfR1ejtO8rD3p', null, 'GP2yEPcfqN4Gwg8M4Da', '2', 'GP2yEPcfqN4Gwg8M4Da', '155168789300100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MoyjJDHnglgpfU5PHdb', 'kPLbeydkgiYW6NIkCt0', null, 'vZjJlrJAj7XdNX3czmS', '0', 'Mk4H4HSkj1saDLiahVH', '155168804571000003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('moZHQAORYfYfGGBpA1A', 'kPLbeydkgiYW6NIkCt0', null, 'YAsL41bmDXtb0dBUQcb', '2', 'YAsL41bmDXtb0dBUQcb', '155168804516400003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mp2TFNZclQfJ9IwUXpz', '2jSs6cnzu4mzY9C13vF', null, 'jhINwVUWllGph0gnSC6', '0', 'CbRpWeZs7qQG3vfc9YZ', '155142339754400001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('mpAZcxLInoq5tNifIjc', 'kPLbeydkgiYW6NIkCt0', null, 'MIExqx2MWO5cunDiuaX', '1', 'MIExqx2MWO5cunDiuaX', '155168804560100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MPIhAY3lJCYGmvJS6ZY', 'kPLbeydkgiYW6NIkCt0', null, 's8qcshfzszuUknfhZNl', '2', 's8qcshfzszuUknfhZNl', '155168804468100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mPRN3yw2IOPAv1vY5nP', '2ytUeoxBqghwofmBALl', null, '5RzsvfgAUx2y0k1pDlg', '0', 'ukXAzRjE6lHNKWb0XN5', '154461619146000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('mPTR52oBWgXjkcAUvxH', 'kPLbeydkgiYW6NIkCt0', null, '4RJ5cYekBtB1RdNDxL3', '1', '4RJ5cYekBtB1RdNDxL3', '155168804589700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MpWTPTRcyX9lsUXR2xv', '3tFw1boS5L9vXoJCr6Z', null, 'XAQy4mQfPb9hnyOISK1', '0', 'jekyDtY4Gsod5cEuiVD', '154563949533500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('mQ1HjWfIRROXBYHpu0g', '3tFw1boS5L9vXoJCr6Z', null, 'ir2OPEdZvttSUxAzfmD', '1', 'C6hePhUj7uuuUyJJSuq', '154563949488200002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('Mq20kAkrQbV2qNU9wUA', '0Q0LkJpfR1ejtO8rD3p', null, 'HPxu0lHX6xisYxe5W5t', '2', 'HPxu0lHX6xisYxe5W5t', '155168789326700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Mqn3b4eYj6pvulZZn8b', 'kPLbeydkgiYW6NIkCt0', null, 'SLlYfxXLhB0ZnQ8ZAlu', '0', 'pvVAGtvgbl0lhiCLP4H', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单3', '2', '2');
INSERT INTO `t_permission` VALUES ('MQq7eMxHUxKkJSIHuDD', '3tFw1boS5L9vXoJCr6Z', null, 'qU8WM5a2IVVudiqn38E', '1', 'qU8WM5a2IVVudiqn38E', '154563949571000004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MQtZWqjqLhno36MiWAN', '2jSs6cnzu4mzY9C13vF', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'kYjMqLc40QkdYGXLHWO', '155142339813700001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('mQUm51nJMYNcmkP8Yto', '3tFw1boS5L9vXoJCr6Z', null, 'Gc5icb2c0g8ARf7Jath', '0', 'nHElJbBXVkEhXwGIaUL', '154563949478800003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MQUqswAlnTNVMCtMIKk', 'WB81MbCBolNg6XmE35M', null, '11e6-5e00-88552092-ae15-3d6b584ebd70', '2', '11e6-5e00-88552092-ae15-3d6b584ebd70', '155141104785500002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mr4SXodjJhCnsW6aDPK', 'kPLbeydkgiYW6NIkCt0', null, 'qAcxhZ5mnoiohEBYD9G', '2', 'qAcxhZ5mnoiohEBYD9G', '155168804474300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mrD1keelBLIqh0EBQbs', 'jkpTHKg7DpuXQrppVxx', null, '66LHqZTlRhXpEZAIoTa', '2', '66LHqZTlRhXpEZAIoTa', '155142352969200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mrdekozVI6ClfW3oefK', 'jkpTHKg7DpuXQrppVxx', null, 'CUiq0kurilZ2dSBIXUv', '0', 'XxEDLxeqpXRncPsDJDo', '155142353070600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MRmorWprD8f6i17o6hJ', 'jkpTHKg7DpuXQrppVxx', null, 'vDsnTykdPOblfwEF4mR', '1', 'vDsnTykdPOblfwEF4mR', '155142353142400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MrONARvlCjCmqfG2dMI', 'kPLbeydkgiYW6NIkCt0', null, 'SLlYfxXLhB0ZnQ8ZAlu', '0', 'DR68Hj8kbXNWpUOlFb0', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单3', '3', '2');
INSERT INTO `t_permission` VALUES ('mRXnNOlVEcFuTHwJ9PC', '2ytUeoxBqghwofmBALl', null, '7fddj0hyGNlDYSZpyFZ', '1', '7fddj0hyGNlDYSZpyFZ', '154461619063200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ms7UG3hoXvE9oArl4m3', 'kPLbeydkgiYW6NIkCt0', null, 'fVc4y8aYlKHvUPNHpUz', '2', 'fVc4y8aYlKHvUPNHpUz', '155168804491500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mSa4SC5mysUu3eBSwsd', 'WB81MbCBolNg6XmE35M', null, '11e6-5611-ba4f4a87-91c5-cd8abd28b1f9', '2', '11e6-5611-ba4f4a87-91c5-cd8abd28b1f9', '155141104774600003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MsdFQl4I9CNjOzD2Lcf', '3tFw1boS5L9vXoJCr6Z', null, 'F6reQ5BW7P6q236Pi13', '1', 'wK7VlAkGcNMtWEsCCF2', '154563949610100001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('MSH5znkjTRVsdDYOFFO', '0Q0LkJpfR1ejtO8rD3p', null, 'QKYvQ00K4tWyyjKycUC', '0', 'ARs78PxB8dp6mXxPrKL', '155168789454600003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('MSS22HBRxIHZjs90W72', 'kPLbeydkgiYW6NIkCt0', null, 'Qi632udYFiwUydksuYy', '2', 'Qi632udYFiwUydksuYy', '155168804524200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mSVI6Mt2RBg85vm1Tpm', 'jkpTHKg7DpuXQrppVxx', null, 'f9GQrsfu9GKGRqKKPgi', '1', '3wblZ30SS7TkVHaoRy2', '155142353139200000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('mTJ6gw9f4Hr9YwZDE55', '3tFw1boS5L9vXoJCr6Z', null, 'QKYvQ00K4tWyyjKycUC', '0', 'ARs78PxB8dp6mXxPrKL', '154563949588200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('mtjKXO9fkmcAP4oIcq5', '2jSs6cnzu4mzY9C13vF', null, 'LSwQOY0mggQ0vy4752p', '0', 'GrfqbEO7sjk3s3xGl3W', '155142339908800001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('mtmRf6RfEHAZHc8WUJq', '2ytUeoxBqghwofmBALl', null, 'lOgu0Jvq0z5dlveyrnY', '0', 'eq15KrpMbnefCOE2bGq', '154461619071000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('MtZgRarAzFQOuLUXYmJ', 'kPLbeydkgiYW6NIkCt0', null, 'kCeLKcebSzaR6kBjWoC', '2', 'kCeLKcebSzaR6kBjWoC', '155168804505500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mUKRMiBa0NF3BeXgMVS', '3tFw1boS5L9vXoJCr6Z', null, 'qFSn8P14pNLldr9j5QS', '2', 'qFSn8P14pNLldr9j5QS', '154563949450700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MUUCd6aPv1Rv6tLjk4H', '3tFw1boS5L9vXoJCr6Z', null, 'ikeULZmmOeAR6XklD2T', '2', 'ikeULZmmOeAR6XklD2T', '154563949477300004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mUvyAyOzVpuN3FbJxjc', 'jkpTHKg7DpuXQrppVxx', null, '1hPCUYj6dx9rMn0NAlL', '2', '1hPCUYj6dx9rMn0NAlL', '155142352958300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mUyeVrfTOqzqNME0sEF', 'WB81MbCBolNg6XmE35M', null, '11e6-561b-051bc33f-91c5-cd8abd28b1f9', '2', '11e6-561b-051bc33f-91c5-cd8abd28b1f9', '155141104760500004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('muz4RpZaIphkU34TzpD', 'WB81MbCBolNg6XmE35M', null, '11de-7666-1dc7f93b-8d52-0547317ddd4c', '1', '11e5-a30f-568805f5-91fb-179044e9a6c7', '155141105128700003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存新增', '42', '1');
INSERT INTO `t_permission` VALUES ('MvaaHn02dixzJpZB5Av', 'jkpTHKg7DpuXQrppVxx', null, '0bgD6IPDYyID2susbqZ', '0', 'qQ3GQtV2z6ogWiGsF2D', '155142353076800005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MVbtfgzjMt6QAdjFUrr', 'jkpTHKg7DpuXQrppVxx', null, 'Vu8Q68Bom89YJDgguC9', '1', 'o0LAsNjkLfWve8FIjmu', '155142353094000001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('mveKVtd3aOJmo2goknz', '2ytUeoxBqghwofmBALl', null, 'IuPDe4Gm9occzflnrP0', '0', 'dSSZNfrsXOVhXvx7vOM', '154461618974200001', 'HdPeBqYwJyFyjHkhZu3', '页签打开', '43', '1');
INSERT INTO `t_permission` VALUES ('MVJ8eBPiRWqMCdFK310', 'kPLbeydkgiYW6NIkCt0', null, 'icLamwX0TBANfjhoCxB', '2', 'icLamwX0TBANfjhoCxB', '155168804466500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MVMeiqFcnXSHRZJBlLd', 'kPLbeydkgiYW6NIkCt0', null, 'x2qgUpE8u9jmGEWbbQm', '1', '1x0dmC76v20LfiQLJDC', '155168804610000000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('mVpZUoo8Iu1vsJyywMF', 'jkpTHKg7DpuXQrppVxx', null, 'epn8IcdUN0afirW9qZ6', '2', 'epn8IcdUN0afirW9qZ6', '155142352995700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MvQzc4stIMbqRH7y3uQ', '2ytUeoxBqghwofmBALl', null, 'QKYvQ00K4tWyyjKycUC', '0', 'vDCiwAlHhexzsJITERJ', '154461619091300000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MvZaMEzehaloWaLzUVe', 'kPLbeydkgiYW6NIkCt0', null, '5RzsvfgAUx2y0k1pDlg', '0', 'ukXAzRjE6lHNKWb0XN5', '155168804674000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MwFMtpl5GV8TtGUk0Rj', '2jSs6cnzu4mzY9C13vF', null, 'RwAgQB30vyuzPHYBb3F', '2', 'RwAgQB30vyuzPHYBb3F', '155142339553200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mwGANdTQ64Og9SX2Lyz', 'kPLbeydkgiYW6NIkCt0', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'NF5zkjoJvJNVpgmQsj6', '155168804642800000', 'HdPeBqYwJyFyjHkhZu3', '执行前提示', '3', '1');
INSERT INTO `t_permission` VALUES ('MwOJmLCVkDvtiRqSqKG', 'jkpTHKg7DpuXQrppVxx', null, 'w7IsSOtXFvo61cP8sKr', '1', '5CLK8GNJd4rBCvhU5Ge', '155142353084600001', 'HdPeBqYwJyFyjHkhZu3', '流程启动', '33', '1');
INSERT INTO `t_permission` VALUES ('MWoWTKnQh0P4WDHHSKQ', 'jkpTHKg7DpuXQrppVxx', null, '9yUEQxnm9PCrsiRLBfo', '2', '9yUEQxnm9PCrsiRLBfo', '155142352961400005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MWvQSQVMa9rzoNrfSN1', 'kPLbeydkgiYW6NIkCt0', null, '0n6dTFPWytWUOlO2aeq', '2', '0n6dTFPWytWUOlO2aeq', '155168804503900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('MWWTc4rk4vhTfBCMjZ0', 'WB81MbCBolNg6XmE35M', null, '11e6-553c-e6e8216e-8350-a3b9b8447d61', '1', '11e6-5a25-6ce3d945-9288-a3f5193ed8de', '155141105150500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('mX1aqnwxaBWoNOMiGZ7', '2ytUeoxBqghwofmBALl', null, 'zg2t1qqkaJ17B2vvX05', '0', '5YmlK5Wk3G3ZqIrhdzM', '154461619099200004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('mx5W0l97SK4urPi6Yf6', '0Q0LkJpfR1ejtO8rD3p', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'va8G9KHkziR1bHrdZwG', '155168789459300003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MxhNBgFu4b1qxVD71i4', 'WB81MbCBolNg6XmE35M', null, '11e6-561b-83a58fc2-91c5-cd8abd28b1f9', '2', '11e6-561b-83a58fc2-91c5-cd8abd28b1f9', '155141104759000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('mXLq8pqMDeciQDIEf9J', '2jSs6cnzu4mzY9C13vF', null, 'gniImP2ug7E82S1WO0L', '1', 'Ap8uKeL5gioGlQk65eL', '155142339826200000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('MXQd0876QePTs2CScxJ', '2jSs6cnzu4mzY9C13vF', null, 'j4ncSyWthzCYoNj3n4J', '0', 'KVWnOmmml6Kwm3w1RPe', '155142339834000003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MXvU3MwznMLFfvrrgTw', '2ytUeoxBqghwofmBALl', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'JyfgeJsIiLDXbY9SXJ7', '154461619088200001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('mY20bqv7OJ3xxTOCiBg', '3tFw1boS5L9vXoJCr6Z', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'QOEHg2MUz4Qp7kv5JyL', '154563949574100004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('my8XBOWPfjRF0knJg5p', '2jSs6cnzu4mzY9C13vF', null, 'gWeQH0XbGS29JGGgrvT', '2', 'gWeQH0XbGS29JGGgrvT', '155142339570300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('My9sIiTLf0fn1VgJyFb', '2ytUeoxBqghwofmBALl', null, 'XOjVSXTJxQ9WnTO8TmN', '1', 'aSYThGpCcKMF1dEwssZ', '154461618967900005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('myFt5Yj1gmVz2umUVDm', 'kPLbeydkgiYW6NIkCt0', null, 'J9uhQYSQWhPor4IvkOE', '0', 'Q2aiiWtqBNqF33UGXUy', '155168804532000002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('MYgu2tPzZPoYLpjECgL', '0Q0LkJpfR1ejtO8rD3p', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'd6qZunMLjwykDchDPZG', '155168789387500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('mZBfABdQLmTjIQ5khug', 'jkpTHKg7DpuXQrppVxx', null, 'ezzP5oVH4ywB1HmiObF', '1', 'ezzP5oVH4ywB1HmiObF', '155142353101800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MzDGUVRA6uqlZljgTeZ', '2jSs6cnzu4mzY9C13vF', null, 'zqGmDkZIRa4COpFVzTj', '1', 'xBzMYIFuvohJrsvZE5M', '155142339631200000', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('MZJgYysfOsmRFtS9fIO', '2jSs6cnzu4mzY9C13vF', null, 'NaZcYrbGaXxrTGcsd2M', '1', 'NaZcYrbGaXxrTGcsd2M', '155142339893200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('MZno79A7c04yhgq4ckW', 'kPLbeydkgiYW6NIkCt0', null, 'Dp0d6MuuCtsiTwqL6qe', '2', 'Dp0d6MuuCtsiTwqL6qe', '155168804524200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('n0NAtzR21rU9jIHJkD1', '2jSs6cnzu4mzY9C13vF', null, 'wwsNkkwFEvqL44gK2fM', '0', 'WbfBIyoU0AkbLY6hBur', '155142339741900003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('N0nPtsXg97Qpt5SBtkr', '3tFw1boS5L9vXoJCr6Z', null, '0zSRHMqiyMTl1dth7ds', '1', '0zSRHMqiyMTl1dth7ds', '154563949496000003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('N0uZtxXguYETf4m4Chg', 'WB81MbCBolNg6XmE35M', null, '11e6-53c1-c45f44a1-81f5-679a826556ce', '1', '11e6-d15f-29ff8abd-bbdd-9f7a0eebced4', '155141104936800001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('N0zeiD29FPrO1HPkgjB', '2jSs6cnzu4mzY9C13vF', null, 'nv2ul1HAiYcvTtoT6Lr', '1', 'nv2ul1HAiYcvTtoT6Lr', '155142339795000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('N2I2gBFy0y1d5JPlI56', '2jSs6cnzu4mzY9C13vF', null, '27MTAjC7JxdEukQ4fFY', '2', '27MTAjC7JxdEukQ4fFY', '155142339561000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('n2iVnFT398auLeXAwAx', '0Q0LkJpfR1ejtO8rD3p', null, '6Xi7fyFJT20APl5y8RE', '2', '6Xi7fyFJT20APl5y8RE', '155168789314200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('N2lUQDml6DCxu5CIbrF', 'WB81MbCBolNg6XmE35M', null, '11de-a1c6-fdf40dd0-a188-7710f5ef0f5e', '1', '11e6-d15e-3ecd4643-bbdd-9f7a0eebced4', '155141104835400001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('n34eTlGDm20r7raDS0w', '3tFw1boS5L9vXoJCr6Z', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'zQbdwHlWMKfQxZOw4TN', '154563949616300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('N375PmDdYpSuTJ0i6ga', '2jSs6cnzu4mzY9C13vF', null, 'e6OXY8vDBhwyntKTBcc', '1', 'e6OXY8vDBhwyntKTBcc', '155142339894800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('N3YXpfEaiz3bwThtJrE', '2jSs6cnzu4mzY9C13vF', null, 'LdUkdpc3EVM9iBygFMr', '0', 'cS0647Al36GrYYVT25b', '155142339788700004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('N4FcKeQqI7kTXMSl6lg', '2ytUeoxBqghwofmBALl', null, 'F6reQ5BW7P6q236Pi13', '1', 'Okamal6erVlSp96ygxI', '154461619011700005', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('N4ftWb9oHMTr0eExuDj', 'kPLbeydkgiYW6NIkCt0', null, 'TqagBUMFdyCepAZ3Umc', '2', 'TqagBUMFdyCepAZ3Umc', '155168804516400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('n4iab2lxFQTyMpHs3no', '2jSs6cnzu4mzY9C13vF', null, 'wjPLVvwWYR2a9BOi0st', '0', '6798mFOtT3LLK9CYgPv', '155142339799600000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('n4KBsPAklZu9tM01VRL', 'jkpTHKg7DpuXQrppVxx', null, 'EaVrfjS89IZqE63BWPa', '0', 'lPhlrrSkZ8hekbRhXPh', '155142353120500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('N4ltGXeVR1zyBwsLMho', '2jSs6cnzu4mzY9C13vF', null, 'QKYvQ00K4tWyyjKycUC', '0', 'ARs78PxB8dp6mXxPrKL', '155142339852700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('N4xus1QCL5dUEMZ1vXb', '3tFw1boS5L9vXoJCr6Z', null, 'Gc5icb2c0g8ARf7Jath', '0', 'SLsJFM3QWPsTiAQbQRE', '154563949478800004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('n4zYRpz1ElUnFhJiVnW', '3tFw1boS5L9vXoJCr6Z', null, 'mL5IgApmFXBzpokqr1u', '1', 'mL5IgApmFXBzpokqr1u', '154563949564800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('N5EpGNu4SKuRY73ttU8', '3tFw1boS5L9vXoJCr6Z', null, 'XtaVH2y40O9zvIVALWj', '1', 'cJircppYbKZxUtuClYU', '154563949480400001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('n5igxltHQSYZvMqouZH', '2ytUeoxBqghwofmBALl', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'PTTHSwtvw3HyoyAo3JB', '154461618949200005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('N5KGJbrAUTtv0S3DL0e', 'WB81MbCBolNg6XmE35M', null, '11e6-546d-1bedb3b5-9671-379f935a9949', '1', '11e6-546d-1bedb3b5-9671-379f935a9949', '155141104954000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('N5ulOSamim0yPUZsHg1', 'kPLbeydkgiYW6NIkCt0', null, '1hPCUYj6dx9rMn0NAlL', '2', '1hPCUYj6dx9rMn0NAlL', '155168804472700006', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('n5Y87FncI1Prah2Pmh4', '3tFw1boS5L9vXoJCr6Z', null, 'a7jp1Dm53YjlAwDWuws', '1', 'a7jp1Dm53YjlAwDWuws', '154563949541300003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('n6InpLXQ6yxBnxa0muF', '2jSs6cnzu4mzY9C13vF', null, 'w7IsSOtXFvo61cP8sKr', '1', '5CLK8GNJd4rBCvhU5Ge', '155142339777800001', 'HdPeBqYwJyFyjHkhZu3', '流程启动', '33', '1');
INSERT INTO `t_permission` VALUES ('n6KrDXPew1OIVmdNtaD', '2ytUeoxBqghwofmBALl', null, 'nv2ul1HAiYcvTtoT6Lr', '1', 'nv2ul1HAiYcvTtoT6Lr', '154461619055400005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('n6LkFYVM2U2GwT2wR5i', '3tFw1boS5L9vXoJCr6Z', null, 'zg2t1qqkaJ17B2vvX05', '0', '5YmlK5Wk3G3ZqIrhdzM', '154563949594500002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('N6RChS9YZS5UlOiJoyK', 'WB81MbCBolNg6XmE35M', null, '11e6-5540-7128195d-8350-a3b9b8447d61', '1', '11e6-5ae4-2eddcd14-a841-31f95f893f0b', '155141105159900003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('N82BTQelF1mkXU8Wk6C', 'jkpTHKg7DpuXQrppVxx', null, 'XOjVSXTJxQ9WnTO8TmN', '1', 'aSYThGpCcKMF1dEwssZ', '155142353045600001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('N8Aiu7LtlttOQ7LVkIW', '3tFw1boS5L9vXoJCr6Z', null, 'tfxROndy5dmj8HKxpkX', '2', 'tfxROndy5dmj8HKxpkX', '154563949475700005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('n8InFi7SEc2XFRHfWj1', '2ytUeoxBqghwofmBALl', null, 'XpNoNSLR8vialNcJDXq', '0', 'DDOwg7IIyIziyaozQTN', '154461619063200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('n8qoFz0aVtAKVCdiTVi', '0Q0LkJpfR1ejtO8rD3p', null, '66LHqZTlRhXpEZAIoTa', '2', '66LHqZTlRhXpEZAIoTa', '155168789307900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('n8wK08Q5QA7Aq6mJBfI', 'kPLbeydkgiYW6NIkCt0', null, 'NyOvQfCmNxbiRG9N00v', '2', 'NyOvQfCmNxbiRG9N00v', '155168804499300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('N9aJ4SLqbzdXu4ol4U0', '0Q0LkJpfR1ejtO8rD3p', null, 'SAzJx5AkUZOJRct29BH', '0', 'wLzLCUPc9LuRRv9j8J3', '155168789446800002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('N9D1DIm3JjVitAMCbIx', 'TzxwQuzGAOCi1aTd7o1', null, 'dOBS9ubbO1XiVfY9ndg', '2', 'dOBS9ubbO1XiVfY9ndg', '154461643399800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('N9J8xyQdwwSOd7t0Sip', 'kPLbeydkgiYW6NIkCt0', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'cY4kl4aBnqojbhnxddX', '155168804611600002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('n9vYo9ukFNbmYKxr09F', 'kPLbeydkgiYW6NIkCt0', null, 'aGwWScnt2f6X87bV5u9', '1', '4LdvPBnK70nLgMp5OzH', '155168804561700005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('nA7hUJb1MMHEM077GD6', 'WB81MbCBolNg6XmE35M', null, '11e6-5618-fe326c91-91c5-cd8abd28b1f9', '2', '11e6-5618-fe326c91-91c5-cd8abd28b1f9', '155141104754300002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nAk0CTCYbNY8JUmYjjl', '2ytUeoxBqghwofmBALl', null, 'vDsnTykdPOblfwEF4mR', '1', 'jVcLQaH4BiwznPvstCF', '154461619119500000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('naUa0cP47zK4xD9vQpy', '2jSs6cnzu4mzY9C13vF', null, 'hxDvvyWbvIEUUrBHW0R', '1', 'hxDvvyWbvIEUUrBHW0R', '155142339793400003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('NboeSrDHFAzceYHTo7o', '3tFw1boS5L9vXoJCr6Z', null, 'bkoXpI9ilQlOYD8wsbU', '1', 'eEsrQhBVYzA97RMPPGX', '154563949541300000', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('nBrVZl6ZKk8Md5z6WRd', 'WB81MbCBolNg6XmE35M', null, '11e6-5531-4f3943bb-8350-a3b9b8447d61', '1', '11e6-5533-0b7f6488-8350-a3b9b8447d61', '155141105200500002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('nBwuSFEm790zFTnwyJt', '2jSs6cnzu4mzY9C13vF', null, 'jIuyPXyzHxgmBlx4oQs', '2', 'jIuyPXyzHxgmBlx4oQs', '155142339556300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Ncl2CJC978TCNAdEnue', '0Q0LkJpfR1ejtO8rD3p', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'bOLR3Xo33mj06rfix3J', '155168789443700003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('nCul7g9P5ovy2REEvjx', 'jkpTHKg7DpuXQrppVxx', null, 'htuZKnVCqioBBZD9Tg4', '2', 'htuZKnVCqioBBZD9Tg4', '155142352955200004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('NCZ9b7X53fNQfkQvjgA', 'WB81MbCBolNg6XmE35M', null, '11e6-53c7-e8d1f5b4-81f5-679a826556ce', '0', 'RoM9VMbLDw4T5ZGffWY', '155141104941500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('ND3pmKNaT9lTYMijdzJ', '3tFw1boS5L9vXoJCr6Z', null, 'LsrnkDvx5pdkA6JnHuj', '2', 'LsrnkDvx5pdkA6JnHuj', '154563949425700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ndEyO9NiLlY6OySdTBI', '2ytUeoxBqghwofmBALl', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'AiibIdUU3zQiGsrKDXn', '154461619144500001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Ndls1cZH1iNPvoYCVYq', '2jSs6cnzu4mzY9C13vF', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'IHazLikeEs3KYw5CBgr', '155142339887000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('nDlsm7pCafzpCdI3I4c', 'kPLbeydkgiYW6NIkCt0', null, 'vCWvTbPligxwrkrwAv8', '0', 'oyuPcAc1VAmt4JtNf7A', '155168804664600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('NDRRTMtbVlWpy5uXkxF', '2jSs6cnzu4mzY9C13vF', null, 'TqQZlnV3BVaRGCm4tXn', '1', '22ZvmpjYHg3LQFPOh01', '155142339656100002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('nDwpqxZxUMsvqlXwoxs', 'kPLbeydkgiYW6NIkCt0', null, 'SAzJx5AkUZOJRct29BH', '0', 'wLzLCUPc9LuRRv9j8J3', '155168804613100001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('nEFEQMCiYjh49EUpyOz', '2ytUeoxBqghwofmBALl', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'bOLR3Xo33mj06rfix3J', '154461618872600000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('NEIfi15EwMCJRObsfMe', '2jSs6cnzu4mzY9C13vF', null, 'eLFjqFngRQrIkbsdeBd', '1', 'FdZlsUl66zL94sGKwVe', '155142339879200002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Nfns0gdLrL08IYIv0eN', 'jkpTHKg7DpuXQrppVxx', null, 'GLnzLxRphPAJ2Z2L7fM', '2', 'GLnzLxRphPAJ2Z2L7fM', '155142352994200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nFnYIfBZQ11qOvV4vCg', '3tFw1boS5L9vXoJCr6Z', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'Jbc2xwZhMLLNIjg0h02', '154563949510100004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('NFuKNQyJ6ITxVZyKtSf', 'WB81MbCBolNg6XmE35M', null, '11e6-5610-ebfd732c-91c5-cd8abd28b1f9', '2', '11e6-5610-ebfd732c-91c5-cd8abd28b1f9', '155141104783900004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('NgK6NyIoXWUX0Oh7nU1', '2jSs6cnzu4mzY9C13vF', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'CjR2ngF0kCrKnCpD0rj', '155142339702900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Nh5IMOpdyQEymYfIt6e', 'kPLbeydkgiYW6NIkCt0', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155168804483700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nHgwRpC7BY6V5s5BK3P', 'kPLbeydkgiYW6NIkCt0', null, 'P8aW26pXrA6epiJLKX0', '1', 'P8aW26pXrA6epiJLKX0', '155168804605300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('NhTNmhpzxrftHgixftv', 'WB81MbCBolNg6XmE35M', null, '11e2-5faa-5a846059-b702-3f84c4cacb0d', '1', '11e2-5fb6-1dbe6674-b702-3f84c4cacb0d', '155141104832300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('nIQreFlloZUGdSiI5mp', '0Q0LkJpfR1ejtO8rD3p', null, 'gWeQH0XbGS29JGGgrvT', '2', 'gWeQH0XbGS29JGGgrvT', '155168789304800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nIuXtlPHGnnwKQrBGuv', '2jSs6cnzu4mzY9C13vF', null, '6esIc2fTAI9nAOoOZcp', '1', '6esIc2fTAI9nAOoOZcp', '155142339682600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('NiVvBVnbcIdTjrAAcaR', 'kPLbeydkgiYW6NIkCt0', null, 'XtaVH2y40O9zvIVALWj', '1', 'bufGP6tY9wwjTOfXum5', '155168804530500003', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('nJ4rkVQ6mitzxtgqMtw', 'WB81MbCBolNg6XmE35M', null, '11de-a1ce-12978c3f-a188-7710f5ef0f5e', '1', '11e6-d15e-0bd7028b-bbdd-9f7a0eebced4', '155141104815100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Nj5lRS3w9MULzsxTL8T', '3tFw1boS5L9vXoJCr6Z', null, '5RzsvfgAUx2y0k1pDlg', '0', 'NgNicpt0mPuprqEMquB', '154563949630400004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('nJiiFNjKfYpbTfFu7BS', '2jSs6cnzu4mzY9C13vF', null, 'GhbQPNIblLICNGTEwqX', '0', 'CnYPYgX7tOKqpWia5h3', '155142339760600002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('NJOmhJynQ0mlIs9APhy', '3tFw1boS5L9vXoJCr6Z', null, 'sbkS067uQ9jIwpB6qWd', '2', 'sbkS067uQ9jIwpB6qWd', '154563949417900004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nK8EnJ9xoUZoSOEqmqn', 'WB81MbCBolNg6XmE35M', null, '11e6-5534-447f1c38-8350-a3b9b8447d61', '0', '11e6-5534-7ba4ffa5-8350-a3b9b8447d61', '155141105206700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('NKFOJMVtEuRvpbYxIpj', 'WB81MbCBolNg6XmE35M', null, '11e6-5608-19991b0c-bb59-b7243d4bcf51', '0', '11e6-57b1-96f1b740-99bd-f3f2cc3ce475', '155141105225400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '同步后台用户信息', '1', '1');
INSERT INTO `t_permission` VALUES ('NkoCD4zK0orxLSBGr1L', '3tFw1boS5L9vXoJCr6Z', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'A293BH1uO82kIt5k5f9', '154563949558500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Nmaxe96RXcmXaQKfTLo', '2jSs6cnzu4mzY9C13vF', null, 'mXDUC8go52mfA91GY0r', '0', 'P2oUhWPVibevLu0mKhp', '155142339868300001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('nMjg7ZYICs6N3hXJNJH', 'jkpTHKg7DpuXQrppVxx', null, 'WHKujMuxTp67TYMu80o', '0', 'ti2S70c11piGDmryGEq', '155142353119000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('nMKPgCa9cHb416PJhk7', '0Q0LkJpfR1ejtO8rD3p', null, 'qqHbF4LC1qdUg1ak29k', '1', 'B3jWFwhgVoeriEcsKyv', '155168789353200002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Nn0yUe5RIfqnMGIsLGy', '2ytUeoxBqghwofmBALl', null, 'P8aW26pXrA6epiJLKX0', '1', 'P8aW26pXrA6epiJLKX0', '154461619055400001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Nn8mbOgBHO9oOV2G0jE', 'jkpTHKg7DpuXQrppVxx', null, '7q6BJWxhJzTuAFZpxa8', '2', '7q6BJWxhJzTuAFZpxa8', '155142352952000004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nNBrWxLjqnFj13QNJiI', 'jkpTHKg7DpuXQrppVxx', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'erjzyEtPTNQ9Oc2MmGl', '155142353017600004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('nNjudtRhwrlpQ5sEMeh', 'jkpTHKg7DpuXQrppVxx', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'nGaEFBPrXgV7aN882KS', '155142353106500003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('nNNyybkS0uyOY16vWJt', '3tFw1boS5L9vXoJCr6Z', null, 'bkoXpI9ilQlOYD8wsbU', '1', 'bkoXpI9ilQlOYD8wsbU', '154563949539800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('nnqy3qex9B59TMo3y5Y', 'WB81MbCBolNg6XmE35M', null, '11e6-5611-dcf9a68f-91c5-cd8abd28b1f9', '2', '11e6-5611-dcf9a68f-91c5-cd8abd28b1f9', '155141104779300003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nNR8FOqtBSQl4QvmQrG', '2ytUeoxBqghwofmBALl', null, 'ZM7F9MjjscP8bADF7cH', '1', '0LKFnyB5ViPnDQN8Ocl', '154461618952300001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('NnRxVX2mSluaSrNk8rA', '2ytUeoxBqghwofmBALl', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'x2qgUpE8u9jmGEWbbQm', '154461619060100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('nNX7g7AgV9OATSV2pl3', '3tFw1boS5L9vXoJCr6Z', null, 'gniImP2ug7E82S1WO0L', '1', 'Ap8uKeL5gioGlQk65eL', '154563949578800003', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('NnyIZNzdmgenophYfv5', '3tFw1boS5L9vXoJCr6Z', null, '5XvXec6bdYRjaPxuLlQ', '1', '5XvXec6bdYRjaPxuLlQ', '154563949567900003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('noOoDU1er3pWAgirbEP', 'kPLbeydkgiYW6NIkCt0', null, '1hPCUYj6dx9rMn0NAlL', '2', '1hPCUYj6dx9rMn0NAlL', '155168804472700005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('NOpFoF3LGz5w3eaxjSn', 'kPLbeydkgiYW6NIkCt0', null, 'fAVX6iUbvHroALIUfPf', '2', 'fAVX6iUbvHroALIUfPf', '155168804474300004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('NoXI4Twb5Wg4LTlwMxD', '0Q0LkJpfR1ejtO8rD3p', null, 'WHKujMuxTp67TYMu80o', '0', '7wT8mURPGaaDwJxvvHC', '155168789457700002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('np1A2xXnUc3hOiBghQx', 'kPLbeydkgiYW6NIkCt0', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'XG8ap7ffszErnf3ZYYp', '155168804606900006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('NP4XEYIp9TxLWencz3X', '2jSs6cnzu4mzY9C13vF', null, 'vThTQ2M4QKScZTsYPVX', '2', 'vThTQ2M4QKScZTsYPVX', '155142339559400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Np5G54anYYdxR3wxaFl', '2jSs6cnzu4mzY9C13vF', null, 'exsIaz9QN0WD65u23jd', '2', 'exsIaz9QN0WD65u23jd', '155142339628000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('NPCoyBqONp0oqUrpAmq', '0Q0LkJpfR1ejtO8rD3p', null, 'm8moRuOLRGU8fSbCIty', '0', '6ieKi8bk8zbO9XkicpP', '155168789342300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('nPdTQxEdpVKJEqcoaxB', '2jSs6cnzu4mzY9C13vF', null, 'jyd4rbIxoL6EKjtSVWC', '1', 'jyd4rbIxoL6EKjtSVWC', '155142339791800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('nPnzF91jCzR5o4DRx18', 'jkpTHKg7DpuXQrppVxx', null, 'hxDvvyWbvIEUUrBHW0R', '1', 'hxDvvyWbvIEUUrBHW0R', '155142353100200003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('NPV1G0p66W0YZpeQSUN', '0Q0LkJpfR1ejtO8rD3p', null, 'UmMnr5J8RhgknR3Dsos', '0', 'RZ790ojkvhzumC5tyL2', '155168789400000004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('nPYGoNkI8RLrA9I0XJp', 'WB81MbCBolNg6XmE35M', null, '11e6-4fb1-18359874-ae2a-85737433dd16', '2', '11e6-4fb1-18359874-ae2a-85737433dd16', '155141104782400001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nQnaG3CQRkMDvol9gM9', '0Q0LkJpfR1ejtO8rD3p', null, '71ct9G1xJPW7vLgA5JB', '2', '71ct9G1xJPW7vLgA5JB', '155168789332900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nqqEKMqaPowOKGKIHWo', 'kPLbeydkgiYW6NIkCt0', null, 'HqyysOeWOVkmU29sLla', '0', 'K6e79wYCTJXzxMeQIon', '155168804585100001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('nqxmechM8wkuJe5qf8G', '2jSs6cnzu4mzY9C13vF', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'MiEVpwvQ9yx8Zb5c2bR', '155142339734100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('nqZ9DO0xtqJVRM1z55M', 'jkpTHKg7DpuXQrppVxx', null, 'U1TygLjjsSxDfEoGwhc', '1', 'ih9o5BJcd9TxtaItt0i', '155142353016000002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('nr4mVhtmTYFEeGZD3Hz', '2jSs6cnzu4mzY9C13vF', null, 'XpNoNSLR8vialNcJDXq', '0', 'WadmhwRuII4JmFt4TYS', '155142339802800003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('nRLiDeLfyCHM3tRFP1S', 'kPLbeydkgiYW6NIkCt0', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'CJu3AVSi8NfqhFlu5jl', '155168804564800005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('NrXRrjx6FMxn8Uavs47', '2jSs6cnzu4mzY9C13vF', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'P1pXLZ0kw9I6axwJEcd', '155142339667000000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('NS4KKmfn0PbtiOgT5BU', '2ytUeoxBqghwofmBALl', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'IE1QRBOyhDRgkxFpUU2', '154461618930400003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('nS7pzyCb0b9nfupDAW3', 'kPLbeydkgiYW6NIkCt0', null, 'CjR2ngF0kCrKnCpD0rj', '1', '5KOAZ5zATQsht3hJjXs', '155168804558500000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Ns8uwlMocDpYEmSuDnB', 'kPLbeydkgiYW6NIkCt0', null, 'SYAJTXtkhpXsGIAqioF', '2', 'SYAJTXtkhpXsGIAqioF', '155168804493000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nSBMVA7xpvLBBwwaM6D', 'kPLbeydkgiYW6NIkCt0', null, 'TqQZlnV3BVaRGCm4tXn', '1', 'UsdBObB53oqCjmBMNib', '155168804544500000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('NSBWJkPdSyVvSDB0EGH', 'jkpTHKg7DpuXQrppVxx', null, 'xBX9EbJkveiSGJm9xRj', '0', 'Ly9Spk5ma18fAyhAWh3', '155142353069000003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('NsPABiGpaKQdeA68a2A', 'jkpTHKg7DpuXQrppVxx', null, 'JdWD8biOlCXjkEvrwMm', '0', 'OLJQOfZpoAIKsZOpeqD', '155142353134600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('NsWbtei8aj4pJYAkK46', '2jSs6cnzu4mzY9C13vF', null, 'IiXqyN1VoajtXmJTPKS', '2', 'IiXqyN1VoajtXmJTPKS', '155142339578100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nTg56obmTAYPtgsSbj1', '2ytUeoxBqghwofmBALl', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'zQbdwHlWMKfQxZOw4TN', '154461619130400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('NtvyuOmkSAq8Xlve4QF', '2ytUeoxBqghwofmBALl', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'KDRVonlpSB5oYD1O1LY', '154461619111700004', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('NtXggAfJzGsmNrcslew', '2jSs6cnzu4mzY9C13vF', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'f4NDOEOVMi7vrgWjzz4', '155142339774700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('NU3xkxXrFN7yHb3LUUN', 'kPLbeydkgiYW6NIkCt0', null, 'yv2DP99h1j34cgCO1SZ', '2', 'yv2DP99h1j34cgCO1SZ', '155168804516400004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('nu9IFkXPd0MD4bXmkhe', '3tFw1boS5L9vXoJCr6Z', null, 'P8aW26pXrA6epiJLKX0', '1', 'P8aW26pXrA6epiJLKX0', '154563949571000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Nub7C8qSeAKrU9b6uXh', '0Q0LkJpfR1ejtO8rD3p', null, '0zSRHMqiyMTl1dth7ds', '1', 'EbrSUqhaaWu3vkwQzkZ', '155168789357900004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('NUwKH2nXeFASKpi4tHU', '2jSs6cnzu4mzY9C13vF', null, 'zg2t1qqkaJ17B2vvX05', '0', 'COoHnOHkHeviVNasUlf', '155142339860500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('nUzd9HfFgRVL8sxPWrJ', '3tFw1boS5L9vXoJCr6Z', null, '5XKkpkend5hrAy8xWlc', '1', '5XKkpkend5hrAy8xWlc', '154563949500700004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('nVHbnzwEOo0jofffOKM', '3tFw1boS5L9vXoJCr6Z', null, 'vThTQ2M4QKScZTsYPVX', '2', 'vThTQ2M4QKScZTsYPVX', '154563949433500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('NvY1A9DMyDBmrdbfAOJ', '2jSs6cnzu4mzY9C13vF', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'QOJ06s8WUaokm0sdBKM', '155142339858900000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('NVyBlrBNpbjqQMx19EK', 'WB81MbCBolNg6XmE35M', null, '11e3-99fe-5dd46414-82a9-5d3e655b6861', '0', '11de-a1db-ce8a3fa0-a188-7710f5ef0f5e', '155141104827600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('nwItSQ80PNdVLfMjt7d', '0Q0LkJpfR1ejtO8rD3p', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'nGaEFBPrXgV7aN882KS', '155168789443700005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('nwyrC6nQ5JwHT4ZxuRa', '0Q0LkJpfR1ejtO8rD3p', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Z3JLytYNIhmUl9AqEci', '155168789407800003', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('nx7ll9bPUT5kdV8JSIC', 'WB81MbCBolNg6XmE35M', null, '11e6-5ba7-b85e1b87-a270-539aa660c6fc', '2', '11e6-5ba7-b85e1b87-a270-539aa660c6fc', '155141104782400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('NXCLg5Sq4GckP5VN0C4', '2jSs6cnzu4mzY9C13vF', null, 'XzgpTEte9Q1JQswSETz', '0', 'XLZiQKl894Jrpsbimx0', '155142339897900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('NxfXbDElxOeh21Q9v5Z', '2ytUeoxBqghwofmBALl', null, 'w7IsSOtXFvo61cP8sKr', '1', '5CLK8GNJd4rBCvhU5Ge', '154461619036700000', 'HdPeBqYwJyFyjHkhZu3', '流程启动', '33', '1');
INSERT INTO `t_permission` VALUES ('Nxv6lo20dumWPhzjUxq', '0Q0LkJpfR1ejtO8rD3p', null, 'qqHbF4LC1qdUg1ak29k', '1', 'qqHbF4LC1qdUg1ak29k', '155168789353200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ny9iszFfTdvy1OTKyjH', 'kPLbeydkgiYW6NIkCt0', null, '71ct9G1xJPW7vLgA5JB', '2', '71ct9G1xJPW7vLgA5JB', '155168804521100004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('NyGX8mFCfv8c4MfCs4y', '2ytUeoxBqghwofmBALl', null, '6bUPlXeVH92MIv7Nmdw', '1', 'RUXaoNPGKk4u8FtSPTh', '154461618941300003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('NYHUL3XlYLkLrzuAhOP', '3tFw1boS5L9vXoJCr6Z', null, 'OGMmff1QTZYqFk5vfeD', '1', 'KTmmfPfwuB4gGJuw9fD', '154563949483600001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('NYlEEDFIfEKe6bwCByu', 'jkpTHKg7DpuXQrppVxx', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'sMlqIILsNZ3bvqE2hSm', '155142353016000004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Nylf4UwLGRs5y2O0Bdf', '0Q0LkJpfR1ejtO8rD3p', null, 'jYDgN5WH46paTNLcCqi', '0', 'MfAD53jYG4vMOBrhLRM', '155168789418700002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('NySyXFdkXhLkBzA74Ko', '3tFw1boS5L9vXoJCr6Z', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'weZ9Sz2X5RBVBRpCdJM', '154563949617900001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('NYwfTyoc9BPVq0bh1KT', 'kPLbeydkgiYW6NIkCt0', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'sMlqIILsNZ3bvqE2hSm', '155168804538300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('nyXwMDlYpG4fDcalt3w', '2ytUeoxBqghwofmBALl', null, 'smthlnru9z9qwavJKk1', '0', 'AHJzoQDdLpyRpZLTTdK', '154461619099200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Nz0ncz7MggIVCCSfBOu', '0Q0LkJpfR1ejtO8rD3p', null, 'EaVrfjS89IZqE63BWPa', '0', 'lPhlrrSkZ8hekbRhXPh', '155168789459300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('NzkZYhfj8xSVqYtePcW', 'kPLbeydkgiYW6NIkCt0', null, 'F6reQ5BW7P6q236Pi13', '1', 'F6reQ5BW7P6q236Pi13', '155168804650600003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('o1anbpCj0cqPba7wMNu', 'kPLbeydkgiYW6NIkCt0', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '155168804566300002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('o1Z91vDUWI8okwJOMAe', '3tFw1boS5L9vXoJCr6Z', null, 'kA4m81roWetnkDQgWm0', '0', 'fc8oYpPYk2t3xyohWqx', '154563949514800004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('O2bB4GuaU8LmADLApma', 'jkpTHKg7DpuXQrppVxx', null, '06Me4ssjoGBiKz0gMK2', '0', 'ZEh1qpMCAgYe10KWd1j', '155142353151700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('O2ySy80faA8wEToNpHA', '0Q0LkJpfR1ejtO8rD3p', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'P1pXLZ0kw9I6axwJEcd', '155168789351600002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('O3765airhNEy6XuyNfS', 'jkpTHKg7DpuXQrppVxx', null, 'IuPDe4Gm9occzflnrP0', '0', 'LFydu54akpsq9Y9sCQr', '155142353133000002', 'HdPeBqYwJyFyjHkhZu3', '载入其他视图', '1', '1');
INSERT INTO `t_permission` VALUES ('O3hYU8ZxPKMgc4mI9i4', 'WB81MbCBolNg6XmE35M', null, '11e6-5e11-d8696763-ae15-3d6b584ebd70', '0', '11e6-5e11-e4c5023b-ae15-3d6b584ebd70', '155141104996100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('o592dQcEHfg1FENIDeM', '0Q0LkJpfR1ejtO8rD3p', null, 'NGN4SO4fu5S5XxULG4X', '1', 'OH7Z3LEcqPhif8kJKhi', '155168789342300004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('O5iRbXaeB4pwYkXX6TE', '2ytUeoxBqghwofmBALl', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'KWyhjGMdOzdszl2VD2Q', '154461619142900001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('o5R2m9nkVrnfGKWeql0', 'jkpTHKg7DpuXQrppVxx', null, 'BXWlXtLv3yNVPzVHd1A', '2', 'BXWlXtLv3yNVPzVHd1A', '155142352997300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('O5Vs5KGq55GjglvAZeZ', '3tFw1boS5L9vXoJCr6Z', null, '1hPCUYj6dx9rMn0NAlL', '2', '1hPCUYj6dx9rMn0NAlL', '154563949425700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('O6AAW64rgrn7gsyAi0S', 'jkpTHKg7DpuXQrppVxx', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'CJu3AVSi8NfqhFlu5jl', '155142353048800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('o6MEeg3xawCsq4XibM4', '2jSs6cnzu4mzY9C13vF', null, '3gGNzYyE5dK9ogZidWA', '1', 'HbDOYiiIBcC1oYN30Kx', '155142339843300001', 'HdPeBqYwJyFyjHkhZu3', '保存', '4', '1');
INSERT INTO `t_permission` VALUES ('o6wpsqYQxaXFABQAf9U', 'kPLbeydkgiYW6NIkCt0', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'kgw3nVgzE2lQ8Be6S1i', '155168804594400004', 'HdPeBqYwJyFyjHkhZu3', '关闭窗口', '8', '1');
INSERT INTO `t_permission` VALUES ('o77KTG2K0dpDdtQdSri', 'jkpTHKg7DpuXQrppVxx', null, 'eLFjqFngRQrIkbsdeBd', '1', 'eLFjqFngRQrIkbsdeBd', '155142353145500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('o7nyj33ugkdz6FGldhh', 'kPLbeydkgiYW6NIkCt0', null, 'Gs69JZ3ObwaQctDBcOp', '2', 'Gs69JZ3ObwaQctDBcOp', '155168804489900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('O9c2LRmSlXQGmMbsvWf', '0Q0LkJpfR1ejtO8rD3p', null, '0bmAo7ylNxrpnAXlqnb', '2', '0bmAo7ylNxrpnAXlqnb', '155168789332900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('O9GL13R9kI5z7neI0Ag', '2ytUeoxBqghwofmBALl', null, 'oeLOJO0f3CC02OjOOIC', '0', 'Wvgpr80lY60tZ8EcoLc', '154461619013200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('O9oAXRI3ELVgTXGMhIP', '0Q0LkJpfR1ejtO8rD3p', null, 'TqQZlnV3BVaRGCm4tXn', '1', 'TqQZlnV3BVaRGCm4tXn', '155168789346900003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('O9Si2iWjE3Y5L5I3lVf', '0Q0LkJpfR1ejtO8rD3p', null, 'a2ZyD3z0DqPxaNXX6Zx', '0', 'UcyIJcbxVT4vXhKlAIg', '155168789395300005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('oA6pi7szBcJllThKSSq', 'kPLbeydkgiYW6NIkCt0', null, 'E4cbMljP402vIH2nZMB', '2', 'E4cbMljP402vIH2nZMB', '155168804500800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('OagVM9U2ZfRsqtkwxZy', '0Q0LkJpfR1ejtO8rD3p', null, '6arVIWht264qE2jDBdE', '2', '6arVIWht264qE2jDBdE', '155168789325100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('oaIwxGF5IAE9NYmj4VG', '2ytUeoxBqghwofmBALl', null, 'vDsnTykdPOblfwEF4mR', '1', 'g26NwXh1sSVhmkBCy8v', '154461619022600002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('oauOoW8EZcs47bMoOyz', '2jSs6cnzu4mzY9C13vF', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'aJ8FUYVtCO50iowXPg5', '155142339667000001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('OBRa9veUkKVffkk6oxu', 'jkpTHKg7DpuXQrppVxx', null, 'Vu8Q68Bom89YJDgguC9', '1', 'pTuo29zZfTBXXiWv0y7', '155142353094000000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('oC3dV614ocShoZYm9ZS', '2jSs6cnzu4mzY9C13vF', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'eIRDEeewznXKf3ktljY', '155142339779400001', 'HdPeBqYwJyFyjHkhZu3', '跳转', '43', '1');
INSERT INTO `t_permission` VALUES ('OcAX2Tr6w7DWxuVsdUd', '0Q0LkJpfR1ejtO8rD3p', null, 'eLFjqFngRQrIkbsdeBd', '1', 'laHgljUkGTSlRpd6Sbl', '155168789476400002', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('OcHuQiWl4GLDt7VqGcI', '2ytUeoxBqghwofmBALl', null, 'aGwWScnt2f6X87bV5u9', '1', 'aGwWScnt2f6X87bV5u9', '154461618963200002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('OcQlC8k7pxp7xDninOR', '3tFw1boS5L9vXoJCr6Z', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K4IeXTdrXu7wZa0AkpH', '154563949507000003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('oCUwmPUcWEbk5QbdUdC', 'WB81MbCBolNg6XmE35M', null, '11e6-5476-94a8e7ab-9671-379f935a9949', '1', '11e6-5476-94a8e7ab-9671-379f935a9949', '155141105071000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('OcvVGY7lxjbYyFU4WTZ', '3tFw1boS5L9vXoJCr6Z', null, 'G0WtPO1mX58wd7tjkTy', '0', 'MiGkf6DvyyRTJk95EY3', '154563949563200000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Od7GfS43lv5lgjhRCG2', '3tFw1boS5L9vXoJCr6Z', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'kgw3nVgzE2lQ8Be6S1i', '154563949550700004', 'HdPeBqYwJyFyjHkhZu3', '关闭窗口', '8', '1');
INSERT INTO `t_permission` VALUES ('odptSGMHK7wUuIzZSJk', '2jSs6cnzu4mzY9C13vF', null, 'gPHUIa48Bpsz26fjjNA', '2', 'gPHUIa48Bpsz26fjjNA', '155142339596800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('odukT2gE95Oh4mvoiII', '2ytUeoxBqghwofmBALl', null, '9ppSV2PIKNhHCOwufvI', '0', 'KJPLDYCNeJz1SWkwXZd', '154461619102300001', 'HdPeBqYwJyFyjHkhZu3', '下载文件', '26', '1');
INSERT INTO `t_permission` VALUES ('Oe2qiXCWOvHiMLDMX0G', '0Q0LkJpfR1ejtO8rD3p', null, 'F6reQ5BW7P6q236Pi13', '1', 'Okamal6erVlSp96ygxI', '155168789471700002', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('oEhFtYVXToIRY3IBoYq', '0Q0LkJpfR1ejtO8rD3p', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'SAYbUm9awyQJXoJpDNc', '155168789412500000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Oen9rfygY8Fr0viMzmj', 'kPLbeydkgiYW6NIkCt0', null, '36v96aPARGPLLLpXBt5', '2', '36v96aPARGPLLLpXBt5', '155168804516400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Ofr7pqctAimyrfH20Su', '3tFw1boS5L9vXoJCr6Z', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'TkN4G3lj2mZ4XOo0kVQ', '154563949607000004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('OfRtNz8B4zw4mz0lMVq', '2jSs6cnzu4mzY9C13vF', null, 'zqGmDkZIRa4COpFVzTj', '1', 'zqGmDkZIRa4COpFVzTj', '155142339629600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('OG9MMJW9zJVqaMLFMFG', 'jkpTHKg7DpuXQrppVxx', null, '6esIc2fTAI9nAOoOZcp', '1', 'y5AHygdKnFROYRFfQuX', '155142353030000001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('oGFDESLTHLgmJOFUAQj', '2ytUeoxBqghwofmBALl', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'f9GQrsfu9GKGRqKKPgi', '154461619002300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('OGgmYqTrxv8PpyPTrT2', '3tFw1boS5L9vXoJCr6Z', null, 'NaZcYrbGaXxrTGcsd2M', '1', 'NaZcYrbGaXxrTGcsd2M', '154563949625700003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('OgHGVOVl46HkpTIY1V0', 'jkpTHKg7DpuXQrppVxx', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'x2qgUpE8u9jmGEWbbQm', '155142353104900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('OGjrFcZN7BYkrBhWrD7', '0Q0LkJpfR1ejtO8rD3p', null, 'PLiK5HYs3YFoECyyMBo', '2', 'PLiK5HYs3YFoECyyMBo', '155168789323500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('OgRXhJSij9mpSbAotpP', '3tFw1boS5L9vXoJCr6Z', null, '68kltzfu9ZSUp9aJOg4', '2', '68kltzfu9ZSUp9aJOg4', '154563949455400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ohsYEv7nP7XjQZoRcim', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-e35a36a7-91c5-cd8abd28b1f9', '2', '11e6-5619-e35a36a7-91c5-cd8abd28b1f9', '155141104768300003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('OI8TQO5MxzNhYzdS7U6', '0Q0LkJpfR1ejtO8rD3p', null, 'viwgtc32VtB7wJo2O8S', '0', 'u09JpvzXkvJXfyRFCj6', '155168789382800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('oiGPxQgeesLnNqHwlbQ', '0Q0LkJpfR1ejtO8rD3p', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'WVuL60fA6C1cUsSUk5t', '155168789421800000', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('OjI1m1DyHpepMoID1Dn', '2jSs6cnzu4mzY9C13vF', null, 'eKZqOwJmAFsUEwu0WfL', '1', 'eKZqOwJmAFsUEwu0WfL', '155142339713800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ojnkhZWC2tngwbPpFVW', '2ytUeoxBqghwofmBALl', null, 'EaVrfjS89IZqE63BWPa', '0', '9YwViaujJTr161CesBX', '154461619097600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('OJUrTKTjjRkP26AJJzm', '0Q0LkJpfR1ejtO8rD3p', null, 'MnvkHQ9zdkDlQaAgtGq', '2', 'MnvkHQ9zdkDlQaAgtGq', '155168789311100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ojzhIU90170yLbUXwKN', '2ytUeoxBqghwofmBALl', null, 'Tm9KRBnKnzjuuld7bJh', '0', '5GCo50RaCJdscjJW16V', '154461619017900000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('oKddImaPqRLnCBw2OOY', 'jkpTHKg7DpuXQrppVxx', null, 'a0NeCmvVh6L5QDzhezl', '2', 'a0NeCmvVh6L5QDzhezl', '155142352970800004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('OkHwRZZ2V6lnGOV6IGW', 'WB81MbCBolNg6XmE35M', null, '11e6-53ae-1c5fbd29-81f5-679a826556ce', '1', '11e6-53ae-1c5fbd29-81f5-679a826556ce', '155141105177100003', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Okmbbzfapg6WO8KgOto', 'kPLbeydkgiYW6NIkCt0', null, '0N8ygEUeoPdGG6HeaCN', '0', '0N8ygEUeoPdGG6HeaCN', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单11', '1032', '2');
INSERT INTO `t_permission` VALUES ('oknzMqYusi7BZBOHckv', 'kPLbeydkgiYW6NIkCt0', null, 'k3Ro7OsGafHyoiDAeLl', '2', 'k3Ro7OsGafHyoiDAeLl', '155168804527300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('OL649hf4XU4m7zxnkKI', 'kPLbeydkgiYW6NIkCt0', null, 'kebFCC8mkGX3V1QEriK', '0', 'dsB4JOjIMnlpqITpAVO', '155168804675500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('olATsBjr4H4qvCvxe6a', '2ytUeoxBqghwofmBALl', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'IHazLikeEs3KYw5CBgr', '154461619135100002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('OlcY0pflz4Yhn5n2I7Q', '2jSs6cnzu4mzY9C13vF', null, 'jhINwVUWllGph0gnSC6', '0', 'GdRrT9CE4nmpUBASJy2', '155142339754400000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('OLejlr27Sb1Bu8bW9lu', 'kPLbeydkgiYW6NIkCt0', null, 'Vu8Q68Bom89YJDgguC9', '1', 'Vu8Q68Bom89YJDgguC9', '155168804600700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('olOUpgjJQtjpsmskluH', '0Q0LkJpfR1ejtO8rD3p', null, 'w7IsSOtXFvo61cP8sKr', '1', 'u8cNJQfZVXWFj5hlBow', '155168789409300002', 'HdPeBqYwJyFyjHkhZu3', '保存并启动流程', '4', '1');
INSERT INTO `t_permission` VALUES ('OLr7nPNdNvWwpPE2Y9r', '3tFw1boS5L9vXoJCr6Z', null, 'jYDgN5WH46paTNLcCqi', '0', 'MfAD53jYG4vMOBrhLRM', '154563949558500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('OlvywjoHHIuqM8gTmfU', 'jkpTHKg7DpuXQrppVxx', null, 'smthlnru9z9qwavJKk1', '0', '55V8ZUWfTBCxFClWTNS', '155142353162600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('OM1Pb4Lct7PbEgk5rN4', '3tFw1boS5L9vXoJCr6Z', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'va8G9KHkziR1bHrdZwG', '154563949592900002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('OMAWugIjTZcs2rgSkDS', '2jSs6cnzu4mzY9C13vF', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'PX5hS2Svd6sudk7n9l9', '155142339649900000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('OMLcwkmWV0hqFAeRQRN', '2jSs6cnzu4mzY9C13vF', null, '5rcVntJVt1P8847Jpus', '2', '5rcVntJVt1P8847Jpus', '155142339617100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ommXDahArdYhi8b2iNz', 'jkpTHKg7DpuXQrppVxx', null, 'sbkS067uQ9jIwpB6qWd', '2', 'sbkS067uQ9jIwpB6qWd', '155142352952000005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('OMSo7u3TTCOWkfJguS8', '3tFw1boS5L9vXoJCr6Z', null, 'B0yjUrREPsW6eZ4NRxH', '2', 'B0yjUrREPsW6eZ4NRxH', '154563949438200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('on0ATuKkzaOt0Pd9xFa', '2jSs6cnzu4mzY9C13vF', null, 'DwtZozROcOIsno6lTY3', '2', 'DwtZozROcOIsno6lTY3', '155142339578100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('On8khWOHXAbiNNyE3so', '2ytUeoxBqghwofmBALl', null, 'IuPDe4Gm9occzflnrP0', '0', 'oD3WAF1Vtv6gB6lDCtv', '154461619110100001', 'HdPeBqYwJyFyjHkhZu3', '新窗口打开', '43', '1');
INSERT INTO `t_permission` VALUES ('ONIg6XgzibOqJqNlnz8', 'kPLbeydkgiYW6NIkCt0', null, 'yDZaeD0mt44iNjakHmE', '0', 'gOx8PapU5TCGaG1IcWs', '155168804588200004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('OnxEshaYMxUe516fojs', '0Q0LkJpfR1ejtO8rD3p', null, 'wwsNkkwFEvqL44gK2fM', '0', 'ITAEcCLmB4JM7hMwJQC', '155168789381300001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('oo4myJuJCp3cRo2Jp2P', 'jkpTHKg7DpuXQrppVxx', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'NF5zkjoJvJNVpgmQsj6', '155142353128300003', 'HdPeBqYwJyFyjHkhZu3', '执行前提示', '3', '1');
INSERT INTO `t_permission` VALUES ('OobRv6TVlt6tPSU4Sma', '3tFw1boS5L9vXoJCr6Z', null, 'p44Eh34DScjVKkZi1ok', '2', 'p44Eh34DScjVKkZi1ok', '154563949438200004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('oOBx9Pg3LRTKfo9d9qV', 'kPLbeydkgiYW6NIkCt0', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'XYV76K6iat8P2bzFJIm', '155168804647500001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('OoLS70qVUJRjCFyFECm', 'WB81MbCBolNg6XmE35M', null, '11de-7666-1dc7f93b-8d52-0547317ddd4c', '1', '11de-766c-8bb9d2b0-824d-d3dd83e4db1b', '155141105130300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('OoqCTF5cV15mjP50nl9', 'kPLbeydkgiYW6NIkCt0', null, 'g2XzgmKDL1T8UB79GZh', '0', '1uOt5KaDxl3ZK3OT1Mw', '155168804627200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('oPfoZGTqiKtHjIehRYy', '2ytUeoxBqghwofmBALl', null, 'DzqlEtg4JObApV7iWX8', '0', 'YIzUW1O7NPBhfxLwHuj', '154461619025700002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('oPLHnTl1ew4e0INTvJi', 'WB81MbCBolNg6XmE35M', null, '11e6-539f-0c568130-81f5-679a826556ce', '1', '11e6-d15e-8dfba976-bbdd-9f7a0eebced4', '155141104788600001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('oplpBPH9nMYqcMzzyVG', '2ytUeoxBqghwofmBALl', null, 'kebFCC8mkGX3V1QEriK', '0', 'dsB4JOjIMnlpqITpAVO', '154461619100700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('oPvwLdlT3w036cXz8Ig', '3tFw1boS5L9vXoJCr6Z', null, 'IuPDe4Gm9occzflnrP0', '0', 'LFydu54akpsq9Y9sCQr', '154563949603800003', 'HdPeBqYwJyFyjHkhZu3', '载入其他视图', '1', '1');
INSERT INTO `t_permission` VALUES ('oQ5xcMXSfLXcJMv4Ac8', '3tFw1boS5L9vXoJCr6Z', null, 'fwj9yeT6AbfKtPOwtOM', '2', 'fwj9yeT6AbfKtPOwtOM', '154563949471000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('OQ8RdmF8Zf7QuuxGIqq', '3tFw1boS5L9vXoJCr6Z', null, 'E4cbMljP402vIH2nZMB', '2', 'E4cbMljP402vIH2nZMB', '154563949455400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('OQg2mwoVzQFAr6xD5qS', 'kPLbeydkgiYW6NIkCt0', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'zEz94y8drV2wM7Sh0jS', '155168804566300000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('OQLtBKG2GI96R6bhE3i', '0Q0LkJpfR1ejtO8rD3p', null, 'fu3FPAvy3QbJl8Y96P7', '1', '5oWWmwFfmt1UTNzYcO7', '155168789414000000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('oquGrMkaFALqL4sOAAg', '2jSs6cnzu4mzY9C13vF', null, 'ddbeKTjs0WvqKVJ90MU', '1', '5fbpm1XlYeZn8KXFMNL', '155142339690400001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('oqVE0PyqL3NqLr8ksX8', '2jSs6cnzu4mzY9C13vF', null, '6arVIWht264qE2jDBdE', '2', '6arVIWht264qE2jDBdE', '155142339609300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('OrfJ57BQKhHFEB8w40h', 'jkpTHKg7DpuXQrppVxx', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'SAYbUm9awyQJXoJpDNc', '155142353084600005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('orfoKaSKnljjvP3Rjw1', 'kPLbeydkgiYW6NIkCt0', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'bVmZ9H8tKyNWZ4omc1a', '155168804650600002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('org3bh0ltLfHq3tpIXT', 'kPLbeydkgiYW6NIkCt0', null, 'MsyfStEFzDcCB1VPbYJ', '1', 'MsyfStEFzDcCB1VPbYJ', '155168804656800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('oRIyvktlyiBnYzdsCAX', '2ytUeoxBqghwofmBALl', null, 'rfmGjP7LXiQfxy15izp', '1', 'rfmGjP7LXiQfxy15izp', '154461618903800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('OrkxzALE5dFev4lb5Q9', '3tFw1boS5L9vXoJCr6Z', null, 'vDsnTykdPOblfwEF4mR', '1', 'vDsnTykdPOblfwEF4mR', '154563949611600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ORqDMXYDWN5jpnZAKk5', '2ytUeoxBqghwofmBALl', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'zEz94y8drV2wM7Sh0jS', '154461618974200000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('Osinzsw8h2k1iknIqSX', '2jSs6cnzu4mzY9C13vF', null, 'avS4WYnlhLiRlkXIHhD', '2', 'avS4WYnlhLiRlkXIHhD', '155142339628000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Osjtl09kEPtxxkl2r0G', 'jkpTHKg7DpuXQrppVxx', null, 'bn8WKWSmkeCbTynZV4J', '2', 'bn8WKWSmkeCbTynZV4J', '155142352970800006', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('oSLg1r1JuMenknHFn0F', '2jSs6cnzu4mzY9C13vF', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'GWNOfrdfU2z2hYo2y6Q', '155142339784000003', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('oTe8kuLEOvfNIYcS0qi', 'kPLbeydkgiYW6NIkCt0', null, 'a2ZyD3z0DqPxaNXX6Zx', '0', 'UcyIJcbxVT4vXhKlAIg', '155168804580400005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('oTP9oqzm3YJq3M4xhF7', '2jSs6cnzu4mzY9C13vF', null, '6bUPlXeVH92MIv7Nmdw', '1', 'ZNYYg5DdRtEMBaS3QLl', '155142339671700001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('otPCV2Ej8oFTRX2JJIn', '2jSs6cnzu4mzY9C13vF', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'TFCrC5zb0w6fDoq6icl', '155142339762200001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('OU9bAPJWeOenWcOk53g', '0Q0LkJpfR1ejtO8rD3p', null, 'jzty8K7Nbi7GKcU8c3L', '2', 'jzty8K7Nbi7GKcU8c3L', '155168789317300005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('oUdSkl22W9HyalZlIGK', '0Q0LkJpfR1ejtO8rD3p', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'CjR2ngF0kCrKnCpD0rj', '155168789365700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('oUOi53mgvoMJFsKB80I', '2ytUeoxBqghwofmBALl', null, 'vDsnTykdPOblfwEF4mR', '1', 'g26NwXh1sSVhmkBCy8v', '154461619117900003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('oUVPhIqrHjIxBasDAsz', 'kPLbeydkgiYW6NIkCt0', null, '2bmCU7aUTZfM8CZmJEP', '2', '2bmCU7aUTZfM8CZmJEP', '155168804499300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('oVD6E1ZD49vrbFejeJB', '3tFw1boS5L9vXoJCr6Z', null, 'gkbm2C0NbCfu86GHkFh', '0', 'C06613mOoQKz6Rr0LIo', '154563949514800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('OVEUcy27FYmCDmXxQbF', '2jSs6cnzu4mzY9C13vF', null, 'WOmzvkui5ZsoZu1CogR', '1', 'WOmzvkui5ZsoZu1CogR', '155142339779400005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('OVGzLxm5GbInKewnr2M', '3tFw1boS5L9vXoJCr6Z', null, '27MTAjC7JxdEukQ4fFY', '2', '27MTAjC7JxdEukQ4fFY', '154563949433500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('oVh63w7fkGTGWTPW3h9', '0Q0LkJpfR1ejtO8rD3p', null, '4oavihvP4J8cXDsWDIP', '0', 'pwDWlADlB4vGrKVGIQc', '155168789448300002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('OvhaDi3uuELISjN5COV', '0Q0LkJpfR1ejtO8rD3p', null, 'Vu8Q68Bom89YJDgguC9', '1', 'Vu8Q68Bom89YJDgguC9', '155168789423400001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('oVOknPqaqTYOnSDNKQl', 'kPLbeydkgiYW6NIkCt0', null, 'poalxIjVlN70WdVjfQq', '1', '1reYhDLZyvld0uiPZMk', '155168804675500004', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('OVqCql1b0Dww4MpBD8v', '3tFw1boS5L9vXoJCr6Z', null, '3sSURwczE2wMjgOqqOo', '0', 'xgvB9tVQZn0ZxoQMZ31', '154563949536600001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('OwDXOQED8eWoq3c9SwJ', 'WB81MbCBolNg6XmE35M', null, '11e6-549a-e2332c7e-9671-379f935a9949', '1', '11e6-54a0-fe1ddfda-9671-379f935a9949', '155141105056900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('oWlyaNRIwbVvSVMTJJl', '0Q0LkJpfR1ejtO8rD3p', null, 'K34zNYKOBOe8fgOk6ia', '2', 'K34zNYKOBOe8fgOk6ia', '155168789315700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('OWRGgfIy5Db2NYwMklI', '0Q0LkJpfR1ejtO8rD3p', null, 'JUpr2SmaIGVASTdp53r', '2', 'JUpr2SmaIGVASTdp53r', '155168789295500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Ox2g9YXccb7uq8tQOyS', '0Q0LkJpfR1ejtO8rD3p', null, '2FzVqBVCwr7uvFsl3Yo', '2', '2FzVqBVCwr7uvFsl3Yo', '155168789315700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ox6bwJAmsELBFLK6Ecx', '2ytUeoxBqghwofmBALl', null, 'WOmzvkui5ZsoZu1CogR', '1', 'GtjuDeHrOcWix1W5qZC', '154461619041300003', 'HdPeBqYwJyFyjHkhZu3', '签章', '46', '1');
INSERT INTO `t_permission` VALUES ('OxKj93el670qFFgdEl2', '0Q0LkJpfR1ejtO8rD3p', null, '5XvXec6bdYRjaPxuLlQ', '1', '5XvXec6bdYRjaPxuLlQ', '155168789428100001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('OY4Q2byaOtd301pZxCY', 'jkpTHKg7DpuXQrppVxx', null, 'RZTAlFVXkUYpYm96zVo', '1', 'RZTAlFVXkUYpYm96zVo', '155142353158000003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('oYldvBJ9cdAhZiKPJxT', '2jSs6cnzu4mzY9C13vF', null, 'c8qqHIRjZCxEMPx5YoO', '1', 'c8qqHIRjZCxEMPx5YoO', '155142339791800001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('OYnFwxvDhoOrUkPfrRw', 'jkpTHKg7DpuXQrppVxx', null, 'NGN4SO4fu5S5XxULG4X', '1', 'TrHax0MzDGsTz4DFUoo', '155142353014400002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('OZEY5o8JoFNSgFfZs52', 'WB81MbCBolNg6XmE35M', null, '11e6-53c8-9cbf836c-81f5-679a826556ce', '1', '11e6-d15f-3eb5f885-bbdd-9f7a0eebced4', '155141104946200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('OZoYxp8SB4SGufcM4Ig', '3tFw1boS5L9vXoJCr6Z', null, 'poalxIjVlN70WdVjfQq', '1', 'ZABfGox4xJSo5PMgCOr', '154563949632000002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('P02bJYrk0ikXg54eKSk', 'kPLbeydkgiYW6NIkCt0', null, 'w7IsSOtXFvo61cP8sKr', '1', 'tdpqhqKdJ6wj3toLl5M', '155168804592900006', 'HdPeBqYwJyFyjHkhZu3', '打印包含流程历史', '15', '1');
INSERT INTO `t_permission` VALUES ('p0kqwAfiu4zyeOj2tMh', 'WB81MbCBolNg6XmE35M', null, '11e2-5fb6-9a1cc7c4-b702-3f84c4cacb0d', '0', '11e3-9878-52e40747-a625-2b98d9965dcf', '155141104843200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('P0uAbkVJK7eyZwDCbU0', '3tFw1boS5L9vXoJCr6Z', null, 'G0WtPO1mX58wd7tjkTy', '0', 'XIYtwtem4lZYZBYOfS5', '154563949563200001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('P164qI9jOgcxO7bTpTd', '0Q0LkJpfR1ejtO8rD3p', null, 'lOgu0Jvq0z5dlveyrnY', '0', 'eq15KrpMbnefCOE2bGq', '155168789449900000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('p1ILxi6EIQl68DVR1Gj', '0Q0LkJpfR1ejtO8rD3p', null, 'iuGmP6OvURaOFF3NzoP', '0', 'qylo0G6lIYWGVKLPVnS', '155168789437400003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('P1sfynHf9PixopY02z8', '3tFw1boS5L9vXoJCr6Z', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'tjznokFdoftUtJzbwhl', '154563949500700000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('P1V07oJPCKG0pz6nrwP', 'jkpTHKg7DpuXQrppVxx', null, 'enhnCZbrTQ1mZpn18o5', '0', 'u8rE2hHMPcvxRUXgNQk', '155142353123600001', 'HdPeBqYwJyFyjHkhZu3', '更新所选记录', '1', '1');
INSERT INTO `t_permission` VALUES ('P1wKze7L2IdHvJtsXq8', '2jSs6cnzu4mzY9C13vF', null, '0bmAo7ylNxrpnAXlqnb', '2', '0bmAo7ylNxrpnAXlqnb', '155142339621800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('P1ZNrvIMuUandMwuqt3', '0Q0LkJpfR1ejtO8rD3p', null, 'CuDZkkf1DSaMf5ST7bj', '1', 'CuDZkkf1DSaMf5ST7bj', '155168789437400002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('p2QHJnWqhzyb38rzx4l', '3tFw1boS5L9vXoJCr6Z', null, 'KR5pPS7kOi82d8Wrkc5', '0', 'QYoz2hXTOBl13zY1LO7', '154563949525700004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('p2WjjlNTJScyBtLA8yf', 'kPLbeydkgiYW6NIkCt0', null, '0bgD6IPDYyID2susbqZ', '0', 'qQ3GQtV2z6ogWiGsF2D', '155168804586600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('p330N4kByFh8mG1MTOd', 'jkpTHKg7DpuXQrppVxx', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'gUlSUpqhlS2ym2ijZAg', '155142353025400006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('P3d9I6qmuOF18aTvSno', '0Q0LkJpfR1ejtO8rD3p', null, 'IiXqyN1VoajtXmJTPKS', '2', 'IiXqyN1VoajtXmJTPKS', '155168789307900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('P3PzjwglAhnaTITmNvX', '3tFw1boS5L9vXoJCr6Z', null, 'v0ioxUWrQYtMKt3TTeU', '0', 'kDh3nPpNY2Iuqx1J4V9', '154563949527300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('P6ODH0bEoR3PbycSjrs', '0Q0LkJpfR1ejtO8rD3p', null, 'xBX9EbJkveiSGJm9xRj', '0', 'hkNKtk1zbGkFX0hZFT9', '155168789392200001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('P7rFM7NGBgzsxFsBpHS', '3tFw1boS5L9vXoJCr6Z', null, 'K34zNYKOBOe8fgOk6ia', '2', 'K34zNYKOBOe8fgOk6ia', '154563949453800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('p7Wy22RL1UokMiwPD7p', '2ytUeoxBqghwofmBALl', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'csKjmVnToONLiXzljYG', '154461619108500000', 'HdPeBqYwJyFyjHkhZu3', '执行后提醒', '3', '1');
INSERT INTO `t_permission` VALUES ('p85c9muBpwzG0UaGJa4', '3tFw1boS5L9vXoJCr6Z', null, '6bUPlXeVH92MIv7Nmdw', '1', '6bUPlXeVH92MIv7Nmdw', '154563949494500002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('p8iIvpqJS499otHvLnp', '2jSs6cnzu4mzY9C13vF', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'VC7xzHBeSzCmdpBwT9w', '155142339702900001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('P8nngV3KA1zq4NvQSU9', '3tFw1boS5L9vXoJCr6Z', null, 'zg2t1qqkaJ17B2vvX05', '0', 'COoHnOHkHeviVNasUlf', '154563949594500001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('P8WFrBKurro63h23rEH', '0Q0LkJpfR1ejtO8rD3p', null, '3gGNzYyE5dK9ogZidWA', '1', '7SBexLWqUvnu9vb48Vu', '155168789453000004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('p9piosyjqjTP43Gi1Fl', 'kPLbeydkgiYW6NIkCt0', null, 'IuPDe4Gm9occzflnrP0', '0', 'v6Do5TzCwJt7gNmEi1b', '155168804644300003', 'HdPeBqYwJyFyjHkhZu3', '弹出层打开', '43', '1');
INSERT INTO `t_permission` VALUES ('PA5NP7KXTGijH9feoRR', 'WB81MbCBolNg6XmE35M', null, '11e6-54b3-01603448-9671-379f935a9949', '1', '11e6-54b5-d34e334a-9671-379f935a9949', '155141104904100001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '发布会议', '11', '1');
INSERT INTO `t_permission` VALUES ('PaCKnmys6lFq0iBhKbd', '0Q0LkJpfR1ejtO8rD3p', null, 'B0yjUrREPsW6eZ4NRxH', '2', 'B0yjUrREPsW6eZ4NRxH', '155168789301700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PAhfst0BGGBQwEs0am6', '0Q0LkJpfR1ejtO8rD3p', null, 'XpNoNSLR8vialNcJDXq', '0', 'WadmhwRuII4JmFt4TYS', '155168789442100004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('PanL2z0UZZmgnptnklH', '2jSs6cnzu4mzY9C13vF', null, 'TyQHY3EqKQuNGfJ6teV', '2', 'TyQHY3EqKQuNGfJ6teV', '155142339623400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('pASvFxRMwSRxh42m2zL', '3tFw1boS5L9vXoJCr6Z', null, 'Ta56UCfylnpmF0NhOQW', '2', 'Ta56UCfylnpmF0NhOQW', '154563949458500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PBGYShRkkowePmViD66', 'jkpTHKg7DpuXQrppVxx', null, 'UmMnr5J8RhgknR3Dsos', '0', 'RZ790ojkvhzumC5tyL2', '155142353076800002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('PbiUKnjImTd8Zg4n5oT', 'kPLbeydkgiYW6NIkCt0', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'bYd4AsVWGV8kpxju1vo', '155168804594400006', 'HdPeBqYwJyFyjHkhZu3', 'PDF导出', '25', '1');
INSERT INTO `t_permission` VALUES ('pbVBwXFFEWRAsqV1IS2', '2ytUeoxBqghwofmBALl', null, 'viwgtc32VtB7wJo2O8S', '0', 'u09JpvzXkvJXfyRFCj6', '154461618994500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('pcA9FoXO1M47fKx3LZo', '2ytUeoxBqghwofmBALl', null, 'TqQZlnV3BVaRGCm4tXn', '1', '22ZvmpjYHg3LQFPOh01', '154461618935100005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('PcD5m62po9Tx47MFOew', 'WB81MbCBolNg6XmE35M', null, '11e3-235b-96added8-825b-e3da92374d42', '0', '11e5-f25a-0627866f-bf05-733864b5145f', '155141104851000001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '查看汇总', '43', '1');
INSERT INTO `t_permission` VALUES ('pCNxLLEWb2n6W14CpXs', 'kPLbeydkgiYW6NIkCt0', null, '0bgD6IPDYyID2susbqZ', '0', 'q2Ay04xXzfVCDjfyvgH', '155168804586600002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('PCrsccUn9sZhlwNyTI6', '3tFw1boS5L9vXoJCr6Z', null, 'PEBmSuAdvPujm2dfjAb', '2', 'PEBmSuAdvPujm2dfjAb', '154563949417900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PdbI8Vyr72Phcf1v8z9', 'kPLbeydkgiYW6NIkCt0', null, 'eLFjqFngRQrIkbsdeBd', '1', 'SX3rVQxkpU96Pko5JDm', '155168804658400002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('pDLRjQuRKB6oSboSQT1', '0Q0LkJpfR1ejtO8rD3p', null, '5XKkpkend5hrAy8xWlc', '1', 'gMLNnDrjNUE07fMXd9o', '155168789364100000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('PDsq2RYPhwmvtLJIqvp', '2ytUeoxBqghwofmBALl', null, 'MIExqx2MWO5cunDiuaX', '1', 'MIExqx2MWO5cunDiuaX', '154461618957000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('pebDyPmDlPFqXC4uAws', '0Q0LkJpfR1ejtO8rD3p', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'KWyhjGMdOzdszl2VD2Q', '155168789484200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('pebfBsp1EYcIgKrLGK3', 'kPLbeydkgiYW6NIkCt0', null, 'G0WtPO1mX58wd7tjkTy', '0', 'MiGkf6DvyyRTJk95EY3', '155168804599100003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('peFqyktIXwHsMCBJOH4', '0Q0LkJpfR1ejtO8rD3p', null, 'aGwWScnt2f6X87bV5u9', '1', 'aGwWScnt2f6X87bV5u9', '155168789370300003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('PEhFvTeqOcmDsLLNJIE', 'WB81MbCBolNg6XmE35M', null, '11e6-553c-e6e8216e-8350-a3b9b8447d61', '1', '11e6-5b9b-a2d2536c-a270-539aa660c6fc', '155141105150500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('PErwL4ksOBKz2MDQqiy', 'jkpTHKg7DpuXQrppVxx', null, 'P14ZGIv1IEdecUGGYYk', '2', 'P14ZGIv1IEdecUGGYYk', '155142352956700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PF3FAt1TZp29Y64MP8V', 'jkpTHKg7DpuXQrppVxx', null, '98kmnnrWwGKmgyiIkUF', '0', 'erevZ9qTmGbUQpQWI61', '155142353061200001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('pfdu74RyICR8holtwcc', '3tFw1boS5L9vXoJCr6Z', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'QOJ06s8WUaokm0sdBKM', '154563949592900000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('pfETUiZLOohOxK0LUIf', '3tFw1boS5L9vXoJCr6Z', null, 'EUJuOrIly3lBnwGTF7Q', '1', 'EUJuOrIly3lBnwGTF7Q', '154563949571000006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('pFKlsQmeiulgDuuogQK', '0Q0LkJpfR1ejtO8rD3p', null, '6bUPlXeVH92MIv7Nmdw', '1', 'ZNYYg5DdRtEMBaS3QLl', '155168789354700001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Pfopg7RbyWdbNMJe2YM', '3tFw1boS5L9vXoJCr6Z', null, 'JSvvw8VjIpL8ESGH8YA', '2', 'JSvvw8VjIpL8ESGH8YA', '154563949439800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Pgc37aanZGSQbfq7R9i', 'kPLbeydkgiYW6NIkCt0', null, 'gHKBmQ7kx8ThwKaSbuk', '2', 'gHKBmQ7kx8ThwKaSbuk', '155168804493000004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('pGK0key2JsTEsFr2LCN', 'kPLbeydkgiYW6NIkCt0', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'x2qgUpE8u9jmGEWbbQm', '155168804608500004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('PgQBsEBlFYptgm2iITR', '3tFw1boS5L9vXoJCr6Z', null, 'mL5IgApmFXBzpokqr1u', '1', 'GCUKqbuDK4aJB3q2DZ8', '154563949566300001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('PgSq1OXQCMbBIRxsIj9', 'WB81MbCBolNg6XmE35M', null, '11e6-5615-d07c2ee4-91c5-cd8abd28b1f9', '2', '11e6-5615-d07c2ee4-91c5-cd8abd28b1f9', '155141104752700002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PHgRnKkmn0atnUEIEgJ', '2jSs6cnzu4mzY9C13vF', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K8Lx8Yr2KhbHQo4z25I', '155142339715400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('PID0jELPsWqXoUt6AZt', 'WB81MbCBolNg6XmE35M', null, '11e6-4f27-1f4a23d7-81e8-cb77e1bc6c59', '1', '11e6-4fb6-aac10fed-ae2a-85737433dd16', '155141104801100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('PiLc1HaHY0Hq92h5nQQ', '2jSs6cnzu4mzY9C13vF', null, 'QKYvQ00K4tWyyjKycUC', '0', 'vDCiwAlHhexzsJITERJ', '155142339851100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('pILelHIS5t6W7I1z14H', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-76e021e7-91c5-cd8abd28b1f9', '2', '11e6-5619-76e021e7-91c5-cd8abd28b1f9', '155141104782400003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('pioyM9PE9VFuEpoqZRi', '2jSs6cnzu4mzY9C13vF', null, 'Ps4ZZv1ZXK9RWgInE2I', '2', 'Ps4ZZv1ZXK9RWgInE2I', '155142339585900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PiqJVhKDJWN5h5RjDRO', '2ytUeoxBqghwofmBALl', null, '2Icse0Cn99YRTQTZO3f', '1', '2Icse0Cn99YRTQTZO3f', '154461619141300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('pIx9GWXgAn9sxY5W1u0', 'jkpTHKg7DpuXQrppVxx', null, 'LdUkdpc3EVM9iBygFMr', '0', 'aDMBVBnzRI5FgVJbQR2', '155142353097100000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Pj6yzF6FfizzcTuuMdi', '2ytUeoxBqghwofmBALl', null, 'TB1tzLM8yuJEkB6aQUk', '1', 'TB1tzLM8yuJEkB6aQUk', '154461619074200007', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('pJfqIfEhJY5hm6hLnPg', '2jSs6cnzu4mzY9C13vF', null, 'qAcxhZ5mnoiohEBYD9G', '2', 'qAcxhZ5mnoiohEBYD9G', '155142339557800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('pJjluBUj3i52mtlNeKU', 'kPLbeydkgiYW6NIkCt0', null, 'XzgpTEte9Q1JQswSETz', '0', 'oTrq3HVrCNx1jALWUgh', '155168804672400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('PjzpNOVG3joS6C7Wn9B', 'WB81MbCBolNg6XmE35M', null, '11e6-561b-95ec3623-91c5-cd8abd28b1f9', '2', '11e6-561b-95ec3623-91c5-cd8abd28b1f9', '155141104755900003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PJzrBMxmddymc3cCFaS', 'kPLbeydkgiYW6NIkCt0', null, 'EGmIBh1ogGUoD8df1rE', '1', 'EGmIBh1ogGUoD8df1rE', '155168804667700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('PK8Ulo676duzqtqokyC', '2ytUeoxBqghwofmBALl', null, 'bKWrnsYGUGaqqYqkeeO', '0', '23XpTvLhb5XEzINSZHU', '154461619111700005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('PKaImKkzwrz1JuTYPa5', '2jSs6cnzu4mzY9C13vF', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'gUlSUpqhlS2ym2ijZAg', '155142339674800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('pKM5M83NGmgLA5FDZKG', '0Q0LkJpfR1ejtO8rD3p', null, 'CUiq0kurilZ2dSBIXUv', '0', 'Ksb2IhhfWaj5cJWTMwr', '155168789393700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('pL8rMOrmha4kIvynwDa', 'jkpTHKg7DpuXQrppVxx', null, 'ddbeKTjs0WvqKVJ90MU', '1', '8S96fbM0hHIvN2tHSUq', '155142353031600001', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('pl9T52gU9B7wyk8rKpU', 'WB81MbCBolNg6XmE35M', null, '11e6-561a-7e908e1e-91c5-cd8abd28b1f9', '2', '11e6-561a-7e908e1e-91c5-cd8abd28b1f9', '155141104762100004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PlIlxdtwMFglusQqnYV', 'kPLbeydkgiYW6NIkCt0', null, '8DmOHAVRvs3BblbhJoa', '1', 'b2wnjqSK0hVEGNix31k', '155168804542900001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('plInkYxZOBhLcpPMrNy', '0Q0LkJpfR1ejtO8rD3p', null, 'E4cbMljP402vIH2nZMB', '2', 'E4cbMljP402vIH2nZMB', '155168789317300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('plsuZTgLAuAvP1TpeN2', 'jkpTHKg7DpuXQrppVxx', null, '5XKkpkend5hrAy8xWlc', '1', '5XKkpkend5hrAy8xWlc', '155142353031600003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('PlvepuFMbhfKx33jRIh', 'jkpTHKg7DpuXQrppVxx', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'HsJKTUvE0PpgpJ9EXSw', '155142353148600001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('PLzMAEtsEIGlN6z2SnG', '2jSs6cnzu4mzY9C13vF', null, 'kA4m81roWetnkDQgWm0', '0', 'fc8oYpPYk2t3xyohWqx', '155142339741900004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('pM33fiaQojA488y74NK', '2jSs6cnzu4mzY9C13vF', null, 'dtXU9EYYl4qLe8PdIVc', '0', 'k1Bk7XRgKJ0522NyIQs', '155142339745000004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('PMBO0ZIY4z6qMqo3jHg', 'kPLbeydkgiYW6NIkCt0', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'cAu7pZ4IzsfytkdYNLM', '155168804546100003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('PMCPDw42S9WxRdvakv0', 'jkpTHKg7DpuXQrppVxx', null, '4wigakaNlnx6FakxlBQ', '2', '4wigakaNlnx6FakxlBQ', '155142352998800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('pml564Ztce3x2sWQEvx', 'kPLbeydkgiYW6NIkCt0', null, 'NGN4SO4fu5S5XxULG4X', '1', 'OH7Z3LEcqPhif8kJKhi', '155168804536700000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('PMof1Ds6uaa2i9VCSCg', '2ytUeoxBqghwofmBALl', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'JAAon6tsqZ7pmxzP2fn', '154461618966300006', 'HdPeBqYwJyFyjHkhZu3', '批量签章', '29', '1');
INSERT INTO `t_permission` VALUES ('pmPjn2kmv1HkgDAceNB', '3tFw1boS5L9vXoJCr6Z', null, 'MsyfStEFzDcCB1VPbYJ', '1', 'MsyfStEFzDcCB1VPbYJ', '154563949614800001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('PMvwxAh9daoA0zhPjQi', 'WB81MbCBolNg6XmE35M', null, '11e6-5476-94a8e7ab-9671-379f935a9949', '1', '11e6-548a-7aab1114-9671-379f935a9949', '155141105071000002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('PncfQw9oli3fMQijBt4', 'jkpTHKg7DpuXQrppVxx', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '155142353067500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('PNl3fHimaMWxmwfiCgN', '2ytUeoxBqghwofmBALl', null, 'a7jp1Dm53YjlAwDWuws', '1', 'wL7xiiufleig43GVrAC', '154461619032000000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('POmU68iGhgHivhEqwtI', 'WB81MbCBolNg6XmE35M', null, '11e6-54ac-b2844607-9671-379f935a9949', '1', '11e6-54b0-46f88c3b-9671-379f935a9949', '155141105025700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('pP3B0WYKGFEjwo99U3C', '2jSs6cnzu4mzY9C13vF', null, 'PLiK5HYs3YFoECyyMBo', '2', 'PLiK5HYs3YFoECyyMBo', '155142339606200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('pPfDaD9KH6IJGJCRMbm', '0Q0LkJpfR1ejtO8rD3p', null, 'IuPDe4Gm9occzflnrP0', '0', 'oD3WAF1Vtv6gB6lDCtv', '155168789467100001', 'HdPeBqYwJyFyjHkhZu3', '新窗口打开', '43', '1');
INSERT INTO `t_permission` VALUES ('ppiazCBkCI7zDdaf5XB', 'jkpTHKg7DpuXQrppVxx', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'XYV76K6iat8P2bzFJIm', '155142353136100002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('pQckMVjpTm6cvAEbU5j', 'jkpTHKg7DpuXQrppVxx', null, 'lOgu0Jvq0z5dlveyrnY', '0', '5XIqbMcQ6K0lFtVi4HZ', '155142353109600004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('PqJw1QzxdEUuT82rUEs', '2jSs6cnzu4mzY9C13vF', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'QE5Y9qsMqfgX5CnSw2u', '155142339868300004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('PqmQz83SixVx1qXNSYO', 'kPLbeydkgiYW6NIkCt0', null, '3K4lxgBhBLAbzJrfYaB', '1', 'iYGmCNLDOISoDmNMi4d', '155168804677100002', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('PqqTYp7nlY6jBiYJkGs', '0Q0LkJpfR1ejtO8rD3p', null, 'poalxIjVlN70WdVjfQq', '1', 'ZABfGox4xJSo5PMgCOr', '155168789487300002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('pqrsfOnOKqHyfScMFDg', '2ytUeoxBqghwofmBALl', null, 'wjPLVvwWYR2a9BOi0st', '0', '6798mFOtT3LLK9CYgPv', '154461618858500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('PsA6qZHUorL45ehONEZ', 'jkpTHKg7DpuXQrppVxx', null, 'T9IoQKXjHSvxRXYM3L8', '1', 'T9IoQKXjHSvxRXYM3L8', '155142353044100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('psitoEUsTR5LxaszjjC', '2jSs6cnzu4mzY9C13vF', null, '9ppSV2PIKNhHCOwufvI', '0', 'Qbqk2LB86r3acRInIHN', '155142339862000002', 'HdPeBqYwJyFyjHkhZu3', '刷新', '1', '1');
INSERT INTO `t_permission` VALUES ('pSjEaWryeMuiumVMx0q', '2ytUeoxBqghwofmBALl', null, 'ir2OPEdZvttSUxAzfmD', '1', 'C6hePhUj7uuuUyJJSuq', '154461618933500006', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('PSWP0VBJxaUI5Hs0okA', '0Q0LkJpfR1ejtO8rD3p', null, '7giYu3zk1hrdILU9eCl', '2', '7giYu3zk1hrdILU9eCl', '155168789331300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ptJzieAY2eEp3GOcPvO', '2jSs6cnzu4mzY9C13vF', null, 'viwgtc32VtB7wJo2O8S', '0', 'Wlje8Nr2ww7qrmEwdBf', '155142339743500002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('pTLbW9xpgcpoIVt8D3R', 'jkpTHKg7DpuXQrppVxx', null, '2Icse0Cn99YRTQTZO3f', '1', '2Icse0Cn99YRTQTZO3f', '155142353159500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('PTzFtlC1dTIkJecsxNA', '0Q0LkJpfR1ejtO8rD3p', null, '0n6dTFPWytWUOlO2aeq', '2', '0n6dTFPWytWUOlO2aeq', '155168789318900000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('pus2ZnuzTS0wxfMl54a', 'kPLbeydkgiYW6NIkCt0', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'A293BH1uO82kIt5k5f9', '155168804597500005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('PV2dTM7YET2Vn0dKflR', '2jSs6cnzu4mzY9C13vF', null, '6esIc2fTAI9nAOoOZcp', '1', 'y5AHygdKnFROYRFfQuX', '155142339684200000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('pV664RDmfBFudft2kVJ', '0Q0LkJpfR1ejtO8rD3p', null, 'LdUkdpc3EVM9iBygFMr', '0', 'cS0647Al36GrYYVT25b', '155168789426500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('PVLAa5ibCABDlAkmSvC', '2ytUeoxBqghwofmBALl', null, 'hdMXKLI1XqTUYUrFniv', '0', 'aa25jXytFYZYB62Ac2z', '154461618941300002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('PvmWaRhINdANgwFYN4b', 'kPLbeydkgiYW6NIkCt0', null, 'mNVKo7InVqtGMI8pWnS', '2', 'mNVKo7InVqtGMI8pWnS', '155168804505500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('pvNsK79FYhvl0jf3e27', '2ytUeoxBqghwofmBALl', null, '2F75ZJJXk8564FkCLYA', '1', '2F75ZJJXk8564FkCLYA', '154461618946000006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('PVO1Fpz27BXORAiUj3e', 'kPLbeydkgiYW6NIkCt0', null, 'hdMXKLI1XqTUYUrFniv', '0', 'aa25jXytFYZYB62Ac2z', '155168804628700001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('pvtZgy9acHNgJbvaGay', 'jkpTHKg7DpuXQrppVxx', null, 'EGmIBh1ogGUoD8df1rE', '1', 'K1Q7LwDo3Y9JWxc1O1W', '155142353158000002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('pvXV7GWftmmJaMMLeJ6', 'WB81MbCBolNg6XmE35M', null, '11e6-5303-7920361b-a13d-c75d0a89256c', '1', '11e6-5306-6d0daa12-a13d-c75d0a89256c', '155141104885300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('pVzDJdg8WJCiftA6QS5', '2ytUeoxBqghwofmBALl', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'fu3FPAvy3QbJl8Y96P7', '154461619038200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('pvZfw2SdvMasaE2K8g2', 'kPLbeydkgiYW6NIkCt0', null, 'jIuyPXyzHxgmBlx4oQs', '2', 'jIuyPXyzHxgmBlx4oQs', '155168804472700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PWaW2k83KWYAVEZohPI', '2ytUeoxBqghwofmBALl', null, '9ppSV2PIKNhHCOwufvI', '0', '1vKJVgUjJInvLMSVXIn', '154461618961700004', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '36', '1');
INSERT INTO `t_permission` VALUES ('pwDhehCQ7Boq7hGkuko', 'kPLbeydkgiYW6NIkCt0', null, 'TqQZlnV3BVaRGCm4tXn', '1', '7Cu3i9C1gOoAeAS2dAn', '155168804542900003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('pwfzRocazX7JsJ2Hpt3', '2ytUeoxBqghwofmBALl', null, 'laN4VVChl81K10rDCWr', '1', 'laN4VVChl81K10rDCWr', '154461618794500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('pwgDpbGbvBCXpqdyZYo', '2ytUeoxBqghwofmBALl', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'SospNqkq0w4oZqt8HNv', '154461619108500002', 'HdPeBqYwJyFyjHkhZu3', '只读按钮', '3', '1');
INSERT INTO `t_permission` VALUES ('pwlu0iRL6GWiIOt3z6o', '0Q0LkJpfR1ejtO8rD3p', null, 'vThTQ2M4QKScZTsYPVX', '2', 'vThTQ2M4QKScZTsYPVX', '155168789295500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PWorury1GNFsvX1vQlG', '2ytUeoxBqghwofmBALl', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'IHazLikeEs3KYw5CBgr', '154461619066300003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('PwPd4QglMeRBVQLyT3e', '3tFw1boS5L9vXoJCr6Z', null, 'eLFjqFngRQrIkbsdeBd', '1', 'UZzpqQ3lo5RbuYNWbsL', '154563949614800004', 'HdPeBqYwJyFyjHkhZu3', 'pdf导出', '25', '1');
INSERT INTO `t_permission` VALUES ('PwVqMKQJ9vKKG8vRld8', '2jSs6cnzu4mzY9C13vF', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'IE1QRBOyhDRgkxFpUU2', '155142339648300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('px8ZTKnEGuSPrLfMI58', '0Q0LkJpfR1ejtO8rD3p', null, '7am5R9EPlSCV3gz3SZG', '2', '7am5R9EPlSCV3gz3SZG', '155168789290800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('pXlnVuKQN1Wzs9PCMqK', 'kPLbeydkgiYW6NIkCt0', null, '3gGNzYyE5dK9ogZidWA', '1', 'HbDOYiiIBcC1oYN30Kx', '155168804622500002', 'HdPeBqYwJyFyjHkhZu3', '保存', '4', '1');
INSERT INTO `t_permission` VALUES ('pXMGBQ4l5jvyBXybSld', '0Q0LkJpfR1ejtO8rD3p', null, 'IiQlslLmgrgXGsdYY0S', '2', 'IiQlslLmgrgXGsdYY0S', '155168789309500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('PXoa8H4hdHzXy9clgQ2', '2ytUeoxBqghwofmBALl', null, 'OGMmff1QTZYqFk5vfeD', '1', 'KTmmfPfwuB4gGJuw9fD', '154461618925700000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('pXoTFR692H6SPvFaXZH', '2jSs6cnzu4mzY9C13vF', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'jlpTpnbZ03B6oqSeFmM', '155142339819900003', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('pXteOog8xvB21GfLGiD', 'WB81MbCBolNg6XmE35M', null, '11e6-5611-9a2d4725-91c5-cd8abd28b1f9', '2', '11e6-5611-9a2d4725-91c5-cd8abd28b1f9', '155141104769900002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('pXxfM6HAqsQv5adDQTE', '2ytUeoxBqghwofmBALl', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'mJFtUs7KSNrMTt3W70z', '154461619136700004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('pXZBNikJ1aQwnVdk2nU', '2ytUeoxBqghwofmBALl', null, '9ppSV2PIKNhHCOwufvI', '0', 'KXsfuFCITnsqT6hE3Je', '154461618961700002', 'HdPeBqYwJyFyjHkhZu3', '导出', '16', '1');
INSERT INTO `t_permission` VALUES ('pY5EcA1bSVfk7uZHA05', '2ytUeoxBqghwofmBALl', null, 'XpNoNSLR8vialNcJDXq', '0', 'WadmhwRuII4JmFt4TYS', '154461619061700002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('pyfEhMK1xNWxAFgWnUU', '2ytUeoxBqghwofmBALl', null, 'nTlBd4a4Vt8mtiTX41J', '0', 'E3J8OfymoQtKHIuFNMK', '154461619094500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('pYfFEOs6c6d75CioeW8', '2ytUeoxBqghwofmBALl', null, 'WHKujMuxTp67TYMu80o', '0', '7wT8mURPGaaDwJxvvHC', '154461619096000006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('PYseI7vmjEI37OrXUy9', 'kPLbeydkgiYW6NIkCt0', null, 'A6EMGp4mkUqLbMGLtql', '0', 'z1cc7dNuc4Vg60yjjLM', '155168804606900005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('PyZpia3QNceMoyBOYqD', '2jSs6cnzu4mzY9C13vF', null, 'vDsnTykdPOblfwEF4mR', '1', 'I7O5wArbJ75dWvyv3oX', '155142339876100002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('PzSdmE8ETfXCdiBdLE3', 'jkpTHKg7DpuXQrppVxx', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'jlpTpnbZ03B6oqSeFmM', '155142353108000002', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('pZYvdo3UlUastDN8qwh', 'kPLbeydkgiYW6NIkCt0', null, 'lOgu0Jvq0z5dlveyrnY', '0', 'eq15KrpMbnefCOE2bGq', '155168804616300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('q0h8geuF1fekmJzPFZv', 'kPLbeydkgiYW6NIkCt0', null, 'qqHbF4LC1qdUg1ak29k', '1', 'qqHbF4LC1qdUg1ak29k', '155168804547600006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('q1hdrFzzvcrqYGlxL7r', '2jSs6cnzu4mzY9C13vF', null, 'Ad9RS4RG7w9vkXmoKHG', '2', 'Ad9RS4RG7w9vkXmoKHG', '155142339561000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('q1rOMe8v5BVx9XMxvsP', 'jkpTHKg7DpuXQrppVxx', null, 'zqGmDkZIRa4COpFVzTj', '1', 'xBzMYIFuvohJrsvZE5M', '155142353006600003', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('Q1v6pS938F4KipT5LKA', '2jSs6cnzu4mzY9C13vF', null, 'RZTAlFVXkUYpYm96zVo', '1', 'RZTAlFVXkUYpYm96zVo', '155142339890100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Q2E3qzDw1fUyD66R13T', '2jSs6cnzu4mzY9C13vF', null, 'pyZGNS3zwQ5ravJoqyj', '2', 'pyZGNS3zwQ5ravJoqyj', '155142339578100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Q3RmRDWQriRapRKLWc6', 'jkpTHKg7DpuXQrppVxx', null, 'sxP7Fu1gvFvYLklKaKB', '2', 'sxP7Fu1gvFvYLklKaKB', '155142352959800006', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('q5rf4hvQMtijkLpw0iu', '2jSs6cnzu4mzY9C13vF', null, '4wigakaNlnx6FakxlBQ', '2', '4wigakaNlnx6FakxlBQ', '155142339620200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Q61WSN4tEiGNrbW6DlT', 'kPLbeydkgiYW6NIkCt0', null, 'EaVrfjS89IZqE63BWPa', '0', 'lPhlrrSkZ8hekbRhXPh', '155168804631900001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Q6ZegFAj7rS7hw6imsD', 'kPLbeydkgiYW6NIkCt0', null, 'EUJuOrIly3lBnwGTF7Q', '1', 'EUJuOrIly3lBnwGTF7Q', '155168804606900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('q737TdyCVJJiu0xfB6Y', 'WB81MbCBolNg6XmE35M', null, '11e6-5e14-92072f34-ae15-3d6b584ebd70', '2', '11e6-5e14-92072f34-ae15-3d6b584ebd70', '155141104759000003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Q75ZNk1FoSgAHw0YTL0', 'jkpTHKg7DpuXQrppVxx', null, 'bkoXpI9ilQlOYD8wsbU', '1', 'eEsrQhBVYzA97RMPPGX', '155142353080000003', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('Q7lkrzR28HanpsPA9Uo', '2jSs6cnzu4mzY9C13vF', null, 'aGwWScnt2f6X87bV5u9', '1', 'aGwWScnt2f6X87bV5u9', '155142339720100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Q8DPVjm0B5C7o1T2VUD', 'kPLbeydkgiYW6NIkCt0', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'M2lLJBuu4yQUfthKi4F', '155168804591300005', 'HdPeBqYwJyFyjHkhZu3', '保存草稿', '19', '1');
INSERT INTO `t_permission` VALUES ('Q96xzTlFwNI14VHmfbM', '2ytUeoxBqghwofmBALl', null, 'hdMXKLI1XqTUYUrFniv', '0', '3EhqWBGmEEkub8qvOuy', '154461618941300004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('qAGF9EWGKkbNEaVU5gC', 'jkpTHKg7DpuXQrppVxx', null, '6bUPlXeVH92MIv7Nmdw', '1', 'ZNYYg5DdRtEMBaS3QLl', '155142353025400003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('QAPOt3mUNGsHuC8gHuP', '2jSs6cnzu4mzY9C13vF', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'E47mVx0cWjUwctEiuIt', '155142339749700004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('QAqa8NlNPxGkjHsyaeL', 'kPLbeydkgiYW6NIkCt0', null, 'Z6pISvulUdsSz8bjuOV', '0', '81O85fI7nEQvujIwWvl', '155168804577300004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('QaVIWAQ9xtB2XK0sboT', 'WB81MbCBolNg6XmE35M', null, '11e3-995e-11cc3dcd-8582-9597e950ed46', '0', '11e4-ceb2-7ed2c46f-b2a1-b5b94c6fcd94', '155141104857300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '导出Excel', '16', '1');
INSERT INTO `t_permission` VALUES ('qaZO3NUl3wiOoTrkumj', '0Q0LkJpfR1ejtO8rD3p', null, 'sxP7Fu1gvFvYLklKaKB', '2', 'sxP7Fu1gvFvYLklKaKB', '155168789297000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('qbcA9r4e3MeAnDPA06I', 'WB81MbCBolNg6XmE35M', null, '11e6-5611-a66a5d76-91c5-cd8abd28b1f9', '2', '11e6-5611-a66a5d76-91c5-cd8abd28b1f9', '155141104773000001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Qc4uuWGO7NDvxPjJ5js', 'jkpTHKg7DpuXQrppVxx', null, '9ppSV2PIKNhHCOwufvI', '0', 'KJPLDYCNeJz1SWkwXZd', '155142353125200002', 'HdPeBqYwJyFyjHkhZu3', '下载文件', '26', '1');
INSERT INTO `t_permission` VALUES ('qcD0VPaqObgmUTsah6X', '2ytUeoxBqghwofmBALl', null, 'F6reQ5BW7P6q236Pi13', '1', 'Okamal6erVlSp96ygxI', '154461619117900000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('qCMAu0pAGDTlBpgWNqT', 'WB81MbCBolNg6XmE35M', null, '11de-c39b-5cf3eb81-b652-871d9b638147', '1', '11de-c39e-23329469-b652-871d9b638147', '155141104872900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '打印', '14', '1');
INSERT INTO `t_permission` VALUES ('qCPBhvrmZNketH8T54X', '2ytUeoxBqghwofmBALl', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'KWyhjGMdOzdszl2VD2Q', '154461619096000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qcpQxqnaV1wxvQUhpDx', '2ytUeoxBqghwofmBALl', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'CJu3AVSi8NfqhFlu5jl', '154461618972600002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qcxDOTT60ZdtaSzAoyC', '0Q0LkJpfR1ejtO8rD3p', null, '7fddj0hyGNlDYSZpyFZ', '1', '7fddj0hyGNlDYSZpyFZ', '155168789478000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qDJqKjx7SWfm75mdU4b', '2ytUeoxBqghwofmBALl', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'wKRxU5XodFTWQ3Od5v0', '154461618936700005', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('qdPGnQlChvzs4xlIhlk', '3tFw1boS5L9vXoJCr6Z', null, 'LSwQOY0mggQ0vy4752p', '0', 'PSPMnN2J3uJvKmrQ0mW', '154563949633500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('qdwjLBhznYeIGFcGFu8', '2ytUeoxBqghwofmBALl', null, 'lAUkIpgQSIZqQyttrB4', '1', 'g6HusIB9Lr81fIHCCp5', '154461618963200000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('QdWuR1t1tSGHrLOROup', 'jkpTHKg7DpuXQrppVxx', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'TFCrC5zb0w6fDoq6icl', '155142353075300002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('QedLbe0UsCaoofYKKLy', '2jSs6cnzu4mzY9C13vF', null, '98kmnnrWwGKmgyiIkUF', '0', 'mlTio0aN6W90Aant0Mk', '155142339745000000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('QEf6y6zXWrYsMXdPqjJ', '3tFw1boS5L9vXoJCr6Z', null, '3K4lxgBhBLAbzJrfYaB', '1', 'iYGmCNLDOISoDmNMi4d', '154563949632000005', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('QEvtvutKlzKjNyW5jia', '2jSs6cnzu4mzY9C13vF', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'bYd4AsVWGV8kpxju1vo', '155142339779400004', 'HdPeBqYwJyFyjHkhZu3', 'PDF导出', '25', '1');
INSERT INTO `t_permission` VALUES ('Qfd2XRwmDnAIt7S2t9C', '0Q0LkJpfR1ejtO8rD3p', null, 'kA4m81roWetnkDQgWm0', '0', 'fc8oYpPYk2t3xyohWqx', '155168789381300003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Qff7YtCOk4HzvGAvdAq', '2ytUeoxBqghwofmBALl', null, 'ddbeKTjs0WvqKVJ90MU', '1', '8S96fbM0hHIvN2tHSUq', '154461618950700000', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('QFjjD8o5Z6vqF5TbCIV', '0Q0LkJpfR1ejtO8rD3p', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'iY5ypHvJGJTn6j3J2nC', '155168789443700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('QfrxOTHSMVljupnRqnt', 'jkpTHKg7DpuXQrppVxx', null, '74xpaQX1peQaya80WFh', '2', '74xpaQX1peQaya80WFh', '155142352970800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QG0yk3PVWKNm0FXE6gI', 'WB81MbCBolNg6XmE35M', null, '11de-7665-e571fab8-8d52-0547317ddd4c', '1', '11de-7b44-c1cf6336-8e75-5db8009a65bb', '155141105133400002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('QGfWDCzWMmDCS2z90yt', '3tFw1boS5L9vXoJCr6Z', null, 'ZM7F9MjjscP8bADF7cH', '1', 'aN0KA8MmhVB1LjOqtWo', '154563949502300005', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('QGfyNMYfYxCZT2uSFAn', '0Q0LkJpfR1ejtO8rD3p', null, 'avS4WYnlhLiRlkXIHhD', '2', 'avS4WYnlhLiRlkXIHhD', '155168789336000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('qGIHPyNvxVnGYhejx9b', '2jSs6cnzu4mzY9C13vF', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '155142339737200004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('QhAPkor4b6UKJeZ7H40', '0Q0LkJpfR1ejtO8rD3p', null, 'U1TygLjjsSxDfEoGwhc', '1', 'hdiqWVc1ZHENK9nuZv5', '155168789343800000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Qhgs2EOGXUSK9y9Nl97', '2jSs6cnzu4mzY9C13vF', null, 'DzqlEtg4JObApV7iWX8', '0', 'YIzUW1O7NPBhfxLwHuj', '155142339766900000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('QHM3i0hk1F8eQEiBf8Y', '0Q0LkJpfR1ejtO8rD3p', null, 'mEHACJenoEKew2MDnRm', '1', 'mEHACJenoEKew2MDnRm', '155168789454600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qI5V8fwYGT8z2XrHdtT', 'WB81MbCBolNg6XmE35M', null, '11e6-55fe-4ea6ff8f-bb59-b7243d4bcf51', '1', '11e6-55fe-4ea6ff8f-bb59-b7243d4bcf51', '155141105013300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('QibVRlAtAznN1zVX3Mb', '2ytUeoxBqghwofmBALl', null, 'HqyysOeWOVkmU29sLla', '0', 'K6e79wYCTJXzxMeQIon', '154461619019500004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('qielD6xD3H66JmJEBmA', 'kPLbeydkgiYW6NIkCt0', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'Mto2Exz54Tcvkyw1NCx', '155168804553900004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qiplAtvfYBSU3fIVJ7j', '2ytUeoxBqghwofmBALl', null, 'T9IoQKXjHSvxRXYM3L8', '1', 'T9IoQKXjHSvxRXYM3L8', '154461618967900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('QjfWTs1KetKO4cRdEy5', 'jkpTHKg7DpuXQrppVxx', null, 'MnvkHQ9zdkDlQaAgtGq', '2', 'MnvkHQ9zdkDlQaAgtGq', '155142352970800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QJJfgp0IInBqVZteakE', 'kPLbeydkgiYW6NIkCt0', null, 'taWpyKypy5rBhloCotj', '2', 'taWpyKypy5rBhloCotj', '155168804477400005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QJlfi8Ju9YZbYs5IXUN', 'jkpTHKg7DpuXQrppVxx', null, 'gkbm2C0NbCfu86GHkFh', '0', 'C06613mOoQKz6Rr0LIo', '155142353053400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('QjmcNKsZxC4npjhjHa7', '2ytUeoxBqghwofmBALl', null, 'IuPDe4Gm9occzflnrP0', '0', 'R45h7dTChA2x72ng9VU', '154461618972600001', 'HdPeBqYwJyFyjHkhZu3', '当前页面打开', '43', '1');
INSERT INTO `t_permission` VALUES ('qJtMDHG69Owtawi2X1P', '3tFw1boS5L9vXoJCr6Z', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'bOLR3Xo33mj06rfix3J', '154563949575700004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('qk0ZyzZyX48lae3MXGb', '3tFw1boS5L9vXoJCr6Z', null, 'JHeHJ8lBe8BGHZfwoph', '2', 'JHeHJ8lBe8BGHZfwoph', '154563949455400002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QklXADxYR49SvrCpaaF', 'WB81MbCBolNg6XmE35M', null, '11e6-54c0-6df9a554-9671-379f935a9949', '1', '11e6-54c1-aa2bd7b7-9671-379f935a9949', '155141104910300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('QkO9rRyb2btHG0gaItI', '2ytUeoxBqghwofmBALl', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'bYd4AsVWGV8kpxju1vo', '154461619039800006', 'HdPeBqYwJyFyjHkhZu3', 'PDF导出', '25', '1');
INSERT INTO `t_permission` VALUES ('QKoWwXAlpedcCnwqZno', '0Q0LkJpfR1ejtO8rD3p', null, '5RzsvfgAUx2y0k1pDlg', '0', 'ukXAzRjE6lHNKWb0XN5', '155168789485800002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('qkqCM3rF6O0HpdSLbkc', 'kPLbeydkgiYW6NIkCt0', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'ISM9kGtKs3Gkvrg1HSD', '155168804649000000', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '27', '1');
INSERT INTO `t_permission` VALUES ('QKulAaODVa83lbTbhUn', '3tFw1boS5L9vXoJCr6Z', null, 'EKD2uh12ht0Vptz9xN5', '0', 'ThJH0AWU99Z8F5DDmUo', '154563949513200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('qkV6GNNVPFDcn1bJbc6', '0Q0LkJpfR1ejtO8rD3p', null, 'wjPLVvwWYR2a9BOi0st', '0', '6798mFOtT3LLK9CYgPv', '155168789440500002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('QLiBkLmGZeSpEiT5TVj', '2ytUeoxBqghwofmBALl', null, '5RzsvfgAUx2y0k1pDlg', '0', 'ukXAzRjE6lHNKWb0XN5', '154461619099200006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('qlpWYgWlLQndFuvaxhk', 'jkpTHKg7DpuXQrppVxx', null, 'ZM7F9MjjscP8bADF7cH', '1', '0LKFnyB5ViPnDQN8Ocl', '155142353033200001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('qLw6b0ms4LuyiCpTf6x', '2jSs6cnzu4mzY9C13vF', null, 'TqagBUMFdyCepAZ3Umc', '2', 'TqagBUMFdyCepAZ3Umc', '155142339614000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('qMaa0bokuQoubMtu1kT', 'kPLbeydkgiYW6NIkCt0', null, '2Icse0Cn99YRTQTZO3f', '1', '2Icse0Cn99YRTQTZO3f', '155168804669300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qmBYTnOesdzwhqcpd0E', '0Q0LkJpfR1ejtO8rD3p', null, 'IuPDe4Gm9occzflnrP0', '0', 'dSSZNfrsXOVhXvx7vOM', '155168789467100000', 'HdPeBqYwJyFyjHkhZu3', '页签打开', '43', '1');
INSERT INTO `t_permission` VALUES ('QMn2fgnNXy28wlVVT0H', 'jkpTHKg7DpuXQrppVxx', null, 'yv2DP99h1j34cgCO1SZ', '2', 'yv2DP99h1j34cgCO1SZ', '155142352994200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QMVS8VbkpK41AuY6BpE', '2jSs6cnzu4mzY9C13vF', null, 'a7jp1Dm53YjlAwDWuws', '1', 'a7jp1Dm53YjlAwDWuws', '155142339773100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qMX0TRUNXzUbSSRRGDP', 'kPLbeydkgiYW6NIkCt0', null, 'qOM6QAy48iqde43ij94', '2', 'qOM6QAy48iqde43ij94', '155168804489900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Qn08bblRzrRVhe2PB4h', 'WB81MbCBolNg6XmE35M', null, '11e6-5612-15fc60a6-91c5-cd8abd28b1f9', '2', '11e6-5612-15fc60a6-91c5-cd8abd28b1f9', '155141104774600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('qND6v15e9N154ruleoE', '2jSs6cnzu4mzY9C13vF', null, 'Gc5icb2c0g8ARf7Jath', '0', 'nHElJbBXVkEhXwGIaUL', '155142339631200002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('QnWdirDEyEGrcn2Zkff', '2jSs6cnzu4mzY9C13vF', null, 'P14ZGIv1IEdecUGGYYk', '2', 'P14ZGIv1IEdecUGGYYk', '155142339553200004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QnzA2rT6s4oTIBDQfSr', 'kPLbeydkgiYW6NIkCt0', null, 'GP2yEPcfqN4Gwg8M4Da', '2', 'GP2yEPcfqN4Gwg8M4Da', '155168804479000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QO24VmXhqYqOekEgohY', '0Q0LkJpfR1ejtO8rD3p', null, '3gGNzYyE5dK9ogZidWA', '1', 'HbDOYiiIBcC1oYN30Kx', '155168789453000003', 'HdPeBqYwJyFyjHkhZu3', '保存', '4', '1');
INSERT INTO `t_permission` VALUES ('QOoGGqxzJTgvg6cY49G', '2jSs6cnzu4mzY9C13vF', null, '7q6BJWxhJzTuAFZpxa8', '2', '7q6BJWxhJzTuAFZpxa8', '155142339548500004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QoZFgoo6JwMgqchUeNp', '0Q0LkJpfR1ejtO8rD3p', null, 'G0WtPO1mX58wd7tjkTy', '0', 'MiGkf6DvyyRTJk95EY3', '155168789421800001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('qp0RB8DvzhGbqbqowNL', '2ytUeoxBqghwofmBALl', null, 'poalxIjVlN70WdVjfQq', '1', 'poalxIjVlN70WdVjfQq', '154461619147600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Qpknj5yCWXAEpRuxmkB', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-25ff2cf8-91c5-cd8abd28b1f9', '2', '11e6-5619-25ff2cf8-91c5-cd8abd28b1f9', '155141104754300003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Qqft7vep9t7fY2KjoAd', '0Q0LkJpfR1ejtO8rD3p', null, '6BIvNJISOeZ3xm8S2aG', '1', '6BIvNJISOeZ3xm8S2aG', '155168789348500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qQQ3ZXoAvFVneEpJv70', '2jSs6cnzu4mzY9C13vF', null, 'JHeHJ8lBe8BGHZfwoph', '2', 'JHeHJ8lBe8BGHZfwoph', '155142339595300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QR2j4lnk5buQdAxz9z5', 'jkpTHKg7DpuXQrppVxx', null, 'qAcxhZ5mnoiohEBYD9G', '2', 'qAcxhZ5mnoiohEBYD9G', '155142352958300005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QR58D92dKF8OoJAd9o1', 'kPLbeydkgiYW6NIkCt0', null, 'IMD35YU4FNWL8IkwPAJ', '1', 'IMD35YU4FNWL8IkwPAJ', '155168804558500005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Qr8DPZwBNYKjUwacr5E', '0Q0LkJpfR1ejtO8rD3p', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K4IeXTdrXu7wZa0AkpH', '155168789370300000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('QRDqYyiutt0wTEEkabr', 'jkpTHKg7DpuXQrppVxx', null, 'QgINfDEbj3rwSwaOJHg', '2', 'QgINfDEbj3rwSwaOJHg', '155142352989500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QRM8CKDfr27vnsFNrqH', '0Q0LkJpfR1ejtO8rD3p', null, 'Ksfgm24NkZrnPIXYgay', '2', 'Ksfgm24NkZrnPIXYgay', '155168789322000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QS7jc7571EqULVWuvA7', '2jSs6cnzu4mzY9C13vF', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'eTfrqgZ8RLViOksDpqV', '155142339819900001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('QsavKVYHmfAto1Pg1rZ', '2jSs6cnzu4mzY9C13vF', null, 'Vu8Q68Bom89YJDgguC9', '1', 'Vu8Q68Bom89YJDgguC9', '155142339787200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qSssLmlsugEfsRXYBT7', '2ytUeoxBqghwofmBALl', null, 'QKYvQ00K4tWyyjKycUC', '0', 'ARs78PxB8dp6mXxPrKL', '154461619091300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('qT14I9FV4GygkVPaquA', '3tFw1boS5L9vXoJCr6Z', null, 'jhINwVUWllGph0gnSC6', '0', 'GdRrT9CE4nmpUBASJy2', '154563949525700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('QtEq4BMQ8sdgSnspYSt', 'WB81MbCBolNg6XmE35M', null, '11e6-592c-d0d8c95a-a8ef-c39406c7f446', '1', '11e6-5934-98cc0eb5-a94a-e36ebd4ccf2c', '155141105177100001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('QTFpA3OfhpvDkJYUwkI', '0Q0LkJpfR1ejtO8rD3p', null, 'Ta56UCfylnpmF0NhOQW', '2', 'Ta56UCfylnpmF0NhOQW', '155168789320400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('qTJv1R3yuRoxpXXQgQ1', '2ytUeoxBqghwofmBALl', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'jlpTpnbZ03B6oqSeFmM', '154461619066300002', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('QtnwDus1lCXrHmCjPJh', '2jSs6cnzu4mzY9C13vF', null, 'iL3YpikkZUlruc5ai3D', '1', 'iL3YpikkZUlruc5ai3D', '155142339663900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('QtsLADlhMbjGhfbWFND', 'jkpTHKg7DpuXQrppVxx', null, 'ry6uZqKmxro1UYtKquD', '2', 'ry6uZqKmxro1UYtKquD', '155142352953600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QuAeuRrjLRu5ea4Wo2R', 'kPLbeydkgiYW6NIkCt0', null, '7NlGpNC1MAEM6EuX2X0', '1', 'tqjrAb05aPRsD2JYTh1', '155168804677100004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('qUbbTlQ2d3axPt7rjKP', 'WB81MbCBolNg6XmE35M', null, '11e6-6384-200a2f95-80b8-b12ccac86772', '1', '11e6-6384-200a2f95-80b8-b12ccac86772', '155141105022600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qUhe2qKhyMOUTROXb8Y', '3tFw1boS5L9vXoJCr6Z', null, 'j4ncSyWthzCYoNj3n4J', '0', 'WWNamo3Hl2Q5IoZUFn7', '154563949583500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('QuJOSNV6HGEnDAIIg9P', 'jkpTHKg7DpuXQrppVxx', null, 'AkuEixxtkMd7QuHLVOR', '2', 'AkuEixxtkMd7QuHLVOR', '155142352956700004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('qv0cFHsmjRlkwI0bYjH', 'kPLbeydkgiYW6NIkCt0', null, 'a0NeCmvVh6L5QDzhezl', '2', 'a0NeCmvVh6L5QDzhezl', '155168804493000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QVFiGNFIyKkC740yqSq', '0Q0LkJpfR1ejtO8rD3p', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'XG8ap7ffszErnf3ZYYp', '155168789439000001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('QVKQwYgqLypIxLPHrSP', '2jSs6cnzu4mzY9C13vF', null, 'EKD2uh12ht0Vptz9xN5', '0', 'ThJH0AWU99Z8F5DDmUo', '155142339738800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('QvuGAbrXuB6T4KUadgd', 'WB81MbCBolNg6XmE35M', null, '11e6-6ad8-56559bec-82ae-bbe47783a3bc', '1', '11e6-6ad8-56559bec-82ae-bbe47783a3bc', '155141105028900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qVWsQmoMA4pCqQlpM1z', 'jkpTHKg7DpuXQrppVxx', null, 'McumxQcBkg92YPli9Ox', '1', 'McumxQcBkg92YPli9Ox', '155142353098700003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('QWBBmvuEqIE7ut9HoD8', '2ytUeoxBqghwofmBALl', null, 'IfoHRC8Rs6njW75HqiE', '1', 'IfoHRC8Rs6njW75HqiE', '154461619019500003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Qwr5BcHqfQicrBGpENr', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-67f06eb6-91c5-cd8abd28b1f9', '2', '11e6-5619-67f06eb6-91c5-cd8abd28b1f9', '155141104754300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Qx0YIFgMYqdewoxf20S', 'kPLbeydkgiYW6NIkCt0', null, 'Li1q0Dlwg6sZn4YFamQ', '2', 'Li1q0Dlwg6sZn4YFamQ', '155168804486800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QXqABSOk1ewAJR6TgeS', '0Q0LkJpfR1ejtO8rD3p', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'zEz94y8drV2wM7Sh0jS', '155168789376600001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('qxRpc0oPYdzWyjMI9Z3', '2jSs6cnzu4mzY9C13vF', null, '3K4lxgBhBLAbzJrfYaB', '1', 'iYGmCNLDOISoDmNMi4d', '155142339905700002', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('QYBX0rbcSaVKwnLvvb9', '2jSs6cnzu4mzY9C13vF', null, 'qOM6QAy48iqde43ij94', '2', 'qOM6QAy48iqde43ij94', '155142339579700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('QYFvszN3tLQtHjdpV1G', 'kPLbeydkgiYW6NIkCt0', null, '6esIc2fTAI9nAOoOZcp', '1', '6esIc2fTAI9nAOoOZcp', '155168804553900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('qYhT8ymBE4G2bp3aaRS', '2ytUeoxBqghwofmBALl', null, 'eLFjqFngRQrIkbsdeBd', '1', 'FdZlsUl66zL94sGKwVe', '154461619128800000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('qYjCk9rnNNezy3n3YUC', '0Q0LkJpfR1ejtO8rD3p', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'iURMg4fbNkBkiB0qxra', '155168789368800001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('qZ2GvmteAgscwUORf1P', 'WB81MbCBolNg6XmE35M', null, '11e6-53e0-0aeaac2d-81f5-679a826556ce', '1', '11e6-d15f-90e195db-bbdd-9f7a0eebced4', '155141105120900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('qZbf8nYE4HnyregmLD5', '0Q0LkJpfR1ejtO8rD3p', null, 'p44Eh34DScjVKkZi1ok', '2', 'p44Eh34DScjVKkZi1ok', '155168789301700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('qzcTHhYyfjdXHiGKoaC', 'kPLbeydkgiYW6NIkCt0', null, 'cbE2ixGwPBn9lHk5RmS', '2', 'cbE2ixGwPBn9lHk5RmS', '155168804469600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Qzk7utBmy4BEu8dQOGI', '2ytUeoxBqghwofmBALl', null, 'SAzJx5AkUZOJRct29BH', '0', 'x3O0Ifcwe8BqX5uhms5', '154461619066300004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Qzm1gxEkNJnqIWh6hzy', 'kPLbeydkgiYW6NIkCt0', null, 'Gc5icb2c0g8ARf7Jath', '0', 'nHElJbBXVkEhXwGIaUL', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单', '2', '2');
INSERT INTO `t_permission` VALUES ('Qzu6pkoqr1H5at4IgWx', 'jkpTHKg7DpuXQrppVxx', null, '4VkP5W8VPlERMiThvSD', '0', 'DKXXNVp1SE3PrcD4Mq2', '155142353089300000', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('r07tN3C2ssFnEqe7TqJ', '2ytUeoxBqghwofmBALl', null, 'U1TygLjjsSxDfEoGwhc', '1', 'U1TygLjjsSxDfEoGwhc', '154461618927300003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('R0K4ozd9TvFiLzLeAAU', 'kPLbeydkgiYW6NIkCt0', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '155168804575700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('R0XmvcwmL9BwhhpmfQI', 'jkpTHKg7DpuXQrppVxx', null, 'blVc1BNkTRUvVGde7Pj', '2', 'blVc1BNkTRUvVGde7Pj', '155142352986400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('R1qCOesrKT8XGLhkv03', 'jkpTHKg7DpuXQrppVxx', null, '9IbX83RDH7O16tUh901', '2', '9IbX83RDH7O16tUh901', '155142352991000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('R1XQxcGRv0Fvhz1wfU0', 'jkpTHKg7DpuXQrppVxx', null, 'LfGA9FEokOkgKY6hN4p', '2', 'LfGA9FEokOkgKY6hN4p', '155142352980100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('R23DfphxFqkh9HyrXbH', '2jSs6cnzu4mzY9C13vF', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'fkbqJ4vxJOUvHY59Lo6', '155142339883900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('R2i1sEQ3BGcSQqKlE0O', '2ytUeoxBqghwofmBALl', null, 'eKZqOwJmAFsUEwu0WfL', '1', 'eKZqOwJmAFsUEwu0WfL', '154461618960100004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('r2m7I8ydggkEtVxO0j2', 'WB81MbCBolNg6XmE35M', null, '11e6-5612-0c03bc15-91c5-cd8abd28b1f9', '2', '11e6-5612-0c03bc15-91c5-cd8abd28b1f9', '155141104777700003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('R3nIY6NpbcQiUkisc6I', '0Q0LkJpfR1ejtO8rD3p', null, 'SAzJx5AkUZOJRct29BH', '0', 'x3O0Ifcwe8BqX5uhms5', '155168789446800001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('r3rZ0bZbp6iAFhiKGar', 'jkpTHKg7DpuXQrppVxx', null, '4VkP5W8VPlERMiThvSD', '0', 'SOe9OaDTLOE1domxYKV', '155142353087800003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('r3xAp7Ed67Gyiatmnne', 'kPLbeydkgiYW6NIkCt0', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'czdV0c3QJMI2AZPkQZ6', '155168804638100002', 'HdPeBqYwJyFyjHkhZu3', '新建（绿色）', '2', '1');
INSERT INTO `t_permission` VALUES ('R3yAqw7IkJ3H6uOOJNz', 'jkpTHKg7DpuXQrppVxx', null, 'RGSlfhmaWRtgtaWUhTU', '2', 'RGSlfhmaWRtgtaWUhTU', '155142352963000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('R47RZ7cy2RsdjEulFIk', 'jkpTHKg7DpuXQrppVxx', null, '6bUPlXeVH92MIv7Nmdw', '1', 'qPbgIDRXTjRZoXpvZJl', '155142353025400004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('R49ERj3JbyUwJBVdr24', 'jkpTHKg7DpuXQrppVxx', null, '4mlBSmLGlzULUWJe8Nu', '1', 'XeBSO1gjZBWzi78mcUl', '155142353081500004', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('r4cZcCDv0EmAClvyLPm', '2jSs6cnzu4mzY9C13vF', null, 'bKWrnsYGUGaqqYqkeeO', '0', 'eKS6W5ObdgLXuBIKcJP', '155142339910400000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('r4NVGdp2LsYGHDsau8E', '2jSs6cnzu4mzY9C13vF', null, 'ZM7F9MjjscP8bADF7cH', '1', 'ZM7F9MjjscP8bADF7cH', '155142339699800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('R4ZfSYPos5L2IkcRUWu', '2jSs6cnzu4mzY9C13vF', null, 'G1v3gcUQOvFAo7IH62c', '2', 'G1v3gcUQOvFAo7IH62c', '155142339568800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('R5XxbqTTJrwNGVHXCVY', '2jSs6cnzu4mzY9C13vF', null, 'UmMnr5J8RhgknR3Dsos', '0', 'RZ790ojkvhzumC5tyL2', '155142339763800002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('R6dDKN8jD28rrBWas3y', 'kPLbeydkgiYW6NIkCt0', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'KDRVonlpSB5oYD1O1LY', '155168804647500003', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('R6hWunxx6C1o1aHeoi6', '2ytUeoxBqghwofmBALl', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'sMlqIILsNZ3bvqE2hSm', '154461618928800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('r6MHxK8zkw63mKmdQcP', '2jSs6cnzu4mzY9C13vF', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'cY4kl4aBnqojbhnxddX', '155142339818400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('r6Nsd3qntHl7ybvqV8P', '3tFw1boS5L9vXoJCr6Z', null, 'sivHMH0kWQLjuMBG8z1', '2', 'sivHMH0kWQLjuMBG8z1', '154563949428800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('r6O2JRrfXmLqBv5lEoy', 'jkpTHKg7DpuXQrppVxx', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'mHhOCWGxOkvrAOWpqLl', '155142353022200002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('r6w3jG4mxnVkIEk6Avd', 'jkpTHKg7DpuXQrppVxx', null, 'gniImP2ug7E82S1WO0L', '1', 'A9ZVOiaJCjFUhFQkG6X', '155142353109600000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('R7AgRYTFGDOxpJXEREm', '2jSs6cnzu4mzY9C13vF', null, 'fWq4603Eftipw3SEKHB', '2', 'fWq4603Eftipw3SEKHB', '155142339553200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('r7yoa7nzeO2KVHCsnSw', '0Q0LkJpfR1ejtO8rD3p', null, 'ddbeKTjs0WvqKVJ90MU', '1', '8S96fbM0hHIvN2tHSUq', '155168789362500001', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('r83zjw9ZLKxiTQmjaCR', '2ytUeoxBqghwofmBALl', null, 'w7IsSOtXFvo61cP8sKr', '1', 'tdpqhqKdJ6wj3toLl5M', '154461619036700002', 'HdPeBqYwJyFyjHkhZu3', '打印包含流程历史', '15', '1');
INSERT INTO `t_permission` VALUES ('r8umqOvUG2Xqr2W3ftO', '0Q0LkJpfR1ejtO8rD3p', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '155168789376600003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('r9eODlAT6N8TKDznr3v', '2jSs6cnzu4mzY9C13vF', null, '3gGNzYyE5dK9ogZidWA', '1', '1yFGNlNaVN83hKJQ7vt', '155142339844900000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('ra435HTZQrlTqLZGZtc', '2jSs6cnzu4mzY9C13vF', null, 'smthlnru9z9qwavJKk1', '0', '55V8ZUWfTBCxFClWTNS', '155142339899500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('RAbB01sgTr9bHKQKG3T', 'jkpTHKg7DpuXQrppVxx', null, 'iL3YpikkZUlruc5ai3D', '1', 'iL3YpikkZUlruc5ai3D', '155142353022200005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('raFmB49OruH03cQpklE', '2jSs6cnzu4mzY9C13vF', null, '3K4lxgBhBLAbzJrfYaB', '1', '3K4lxgBhBLAbzJrfYaB', '155142339905700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('RBhHvy9RBoGpSdfc0I7', '2ytUeoxBqghwofmBALl', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'xEBN59fWrxYULgpdRLy', '154461618930400001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('rbygP0god35jR4PQern', '0Q0LkJpfR1ejtO8rD3p', null, 'kebFCC8mkGX3V1QEriK', '0', '2eoDuuIu6c2LNFTXHBl', '155168789487300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('RCZmkHe9uEq31nxdJm6', '3tFw1boS5L9vXoJCr6Z', null, 'fBeJCr5ipcIdScfuebs', '2', 'fBeJCr5ipcIdScfuebs', '154563949472600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RD2NB5gT0L9tIRdIH1d', 'jkpTHKg7DpuXQrppVxx', null, 'ZM7F9MjjscP8bADF7cH', '1', 's0ipQa9ktbRum255G0J', '155142353033200002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('RD4kqw2mrCKuFfK62py', '0Q0LkJpfR1ejtO8rD3p', null, 'cbE2ixGwPBn9lHk5RmS', '2', 'cbE2ixGwPBn9lHk5RmS', '155168789286100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RdAuzhpsoBIcbJlfYJZ', 'WB81MbCBolNg6XmE35M', null, '11e6-5530-13f122e7-8350-a3b9b8447d61', '0', '11e6-5a14-92bf5fd3-9288-a3f5193ed8de', '155141104925900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('rdE6gFLdvuLsSPy88HM', '3tFw1boS5L9vXoJCr6Z', null, 's4T0yhSw1lIJMsiBfQa', '2', 's4T0yhSw1lIJMsiBfQa', '154563949461600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rDfXlChc2sBshvokrYD', '2ytUeoxBqghwofmBALl', null, 'lOgu0Jvq0z5dlveyrnY', '0', '5XIqbMcQ6K0lFtVi4HZ', '154461619069500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('RdK5Gz6pTqMUYUClk2A', 'kPLbeydkgiYW6NIkCt0', null, 'Z6pISvulUdsSz8bjuOV', '0', '7nN7s8EOZ6SjZc0tEMY', '155168804577300005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('RdLWA7GeHC51siP3d83', '2ytUeoxBqghwofmBALl', null, 'eLFjqFngRQrIkbsdeBd', '1', 'FdZlsUl66zL94sGKwVe', '154461619052300003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('rDMzgVM6N1Pg34rSX3r', 'jkpTHKg7DpuXQrppVxx', null, 'mXDUC8go52mfA91GY0r', '0', 'P2oUhWPVibevLu0mKhp', '155142353136100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('RE47WDy63R5wcRIVL6H', 'kPLbeydkgiYW6NIkCt0', null, 'qEKeS98EGXZh9qkxklB', '2', 'qEKeS98EGXZh9qkxklB', '155168804469600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rebl4eGS07Jm5NqmPcb', '2ytUeoxBqghwofmBALl', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'lCdJ38yUB4mcSL1qJJ2', '154461618972600000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('rECupbuyDojKxGBlRBB', '2ytUeoxBqghwofmBALl', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'KMy1rLdwRmKATB4fMJZ', '154461619044500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('REltGiDr8HDiDyDgr8Q', 'WB81MbCBolNg6XmE35M', null, '11e6-4f1e-e81c7160-81e8-cb77e1bc6c59', '1', '11e6-4f2b-deb8a6ea-81e8-cb77e1bc6c59', '155141105214500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('REPInot4yCPvIR5lp3X', '2ytUeoxBqghwofmBALl', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'VC7xzHBeSzCmdpBwT9w', '154461618955400002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('rEsAYbAKB87eRvLDkwG', '3tFw1boS5L9vXoJCr6Z', null, 'kYU5ffwtqGFdhsYDlG8', '2', 'kYU5ffwtqGFdhsYDlG8', '154563949421000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rF0kKEtRsi6wJ4fJR6Q', 'jkpTHKg7DpuXQrppVxx', null, 'SiPTeSpUhRIqVgi1HW1', '0', 'LI7k2GDTP5VDdaobmtO', '155142353092400002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('RF2gMzXP0beLyLbFWFI', 'jkpTHKg7DpuXQrppVxx', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'aJ8FUYVtCO50iowXPg5', '155142353023800003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Rf4wI2rZao3zqbAaSxU', 'kPLbeydkgiYW6NIkCt0', null, 'Cg51Ds07QnrIkV1ne95', '2', 'Cg51Ds07QnrIkV1ne95', '155168804507100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RfBbEnBWqoKX85NMV9e', 'kPLbeydkgiYW6NIkCt0', null, 'Jh68ppMt3QMha315Hi6', '0', 'xTW6bbE29gUdngFIb2q', '155168804572600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('rfg9fr5iZOfuUOZtkoy', '2jSs6cnzu4mzY9C13vF', null, '3K4lxgBhBLAbzJrfYaB', '1', 'j2jPRJ7cK9BqO2p9iP9', '155142339905700001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('RFK8xrhJGDvAcjeTeja', '0Q0LkJpfR1ejtO8rD3p', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'KDRVonlpSB5oYD1O1LY', '155168789468600004', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('RfYQj5vx7UkuBYl0ryT', '3tFw1boS5L9vXoJCr6Z', null, '8BSYIj5kZKJjAD7IxkX', '2', '8BSYIj5kZKJjAD7IxkX', '154563949447600002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rg1AutjKFfyokyOVqSB', '3tFw1boS5L9vXoJCr6Z', null, '2bmCU7aUTZfM8CZmJEP', '2', '2bmCU7aUTZfM8CZmJEP', '154563949452300004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RG7JGBMn7aJM6HonzzN', 'kPLbeydkgiYW6NIkCt0', null, '4mlBSmLGlzULUWJe8Nu', '1', 'XeBSO1gjZBWzi78mcUl', '155168804591300000', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('RgF3p89Q5rw2OqFyBrS', '0Q0LkJpfR1ejtO8rD3p', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'QXO7cxkzLZ51qdiKBrI', '155168789481100001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('rGjx1Z1ag3Sv8IDQu53', 'jkpTHKg7DpuXQrppVxx', null, 'fAVX6iUbvHroALIUfPf', '2', 'fAVX6iUbvHroALIUfPf', '155142352959800003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RGOSyc5cuJ3jQeTXxmw', 'kPLbeydkgiYW6NIkCt0', null, 'kcMdjikNe3R1UmNMZPB', '2', 'kcMdjikNe3R1UmNMZPB', '155168804525800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RgSZBwRd3H8E5PWgaJc', 'jkpTHKg7DpuXQrppVxx', null, 'Ry5YZ6oWsbQSIWGTbiM', '2', 'Ry5YZ6oWsbQSIWGTbiM', '155142352967600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rGutecOxL3OvRLOl5Rg', '2jSs6cnzu4mzY9C13vF', null, 'a7jp1Dm53YjlAwDWuws', '1', 'wL7xiiufleig43GVrAC', '155142339773100002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('rh8dS5PscRNpv7h9ync', '2jSs6cnzu4mzY9C13vF', null, 'JSvvw8VjIpL8ESGH8YA', '2', 'JSvvw8VjIpL8ESGH8YA', '155142339567200002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rHdXxrDkUJImIRfxpAr', '2ytUeoxBqghwofmBALl', null, '0zSRHMqiyMTl1dth7ds', '1', 'hy32XOXaddLpvsHlLeY', '154461618946000001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('RHfT0PNbeIEyOk022oi', '3tFw1boS5L9vXoJCr6Z', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'JyfgeJsIiLDXbY9SXJ7', '154563949585100004', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('rhfuN2ZrEcphwah0vFv', '0Q0LkJpfR1ejtO8rD3p', null, '1fhgTUPecMY0ajlTkKZ', '0', 'juwrHEhNEXIqxCUqQuz', '155168789401500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('rhISK3EAHD30nTbBo4C', '0Q0LkJpfR1ejtO8rD3p', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'f9GQrsfu9GKGRqKKPgi', '155168789470200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('RHmSkHE8IjD679Rknpx', 'jkpTHKg7DpuXQrppVxx', null, '4mlBSmLGlzULUWJe8Nu', '1', '4mlBSmLGlzULUWJe8Nu', '155142353081500003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Rhr7Bv8SFW2ZsqCBkdR', '3tFw1boS5L9vXoJCr6Z', null, 'KR5pPS7kOi82d8Wrkc5', '0', 'gjODjQxJPXgqqCaNMY7', '154563949525700005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('rHvLeXgwW5ycDptZ65x', '0Q0LkJpfR1ejtO8rD3p', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'weZ9Sz2X5RBVBRpCdJM', '155168789478000001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('ri9DlE3z70LdcJtjwwD', 'kPLbeydkgiYW6NIkCt0', null, '4wigakaNlnx6FakxlBQ', '2', '4wigakaNlnx6FakxlBQ', '155168804521100003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RiNqZQPLBfYdHV1i6K0', 'kPLbeydkgiYW6NIkCt0', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'RXwhTRAzZSqsUpQc1NF', '155168804620900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('rIQa5oDPb6TmQUeqQZL', '2jSs6cnzu4mzY9C13vF', null, 'L7O7fkCLsVh7KYd0RIy', '1', 'L7O7fkCLsVh7KYd0RIy', '155142339876100004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('RiVgETPkVAX94veDqI8', 'kPLbeydkgiYW6NIkCt0', null, 'qqHbF4LC1qdUg1ak29k', '1', 'vdYEg1wdkIfHULE2LzN', '155168804549200000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('rJCd05GKqhLy768rngq', '2ytUeoxBqghwofmBALl', null, 'rfmGjP7LXiQfxy15izp', '1', '5RmGeLAjzOblugQN5jG', '154461618905400000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('rjds8cGFIUGlsVP5yJu', 'kPLbeydkgiYW6NIkCt0', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'ZLGOtOxZGBCsfXYeK15', '155168804608500005', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('RJIcpdPRXIJnly6XcSP', '2ytUeoxBqghwofmBALl', null, 'gniImP2ug7E82S1WO0L', '1', 'gniImP2ug7E82S1WO0L', '154461618889800001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('RjnJYc0niGcyYvQMzI9', '2ytUeoxBqghwofmBALl', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'cHPexySH1L6Pf3IyNTH', '154461619057000005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('rJvuM5wF608Pr1L9Q4h', '2jSs6cnzu4mzY9C13vF', null, 'tbfv6enk6DCV69XcIwq', '2', 'tbfv6enk6DCV69XcIwq', '155142339548500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RK1bXYWLtyvsvciWsIc', 'WB81MbCBolNg6XmE35M', null, '11e6-5534-a670333f-8350-a3b9b8447d61', '1', '11e6-5534-a670333f-8350-a3b9b8447d61', '155141105194200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('rkAlWcBen2h4jI8UbSp', 'kPLbeydkgiYW6NIkCt0', null, 'PbQMu46yyehblOGohri', '2', 'PbQMu46yyehblOGohri', '155168804486800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rklbxcMDE8xeM6M6nEg', '2ytUeoxBqghwofmBALl', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'SAYbUm9awyQJXoJpDNc', '154461619039800000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('RkOt3rv1QPUpZuINjFk', '3tFw1boS5L9vXoJCr6Z', null, 'TB1tzLM8yuJEkB6aQUk', '1', 'TB1tzLM8yuJEkB6aQUk', '154563949625700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('RkZr6EdiJQx3AJ2g4dd', '2jSs6cnzu4mzY9C13vF', null, '6BIvNJISOeZ3xm8S2aG', '1', '6BIvNJISOeZ3xm8S2aG', '155142339659200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('rLhajKXZjR8Ocsxr2CB', '2ytUeoxBqghwofmBALl', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'fkbqJ4vxJOUvHY59Lo6', '154461619130400003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('rlstXGGAZS9eqimlqia', '2ytUeoxBqghwofmBALl', null, 'kebFCC8mkGX3V1QEriK', '0', 'dsB4JOjIMnlpqITpAVO', '154461619146000003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('rM8gCZFdtBJl2pvF1G5', 'kPLbeydkgiYW6NIkCt0', null, 'ZM7F9MjjscP8bADF7cH', '1', 'ZM7F9MjjscP8bADF7cH', '155168804557000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('rMdSCaPjR3elNdTQzKN', '3tFw1boS5L9vXoJCr6Z', null, 'Z6pISvulUdsSz8bjuOV', '0', '7nN7s8EOZ6SjZc0tEMY', '154563949524100003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('rmEWJxRlxXewRcqkOnk', 'kPLbeydkgiYW6NIkCt0', null, 'Jbc2xwZhMLLNIjg0h02', '1', 'Jbc2xwZhMLLNIjg0h02', '155168804564800001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('RmiAKK7M1bM7yMZzWkK', '2jSs6cnzu4mzY9C13vF', null, 'AkuEixxtkMd7QuHLVOR', '2', 'AkuEixxtkMd7QuHLVOR', '155142339554700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rmNjtxhy5GVBD8zfCN0', 'kPLbeydkgiYW6NIkCt0', null, '98kmnnrWwGKmgyiIkUF', '0', 'erevZ9qTmGbUQpQWI61', '155168804571000005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('rMUQGPWvC5ByAzP4kog', 'kPLbeydkgiYW6NIkCt0', null, 'JdWD8biOlCXjkEvrwMm', '0', 'MRVrK6Uj6Z6imY0qwYm', '155168804645900004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('rn3hIbiRuddma0f90q3', '2ytUeoxBqghwofmBALl', null, 'e6OXY8vDBhwyntKTBcc', '1', 'e6OXY8vDBhwyntKTBcc', '154461619142900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('RnfQX6Ml4dBmg4C0ZTr', '3tFw1boS5L9vXoJCr6Z', null, 'd1anhG9lkXM7xOEL0p0', '1', 'd1anhG9lkXM7xOEL0p0', '154563949508500002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('rnTxYeQrIhKUrv3exqj', '2ytUeoxBqghwofmBALl', null, 'U1TygLjjsSxDfEoGwhc', '1', '6hT0k732Mz5j3yugFP1', '154461618928800001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('ROetxSK6gggxQFJny8y', '0Q0LkJpfR1ejtO8rD3p', null, '2F75ZJJXk8564FkCLYA', '1', 'G1Mxsr3SbNkCXsao7je', '155168789359400002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('ROkjd7UGGGChxFVkq04', '2jSs6cnzu4mzY9C13vF', null, '74xpaQX1peQaya80WFh', '2', '74xpaQX1peQaya80WFh', '155142339579700003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rp3YN2hjQaJIwxqEw0g', '3tFw1boS5L9vXoJCr6Z', null, '0zSRHMqiyMTl1dth7ds', '1', 'cn2gajGsHOgYLGZkWvG', '154563949496000005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('RPDbPj9Vat3XF4xSJvL', '0Q0LkJpfR1ejtO8rD3p', null, 'mNVKo7InVqtGMI8pWnS', '2', 'mNVKo7InVqtGMI8pWnS', '155168789318900004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RPMjlL0rebgOaAXxX7V', 'kPLbeydkgiYW6NIkCt0', null, '3sSURwczE2wMjgOqqOo', '0', 'xgvB9tVQZn0ZxoQMZ31', '155168804586600004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('rpNKm8fVzJJKi7Cccoq', 'WB81MbCBolNg6XmE35M', null, '11e6-54a7-2bd353aa-9671-379f935a9949', '1', '11e6-d160-5819a50f-bbdd-9f7a0eebced4', '155141105105300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('rqnnneLNGyUNb5xDAMX', '0Q0LkJpfR1ejtO8rD3p', null, 'SiPTeSpUhRIqVgi1HW1', '0', 'LI7k2GDTP5VDdaobmtO', '155168789421800003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('RQu0tiTZcGZ8wCN0WRP', '0Q0LkJpfR1ejtO8rD3p', null, 'c8qqHIRjZCxEMPx5YoO', '1', 'c8qqHIRjZCxEMPx5YoO', '155168789429600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('rqUYvVRpmqCxEb93EAr', '3tFw1boS5L9vXoJCr6Z', null, 'vCWvTbPligxwrkrwAv8', '0', 'akF0OOm8JnnvHsDhrLQ', '154563949622600000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('RqYFdDd6ZWTIv8hFTqe', 'jkpTHKg7DpuXQrppVxx', null, 'XAQy4mQfPb9hnyOISK1', '0', 'jekyDtY4Gsod5cEuiVD', '155142353076800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('RR4nyhCDIO3q1UL7VCv', 'kPLbeydkgiYW6NIkCt0', null, '4mTMb4cMMoLDRa0FTzS', '2', '4mTMb4cMMoLDRa0FTzS', '155168804471200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RrdcCA5JmdaRKRrwAPL', '2ytUeoxBqghwofmBALl', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K4IeXTdrXu7wZa0AkpH', '154461618961700003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('RrrsHgkpa8tpn2vd7JW', 'kPLbeydkgiYW6NIkCt0', null, 'DwtZozROcOIsno6lTY3', '2', 'DwtZozROcOIsno6lTY3', '155168804488300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RStE6t9c6YJ6oXA2gNV', 'jkpTHKg7DpuXQrppVxx', null, '0n6dTFPWytWUOlO2aeq', '2', '0n6dTFPWytWUOlO2aeq', '155142352977000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rtu2rbDvHpjDXAYAHh7', 'kPLbeydkgiYW6NIkCt0', null, 'SV5pJA48sYTCJEWntbv', '0', '6jNKnfzqHTCVEbSfkF9', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单111', '3', '2');
INSERT INTO `t_permission` VALUES ('rufaRr9ext8LumVXCum', '0Q0LkJpfR1ejtO8rD3p', null, '6BIvNJISOeZ3xm8S2aG', '1', 't4hcTsCptGZ5kTWV2Ya', '155168789348500004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('rUhnCjz8vDM8zqHExgt', '3tFw1boS5L9vXoJCr6Z', null, 'x2qgUpE8u9jmGEWbbQm', '1', '1x0dmC76v20LfiQLJDC', '154563949574100005', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('rVdUNB1xMXIEqjbPY73', '2jSs6cnzu4mzY9C13vF', null, 'fu3FPAvy3QbJl8Y96P7', '1', '5oWWmwFfmt1UTNzYcO7', '155142339779400003', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('RvFquwULz6h6N0C2y4g', 'WB81MbCBolNg6XmE35M', null, '11e6-5ba8-1b0ba534-a270-539aa660c6fc', '2', '11e6-5ba8-1b0ba534-a270-539aa660c6fc', '155141104777700002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RVKUrx0wa4wezw17Pa1', 'jkpTHKg7DpuXQrppVxx', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'AiibIdUU3zQiGsrKDXn', '155142353161100001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Rvy1C760ar8i8Z7veJV', '2jSs6cnzu4mzY9C13vF', null, 'Qi632udYFiwUydksuYy', '2', 'Qi632udYFiwUydksuYy', '155142339624900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rvYLKjxUx38RmpdEHFI', '2ytUeoxBqghwofmBALl', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'wuWQttnDBKAz7kQ2UMs', '154461619144500000', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('RWaPgxPIeAIkyuHIjo3', '2jSs6cnzu4mzY9C13vF', null, 'XpNoNSLR8vialNcJDXq', '0', 'DDOwg7IIyIziyaozQTN', '155142339804300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('RWGVP9cQXQFjMzsoEzD', 'kPLbeydkgiYW6NIkCt0', null, 'HsCxJxVzSoMOXQotkMK', '1', 'HsCxJxVzSoMOXQotkMK', '155168804656800001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('RwP20b1sI8et4p7laaq', '2jSs6cnzu4mzY9C13vF', null, 'KQSVH3r5JbmIAoPEf1R', '0', 'K4Z97NLTLZ952TInMrM', '155142339765300004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('rWryaSlsqXVZyGTdJ6f', '0Q0LkJpfR1ejtO8rD3p', null, 'ty5ziZz2nDWVO0jHM22', '2', 'ty5ziZz2nDWVO0jHM22', '155168789336000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('RXHHjOhWFK9jRHr2rY5', '3tFw1boS5L9vXoJCr6Z', null, 'WOmzvkui5ZsoZu1CogR', '1', 'i12huWXbQz9KJExHc6D', '154563949555400000', 'HdPeBqYwJyFyjHkhZu3', '文件下载(路径脚本需完善)', '26', '1');
INSERT INTO `t_permission` VALUES ('Rxpb1pSKkVlp56iol9f', '2jSs6cnzu4mzY9C13vF', null, 'iL3YpikkZUlruc5ai3D', '1', '2HH7snENERzvRumcFTa', '155142339663900001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('rXrjpOaz0AiNNOc2bg7', '3tFw1boS5L9vXoJCr6Z', null, 'yDZaeD0mt44iNjakHmE', '0', 'mYv5iZiU0TwoK4MWL6v', '154563949539800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ry0Vu0hnYhAWPbQjdbc', '2ytUeoxBqghwofmBALl', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'jlpTpnbZ03B6oqSeFmM', '154461618883500000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('RYcx4J8VmLEp95RCgO6', '3tFw1boS5L9vXoJCr6Z', null, 'd1anhG9lkXM7xOEL0p0', '1', '54Ke6lqQKZqsRiIAuzU', '154563949508500003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('RyebpDNGNwqdZAdg6W6', 'WB81MbCBolNg6XmE35M', null, '11e5-9272-11dcad2f-9db1-913f1ac2a256', '1', '11e5-9272-11dcad2f-9db1-913f1ac2a256', '155141104865100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('rYfHJW6LMCoVm0saiVD', '2ytUeoxBqghwofmBALl', null, 'g7U0PGtN5bKYhwbka6s', '0', 'VXaTIyUn85r0Xf2ja64', '154461619000700003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('RYnpwglVK9Uyu64RyD5', 'jkpTHKg7DpuXQrppVxx', null, 'bKWrnsYGUGaqqYqkeeO', '0', 'eKS6W5ObdgLXuBIKcJP', '155142353168900003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('rYOWJQxjyMvkCtUiT9V', 'kPLbeydkgiYW6NIkCt0', null, 'a2ZyD3z0DqPxaNXX6Zx', '0', 'XUVXBLmXG3ryVuGQfA9', '155168804580400004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('RyPPAKqOahsxLsVI8Ih', 'WB81MbCBolNg6XmE35M', null, '11e6-54b3-01603448-9671-379f935a9949', '1', '11e6-54b3-01603448-9671-379f935a9949', '155141104902500004', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ryUnCWodfe30LguOlQw', 'kPLbeydkgiYW6NIkCt0', null, '7q6BJWxhJzTuAFZpxa8', '2', '7q6BJWxhJzTuAFZpxa8', '155168804466500006', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rZ1YlCoYXL46oGaZ3z5', '2ytUeoxBqghwofmBALl', null, 'NGN4SO4fu5S5XxULG4X', '1', 'OH7Z3LEcqPhif8kJKhi', '154461618927300002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('rZ5z4TFkkpSyiSvyAjt', '0Q0LkJpfR1ejtO8rD3p', null, 'a7jp1Dm53YjlAwDWuws', '1', 'a7jp1Dm53YjlAwDWuws', '155168789406200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('RZ6RfgxZRMiMP1Uy7Lq', '3tFw1boS5L9vXoJCr6Z', null, 's8vMWH9Nh6oZ3Fa6D2K', '0', 'VMAbFQIQDDpyST1AhyZ', '154563949621000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('rzamioBAV0UAurfJH03', '0Q0LkJpfR1ejtO8rD3p', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'MiEVpwvQ9yx8Zb5c2bR', '155168789375000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('rzEKyMo89KasugH9PrJ', 'kPLbeydkgiYW6NIkCt0', null, 'vDsnTykdPOblfwEF4mR', '1', 'I7O5wArbJ75dWvyv3oX', '155168804655300000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('rziQuJtPCEqak2nRde7', 'kPLbeydkgiYW6NIkCt0', null, 'j4ncSyWthzCYoNj3n4J', '0', 'KVWnOmmml6Kwm3w1RPe', '155168804619400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('RZsQNj9mtDCyBeM3E0x', 'jkpTHKg7DpuXQrppVxx', null, '4RJ5cYekBtB1RdNDxL3', '1', '4RJ5cYekBtB1RdNDxL3', '155142353080000004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('RzwANaT0Swcd87HYAuM', 'jkpTHKg7DpuXQrppVxx', null, 'Ta56UCfylnpmF0NhOQW', '2', 'Ta56UCfylnpmF0NhOQW', '155142352980100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('rZZuOo5SubVUdbm5gL8', 'WB81MbCBolNg6XmE35M', null, '11e6-54b1-282867bf-9671-379f935a9949', '1', '11e6-54b2-63e03a4c-9671-379f935a9949', '155141104929000001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('s06mQ5dDqu5MOqaWxxK', '2jSs6cnzu4mzY9C13vF', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'SospNqkq0w4oZqt8HNv', '155142339865200003', 'HdPeBqYwJyFyjHkhZu3', '只读按钮', '3', '1');
INSERT INTO `t_permission` VALUES ('s2blvmxKSI4I4QleJUQ', '2ytUeoxBqghwofmBALl', null, 'bKWrnsYGUGaqqYqkeeO', '0', 'eKS6W5ObdgLXuBIKcJP', '154461619149200003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('s2CFAhugZ3pf0O5XIeS', 'kPLbeydkgiYW6NIkCt0', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'JAAon6tsqZ7pmxzP2fn', '155168804641200000', 'HdPeBqYwJyFyjHkhZu3', '批量签章', '29', '1');
INSERT INTO `t_permission` VALUES ('s2IFaDVEKMLsj0YSotD', 'kPLbeydkgiYW6NIkCt0', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'PTTHSwtvw3HyoyAo3JB', '155168804631900003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('S2sX10HPVA6QVneRDCN', 'WB81MbCBolNg6XmE35M', null, '11e6-5303-7920361b-a13d-c75d0a89256c', '1', '11e6-5303-7920361b-a13d-c75d0a89256c', '155141104883800000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('S2yLHDHCluejOJqgjc4', '3tFw1boS5L9vXoJCr6Z', null, 'L7O7fkCLsVh7KYd0RIy', '1', 'L7O7fkCLsVh7KYd0RIy', '154563949614800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('S3WdoByjiX0E0B2njWB', 'kPLbeydkgiYW6NIkCt0', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'HsJKTUvE0PpgpJ9EXSw', '155168804659900002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('s3YyeEomf9I3ZGUttCK', '2jSs6cnzu4mzY9C13vF', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'Iw7PqAhVcFRVUHnbbwR', '155142339819900000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('s4HDGWXdYKpdhR6xtnP', '2jSs6cnzu4mzY9C13vF', null, 'DH7Zen0eWUXbjpOEAKb', '2', 'DH7Zen0eWUXbjpOEAKb', '155142339576600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('S4TeyQNeYGJUUvdP8wt', '2jSs6cnzu4mzY9C13vF', null, 'smthlnru9z9qwavJKk1', '0', 'AHJzoQDdLpyRpZLTTdK', '155142339899500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('s4uKRKoL1MVffqYXZhy', '2jSs6cnzu4mzY9C13vF', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'f9GQrsfu9GKGRqKKPgi', '155142339871400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('s4ut7fISBYNlTo1Gchz', 'jkpTHKg7DpuXQrppVxx', null, '2F75ZJJXk8564FkCLYA', '1', 'G1Mxsr3SbNkCXsao7je', '155142353028500004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('s4v5fOE9fJaX7GJaEt2', 'WB81MbCBolNg6XmE35M', null, '11e6-561a-c7c2a760-91c5-cd8abd28b1f9', '2', '11e6-561a-c7c2a760-91c5-cd8abd28b1f9', '155141104763700002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('S58dHwjRXnZmiNjj2cJ', 'kPLbeydkgiYW6NIkCt0', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'eIRDEeewznXKf3ktljY', '155168804594400003', 'HdPeBqYwJyFyjHkhZu3', '跳转', '43', '1');
INSERT INTO `t_permission` VALUES ('s5Fanarr43ngyy46cKl', '0Q0LkJpfR1ejtO8rD3p', null, '4VkP5W8VPlERMiThvSD', '0', 'SOe9OaDTLOE1domxYKV', '155168789417100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('S5kkLqVh9nxJi8OJPBM', '2jSs6cnzu4mzY9C13vF', null, 'NGN4SO4fu5S5XxULG4X', '1', '3obNdvpJGlYwLE4U916', '155142339640500002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('S5lX1mVrtaAUuUgzXUQ', 'jkpTHKg7DpuXQrppVxx', null, 'e6OXY8vDBhwyntKTBcc', '1', 'e6OXY8vDBhwyntKTBcc', '155142353159500003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('S79VM3WrmWlmoaem9SO', '0Q0LkJpfR1ejtO8rD3p', null, 'RGSlfhmaWRtgtaWUhTU', '2', 'RGSlfhmaWRtgtaWUhTU', '155168789300100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('s7dgu5dmotncV9Oby3U', '0Q0LkJpfR1ejtO8rD3p', null, '5rcVntJVt1P8847Jpus', '2', '5rcVntJVt1P8847Jpus', '155168789329800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('S9kX9TAm2OWk574I52Q', '0Q0LkJpfR1ejtO8rD3p', null, '5RzsvfgAUx2y0k1pDlg', '0', 'NgNicpt0mPuprqEMquB', '155168789485800003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('SA33HFkv6WIt8vgkDQu', '2jSs6cnzu4mzY9C13vF', null, 'gniImP2ug7E82S1WO0L', '1', 'A9ZVOiaJCjFUhFQkG6X', '155142339826200001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('SaKnrfO1UkOdeqSKTfD', '2ytUeoxBqghwofmBALl', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'czdV0c3QJMI2AZPkQZ6', '154461619102300002', 'HdPeBqYwJyFyjHkhZu3', '新建（绿色）', '2', '1');
INSERT INTO `t_permission` VALUES ('Saueywpb4UDmDHMMBXt', 'kPLbeydkgiYW6NIkCt0', null, 'hP9KCze8ACTb6Z4BWVV', '2', 'hP9KCze8ACTb6Z4BWVV', '155168804496100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SAxFsz2CGqB7F4cG2u5', 'kPLbeydkgiYW6NIkCt0', null, 'tXSz1JBmnuwUf1VB2vL', '2', 'tXSz1JBmnuwUf1VB2vL', '155168804477400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Sb4RTZ2rHVdc8ar1s0B', '3tFw1boS5L9vXoJCr6Z', null, '4oavihvP4J8cXDsWDIP', '0', 'pwDWlADlB4vGrKVGIQc', '154563949580400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Sb5hcTYQZYeXxzuocQa', '2ytUeoxBqghwofmBALl', null, 'PJKPR9GEIOqDfGNsFm3', '0', 'TFCrC5zb0w6fDoq6icl', '154461619019500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('SbrcTD7FRJePmymNWee', '2ytUeoxBqghwofmBALl', null, 'WOmzvkui5ZsoZu1CogR', '1', 'yJFj2Hn06m1lkC7swux', '154461619041300002', 'HdPeBqYwJyFyjHkhZu3', '通过邮件或短信通知', '37', '1');
INSERT INTO `t_permission` VALUES ('SCKMjhJIqaWZ2MBkCKp', '2ytUeoxBqghwofmBALl', null, 'j3y8CHrsMwRmnPJz7EW', '1', 'j3y8CHrsMwRmnPJz7EW', '154461618910100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ScPitMbeeGKjsKWcd8a', 'WB81MbCBolNg6XmE35M', null, '11e6-5610-cf71dcfa-91c5-cd8abd28b1f9', '2', '11e6-5610-cf71dcfa-91c5-cd8abd28b1f9', '155141104779300004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('ScQy70JQzs1yLlS5iFA', 'jkpTHKg7DpuXQrppVxx', null, 'LdUkdpc3EVM9iBygFMr', '0', 'cS0647Al36GrYYVT25b', '155142353095600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ScuiKUhNfDQtGYzfsGE', 'jkpTHKg7DpuXQrppVxx', null, 'KQSVH3r5JbmIAoPEf1R', '0', 'K4Z97NLTLZ952TInMrM', '155142353078400004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('sCurgN7iNPNmiftr6I9', '2ytUeoxBqghwofmBALl', null, 'CuDZkkf1DSaMf5ST7bj', '1', 'CuDZkkf1DSaMf5ST7bj', '154461618839800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('SD8Lrg8mwdupMWVrac3', 'WB81MbCBolNg6XmE35M', null, '11e6-55fc-eef7de0c-bb59-b7243d4bcf51', '1', '11e6-55fc-eef7de0c-bb59-b7243d4bcf51', '155141104988300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('sdLojaTwoXPy7ZFpaWo', '0Q0LkJpfR1ejtO8rD3p', null, 'gniImP2ug7E82S1WO0L', '1', '2GBc0jCYf23ydklhe3I', '155168789448300001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('SDuMESw3LbDp3ddkI70', '3tFw1boS5L9vXoJCr6Z', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'CjR2ngF0kCrKnCpD0rj', '154563949502300006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('sdwv7zdJnZ9QuUbdI1N', 'kPLbeydkgiYW6NIkCt0', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'f1qYzMAqsF7bNYJc4Xl', '155168804547600003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('se3mDwEjD8P1IcU0Fv5', 'jkpTHKg7DpuXQrppVxx', null, 'EGz4qs5QI4fsCuCJwdc', '2', 'EGz4qs5QI4fsCuCJwdc', '155142353000400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SECExcRlLXSmI3c2SYz', '3tFw1boS5L9vXoJCr6Z', null, 'pyZGNS3zwQ5ravJoqyj', '2', 'pyZGNS3zwQ5ravJoqyj', '154563949446000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SEeFjbdMX7gcoKOhhfW', 'jkpTHKg7DpuXQrppVxx', null, 'bVLnHAUMhdToxosd7nT', '0', 'zNyhoGxQwFdm43lTvgK', '155142353072200003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('SfZsQFIYdBSBNIqtFtI', 'kPLbeydkgiYW6NIkCt0', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'JyfgeJsIiLDXbY9SXJ7', '155168804622500000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('sGE4ePXNQIZDlTcMYBr', '3tFw1boS5L9vXoJCr6Z', null, 'oeLOJO0f3CC02OjOOIC', '0', '6onRFmzn8mrnGdrnIJy', '154563949525700003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('SgGbQCB138MRrDspjGJ', 'jkpTHKg7DpuXQrppVxx', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'APxRfhpMtHJp5vsjIIa', '155142353073700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('sGjxeG6FjE7sfShmXiV', '3tFw1boS5L9vXoJCr6Z', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '154563949439800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('sGlFyM6JWPmDVOLpGqc', '2jSs6cnzu4mzY9C13vF', null, 'OGMmff1QTZYqFk5vfeD', '1', 'OGMmff1QTZYqFk5vfeD', '155142339637400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('SGygf5wjmdYw278xNHd', 'WB81MbCBolNg6XmE35M', null, '11e6-5491-50c5cc93-9671-379f935a9949', '1', '11e6-5493-5475f11a-9671-379f935a9949', '155141105088100002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('SH1kcoVTpuwEUPnK1XA', 'jkpTHKg7DpuXQrppVxx', null, 'eLFjqFngRQrIkbsdeBd', '1', 'laHgljUkGTSlRpd6Sbl', '155142353147000001', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('shexcv6C1bUmpJMLOO6', '3tFw1boS5L9vXoJCr6Z', null, '1QioSPqczT1xRrQBliu', '0', 'HxoUk6HtGOsbmINNEDW', '154563949522600003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('sHQRWNMkTeVA0aVS3q1', 'jkpTHKg7DpuXQrppVxx', null, 'RwMAY2iXBOjVaNZzkcE', '2', 'RwMAY2iXBOjVaNZzkcE', '155142352981700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('si1taVJzZGbA30wuRk0', 'jkpTHKg7DpuXQrppVxx', null, '6BIvNJISOeZ3xm8S2aG', '1', 'gZXQSMJKQTAqYMBYWXE', '155142353020700004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('sIikPrM4p6XxHcM6oCe', '3tFw1boS5L9vXoJCr6Z', null, 'xBX9EbJkveiSGJm9xRj', '0', 'hkNKtk1zbGkFX0hZFT9', '154563949524100001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('SIKUTW06K9p4NdZPSIJ', '3tFw1boS5L9vXoJCr6Z', null, 'WOmzvkui5ZsoZu1CogR', '1', 'YTpVlB2kK9hmipw8HMw', '154563949553800000', 'HdPeBqYwJyFyjHkhZu3', '自定义打印', '30', '1');
INSERT INTO `t_permission` VALUES ('SJ0nteG71nmEowBNNcj', '2jSs6cnzu4mzY9C13vF', null, 'L5GM913NGCFMkNWSZ8A', '0', 'l8GWni0miSZsKhx4FGB', '155142339756000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('sj3R4jFrdSoef8HqgtA', '0Q0LkJpfR1ejtO8rD3p', null, 'Q70cP6OyQI3YDJ10sz9', '2', 'Q70cP6OyQI3YDJ10sz9', '155168789314200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('sJaOqqz19c3m6LiXUL4', 'kPLbeydkgiYW6NIkCt0', null, 'F0SEYWEOMkZjQU2f0R1', '2', 'F0SEYWEOMkZjQU2f0R1', '155168804514900002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SJIpCOqOPZYrNc4Hnna', '3tFw1boS5L9vXoJCr6Z', null, 'bIBjrPWlkEMkXKe7cPi', '2', 'bIBjrPWlkEMkXKe7cPi', '154563949475700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SjLVfr431DL9DaLRt8N', 'kPLbeydkgiYW6NIkCt0', null, 'XAQy4mQfPb9hnyOISK1', '0', 'jekyDtY4Gsod5cEuiVD', '155168804585100003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('SjpiPcmVjpUngIfcLln', '2jSs6cnzu4mzY9C13vF', null, '0zSRHMqiyMTl1dth7ds', '1', 'hy32XOXaddLpvsHlLeY', '155142339678000000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('SjtlWHLjeLA6tROsnME', '2jSs6cnzu4mzY9C13vF', null, 'IuPDe4Gm9occzflnrP0', '0', 'dSSZNfrsXOVhXvx7vOM', '155142339866700002', 'HdPeBqYwJyFyjHkhZu3', '页签打开', '43', '1');
INSERT INTO `t_permission` VALUES ('SK0Vvru58Y5jEqWal4f', '3tFw1boS5L9vXoJCr6Z', null, '5rcVntJVt1P8847Jpus', '2', '5rcVntJVt1P8847Jpus', '154563949471000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('sKcIoRurMcaRBjk6Kgb', '3tFw1boS5L9vXoJCr6Z', null, '2F75ZJJXk8564FkCLYA', '1', 'elMcFSK0gGbaGWSt2pH', '154563949497600004', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('SkRgBe0p6IezOKCoI5e', '0Q0LkJpfR1ejtO8rD3p', null, 'mXDUC8go52mfA91GY0r', '0', 'P2oUhWPVibevLu0mKhp', '155168789468600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('sKTrMMNqxkgy4lnGqoh', 'kPLbeydkgiYW6NIkCt0', null, 'sbkS067uQ9jIwpB6qWd', '2', 'sbkS067uQ9jIwpB6qWd', '155168804468100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('sKwLTEFqF661IBZ1CSy', '2ytUeoxBqghwofmBALl', null, 'Z6pISvulUdsSz8bjuOV', '0', '7nN7s8EOZ6SjZc0tEMY', '154461619011700002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('sL7GulxS3dIoa4QH9pK', '0Q0LkJpfR1ejtO8rD3p', null, 'eLFjqFngRQrIkbsdeBd', '1', 'eLFjqFngRQrIkbsdeBd', '155168789474900002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('SLLQ79DWy0wZR1QMPWm', '0Q0LkJpfR1ejtO8rD3p', null, 'w7IsSOtXFvo61cP8sKr', '1', 'tdpqhqKdJ6wj3toLl5M', '155168789410900002', 'HdPeBqYwJyFyjHkhZu3', '打印包含流程历史', '15', '1');
INSERT INTO `t_permission` VALUES ('SMe6VfZ4TU1zd9tUjYI', '2jSs6cnzu4mzY9C13vF', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'KWyhjGMdOzdszl2VD2Q', '155142339896400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('SmMcmkFVOpQeSUIRKzY', '2ytUeoxBqghwofmBALl', null, 'U945OMsdX9fvzRjE7xG', '0', 'NNovnd63EkWs6jGCQgq', '154461618999200005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('SMMk6YmCYDsmXbz5ska', 'kPLbeydkgiYW6NIkCt0', null, '2F75ZJJXk8564FkCLYA', '1', 'elMcFSK0gGbaGWSt2pH', '155168804552300005', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('sMW1bbfNft2bEYSMBMe', '2ytUeoxBqghwofmBALl', null, 'NLGiWBICUXkTNWcaaD0', '1', 'NLGiWBICUXkTNWcaaD0', '154461618788200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('smxPCximrPuuhHZIrQ3', 'jkpTHKg7DpuXQrppVxx', null, 'J9uhQYSQWhPor4IvkOE', '0', 'KgFs9krHT2ZyBayTPo8', '155142353012900002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('SnI2AsxXwdw7LeQV4DL', 'kPLbeydkgiYW6NIkCt0', null, 'L5GM913NGCFMkNWSZ8A', '0', 'QicxhLOE9YigegItmGd', '155168804580400000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('sNJLJAC8GCWcVFFcezm', 'kPLbeydkgiYW6NIkCt0', null, 'SAzJx5AkUZOJRct29BH', '0', 'x3O0Ifcwe8BqX5uhms5', '155168804613100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('sNlJFwYjm2nfV4thUjm', 'kPLbeydkgiYW6NIkCt0', null, 'H4Obg0f1gqRhQW4pA1i', '0', 'q0Z8EN0fCmx3aqEcPgV', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单2', '2', '2');
INSERT INTO `t_permission` VALUES ('Snr4iJwjBOrlhWTrYEL', 'jkpTHKg7DpuXQrppVxx', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'eIRDEeewznXKf3ktljY', '155142353086200001', 'HdPeBqYwJyFyjHkhZu3', '跳转', '43', '1');
INSERT INTO `t_permission` VALUES ('snTThiQg1U6Ok1DIUzg', '2ytUeoxBqghwofmBALl', null, 'mXDUC8go52mfA91GY0r', '0', 'P2oUhWPVibevLu0mKhp', '154461618989800001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('SNVo4Cc5CrSqe215psf', 'WB81MbCBolNg6XmE35M', null, '11e6-5616-8e0d3cb1-91c5-cd8abd28b1f9', '2', '11e6-5616-8e0d3cb1-91c5-cd8abd28b1f9', '155141104762100003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SO8gelquv6bULdEowPE', '2jSs6cnzu4mzY9C13vF', null, 'rfmGjP7LXiQfxy15izp', '1', 'rfmGjP7LXiQfxy15izp', '155142339832400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('SoL0y5o6kvU7B6Hy5AH', '0Q0LkJpfR1ejtO8rD3p', null, 'd1anhG9lkXM7xOEL0p0', '1', '54Ke6lqQKZqsRiIAuzU', '155168789371900000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('sp2tiaFu9HhrBbuDXMJ', 'jkpTHKg7DpuXQrppVxx', null, 'aGwWScnt2f6X87bV5u9', '1', '4LdvPBnK70nLgMp5OzH', '155142353041000002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('spePbTa30VEmEZMreG4', 'kPLbeydkgiYW6NIkCt0', null, '9ppSV2PIKNhHCOwufvI', '0', 'Qbqk2LB86r3acRInIHN', '155168804636500002', 'HdPeBqYwJyFyjHkhZu3', '刷新', '1', '1');
INSERT INTO `t_permission` VALUES ('sPn0NlxaP4Glw2Pq1UX', '2ytUeoxBqghwofmBALl', null, 'MIExqx2MWO5cunDiuaX', '1', 'BjLpkwnLuJNx6aokoma', '154461618958500000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('SQ1IPaBjRTa6eUiXEr3', 'jkpTHKg7DpuXQrppVxx', null, 'Li1q0Dlwg6sZn4YFamQ', '2', 'Li1q0Dlwg6sZn4YFamQ', '155142352967600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SqpZLhw1EOzQ0E5m2FU', '3tFw1boS5L9vXoJCr6Z', null, 'F6reQ5BW7P6q236Pi13', '1', 'Okamal6erVlSp96ygxI', '154563949610100002', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('SR5qD5qGQoZHtJOu3qN', '3tFw1boS5L9vXoJCr6Z', null, 'vDsnTykdPOblfwEF4mR', '1', 'jVcLQaH4BiwznPvstCF', '154563949613200000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('SR7HF4lxN7gMHkStxql', 'WB81MbCBolNg6XmE35M', null, '11e6-5616-719c0c3f-91c5-cd8abd28b1f9', '2', '11e6-5616-719c0c3f-91c5-cd8abd28b1f9', '155141104762100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SRcLljYmltjk8amfvBT', '0Q0LkJpfR1ejtO8rD3p', null, 'fBeJCr5ipcIdScfuebs', '2', 'fBeJCr5ipcIdScfuebs', '155168789331300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('sRoDIV93cb6wD6go5dy', 'jkpTHKg7DpuXQrppVxx', null, 'qqHbF4LC1qdUg1ak29k', '1', 'qqHbF4LC1qdUg1ak29k', '155142353023800004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('sRy5mYpVkpvnkCNCiDR', 'kPLbeydkgiYW6NIkCt0', null, 'QgINfDEbj3rwSwaOJHg', '2', 'QgINfDEbj3rwSwaOJHg', '155168804513300004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SRZ9jYMMg58Fdj4iZ8j', 'jkpTHKg7DpuXQrppVxx', null, 'MIExqx2MWO5cunDiuaX', '1', 'MIExqx2MWO5cunDiuaX', '155142353036300001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('sS5h0DmGLhPRvC9YR0v', 'kPLbeydkgiYW6NIkCt0', null, '2F75ZJJXk8564FkCLYA', '1', 'aYBPeZTWDS1YHS4MWF5', '155168804552300003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('ss60hixc2Etk5q69JhW', '2jSs6cnzu4mzY9C13vF', null, '4RJ5cYekBtB1RdNDxL3', '1', '2WEniL1FLLpXKQfd5XU', '155142339771600001', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('ssa0zyPPV23sE08FBlV', 'WB81MbCBolNg6XmE35M', null, '11e6-55fe-4ea6ff8f-bb59-b7243d4bcf51', '1', '11e6-55fe-64313837-bb59-b7243d4bcf51', '155141105013300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('ssc6VlHjxOt1iHMJtpY', 'jkpTHKg7DpuXQrppVxx', null, 'WOmzvkui5ZsoZu1CogR', '1', 'yJFj2Hn06m1lkC7swux', '155142353087800000', 'HdPeBqYwJyFyjHkhZu3', '通过邮件或短信通知', '37', '1');
INSERT INTO `t_permission` VALUES ('ssI35vGpffiYSFG3scP', '3tFw1boS5L9vXoJCr6Z', null, 'PbQMu46yyehblOGohri', '2', 'PbQMu46yyehblOGohri', '154563949444500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SSjRUvDWJpPuJj2ew49', '2ytUeoxBqghwofmBALl', null, 'rfmGjP7LXiQfxy15izp', '1', '5RmGeLAjzOblugQN5jG', '154461619072600001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('SSl1PqTGHreBAGjLVs1', 'kPLbeydkgiYW6NIkCt0', null, 'BrbFcB3ptMyxdPl5W6u', '0', '6DhnKNo54979AgvQSGH', '155168804627200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('SsmPewbPFoJt6I4j0hz', 'kPLbeydkgiYW6NIkCt0', null, 'WOmzvkui5ZsoZu1CogR', '1', 'YTpVlB2kK9hmipw8HMw', '155168804596000001', 'HdPeBqYwJyFyjHkhZu3', '自定义打印', '30', '1');
INSERT INTO `t_permission` VALUES ('sSQn6RlFQs4ijHM3U0j', 'kPLbeydkgiYW6NIkCt0', null, 'w7IsSOtXFvo61cP8sKr', '1', 'bdnOlGNgir39pNIV5w3', '155168804592900003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('SsuMYpYDHdroaFly9W9', 'kPLbeydkgiYW6NIkCt0', null, 'IiXqyN1VoajtXmJTPKS', '2', 'IiXqyN1VoajtXmJTPKS', '155168804488300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('sT3awODA4Jpa6FQuIY2', '2ytUeoxBqghwofmBALl', null, 'vCWvTbPligxwrkrwAv8', '0', 'akF0OOm8JnnvHsDhrLQ', '154461619067900004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('sTQ5rgkUsTbO2u41uqX', 'kPLbeydkgiYW6NIkCt0', null, '6bUPlXeVH92MIv7Nmdw', '1', '6bUPlXeVH92MIv7Nmdw', '155168804549200003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('STRotEHgTJF83BMYM7Q', '2ytUeoxBqghwofmBALl', null, '1QioSPqczT1xRrQBliu', '0', 'HxoUk6HtGOsbmINNEDW', '154461619007000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('StsTcisjrAKpvMmACz8', '2ytUeoxBqghwofmBALl', null, 'U1TygLjjsSxDfEoGwhc', '1', 'ih9o5BJcd9TxtaItt0i', '154461618928800000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('StX9aLOh2YfqPYo077v', '2ytUeoxBqghwofmBALl', null, 'NaZcYrbGaXxrTGcsd2M', '1', 'NaZcYrbGaXxrTGcsd2M', '154461619089800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('StxEXWjSDdPymhQHaMs', '3tFw1boS5L9vXoJCr6Z', null, 'poalxIjVlN70WdVjfQq', '1', 'poalxIjVlN70WdVjfQq', '154563949632000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('SUeCEykHjX3sBCCyRTE', '2jSs6cnzu4mzY9C13vF', null, 'TB1tzLM8yuJEkB6aQUk', '1', 'TB1tzLM8yuJEkB6aQUk', '155142339891700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('SUglU72fKOFslFJMQ1N', '0Q0LkJpfR1ejtO8rD3p', null, 'F6reQ5BW7P6q236Pi13', '1', 'F6reQ5BW7P6q236Pi13', '155168789470200005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('SuH1Nwt3Zh1jpDlXv8z', '3tFw1boS5L9vXoJCr6Z', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'QXO7cxkzLZ51qdiKBrI', '154563949622600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('SuintQHa7lrcy8vAPV4', 'WB81MbCBolNg6XmE35M', null, '11e6-5467-f56e4cca-9671-379f935a9949', '1', '11e6-5ab8-9db3b0dc-a841-31f95f893f0b', '155141104963300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('sUZKI9xD2ycrVy1ikQn', 'jkpTHKg7DpuXQrppVxx', null, 'Jh68ppMt3QMha315Hi6', '0', 'ePkoYYvvztlUvkHqa16', '155142353062800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('svOgLNAF3UjnHpEI0XL', '0Q0LkJpfR1ejtO8rD3p', null, 'gPHUIa48Bpsz26fjjNA', '2', 'gPHUIa48Bpsz26fjjNA', '155168789317300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SVV44LWnASRaXv4Fwph', 'kPLbeydkgiYW6NIkCt0', null, 'm8moRuOLRGU8fSbCIty', '0', 'Z6h9QsC5gMpu1hmPip2', '155168804533600002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('svZQhwmvzhtFotYMRqa', '3tFw1boS5L9vXoJCr6Z', null, '9ppSV2PIKNhHCOwufvI', '0', 'Qbqk2LB86r3acRInIHN', '154563949597600000', 'HdPeBqYwJyFyjHkhZu3', '刷新', '1', '1');
INSERT INTO `t_permission` VALUES ('swddYgHnYml8JEUoMOZ', 'jkpTHKg7DpuXQrppVxx', null, 'ECNTZk993cE71dxVqsx', '2', 'ECNTZk993cE71dxVqsx', '155142352984800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('sWn570yVzDUVtHlbuTh', '2ytUeoxBqghwofmBALl', null, 'jYDgN5WH46paTNLcCqi', '0', 'MfAD53jYG4vMOBrhLRM', '154461619044500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('SwVCN6dMWFJkNULG583', 'WB81MbCBolNg6XmE35M', null, '11e6-5618-ef2c7240-91c5-cd8abd28b1f9', '2', '11e6-5618-ef2c7240-91c5-cd8abd28b1f9', '155141104755900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SxcPaFkscDUj42AnOkn', 'WB81MbCBolNg6XmE35M', null, '11e6-5e11-af9f0d23-ae15-3d6b584ebd70', '1', '11e6-5e11-c8d11788-ae15-3d6b584ebd70', '155141104993000001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('sxnCkYNmSPmaQVRczlg', 'jkpTHKg7DpuXQrppVxx', null, 'TB1tzLM8yuJEkB6aQUk', '1', 'TB1tzLM8yuJEkB6aQUk', '155142353159500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('sxtouoekbV1X9kjd1UU', '2ytUeoxBqghwofmBALl', null, '3fHReAsD0ZoQ8qeeGB8', '0', 'GWNOfrdfU2z2hYo2y6Q', '154461619044500005', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('Sy0WVCNZ8Z6jb6X3FWS', '3tFw1boS5L9vXoJCr6Z', null, 'ZM7F9MjjscP8bADF7cH', '1', 'ZM7F9MjjscP8bADF7cH', '154563949502300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Sy5egyJndGkNX3rZu6O', 'jkpTHKg7DpuXQrppVxx', null, 'TU5YGgO5fJs1QU3q3h6', '1', 'TU5YGgO5fJs1QU3q3h6', '155142353097100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('sY6X5LZGtJKCqrAVU8C', '2jSs6cnzu4mzY9C13vF', null, 'ty5ziZz2nDWVO0jHM22', '2', 'ty5ziZz2nDWVO0jHM22', '155142339626500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SyP8T6CmAc5ef6YGExN', 'jkpTHKg7DpuXQrppVxx', null, 'Dp0d6MuuCtsiTwqL6qe', '2', 'Dp0d6MuuCtsiTwqL6qe', '155142353002000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SyuQPtRjYsmZSGU9m0b', '2jSs6cnzu4mzY9C13vF', null, '4VkP5W8VPlERMiThvSD', '0', 'r8ONfNaqWuH1q18rKZk', '155142339782500000', 'HdPeBqYwJyFyjHkhZu3', 'excel导入', '27', '1');
INSERT INTO `t_permission` VALUES ('syxQitcRgLhiGh8z5QD', '2jSs6cnzu4mzY9C13vF', null, 'lAUkIpgQSIZqQyttrB4', '1', 'lAUkIpgQSIZqQyttrB4', '155142339717000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Sz2vgxWklkgRLWJUnHv', 'jkpTHKg7DpuXQrppVxx', null, 'oeLOJO0f3CC02OjOOIC', '0', 'Wvgpr80lY60tZ8EcoLc', '155142353070600005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('szAEFADPCKvs5saNcKP', 'kPLbeydkgiYW6NIkCt0', null, 'SV5pJA48sYTCJEWntbv', '0', 'SV5pJA48sYTCJEWntbv', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单111', '1032', '2');
INSERT INTO `t_permission` VALUES ('SzBftVt42IExkQaoQPI', '0Q0LkJpfR1ejtO8rD3p', null, 'zqGmDkZIRa4COpFVzTj', '1', 'xBzMYIFuvohJrsvZE5M', '155168789337600002', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('SZENqFvBr7fphaHDENp', '2ytUeoxBqghwofmBALl', null, 'XtaVH2y40O9zvIVALWj', '1', 'XtaVH2y40O9zvIVALWj', '154461618922600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('SzEQT4As4rwaa6oH217', '0Q0LkJpfR1ejtO8rD3p', null, 'f9GQrsfu9GKGRqKKPgi', '1', '3wblZ30SS7TkVHaoRy2', '155168789470200002', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('SZhU00hGjqtkEgqJcnW', '2jSs6cnzu4mzY9C13vF', null, 'OGMmff1QTZYqFk5vfeD', '1', 'KTmmfPfwuB4gGJuw9fD', '155142339637400001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('sZKErucqbMLgA9mcgIM', '2jSs6cnzu4mzY9C13vF', null, 'JdWD8biOlCXjkEvrwMm', '0', 'OLJQOfZpoAIKsZOpeqD', '155142339866700005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('szoP10HqdAK4NlyBYa1', 'jkpTHKg7DpuXQrppVxx', null, '6BIvNJISOeZ3xm8S2aG', '1', '4TEeGoSPUfMP6R1Dxgq', '155142353020700003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('SzSoYsXglHPfSSVjJKU', '2jSs6cnzu4mzY9C13vF', null, 'jwnvWbHVPeT86x5j2LF', '2', 'jwnvWbHVPeT86x5j2LF', '155142339609300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('SZz1s2nfrzov11qT0L8', '3tFw1boS5L9vXoJCr6Z', null, 'fVc4y8aYlKHvUPNHpUz', '2', 'fVc4y8aYlKHvUPNHpUz', '154563949447600004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('t0IxFy57ObRt0UvcYV3', '3tFw1boS5L9vXoJCr6Z', null, '9ppSV2PIKNhHCOwufvI', '0', '1vKJVgUjJInvLMSVXIn', '154563949596000003', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '36', '1');
INSERT INTO `t_permission` VALUES ('T0TvCgclH4RLdtxpqeU', '0Q0LkJpfR1ejtO8rD3p', null, 'bVLnHAUMhdToxosd7nT', '0', 'yzBBJOTOG9lvHIAigYN', '155168789395300003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('t12ESwBQS4kqR1WpDWD', 'kPLbeydkgiYW6NIkCt0', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'SospNqkq0w4oZqt8HNv', '155168804644300000', 'HdPeBqYwJyFyjHkhZu3', '只读按钮', '3', '1');
INSERT INTO `t_permission` VALUES ('T1MhMfD7j51XtHlUi6V', 'jkpTHKg7DpuXQrppVxx', null, '1hPCUYj6dx9rMn0NAlL', '2', '1hPCUYj6dx9rMn0NAlL', '155142352958300004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('T1UtGWq27Ycgjx9z7tw', '2ytUeoxBqghwofmBALl', null, 'kebFCC8mkGX3V1QEriK', '0', '2eoDuuIu6c2LNFTXHBl', '154461619100700002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('T1wPKhrCf6ZV1Z9m5dq', '0Q0LkJpfR1ejtO8rD3p', null, 'A6EMGp4mkUqLbMGLtql', '0', 'jvS3grY0lQM6HRUV78H', '155168789437400005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('t258QPDnlHLYt2zaodM', 'kPLbeydkgiYW6NIkCt0', null, '6BIvNJISOeZ3xm8S2aG', '1', '4TEeGoSPUfMP6R1Dxgq', '155168804546100000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('t2rzz9zELQJ8npZhwT9', '2jSs6cnzu4mzY9C13vF', null, 'PEBmSuAdvPujm2dfjAb', '2', 'PEBmSuAdvPujm2dfjAb', '155142339548500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('t4H7Jo88tK2tHDtB8vx', '0Q0LkJpfR1ejtO8rD3p', null, '9ppSV2PIKNhHCOwufvI', '0', 'OPN8L9J3OMzySIcqldf', '155168789462400002', 'HdPeBqYwJyFyjHkhZu3', '跳转', '1', '1');
INSERT INTO `t_permission` VALUES ('t55XCN48ihYjZLB71iy', 'kPLbeydkgiYW6NIkCt0', null, 'kA4m81roWetnkDQgWm0', '0', 'fc8oYpPYk2t3xyohWqx', '155168804569500004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('T5cWISkWd1tWPdJrJBD', '3tFw1boS5L9vXoJCr6Z', null, 'DzqlEtg4JObApV7iWX8', '0', 'YIzUW1O7NPBhfxLwHuj', '154563949538200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('t6EHniIYUv3Md5E65ri', 'jkpTHKg7DpuXQrppVxx', null, 'JmxxVKFmtiAV278992Z', '2', 'JmxxVKFmtiAV278992Z', '155142352980100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('t6J90xaGWFLb8Vkmxak', '0Q0LkJpfR1ejtO8rD3p', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'gjNDcP4lJlHlGCLsxRq', '155168789389100001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('t6NrzBVxuodqmgifyVn', '3tFw1boS5L9vXoJCr6Z', null, 'TqQZlnV3BVaRGCm4tXn', '1', '22ZvmpjYHg3LQFPOh01', '154563949489800001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('t6UES3muD7I4WNe1gCQ', '2ytUeoxBqghwofmBALl', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'f4NDOEOVMi7vrgWjzz4', '154461619033500001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('t7gEKDkv1K7Bm5GThUo', '2jSs6cnzu4mzY9C13vF', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'nGaEFBPrXgV7aN882KS', '155142339816800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('T7pwlGGpU6a238iY9FK', '3tFw1boS5L9vXoJCr6Z', null, 'rfmGjP7LXiQfxy15izp', '1', 'N1gohv56wfzjxXMkYXQ', '154563949583500000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('T9oL58gaeJj0th0UDPi', '0Q0LkJpfR1ejtO8rD3p', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'M2lLJBuu4yQUfthKi4F', '155168789407800004', 'HdPeBqYwJyFyjHkhZu3', '保存草稿', '19', '1');
INSERT INTO `t_permission` VALUES ('T9pwxNjWGtrsaen6XEx', 'jkpTHKg7DpuXQrppVxx', null, '1QioSPqczT1xRrQBliu', '0', 'HxoUk6HtGOsbmINNEDW', '155142353069000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('TAAPeKXMNuv41xJuvvn', '2ytUeoxBqghwofmBALl', null, 'EUJuOrIly3lBnwGTF7Q', '1', 'EUJuOrIly3lBnwGTF7Q', '154461619055400006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('tADTy5TCYSYkWB3pmnw', '2jSs6cnzu4mzY9C13vF', null, 'epn8IcdUN0afirW9qZ6', '2', 'epn8IcdUN0afirW9qZ6', '155142339617100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('tAL6zd1GzdulArk4qLu', '2jSs6cnzu4mzY9C13vF', null, 'iDzESIHQQFeI8FiDtGE', '2', 'iDzESIHQQFeI8FiDtGE', '155142339551600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('tAqh559HSKvqO32C6lk', '3tFw1boS5L9vXoJCr6Z', null, 'SiPTeSpUhRIqVgi1HW1', '0', 'LI7k2GDTP5VDdaobmtO', '154563949564800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('taxfYtsYk6QSXgE9fz6', '0Q0LkJpfR1ejtO8rD3p', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'Nmhce5xixb5FBPVv5dc', '155168789465500002', 'HdPeBqYwJyFyjHkhZu3', '此按钮不可见', '3', '1');
INSERT INTO `t_permission` VALUES ('tB7P8aaYXIjQwjXqkD6', 'kPLbeydkgiYW6NIkCt0', null, 'Ad9RS4RG7w9vkXmoKHG', '2', 'Ad9RS4RG7w9vkXmoKHG', '155168804475900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Tb8rrIzLYLsEqJJfRS1', '0Q0LkJpfR1ejtO8rD3p', null, 'rfmGjP7LXiQfxy15izp', '1', 'N1gohv56wfzjxXMkYXQ', '155168789449900003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('tBcyyfsukS0MyOCK3cp', 'jkpTHKg7DpuXQrppVxx', null, 'd1anhG9lkXM7xOEL0p0', '1', '54Ke6lqQKZqsRiIAuzU', '155142353042500001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('tc7o7305aAE71JAhv7B', '3tFw1boS5L9vXoJCr6Z', null, 'kcMdjikNe3R1UmNMZPB', '2', 'kcMdjikNe3R1UmNMZPB', '154563949477300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Tccq8vVhUeHhXDYetE7', 'WB81MbCBolNg6XmE35M', null, '11e6-5ee9-55debb99-b0f0-d3a532217234', '2', '11e6-5ee9-55debb99-b0f0-d3a532217234', '155141104760500001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TCSb358XM3Gqc3jkmVn', 'kPLbeydkgiYW6NIkCt0', null, 'ZzKElb4GrlkC6XD8mVD', '0', 'QaCafUFQYXRuzZZgMMP', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单21', '3', '2');
INSERT INTO `t_permission` VALUES ('tcSGoSYd4003qHBLKOf', 'kPLbeydkgiYW6NIkCt0', null, 'LgvvPpcCxScmiziQW7d', '2', 'LgvvPpcCxScmiziQW7d', '155168804497700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TCwLreTI8xc1uIWoinf', 'kPLbeydkgiYW6NIkCt0', null, 'oeLOJO0f3CC02OjOOIC', '0', 'Wvgpr80lY60tZ8EcoLc', '155168804578800004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('tCZ2SscqgFwixbYVB4j', 'kPLbeydkgiYW6NIkCt0', null, '4v5tmazbZwdNkJDYso5', '1', '4v5tmazbZwdNkJDYso5', '155168804667700003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('TD9xmOH1DyG5qiVG0pk', 'jkpTHKg7DpuXQrppVxx', null, '2FzVqBVCwr7uvFsl3Yo', '2', '2FzVqBVCwr7uvFsl3Yo', '155142352975400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('tda4dehcx7sy8TKtapR', '0Q0LkJpfR1ejtO8rD3p', null, 'b6g5bRV7zRXcD3xq6MS', '0', 'cY4kl4aBnqojbhnxddX', '155168789445200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('TdDDDIFbZ5P4vhWpnEX', '0Q0LkJpfR1ejtO8rD3p', null, 'gUlSUpqhlS2ym2ijZAg', '1', 'vVMfrqzsYfwhMJonU2y', '155168789357900000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('TDOQ8SVrYl8XJgwdAgB', 'WB81MbCBolNg6XmE35M', null, '11e6-55fd-e3a84011-bb59-b7243d4bcf51', '1', '11e6-55fe-06b0c19a-bb59-b7243d4bcf51', '155141105008600002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('tDwnnj9zpA07VTDdK8D', 'jkpTHKg7DpuXQrppVxx', null, 'KUp98gX4KG2acWUaepP', '2', 'KUp98gX4KG2acWUaepP', '155142352961400004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('tDwsqyQNm1sxWQ4PsP8', '3tFw1boS5L9vXoJCr6Z', null, 'IS48bOUKPFjCVejkBfd', '2', 'IS48bOUKPFjCVejkBfd', '154563949475700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Te2dFvfHPaMk6nQ0StT', '2jSs6cnzu4mzY9C13vF', null, '1fhgTUPecMY0ajlTkKZ', '0', 'juwrHEhNEXIqxCUqQuz', '155142339763800004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('tE2ZGHtYvMqrW1ChNLG', '3tFw1boS5L9vXoJCr6Z', null, 'g9mT8lUwK5R1aBCmTAC', '0', 'fW5mHIOMi7iJ4kftiPg', '154563949527300005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('te6Dj4ggaqLUrC96gdm', '0Q0LkJpfR1ejtO8rD3p', null, '06Me4ssjoGBiKz0gMK2', '0', 'ZEh1qpMCAgYe10KWd1j', '155168789478000003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('tEhN65Rkwh3SIyYQyKg', '3tFw1boS5L9vXoJCr6Z', null, 'XzgpTEte9Q1JQswSETz', '0', 'XLZiQKl894Jrpsbimx0', '154563949628800001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('TeJPi064CSjpzCSgRh0', '2ytUeoxBqghwofmBALl', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'cAu7pZ4IzsfytkdYNLM', '154461618936700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('TF1tg7n76ciqV2KNA0j', 'jkpTHKg7DpuXQrppVxx', null, 'MtITrUcx3REq45LskT3', '0', '7vuhrOZQxA5vCOL1Nkw', '155142353153300001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Tf5PdEnthKqj6YBDUkh', 'WB81MbCBolNg6XmE35M', null, '11e6-55fc-eef7de0c-bb59-b7243d4bcf51', '1', '11e6-55fd-904693a3-bb59-b7243d4bcf51', '155141104989900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('TfIrDMu4pdc4pKm8pcT', 'kPLbeydkgiYW6NIkCt0', null, 'lAUkIpgQSIZqQyttrB4', '1', 'lAUkIpgQSIZqQyttrB4', '155168804561700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('TFj4wI2zLEqxgFRwKyP', '0Q0LkJpfR1ejtO8rD3p', null, 'ZB7liHeZS7Qm0mlMz6b', '2', 'ZB7liHeZS7Qm0mlMz6b', '155168789325100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('tFkBUkkyc2WfvLkztd1', 'jkpTHKg7DpuXQrppVxx', null, 'F6reQ5BW7P6q236Pi13', '1', 'Okamal6erVlSp96ygxI', '155142353140800003', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('tfpz0XLBlqNLut6RrHt', '0Q0LkJpfR1ejtO8rD3p', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'PTTHSwtvw3HyoyAo3JB', '155168789459300002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('tfvsLEaHolR4DEm4Qzq', '2ytUeoxBqghwofmBALl', null, 'SO8LHb3jgAOBSXCiAjn', '0', 'QOJ06s8WUaokm0sdBKM', '154461618949200003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Tg3zZqBtvrRFoZY66f1', 'kPLbeydkgiYW6NIkCt0', null, 'XOjVSXTJxQ9WnTO8TmN', '1', 'XOjVSXTJxQ9WnTO8TmN', '155168804563200006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('tGJGJYBjK5sgsywZZRY', 'jkpTHKg7DpuXQrppVxx', null, 'vCWvTbPligxwrkrwAv8', '0', 'oyuPcAc1VAmt4JtNf7A', '155142353154800002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('tHwOzB6pxA9sl2IHt75', 'WB81MbCBolNg6XmE35M', null, '11e8-5779-e83c37fa-a079-2fb3fd4402df', '0', '11e8-5779-e83c3807-a079-2fb3fd4402df', '155141104855700001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('tiSCHjxygERdT5RLc1v', '0Q0LkJpfR1ejtO8rD3p', null, 'gUlSUpqhlS2ym2ijZAg', '1', '6vfobfgmvGLQuOe0b3s', '155168789356300001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Tj0RtuUmmG2dqsBciC7', 'jkpTHKg7DpuXQrppVxx', null, 'Q70cP6OyQI3YDJ10sz9', '2', 'Q70cP6OyQI3YDJ10sz9', '155142352973900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TJ7TeTOxPv1BtGPoKQA', 'WB81MbCBolNg6XmE35M', null, '11e6-5ba8-420de919-a270-539aa660c6fc', '2', '11e6-5ba8-420de919-a270-539aa660c6fc', '155141104776100003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('tjQNFCsjD602WYHM9En', '2jSs6cnzu4mzY9C13vF', null, 'zl3R26vYd12dQFRodMT', '2', 'zl3R26vYd12dQFRodMT', '155142339570300003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TJRmIRLy5SHBKzEJ1k2', '0Q0LkJpfR1ejtO8rD3p', null, '4VkP5W8VPlERMiThvSD', '0', 'DKXXNVp1SE3PrcD4Mq2', '155168789418700000', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '16', '1');
INSERT INTO `t_permission` VALUES ('TjslUWa2OCY5TgdKPen', 'kPLbeydkgiYW6NIkCt0', null, 'kYU5ffwtqGFdhsYDlG8', '2', 'kYU5ffwtqGFdhsYDlG8', '155168804469600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TJz49n8W0ACxueBOhvk', 'WB81MbCBolNg6XmE35M', null, '11e6-55fc-6817fa46-bb59-b7243d4bcf51', '1', '11e6-55fd-766b5051-bb59-b7243d4bcf51', '155141105017900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('tK24eDguLUBQWCmDW8B', '2ytUeoxBqghwofmBALl', null, 'm8moRuOLRGU8fSbCIty', '0', 'Z6h9QsC5gMpu1hmPip2', '154461618925700001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('TK7IahlFbf3iOlaZj2k', 'jkpTHKg7DpuXQrppVxx', null, 'bKWrnsYGUGaqqYqkeeO', '0', '23XpTvLhb5XEzINSZHU', '155142353170400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('TKUwC8ta7QhkDRc7eoq', 'jkpTHKg7DpuXQrppVxx', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'Iw7PqAhVcFRVUHnbbwR', '155142353106500005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('TKx14lFpb2ywqHECNBz', 'jkpTHKg7DpuXQrppVxx', null, 'a2ZyD3z0DqPxaNXX6Zx', '0', 'UcyIJcbxVT4vXhKlAIg', '155142353072200006', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('TlgKWboU8z1sI7MsdsO', 'kPLbeydkgiYW6NIkCt0', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'QXO7cxkzLZ51qdiKBrI', '155168804666200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('TMc0IRM1fq5mRB6YPU3', '0Q0LkJpfR1ejtO8rD3p', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'v5qY31shPwgs5BLkLlM', '155168789389100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('tMNHthOxc5A2ItkxCKM', 'WB81MbCBolNg6XmE35M', null, '11e6-55fe-10c18219-bb59-b7243d4bcf51', '0', '11e6-55fe-1e6b47d3-bb59-b7243d4bcf51', '155141105010100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('tmrK1wEUKyyIrIwDPkg', 'WB81MbCBolNg6XmE35M', null, '11e6-53a7-e48bf523-81f5-679a826556ce', '1', '11e6-53ad-ff5cacae-81f5-679a826556ce', '155141105186400002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('TN6R44UaxyriAVt5m5h', 'WB81MbCBolNg6XmE35M', null, '11e6-5610-b2f27bc8-91c5-cd8abd28b1f9', '2', '11e6-5610-b2f27bc8-91c5-cd8abd28b1f9', '155141104776100001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TN8FZcPMu95RDchSZpr', '0Q0LkJpfR1ejtO8rD3p', null, 'a7jp1Dm53YjlAwDWuws', '1', 'UFBBbyiSeV5fpFq1Apn', '155168789406200002', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('TneUTDnPWkA0Gm57zxy', 'jkpTHKg7DpuXQrppVxx', null, 'G1v3gcUQOvFAo7IH62c', '2', 'G1v3gcUQOvFAo7IH62c', '155142352964500006', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TnFORvtqepo2SEruY1o', '2jSs6cnzu4mzY9C13vF', null, 'ID88NPj17JbpAMGYh9J', '2', 'ID88NPj17JbpAMGYh9J', '155142339606200000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TnzJElJuhvWyg6mc2jW', '0Q0LkJpfR1ejtO8rD3p', null, 'zqGmDkZIRa4COpFVzTj', '1', 'GfV1N4DO1ZfVQGkI6Jz', '155168789337600003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('tofrV6TmPOIFlTI3ESR', '3tFw1boS5L9vXoJCr6Z', null, 'jYDgN5WH46paTNLcCqi', '0', '3Un6aJGRxrZKJu5VhVa', '154563949558500000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('TOHVjxAXOrCy1GNw8Xm', '3tFw1boS5L9vXoJCr6Z', null, 'TqQZlnV3BVaRGCm4tXn', '1', '7Cu3i9C1gOoAeAS2dAn', '154563949489800000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('TOqEWu4wS4cRYoIqCu3', '3tFw1boS5L9vXoJCr6Z', null, 'ddbeKTjs0WvqKVJ90MU', '1', '8S96fbM0hHIvN2tHSUq', '154563949500700002', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('torv242PE7YxZx34zer', '3tFw1boS5L9vXoJCr6Z', null, 'U1TygLjjsSxDfEoGwhc', '1', 'hdiqWVc1ZHENK9nuZv5', '154563949485100004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('tPCIb52M546AZWWlWDn', '2ytUeoxBqghwofmBALl', null, '6esIc2fTAI9nAOoOZcp', '1', 'y5AHygdKnFROYRFfQuX', '154461618947600004', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('tptAIH2JZOayAf1R9R9', 'jkpTHKg7DpuXQrppVxx', null, 'G0WtPO1mX58wd7tjkTy', '0', 'XIYtwtem4lZYZBYOfS5', '155142353092400001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('tpZlK5DcNnBx9Tr2x85', 'WB81MbCBolNg6XmE35M', null, '11e6-53c8-9cbf836c-81f5-679a826556ce', '1', '11e6-563c-abf9a5b3-91c5-cd8abd28b1f9', '155141104946200002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('TpZVnPCBILsWDeYmOrz', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-effac9b8-91c5-cd8abd28b1f9', '2', '11e6-5619-effac9b8-91c5-cd8abd28b1f9', '155141104768300002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('tQdFCpjFCnrZVFrZaf6', '2ytUeoxBqghwofmBALl', null, '3gGNzYyE5dK9ogZidWA', '1', 'HbDOYiiIBcC1oYN30Kx', '154461618922600001', 'HdPeBqYwJyFyjHkhZu3', '保存', '4', '1');
INSERT INTO `t_permission` VALUES ('tqnPxyUkPFX0kYnHUrO', 'kPLbeydkgiYW6NIkCt0', null, '7am5R9EPlSCV3gz3SZG', '2', '7am5R9EPlSCV3gz3SZG', '155168804472700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('tqx4xWHT1hxGPOfG822', 'kPLbeydkgiYW6NIkCt0', null, 'gkbm2C0NbCfu86GHkFh', '0', 'hahOwfXx6ZmPFPMbyf8', '155168804567900003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('TQxbaq3wQkxRcytxJAx', 'WB81MbCBolNg6XmE35M', null, '11e6-5496-7fbba41d-9671-379f935a9949', '1', '11e6-549a-4c83513c-9671-379f935a9949', '155141105095900001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('tqxcVuVnoMvX5Ec3F7m', '2ytUeoxBqghwofmBALl', null, 'zqGmDkZIRa4COpFVzTj', '1', 'GfV1N4DO1ZfVQGkI6Jz', '154461618916300002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('TRDREN9BcbBeJdl9tf9', 'jkpTHKg7DpuXQrppVxx', null, '9ppSV2PIKNhHCOwufvI', '0', 'KXsfuFCITnsqT6hE3Je', '155142353123600002', 'HdPeBqYwJyFyjHkhZu3', '导出', '16', '1');
INSERT INTO `t_permission` VALUES ('TRelCXnQpM76clx3onJ', 'kPLbeydkgiYW6NIkCt0', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'TdjwkbcPtyWwzr47Pw5', '155168804546100005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('TrtHDFvbSxLZcUMyS1g', '2jSs6cnzu4mzY9C13vF', null, 'R6yjKjfn0NuFZDhxQuS', '2', 'R6yjKjfn0NuFZDhxQuS', '155142339598400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('trZvqFkulWW6OuFeh6d', 'kPLbeydkgiYW6NIkCt0', null, 'G1v3gcUQOvFAo7IH62c', '2', 'G1v3gcUQOvFAo7IH62c', '155168804482100000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TSJ2g4o4g1uHAf3LX1z', '3tFw1boS5L9vXoJCr6Z', null, 'Jh68ppMt3QMha315Hi6', '0', 'ePkoYYvvztlUvkHqa16', '154563949519500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('tsXd9n3kWKBoPF9JyXm', 'jkpTHKg7DpuXQrppVxx', null, '9HKopmq2QmqQZjBp0ve', '1', '9HKopmq2QmqQZjBp0ve', '155142353114300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ttDpfecBzMx0aedKcaW', '2jSs6cnzu4mzY9C13vF', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '155142339748200004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('tuDW5vyI8qD9RNMHpXQ', '0Q0LkJpfR1ejtO8rD3p', null, 'CjR2ngF0kCrKnCpD0rj', '1', '5KOAZ5zATQsht3hJjXs', '155168789365700002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('tufiRhRUzPfvUJWlhW8', 'jkpTHKg7DpuXQrppVxx', null, 'vDsnTykdPOblfwEF4mR', '1', 'jVcLQaH4BiwznPvstCF', '155142353143900000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('tUoEdiGtCnaqxgtzb6F', 'jkpTHKg7DpuXQrppVxx', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'd6qZunMLjwykDchDPZG', '155142353065900000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('TuXtcK7OWvA36f984sA', '3tFw1boS5L9vXoJCr6Z', null, 'rdQ5WPuRoiCMJtXgsjg', '1', 'rdQ5WPuRoiCMJtXgsjg', '154563949482000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('tV2hxemXKVNZxGUt5hq', 'TzxwQuzGAOCi1aTd7o1', null, 'j4ncSyWthzCYoNj3n4J', '0', 'WWNamo3Hl2Q5IoZUFn7', '154461643402900000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('tVbIdGfwnUeE7EDcXCE', '0Q0LkJpfR1ejtO8rD3p', null, 'XzgpTEte9Q1JQswSETz', '0', 'XLZiQKl894Jrpsbimx0', '155168789484200004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('TVdlRyQW40izxnvSCwW', 'kPLbeydkgiYW6NIkCt0', null, 'DH7Zen0eWUXbjpOEAKb', '2', 'DH7Zen0eWUXbjpOEAKb', '155168804485200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('tVHCIrddlLNybZ2fDL2', '0Q0LkJpfR1ejtO8rD3p', null, 'UdbmUInPiuJzqP4yBTS', '1', 'UdbmUInPiuJzqP4yBTS', '155168789473300003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('TvHwdGD5khQJmZviDMk', 'kPLbeydkgiYW6NIkCt0', null, '5XKkpkend5hrAy8xWlc', '1', 'gMLNnDrjNUE07fMXd9o', '155168804555400005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('TvU0eYzjmKvkwJXfVIG', '0Q0LkJpfR1ejtO8rD3p', null, 'HqyysOeWOVkmU29sLla', '0', 'NYq2pB1fAXTxVgfupIY', '155168789398400003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('tWCgU6dDCOvolwqkCHR', 'jkpTHKg7DpuXQrppVxx', null, 'kqrKj5I16CqjnePUq0G', '1', 'kqrKj5I16CqjnePUq0G', '155142353098700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('TwiyXMUNUmEe6hXj6AI', '2jSs6cnzu4mzY9C13vF', null, 'oeLOJO0f3CC02OjOOIC', '0', '6onRFmzn8mrnGdrnIJy', '155142339754400003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('TxDjijWIlqqr3oxu3GH', '2ytUeoxBqghwofmBALl', null, 'rfmGjP7LXiQfxy15izp', '1', 'dUQn2CkeHgHGnGsR8JC', '154461618907000001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('TxG4m1Irxp3zgEdDFRz', '2ytUeoxBqghwofmBALl', null, '4RJ5cYekBtB1RdNDxL3', '1', '2WEniL1FLLpXKQfd5XU', '154461619030400002', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('tXwdIMUdoJw5c3Fsy5T', '3tFw1boS5L9vXoJCr6Z', null, 'qOM6QAy48iqde43ij94', '2', 'qOM6QAy48iqde43ij94', '154563949447600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('txzSxy3b4XodvLgZ0YT', '2jSs6cnzu4mzY9C13vF', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'zubbDJQFaTursZKijlj', '155142339779400000', 'HdPeBqYwJyFyjHkhZu3', '自定义', '13', '1');
INSERT INTO `t_permission` VALUES ('tY2w16HD8pMvrKGZ1bc', '3tFw1boS5L9vXoJCr6Z', null, 'EaVrfjS89IZqE63BWPa', '0', 'lPhlrrSkZ8hekbRhXPh', '154563949591300003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('TYG8TzW4yeCax7XB6fS', '0Q0LkJpfR1ejtO8rD3p', null, '1YQdDj3kDCsdgpgrTSf', '2', '1YQdDj3kDCsdgpgrTSf', '155168789292300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TYJey1yl4t3rd68EsfH', '2jSs6cnzu4mzY9C13vF', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'SmYDAD9eEDzqIUvO99F', '155142339746600003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('tYTGJlnH3zNyFZKpkFm', 'kPLbeydkgiYW6NIkCt0', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '155168804575700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('TZi1U9X7B74dnz2dO6d', 'WB81MbCBolNg6XmE35M', null, '11e6-55fc-eef7de0c-bb59-b7243d4bcf51', '1', '11e6-55fd-8b9f52b2-bb59-b7243d4bcf51', '155141104989900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('TZjHWuA0MGLurX4TtvQ', 'kPLbeydkgiYW6NIkCt0', null, 'Q70cP6OyQI3YDJ10sz9', '2', 'Q70cP6OyQI3YDJ10sz9', '155168804497700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('TzQUiyBjHFUbT8WLkir', '2ytUeoxBqghwofmBALl', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'fkbqJ4vxJOUvHY59Lo6', '154461619058500003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('TzVkLB0DUIWDC4g6DXc', 'kPLbeydkgiYW6NIkCt0', null, 'AKGX6zv2MUckrIYhVdz', '2', 'AKGX6zv2MUckrIYhVdz', '155168804486800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('U18pKinHyxatldlBup5', 'kPLbeydkgiYW6NIkCt0', null, 'gWeQH0XbGS29JGGgrvT', '2', 'gWeQH0XbGS29JGGgrvT', '155168804483700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('U1thrgGNb44iStaStq6', '2jSs6cnzu4mzY9C13vF', null, 'w7IsSOtXFvo61cP8sKr', '1', 'w7IsSOtXFvo61cP8sKr', '155142339776200004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('u2A0BYWnAtG0BciGObr', 'jkpTHKg7DpuXQrppVxx', null, 'Ad9RS4RG7w9vkXmoKHG', '2', 'Ad9RS4RG7w9vkXmoKHG', '155142352961400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('u3DlCL8he9TqlN3jT14', '3tFw1boS5L9vXoJCr6Z', null, 'XtaVH2y40O9zvIVALWj', '1', 'bufGP6tY9wwjTOfXum5', '154563949480400000', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('U3hSnkXwpL4DLqIwepg', '2ytUeoxBqghwofmBALl', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'RXwhTRAzZSqsUpQc1NF', '154461619074200004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('U45KDSLPhdnpwCJ8WBO', 'jkpTHKg7DpuXQrppVxx', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'QOEHg2MUz4Qp7kv5JyL', '155142353104900002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('U4tFLMKu1dln5CUxgWf', '0Q0LkJpfR1ejtO8rD3p', null, 'KUp98gX4KG2acWUaepP', '2', 'KUp98gX4KG2acWUaepP', '155168789298600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('u4VaC7qybMCpd6Mvyjq', '0Q0LkJpfR1ejtO8rD3p', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'LjTWOCClNPbDkDtAgoQ', '155168789463900000', 'HdPeBqYwJyFyjHkhZu3', '删除（字体图标红色 ）', '3', '1');
INSERT INTO `t_permission` VALUES ('U5HfFbXxM5e85Jr9fuD', 'jkpTHKg7DpuXQrppVxx', null, 'vDsnTykdPOblfwEF4mR', '1', 'g26NwXh1sSVhmkBCy8v', '155142353142400001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('u5hwU70QYtpsrvlPXN5', 'kPLbeydkgiYW6NIkCt0', null, 'tbfv6enk6DCV69XcIwq', '2', 'tbfv6enk6DCV69XcIwq', '155168804466500004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('u6EMWKBw6Ogc5rnsy9A', '0Q0LkJpfR1ejtO8rD3p', null, 'Jzy7zZItDzniSSkL6fQ', '2', 'Jzy7zZItDzniSSkL6fQ', '155168789323500004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('U6mB84NTpc0Kx4uxhZr', 'kPLbeydkgiYW6NIkCt0', null, 'bKWrnsYGUGaqqYqkeeO', '0', '23XpTvLhb5XEzINSZHU', '155168804678700002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('u6rYa63TgAWQ87628Pw', '3tFw1boS5L9vXoJCr6Z', null, 'KUp98gX4KG2acWUaepP', '2', 'KUp98gX4KG2acWUaepP', '154563949435100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('u7ia4wbdncpjzmNdcWu', '0Q0LkJpfR1ejtO8rD3p', null, 'SaFhOUcZJcd0Kj5IodL', '2', 'SaFhOUcZJcd0Kj5IodL', '155168789326700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('u7NMsszqdqruaMMq0As', '2ytUeoxBqghwofmBALl', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'HsJKTUvE0PpgpJ9EXSw', '154461619130400001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('u7xv3i2Sg73vZR4wL07', '3tFw1boS5L9vXoJCr6Z', null, 'EKD2uh12ht0Vptz9xN5', '0', 'lvJH9BuhAKV63iMY4ld', '154563949522600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('U81657Ed2Sy0cyC67NB', '2jSs6cnzu4mzY9C13vF', null, 'LfGA9FEokOkgKY6hN4p', '2', 'LfGA9FEokOkgKY6hN4p', '155142339600000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('UA6wYS0WrupsaHQNNud', 'jkpTHKg7DpuXQrppVxx', null, 'sMlqIILsNZ3bvqE2hSm', '1', 'xEBN59fWrxYULgpdRLy', '155142353016000005', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('UAA9ICN5aGJ2SIWKefx', 'jkpTHKg7DpuXQrppVxx', null, 'nTlBd4a4Vt8mtiTX41J', '0', '9e1x2YMVEFvz8YJOOtI', '155142353115800005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UaBQ4wA6gfQAdG1zfXC', 'jkpTHKg7DpuXQrppVxx', null, 'GhbQPNIblLICNGTEwqX', '0', 'CnYPYgX7tOKqpWia5h3', '155142353075300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('uaO0ppAuznkOFdZl9MM', 'jkpTHKg7DpuXQrppVxx', null, '3gGNzYyE5dK9ogZidWA', '1', 'HbDOYiiIBcC1oYN30Kx', '155142353112700005', 'HdPeBqYwJyFyjHkhZu3', '保存', '4', '1');
INSERT INTO `t_permission` VALUES ('UaZh4kGLoJ8Cl2W3f5J', '2jSs6cnzu4mzY9C13vF', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'wuWQttnDBKAz7kQ2UMs', '155142339897900000', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('ubbZvBi3JOcGKfoIkEV', '0Q0LkJpfR1ejtO8rD3p', null, 'fAVX6iUbvHroALIUfPf', '2', 'fAVX6iUbvHroALIUfPf', '155168789295500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('UC13Xc21uOtDmYkSJsz', '2jSs6cnzu4mzY9C13vF', null, 'Z6pISvulUdsSz8bjuOV', '0', '7nN7s8EOZ6SjZc0tEMY', '155142339752800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Uci7t2lYETNKvkOFv0Y', 'jkpTHKg7DpuXQrppVxx', null, '5RzsvfgAUx2y0k1pDlg', '0', 'NgNicpt0mPuprqEMquB', '155142353164200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UcYwQj9pACW1DAyR2fP', '3tFw1boS5L9vXoJCr6Z', null, 'WrG5tW3KzqYHU2QYywI', '2', 'WrG5tW3KzqYHU2QYywI', '154563949460100004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('udSNkV6wylRdClenFv2', '0Q0LkJpfR1ejtO8rD3p', null, 'WOmzvkui5ZsoZu1CogR', '1', 'GtjuDeHrOcWix1W5qZC', '155168789415600001', 'HdPeBqYwJyFyjHkhZu3', '签章', '46', '1');
INSERT INTO `t_permission` VALUES ('udvJ3KLFwn2p5iMHmYK', '3tFw1boS5L9vXoJCr6Z', null, 'U1TygLjjsSxDfEoGwhc', '1', 'U1TygLjjsSxDfEoGwhc', '154563949485100003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Ue2nAp24dte7YpaGb0N', '2ytUeoxBqghwofmBALl', null, 'LSwQOY0mggQ0vy4752p', '0', 'PSPMnN2J3uJvKmrQ0mW', '154461619149200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('uFBHTkShlvkrKCrkeXN', '0Q0LkJpfR1ejtO8rD3p', null, 'vZjJlrJAj7XdNX3czmS', '0', 'Mk4H4HSkj1saDLiahVH', '155168789384400000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UfGpcYu1BORVCeNNh25', '2ytUeoxBqghwofmBALl', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'wgw8EmPgt7pl1vVHHdz', '154461618960100001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('UfJoe0kQznCkdwgHkIr', '2ytUeoxBqghwofmBALl', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'MiEVpwvQ9yx8Zb5c2bR', '154461618969500003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('UGctMfL5jxiCCWIVDkM', '2ytUeoxBqghwofmBALl', null, 'McumxQcBkg92YPli9Ox', '1', 'McumxQcBkg92YPli9Ox', '154461619053800001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('uglw1Tdj4WQKWVmWNa3', 'kPLbeydkgiYW6NIkCt0', null, 'T9IoQKXjHSvxRXYM3L8', '1', '3X6cQR0K41HlNd3N5Ty', '155168804563200005', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('uGpJkqqOYyxnWDE9yLc', 'jkpTHKg7DpuXQrppVxx', null, 'aGwWScnt2f6X87bV5u9', '1', 'aGwWScnt2f6X87bV5u9', '155142353041000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('ugpRM9EPDVOEvxwwWMN', '2ytUeoxBqghwofmBALl', null, 'Jh68ppMt3QMha315Hi6', '0', 'xTW6bbE29gUdngFIb2q', '154461618999200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('UGs669WVQKBytBKz5O8', 'kPLbeydkgiYW6NIkCt0', null, '8PCn6NiiMTRGZcA5dsU', '1', '8PCn6NiiMTRGZcA5dsU', '155168804600700005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Uh61IZTvfv0rIvbTDIN', 'kPLbeydkgiYW6NIkCt0', null, 'iL3YpikkZUlruc5ai3D', '1', 'iL3YpikkZUlruc5ai3D', '155168804547600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('uh7hv77k7mQKQcUojN0', 'WB81MbCBolNg6XmE35M', null, '11e6-53e6-73b34240-81f5-679a826556ce', '1', '11e6-53eb-ac62e12b-81f5-679a826556ce', '155141105113100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Uh91zggAMG9yyIP8twJ', '2ytUeoxBqghwofmBALl', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'RXwhTRAzZSqsUpQc1NF', '154461618913200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('uhIbFtg2Nx1teXHIWvG', '2jSs6cnzu4mzY9C13vF', null, 'IuPDe4Gm9occzflnrP0', '0', 'R45h7dTChA2x72ng9VU', '155142339866700000', 'HdPeBqYwJyFyjHkhZu3', '当前页面打开', '43', '1');
INSERT INTO `t_permission` VALUES ('UHkrUv3ulCUbwMhUKof', '0Q0LkJpfR1ejtO8rD3p', null, 'sMlqIILsNZ3bvqE2hSm', '1', '7gZkOqMaP3BBCXPapf5', '155168789343800005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('UhpdrCpcluCTxECpqwD', '2ytUeoxBqghwofmBALl', null, 'MtITrUcx3REq45LskT3', '0', '7vuhrOZQxA5vCOL1Nkw', '154461619064800006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('uhrPEQ461ZFJsJjP8Eo', 'jkpTHKg7DpuXQrppVxx', null, 'MtITrUcx3REq45LskT3', '0', '1GnA7ouj5X9SbchE8C5', '155142353153300002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UI9VRqxjsMfprFwRXoD', 'kPLbeydkgiYW6NIkCt0', null, 'LSwQOY0mggQ0vy4752p', '0', 'PSPMnN2J3uJvKmrQ0mW', '155168804678700000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UIQsmFUzo2hZiJyLH7A', '2jSs6cnzu4mzY9C13vF', null, 'F6reQ5BW7P6q236Pi13', '1', 'wK7VlAkGcNMtWEsCCF2', '155142339874500001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('UIuCdkM0OCQk8bZ1emR', '0Q0LkJpfR1ejtO8rD3p', null, 'vO8pkCUFsC8T8Ur5qEn', '2', 'vO8pkCUFsC8T8Ur5qEn', '155168789312600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('UJ0WQaOVSNJeAist8Fe', '2jSs6cnzu4mzY9C13vF', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '155142339737200003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UJ3R6SQMZhrpHiPDt2Q', 'jkpTHKg7DpuXQrppVxx', null, 'jYDgN5WH46paTNLcCqi', '0', '3Un6aJGRxrZKJu5VhVa', '155142353089300001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('UJeVA0N6fzWD5WEqzWs', '3tFw1boS5L9vXoJCr6Z', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'HsJKTUvE0PpgpJ9EXSw', '154563949616300002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('uKd1IiWjA0d97axVfwq', '2ytUeoxBqghwofmBALl', null, 'vCWvTbPligxwrkrwAv8', '0', 'akF0OOm8JnnvHsDhrLQ', '154461619136700002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('ukfqPTLeiPfQBvBFM60', '3tFw1boS5L9vXoJCr6Z', null, '4mlBSmLGlzULUWJe8Nu', '1', 'XeBSO1gjZBWzi78mcUl', '154563949542900001', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('uKHeQtif9LleUfYp4fb', '2ytUeoxBqghwofmBALl', null, 'JdWD8biOlCXjkEvrwMm', '0', 'MRVrK6Uj6Z6imY0qwYm', '154461618977300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('ukNXT5emwOLq7NXYUoQ', '2jSs6cnzu4mzY9C13vF', null, 'EGmIBh1ogGUoD8df1rE', '1', 'EGmIBh1ogGUoD8df1rE', '155142339890100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('UkSBw8MyrTLquLpAHjo', '0Q0LkJpfR1ejtO8rD3p', null, 's8qcshfzszuUknfhZNl', '2', 's8qcshfzszuUknfhZNl', '155168789283000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('UKxgAk27BIZrZMTgmoS', '3tFw1boS5L9vXoJCr6Z', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'LGI4kXh1sQ9vMEdPg6S', '154563949546000001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('UkyUt4SZl6gq91yWpIf', 'kPLbeydkgiYW6NIkCt0', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'va8G9KHkziR1bHrdZwG', '155168804633400000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('UL5PYBBkYJlrmp3DsKk', '2ytUeoxBqghwofmBALl', null, '3K4lxgBhBLAbzJrfYaB', '1', 'iYGmCNLDOISoDmNMi4d', '154461619108500001', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('uLhOorPl0E100G7B5JT', '0Q0LkJpfR1ejtO8rD3p', null, 'iuGmP6OvURaOFF3NzoP', '0', 'vTGnvvEUTALWtPdcXab', '155168789437400004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UmAkTnmj9LHlsnN4GOQ', 'WB81MbCBolNg6XmE35M', null, '11e6-5611-ccf21abe-91c5-cd8abd28b1f9', '2', '11e6-5611-ccf21abe-91c5-cd8abd28b1f9', '155141104776100000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('UMaScfaldayCvMvYehI', '2ytUeoxBqghwofmBALl', null, 'TqQZlnV3BVaRGCm4tXn', '1', '7Cu3i9C1gOoAeAS2dAn', '154461618935100003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('UmC0zQI6czmIKOKoBqJ', 'kPLbeydkgiYW6NIkCt0', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'fu3FPAvy3QbJl8Y96P7', '155168804594400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('UMpE3zlUdcVcbOVuTy3', '0Q0LkJpfR1ejtO8rD3p', null, '6bUPlXeVH92MIv7Nmdw', '1', 'RUXaoNPGKk4u8FtSPTh', '155168789354700003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('umwLWYwlY0RQ1hYu6bz', 'jkpTHKg7DpuXQrppVxx', null, '7am5R9EPlSCV3gz3SZG', '2', '7am5R9EPlSCV3gz3SZG', '155142352956700005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('umYF3sCdccwMqhayy7l', '0Q0LkJpfR1ejtO8rD3p', null, 'WjB49SEA8rvzL9rkC7N', '1', 'WjB49SEA8rvzL9rkC7N', '155168789432700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('unatemFkfKmodmfLwbA', 'WB81MbCBolNg6XmE35M', null, '11e6-561a-6cd49b8d-91c5-cd8abd28b1f9', '2', '11e6-561a-6cd49b8d-91c5-cd8abd28b1f9', '155141104763700003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('uND7Gfsm4hKBJ31mA3H', '0Q0LkJpfR1ejtO8rD3p', null, 'IuPDe4Gm9occzflnrP0', '0', 'R45h7dTChA2x72ng9VU', '155168789465500003', 'HdPeBqYwJyFyjHkhZu3', '当前页面打开', '43', '1');
INSERT INTO `t_permission` VALUES ('UOaSQZ2ofUbDQt0tXR6', 'kPLbeydkgiYW6NIkCt0', null, '5r3ZtpSgGVUw8avJcWr', '0', 'XR385S9LsLvvWdnYcuM', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单1', '3', '2');
INSERT INTO `t_permission` VALUES ('uOevRTgR76GoYjSbEKw', '2jSs6cnzu4mzY9C13vF', null, 'GhbQPNIblLICNGTEwqX', '0', '2YA8KZ2P1yC1f0g2Nzs', '155142339760600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('UoICvnlp9i7KYOUaU5n', '2ytUeoxBqghwofmBALl', null, 'g7U0PGtN5bKYhwbka6s', '0', 'V6C3ScFeVfcdhY9Xw63', '154461619000700002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('uoJNcXNVlS1yMOl20YT', 'kPLbeydkgiYW6NIkCt0', null, 'XzgpTEte9Q1JQswSETz', '0', 'XLZiQKl894Jrpsbimx0', '155168804670900004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('UOKvDx4il22eSaQUNpy', '3tFw1boS5L9vXoJCr6Z', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'iY5ypHvJGJTn6j3J2nC', '154563949575700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('UOnT1tn1QSGabNSecvz', 'jkpTHKg7DpuXQrppVxx', null, 'R6yjKjfn0NuFZDhxQuS', '2', 'R6yjKjfn0NuFZDhxQuS', '155142352978600001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('uoQXz83WxmUSy8AMYuF', 'WB81MbCBolNg6XmE35M', null, '11e6-55fd-b6c9bd17-bb59-b7243d4bcf51', '0', '11e6-55fe-315b9bc3-bb59-b7243d4bcf51', '155141105007000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('uorAVGNftzlNQYbLGJ3', '2ytUeoxBqghwofmBALl', null, 'F6reQ5BW7P6q236Pi13', '1', 'wK7VlAkGcNMtWEsCCF2', '154461619116300003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('UOt5IWPSgMra4FH2Bl4', '0Q0LkJpfR1ejtO8rD3p', null, '0zSRHMqiyMTl1dth7ds', '1', 'cn2gajGsHOgYLGZkWvG', '155168789357900003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('uouHKUrEbqx9w1P3pH0', 'jkpTHKg7DpuXQrppVxx', null, 'XOjVSXTJxQ9WnTO8TmN', '1', 'XOjVSXTJxQ9WnTO8TmN', '155142353045600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('upDXzWgeVM44Qs1Ssr5', '2ytUeoxBqghwofmBALl', null, 'bG7zmifAqOWLU6guwgi', '1', 'bG7zmifAqOWLU6guwgi', '154461619053800006', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('UPrGNKGAV20hYy0mAYb', 'jkpTHKg7DpuXQrppVxx', null, 'jzty8K7Nbi7GKcU8c3L', '2', 'jzty8K7Nbi7GKcU8c3L', '155142352977000002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('UpXcqak94vhXAdMK4Us', 'kPLbeydkgiYW6NIkCt0', null, 'D0geS9pQRj0wkmGMmBp', '2', 'D0geS9pQRj0wkmGMmBp', '155168804503900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('UpY1Df4kHX3doxYUWxW', 'kPLbeydkgiYW6NIkCt0', null, 'zqGmDkZIRa4COpFVzTj', '1', 'GfV1N4DO1ZfVQGkI6Jz', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单', '10', '2');
INSERT INTO `t_permission` VALUES ('UpztjTHkKhQ7TzjioGB', '2ytUeoxBqghwofmBALl', null, 'HqyysOeWOVkmU29sLla', '0', 'NYq2pB1fAXTxVgfupIY', '154461619019500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('uQs3y3cuNPXuOON0siN', 'kPLbeydkgiYW6NIkCt0', null, 'TB1tzLM8yuJEkB6aQUk', '1', 'TB1tzLM8yuJEkB6aQUk', '155168804669300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('urbvh74Oe0DyJ79Ozda', '0Q0LkJpfR1ejtO8rD3p', null, 'jyd4rbIxoL6EKjtSVWC', '1', 'jyd4rbIxoL6EKjtSVWC', '155168789429600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('uRDTzGamTI8bKS6MIYA', '2jSs6cnzu4mzY9C13vF', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'weZ9Sz2X5RBVBRpCdJM', '155142339885400000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('UrFLuaGt2enXfOVghUs', '2ytUeoxBqghwofmBALl', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'QE5Y9qsMqfgX5CnSw2u', '154461618999200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UrHj3MQ1hQYlhs9KELm', '2jSs6cnzu4mzY9C13vF', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'JyfgeJsIiLDXbY9SXJ7', '155142339840200000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('urpfyCGlXbcbBaDFHSM', 'kPLbeydkgiYW6NIkCt0', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'QE5Y9qsMqfgX5CnSw2u', '155168804647500002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('URPKYjEhUATVgxvgQ4Z', 'jkpTHKg7DpuXQrppVxx', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '155142353050300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UScPd4IpPbOeNMUrxvN', '0Q0LkJpfR1ejtO8rD3p', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'E47mVx0cWjUwctEiuIt', '155168789390600004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('ush09GO7SzzwFEvUJnJ', '3tFw1boS5L9vXoJCr6Z', null, 'w7IsSOtXFvo61cP8sKr', '1', 'w7IsSOtXFvo61cP8sKr', '154563949546000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('USNAEIkOgKGlPltIGRF', 'jkpTHKg7DpuXQrppVxx', null, 'FKEDNCysUfAav1gze8O', '2', 'FKEDNCysUfAav1gze8O', '155142352983200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('uSSETYBFQkKpoHStvgi', 'kPLbeydkgiYW6NIkCt0', null, 'QKYvQ00K4tWyyjKycUC', '0', 'vDCiwAlHhexzsJITERJ', '155168804625600001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Ut3HpPuSQ7Ez78UKahm', '2ytUeoxBqghwofmBALl', null, 'enhnCZbrTQ1mZpn18o5', '0', 'u8rE2hHMPcvxRUXgNQk', '154461619099200007', 'HdPeBqYwJyFyjHkhZu3', '更新所选记录', '1', '1');
INSERT INTO `t_permission` VALUES ('ut7qv7paqzeCRRgm9Mv', '3tFw1boS5L9vXoJCr6Z', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'ISM9kGtKs3Gkvrg1HSD', '154563949607000001', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '27', '1');
INSERT INTO `t_permission` VALUES ('UtDaJcbhp3skj7CS5hQ', '0Q0LkJpfR1ejtO8rD3p', null, 'fWq4603Eftipw3SEKHB', '2', 'fWq4603Eftipw3SEKHB', '155168789287700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('uTMW8CfLQuCYg68Audw', '2jSs6cnzu4mzY9C13vF', null, '5XKkpkend5hrAy8xWlc', '1', 'gMLNnDrjNUE07fMXd9o', '155142339695100000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('UtTnY2xqTvpQMwbwACf', '3tFw1boS5L9vXoJCr6Z', null, 'ArQpV2XcSwZaAGmiCGT', '2', 'ArQpV2XcSwZaAGmiCGT', '154563949469500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('uUjnIf6XWG0A2Mj6bPN', '3tFw1boS5L9vXoJCr6Z', null, 'Sf4gJqKj6QZzzSzkQM8', '0', 'MP9M3VhvaydaIQP5k8V', '154563949527300002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('uuPe1jRe3BvHCanbO5y', 'WB81MbCBolNg6XmE35M', null, '11e6-5e11-af9f0d23-ae15-3d6b584ebd70', '1', '11e6-5e11-cd18fa69-ae15-3d6b584ebd70', '155141104994500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('uuRGx21bZVmzHl6m5Cs', '3tFw1boS5L9vXoJCr6Z', null, 'zl3R26vYd12dQFRodMT', '2', 'zl3R26vYd12dQFRodMT', '154563949442900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Uv1lBRTL0wgrA9Bd6X3', '2ytUeoxBqghwofmBALl', null, 'gniImP2ug7E82S1WO0L', '1', 'A9ZVOiaJCjFUhFQkG6X', '154461618891300001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('Uv7kWnxTamMSslcEOsg', 'WB81MbCBolNg6XmE35M', null, '11e6-55fc-6817fa46-bb59-b7243d4bcf51', '1', '11e6-55fc-6817fa46-bb59-b7243d4bcf51', '155141105017900000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('uVBUaZfHsTquFgE0MAH', 'kPLbeydkgiYW6NIkCt0', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'wuWQttnDBKAz7kQ2UMs', '155168804670900002', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('uVvlAhGHEXJc5JcbRoF', 'kPLbeydkgiYW6NIkCt0', null, 'TqQZlnV3BVaRGCm4tXn', '1', '22ZvmpjYHg3LQFPOh01', '155168804542900004', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('uW0PfgeyUM5maNkobVo', 'kPLbeydkgiYW6NIkCt0', null, 'wgw8EmPgt7pl1vVHHdz', '1', 'iURMg4fbNkBkiB0qxra', '155168804560100003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('uWlOdQppzTCmrjxjSo0', 'WB81MbCBolNg6XmE35M', null, '11e6-553c-e6e8216e-8350-a3b9b8447d61', '1', '11e6-553c-e6e8216e-8350-a3b9b8447d61', '155141105149000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('UwQM8UGF0qvuyktGuux', '2ytUeoxBqghwofmBALl', null, 'XzgpTEte9Q1JQswSETz', '0', 'oTrq3HVrCNx1jALWUgh', '154461619144500003', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UwURC98UtoL37PC7oG5', '2ytUeoxBqghwofmBALl', null, 'UmMnr5J8RhgknR3Dsos', '0', 'RZ790ojkvhzumC5tyL2', '154461619024200000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UwVSWDjg0EFvp6orWLY', 'jkpTHKg7DpuXQrppVxx', null, 'QuvtJrkqhNSzp7mN4R3', '2', 'QuvtJrkqhNSzp7mN4R3', '155142352964500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('UWwA2serXr9kAJPlByx', '3tFw1boS5L9vXoJCr6Z', null, 'PvMaZ0rVJFTsr0SXOgT', '0', 'eTnoMZs9GI6BwMJq1Cn', '154563949522600005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UXI9J23POXYIIljn0QK', 'WB81MbCBolNg6XmE35M', null, '11e6-5491-50c5cc93-9671-379f935a9949', '1', '11e6-d160-1e22796e-bbdd-9f7a0eebced4', '155141105088100001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('uXOoHor99Gqpz6A3fLN', '2ytUeoxBqghwofmBALl', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'va8G9KHkziR1bHrdZwG', '154461618953800000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('uXXZMR3FlG4vpYKlSsJ', '2jSs6cnzu4mzY9C13vF', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155142339568800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('uY7wi2emMPOnGhYjo4K', '2ytUeoxBqghwofmBALl', null, 'qqHbF4LC1qdUg1ak29k', '1', 'vdYEg1wdkIfHULE2LzN', '154461618939800002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('uy88DjcA0NRvJFKFCHC', 'jkpTHKg7DpuXQrppVxx', null, 'HqyysOeWOVkmU29sLla', '0', 'NYq2pB1fAXTxVgfupIY', '155142353075300003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('UYbEsOd7uM69qsLTxhX', 'WB81MbCBolNg6XmE35M', null, '11e6-8086-9ae48819-94e7-cf1302a16d88', '0', '11e8-6313-b63cda92-a200-b5b0a579f3f4', '155141105144300002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '载入视图', '1', '1');
INSERT INTO `t_permission` VALUES ('UYdziFIWv8xgRSH4xSg', 'kPLbeydkgiYW6NIkCt0', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'Zb272Z4FRc9su5s2Lik', '155168804639700002', 'HdPeBqYwJyFyjHkhZu3', '批量提交（图片图标）', '20', '1');
INSERT INTO `t_permission` VALUES ('uYe49JsoXyT5YNCvtfT', '3tFw1boS5L9vXoJCr6Z', null, 'smthlnru9z9qwavJKk1', '0', '55V8ZUWfTBCxFClWTNS', '154563949630400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('UYEbTzAhLcuRXbhNw2N', 'WB81MbCBolNg6XmE35M', null, '11e6-5ba8-7822d2ac-a270-539aa660c6fc', '2', '11e6-5ba8-7822d2ac-a270-539aa660c6fc', '155141104780800001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('uYepCbT43koSCzHQRLd', '3tFw1boS5L9vXoJCr6Z', null, 'NGN4SO4fu5S5XxULG4X', '1', 'NGN4SO4fu5S5XxULG4X', '154563949483600004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('uyfcBMimcdUyEwvh0jg', '3tFw1boS5L9vXoJCr6Z', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'cHPexySH1L6Pf3IyNTH', '154563949572600004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('UYGGfITmj9ZpdTL5VeT', 'kPLbeydkgiYW6NIkCt0', null, 'vDsnTykdPOblfwEF4mR', '1', 'jVcLQaH4BiwznPvstCF', '155168804653700003', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('uyqLehhZ1EeA0Ak9MkS', '3tFw1boS5L9vXoJCr6Z', null, 'CJu3AVSi8NfqhFlu5jl', '1', 'zEz94y8drV2wM7Sh0jS', '154563949511600002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('UYsYU5usPWkK7i8xgdM', '2ytUeoxBqghwofmBALl', null, '06Me4ssjoGBiKz0gMK2', '0', '8Hhv2rO3YipCX5JageH', '154461619064800002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('uyvSX6fmBSlyEYNZjgd', '0Q0LkJpfR1ejtO8rD3p', null, '6r0MsymflCeuD0Rrz4G', '2', '6r0MsymflCeuD0Rrz4G', '155168789281400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('UZAmSav577ZvfmVEcQz', '0Q0LkJpfR1ejtO8rD3p', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K8Lx8Yr2KhbHQo4z25I', '155168789368800004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('uZE4de8kOfFlfvTzEH7', '3tFw1boS5L9vXoJCr6Z', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Z3JLytYNIhmUl9AqEci', '154563949544500003', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('UZJJy5oSRNYF6WLZgSj', 'jkpTHKg7DpuXQrppVxx', null, '1QioSPqczT1xRrQBliu', '0', 'wIwBEaIp2kNiyXqGS2h', '155142353067500006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('UznG2AJTHyttKjHZrP4', '0Q0LkJpfR1ejtO8rD3p', null, 'lbZDhonVIlyX0n0IKyu', '2', 'lbZDhonVIlyX0n0IKyu', '155168789289200004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('uzra6y7T1X1cdxsEBwh', '2ytUeoxBqghwofmBALl', null, '0zSRHMqiyMTl1dth7ds', '1', 'EbrSUqhaaWu3vkwQzkZ', '154461618946000005', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('uZwLpDjsW0vq1zIXuuf', '2ytUeoxBqghwofmBALl', null, '7NlGpNC1MAEM6EuX2X0', '1', '7NlGpNC1MAEM6EuX2X0', '154461619147600005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('uzwNu1KWcrdfnjYburZ', '2jSs6cnzu4mzY9C13vF', null, 'WOmzvkui5ZsoZu1CogR', '1', 'GtjuDeHrOcWix1W5qZC', '155142339780900002', 'HdPeBqYwJyFyjHkhZu3', '签章', '46', '1');
INSERT INTO `t_permission` VALUES ('UZzG3nN3IlKdVRpRbro', 'WB81MbCBolNg6XmE35M', null, '11e6-539f-0c568130-81f5-679a826556ce', '1', '11e6-539f-0c568130-81f5-679a826556ce', '155141104788600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('v0bI0Agadxkov1uFZSM', 'jkpTHKg7DpuXQrppVxx', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'Z3JLytYNIhmUl9AqEci', '155142353083100001', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('v1tNw1INXcEyIr2kEf8', 'WB81MbCBolNg6XmE35M', null, '11e6-5616-02af49c8-91c5-cd8abd28b1f9', '2', '11e6-5616-02af49c8-91c5-cd8abd28b1f9', '155141104766800002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('v1zuD9dViZMxslAgSeJ', '2ytUeoxBqghwofmBALl', null, 'kA4m81roWetnkDQgWm0', '0', 'fc8oYpPYk2t3xyohWqx', '154461618992900004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('V25qUT4CoBShLWYLuKG', '2jSs6cnzu4mzY9C13vF', null, 'F6reQ5BW7P6q236Pi13', '1', 'F6reQ5BW7P6q236Pi13', '155142339873000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('v2YbreCkfKQ3ngC1e5k', '3tFw1boS5L9vXoJCr6Z', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '154563949511600003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('V34J0kTDH9x6aGDbXrl', 'jkpTHKg7DpuXQrppVxx', null, 'yDZaeD0mt44iNjakHmE', '0', 'mYv5iZiU0TwoK4MWL6v', '155142353080000000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('V35pP35iMg9tpfpiEpO', '3tFw1boS5L9vXoJCr6Z', null, 'EHYHRWZlyHZcXyKrAkr', '2', 'EHYHRWZlyHZcXyKrAkr', '154563949442900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('v3faHc351c9n8FCfCEr', '2ytUeoxBqghwofmBALl', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'f9GQrsfu9GKGRqKKPgi', '154461619113200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('V3J3mETdbQ5j2xcW2dP', '3tFw1boS5L9vXoJCr6Z', null, 'MIExqx2MWO5cunDiuaX', '1', 'BjLpkwnLuJNx6aokoma', '154563949505400003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('V3lxIyYjNbZlZYOgKxk', '3tFw1boS5L9vXoJCr6Z', null, '6arVIWht264qE2jDBdE', '2', '6arVIWht264qE2jDBdE', '154563949464800002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('V5JYJ1l8LXHTAuN6SBZ', '2jSs6cnzu4mzY9C13vF', null, 'jWiazgyndKfhYY4uvW8', '2', 'jWiazgyndKfhYY4uvW8', '155142339554700000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('V6lTRwvChy65X7Inc3z', '2ytUeoxBqghwofmBALl', null, 'eLFjqFngRQrIkbsdeBd', '1', 'eLFjqFngRQrIkbsdeBd', '154461619050700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('v7DjpOclHoFk19CBfGt', 'WB81MbCBolNg6XmE35M', null, '11e2-11c4-3682572e-8481-bf43184b8d87', '0', '11e4-ceb1-e720d805-b2a1-b5b94c6fcd94', '155141104819800002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '导出Excel', '16', '1');
INSERT INTO `t_permission` VALUES ('V7IBdZ3b7wkt346VQ86', 'jkpTHKg7DpuXQrppVxx', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'Y0AtqRPANYqitR5XI0Q', '155142353034700001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('v7wnrLE9LZdXDLAY4uI', 'kPLbeydkgiYW6NIkCt0', null, 'MtITrUcx3REq45LskT3', '0', '1GnA7ouj5X9SbchE8C5', '155168804663100004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('V865VcEBSareAQEw65Z', 'WB81MbCBolNg6XmE35M', null, '11e6-5618-885d2bbb-91c5-cd8abd28b1f9', '2', '11e6-5618-885d2bbb-91c5-cd8abd28b1f9', '155141104773000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('v8PjIzcSYioiTEobqFx', '3tFw1boS5L9vXoJCr6Z', null, 'QgINfDEbj3rwSwaOJHg', '2', 'QgINfDEbj3rwSwaOJHg', '154563949466300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('V8v2ZghNeHvdHupqsBW', 'jkpTHKg7DpuXQrppVxx', null, 'XzgpTEte9Q1JQswSETz', '0', 'XLZiQKl894Jrpsbimx0', '155142353161100002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('V9CEbrzv8hePA2az6PV', '3tFw1boS5L9vXoJCr6Z', null, 'qAcxhZ5mnoiohEBYD9G', '2', 'qAcxhZ5mnoiohEBYD9G', '154563949427300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('v9mDKdTtDUFiPWJquFB', 'kPLbeydkgiYW6NIkCt0', null, 'qU8WM5a2IVVudiqn38E', '1', 'qU8WM5a2IVVudiqn38E', '155168804605300003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('v9uRRONfc8ckjYW4fSi', 'jkpTHKg7DpuXQrppVxx', null, '9ppSV2PIKNhHCOwufvI', '0', 'OPN8L9J3OMzySIcqldf', '155142353125200001', 'HdPeBqYwJyFyjHkhZu3', '跳转', '1', '1');
INSERT INTO `t_permission` VALUES ('V9yrqDipv2yJIEnPXbX', '2jSs6cnzu4mzY9C13vF', null, 'm8moRuOLRGU8fSbCIty', '0', 'Z6h9QsC5gMpu1hmPip2', '155142339637400002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('VAdeV9jPN0Cvpn0i5M7', '0Q0LkJpfR1ejtO8rD3p', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'bYd4AsVWGV8kpxju1vo', '155168789414000001', 'HdPeBqYwJyFyjHkhZu3', 'PDF导出', '25', '1');
INSERT INTO `t_permission` VALUES ('vas72y8JcUKnmViMCiq', 'kPLbeydkgiYW6NIkCt0', null, 'LdUkdpc3EVM9iBygFMr', '0', 'cS0647Al36GrYYVT25b', '155168804602200000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('VBGynlcytbaf3uQnl7C', '3tFw1boS5L9vXoJCr6Z', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'x2qgUpE8u9jmGEWbbQm', '154563949574100002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VBuWI7NRN4fss3OKXNI', 'jkpTHKg7DpuXQrppVxx', null, '1fhgTUPecMY0ajlTkKZ', '0', 'UiotHIXmy0M1EdhhF8k', '155142353076800003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('VbX32twFrCWd8GYcTBe', '2jSs6cnzu4mzY9C13vF', null, 'U1TygLjjsSxDfEoGwhc', '1', 'ih9o5BJcd9TxtaItt0i', '155142339643600001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('vC7s8nvm6541eXPIAYt', 'kPLbeydkgiYW6NIkCt0', null, 'WOmzvkui5ZsoZu1CogR', '1', 'GtjuDeHrOcWix1W5qZC', '155168804596000003', 'HdPeBqYwJyFyjHkhZu3', '签章', '46', '1');
INSERT INTO `t_permission` VALUES ('vdA5PoDkU0jiJ6fDc78', '0Q0LkJpfR1ejtO8rD3p', null, 'smthlnru9z9qwavJKk1', '0', 'AHJzoQDdLpyRpZLTTdK', '155168789485800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('VdGX7VCBIqYYffvXAR0', '2ytUeoxBqghwofmBALl', null, 'vDsnTykdPOblfwEF4mR', '1', 'vDsnTykdPOblfwEF4mR', '154461619022600000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Vdy6mh72AIqrDEvKc3k', '0Q0LkJpfR1ejtO8rD3p', null, '3gGNzYyE5dK9ogZidWA', '1', '3gGNzYyE5dK9ogZidWA', '155168789453000002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('vdzh1iBi5XgminEvNCc', '2jSs6cnzu4mzY9C13vF', null, 'WjB49SEA8rvzL9rkC7N', '1', 'WjB49SEA8rvzL9rkC7N', '155142339793400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VE5bcRcEy8wvZ3YXKH7', '2jSs6cnzu4mzY9C13vF', null, 'wjPLVvwWYR2a9BOi0st', '0', 'cV9hNfWQ2CjjMiWBnt2', '155142339798100002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('vE6ChVlRqhP01GdSbPP', '2ytUeoxBqghwofmBALl', null, '9ppSV2PIKNhHCOwufvI', '0', 'OPN8L9J3OMzySIcqldf', '154461618963200001', 'HdPeBqYwJyFyjHkhZu3', '跳转', '1', '1');
INSERT INTO `t_permission` VALUES ('vED1AE1DpDUTeatl2OP', '3tFw1boS5L9vXoJCr6Z', null, 'ysihCX7dcjE9EuejMrJ', '2', 'ysihCX7dcjE9EuejMrJ', '154563949471000004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VEtMUw4Nv2yrUMVOA27', 'jkpTHKg7DpuXQrppVxx', null, 'F0SEYWEOMkZjQU2f0R1', '2', 'F0SEYWEOMkZjQU2f0R1', '155142352991000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('vEtp3AnlgUpdbObWcBV', '0Q0LkJpfR1ejtO8rD3p', null, 'GkSLWRbQwybXSXPOABb', '2', 'GkSLWRbQwybXSXPOABb', '155168789304800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('veuCH01sQRdnCQWUSq5', '3tFw1boS5L9vXoJCr6Z', null, '5XKkpkend5hrAy8xWlc', '1', 'gMLNnDrjNUE07fMXd9o', '154563949502300000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('VFGKXWW0FBW94BXZZl1', 'jkpTHKg7DpuXQrppVxx', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'bVmZ9H8tKyNWZ4omc1a', '155142353139200002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('VfUCRNtOehgvE7KaZGS', '2ytUeoxBqghwofmBALl', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'iY5ypHvJGJTn6j3J2nC', '154461619063200002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VFwZLPRzvAyavBwM1Dt', 'kPLbeydkgiYW6NIkCt0', null, 'U1TygLjjsSxDfEoGwhc', '1', 'ih9o5BJcd9TxtaItt0i', '155168804536700003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('vFxeRvpfpTSSCAe6ZUL', '3tFw1boS5L9vXoJCr6Z', null, '14PxjfoOE09shUfSg1l', '2', '14PxjfoOE09shUfSg1l', '154563949453800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VG6uWgvktIp9ykAdEZI', 'jkpTHKg7DpuXQrppVxx', null, '3K4lxgBhBLAbzJrfYaB', '1', '3K4lxgBhBLAbzJrfYaB', '155142353167300000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('vgeF8QYkbc5wGwoSgJL', 'WB81MbCBolNg6XmE35M', null, '11e6-5496-7fbba41d-9671-379f935a9949', '1', '11e6-5496-7fbba41d-9671-379f935a9949', '155141105094400000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VgMXRy47jkFSSTPz3cV', '3tFw1boS5L9vXoJCr6Z', null, 'w7IsSOtXFvo61cP8sKr', '1', 'tdpqhqKdJ6wj3toLl5M', '154563949549100001', 'HdPeBqYwJyFyjHkhZu3', '打印包含流程历史', '15', '1');
INSERT INTO `t_permission` VALUES ('VGsZ7lpIZFfsp2lBnEI', '3tFw1boS5L9vXoJCr6Z', null, 'o4zdmPoNHMg5JK6m6dx', '0', '2MHj4CnPnbOb2UFuMQr', '154563949600700001', 'HdPeBqYwJyFyjHkhZu3', '执行前再确认', '3', '1');
INSERT INTO `t_permission` VALUES ('VgVLso5VDFkiKCLKeDz', '2ytUeoxBqghwofmBALl', null, 'A6EMGp4mkUqLbMGLtql', '0', 'z1cc7dNuc4Vg60yjjLM', '154461619057000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('vGya1GEDEpbgJdBF81W', '2jSs6cnzu4mzY9C13vF', null, '53PLwEjsvlAXAnlixPb', '2', '53PLwEjsvlAXAnlixPb', '155142339620200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VHZjBCPjUpcttT0N0qz', '3tFw1boS5L9vXoJCr6Z', null, 'k3Ro7OsGafHyoiDAeLl', '2', 'k3Ro7OsGafHyoiDAeLl', '154563949477300005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Vi8RWlIA2xQq0KsvLVv', 'jkpTHKg7DpuXQrppVxx', null, 'PEBmSuAdvPujm2dfjAb', '2', 'PEBmSuAdvPujm2dfjAb', '155142352952000001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('vijImRghl9qvsCCMh01', 'jkpTHKg7DpuXQrppVxx', null, 'w7IsSOtXFvo61cP8sKr', '1', 'u8cNJQfZVXWFj5hlBow', '155142353083100005', 'HdPeBqYwJyFyjHkhZu3', '保存并启动流程', '4', '1');
INSERT INTO `t_permission` VALUES ('viyvJ9nqMiD9a13rJRN', 'WB81MbCBolNg6XmE35M', null, '11e6-52de-588531bf-a13d-c75d0a89256c', '1', '11e6-52e1-fe3d05ab-a13d-c75d0a89256c', '155141104890000001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('vjJ7zpWHhLrhjafcwww', 'kPLbeydkgiYW6NIkCt0', null, 'fWq4603Eftipw3SEKHB', '2', 'fWq4603Eftipw3SEKHB', '155168804469600004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VjlV8KYsMPfzVxl2aK4', 'WB81MbCBolNg6XmE35M', null, '11e6-560b-0542ee27-91c5-cd8abd28b1f9', '2', '11e6-560b-0542ee27-91c5-cd8abd28b1f9', '155141104773000004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VjpObfexeVJL3lhGMQa', 'jkpTHKg7DpuXQrppVxx', null, 'ID88NPj17JbpAMGYh9J', '2', 'ID88NPj17JbpAMGYh9J', '155142352984800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('vJz8f7QY1nKBUUnOiXF', '3tFw1boS5L9vXoJCr6Z', null, 'ZvhxR9A4dKdadPzdHgZ', '0', 'IajyYUcsSuyg4dFRXdR', '154563949594500000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('vk3LUvHkBOjqDFqwvHH', '3tFw1boS5L9vXoJCr6Z', null, 'rfmGjP7LXiQfxy15izp', '1', '5RmGeLAjzOblugQN5jG', '154563949582000002', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('vkjMeLMjXap8a7a3CmI', 'kPLbeydkgiYW6NIkCt0', null, 'poalxIjVlN70WdVjfQq', '1', 'ZABfGox4xJSo5PMgCOr', '155168804675500003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('vlM6DqSM1mbtXEs48Za', '2ytUeoxBqghwofmBALl', null, 'J9uhQYSQWhPor4IvkOE', '0', 'Q2aiiWtqBNqF33UGXUy', '154461618922600006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('vMA42kCUI8mPOz9EnEc', 'jkpTHKg7DpuXQrppVxx', null, 'ikeULZmmOeAR6XklD2T', '2', 'ikeULZmmOeAR6XklD2T', '155142353006600000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('vMD4isNRpn5PpZl0qtV', '3tFw1boS5L9vXoJCr6Z', null, 'LfGA9FEokOkgKY6hN4p', '2', 'LfGA9FEokOkgKY6hN4p', '154563949458500003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VMdF1DICjj56kY9hc0F', 'jkpTHKg7DpuXQrppVxx', null, 'TqQZlnV3BVaRGCm4tXn', '1', '22ZvmpjYHg3LQFPOh01', '155142353020700000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('VmF3cRMfsncQtknKtJU', '2ytUeoxBqghwofmBALl', null, 'a7jp1Dm53YjlAwDWuws', '1', 'a7jp1Dm53YjlAwDWuws', '154461619030400003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('vMGkoqL25R01Kxndlo5', 'jkpTHKg7DpuXQrppVxx', null, 'Cg51Ds07QnrIkV1ne95', '2', 'Cg51Ds07QnrIkV1ne95', '155142352980100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('vmogrXCSxwUQwphpQQN', 'jkpTHKg7DpuXQrppVxx', null, 'RwAgQB30vyuzPHYBb3F', '2', 'RwAgQB30vyuzPHYBb3F', '155142352955200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('vmyhGcfTyZ5vIT9vHAQ', '2ytUeoxBqghwofmBALl', null, 'lAUkIpgQSIZqQyttrB4', '1', 'lAUkIpgQSIZqQyttrB4', '154461618961700005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VNfDsP60OP4588pki4r', 'kPLbeydkgiYW6NIkCt0', null, 'U945OMsdX9fvzRjE7xG', '0', 'S1V13oV2ZMjKmg0oiLO', '155168804572600005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('VnmmD3KJEQnBUBf6Cmn', '2jSs6cnzu4mzY9C13vF', null, 'rumve1swtYufxpvxfcC', '2', 'rumve1swtYufxpvxfcC', '155142339606200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VohQLbb64SYzvZpWfyW', '3tFw1boS5L9vXoJCr6Z', null, 'cAu7pZ4IzsfytkdYNLM', '1', 'cAu7pZ4IzsfytkdYNLM', '154563949489800003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('vOM0uIODFrAS9Al2bMV', '2jSs6cnzu4mzY9C13vF', null, '5XKkpkend5hrAy8xWlc', '1', 'xHnChg1mK6MilHV4VCZ', '155142339692000001', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('VPkD3YFfXGKyhHqhc3A', '3tFw1boS5L9vXoJCr6Z', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'ElTaDWYx8x0ksSxQW27', '154563949585100002', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('Vpmp1d6FepwfIEeoEzd', 'WB81MbCBolNg6XmE35M', null, '11de-7666-1dc7f93b-8d52-0547317ddd4c', '1', '11de-766c-80ff3daf-824d-d3dd83e4db1b', '155141105128700002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存返回', '11', '1');
INSERT INTO `t_permission` VALUES ('VPo9jf5nhoiTBE9VkXd', '0Q0LkJpfR1ejtO8rD3p', null, 'U1TygLjjsSxDfEoGwhc', '1', 'U1TygLjjsSxDfEoGwhc', '155168789342300005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VPtTIELk60f6AaiWg6a', '3tFw1boS5L9vXoJCr6Z', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'IE1QRBOyhDRgkxFpUU2', '154563949486600003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VPyLD363GIKjKoHpwq7', 'jkpTHKg7DpuXQrppVxx', null, '68kltzfu9ZSUp9aJOg4', '2', '68kltzfu9ZSUp9aJOg4', '155142352975400003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VpZcb04Y06kIjI7BoTy', '2jSs6cnzu4mzY9C13vF', null, 'TqQZlnV3BVaRGCm4tXn', '1', 'UsdBObB53oqCjmBMNib', '155142339656100003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('VqILe5ogaiGymLi2cGM', '2jSs6cnzu4mzY9C13vF', null, '5RZRK7Jt5vyqwlIccop', '1', '5RZRK7Jt5vyqwlIccop', '155142339724800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('vQMX77ODQNlPUsfcXtI', '0Q0LkJpfR1ejtO8rD3p', null, '6esIc2fTAI9nAOoOZcp', '1', 'ngq5KVxqa5NRDO7OoHy', '155168789361000001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('VR1kOtXEyRxoCBha9k3', '2jSs6cnzu4mzY9C13vF', null, 'hP9KCze8ACTb6Z4BWVV', '2', 'hP9KCze8ACTb6Z4BWVV', '155142339585900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('vR2cWMtNq2S0TWiexi7', '2ytUeoxBqghwofmBALl', null, 'tFGnOBQtXBu5h6H7uk6', '0', 'd6qZunMLjwykDchDPZG', '154461619000700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('VR3EUO4qHRa0Rv5rlDV', '2ytUeoxBqghwofmBALl', null, '98kmnnrWwGKmgyiIkUF', '0', 'erevZ9qTmGbUQpQWI61', '154461618997600000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('vR3wDPxkSrjyyDLLxub', '3tFw1boS5L9vXoJCr6Z', null, '2Icse0Cn99YRTQTZO3f', '1', '2Icse0Cn99YRTQTZO3f', '154563949625700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('vRXKd5KktCEVcpsTNbr', '2jSs6cnzu4mzY9C13vF', null, 'NLGiWBICUXkTNWcaaD0', '1', 'NLGiWBICUXkTNWcaaD0', '155142339793400001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VsDIdXc80aSv2YxC0Fe', '0Q0LkJpfR1ejtO8rD3p', null, 'DH7Zen0eWUXbjpOEAKb', '2', 'DH7Zen0eWUXbjpOEAKb', '155168789306400001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('vSFeIa3GzVdGJbWMc1m', '2jSs6cnzu4mzY9C13vF', null, 'BrbFcB3ptMyxdPl5W6u', '0', '1JVZYNRouHUK7MH0xzc', '155142339854200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('VstmKK3H8t8TBvSXy4h', 'kPLbeydkgiYW6NIkCt0', null, '6BIvNJISOeZ3xm8S2aG', '1', 'gZXQSMJKQTAqYMBYWXE', '155168804546100001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('VTV5vXEXJ1CYjMCYsSj', '2ytUeoxBqghwofmBALl', null, 'j3y8CHrsMwRmnPJz7EW', '1', 'j3y8CHrsMwRmnPJz7EW', '154461619074200002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VueqaB2x0nUYJjrMipI', 'WB81MbCBolNg6XmE35M', null, '11e6-53ae-1c5fbd29-81f5-679a826556ce', '1', '11e6-53bf-684bdd42-81f5-679a826556ce', '155141105178600001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('VUMBVlQWpDTx207U3YO', '3tFw1boS5L9vXoJCr6Z', null, 'LocWe3mm3K3vF1gdbgC', '2', 'LocWe3mm3K3vF1gdbgC', '154563949441300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VVIsl4xXI4wpEudbNwR', 'kPLbeydkgiYW6NIkCt0', null, '9ppSV2PIKNhHCOwufvI', '0', 'OPN8L9J3OMzySIcqldf', '155168804638100000', 'HdPeBqYwJyFyjHkhZu3', '跳转', '1', '1');
INSERT INTO `t_permission` VALUES ('VvncrCvrKJF9oYtr5mg', 'WB81MbCBolNg6XmE35M', null, '11e6-5e11-d8696763-ae15-3d6b584ebd70', '0', '11e6-5e11-ebe8189c-ae15-3d6b584ebd70', '155141104996100001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('vw20OEtuU5hry64WXK0', 'jkpTHKg7DpuXQrppVxx', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'ISM9kGtKs3Gkvrg1HSD', '155142353137700002', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '27', '1');
INSERT INTO `t_permission` VALUES ('VwCoBrrzlP4xsrSoxkk', 'jkpTHKg7DpuXQrppVxx', null, '27MTAjC7JxdEukQ4fFY', '2', '27MTAjC7JxdEukQ4fFY', '155142352961400000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VwnzK3ykFPHnJLuoCKj', 'kPLbeydkgiYW6NIkCt0', null, 'f1qYzMAqsF7bNYJc4Xl', '1', 'aJ8FUYVtCO50iowXPg5', '155168804547600005', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Vws5efcCk0CpNIYwbEm', 'jkpTHKg7DpuXQrppVxx', null, '06Me4ssjoGBiKz0gMK2', '0', '8Hhv2rO3YipCX5JageH', '155142353153300000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('vwSx9GNWNqNJ9RI6DMi', 'WB81MbCBolNg6XmE35M', null, '11de-a1ce-12978c3f-a188-7710f5ef0f5e', '1', '11e8-5efb-c61eceec-b84a-39be571b3c90', '155141104816700003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存返回', '11', '1');
INSERT INTO `t_permission` VALUES ('vWVQzclk1hdowRcsxvI', 'kPLbeydkgiYW6NIkCt0', null, 'laN4VVChl81K10rDCWr', '1', 'laN4VVChl81K10rDCWr', '155168804603800004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VXBx42yMqIfunWvDdfS', '2ytUeoxBqghwofmBALl', null, 'i5qLZgg10LH5Och6mZo', '0', 'vmO7V4YJr5CDE0OPUG3', '154461618974200004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('vxekJd9BBfNfmPb5FnD', 'jkpTHKg7DpuXQrppVxx', null, 'LsrnkDvx5pdkA6JnHuj', '2', 'LsrnkDvx5pdkA6JnHuj', '155142352958300002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VxEvYyDrNB5iTA0qb7M', 'WB81MbCBolNg6XmE35M', null, '11e6-5ba6-8bef196b-a270-539aa660c6fc', '2', '11e6-5ba6-8bef196b-a270-539aa660c6fc', '155141104766800004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Vxff14br0bIE3dk76vh', '2jSs6cnzu4mzY9C13vF', null, 'MIExqx2MWO5cunDiuaX', '1', 'MIExqx2MWO5cunDiuaX', '155142339709200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('VxPtNlLFpwjk4HPA2Vp', '3tFw1boS5L9vXoJCr6Z', null, 'f4NDOEOVMi7vrgWjzz4', '1', 'gP7qA2QTRCEqWmdByHT', '154563949544500002', 'HdPeBqYwJyFyjHkhZu3', '保存并返回', '11', '1');
INSERT INTO `t_permission` VALUES ('VXrQWbI4e0DbluU6rcp', '2jSs6cnzu4mzY9C13vF', null, 'JmxxVKFmtiAV278992Z', '2', 'JmxxVKFmtiAV278992Z', '155142339598400003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('VXz7vf7rrvBjNxHqQLA', '2jSs6cnzu4mzY9C13vF', null, 'J9uhQYSQWhPor4IvkOE', '0', 'KgFs9krHT2ZyBayTPo8', '155142339635800000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('vYDZDy7Lw3ZCwxJQwOU', '0Q0LkJpfR1ejtO8rD3p', null, 'jYDgN5WH46paTNLcCqi', '0', '3Un6aJGRxrZKJu5VhVa', '155168789418700001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('vYigGFETPp9ge5IqeXt', '0Q0LkJpfR1ejtO8rD3p', null, 'sivHMH0kWQLjuMBG8z1', '2', 'sivHMH0kWQLjuMBG8z1', '155168789293900004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('vZ7MLFJVy4wOmSDtahr', 'jkpTHKg7DpuXQrppVxx', null, 'ty5ziZz2nDWVO0jHM22', '2', 'ty5ziZz2nDWVO0jHM22', '155142353003500002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('vzsO3vG1sa2hzHKIVFA', '3tFw1boS5L9vXoJCr6Z', null, 'gniImP2ug7E82S1WO0L', '1', 'gniImP2ug7E82S1WO0L', '154563949578800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('W147Mu1KXETr9exgN08', '2jSs6cnzu4mzY9C13vF', null, 'E4cbMljP402vIH2nZMB', '2', 'E4cbMljP402vIH2nZMB', '155142339592200003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('W16AU3ZGXP7mGqhflMa', 'WB81MbCBolNg6XmE35M', null, '11e6-54a1-8e46ef97-9671-379f935a9949', '1', '11e6-54a6-a72f2dda-9671-379f935a9949', '155141105080300001', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('W1Eo5EUhkNnp6TxSNvd', '0Q0LkJpfR1ejtO8rD3p', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'kYjMqLc40QkdYGXLHWO', '155168789443700002', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('w1woRKwtDQWoQCjlvvd', 'jkpTHKg7DpuXQrppVxx', null, 'dOBS9ubbO1XiVfY9ndg', '2', 'dOBS9ubbO1XiVfY9ndg', '155142352950500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('w3FvsBUbQGLjAdLnZCe', '2ytUeoxBqghwofmBALl', null, 'G0WtPO1mX58wd7tjkTy', '0', 'XIYtwtem4lZYZBYOfS5', '154461619046000001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('W3myc5RgBYY38iIUMwl', '2ytUeoxBqghwofmBALl', null, 'm8moRuOLRGU8fSbCIty', '0', '6ieKi8bk8zbO9XkicpP', '154461618925700002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('W423uPNP4bXwx6XpgBf', '2jSs6cnzu4mzY9C13vF', null, 'eLFjqFngRQrIkbsdeBd', '1', 'SX3rVQxkpU96Pko5JDm', '155142339880800000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('W4n6dMNuwOZRd6DLZO4', 'WB81MbCBolNg6XmE35M', null, '11e6-5531-4f3943bb-8350-a3b9b8447d61', '1', '11e6-5533-00c6f266-8350-a3b9b8447d61', '155141105200500000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('W4PZyXS4pcOvugnp3T3', 'kPLbeydkgiYW6NIkCt0', null, 'CVu6WUQOWb6xeKfIWS3', '0', 'gjNDcP4lJlHlGCLsxRq', '155168804574100005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('W4YQwp6WkpSAHKZ8oWD', '2ytUeoxBqghwofmBALl', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'ElTaDWYx8x0ksSxQW27', '154461618913200001', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('w4ywkxXzkZDYy9RHOxO', '3tFw1boS5L9vXoJCr6Z', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'D4TlyirrG1V4ebAqUSh', '154563949599100001', 'HdPeBqYwJyFyjHkhZu3', '删除（右键菜单）', '3', '1');
INSERT INTO `t_permission` VALUES ('w5Xb6EjH5euvgRGZpil', '3tFw1boS5L9vXoJCr6Z', null, 'XOjVSXTJxQ9WnTO8TmN', '1', 'aSYThGpCcKMF1dEwssZ', '154563949510100003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('w6ieo6THiPFT7HZTiCm', '3tFw1boS5L9vXoJCr6Z', null, 'ZM7F9MjjscP8bADF7cH', '1', '0LKFnyB5ViPnDQN8Ocl', '154563949502300003', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('W7E1xOz2Ifm81JaEfGS', '3tFw1boS5L9vXoJCr6Z', null, 'UmMnr5J8RhgknR3Dsos', '0', 'gxzuym0IWRzScvUoUk7', '154563949533500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('w80jsrzqcNUEBY4kyEC', '0Q0LkJpfR1ejtO8rD3p', null, 'QfirpboG4MjuFdj8mbs', '2', 'QfirpboG4MjuFdj8mbs', '155168789298600004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('W89YQBeeJqbsXrNxsQm', '2jSs6cnzu4mzY9C13vF', null, 'EKD2uh12ht0Vptz9xN5', '0', 'ThJH0AWU99Z8F5DDmUo', '155142339749700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('W8rnXONyU4sAioCNEnV', 'jkpTHKg7DpuXQrppVxx', null, 'exsIaz9QN0WD65u23jd', '2', 'exsIaz9QN0WD65u23jd', '155142353005100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('w9OGoXMt1Q92EbWbaZK', 'jkpTHKg7DpuXQrppVxx', null, 'gUlSUpqhlS2ym2ijZAg', '1', '6vfobfgmvGLQuOe0b3s', '155142353026900000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('w9yL9sWobuqwQmz4TeM', 'kPLbeydkgiYW6NIkCt0', null, 'H4Obg0f1gqRhQW4pA1i', '0', 'H4Obg0f1gqRhQW4pA1i', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单2', '1032', '2');
INSERT INTO `t_permission` VALUES ('war9kNJjBDSN1lUhFEt', '2ytUeoxBqghwofmBALl', null, 'viwgtc32VtB7wJo2O8S', '0', 'Wlje8Nr2ww7qrmEwdBf', '154461618994500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('wAtdyCSidfelKH42mFP', 'kPLbeydkgiYW6NIkCt0', null, 'rfmGjP7LXiQfxy15izp', '1', 'N1gohv56wfzjxXMkYXQ', '155168804617800002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('WAXPlLsE2pQnT0NpLPe', '0Q0LkJpfR1ejtO8rD3p', null, 'pyZGNS3zwQ5ravJoqyj', '2', 'pyZGNS3zwQ5ravJoqyj', '155168789307900003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('WB0nh8jQ15nAiplrxvI', 'WB81MbCBolNg6XmE35M', null, '11e6-549a-e2332c7e-9671-379f935a9949', '1', '11e6-d160-3a584db3-bbdd-9f7a0eebced4', '155141105056900002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('wb7Pa2VU7CXDzYf1442', 'WB81MbCBolNg6XmE35M', null, '11e6-54b1-282867bf-9671-379f935a9949', '1', '11e6-54b1-282867bf-9671-379f935a9949', '155141104929000000', '11de-f053-df18d577-aeb6-19a7865cfdb6', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('wBfJ5fNcjwmOC5Zu0QT', '2jSs6cnzu4mzY9C13vF', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'Y0AtqRPANYqitR5XI0Q', '155142339704500000', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('wbhWqctZxEepRBnwcnG', '0Q0LkJpfR1ejtO8rD3p', null, 'ezoT7Pqp0BbwzG6lg5A', '1', 'ezoT7Pqp0BbwzG6lg5A', '155168789339100004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('wBK3cnLPznIgaEmw908', 'kPLbeydkgiYW6NIkCt0', null, 'ezoT7Pqp0BbwzG6lg5A', '1', 'ezoT7Pqp0BbwzG6lg5A', '155168804532000001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('wCLmMkygiz6XO50WxMC', '2ytUeoxBqghwofmBALl', null, 'zqGmDkZIRa4COpFVzTj', '1', 'xBzMYIFuvohJrsvZE5M', '154461618916300001', 'HdPeBqYwJyFyjHkhZu3', '保存并新建', '42', '1');
INSERT INTO `t_permission` VALUES ('wCUOa4onhSiXrjHkcLz', 'jkpTHKg7DpuXQrppVxx', null, 'MiEVpwvQ9yx8Zb5c2bR', '1', 'MiEVpwvQ9yx8Zb5c2bR', '155142353047200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WCvlK1b7d3YylGBxqY7', '0Q0LkJpfR1ejtO8rD3p', null, 'XOjVSXTJxQ9WnTO8TmN', '1', 'aSYThGpCcKMF1dEwssZ', '155168789373500001', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('WcYIQafL2FrIWp8Q0VQ', '2jSs6cnzu4mzY9C13vF', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'tjznokFdoftUtJzbwhl', '155142339687300000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('wdIc5nSOnZ3RRTvq1h4', '2ytUeoxBqghwofmBALl', null, 'gniImP2ug7E82S1WO0L', '1', '2GBc0jCYf23ydklhe3I', '154461618891300002', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('WDSeo92EiCOQ6YEr4f1', 'jkpTHKg7DpuXQrppVxx', null, 'TqagBUMFdyCepAZ3Umc', '2', 'TqagBUMFdyCepAZ3Umc', '155142352992600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('wFaYvougXC8c5Q0uU9A', '2jSs6cnzu4mzY9C13vF', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'erjzyEtPTNQ9Oc2MmGl', '155142339651400001', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('WfntnjOpdExAQm7ve6Y', '2jSs6cnzu4mzY9C13vF', null, 'GkSLWRbQwybXSXPOABb', '2', 'GkSLWRbQwybXSXPOABb', '155142339570300001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('wfUZ3GN1TrBXMolvXBU', '2jSs6cnzu4mzY9C13vF', null, 'kebFCC8mkGX3V1QEriK', '0', 'dsB4JOjIMnlpqITpAVO', '155142339901000002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('wgGn8A6DKKo8bhOmPvC', '2ytUeoxBqghwofmBALl', null, '9ppSV2PIKNhHCOwufvI', '0', 'Qbqk2LB86r3acRInIHN', '154461619100700003', 'HdPeBqYwJyFyjHkhZu3', '刷新', '1', '1');
INSERT INTO `t_permission` VALUES ('wGVragaKWiHzml6lhmR', '2ytUeoxBqghwofmBALl', null, 'e6OXY8vDBhwyntKTBcc', '1', 'e6OXY8vDBhwyntKTBcc', '154461619091300003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WHICOuyWqwD5NgYBXie', '2ytUeoxBqghwofmBALl', null, 'mXDUC8go52mfA91GY0r', '0', 'P2oUhWPVibevLu0mKhp', '154461619110100007', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('whXR7nRTlWivaJINc9w', 'kPLbeydkgiYW6NIkCt0', null, 'QuvtJrkqhNSzp7mN4R3', '2', 'QuvtJrkqhNSzp7mN4R3', '155168804480500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('WId6hhi4wo7JRHdd3AF', '0Q0LkJpfR1ejtO8rD3p', null, 'kA4m81roWetnkDQgWm0', '0', 'imbMPttNeDXyRLEFJeh', '155168789381300004', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('wieF09PRDPyoVrWDQ1l', 'jkpTHKg7DpuXQrppVxx', null, 'bG7zmifAqOWLU6guwgi', '1', 'bG7zmifAqOWLU6guwgi', '155142353100200004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('wiNPurqVvhUtdqaAb9p', '3tFw1boS5L9vXoJCr6Z', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '154563949521000004', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('WIo6mOqjnw74suawUa3', 'kPLbeydkgiYW6NIkCt0', null, 'aGwWScnt2f6X87bV5u9', '1', 'aGwWScnt2f6X87bV5u9', '155168804561700004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WiyVq8DcPtUvRI36K6o', '0Q0LkJpfR1ejtO8rD3p', null, '7u0fRbpHrxopCyfgADs', '1', '7u0fRbpHrxopCyfgADs', '155168789365700004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WJ78QhwRezNqA3YZMkG', '2jSs6cnzu4mzY9C13vF', null, 'LY2n5aO7h1TrpoHU2mc', '1', 'LY2n5aO7h1TrpoHU2mc', '155142339799600001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WjEtKSllbOC0bzpEFvR', 'kPLbeydkgiYW6NIkCt0', null, 'tfxROndy5dmj8HKxpkX', '2', 'tfxROndy5dmj8HKxpkX', '155168804524200004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('wJGsD46JvwUWNhTIWfP', 'jkpTHKg7DpuXQrppVxx', null, 'fu3FPAvy3QbJl8Y96P7', '1', 'bYd4AsVWGV8kpxju1vo', '155142353086200004', 'HdPeBqYwJyFyjHkhZu3', 'PDF导出', '25', '1');
INSERT INTO `t_permission` VALUES ('wKbOxy0Fid2ku0SjWLr', 'jkpTHKg7DpuXQrppVxx', null, 'jwnvWbHVPeT86x5j2LF', '2', 'jwnvWbHVPeT86x5j2LF', '155142352989500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('WKcODNlHWSewiVcKW1g', '2jSs6cnzu4mzY9C13vF', null, 'zqGmDkZIRa4COpFVzTj', '1', 'GfV1N4DO1ZfVQGkI6Jz', '155142339631200001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('wkK03iw2WENyZbhoH4F', 'jkpTHKg7DpuXQrppVxx', null, '8DmOHAVRvs3BblbhJoa', '1', '8DmOHAVRvs3BblbhJoa', '155142353019100001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WKN7R09jsgOTuFpxSDV', 'jkpTHKg7DpuXQrppVxx', null, 'K8Lx8Yr2KhbHQo4z25I', '1', 'K8Lx8Yr2KhbHQo4z25I', '155142353039400000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WLhG2NHEdTzcKq2DRdo', '3tFw1boS5L9vXoJCr6Z', null, 'Z6pISvulUdsSz8bjuOV', '0', '81O85fI7nEQvujIwWvl', '154563949524100002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('WlJuRqMT4dcI99etuab', '0Q0LkJpfR1ejtO8rD3p', null, 'bkoXpI9ilQlOYD8wsbU', '1', 'bkoXpI9ilQlOYD8wsbU', '155168789404700002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WLSHDJTAzI5xEZwaQMi', '2ytUeoxBqghwofmBALl', null, '4v5tmazbZwdNkJDYso5', '1', '4v5tmazbZwdNkJDYso5', '154461619139800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WltDMungccYt9NdibNL', '2jSs6cnzu4mzY9C13vF', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'czdV0c3QJMI2AZPkQZ6', '155142339863600000', 'HdPeBqYwJyFyjHkhZu3', '新建（绿色）', '2', '1');
INSERT INTO `t_permission` VALUES ('WMeIZUolG8Mnn6VUi1R', 'jkpTHKg7DpuXQrppVxx', null, 'fkbqJ4vxJOUvHY59Lo6', '1', 'fkbqJ4vxJOUvHY59Lo6', '155142353150200001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WMh9NetA3la6Rt5iTpO', 'kPLbeydkgiYW6NIkCt0', null, 'JdWD8biOlCXjkEvrwMm', '0', 'OLJQOfZpoAIKsZOpeqD', '155168804645900003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('wMJjEmJRqxfjZNIZD07', '2jSs6cnzu4mzY9C13vF', null, 'gkbm2C0NbCfu86GHkFh', '0', 'hahOwfXx6ZmPFPMbyf8', '155142339740400001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Wmlzg6VDczAgbEN0QIn', '2ytUeoxBqghwofmBALl', null, 'qU8WM5a2IVVudiqn38E', '1', 'qU8WM5a2IVVudiqn38E', '154461619055400004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('wN5t5u0Qc02t6wV4pMi', 'kPLbeydkgiYW6NIkCt0', null, 'ZzKElb4GrlkC6XD8mVD', '0', '1krYPYySRPh91VrcaHA', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单21', '2', '2');
INSERT INTO `t_permission` VALUES ('wNrA37fTEQQo99TYffS', '3tFw1boS5L9vXoJCr6Z', null, 'aFAe8VMz1vxw9BfL1QE', '0', 'mJFtUs7KSNrMTt3W70z', '154563949622600002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('WnRtDO5mx8edsk6nkyc', '0Q0LkJpfR1ejtO8rD3p', null, 'DzqlEtg4JObApV7iWX8', '0', 'YIzUW1O7NPBhfxLwHuj', '155168789403100003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('wnT3Us3qfUJXHgya9JU', 'kPLbeydkgiYW6NIkCt0', null, 'ir2OPEdZvttSUxAzfmD', '1', 'ir2OPEdZvttSUxAzfmD', '155168804541400001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Wnuf62Dr0MbeGEd5yFO', '3tFw1boS5L9vXoJCr6Z', null, '0n6dTFPWytWUOlO2aeq', '2', '0n6dTFPWytWUOlO2aeq', '154563949457000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('WnvVzsS3UTx8pXtOeQU', 'WB81MbCBolNg6XmE35M', null, '11e6-54c0-6df9a554-9671-379f935a9949', '1', '11e6-54c1-a3488976-9671-379f935a9949', '155141104910300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('WOogukpASgemqfy7gZ7', '3tFw1boS5L9vXoJCr6Z', null, 'MtITrUcx3REq45LskT3', '0', '7vuhrOZQxA5vCOL1Nkw', '154563949619500002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('wOTIJNIezykimTpazW2', 'kPLbeydkgiYW6NIkCt0', null, 'i5qLZgg10LH5Och6mZo', '0', '1yATnQq0lqJI5UvHiZA', '155168804566300001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('wpeEQxhJirnzoslVsxM', '3tFw1boS5L9vXoJCr6Z', null, 'WHKujMuxTp67TYMu80o', '0', 'ti2S70c11piGDmryGEq', '154563949591300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('wPGrDjfAqOYA6IiGO3e', '2jSs6cnzu4mzY9C13vF', null, 'bJ9sgpEHjmdZEsbMwIM', '2', 'bJ9sgpEHjmdZEsbMwIM', '155142339618700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('wPmODJxLEai98FiiVNS', 'kPLbeydkgiYW6NIkCt0', null, 'qFSn8P14pNLldr9j5QS', '2', 'qFSn8P14pNLldr9j5QS', '155168804493000005', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('wPo8qa6yXqfOpz2FRSw', '2jSs6cnzu4mzY9C13vF', null, 'hdMXKLI1XqTUYUrFniv', '0', '3EhqWBGmEEkub8qvOuy', '155142339855800002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('WPQQGQAbDpyJ7hxDe2g', 'WB81MbCBolNg6XmE35M', null, '11e6-5530-8ee397f4-8350-a3b9b8447d61', '0', '11e6-5a16-6359abb6-9288-a3f5193ed8de', '155141104924300000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('WPVJzZkvpIjyajoqNS8', '2jSs6cnzu4mzY9C13vF', null, '8DmOHAVRvs3BblbhJoa', '1', 'b2wnjqSK0hVEGNix31k', '155142339654600000', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('wPvTJ1u8eS75EqBIQu4', '2ytUeoxBqghwofmBALl', null, 'vCWvTbPligxwrkrwAv8', '0', 'oyuPcAc1VAmt4JtNf7A', '154461619136700001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('WQL0lP9IGEMkYBEunDO', '2ytUeoxBqghwofmBALl', null, 'nTlBd4a4Vt8mtiTX41J', '0', '9e1x2YMVEFvz8YJOOtI', '154461618939800001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('wqTVkxnp3xhxwJWsItQ', 'WB81MbCBolNg6XmE35M', null, '11e6-5633-c861eb4e-91c5-cd8abd28b1f9', '1', '11e6-5635-57ce6c4f-91c5-cd8abd28b1f9', '155141105220700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('wRA4533FDZFzERXhZ3I', '2jSs6cnzu4mzY9C13vF', null, 'k3Ro7OsGafHyoiDAeLl', '2', 'k3Ro7OsGafHyoiDAeLl', '155142339628000003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('wrdB0vy61ZtKlqut2hV', 'kPLbeydkgiYW6NIkCt0', null, '9ppSV2PIKNhHCOwufvI', '0', 'KXsfuFCITnsqT6hE3Je', '155168804636500000', 'HdPeBqYwJyFyjHkhZu3', '导出', '16', '1');
INSERT INTO `t_permission` VALUES ('WRdC5jbpHCLUxZl3lPv', '2jSs6cnzu4mzY9C13vF', null, 'U1TygLjjsSxDfEoGwhc', '1', '6hT0k732Mz5j3yugFP1', '155142339643600002', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('ws6Y95xliE9t0wqgIdY', 'kPLbeydkgiYW6NIkCt0', null, '2F75ZJJXk8564FkCLYA', '1', '2F75ZJJXk8564FkCLYA', '155168804552300002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Wsf4HKhc59SpKlne9BG', '3tFw1boS5L9vXoJCr6Z', null, 'QuvtJrkqhNSzp7mN4R3', '2', 'QuvtJrkqhNSzp7mN4R3', '154563949439800001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('WsjSqq1O6GdZuRB9Sei', '3tFw1boS5L9vXoJCr6Z', null, 'RXwhTRAzZSqsUpQc1NF', '1', 'RXwhTRAzZSqsUpQc1NF', '154563949585100001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WsqQK6ay9pkmw61Qi9c', '0Q0LkJpfR1ejtO8rD3p', null, 'a0NeCmvVh6L5QDzhezl', '2', 'a0NeCmvVh6L5QDzhezl', '155168789311100001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('WSx5oNNDDBO5xoxSmxc', '0Q0LkJpfR1ejtO8rD3p', null, 'zQbdwHlWMKfQxZOw4TN', '1', 'HsJKTUvE0PpgpJ9EXSw', '155168789476400004', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('WSZpf3QImKbaezd8hgJ', 'kPLbeydkgiYW6NIkCt0', null, 'eLFjqFngRQrIkbsdeBd', '1', 'eLFjqFngRQrIkbsdeBd', '155168804656800002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('wTHVM7ZP8ObxvMYCAvV', '2ytUeoxBqghwofmBALl', null, '7NlGpNC1MAEM6EuX2X0', '1', 'tqjrAb05aPRsD2JYTh1', '154461619149200000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('WU1tDxYBb5P61SVFs72', '3tFw1boS5L9vXoJCr6Z', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'VC7xzHBeSzCmdpBwT9w', '154563949503800000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('WuIMiHAKuAHQlWv4ktS', '2jSs6cnzu4mzY9C13vF', null, 'qX2GQGpdWwGnelcjHZP', '2', 'qX2GQGpdWwGnelcjHZP', '155142339546900001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('WUiMxRtgLKcHyldEALN', 'jkpTHKg7DpuXQrppVxx', null, 'EaVrfjS89IZqE63BWPa', '0', '9YwViaujJTr161CesBX', '155142353119000002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('wv9hC0rjOKiVzU4depK', 'jkpTHKg7DpuXQrppVxx', null, 'a7jp1Dm53YjlAwDWuws', '1', 'UFBBbyiSeV5fpFq1Apn', '155142353081500001', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('WvDDAcpK9DhtM3WNMe4', 'jkpTHKg7DpuXQrppVxx', null, '2F75ZJJXk8564FkCLYA', '1', 'elMcFSK0gGbaGWSt2pH', '155142353028500005', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('WVHCL1rZgnUH9lIFn7f', '2ytUeoxBqghwofmBALl', null, 'eLFjqFngRQrIkbsdeBd', '1', 'eLFjqFngRQrIkbsdeBd', '154461619124200000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WVK4g5rCvUDFlYXJvUS', 'kPLbeydkgiYW6NIkCt0', null, 'eLFjqFngRQrIkbsdeBd', '1', 'laHgljUkGTSlRpd6Sbl', '155168804659900000', 'HdPeBqYwJyFyjHkhZu3', '网页打印', '14', '1');
INSERT INTO `t_permission` VALUES ('wvQnMcZjU90toSO46fl', '3tFw1boS5L9vXoJCr6Z', null, '8DmOHAVRvs3BblbhJoa', '1', '8DmOHAVRvs3BblbhJoa', '154563949488200003', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WvVfiBMiig7xR7EFhZI', '0Q0LkJpfR1ejtO8rD3p', null, 'L5GM913NGCFMkNWSZ8A', '0', 'l8GWni0miSZsKhx4FGB', '155168789395300001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('wW2MGw7zk7EPcen1pur', 'WB81MbCBolNg6XmE35M', null, '11e6-53a7-e48bf523-81f5-679a826556ce', '1', '11e6-53ae-02c6b2af-81f5-679a826556ce', '155141105186400003', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('wW3MoUgiYi1vsKFtb0a', '0Q0LkJpfR1ejtO8rD3p', null, '6bUPlXeVH92MIv7Nmdw', '1', '6bUPlXeVH92MIv7Nmdw', '155168789354700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('wWlHXXND51uNiP2NJmR', 'WB81MbCBolNg6XmE35M', null, '11e6-5610-9d97dea7-91c5-cd8abd28b1f9', '2', '11e6-5610-9d97dea7-91c5-cd8abd28b1f9', '155141104777700000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('WwU4pW9J52gLUvpQsFs', '2jSs6cnzu4mzY9C13vF', null, 'iY5ypHvJGJTn6j3J2nC', '1', 'FoxNtE4HNjqsnne055E', '155142339815200000', 'HdPeBqYwJyFyjHkhZu3', '取消', '10', '1');
INSERT INTO `t_permission` VALUES ('wy539Yx0xIgjOvnxd4l', '2ytUeoxBqghwofmBALl', null, 'gniImP2ug7E82S1WO0L', '1', 'Ap8uKeL5gioGlQk65eL', '154461618891300000', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('WyIuiEDHoqzqZE8PAXG', '3tFw1boS5L9vXoJCr6Z', null, 'hdMXKLI1XqTUYUrFniv', '0', '3EhqWBGmEEkub8qvOuy', '154563949589800002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('wYMmTeiCjM3kYtx5wbu', '2ytUeoxBqghwofmBALl', null, 'hxDvvyWbvIEUUrBHW0R', '1', 'hxDvvyWbvIEUUrBHW0R', '154461619053800005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('WYToFVwcPBXvyVUs1bS', '0Q0LkJpfR1ejtO8rD3p', null, 'J9uhQYSQWhPor4IvkOE', '0', 'KgFs9krHT2ZyBayTPo8', '155168789340700001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Wz48T9I1hlRU7SURbwS', '2ytUeoxBqghwofmBALl', null, 'a7jp1Dm53YjlAwDWuws', '1', 'UFBBbyiSeV5fpFq1Apn', '154461619030400004', 'HdPeBqYwJyFyjHkhZu3', '保存', '11', '1');
INSERT INTO `t_permission` VALUES ('WZK1h5wMMOKznctKLhq', 'WB81MbCBolNg6XmE35M', null, '11e6-53f9-3bed7a60-81f5-679a826556ce', '1', '11e6-5467-b69ce96f-9671-379f935a9949', '155141104983600000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('WzKVc9k7Oyez56hyWnT', '2ytUeoxBqghwofmBALl', null, '1fhgTUPecMY0ajlTkKZ', '0', 'UiotHIXmy0M1EdhhF8k', '154461619024200002', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('x0IWbIbAfXwFBoBa4lF', '0Q0LkJpfR1ejtO8rD3p', null, 'KQSVH3r5JbmIAoPEf1R', '0', 'FpCOlrvb0mWq2jRlD44', '155168789403100001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('X16g3OQBwqgXEegdREp', '0Q0LkJpfR1ejtO8rD3p', null, 'SYAJTXtkhpXsGIAqioF', '2', 'SYAJTXtkhpXsGIAqioF', '155168789311100004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('X1AeCkvzvPKwWIQh6AB', '0Q0LkJpfR1ejtO8rD3p', null, 'ypFGviMvQl4iVE8dOS0', '2', 'ypFGviMvQl4iVE8dOS0', '155168789290800000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('X1NeGiv1VxKn1IwhgQh', '0Q0LkJpfR1ejtO8rD3p', null, 'x2qgUpE8u9jmGEWbbQm', '1', 'x2qgUpE8u9jmGEWbbQm', '155168789442100000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('X1O7nyMjBrf7289d3da', '2jSs6cnzu4mzY9C13vF', null, '9HKopmq2QmqQZjBp0ve', '1', '9HKopmq2QmqQZjBp0ve', '155142339848000000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('x25Dmer0sURwIEJbDjx', '2ytUeoxBqghwofmBALl', null, 'gUlSUpqhlS2ym2ijZAg', '1', '6vfobfgmvGLQuOe0b3s', '154461618944500000', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('x2ohanXXPlHP11t6oiR', '2ytUeoxBqghwofmBALl', null, '06Me4ssjoGBiKz0gMK2', '0', '8Hhv2rO3YipCX5JageH', '154461619132000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('X3107GaeV5zun6gUVyK', 'kPLbeydkgiYW6NIkCt0', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'CjR2ngF0kCrKnCpD0rj', '155168804557000005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('X3eXrn7MrLYEUBVxILW', '0Q0LkJpfR1ejtO8rD3p', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'csKjmVnToONLiXzljYG', '155168789465500000', 'HdPeBqYwJyFyjHkhZu3', '执行后提醒', '3', '1');
INSERT INTO `t_permission` VALUES ('X3QzRQcQxSdqdycH7bR', 'kPLbeydkgiYW6NIkCt0', null, 'IE1QRBOyhDRgkxFpUU2', '1', 'Wy8unQKVYBEnHvEqVyA', '155168804539800002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('x4cuDxFCuVlwUp603fp', 'jkpTHKg7DpuXQrppVxx', null, 'NrNKdrnUm1ENsWwSkYl', '0', 'cHPexySH1L6Pf3IyNTH', '155142353103400002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('X50g9H8ifQagYbcwXMa', '2ytUeoxBqghwofmBALl', null, 'rfmGjP7LXiQfxy15izp', '1', 'N1gohv56wfzjxXMkYXQ', '154461619072600002', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('X55azvCrbTBoPmRloLC', '2jSs6cnzu4mzY9C13vF', null, 'PbQMu46yyehblOGohri', '2', 'PbQMu46yyehblOGohri', '155142339576600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('x9NHlrjJNWKhYTdJeLg', 'jkpTHKg7DpuXQrppVxx', null, 'XAQy4mQfPb9hnyOISK1', '0', 'xGuspPXmrUTCn5KTdAR', '155142353075300005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('X9S2IHrjLUJvRYBs0hl', '2ytUeoxBqghwofmBALl', null, 'vDsnTykdPOblfwEF4mR', '1', 'vDsnTykdPOblfwEF4mR', '154461619117900002', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('XAbNM1lzLrNtb6N1U6F', 'kPLbeydkgiYW6NIkCt0', null, 'Iw7PqAhVcFRVUHnbbwR', '1', 'eTfrqgZ8RLViOksDpqV', '155168804611600004', 'HdPeBqYwJyFyjHkhZu3', '保存并复制', '21', '1');
INSERT INTO `t_permission` VALUES ('xAbXf82xiZyfshBtDsP', '2jSs6cnzu4mzY9C13vF', null, 'w7IsSOtXFvo61cP8sKr', '1', 'u8cNJQfZVXWFj5hlBow', '155142339776200005', 'HdPeBqYwJyFyjHkhZu3', '保存并启动流程', '4', '1');
INSERT INTO `t_permission` VALUES ('XAeKVpvxtkk5RAq3aKY', '2jSs6cnzu4mzY9C13vF', null, 'Dp0d6MuuCtsiTwqL6qe', '2', 'Dp0d6MuuCtsiTwqL6qe', '155142339624900004', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('XB0DQ9L0Np9WzHKBhP8', 'kPLbeydkgiYW6NIkCt0', null, 'ir2OPEdZvttSUxAzfmD', '1', 'C6hePhUj7uuuUyJJSuq', '155168804541400002', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('XbdqqpFAoM0bIrVBChz', '3tFw1boS5L9vXoJCr6Z', null, 'JmxxVKFmtiAV278992Z', '2', 'JmxxVKFmtiAV278992Z', '154563949458500000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('xbMANgwoUNzBwsnlZdt', 'kPLbeydkgiYW6NIkCt0', null, '4VkP5W8VPlERMiThvSD', '0', 'SOe9OaDTLOE1domxYKV', '155168804596000005', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('XBnu5leny8luFSui64I', 'jkpTHKg7DpuXQrppVxx', null, 'Ksfgm24NkZrnPIXYgay', '2', 'Ksfgm24NkZrnPIXYgay', '155142352981700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('xBTeT7RBRWGb5vcyMqD', 'kPLbeydkgiYW6NIkCt0', null, 'T9IoQKXjHSvxRXYM3L8', '1', 'T9IoQKXjHSvxRXYM3L8', '155168804563200004', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('xCDKxUTNgIiuizxSBLY', '2jSs6cnzu4mzY9C13vF', null, '4v5tmazbZwdNkJDYso5', '1', '4v5tmazbZwdNkJDYso5', '155142339891700000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('xCespZJ7NKAj1WqjlSO', '3tFw1boS5L9vXoJCr6Z', null, '1fhgTUPecMY0ajlTkKZ', '0', 'UiotHIXmy0M1EdhhF8k', '154563949535100001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('xCKUuiXScE6v4uuwBKI', 'kPLbeydkgiYW6NIkCt0', null, 'Gc5icb2c0g8ARf7Jath', '0', 'Gc5icb2c0g8ARf7Jath', null, 'HdPeBqYwJyFyjHkhZu3', '费用报销单', '1032', '2');
INSERT INTO `t_permission` VALUES ('xcvYx5ycOornhB5Tt0s', 'WB81MbCBolNg6XmE35M', null, '11de-a1ce-12978c3f-a188-7710f5ef0f5e', '1', '11e8-5efb-bca93d0b-b84a-39be571b3c90', '155141104816700002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '保存启动', '4', '1');
INSERT INTO `t_permission` VALUES ('xcx2AwZ0yoWUf2Kidne', 'jkpTHKg7DpuXQrppVxx', null, 'Gc5icb2c0g8ARf7Jath', '0', 'nHElJbBXVkEhXwGIaUL', '155142353008200001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('XcXXXQu4iG1wvMtF0pd', 'kPLbeydkgiYW6NIkCt0', null, 'TyQHY3EqKQuNGfJ6teV', '2', 'TyQHY3EqKQuNGfJ6teV', '155168804522700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Xd162iHahlXInpOUkmK', 'WB81MbCBolNg6XmE35M', null, '11e6-5619-983e27c7-91c5-cd8abd28b1f9', '2', '11e6-5619-983e27c7-91c5-cd8abd28b1f9', '155141104765200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('XdmIbhyT1LMLmDurMBo', 'WB81MbCBolNg6XmE35M', null, '11e6-5e0c-5b614a82-ae15-3d6b584ebd70', '1', '11e6-5e0c-7c81ab68-ae15-3d6b584ebd70', '155141104999200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('Xdx0XtjP0yNatkX26UE', 'jkpTHKg7DpuXQrppVxx', null, 'EKD2uh12ht0Vptz9xN5', '0', 'ThJH0AWU99Z8F5DDmUo', '155142353067500005', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('XDYrVI11W3NEJukiYqD', '2ytUeoxBqghwofmBALl', null, 'w7IsSOtXFvo61cP8sKr', '1', 'u8cNJQfZVXWFj5hlBow', '154461619035100003', 'HdPeBqYwJyFyjHkhZu3', '保存并启动流程', '4', '1');
INSERT INTO `t_permission` VALUES ('XeduDdLT0XsqN1PsHeH', 'kPLbeydkgiYW6NIkCt0', null, 'wjPLVvwWYR2a9BOi0st', '0', '6798mFOtT3LLK9CYgPv', '155168804608500002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('XeK5bE8vZZZcrVYMAov', '0Q0LkJpfR1ejtO8rD3p', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'Y0AtqRPANYqitR5XI0Q', '155168789365700003', 'HdPeBqYwJyFyjHkhZu3', '流程处理', '5', '1');
INSERT INTO `t_permission` VALUES ('xEuXnLpHwnd9QIF9Xra', '3tFw1boS5L9vXoJCr6Z', null, '3sSURwczE2wMjgOqqOo', '0', 'rNGiDIRMmVUcl95QN9f', '154563949536600000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('Xf17rpWRwKFjRVCbUBv', 'jkpTHKg7DpuXQrppVxx', null, 'HsCxJxVzSoMOXQotkMK', '1', 'HsCxJxVzSoMOXQotkMK', '155142353145500000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('xf394iQpwxgvf7DBYig', '2jSs6cnzu4mzY9C13vF', null, 'w7IsSOtXFvo61cP8sKr', '1', '0km7YEvweo5SVWbQlku', '155142339777800002', 'HdPeBqYwJyFyjHkhZu3', '归档', '45', '1');
INSERT INTO `t_permission` VALUES ('xFCRD3z5PZDXywDmGn9', '0Q0LkJpfR1ejtO8rD3p', null, 'CjR2ngF0kCrKnCpD0rj', '1', 'VC7xzHBeSzCmdpBwT9w', '155168789365700001', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('XFeLZynXkadDoNGKA7h', 'kPLbeydkgiYW6NIkCt0', null, 'GkSLWRbQwybXSXPOABb', '2', 'GkSLWRbQwybXSXPOABb', '155168804483700001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('XfghjeqwxgZLH6Dc6OK', '0Q0LkJpfR1ejtO8rD3p', null, '3K4lxgBhBLAbzJrfYaB', '1', 'j2jPRJ7cK9BqO2p9iP9', '155168789487300005', 'HdPeBqYwJyFyjHkhZu3', '保存', '34', '1');
INSERT INTO `t_permission` VALUES ('xFJxgoVqa6vncTmTZVu', '2ytUeoxBqghwofmBALl', null, 'eLFjqFngRQrIkbsdeBd', '1', 'SX3rVQxkpU96Pko5JDm', '154461619128800001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('xFLd5PYCLHah2sDmtU0', 'kPLbeydkgiYW6NIkCt0', null, '1fhgTUPecMY0ajlTkKZ', '0', 'UiotHIXmy0M1EdhhF8k', '155168804585100006', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('XFNptxeye6BJ8QoYyZx', '2ytUeoxBqghwofmBALl', null, 'enhnCZbrTQ1mZpn18o5', '0', 'iqufoXl2qzIWDFkt1Vi', '154461618960100000', 'HdPeBqYwJyFyjHkhZu3', '获取第一个查询条件的值', '1', '1');
INSERT INTO `t_permission` VALUES ('XFz5I1D6CKGjqysi0F1', '3tFw1boS5L9vXoJCr6Z', null, 'g2XzgmKDL1T8UB79GZh', '0', '1uOt5KaDxl3ZK3OT1Mw', '154563949588200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('Xfzzd5b6ZFUGRMvh2CI', 'kPLbeydkgiYW6NIkCt0', null, 'XpNoNSLR8vialNcJDXq', '0', 'DDOwg7IIyIziyaozQTN', '155168804610000002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('XG5KsvwU8CCs2Jcq1SX', '3tFw1boS5L9vXoJCr6Z', null, 'qqHbF4LC1qdUg1ak29k', '1', 'qqHbF4LC1qdUg1ak29k', '154563949492900005', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('xgehSDECgTXuf6N0AwE', 'jkpTHKg7DpuXQrppVxx', null, 'c8qqHIRjZCxEMPx5YoO', '1', 'c8qqHIRjZCxEMPx5YoO', '155142353098700001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('Xh0kYtIkNHyIV6pRok6', '3tFw1boS5L9vXoJCr6Z', null, '0bmAo7ylNxrpnAXlqnb', '2', '0bmAo7ylNxrpnAXlqnb', '154563949474100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('XHkxvrjjyB8gY0XtAcZ', 'jkpTHKg7DpuXQrppVxx', null, 'U945OMsdX9fvzRjE7xG', '0', 'NNovnd63EkWs6jGCQgq', '155142353064400001', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('xHQ2y7BHDM7smMLmN1X', '3tFw1boS5L9vXoJCr6Z', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'XYV76K6iat8P2bzFJIm', '154563949605400003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('XhWNXtnkha5dah5PDYn', '3tFw1boS5L9vXoJCr6Z', null, 'GLnzLxRphPAJ2Z2L7fM', '2', 'GLnzLxRphPAJ2Z2L7fM', '154563949471000000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('xi4acu26YyBUMe4aCmK', '0Q0LkJpfR1ejtO8rD3p', null, 'J9uhQYSQWhPor4IvkOE', '0', 'Q2aiiWtqBNqF33UGXUy', '155168789340700000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('xiju4l9xSy0iiQhztfy', '2jSs6cnzu4mzY9C13vF', null, 'p44Eh34DScjVKkZi1ok', '2', 'p44Eh34DScjVKkZi1ok', '155142339567200001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('xiKzDEWawM6azV5sUYS', 'WB81MbCBolNg6XmE35M', null, '11e6-5611-5dcb0e5a-91c5-cd8abd28b1f9', '2', '11e6-5611-5dcb0e5a-91c5-cd8abd28b1f9', '155141104776100004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('xjg7mrFvK6osTlcXnJ7', 'jkpTHKg7DpuXQrppVxx', null, '6esIc2fTAI9nAOoOZcp', '1', 'ngq5KVxqa5NRDO7OoHy', '155142353030000002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('XJjRnlB54fdRCLzZRB1', 'WB81MbCBolNg6XmE35M', null, '11e6-539f-0c568130-81f5-679a826556ce', '1', '11e6-53a1-e4d149c2-81f5-679a826556ce', '155141104790200000', '11de-f053-df18d577-aeb6-19a7865cfdb6', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('XjnkSFkTC1TsfhuTMz3', '0Q0LkJpfR1ejtO8rD3p', null, 'JSvvw8VjIpL8ESGH8YA', '2', 'JSvvw8VjIpL8ESGH8YA', '155168789301700002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('xKBJ20SUbGfXTaxpxQp', '0Q0LkJpfR1ejtO8rD3p', null, '7u0fRbpHrxopCyfgADs', '1', 'QdJEZOBLT4lXyJm0dJq', '155168789367200001', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('xkC6pOicFNssEfsOYg6', '2jSs6cnzu4mzY9C13vF', null, 'bBnaCBfJDrnkLoxw552', '2', 'bBnaCBfJDrnkLoxw552', '155142339570300000', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Xl3Mmy0auTJ2oopPS6T', '0Q0LkJpfR1ejtO8rD3p', null, 'MtITrUcx3REq45LskT3', '0', '1GnA7ouj5X9SbchE8C5', '155168789479500001', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('xL8G1beML0xnpjhIecn', '2ytUeoxBqghwofmBALl', null, 'X6TIettbQ8xAoG8Gl8e', '0', 'ISM9kGtKs3Gkvrg1HSD', '154461618999200006', 'HdPeBqYwJyFyjHkhZu3', 'excel导出', '27', '1');
INSERT INTO `t_permission` VALUES ('XLutrKZBLAZVF5tLbre', '2jSs6cnzu4mzY9C13vF', null, 'cbE2ixGwPBn9lHk5RmS', '2', 'cbE2ixGwPBn9lHk5RmS', '155142339551600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('xlVTIwiyG2AwMPb92gl', '2ytUeoxBqghwofmBALl', null, 'nTlBd4a4Vt8mtiTX41J', '0', 'E3J8OfymoQtKHIuFNMK', '154461618938200007', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('XlzgiRhwqpmAgWihc1f', 'WB81MbCBolNg6XmE35M', null, '11e6-5616-60d6608e-91c5-cd8abd28b1f9', '2', '11e6-5616-60d6608e-91c5-cd8abd28b1f9', '155141104762100002', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('xm9oETPNkB0PiL7toK4', 'kPLbeydkgiYW6NIkCt0', null, 'lAUkIpgQSIZqQyttrB4', '1', 'g6HusIB9Lr81fIHCCp5', '155168804561700003', 'HdPeBqYwJyFyjHkhZu3', '提交', '5', '1');
INSERT INTO `t_permission` VALUES ('XNDODKLmfWp5mMmfXpl', '3tFw1boS5L9vXoJCr6Z', null, 's8qcshfzszuUknfhZNl', '2', 's8qcshfzszuUknfhZNl', '154563949419500001', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('Xnhzm9kIghZj9vcu1Mv', '2ytUeoxBqghwofmBALl', null, 'w7IsSOtXFvo61cP8sKr', '1', '0km7YEvweo5SVWbQlku', '154461619036700001', 'HdPeBqYwJyFyjHkhZu3', '归档', '45', '1');
INSERT INTO `t_permission` VALUES ('XNj5g0dmFuXFk7aB3fl', '2ytUeoxBqghwofmBALl', null, '4oavihvP4J8cXDsWDIP', '0', 'FRLJFxdshvQAeKmHSfM', '154461619067900008', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('xnw7H1F9UihGRkpLOmk', '0Q0LkJpfR1ejtO8rD3p', null, 'EUJuOrIly3lBnwGTF7Q', '1', 'EUJuOrIly3lBnwGTF7Q', '155168789437400001', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('XNZkgVYrcEiwIBqJ3S3', 'WB81MbCBolNg6XmE35M', null, '11e6-561b-d1fb1eb6-91c5-cd8abd28b1f9', '2', '11e6-561b-d1fb1eb6-91c5-cd8abd28b1f9', '155141104757400004', '11de-f053-df18d577-aeb6-19a7865cfdb6', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('XO2lhPW8bXqeAAvAA1K', '3tFw1boS5L9vXoJCr6Z', null, 'kebFCC8mkGX3V1QEriK', '0', '2eoDuuIu6c2LNFTXHBl', '154563949632000000', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('xO3CcpBjsc3dUj4KXgI', 'jkpTHKg7DpuXQrppVxx', null, 'XtaVH2y40O9zvIVALWj', '1', 'cJircppYbKZxUtuClYU', '155142353012900000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('xo4puIMwLjrV3l7gCxG', '0Q0LkJpfR1ejtO8rD3p', null, 'tXSz1JBmnuwUf1VB2vL', '2', 'tXSz1JBmnuwUf1VB2vL', '155168789298600003', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('xoudPcmgbMQWdUbHYXN', '2jSs6cnzu4mzY9C13vF', null, 'f9GQrsfu9GKGRqKKPgi', '1', 'bVmZ9H8tKyNWZ4omc1a', '155142339871400003', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('XPcU08UIohybEfjwAoq', 'kPLbeydkgiYW6NIkCt0', null, 'HqyysOeWOVkmU29sLla', '0', 'NYq2pB1fAXTxVgfupIY', '155168804585100000', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('XpsU9yLi0HtxW7ks6se', '3tFw1boS5L9vXoJCr6Z', null, 'PD8d7bOI6YO4W3IL4YI', '0', 'JAAon6tsqZ7pmxzP2fn', '154563949599100003', 'HdPeBqYwJyFyjHkhZu3', '批量签章', '29', '1');
INSERT INTO `t_permission` VALUES ('xpvEcj8YAQe2ZTQOEYw', '2ytUeoxBqghwofmBALl', null, 'ZM7F9MjjscP8bADF7cH', '1', 's0ipQa9ktbRum255G0J', '154461618952300002', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('XQ976aLjXflYlcJnD1l', '2jSs6cnzu4mzY9C13vF', null, 'Mto2Exz54Tcvkyw1NCx', '1', 'Mto2Exz54Tcvkyw1NCx', '155142339685800000', 'HdPeBqYwJyFyjHkhZu3', null, '1032', '1');
INSERT INTO `t_permission` VALUES ('xQblC1XwXESmxqT4cCK', '3tFw1boS5L9vXoJCr6Z', null, 'KWyhjGMdOzdszl2VD2Q', '1', 'AiibIdUU3zQiGsrKDXn', '154563949628800000', 'HdPeBqYwJyFyjHkhZu3', '返回', '10', '1');
INSERT INTO `t_permission` VALUES ('XqCqaZEc754zP6eQIYl', 'kPLbeydkgiYW6NIkCt0', null, 'MtITrUcx3REq45LskT3', '0', '7vuhrOZQxA5vCOL1Nkw', '155168804663100003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('xqUsgIDkieMUvWFC7IT', 'kPLbeydkgiYW6NIkCt0', null, 'o4zdmPoNHMg5JK6m6dx', '0', 'Nmhce5xixb5FBPVv5dc', '155168804644300001', 'HdPeBqYwJyFyjHkhZu3', '此按钮不可见', '3', '1');
INSERT INTO `t_permission` VALUES ('xQvTWudwon9TgyvHX3o', 'jkpTHKg7DpuXQrppVxx', null, 'L5GM913NGCFMkNWSZ8A', '0', 'l8GWni0miSZsKhx4FGB', '155142353072200002', 'HdPeBqYwJyFyjHkhZu3', '删除', '3', '1');
INSERT INTO `t_permission` VALUES ('XQznSECNQAAkG0idRXM', '3tFw1boS5L9vXoJCr6Z', null, '7am5R9EPlSCV3gz3SZG', '2', '7am5R9EPlSCV3gz3SZG', '154563949424100002', 'HdPeBqYwJyFyjHkhZu3', '', '1002', '1');
INSERT INTO `t_permission` VALUES ('XRcgzIxmfR1Y9QuHDO9', '3tFw1boS5L9vXoJCr6Z', null, '98kmnnrWwGKmgyiIkUF', '0', 'mlTio0aN6W90Aant0Mk', '154563949517900003', 'HdPeBqYwJyFyjHkhZu3', '新建', '2', '1');
INSERT INTO `t_permission` VALUES ('XRdnFocisEbzjQ8ZoLi', '2jSs6cnzu4mzY9C13vF', null, 'L5GM913NGCFMkNWSZ8A', '0', 'QicxhLOE9YigegI