CREATE DATABASE IF NOT EXISTS message DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_general_ci; 
use message; 
/*
Navicat MySQL Data Transfer

Source Server         : 192.168.88.123
Source Server Version : 50728
Source Host           : 192.168.88.123:3307
Source Database       : message

Target Server Type    : MYSQL
Target Server Version : 50728
File Encoding         : 65001

Date: 2021-02-02 10:33:02
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for mc_comment
-- ----------------------------
DROP TABLE IF EXISTS `mc_comment`;
CREATE TABLE `mc_comment` (
  `ID` varchar(200) NOT NULL,
  `CONTENT` longtext,
  `ATTACHMENT` longtext,
  `CREATE_TIME` datetime DEFAULT NULL,
  `SENDER` varchar(200) DEFAULT NULL,
  `SENDER_ID` varchar(200) DEFAULT NULL,
  `MESSAGE_ID` varchar(200) DEFAULT NULL,
  `COMMENT_ID` varchar(200) DEFAULT NULL,
  `TO_USER` varchar(200) DEFAULT NULL,
  `TO_USER_ID` varchar(200) DEFAULT NULL,
  `MODULE` varchar(200) DEFAULT NULL,
  `DOMAIN_ID` varchar(200) DEFAULT NULL,
  `TO_CONTENT` varchar(200) DEFAULT NULL,
  `IS_READ` bit(1) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_ID` (`ID`) USING BTREE,
  KEY `index_MESSAGE_ID` (`MESSAGE_ID`) USING BTREE,
  KEY `index_TO_USER_ID` (`TO_USER_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mc_comment
-- ----------------------------

-- ----------------------------
-- Table structure for mc_message
-- ----------------------------
DROP TABLE IF EXISTS `mc_message`;
CREATE TABLE `mc_message` (
  `ID` varchar(200) NOT NULL,
  `TITLE` varchar(200) DEFAULT NULL,
  `CONTENT` longtext,
  `ATTACHMENT` longtext,
  `CREATE_TIME` datetime DEFAULT NULL,
  `SENDER` varchar(200) DEFAULT NULL,
  `SENDER_DEPT` varchar(200) DEFAULT NULL,
  `SENDER_ID` varchar(200) DEFAULT NULL,
  `SENDER_DEPT_ID` varchar(200) DEFAULT NULL,
  `SCOPE` int(11) DEFAULT NULL,
  `RECEIVER_ID` longtext,
  `RECEIVER_DEPT_ID` longtext,
  `COMMENT_COUNT` int(11) DEFAULT NULL,
  `TYPE` int(11) DEFAULT NULL,
  `MODULE` varchar(200) DEFAULT NULL,
  `DOMAIN_ID` varchar(200) DEFAULT NULL,
  `IS_COMMENT` bit(1) DEFAULT NULL,
  `IS_STICKY` bit(1) DEFAULT NULL,
  `RECEIVER_INFO` longtext,
  PRIMARY KEY (`ID`),
  KEY `index_ID` (`ID`) USING BTREE,
  KEY `index_SENDER_ID` (`SENDER_ID`) USING BTREE,
  KEY `index_MODULE` (`MODULE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mc_message
-- ----------------------------

-- ----------------------------
-- Table structure for mc_notice
-- ----------------------------
DROP TABLE IF EXISTS `mc_notice`;
CREATE TABLE `mc_notice` (
  `ID` varchar(200) NOT NULL,
  `IS_READ` bit(1) DEFAULT NULL,
  `SUMMARY` longtext,
  `CONTENT` longtext,
  `TO_USER_ID` varchar(200) DEFAULT NULL,
  `CREATE_TIME` datetime DEFAULT NULL,
  `LINK_PARAMS` longtext,
  `MODULE` varchar(200) DEFAULT NULL,
  `DOMAIN_ID` varchar(200) DEFAULT NULL,
  `SUBJECT_TYPE` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_ID` (`ID`) USING BTREE,
  KEY `index_TO_USER_ID` (`TO_USER_ID`) USING BTREE,
  KEY `index_MODULE` (`MODULE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mc_notice
-- ----------------------------

-- ----------------------------
-- Table structure for mc_notification
-- ----------------------------
DROP TABLE IF EXISTS `mc_notification`;
CREATE TABLE `mc_notification` (
  `ID` varchar(200) NOT NULL,
  `SENDER` varchar(200) DEFAULT NULL,
  `SENDER_ID` varchar(200) DEFAULT NULL,
  `RECEIVER_ID` varchar(200) DEFAULT NULL,
  `MESSAGE_ID` varchar(200) DEFAULT NULL,
  `MESSAGE_TYPE` varchar(200) DEFAULT NULL,
  `MODULE` varchar(200) DEFAULT NULL,
  `LINK_PARAMS` longtext,
  `DOMAIN_ID` varchar(200) DEFAULT NULL,
  `SUMMARY` longtext,
  `CREATE_TIME` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_ID` (`ID`) USING BTREE,
  KEY `index_MESSAGE_ID` (`MESSAGE_ID`) USING BTREE,
  KEY `index_SENDER_ID` (`SENDER_ID`) USING BTREE,
  KEY `index_RECEIVER_ID` (`RECEIVER_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mc_notification
-- ----------------------------
