CREATE DATABASE IF NOT EXISTS kms DEFAULT CHARACTER SET utf8mb4 DEFAULT COLLATE utf8mb4_general_ci; 
use kms; 
/*
Navicat MySQL Data Transfer

Source Server         : 192.168.88.191_3307
Source Server Version : 50728
Source Host           : 192.168.88.191:3307
Source Database       : kms

Target Server Type    : MYSQL
Target Server Version : 50728
File Encoding         : 65001

Date: 2021-03-24 20:23:21
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for kms_authorization
-- ----------------------------
DROP TABLE IF EXISTS `kms_authorization`;
CREATE TABLE `kms_authorization` (
  `TARGET_NAME` longtext,
  `TIME_LIMIT_TYPE` varchar(200) DEFAULT NULL,
  `CREATOR` varchar(200) DEFAULT NULL,
  `RESOURCE_ID` varchar(200) DEFAULT NULL,
  `TARGET_ID` longtext,
  `END_DATE` datetime DEFAULT NULL,
  `CREATOR_ID` varchar(200) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `OPERATIONS` varchar(200) DEFAULT NULL,
  `SCOPE` int(11) DEFAULT NULL,
  `ID` varchar(200) NOT NULL,
  `START_DATE` datetime DEFAULT NULL,
  `CREATE_DATE` datetime DEFAULT NULL,
  `RESOURCE_TYPE` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_RESOURCE_ID` (`RESOURCE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_authorization
-- ----------------------------

-- ----------------------------
-- Table structure for kms_category
-- ----------------------------
DROP TABLE IF EXISTS `kms_category`;
CREATE TABLE `kms_category` (
  `ID` varchar(200) NOT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `PARENTID` varchar(200) DEFAULT NULL,
  `DOMAINID` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_category
-- ----------------------------

-- ----------------------------
-- Table structure for kms_disk
-- ----------------------------
DROP TABLE IF EXISTS `kms_disk`;
CREATE TABLE `kms_disk` (
  `ID` varchar(200) NOT NULL,
  `TYPE` int(11) DEFAULT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `DOMAIN_ID` varchar(200) DEFAULT NULL,
  `OWNER_ID` varchar(200) DEFAULT NULL,
  `ORDER_NO` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_ID` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_disk
-- ----------------------------

-- ----------------------------
-- Table structure for kms_edit_file
-- ----------------------------
DROP TABLE IF EXISTS `kms_edit_file`;
CREATE TABLE `kms_edit_file` (
  `EDITOR_ID` varchar(200) DEFAULT NULL,
  `EDIT_TIME` datetime DEFAULT NULL,
  `FILE_ID` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_edit_file
-- ----------------------------

-- ----------------------------
-- Table structure for kms_file
-- ----------------------------
DROP TABLE IF EXISTS `kms_file`;
CREATE TABLE `kms_file` (
  `ID` varchar(200) NOT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `DISK_ID` varchar(200) DEFAULT NULL,
  `FOLDER_ID` varchar(200) DEFAULT NULL,
  `PATH` varchar(4000) DEFAULT NULL,
  `CREATOR` varchar(200) DEFAULT NULL,
  `CREATOR_ID` varchar(200) DEFAULT NULL,
  `TYPE` varchar(200) DEFAULT NULL,
  `CREATE_DATE` datetime DEFAULT NULL,
  `LAST_MODIFY_DATE` datetime DEFAULT NULL,
  `ORIGIN_TYPE` int(11) DEFAULT NULL,
  `ORIGIN_ID` varchar(200) DEFAULT NULL,
  `URL` varchar(4000) DEFAULT NULL,
  `DIMENSION` int(11) DEFAULT NULL,
  `COLLECTS` int(11) DEFAULT NULL,
  `SHARES` int(11) DEFAULT NULL,
  `VIEWS` int(11) DEFAULT NULL,
  `DOWNLOADS` int(11) DEFAULT NULL,
  `LAST_DOWNLOAD_DATE` datetime DEFAULT NULL,
  `LAST_COLLECT_DATE` datetime DEFAULT NULL,
  `LAST_SHARE_DATE` datetime DEFAULT NULL,
  `LAST_VIEW_DATE` datetime DEFAULT NULL,
  `LAST_EDIT_DATE` datetime DEFAULT NULL,
  `GOOD` int(11) DEFAULT NULL,
  `BAD` int(11) DEFAULT NULL,
  `CATEGORYS` varchar(4000) DEFAULT NULL,
  `CATEGORYS_JSON` longtext,
  PRIMARY KEY (`ID`),
  KEY `index_ID` (`ID`),
  KEY `index_DISK_ID` (`DISK_ID`),
  KEY `index_FOLDER_ID` (`FOLDER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_file
-- ----------------------------

-- ----------------------------
-- Table structure for kms_file_category_set
-- ----------------------------
DROP TABLE IF EXISTS `kms_file_category_set`;
CREATE TABLE `kms_file_category_set` (
  `ID` varchar(200) NOT NULL,
  `FILE_ID` varchar(200) DEFAULT NULL,
  `CATEGORY_ID` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_file_category_set
-- ----------------------------

-- ----------------------------
-- Table structure for kms_file_history
-- ----------------------------
DROP TABLE IF EXISTS `kms_file_history`;
CREATE TABLE `kms_file_history` (
  `ID` varchar(200) NOT NULL,
  `USER_ID` varchar(200) DEFAULT NULL,
  `USER_NAME` varchar(200) DEFAULT NULL,
  `TITLE` varchar(200) DEFAULT NULL,
  `SOURCE_ID` varchar(200) DEFAULT NULL,
  `PATH` varchar(200) DEFAULT NULL,
  `MD5` varchar(200) DEFAULT NULL,
  `TMP` bit(1) DEFAULT NULL,
  `CREATE_TIME` datetime DEFAULT NULL,
  `VERSION_NO` int(11) DEFAULT NULL,
  `FILE_SIZE` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_file_history
-- ----------------------------

-- ----------------------------
-- Table structure for kms_file_outsideshare_set
-- ----------------------------
DROP TABLE IF EXISTS `kms_file_outsideshare_set`;
CREATE TABLE `kms_file_outsideshare_set` (
  `ID` varchar(200) NOT NULL,
  `FILE_ID` varchar(200) DEFAULT NULL,
  `SHARE_TIMEOUT` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_file_outsideshare_set
-- ----------------------------

-- ----------------------------
-- Table structure for kms_folder
-- ----------------------------
DROP TABLE IF EXISTS `kms_folder`;
CREATE TABLE `kms_folder` (
  `ID` varchar(200) NOT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `DISK_ID` varchar(200) DEFAULT NULL,
  `FOLDER_ID` varchar(200) DEFAULT NULL,
  `PATH` varchar(4000) DEFAULT NULL,
  `CREATOR` varchar(200) DEFAULT NULL,
  `CREATOR_ID` varchar(200) DEFAULT NULL,
  `TYPE` int(11) DEFAULT NULL,
  `CREATE_DATE` datetime DEFAULT NULL,
  `LAST_MODIFY_DATE` datetime DEFAULT NULL,
  `ORDER_NO` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `index_ID` (`ID`),
  KEY `index_DISK_ID` (`DISK_ID`),
  KEY `index_FOLDER_ID` (`FOLDER_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_folder
-- ----------------------------

-- ----------------------------
-- Table structure for kms_iflytek_task
-- ----------------------------
DROP TABLE IF EXISTS `kms_iflytek_task`;
CREATE TABLE `kms_iflytek_task` (
  `ID` varchar(200) DEFAULT NULL,
  `FILE_NAME` varchar(200) DEFAULT NULL,
  `CREATE_DATE` datetime DEFAULT NULL,
  `TEXT` longtext,
  `FILE_LENGTH` int(11) DEFAULT NULL,
  `USER_ID` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_iflytek_task
-- ----------------------------

-- ----------------------------
-- Table structure for kms_keyword
-- ----------------------------
DROP TABLE IF EXISTS `kms_keyword`;
CREATE TABLE `kms_keyword` (
  `ID` varchar(200) NOT NULL,
  `CONTENT` varchar(200) DEFAULT NULL,
  `CREATOR_ID` varchar(200) DEFAULT NULL,
  `CREATOR` varchar(200) DEFAULT NULL,
  `CREATE_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_keyword
-- ----------------------------

-- ----------------------------
-- Table structure for kms_logs
-- ----------------------------
DROP TABLE IF EXISTS `kms_logs`;
CREATE TABLE `kms_logs` (
  `DEPT_NAME` varchar(200) DEFAULT NULL,
  `RESOURCE_ID` varchar(200) DEFAULT NULL,
  `CREATOR` varchar(200) DEFAULT NULL,
  `CREATOR_ID` varchar(200) DEFAULT NULL,
  `DEPT_ID` varchar(200) DEFAULT NULL,
  `RESOURCE_NAME` varchar(200) DEFAULT NULL,
  `OPERATION_TYPE` int(11) DEFAULT NULL,
  `ID` varchar(200) DEFAULT NULL,
  `RESOURCE_TYPE` int(11) DEFAULT NULL,
  `CREATE_DATE` datetime DEFAULT NULL,
  `REGION` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_logs
-- ----------------------------

-- ----------------------------
-- Table structure for kms_map
-- ----------------------------
DROP TABLE IF EXISTS `kms_map`;
CREATE TABLE `kms_map` (
  `ID` varchar(200) NOT NULL,
  `TITLE` varchar(200) DEFAULT NULL,
  `SERIAL_NUMBER` varchar(200) DEFAULT NULL,
  `CONTENT` longtext,
  `CREATOR` varchar(200) DEFAULT NULL,
  `CREATOR_ID` varchar(200) DEFAULT NULL,
  `CREATE_DATE` datetime DEFAULT NULL,
  `LAST_MODIFY_DATE` datetime DEFAULT NULL,
  `REALM_ID` varchar(200) DEFAULT NULL,
  `STATUS` varchar(200) DEFAULT NULL,
  `FLOW_HISTORYS` longtext,
  `APPROVERS` varchar(4000) DEFAULT NULL,
  `APPROVER_IDS` varchar(4000) DEFAULT NULL,
  `APPROVER_HISTORYS` longtext,
  `LAST_OPERATION` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_map
-- ----------------------------

-- ----------------------------
-- Table structure for kms_member
-- ----------------------------
DROP TABLE IF EXISTS `kms_member`;
CREATE TABLE `kms_member` (
  `ID` varchar(200) NOT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `TEAM_ID` varchar(200) DEFAULT NULL,
  `USER_ID` varchar(200) DEFAULT NULL,
  `TYPE` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_member
-- ----------------------------

-- ----------------------------
-- Table structure for kms_operation
-- ----------------------------
DROP TABLE IF EXISTS `kms_operation`;
CREATE TABLE `kms_operation` (
  `CODE` int(11) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `ID` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_operation
-- ----------------------------
INSERT INTO `kms_operation` VALUES ('2', '资源预览', '2');
INSERT INTO `kms_operation` VALUES ('1', '资源下载', '1');
INSERT INTO `kms_operation` VALUES ('3', '资源编辑', '3');
INSERT INTO `kms_operation` VALUES ('4', '资源分享', '4');
INSERT INTO `kms_operation` VALUES ('8', '资源收藏', '8');

-- ----------------------------
-- Table structure for kms_permission_app_form
-- ----------------------------
DROP TABLE IF EXISTS `kms_permission_app_form`;
CREATE TABLE `kms_permission_app_form` (
  `ID` varchar(200) NOT NULL,
  `USER_ID` varchar(200) DEFAULT NULL,
  `USER_NAME` varchar(200) DEFAULT NULL,
  `RESOURCE_ID` varchar(200) DEFAULT NULL,
  `RESOURCE_NAME` varchar(200) DEFAULT NULL,
  `RESOURCE_TYPE` int(11) DEFAULT NULL,
  `FILE_OBJECT_TYPE` int(11) DEFAULT NULL,
  `RESOURCE_OWNER_ID` varchar(200) DEFAULT NULL,
  `DOWNLOAD` bit(1) DEFAULT NULL,
  `PREVIEW` bit(1) DEFAULT NULL,
  `EDIT` bit(1) DEFAULT NULL,
  `APPROVERS` varchar(4000) DEFAULT NULL,
  `APPROVER_IDS` varchar(4000) DEFAULT NULL,
  `REASON` longtext,
  `REJECT_REASON` longtext,
  `CREATE_DATE` datetime DEFAULT NULL,
  `STATUS` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_permission_app_form
-- ----------------------------

-- ----------------------------
-- Table structure for kms_preview_file
-- ----------------------------
DROP TABLE IF EXISTS `kms_preview_file`;
CREATE TABLE `kms_preview_file` (
  `PREVIEW_ID` varchar(200) DEFAULT NULL,
  `PREVIEW_TIME` datetime DEFAULT NULL,
  `FILE_ID` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_preview_file
-- ----------------------------

-- ----------------------------
-- Table structure for kms_privilege
-- ----------------------------
DROP TABLE IF EXISTS `kms_privilege`;
CREATE TABLE `kms_privilege` (
  `END_DATE` datetime DEFAULT NULL,
  `ID` varchar(200) NOT NULL,
  `AUTH_ID` varchar(200) DEFAULT NULL,
  `START_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_privilege
-- ----------------------------

-- ----------------------------
-- Table structure for kms_privilege_dept_set
-- ----------------------------
DROP TABLE IF EXISTS `kms_privilege_dept_set`;
CREATE TABLE `kms_privilege_dept_set` (
  `PRIVILEGE_ID` varchar(200) DEFAULT NULL,
  `DEPT_ID` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_privilege_dept_set
-- ----------------------------

-- ----------------------------
-- Table structure for kms_privilege_operation_set
-- ----------------------------
DROP TABLE IF EXISTS `kms_privilege_operation_set`;
CREATE TABLE `kms_privilege_operation_set` (
  `PRIVILEGE_ID` varchar(200) DEFAULT NULL,
  `OPERATION_ID` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_privilege_operation_set
-- ----------------------------

-- ----------------------------
-- Table structure for kms_privilege_resource_set
-- ----------------------------
DROP TABLE IF EXISTS `kms_privilege_resource_set`;
CREATE TABLE `kms_privilege_resource_set` (
  `RESOURCE_ID` varchar(200) DEFAULT NULL,
  `PRIVILEGE_ID` varchar(200) DEFAULT NULL,
  `RESOURCE_TYPE` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_privilege_resource_set
-- ----------------------------

-- ----------------------------
-- Table structure for kms_privilege_user_set
-- ----------------------------
DROP TABLE IF EXISTS `kms_privilege_user_set`;
CREATE TABLE `kms_privilege_user_set` (
  `PRIVILEGE_ID` varchar(200) DEFAULT NULL,
  `USER_ID` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_privilege_user_set
-- ----------------------------

-- ----------------------------
-- Table structure for kms_realm
-- ----------------------------
DROP TABLE IF EXISTS `kms_realm`;
CREATE TABLE `kms_realm` (
  `ID` varchar(200) NOT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `ORDER_NO` int(11) DEFAULT NULL,
  `DOMAIN_ID` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_realm
-- ----------------------------

-- ----------------------------
-- Table structure for kms_role
-- ----------------------------
DROP TABLE IF EXISTS `kms_role`;
CREATE TABLE `kms_role` (
  `ID` varchar(200) NOT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `GRADE` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_role
-- ----------------------------
INSERT INTO `kms_role` VALUES ('0001', '员工', '0');
INSERT INTO `kms_role` VALUES ('0010', '部门知识管理员', '10');
INSERT INTO `kms_role` VALUES ('0020', '专委会知识管理员', '20');
INSERT INTO `kms_role` VALUES ('0100', '企业知识管理员', '100');

-- ----------------------------
-- Table structure for kms_share_record
-- ----------------------------
DROP TABLE IF EXISTS `kms_share_record`;
CREATE TABLE `kms_share_record` (
  `ID` varchar(200) DEFAULT NULL,
  `FILE_ID` varchar(200) DEFAULT NULL,
  `SHARE_AUTHOR_ID` varchar(200) DEFAULT NULL,
  `SHARE_RECEIVE_ID` varchar(200) DEFAULT NULL,
  `SHARE_RECEIVE_NAME` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_share_record
-- ----------------------------

-- ----------------------------
-- Table structure for kms_stage
-- ----------------------------
DROP TABLE IF EXISTS `kms_stage`;
CREATE TABLE `kms_stage` (
  `ID` varchar(200) NOT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `TEAM_ID` varchar(200) DEFAULT NULL,
  `FOLDER_ID` varchar(200) DEFAULT NULL,
  `ORDER_NO` int(11) DEFAULT NULL,
  `COMMENTS` longtext,
  `CREATE_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_stage
-- ----------------------------

-- ----------------------------
-- Table structure for kms_subscription
-- ----------------------------
DROP TABLE IF EXISTS `kms_subscription`;
CREATE TABLE `kms_subscription` (
  `ID` varchar(200) NOT NULL,
  `USER_ID` varchar(200) DEFAULT NULL,
  `CONTENT_ID` varchar(200) DEFAULT NULL,
  `CONTENT_TYPE` int(11) DEFAULT NULL,
  `CONTENT_NAME` varchar(200) DEFAULT NULL,
  `CREATE_DATE` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_subscription
-- ----------------------------

-- ----------------------------
-- Table structure for kms_subscription_notice
-- ----------------------------
DROP TABLE IF EXISTS `kms_subscription_notice`;
CREATE TABLE `kms_subscription_notice` (
  `ID` varchar(200) NOT NULL,
  `USER_ID` varchar(200) DEFAULT NULL,
  `RESOURCE_ID` varchar(200) DEFAULT NULL,
  `RESOURCE_NAME` varchar(200) DEFAULT NULL,
  `CONTENT_TYPE` int(11) DEFAULT NULL,
  `CONTENT_NAME` varchar(200) DEFAULT NULL,
  `CONTENT_ID` varchar(200) DEFAULT NULL,
  `CREATE_DATE` datetime DEFAULT NULL,
  `IS_READ` bit(1) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_subscription_notice
-- ----------------------------

-- ----------------------------
-- Table structure for kms_team
-- ----------------------------
DROP TABLE IF EXISTS `kms_team`;
CREATE TABLE `kms_team` (
  `ID` varchar(200) NOT NULL,
  `NAME` varchar(200) DEFAULT NULL,
  `SERIAL_NUMBER` varchar(200) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `CREATOR_ID` varchar(200) DEFAULT NULL,
  `CREATOR` varchar(200) DEFAULT NULL,
  `CREATE_DATE` datetime DEFAULT NULL,
  `DEPT_PERMISSION` varchar(200) DEFAULT NULL,
  `COMP_PERMISSION` varchar(200) DEFAULT NULL,
  `DISK_ID` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_team
-- ----------------------------

-- ----------------------------
-- Table structure for kms_user_role_set
-- ----------------------------
DROP TABLE IF EXISTS `kms_user_role_set`;
CREATE TABLE `kms_user_role_set` (
  `ID` varchar(200) NOT NULL,
  `USER_ID` varchar(200) DEFAULT NULL,
  `ROLE_ID` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kms_user_role_set
-- ----------------------------
