package com.bcxin.shared.rest.web.apis.controllers.commons;

import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.api.interfaces.tenants.requests.uploads.UploadBase64Request;
import com.bcxin.rest.web.commons.FileProcessor;
import com.bcxin.rest.web.commons.ControllerAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping("/common/resources")
public class UploadController extends ControllerAbstract {
    private final Logger logger = LoggerFactory.getLogger(UploadController.class);

    private final FileProcessor fileProcessor;

    public UploadController(FileProcessor fileProcessor) {
        this.fileProcessor = fileProcessor;
    }


    @PostMapping
    public ResponseEntity post(@RequestParam("file") MultipartFile file) {
        String url = this.fileProcessor.save(file);

        return this.ok(url);
    }

    @PostMapping("/base64")
    public ResponseEntity base64(@RequestBody UploadBase64Request request) {
        try {
            String url = this.fileProcessor.save(request.getBStream());

            return this.ok(url);

        } catch (Exception ex) {
            logger.error(String.format("9.BASE64-url: stream=%s", request.getBStream()), ex);

            throw ex;
        }
    }
}
