package com.bcxin.shared.rest.web.apis;

import com.bcxin.Infrastructures.InitConfig;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.backends.BackendRpfProvider;
import com.bcxin.api.interfaces.backends.QueueRpcProvider;
import com.bcxin.api.interfaces.backends.requests.LogRecorderRequest;
import com.bcxin.api.interfaces.commons.ConfigDictRpcProvider;
import com.bcxin.api.interfaces.commons.ConfigRpcProvider;
import com.bcxin.api.interfaces.commons.RegionRpcProvider;
import com.bcxin.api.interfaces.commons.SuperviseDepartmentRpcProvider;
import com.bcxin.api.interfaces.rbacs.RbacCategoryRpcProvider;
import com.bcxin.api.interfaces.rbacs.RbacResourceRpcProvider;
import com.bcxin.api.interfaces.rbacs.RbacRoleRpcProvider;
import com.bcxin.api.interfaces.rbacs.RbacUserRpcProvider;
import com.bcxin.api.interfaces.tenants.TenantXlcpRpcProvider;
import com.bcxin.rest.web.commons.WebLoggerProvider;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.context.request.WebRequest;

@EnableDubbo
@Configuration
@ComponentScan(basePackages = {
        "com.bcxin.api.interfaces.rbacs",
        "com.bcxin.api.interfaces.commons",
        "com.bcxin.rest.web.commons",
        "com.bcxin.api.interfaces.backends"})
@Import(InitConfig.class)
public class DubboConfig {
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final RbacUserRpcProvider rbacUserRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final RbacCategoryRpcProvider rbacCategoryRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final RbacResourceRpcProvider resourceRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final RbacRoleRpcProvider rbacRoleRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final RegionRpcProvider regionRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final ConfigDictRpcProvider configDictRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final BackendRpfProvider backendRpfProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final QueueRpcProvider queueRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final ConfigRpcProvider configRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final TenantXlcpRpcProvider tenantXlcpRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final SuperviseDepartmentRpcProvider superviseDepartmentRpcProvider;

    public DubboConfig(RbacUserRpcProvider rbacUserRpcProvider,
                       RbacCategoryRpcProvider rbacCategoryRpcProvider,
                       RbacResourceRpcProvider resourceRpcProvider,
                       RbacRoleRpcProvider rbacRoleRpcProvider,
                       RegionRpcProvider regionRpcProvider,
                       ConfigDictRpcProvider configDictRpcProvider,
                       TenantXlcpRpcProvider tenantXlcpRpcProvider,
                       BackendRpfProvider backendRpfProvider,
                       QueueRpcProvider queueRpcProvider,
                       ConfigRpcProvider configRpcProvider,
                       SuperviseDepartmentRpcProvider superviseDepartmentRpcProvider) {
        this.rbacUserRpcProvider = rbacUserRpcProvider;
        this.rbacCategoryRpcProvider = rbacCategoryRpcProvider;
        this.resourceRpcProvider = resourceRpcProvider;
        this.rbacRoleRpcProvider = rbacRoleRpcProvider;
        this.regionRpcProvider = regionRpcProvider;
        this.configDictRpcProvider = configDictRpcProvider;
        this.tenantXlcpRpcProvider = tenantXlcpRpcProvider;
        this.backendRpfProvider = backendRpfProvider;
        this.queueRpcProvider = queueRpcProvider;
        this.configRpcProvider = configRpcProvider;
        this.superviseDepartmentRpcProvider = superviseDepartmentRpcProvider;
    }

    @Bean
    public WebLoggerProvider webLoggerProvider(BackendRpfProvider backendRpfProvider) {
        return new WebLoggerProvider() {
            @Override
            public void error(String title, String detail, WebRequest request) {
                backendRpfProvider.dispatch(LogRecorderRequest.create(title, detail, request.toString()));
            }
        };
    }
}
