/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.v5.snapshots.dataexchanges;

import cn.hutool.core.util.IdcardUtil;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.ValueSnapshot;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.springframework.util.StringUtils;

public class UserValueSnapshot
extends ValueSnapshot {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    public static final String PICTURE_KEY = "PICTURE_KEY";
    private String id;
    private String name;
    public String loginName;
    private String password;
    private String telephone;
    private String email;
    private String certificateType;
    private String certificateNo;
    private String certificateStatus;
    private String faceImage;
    private String defaultDepartId;
    private String domainId;
    private String idCardFrontUrl;
    private String idCardReverseUrl;
    public boolean IsDimission;
    public String domainUser;
    public boolean liaisonOfficer;
    private String idNumber;
    private String idType;
    private int level;
    private boolean status;
    private Date birthdate;
    private Date entryDate;
    private Date leaveDate;
    private Map<String, Object> extendMap;
    private Collection<String> selectedDepartIds;
    private String jsonPicture;
    private int sex;
    private OccupationType occupationType;
    private int orgType;

    private UserValueSnapshot() {
    }

    public String getConnectedSelectedDepartIds() {
        return String.join((CharSequence)",", this.getSelectedDepartIds());
    }

    public static UserValueSnapshot create(String id, String name, String loginName, String password, String telephone, String email, String certificateType, String certificateNo, String certificateStatus, String faceImage, String defaultDepartId, String domainId, String idCardFrontUrl, String idCardReverseUrl, String idNumber, String idType, int level, Collection<String> selectedDepartIds, String resourcePrefix, Date entryDate, Date leaveDate, OccupationType occupationType, EmploymentStatus employmentStatus, TrueFalseStatus domainAdmin, Map<String, Object> extendMap) {
        UserValueSnapshot userValueSnapshot = new UserValueSnapshot();
        userValueSnapshot.setId(id);
        userValueSnapshot.setName(name);
        userValueSnapshot.setTelephone(telephone);
        userValueSnapshot.setEmail(email);
        userValueSnapshot.setCertificateType(certificateType);
        userValueSnapshot.setCertificateNo(certificateNo);
        userValueSnapshot.setCertificateStatus(certificateStatus);
        userValueSnapshot.setOccupationType(occupationType);
        if (idCardFrontUrl != null && !idCardFrontUrl.startsWith("http:")) {
            userValueSnapshot.setIdCardFrontUrl(String.format("%s/%s", resourcePrefix, idCardFrontUrl));
        }
        if (faceImage != null && !faceImage.startsWith("http:")) {
            userValueSnapshot.setFaceImage(String.format("%s/%s", resourcePrefix, faceImage));
        }
        userValueSnapshot.setDefaultDepartId(defaultDepartId);
        userValueSnapshot.setLoginName(loginName);
        userValueSnapshot.setPassword(password);
        userValueSnapshot.setDomainId(domainId);
        if (idCardReverseUrl != null && !idCardReverseUrl.startsWith("http")) {
            userValueSnapshot.setIdCardReverseUrl(String.format("%s/%s", resourcePrefix, idCardReverseUrl));
        }
        userValueSnapshot.setIdNumber(idNumber);
        userValueSnapshot.setIdType(idType);
        userValueSnapshot.setLevel(level);
        userValueSnapshot.setSelectedDepartIds(selectedDepartIds);
        userValueSnapshot.setExtendMap(extendMap);
        if (entryDate == null) {
            entryDate = new Date();
        }
        userValueSnapshot.setEntryDate(entryDate);
        userValueSnapshot.setLeaveDate(leaveDate);
        if (StringUtils.hasLength((String)userValueSnapshot.getCertificateNo())) {
            try {
                userValueSnapshot.setSex(UserValueSnapshot.getSexByCardNo(userValueSnapshot.getCertificateNo()));
                userValueSnapshot.setBirthdate((Date)IdcardUtil.getBirthDate((String)userValueSnapshot.getCertificateNo()));
            }
            catch (Exception ex) {
                System.err.println("\u8f6c\u6362\u51fa\u9519:");
                ex.printStackTrace();
            }
        } else {
            userValueSnapshot.setSex(1);
        }
        if (employmentStatus == EmploymentStatus.OnJob) {
            userValueSnapshot.setLeaveDate(null);
        }
        if (domainAdmin == TrueFalseStatus.True) {
            userValueSnapshot.setOrgType(1);
        } else {
            userValueSnapshot.setOrgType(2);
        }
        String picture = null;
        if (userValueSnapshot.getExtendMap() != null && userValueSnapshot.getExtendMap().containsKey(PICTURE_KEY)) {
            picture = (String)userValueSnapshot.getExtendMap().get(PICTURE_KEY);
        }
        if (picture != null && !picture.startsWith("http")) {
            String pictureUrl = String.format("%s/%s", resourcePrefix, picture);
            userValueSnapshot.setJsonPicture(String.format("[{\"name\":\"%s\",\"path\":\"%s\" }]", picture, pictureUrl));
        }
        return userValueSnapshot;
    }

    private static Date getBirthdate(String certificateNo) {
        if (StringUtils.isEmpty((Object)certificateNo) || certificateNo.length() < 14) {
            return null;
        }
        try {
            String date = String.format("%s-%s-%s", certificateNo.substring(6, 10), certificateNo.substring(11, 12), certificateNo.substring(13, 14));
            return dateFormat.parse(date);
        }
        catch (Exception ex) {
            System.err.println("\u8f6c\u6362\u51fa\u9519:");
            ex.printStackTrace();
            return null;
        }
    }

    public int getCertificateStatusValue() {
        if (StringUtils.isEmpty((Object)this.certificateStatus)) {
            return 0;
        }
        switch (this.certificateStatus) {
            case "\u5df2\u8ba4\u8bc1": {
                return 1;
            }
            case "\u8ba4\u8bc1\u5931\u8d25": {
                return 3;
            }
            case "\u8ba4\u8bc1\u4e2d": {
                return 2;
            }
        }
        return 0;
    }

    public String getCertificateTypeValue() {
        if (StringUtils.isEmpty((Object)this.getCertificateType())) {
            return this.getCertificateType();
        }
        switch (this.getCertificateType()) {
            case "\u5c45\u6c11\u8eab\u4efd\u8bc1": 
            case "\u5c45\u6c11\u8eab\u4efd\u8bc1\uff08\u6237\u53e3\u7c3f\uff09": {
                return "1";
            }
            case "\u4e2d\u56fd\u4eba\u6c11\u89e3\u653e\u519b\u519b\u5b98\u8bc1": {
                return "2";
            }
            case "\u4e2d\u56fd\u4eba\u6c11\u6b66\u88c5\u8b66\u5bdf\u8b66\u5b98\u8bc1": {
                return "3";
            }
            case "\u9999\u6e2f\u7279\u533a\u62a4\u7167": 
            case "\u9999\u6e2f\u7279\u533a\u62a4\u7167/\u8eab\u4efd\u8bc1\u660e": {
                return "4";
            }
            case "\u6fb3\u95e8\u7279\u533a\u62a4\u7167": 
            case "\u6fb3\u95e8\u7279\u533a\u62a4\u7167/\u8eab\u4efd\u8bc1\u660e": {
                return "5";
            }
            case "\u53f0\u6e7e\u5c45\u6c11\u6765\u5f80\u5927\u9646\u901a\u884c\u8bc1": {
                return "6";
            }
            case "\u5916\u56fd\u4eba\u62a4\u7167": {
                return "8";
            }
        }
        return this.getCertificateType();
    }

    public String getBirthdateText() {
        if (this.getBirthdate() == null) {
            return "1990-01-01";
        }
        return dateFormat.format(this.getBirthdate());
    }

    public String getEntryDateText() {
        if (this.getEntryDate() == null) {
            return null;
        }
        return dateFormat.format(this.getEntryDate());
    }

    public String getLeaveDateText() {
        if (this.getLeaveDate() == null) {
            return null;
        }
        return dateFormat.format(this.getLeaveDate());
    }

    public String getJsonPicture() {
        String picture = null;
        if (this.getExtendMap() != null && this.getExtendMap().containsKey(PICTURE_KEY)) {
            picture = (String)this.getExtendMap().get(PICTURE_KEY);
        }
        String pictureUrl = String.format("", new Object[0]);
        return String.format("[{\"name\":\"%s\",\"path\":\"%s\" }]", picture, pictureUrl);
    }

    public static int getSexByCardNo(String cardNo) {
        if (cardNo == null) {
            return 1;
        }
        String sexStr = "0";
        if (cardNo.length() == 15) {
            sexStr = cardNo.substring(14, 15);
        } else if (cardNo.length() == 18) {
            sexStr = cardNo.substring(16, 17);
        }
        int sexNo = Integer.parseInt(sexStr);
        return sexNo % 2 == 0 ? 2 : 1;
    }

    @Override
    protected ValueSnapshot.PriorityValue getPriority() {
        return ValueSnapshot.PriorityValue.User;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCertificateType() {
        return this.certificateType;
    }

    public String getCertificateNo() {
        return this.certificateNo;
    }

    public String getCertificateStatus() {
        return this.certificateStatus;
    }

    public String getFaceImage() {
        return this.faceImage;
    }

    public String getDefaultDepartId() {
        return this.defaultDepartId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getIdCardFrontUrl() {
        return this.idCardFrontUrl;
    }

    public String getIdCardReverseUrl() {
        return this.idCardReverseUrl;
    }

    public boolean isIsDimission() {
        return this.IsDimission;
    }

    public String getDomainUser() {
        return this.domainUser;
    }

    public boolean isLiaisonOfficer() {
        return this.liaisonOfficer;
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    public String getIdType() {
        return this.idType;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isStatus() {
        return this.status;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public Date getEntryDate() {
        return this.entryDate;
    }

    public Date getLeaveDate() {
        return this.leaveDate;
    }

    public Map<String, Object> getExtendMap() {
        return this.extendMap;
    }

    public Collection<String> getSelectedDepartIds() {
        return this.selectedDepartIds;
    }

    public int getSex() {
        return this.sex;
    }

    public OccupationType getOccupationType() {
        return this.occupationType;
    }

    public int getOrgType() {
        return this.orgType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setCertificateType(String certificateType) {
        this.certificateType = certificateType;
    }

    public void setCertificateNo(String certificateNo) {
        this.certificateNo = certificateNo;
    }

    public void setCertificateStatus(String certificateStatus) {
        this.certificateStatus = certificateStatus;
    }

    public void setFaceImage(String faceImage) {
        this.faceImage = faceImage;
    }

    public void setDefaultDepartId(String defaultDepartId) {
        this.defaultDepartId = defaultDepartId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public void setIdCardFrontUrl(String idCardFrontUrl) {
        this.idCardFrontUrl = idCardFrontUrl;
    }

    public void setIdCardReverseUrl(String idCardReverseUrl) {
        this.idCardReverseUrl = idCardReverseUrl;
    }

    public void setIsDimission(boolean IsDimission) {
        this.IsDimission = IsDimission;
    }

    public void setDomainUser(String domainUser) {
        this.domainUser = domainUser;
    }

    public void setLiaisonOfficer(boolean liaisonOfficer) {
        this.liaisonOfficer = liaisonOfficer;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }

    public void setLeaveDate(Date leaveDate) {
        this.leaveDate = leaveDate;
    }

    public void setExtendMap(Map<String, Object> extendMap) {
        this.extendMap = extendMap;
    }

    public void setSelectedDepartIds(Collection<String> selectedDepartIds) {
        this.selectedDepartIds = selectedDepartIds;
    }

    public void setJsonPicture(String jsonPicture) {
        this.jsonPicture = jsonPicture;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    public void setOccupationType(OccupationType occupationType) {
        this.occupationType = occupationType;
    }

    public void setOrgType(int orgType) {
        this.orgType = orgType;
    }
}

