package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

@Getter
public class EmployeeReportResponse extends ResponseAbstract {

    private static final long serialVersionUID = 8556407864044628410L;

    //在职员工总数
    private final long total;
    //未核验
    private final long unCheckedCount;
    //已核验
    private final long checkedCount;
    //已提交
    private final long commitCount;
    //已签合同
    private final long contractCount;
    //未签合同
    private final long unContractCount;
    //保安员总数
    private final long secTotal;
    //保安员未核验
    private final long secUnCheckedCount;
    //保安员已核验
    private final long secCheckedCount;
    //保安员实名认证中
    private final long secUnAuthCount;
    //保安员实名认证通过
    private final long secAuthCount;
    //保安员实名认证失败
    private final long secAuthFailCount;
    //保安员已签合同
    private final long secContractCount;
    //保安员未签合同
    private final long secUnContractCount;


    public EmployeeReportResponse(long total,
                                  long unCheckedCount,
                                  long checkedCount,
                                  long commitCount,
                                  long contractCount,
                                  long secTotal,
                                  long secUnCheckedCount,
                                  long secCheckedCount,
                                  long secUnAuthCount,
                                  long secAuthCount,
                                  long secAuthFailCount,
                                  long secContractCount) {
        this.total = total;
        this.unCheckedCount = unCheckedCount;
        this.checkedCount = checkedCount;
        this.commitCount = commitCount;
        this.contractCount = contractCount;
        this.unContractCount = total - contractCount;
        this.secTotal = secTotal;
        this.secUnCheckedCount = secUnCheckedCount;
        this.secCheckedCount = secCheckedCount;
        this.secUnAuthCount = secUnAuthCount;
        this.secAuthCount = secAuthCount;
        this.secAuthFailCount = secAuthFailCount;
        this.secContractCount = secContractCount;
        this.secUnContractCount = secTotal - secContractCount;
    }

    public static EmployeeReportResponse create(long total,
                                                long unCheckedCount,
                                                long checkedCount,
                                                long commitCount,
                                                long contractCount,
                                                long secTotal,
                                                long secUnCheckedCount,
                                                long secCheckedCount,
                                                long secUnAuthCount,
                                                long secAuthCount,
                                                long secAuthFailCount,
                                                long secContractCount) {
        return new EmployeeReportResponse(total,
                unCheckedCount,
                checkedCount,
                commitCount,
                contractCount,
                secTotal,
                secUnCheckedCount,
                secCheckedCount,
                secUnAuthCount,
                secAuthCount,
                secAuthFailCount,
                secContractCount);
    }
}
