package com.bcxin.api.interfaces.tenants;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.tenants.criterias.DepartAdminCriteria;
import com.bcxin.api.interfaces.tenants.requests.BatchCreateDepartAdminRequest;
import com.bcxin.api.interfaces.tenants.requests.BatchDeleteDepartAdminRequest;
import com.bcxin.api.interfaces.tenants.requests.uploads.UpdateDepartAdminRequest;
import com.bcxin.api.interfaces.tenants.responses.DepartAdminGetResponse;
import com.bcxin.api.interfaces.tenants.responses.DepartResponse;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("departAdminRpcProvider")
public interface DepartAdminRpcProvider {
    void batchCreate(String organizationId, BatchCreateDepartAdminRequest request);

    void batchDelete(String organizationId, BatchDeleteDepartAdminRequest request);

    Pageable<DepartAdminGetResponse> search(DepartAdminCriteria criteria);

    List<DepartResponse> getByEmployeeId(String employeeId);

    void update(String organizationId, UpdateDepartAdminRequest request);

    String exportExcel(String organizationId,DepartAdminCriteria criteria);
}
