package com.bcxin.api.interfaces.identities.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotEmpty;

@ApiModel("赛演微信授权登入")
@Getter
public class ToCWechatCgiBinSignInRequest extends RequestAbstract {
    @ApiModelProperty("赛演微信那边获得到的code")
    @NotEmpty(message = "客户端参数异常, 微信认证jsCode不能为空")
    private final String jsCode;

    @ApiModelProperty("授权获取的昵称信息")
    private final String nicky;

    @Setter
    private String ipAddress;

    public ToCWechatCgiBinSignInRequest(String jsCode, String nicky) {
        this.jsCode = jsCode;
        this.nicky = nicky;
    }
}
