package com.bcxin.api.interfaces.commons;

import lombok.Getter;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

@Getter
public class DownloadImportedResponse implements Serializable {
    private final String path;
    private final String organizationId;
    private final int totalSuccess;
    private final int totalFailed;
    private final Collection<ImportedResponseItem> report;

    public DownloadImportedResponse(String path, String organizationId,
                                    int totalSuccess, int totalFailed,
                                    Collection<ImportedResponseItem> report) {
        this.path = path;
        this.organizationId = organizationId;
        this.totalSuccess = totalSuccess;
        this.totalFailed = totalFailed;
        this.report = report;
    }

    public static DownloadImportedResponse create(String path, String organizationId,
                                                  int totalSuccess, int totalFailed,
                                                  Collection<ImportedResponseItem> report) {
        return new DownloadImportedResponse(path, organizationId, totalSuccess, totalFailed, report);
    }
}
