/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.ContextAware;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TenantUserContext
implements ContextAware<UserModel> {
    public static final String CURRENT_TENANT_USER_INFO = "API.CURRENT_TENANT_USER_INFO";
    private static final ThreadLocal<UserModel> _userContextThread = new ThreadLocal();

    @Override
    public UserModel get() {
        return _userContextThread.get();
    }

    @Override
    public void init(UserModel data) {
        _userContextThread.set(data);
    }

    public void init(String token, String tenantUserId) {
        _userContextThread.set(UserModel.create(token, tenantUserId));
    }

    public void assignDetail(String name, String organId, String organName, String employeeId, MasterSlaveType masterSlaveType, boolean isDomainAdmin, boolean isDepartAdmin, String areaCode) {
        UserModel model = _userContextThread.get();
        if (model == null) {
            throw new ArgumentTenantException("\u5f53\u524d\u7528\u6237\u4e0a\u4e0b\u6587\u65e0\u6548, \u7cfb\u7edf\u672a\u80fd\u5728AuthFilter\u6267\u884c\u521d\u59cb\u5316");
        }
        model.assignDetail(name, organId, organName, employeeId, masterSlaveType, isDomainAdmin, isDepartAdmin, areaCode);
        _userContextThread.set(model);
    }

    public boolean isDomainAdmin() {
        UserModel model = _userContextThread.get();
        if (model == null) {
            return false;
        }
        return model.isMaster();
    }

    public String getAreaCode() {
        UserModel model = _userContextThread.get();
        if (model == null) {
            return "";
        }
        return StrUtil.isNotEmpty((CharSequence)model.getAreaCode()) ? model.getAreaCode() : "";
    }

    public void reset() {
        _userContextThread.set(null);
    }

    public static class UserModel
    implements Serializable {
        private final String token;
        private final String id;
        private String name;
        private String organId;
        private String organName;
        private String employeeId;
        private boolean isMaster;
        private String areaCode;
        private boolean isDepartAdmin = false;
        private final boolean leaveDatedLimited = true;
        private final Map<String, Object> attachments = new HashMap<String, Object>();

        public UserModel(String token, String id) {
            this.id = id;
            this.token = token;
        }

        public void assignDetail(String name, String organId, String organName, String employeeId, MasterSlaveType masterSlaveType, boolean isDomainAdmin, boolean isDepartAdmin, String areaCode) {
            this.name = name;
            this.organId = organId;
            this.organName = organName;
            this.employeeId = employeeId;
            this.isMaster = isDomainAdmin;
            this.isDepartAdmin = isDepartAdmin;
            this.areaCode = areaCode;
        }

        public static UserModel create(String token, String id) {
            return new UserModel(token, id);
        }

        public String getToken() {
            return this.token;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getOrganId() {
            return this.organId;
        }

        public String getOrganName() {
            return this.organName;
        }

        public String getEmployeeId() {
            return this.employeeId;
        }

        public boolean isMaster() {
            return this.isMaster;
        }

        public String getAreaCode() {
            return this.areaCode;
        }

        public boolean isDepartAdmin() {
            return this.isDepartAdmin;
        }

        public boolean isLeaveDatedLimited() {
            return this.leaveDatedLimited;
        }

        public Map<String, Object> getAttachments() {
            return this.attachments;
        }
    }
}

