/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.utils;

import cn.hutool.json.JSONUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static final Logger logger = LoggerFactory.getLogger(JwtUtil.class);
    public static final String JWT_USER_ID = "username";
    public static final String JWT_USER_INFO = "userInfo";
    public static final String SECRET_KEY = "teemlink_obpm";
    private static JWTVerifier verifier;
    public static final long EXPIRE_TIME = 864000000L;
    public static final long MOBILE_EXPIRE_TIME = 1468800000L;

    public static String getContentFromToken(String token) throws JWTVerificationException {
        DecodedJWT jwt = verifier.verify(token);
        String userId = jwt.getClaim(JWT_USER_ID).asString();
        return userId;
    }

    public static String getToken(String userId) {
        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + 864000000L);
            token = JWT.create().withIssuer("auth0").withClaim(JWT_USER_ID, userId).withExpiresAt(expiresAt).sign(Algorithm.HMAC256((String)SECRET_KEY));
        }
        catch (Exception e) {
            logger.error("getToken\u53d1\u751f\u5f02\u5e38:{}", (Object)userId, (Object)e);
        }
        return token;
    }

    public static String getMobileToken(String userId) {
        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + 1468800000L);
            token = JWT.create().withIssuer("auth0").withClaim(JWT_USER_ID, userId).withExpiresAt(expiresAt).sign(Algorithm.HMAC256((String)SECRET_KEY));
        }
        catch (Exception e) {
            logger.error("getMobileToken\u53d1\u751f\u5f02\u5e38:{}", (Object)userId, (Object)e);
        }
        return token;
    }

    public static String getToken(Object object) {
        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + 864000000L);
            token = JWT.create().withIssuer("auth0").withClaim(JWT_USER_INFO, JSONUtil.toJsonStr((Object)object)).withExpiresAt(expiresAt).sign(Algorithm.HMAC256((String)SECRET_KEY));
        }
        catch (Exception e) {
            logger.error("getToken\u53d1\u751f\u5f02\u5e38:{}", object, (Object)e);
        }
        return token;
    }

    static {
        try {
            verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET_KEY)).withIssuer("auth0").build();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

