/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.snapshots;

import java.sql.Timestamp;
import java.time.Instant;

public class OrgGisLocationSnapshot {
    private Double latitude;
    private Double longitude;
    private Timestamp time;
    private int count;
    private String address;

    public static OrgGisLocationSnapshot create(Double latitude, Double longitude, String address) {
        OrgGisLocationSnapshot snapshot = new OrgGisLocationSnapshot();
        snapshot.setLatitude(latitude);
        snapshot.setLongitude(longitude);
        snapshot.setAddress(address);
        snapshot.setCount(1);
        snapshot.setTime(Timestamp.from(Instant.now()));
        return snapshot;
    }

    public void update(Double latitude, Double longitude, String address) {
        if (latitude == null || longitude == null) {
            return;
        }
        if (latitude.doubleValue() != this.latitude.doubleValue() || longitude.doubleValue() != this.longitude.doubleValue()) {
            ++this.count;
            this.setLatitude(latitude);
            this.setLongitude(longitude);
            this.setAddress(address);
        }
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Timestamp getTime() {
        return this.time;
    }

    public int getCount() {
        return this.count;
    }

    public String getAddress() {
        return this.address;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setTime(Timestamp time) {
        this.time = time;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgGisLocationSnapshot)) {
            return false;
        }
        OrgGisLocationSnapshot other = (OrgGisLocationSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Timestamp this$time = this.getTime();
        Timestamp other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrgGisLocationSnapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Timestamp $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    public String toString() {
        return "OrgGisLocationSnapshot(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", time=" + this.getTime() + ", count=" + this.getCount() + ", address=" + this.getAddress() + ")";
    }
}

