package com.bcxin.identity.domains.events.handlers;

import com.bcxin.identity.domains.events.IdentityUserDomainEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * 内存中响应领域事件
 */
@Component
public class IdentityUserDomainEventHandler implements ApplicationListener<IdentityUserDomainEvent> {

    @Override
    public void onApplicationEvent(IdentityUserDomainEvent event) {
        event.getIdentityUser()
                .recordUserEvent(
                        event.getEventAction(),
                        event.getData(),
                        event.getPrincipal());
    }
}







