package com.bcxin.ferry.scheduling;

import com.bcxin.ferry.service.FerryTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * description：调用边界服务执行摆渡任务信息文件
 * author：linchunpeng
 * date：2024/3/8
 */
@Slf4j
@Component
public class SendFerryTaskFile {

    @Autowired
    private FerryTaskService ferryTaskService;

    @Scheduled(cron = "${scheduling-config.send-ferry-task-file.cron}")
    public void sendFerryTaskFile() {
        log.info("===================================定时调用边界服务执行摆渡任务信息文件===================================");
        ferryTaskService.sendFerryTaskFile();
        log.info("===================================调用边界服务执行摆渡任务信息文件务结束===================================");
    }

}
